{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2004 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.Windows platform;

{$ALIGN 1}
{$MINENUMSIZE 1}

{$IFDEF LINUX}
{$DEFINE LINUXCRITSECTION}
{$ENDIF}

interface

uses
  Types, System.Text, System.Runtime.InteropServices;

type
{ Translated from WINDEF.H }

  WCHAR = WideChar;

  DWORD = LongWord;
  BOOL = LongBool;

  UCHAR = Byte;
  SHORT = Smallint;
  UINT = LongWord;
  ULONG = Cardinal;

  LCID = DWORD;
  LANGID = Word;

  THandle = Integer;

const
  MAX_PATH = 260;


{ Translated from WINNT.H (only things needed for API calls) }

type
  LONGLONG = Int64;
  PSID = IntPtr; { Pointer }

  _LARGE_INTEGER = record
    case Integer of
    0: (
      LowPart: DWORD;
      HighPart: Longint);
    1: (
      QuadPart: LONGLONG);
  end;
  {$NODEFINE TLargeInteger}
  TLargeInteger = Int64;
  LARGE_INTEGER = _LARGE_INTEGER;

  ULARGE_INTEGER = record
    case Integer of
    0: (
      LowPart: DWORD;
      HighPart: DWORD);
    1: (
      QuadPart: LONGLONG);
  end;
  TULargeInteger = ULARGE_INTEGER;

  [StructLayout(LayoutKind.Sequential)]
  _LIST_ENTRY = record
    Flink: IntPtr; { PListEntry }
    Blink: IntPtr; { PListEntry }
  end;
  TListEntry = _LIST_ENTRY;
  LIST_ENTRY = _LIST_ENTRY;

const
  MINCHAR = $80;
  MAXCHAR = 127;
  MINSHORT = $8000;
  MAXSHORT = 32767;
  MINLONG = DWORD($80000000);
  MAXLONG = $7FFFFFFF;
  MAXBYTE = 255;
  MAXWORD = 65535;
  MAXDWORD = DWORD($FFFFFFFF);

(*
 *  Language IDs.
 *
 *  The following two combinations of primary language ID and
 *  sublanguage ID have special semantics:
 *
 *    Primary Language ID   Sublanguage ID      Result
 *    -------------------   ---------------     ------------------------
 *    LANG_NEUTRAL          SUBLANG_NEUTRAL     Language neutral
 *    LANG_NEUTRAL          SUBLANG_DEFAULT     User default language
 *    LANG_NEUTRAL          SUBLANG_SYS_DEFAULT System default language
 *)

const
{ Primary language IDs. }

  LANG_NEUTRAL                         = $00;

  LANG_AFRIKAANS                       = $36;
  LANG_ALBANIAN                        = $1c;
  LANG_ARABIC                          = $01;
  LANG_BASQUE                          = $2d;
  LANG_BELARUSIAN                      = $23;
  LANG_BULGARIAN                       = $02;
  LANG_CATALAN                         = $03;
  LANG_CHINESE                         = $04;
  LANG_CROATIAN                        = $1a;
  LANG_CZECH                           = $05;
  LANG_DANISH                          = $06;
  LANG_DUTCH                           = $13;
  LANG_ENGLISH                         = $09;
  LANG_ESTONIAN                        = $25;
  LANG_FAEROESE                        = $38;
  LANG_FARSI                           = $29;
  LANG_FINNISH                         = $0b;
  LANG_FRENCH                          = $0c;
  LANG_GERMAN                          = $07;
  LANG_GREEK                           = $08;
  LANG_HEBREW                          = $0d;
  LANG_HUNGARIAN                       = $0e;
  LANG_ICELANDIC                       = $0f;
  LANG_INDONESIAN                      = $21;
  LANG_ITALIAN                         = $10;
  LANG_JAPANESE                        = $11;
  LANG_KOREAN                          = $12;
  LANG_LATVIAN                         = $26;
  LANG_LITHUANIAN                      = $27;
  LANG_NORWEGIAN                       = $14;
  LANG_POLISH                          = $15;
  LANG_PORTUGUESE                      = $16;
  LANG_ROMANIAN                        = $18;
  LANG_RUSSIAN                         = $19;
  LANG_SERBIAN                         = $1a;
  LANG_SLOVAK                          = $1b;
  LANG_SLOVENIAN                       = $24;
  LANG_SPANISH                         = $0a;
  LANG_SWEDISH                         = $1d;
  LANG_THAI                            = $1e;
  LANG_TURKISH                         = $1f;
  LANG_UKRAINIAN                       = $22;
  LANG_VIETNAMESE                      = $2a;


{ Sublanguage IDs. }

  { The name immediately following SUBLANG_ dictates which primary
    language ID that sublanguage ID can be combined with to form a
    valid language ID. }

  SUBLANG_NEUTRAL                      = $00;    { language neutral }
  SUBLANG_DEFAULT                      = $01;    { user default }
  SUBLANG_SYS_DEFAULT                  = $02;    { system default }

  SUBLANG_ARABIC_SAUDI_ARABIA          = $01;    { Arabic (Saudi Arabia) }
  SUBLANG_ARABIC_IRAQ                  = $02;    { Arabic (Iraq) }
  SUBLANG_ARABIC_EGYPT                 = $03;    { Arabic (Egypt) }
  SUBLANG_ARABIC_LIBYA                 = $04;    { Arabic (Libya) }
  SUBLANG_ARABIC_ALGERIA               = $05;    { Arabic (Algeria) }
  SUBLANG_ARABIC_MOROCCO               = $06;    { Arabic (Morocco) }
  SUBLANG_ARABIC_TUNISIA               = $07;    { Arabic (Tunisia) }
  SUBLANG_ARABIC_OMAN                  = $08;    { Arabic (Oman) }
  SUBLANG_ARABIC_YEMEN                 = $09;    { Arabic (Yemen) }
  SUBLANG_ARABIC_SYRIA                 = $0a;    { Arabic (Syria) }
  SUBLANG_ARABIC_JORDAN                = $0b;    { Arabic (Jordan) }
  SUBLANG_ARABIC_LEBANON               = $0c;    { Arabic (Lebanon) }
  SUBLANG_ARABIC_KUWAIT                = $0d;    { Arabic (Kuwait) }
  SUBLANG_ARABIC_UAE                   = $0e;    { Arabic (U.A.E) }
  SUBLANG_ARABIC_BAHRAIN               = $0f;    { Arabic (Bahrain) }
  SUBLANG_ARABIC_QATAR                 = $10;    { Arabic (Qatar) }
  SUBLANG_CHINESE_TRADITIONAL          = $01;    { Chinese (Taiwan) }
  SUBLANG_CHINESE_SIMPLIFIED           = $02;    { Chinese (PR China) }
  SUBLANG_CHINESE_HONGKONG             = $03;    { Chinese (Hong Kong) }
  SUBLANG_CHINESE_SINGAPORE            = $04;    { Chinese (Singapore) }
  SUBLANG_DUTCH                        = $01;    { Dutch }
  SUBLANG_DUTCH_BELGIAN                = $02;    { Dutch (Belgian) }
  SUBLANG_ENGLISH_US                   = $01;    { English (USA) }
  SUBLANG_ENGLISH_UK                   = $02;    { English (UK) }
  SUBLANG_ENGLISH_AUS                  = $03;    { English (Australian) }
  SUBLANG_ENGLISH_CAN                  = $04;    { English (Canadian) }
  SUBLANG_ENGLISH_NZ                   = $05;    { English (New Zealand) }
  SUBLANG_ENGLISH_EIRE                 = $06;    { English (Irish) }
  SUBLANG_ENGLISH_SOUTH_AFRICA         = $07;    { English (South Africa) }
  SUBLANG_ENGLISH_JAMAICA              = $08;    { English (Jamaica) }
  SUBLANG_ENGLISH_CARIBBEAN            = $09;    { English (Caribbean) }
  SUBLANG_ENGLISH_BELIZE               = $0a;    { English (Belize) }
  SUBLANG_ENGLISH_TRINIDAD             = $0b;    { English (Trinidad) }
  SUBLANG_FRENCH                       = $01;    { French }
  SUBLANG_FRENCH_BELGIAN               = $02;    { French (Belgian) }
  SUBLANG_FRENCH_CANADIAN              = $03;    { French (Canadian) }
  SUBLANG_FRENCH_SWISS                 = $04;    { French (Swiss) }
  SUBLANG_FRENCH_LUXEMBOURG            = $05;    { French (Luxembourg) }
  SUBLANG_GERMAN                       = $01;    { German }
  SUBLANG_GERMAN_SWISS                 = $02;    { German (Swiss) }
  SUBLANG_GERMAN_AUSTRIAN              = $03;    { German (Austrian) }
  SUBLANG_GERMAN_LUXEMBOURG            = $04;    { German (Luxembourg) }
  SUBLANG_GERMAN_LIECHTENSTEIN         = $05;    { German (Liechtenstein) }
  SUBLANG_ITALIAN                      = $01;    { Italian }
  SUBLANG_ITALIAN_SWISS                = $02;    { Italian (Swiss) }
  SUBLANG_KOREAN                       = $01;    { Korean (Extended Wansung) }
  SUBLANG_KOREAN_JOHAB                 = $02;    { Korean (Johab) }
  SUBLANG_NORWEGIAN_BOKMAL             = $01;    { Norwegian (Bokmal) }
  SUBLANG_NORWEGIAN_NYNORSK            = $02;    { Norwegian (Nynorsk) }
  SUBLANG_PORTUGUESE                   = $02;    { Portuguese }
  SUBLANG_PORTUGUESE_BRAZILIAN         = $01;    { Portuguese (Brazilian) }
  SUBLANG_SERBIAN_LATIN                = $02;    { Serbian (Latin) }
  SUBLANG_SERBIAN_CYRILLIC             = $03;    { Serbian (Cyrillic) }
  SUBLANG_SPANISH                      = $01;    { Spanish (Castilian) }
  SUBLANG_SPANISH_MEXICAN              = $02;    { Spanish (Mexican) }
  SUBLANG_SPANISH_MODERN               = $03;    { Spanish (Modern) }
  SUBLANG_SPANISH_GUATEMALA            = $04;    { Spanish (Guatemala) }
  SUBLANG_SPANISH_COSTA_RICA           = $05;    { Spanish (Costa Rica) }
  SUBLANG_SPANISH_PANAMA               = $06;    { Spanish (Panama) }
  SUBLANG_SPANISH_DOMINICAN_REPUBLIC     = $07;  { Spanish (Dominican Republic) }
  SUBLANG_SPANISH_VENEZUELA            = $08;    { Spanish (Venezuela) }
  SUBLANG_SPANISH_COLOMBIA             = $09;    { Spanish (Colombia) }
  SUBLANG_SPANISH_PERU                 = $0a;    { Spanish (Peru) }
  SUBLANG_SPANISH_ARGENTINA            = $0b;    { Spanish (Argentina) }
  SUBLANG_SPANISH_ECUADOR              = $0c;    { Spanish (Ecuador) }
  SUBLANG_SPANISH_CHILE                = $0d;    { Spanish (Chile) }
  SUBLANG_SPANISH_URUGUAY              = $0e;    { Spanish (Uruguay) }
  SUBLANG_SPANISH_PARAGUAY             = $0f;    { Spanish (Paraguay) }
  SUBLANG_SPANISH_BOLIVIA              = $10;    { Spanish (Bolivia) }
  SUBLANG_SPANISH_EL_SALVADOR          = $11;    { Spanish (El Salvador) }
  SUBLANG_SPANISH_HONDURAS             = $12;    { Spanish (Honduras) }
  SUBLANG_SPANISH_NICARAGUA            = $13;    { Spanish (Nicaragua) }
  SUBLANG_SPANISH_PUERTO_RICO          = $14;    { Spanish (Puerto Rico) }
  SUBLANG_SWEDISH                      = $01;    { Swedish }
  SUBLANG_SWEDISH_FINLAND              = $02;    { Swedish (Finland) }


{ Sorting IDs. }

  SORT_DEFAULT                         = $0;     { sorting default }

  SORT_JAPANESE_XJIS                   = $0;     { Japanese XJIS order }
  SORT_JAPANESE_UNICODE                = $1;     { Japanese Unicode order }

  SORT_CHINESE_BIG5                    = $0;     { Chinese BIG5 order }
  SORT_CHINESE_PRCP                    = $0;     { PRC Chinese Phonetic order }
  SORT_CHINESE_UNICODE                 = $1;     { Chinese Unicode order }
  SORT_CHINESE_PRC                     = $2;     { PRC Chinese Stroke Count order }

  SORT_KOREAN_KSC                      = $0;     { Korean KSC order }
  SORT_KOREAN_UNICODE                  = $1;     { Korean Unicode order }

  SORT_GERMAN_PHONE_BOOK               = $1;     { German Phone Book order }


(*
 *  A language ID is a 16 bit value which is the combination of a
 *  primary language ID and a secondary language ID.  The bits are
 *  allocated as follows:
 *
 *       +-----------------------+-------------------------+
 *       |     Sublanguage ID    |   Primary Language ID   |
 *       +-----------------------+-------------------------+
 *        15                   10 9                       0   bit
 *
 *
 *
 *  A locale ID is a 32 bit value which is the combination of a
 *  language ID, a sort ID, and a reserved area.  The bits are
 *  allocated as follows:
 *
 *       +-------------+---------+-------------------------+
 *       |   Reserved  | Sort ID |      Language ID        |
 *       +-------------+---------+-------------------------+
 *        31         20 19     16 15                      0   bit
 *
 *)

{ Default System and User IDs for language and locale. }

  LANG_SYSTEM_DEFAULT   = (SUBLANG_SYS_DEFAULT shl 10) or LANG_NEUTRAL;
  LANG_USER_DEFAULT     = (SUBLANG_DEFAULT shl 10) or LANG_NEUTRAL;

  LOCALE_SYSTEM_DEFAULT = (SORT_DEFAULT shl 16) or LANG_SYSTEM_DEFAULT;
  LOCALE_USER_DEFAULT   = (SORT_DEFAULT shl 16) or LANG_USER_DEFAULT;


{line 724}
  STATUS_WAIT_0                   = $00000000;
  STATUS_ABANDONED_WAIT_0         = $00000080;
  STATUS_USER_APC                 = $000000C0;
  STATUS_TIMEOUT                  = $00000102;
  STATUS_PENDING                  = $00000103;
  STATUS_SEGMENT_NOTIFICATION     = $40000005;
  STATUS_GUARD_PAGE_VIOLATION     = DWORD($80000001);
  STATUS_DATATYPE_MISALIGNMENT    = DWORD($80000002);
  STATUS_BREAKPOINT               = DWORD($80000003);
  STATUS_SINGLE_STEP              = DWORD($80000004);
  STATUS_ACCESS_VIOLATION         = DWORD($C0000005);
  STATUS_IN_PAGE_ERROR            = DWORD($C0000006);
  STATUS_INVALID_HANDLE           = DWORD($C0000008);
  STATUS_NO_MEMORY                = DWORD($C0000017);
  STATUS_ILLEGAL_INSTRUCTION      = DWORD($C000001D);
  STATUS_NONCONTINUABLE_EXCEPTION = DWORD($C0000025);
  STATUS_INVALID_DISPOSITION      = DWORD($C0000026);
  STATUS_ARRAY_BOUNDS_EXCEEDED    = DWORD($C000008C);
  STATUS_FLOAT_DENORMAL_OPERAND   = DWORD($C000008D);
  STATUS_FLOAT_DIVIDE_BY_ZERO     = DWORD($C000008E);
  STATUS_FLOAT_INEXACT_RESULT     = DWORD($C000008F);
  STATUS_FLOAT_INVALID_OPERATION  = DWORD($C0000090);
  STATUS_FLOAT_OVERFLOW           = DWORD($C0000091);
  STATUS_FLOAT_STACK_CHECK        = DWORD($C0000092);
  STATUS_FLOAT_UNDERFLOW          = DWORD($C0000093);
  STATUS_INTEGER_DIVIDE_BY_ZERO   = DWORD($C0000094);
  STATUS_INTEGER_OVERFLOW         = DWORD($C0000095);
  STATUS_PRIVILEGED_INSTRUCTION   = DWORD($C0000096);
  STATUS_STACK_OVERFLOW           = DWORD($C00000FD);
  STATUS_CONTROL_C_EXIT           = DWORD($C000013A);

  MAXIMUM_WAIT_OBJECTS = 64;

{line 1280}
  SIZE_OF_80387_REGISTERS = 80;

  { The following flags control the contents of the CONTEXT structure. }

  CONTEXT_i386 = $10000;     { this assumes that i386 and }
  CONTEXT_i486 = $10000;     { i486 have identical context records }

  CONTEXT_CONTROL         = (CONTEXT_i386 or $00000001); { SS:SP, CS:IP, FLAGS, BP }
  CONTEXT_INTEGER         = (CONTEXT_i386 or $00000002); { AX, BX, CX, DX, SI, DI }
  CONTEXT_SEGMENTS        = (CONTEXT_i386 or $00000004); { DS, ES, FS, GS }
  CONTEXT_FLOATING_POINT  = (CONTEXT_i386 or $00000008); { 387 state }
  CONTEXT_DEBUG_REGISTERS = (CONTEXT_i386 or $00000010); { DB 0-3,6,7 }
  CONTEXT_FULL = (CONTEXT_CONTROL or CONTEXT_INTEGER or CONTEXT_SEGMENTS);

type
  [StructLayout(LayoutKind.Sequential)]
  _FLOATING_SAVE_AREA = record
    ControlWord: DWORD;
    StatusWord: DWORD;
    TagWord: DWORD;
    ErrorOffset: DWORD;
    ErrorSelector: DWORD;
    DataOffset: DWORD;
    DataSelector: DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=SIZE_OF_80387_REGISTERS)]
    RegisterArea: array[0..SIZE_OF_80387_REGISTERS - 1] of Byte;
    Cr0NpxState: DWORD;
  end;
  TFloatingSaveArea = _FLOATING_SAVE_AREA;
  FLOATING_SAVE_AREA = _FLOATING_SAVE_AREA;

{ This frame has a several purposes: 1) it is used as an argument to
  NtContinue, 2) is is used to constuct a call frame for APC delivery,
  and 3) it is used in the user level thread creation routines.
  The layout of the record conforms to a standard call frame. }

  [StructLayout(LayoutKind.Sequential)]
  _CONTEXT = record

  { The flags values within this flag control the contents of
    a CONTEXT record.

    If the context record is used as an input parameter, then
    for each portion of the context record controlled by a flag
    whose value is set, it is assumed that that portion of the
    context record contains valid context. If the context record
    is being used to modify a threads context, then only that
    portion of the threads context will be modified.

    If the context record is used as an IN OUT parameter to capture
    the context of a thread, then only those portions of the thread's
    context corresponding to set flags will be returned.

    The context record is never used as an OUT only parameter. }

    ContextFlags: DWORD;

  { This section is specified/returned if CONTEXT_DEBUG_REGISTERS is
    set in ContextFlags.  Note that CONTEXT_DEBUG_REGISTERS is NOT
    included in CONTEXT_FULL. }

    Dr0: DWORD;
    Dr1: DWORD;
    Dr2: DWORD;
    Dr3: DWORD;
    Dr6: DWORD;
    Dr7: DWORD;

  { This section is specified/returned if the
    ContextFlags word contians the flag CONTEXT_FLOATING_POINT. }

    FloatSave: TFloatingSaveArea;

  { This section is specified/returned if the
    ContextFlags word contians the flag CONTEXT_SEGMENTS. }

    SegGs: DWORD;
    SegFs: DWORD;
    SegEs: DWORD;
    SegDs: DWORD;

  { This section is specified/returned if the
    ContextFlags word contians the flag CONTEXT_INTEGER. }

    Edi: DWORD;
    Esi: DWORD;
    Ebx: DWORD;
    Edx: DWORD;
    Ecx: DWORD;
    Eax: DWORD;

  { This section is specified/returned if the
    ContextFlags word contians the flag CONTEXT_CONTROL. }

    Ebp: DWORD;
    Eip: DWORD;
    SegCs: DWORD;
    EFlags: DWORD;
    Esp: DWORD;
    SegSs: DWORD;
  end;
  TContext = _CONTEXT;
  CONTEXT = _CONTEXT;

const
  { bitfield constants for Flags field of TLDTEntry }

  LDTF_BASEMID      = DWORD($FF000000);  {8}
  LDTF_TYPE_8       = $00F80000;  {5}
  LDTF_DPL          = $00060000;  {2}
  LDTF_PRES         = $00010000;  {1}
  LDTF_LIMITHI      = $0000F000;  {4}
  LDTF_SYS          = $00000800;  {1}
  LDTF_RESERVED_0   = $00000400;  {1}
  LDTF_DEFAULT_BIG  = $00000200;  {1}
  LDTF_GRANULARITY  = $00000100;  {1}
  LDTF_BASEHI       = $000000FF;  {8}


type
  _LDT_ENTRY = record
    LimitLow: Word;
    BaseLow: Word;
    case Integer of
      0: (
        BaseMid: Byte;
        Flags1: Byte;
        Flags2: Byte;
        BaseHi: Byte);
      1: (
        Flags: Longint);
  end;
  TLDTEntry = _LDT_ENTRY;
  LDT_ENTRY = _LDT_ENTRY;

const
  EXCEPTION_NONCONTINUABLE     = 1;    { Noncontinuable exception }
  EXCEPTION_MAXIMUM_PARAMETERS = 15;   { maximum number of exception parameters }

type
  [StructLayout(LayoutKind.Sequential)]
  _EXCEPTION_RECORD = record
    ExceptionCode: DWORD;
    ExceptionFlags: DWORD;
    ExceptionRecord: IntPtr;  { PExceptionRecord }
    ExceptionAddress: IntPtr;
    NumberParameters: DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=EXCEPTION_MAXIMUM_PARAMETERS)]
    ExceptionInformation: array[0..EXCEPTION_MAXIMUM_PARAMETERS - 1] of DWORD;
  end;
  TExceptionRecord = _EXCEPTION_RECORD;
  EXCEPTION_RECORD = _EXCEPTION_RECORD;

{ Typedef for pointer returned by exception_info() }

  [StructLayout(LayoutKind.Sequential)]
  _EXCEPTION_POINTERS = record
    ExceptionRecord: IntPtr; { PExceptionRecord }
    ContextRecord: IntPtr;   { PContext }
  end;
  TExceptionPointers = _EXCEPTION_POINTERS;
  EXCEPTION_POINTERS = _EXCEPTION_POINTERS;

const
  THREAD_BASE_PRIORITY_LOWRT = 15;  { value that gets a thread to LowRealtime-1 }
  THREAD_BASE_PRIORITY_MAX = 2;     { maximum thread base priority boost }
  THREAD_BASE_PRIORITY_MIN = -2;    { minimum thread base priority boost }
  THREAD_BASE_PRIORITY_IDLE = -15;  { value that gets a thread to idle }

  SYNCHRONIZE = $00100000;
  STANDARD_RIGHTS_REQUIRED = $000F0000;
  EVENT_MODIFY_STATE = $0002;
  EVENT_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or $3);
  MUTANT_QUERY_STATE = $0001;
  MUTANT_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or MUTANT_QUERY_STATE);

  PROCESS_TERMINATE         = $0001;
  PROCESS_CREATE_THREAD     = $0002;
  PROCESS_VM_OPERATION      = $0008;
  PROCESS_VM_READ           = $0010;
  PROCESS_VM_WRITE          = $0020;
  PROCESS_DUP_HANDLE        = $0040;
  PROCESS_CREATE_PROCESS    = $0080;
  PROCESS_SET_QUOTA         = $0100;
  PROCESS_SET_INFORMATION   = $0200;
  PROCESS_QUERY_INFORMATION = $0400;
  PROCESS_ALL_ACCESS        = (STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or $FFF);

type
  [StructLayout(LayoutKind.Sequential)]
  _MEMORY_BASIC_INFORMATION = record
    BaseAddress : IntPtr;
    AllocationBase : IntPtr;
    AllocationProtect : DWORD;
    RegionSize : DWORD;
    State : DWORD;
    Protect : DWORD;
    Type_9 : DWORD;
  end;
  TMemoryBasicInformation = _MEMORY_BASIC_INFORMATION;
  MEMORY_BASIC_INFORMATION = _MEMORY_BASIC_INFORMATION;

const
  SECTION_QUERY = 1;
  SECTION_MAP_WRITE = 2;
  SECTION_MAP_READ = 4;
  SECTION_MAP_EXECUTE = 8;
  SECTION_EXTEND_SIZE = $10;
  SECTION_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED or SECTION_QUERY or
    SECTION_MAP_WRITE or SECTION_MAP_READ or SECTION_MAP_EXECUTE or SECTION_EXTEND_SIZE);

  PAGE_NOACCESS = 1;
  PAGE_READONLY = 2;
  PAGE_READWRITE = 4;
  PAGE_WRITECOPY = 8;
  PAGE_EXECUTE = $10;
  PAGE_EXECUTE_READ = $20;
  PAGE_EXECUTE_READWRITE = $40;
  PAGE_EXECUTE_WRITECOPY = $80;
  PAGE_GUARD = $100;
  PAGE_NOCACHE = $200;
  MEM_COMMIT = $1000;
  MEM_RESERVE = $2000;
  MEM_DECOMMIT = $4000;
  MEM_RELEASE = $8000;
  MEM_FREE = $10000;
  MEM_PRIVATE = $20000;
  MEM_MAPPED = $40000;
  MEM_RESET = $80000;
  MEM_TOP_DOWN = $100000;
  SEC_FILE = $800000;
  SEC_IMAGE = $1000000;
  SEC_RESERVE = $4000000;
  SEC_COMMIT = $8000000;
  SEC_NOCACHE = $10000000;
  MEM_IMAGE = SEC_IMAGE;


  FILE_SHARE_READ                     = $00000001;
  FILE_SHARE_WRITE                    = $00000002;
  FILE_SHARE_DELETE                   = $00000004;
  FILE_ATTRIBUTE_READONLY             = $00000001;
  FILE_ATTRIBUTE_HIDDEN               = $00000002;
  FILE_ATTRIBUTE_SYSTEM               = $00000004;
  FILE_ATTRIBUTE_DIRECTORY            = $00000010;
  FILE_ATTRIBUTE_ARCHIVE              = $00000020;
  FILE_ATTRIBUTE_NORMAL               = $00000080;
  FILE_ATTRIBUTE_TEMPORARY            = $00000100;
  FILE_ATTRIBUTE_COMPRESSED           = $00000800;
  FILE_ATTRIBUTE_OFFLINE              = $00001000;
  FILE_NOTIFY_CHANGE_FILE_NAME        = $00000001;
  FILE_NOTIFY_CHANGE_DIR_NAME         = $00000002;
  FILE_NOTIFY_CHANGE_ATTRIBUTES       = $00000004;
  FILE_NOTIFY_CHANGE_SIZE             = $00000008;
  FILE_NOTIFY_CHANGE_LAST_WRITE       = $00000010;
  FILE_NOTIFY_CHANGE_LAST_ACCESS      = $00000020;
  FILE_NOTIFY_CHANGE_CREATION         = $00000040;
  FILE_NOTIFY_CHANGE_SECURITY         = $00000100;
  FILE_ACTION_ADDED                   = $00000001;
  FILE_ACTION_REMOVED                 = $00000002;
  FILE_ACTION_MODIFIED                = $00000003;
  FILE_ACTION_RENAMED_OLD_NAME        = $00000004;
  FILE_ACTION_RENAMED_NEW_NAME        = $00000005;
  MAILSLOT_NO_MESSAGE                 = LongWord(-1);
  MAILSLOT_WAIT_FOREVER               = LongWord(-1);
  FILE_CASE_SENSITIVE_SEARCH          = $00000001;
  FILE_CASE_PRESERVED_NAMES           = $00000002;
  FILE_UNICODE_ON_DISK                = $00000004;
  FILE_PERSISTENT_ACLS                = $00000008;
  FILE_FILE_COMPRESSION               = $00000010;
  FILE_VOLUME_IS_COMPRESSED           = $00008000;


const
  IO_COMPLETION_MODIFY_STATE = $0002;
  IO_COMPLETION_ALL_ACCESS   = (STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or 3);
  DUPLICATE_CLOSE_SOURCE     = $00000001;
  DUPLICATE_SAME_ACCESS      = $00000002;

type
  PSECURITY_DESCRIPTOR = IntPtr;

  ACCESS_MASK = DWORD;

const
  { The following are masks for the predefined standard access types }

  _DELETE                  = $00010000; { Renamed from DELETE }
  READ_CONTROL             = $00020000;
  WRITE_DAC                = $00040000;
  WRITE_OWNER              = $00080000;
{ SYNCHRONIZE              = $00100000; defined above }
{ STANDARD_RIGHTS_REQUIRED = $000F0000; defined above }
  STANDARD_RIGHTS_READ     = READ_CONTROL;
  STANDARD_RIGHTS_WRITE    = READ_CONTROL;
  STANDARD_RIGHTS_EXECUTE  = READ_CONTROL;
  STANDARD_RIGHTS_ALL      = $001F0000;
  SPECIFIC_RIGHTS_ALL      = $0000FFFF;
  ACCESS_SYSTEM_SECURITY   = $01000000;
  MAXIMUM_ALLOWED          = $02000000;
  GENERIC_READ             = DWORD($80000000);
  GENERIC_WRITE            = $40000000;
  GENERIC_EXECUTE          = $20000000;
  GENERIC_ALL              = $10000000;

type
  { Define the generic mapping array.  This is used to denote the
    mapping of each generic access right to a specific access mask. }

  [StructLayout(LayoutKind.Sequential)]
  _GENERIC_MAPPING = record
    GenericRead: ACCESS_MASK;
    GenericWrite: ACCESS_MASK;
    GenericExecute: ACCESS_MASK;
    GenericAll: ACCESS_MASK;
  end;
  TGenericMapping = _GENERIC_MAPPING;
  GENERIC_MAPPING = _GENERIC_MAPPING;

  _LUID_AND_ATTRIBUTES = packed record
    Luid: TLargeInteger;
    Attributes: DWORD;
  end;
  TLUIDAndAttributes = _LUID_AND_ATTRIBUTES;
  LUID_AND_ATTRIBUTES = _LUID_AND_ATTRIBUTES;

{ ////////////////////////////////////////////////////////////////////// }
{                                                                    // }
{              Security Id     (SID)                                 // }
{                                                                    // }
{ ////////////////////////////////////////////////////////////////////// }


{ Pictorially the structure of an SID is as follows: }

{         1   1   1   1   1   1 }
{         5   4   3   2   1   0   9   8   7   6   5   4   3   2   1   0 }
{      +---------------------------------------------------------------+ }
{      |      SubAuthorityCount        |Reserved1 (SBZ)|   Revision    | }
{      +---------------------------------------------------------------+ }
{      |                   IdentifierAuthority[0]                      | }
{      +---------------------------------------------------------------+ }
{      |                   IdentifierAuthority[1]                      | }
{      +---------------------------------------------------------------+ }
{      |                   IdentifierAuthority[2]                      | }
{      +---------------------------------------------------------------+ }
{      |                                                               | }
{      +- -  -  -  -  -  -  -  SubAuthority[]  -  -  -  -  -  -  -  - -+ }
{      |                                                               | }
{      +---------------------------------------------------------------+ }

  [StructLayout(LayoutKind.Sequential)]
  _SID_IDENTIFIER_AUTHORITY = record
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=6)]
    Value: array[0..5] of Byte;
  end;
  TSIDIdentifierAuthority = _SID_IDENTIFIER_AUTHORITY;
  SID_IDENTIFIER_AUTHORITY = _SID_IDENTIFIER_AUTHORITY;

const
  SidTypeUser = 1;
  SidTypeGroup = 2;
  SidTypeDomain = 3;
  SidTypeAlias = 4;
  SidTypeWellKnownGroup = 5;
  SidTypeDeletedAccount = 6;
  SidTypeInvalid = 7;
  SidTypeUnknown = 8;
type
  SID_NAME_USE = DWORD;

  [StructLayout(LayoutKind.Sequential)]
  _SID_AND_ATTRIBUTES = record
    Sid: IntPtr;       { PSID }
    Attributes: DWORD;
  end;
  TSIDAndAttributes = _SID_AND_ATTRIBUTES;
  SID_AND_ATTRIBUTES = _SID_AND_ATTRIBUTES;

  [StructLayout(LayoutKind.Sequential)]
  _ACL = record
    AclRevision: Byte;
    Sbz1: Byte;
    AclSize: Word;
    AceCount: Word;
    Sbz2: Word;
  end;
  TACL = _ACL;
  ACL = _ACL;

  { The following declarations are used for setting and querying information
    about and ACL.  First are the various information classes available to
    the user. }

  TAclInformationClass = (AclInfoPad, AclRevisionInformation, AclSizeInformation);

{ Security Descriptor and related data types. }

const
  SECURITY_DESCRIPTOR_REVISION = 1;
  SECURITY_DESCRIPTOR_REVISION1 = 1;
  SECURITY_DESCRIPTOR_MIN_LENGTH = 20;
  SE_OWNER_DEFAULTED = $0001;
  SE_GROUP_DEFAULTED = $0002;
  SE_DACL_PRESENT    = $0004;
  SE_DACL_DEFAULTED  = $0008;
  SE_SACL_PRESENT    = $0010;
  SE_SACL_DEFAULTED  = $0020;
  SE_DACL_AUTO_INHERIT_REQ = $0100;
  SE_SACL_AUTO_INHERIT_REQ = $0200;
  SE_DACL_AUTO_INHERITED = $0400;
  SE_SACL_AUTO_INHERITED = $0800;
  SE_DACL_PROTECTED = $1000;
  SE_SACL_PROTECTED = $2000;

  SE_SELF_RELATIVE   = $8000;

{  Where: }

{      SE_OWNER_DEFAULTED - This boolean flag, when set, indicates that the }
{          SID pointed to by the Owner field was provided by a }
{          defaulting mechanism rather than explicitly provided by the }
{          original provider of the security descriptor.  This may }
{          affect the treatment of the SID with respect to inheritence }
{          of an owner. }

{      SE_GROUP_DEFAULTED - This boolean flag, when set, indicates that the }
{          SID in the Group field was provided by a defaulting mechanism }
{          rather than explicitly provided by the original provider of }
{          the security descriptor.  This may affect the treatment of }
{          the SID with respect to inheritence of a primary group. }

{      SE_DACL_PRESENT - This boolean flag, when set, indicates that the }
{          security descriptor contains a discretionary ACL.  If this }
{          flag is set and the Dacl field of the SECURITY_DESCRIPTOR is }
{          null, then a null ACL is explicitly being specified. }

{      SE_DACL_DEFAULTED - This boolean flag, when set, indicates that the }
{          ACL pointed to by the Dacl field was provided by a defaulting }
{          mechanism rather than explicitly provided by the original }
{          provider of the security descriptor.  This may affect the }
{          treatment of the ACL with respect to inheritence of an ACL. }
{          This flag is ignored if the DaclPresent flag is not set. }

{      SE_SACL_PRESENT - This boolean flag, when set,  indicates that the }
{          security descriptor contains a system ACL pointed to by the }
{          Sacl field.  If this flag is set and the Sacl field of the }
{          SECURITY_DESCRIPTOR is null, then an empty (but present) }
{          ACL is being specified. }

{      SE_SACL_DEFAULTED - This boolean flag, when set, indicates that the }
{          ACL pointed to by the Sacl field was provided by a defaulting }
{          mechanism rather than explicitly provided by the original }
{          provider of the security descriptor.  This may affect the }
{          treatment of the ACL with respect to inheritence of an ACL. }
{          This flag is ignored if the SaclPresent flag is not set. }

{      SE_SELF_RELATIVE - This boolean flag, when set, indicates that the }
{          security descriptor is in self-relative form.  In this form, }
{          all fields of the security descriptor are contiguous in memory }
{          and all pointer fields are expressed as offsets from the }
{          beginning of the security descriptor.  This form is useful }
{          for treating security descriptors as opaque data structures }
{          for transmission in communication protocol or for storage on }
{          secondary media. }



{ Pictorially the structure of a security descriptor is as follows: }

{       3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 }
{       1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 }
{      +---------------------------------------------------------------+ }
{      |            Control            |Reserved1 (SBZ)|   Revision    | }
{      +---------------------------------------------------------------+ }
{      |                            Owner                              | }
{      +---------------------------------------------------------------+ }
{      |                            Group                              | }
{      +---------------------------------------------------------------+ }
{      |                            Sacl                               | }
{      +---------------------------------------------------------------+ }
{      |                            Dacl                               | }
{      +---------------------------------------------------------------+ }

{ In general, this data structure should be treated opaquely to ensure future }
{ compatibility. }


type
  SECURITY_DESCRIPTOR_CONTROL = Word;

  { In general, this data structure should be treated opaquely
    to ensure future compatibility. }

  [StructLayout(LayoutKind.Sequential)]
  _SECURITY_DESCRIPTOR = record
    Revision: Byte;
    Sbz1: Byte;
    Control: SECURITY_DESCRIPTOR_CONTROL;
    Owner: IntPtr; { PSID }
    Group: IntPtr; { PSID }
    Sacl: IntPtr;  { PACL }
    Dacl: IntPtr;  { PACL }
  end;
  TSecurityDescriptor = _SECURITY_DESCRIPTOR;
  SECURITY_DESCRIPTOR = _SECURITY_DESCRIPTOR;

  [StructLayout(LayoutKind.Sequential)]
  _OBJECT_TYPE_LIST = record
    Level: WORD;
    Sbz: WORD;
    ObjectType: IntPtr; { PGUID }
  end;
  TObjectTypeList = _OBJECT_TYPE_LIST;
  OBJECT_TYPE_LIST = _OBJECT_TYPE_LIST;

const
  { DS values for Level }
  ACCESS_OBJECT_GUID = 0;
  ACCESS_PROPERTY_SET_GUID = 1;
  ACCESS_PROPERTY_GUID = 2;

  ACCESS_MAX_LEVEL = 4;

type
  AUDIT_EVENT_TYPE = DWORD;

const
  AUDIT_ALLOW_NO_PRIVILEGE = $1;


{ Privilege Related Data Structures }

const
  { Privilege attributes }

  SE_PRIVILEGE_ENABLED_BY_DEFAULT = $00000001;
  SE_PRIVILEGE_ENABLED            = $00000002;
  SE_PRIVILEGE_USED_FOR_ACCESS    = DWORD($80000000);

  { Privilege Set Control flags }

  PRIVILEGE_SET_ALL_NECESSARY = 1;

  {  Privilege Set - This is defined for a privilege set of one.
                   If more than one privilege is needed, then this structure
                   will need to be allocated with more space.}
  {  Note: don't change this structure without fixing the INITIAL_PRIVILEGE_SET}

type
  [StructLayout(LayoutKind.Sequential)]
  _PRIVILEGE_SET = record
    PrivilegeCount: DWORD;
    Control: DWORD;
    Privilege: IntPtr; { array[0..0] of TLUIDAndAttributes }
  end;
  TPrivilegeSet = _PRIVILEGE_SET;
  PRIVILEGE_SET = _PRIVILEGE_SET;

{ line 3130 }
  TSecurityImpersonationLevel = (SecurityAnonymous,
    SecurityIdentification, SecurityImpersonation, SecurityDelegation);

const
  SECURITY_MAX_IMPERSONATION_LEVEL     = SecurityDelegation;
  DEFAULT_IMPERSONATION_LEVEL     = SecurityImpersonation;

const
  TOKEN_ASSIGN_PRIMARY = $0001;
  TOKEN_DUPLICATE = $0002;
  TOKEN_IMPERSONATE = $0004;
  TOKEN_QUERY = $0008;
  TOKEN_QUERY_SOURCE = $0010;
  TOKEN_ADJUST_PRIVILEGES = $0020;
  TOKEN_ADJUST_GROUPS = $0040;
  TOKEN_ADJUST_DEFAULT = $0080;
  TOKEN_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED or TOKEN_ASSIGN_PRIMARY or
    TOKEN_DUPLICATE or TOKEN_IMPERSONATE or TOKEN_QUERY or
    TOKEN_QUERY_SOURCE or TOKEN_ADJUST_PRIVILEGES or TOKEN_ADJUST_GROUPS or
    TOKEN_ADJUST_DEFAULT);
  TOKEN_READ = (STANDARD_RIGHTS_READ or TOKEN_QUERY);
  TOKEN_WRITE = (STANDARD_RIGHTS_WRITE or TOKEN_ADJUST_PRIVILEGES or
    TOKEN_ADJUST_GROUPS or TOKEN_ADJUST_DEFAULT);
  TOKEN_EXECUTE = STANDARD_RIGHTS_EXECUTE;

type
  TTokenType = (TokenTPad, TokenPrimary, TokenImpersonation);

  TTokenInformationClass = (TokenICPad, TokenUser, TokenGroups, TokenPrivileges,
    TokenOwner, TokenPrimaryGroup, TokenDefaultDacl, TokenSource, TokenType,
    TokenImpersonationLevel, TokenStatistics);

  [StructLayout(LayoutKind.Sequential)]
  _TOKEN_GROUPS = record
    GroupCount: DWORD;
    Groups: array[0..0] of TSIDAndAttributes;
  end;
  TTokenGroups = _TOKEN_GROUPS;
  TOKEN_GROUPS = _TOKEN_GROUPS;

  [StructLayout(LayoutKind.Sequential)]
  _TOKEN_PRIVILEGES = record
    PrivilegeCount: DWORD;
    Privileges: array[0..0] of TLUIDAndAttributes;
  end;
  TTokenPrivileges = _TOKEN_PRIVILEGES;
  TOKEN_PRIVILEGES = _TOKEN_PRIVILEGES;

const
  SECURITY_DYNAMIC_TRACKING = True;
  SECURITY_STATIC_TRACKING  = False;

type
  SECURITY_CONTEXT_TRACKING_MODE = Boolean;

  [StructLayout(LayoutKind.Sequential)]
  _SECURITY_QUALITY_OF_SERVICE = record
    Length: DWORD;
    ImpersonationLevel: TSecurityImpersonationLevel;
    ContextTrackingMode: SECURITY_CONTEXT_TRACKING_MODE;
    EffectiveOnly: Boolean;
  end;
  TSecurityQualityOfService = _SECURITY_QUALITY_OF_SERVICE;
  SECURITY_QUALITY_OF_SERVICE = _SECURITY_QUALITY_OF_SERVICE;

  SECURITY_INFORMATION = DWORD;

const
  OWNER_SECURITY_INFORMATION =  $00000001;
  GROUP_SECURITY_INFORMATION =  $00000002;
  DACL_SECURITY_INFORMATION  =  $00000004;
  SACL_SECURITY_INFORMATION  =  $00000008;

type
  TThreadStartRoutine = function(lpThreadParameter: IntPtr): Integer;

const
  IMAGE_DOS_SIGNATURE                     = $5A4D;      { MZ }
  IMAGE_OS2_SIGNATURE                     = $454E;      { NE }
  IMAGE_OS2_SIGNATURE_LE                  = $454C;      { LE }
  IMAGE_VXD_SIGNATURE                     = $454C;      { LE }
  IMAGE_NT_SIGNATURE                      = $00004550;  { PE00 }

{ File header format. }

type
  _IMAGE_DOS_HEADER = packed record      { DOS .EXE header                  }
      e_magic: Word;                     { Magic number                     }
      e_cblp: Word;                      { Bytes on last page of file       }
      e_cp: Word;                        { Pages in file                    }
      e_crlc: Word;                      { Relocations                      }
      e_cparhdr: Word;                   { Size of header in paragraphs     }
      e_minalloc: Word;                  { Minimum extra paragraphs needed  }
      e_maxalloc: Word;                  { Maximum extra paragraphs needed  }
      e_ss: Word;                        { Initial (relative) SS value      }
      e_sp: Word;                        { Initial SP value                 }
      e_csum: Word;                      { Checksum                         }
      e_ip: Word;                        { Initial IP value                 }
      e_cs: Word;                        { Initial (relative) CS value      }
      e_lfarlc: Word;                    { File address of relocation table }
      e_ovno: Word;                      { Overlay number                   }
      [MarshalAs(UnmanagedType.ByValArray, SizeConst=4)]
      e_res: array [0..3] of Word;       { Reserved words                   }
      e_oemid: Word;                     { OEM identifier (for e_oeminfo)   }
      e_oeminfo: Word;                   { OEM information; e_oemid specific}
      [MarshalAs(UnmanagedType.ByValArray, SizeConst=10)]
      e_res2: array [0..9] of Word;      { Reserved words                   }
      _lfanew: LongInt;                  { File address of new exe header   }
  end;
  TImageDosHeader = _IMAGE_DOS_HEADER;
  IMAGE_DOS_HEADER = _IMAGE_DOS_HEADER;


  _IMAGE_FILE_HEADER = packed record
    Machine: Word;
    NumberOfSections: Word;
    TimeDateStamp: DWORD;
    PointerToSymbolTable: DWORD;
    NumberOfSymbols: DWORD;
    SizeOfOptionalHeader: Word;
    Characteristics: Word;
  end;
  TImageFileHeader = _IMAGE_FILE_HEADER;
  IMAGE_FILE_HEADER = _IMAGE_FILE_HEADER;

  _IMAGE_EXPORT_DIRECTORY = packed record
      Characteristics: DWord;
      TimeDateStamp: DWord;
      MajorVersion: Word;
      MinorVersion: Word;
      Name: DWord;
      Base: DWord;
      NumberOfFunctions: DWord;
      NumberOfNames: DWord;
      AddressOfFunctions: IntPtr; { ^PDWORD }
      AddressOfNames: IntPtr; { ^PDWORD }
      AddressOfNameOrdinals: IntPtr; { ^PWord }
  end;
  TImageExportDirectory = _IMAGE_EXPORT_DIRECTORY;
  IMAGE_EXPORT_DIRECTORY = _IMAGE_EXPORT_DIRECTORY;

const
  IMAGE_SIZEOF_FILE_HEADER                 = 20;

  IMAGE_FILE_RELOCS_STRIPPED               = $0001;  { Relocation info stripped from file. }
  IMAGE_FILE_EXECUTABLE_IMAGE              = $0002;  { File is executable  (i.e. no unresolved externel references). }
  IMAGE_FILE_LINE_NUMS_STRIPPED            = $0004;  { Line nunbers stripped from file. }
  IMAGE_FILE_LOCAL_SYMS_STRIPPED           = $0008;  { Local symbols stripped from file. }
  IMAGE_FILE_AGGRESIVE_WS_TRIM             = $0010;  { Agressively trim working set }
  IMAGE_FILE_BYTES_REVERSED_LO             = $0080;  { Bytes of machine word are reversed. }
  IMAGE_FILE_32BIT_MACHINE                 = $0100;  { 32 bit word machine. }
  IMAGE_FILE_DEBUG_STRIPPED                = $0200;  { Debugging info stripped from file in .DBG file }
  IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP       = $0400;  { If Image is on removable media, copy and run from the swap file. }
  IMAGE_FILE_NET_RUN_FROM_SWAP             = $0800;  { If Image is on Net, copy and run from the swap file. }
  IMAGE_FILE_SYSTEM                        = $1000;  { System File. }
  IMAGE_FILE_DLL                           = $2000;  { File is a DLL. }
  IMAGE_FILE_UP_SYSTEM_ONLY                = $4000;  { File should only be run on a UP machine }
  IMAGE_FILE_BYTES_REVERSED_HI             = $8000;  { Bytes of machine word are reversed. }

  IMAGE_FILE_MACHINE_UNKNOWN               = 0;
  IMAGE_FILE_MACHINE_I386                  = $14c;   { Intel 386. }
  IMAGE_FILE_MACHINE_R3000                 = $162;   { MIPS little-endian, 0x160 big-endian }
  IMAGE_FILE_MACHINE_R4000                 = $166;   { MIPS little-endian }
  IMAGE_FILE_MACHINE_R10000                = $168;   { MIPS little-endian }
  IMAGE_FILE_MACHINE_ALPHA                 = $184;   { Alpha_AXP }
  IMAGE_FILE_MACHINE_POWERPC               = $1F0;   { IBM PowerPC Little-Endian }

{ Directory format. }

type
  [StructLayout(LayoutKind.Sequential)]
  _IMAGE_DATA_DIRECTORY = record
    VirtualAddress: DWORD;
    Size: DWORD;
  end;
  TImageDataDirectory = _IMAGE_DATA_DIRECTORY;
  IMAGE_DATA_DIRECTORY = _IMAGE_DATA_DIRECTORY;

const
  IMAGE_NUMBEROF_DIRECTORY_ENTRIES        = 16;

{ Optional header format. }

type
  _IMAGE_OPTIONAL_HEADER = packed record
    { Standard fields. }
    Magic: Word;
    MajorLinkerVersion: Byte;
    MinorLinkerVersion: Byte;
    SizeOfCode: DWORD;
    SizeOfInitializedData: DWORD;
    SizeOfUninitializedData: DWORD;
    AddressOfEntryPoint: DWORD;
    BaseOfCode: DWORD;
    BaseOfData: DWORD;
    { NT additional fields. }
    ImageBase: DWORD;
    SectionAlignment: DWORD;
    FileAlignment: DWORD;
    MajorOperatingSystemVersion: Word;
    MinorOperatingSystemVersion: Word;
    MajorImageVersion: Word;
    MinorImageVersion: Word;
    MajorSubsystemVersion: Word;
    MinorSubsystemVersion: Word;
    Win32VersionValue: DWORD;
    SizeOfImage: DWORD;
    SizeOfHeaders: DWORD;
    CheckSum: DWORD;
    Subsystem: Word;
    DllCharacteristics: Word;
    SizeOfStackReserve: DWORD;
    SizeOfStackCommit: DWORD;
    SizeOfHeapReserve: DWORD;
    SizeOfHeapCommit: DWORD;
    LoaderFlags: DWORD;
    NumberOfRvaAndSizes: DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=IMAGE_NUMBEROF_DIRECTORY_ENTRIES)]
    DataDirectory: packed array[0..IMAGE_NUMBEROF_DIRECTORY_ENTRIES-1] of Int64; { TImageDataDirectory }
  end;
  TImageOptionalHeader = _IMAGE_OPTIONAL_HEADER;
  IMAGE_OPTIONAL_HEADER = _IMAGE_OPTIONAL_HEADER;

  _IMAGE_ROM_OPTIONAL_HEADER = packed record
    Magic: Word;
    MajorLinkerVersion: Byte;
    MinorLinkerVersion: Byte;
    SizeOfCode: DWORD;
    SizeOfInitializedData: DWORD;
    SizeOfUninitializedData: DWORD;
    AddressOfEntryPoint: DWORD;
    BaseOfCode: DWORD;
    BaseOfData: DWORD;
    BaseOfBss: DWORD;
    GprMask: DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=4)]
    CprMask: packed array[0..3] of DWORD;
    GpValue: DWORD;
  end;
  TImageRomOptionalHeader = _IMAGE_ROM_OPTIONAL_HEADER;
  IMAGE_ROM_OPTIONAL_HEADER = _IMAGE_ROM_OPTIONAL_HEADER;


const
  IMAGE_SIZEOF_ROM_OPTIONAL_HEADER       = 56;
  IMAGE_SIZEOF_STD_OPTIONAL_HEADER       = 28;
  IMAGE_SIZEOF_NT_OPTIONAL_HEADER        = 224;

  IMAGE_NT_OPTIONAL_HDR_MAGIC            = $010B;
  IMAGE_ROM_OPTIONAL_HDR_MAGIC           = $0107;

type
  _IMAGE_NT_HEADERS = packed record
    Signature: DWORD;
    FileHeader: TImageFileHeader;
    OptionalHeader: TImageOptionalHeader;
  end;
  TImageNtHeaders = _IMAGE_NT_HEADERS;
  IMAGE_NT_HEADERS = _IMAGE_NT_HEADERS;


  _IMAGE_ROM_HEADERS = packed record
    FileHeader: TImageFileHeader;
    OptionalHeader: TImageRomOptionalHeader;
  end;
  TImageRomHeaders = _IMAGE_ROM_HEADERS;
  IMAGE_ROM_HEADERS = _IMAGE_ROM_HEADERS;


{ Subsystem Values }

const
  IMAGE_SUBSYSTEM_UNKNOWN                  = 0;  { Unknown subsystem. }
  IMAGE_SUBSYSTEM_NATIVE                   = 1;  { Image doesn't require a subsystem. }
  IMAGE_SUBSYSTEM_WINDOWS_GUI              = 2;  { Image runs in the Windows GUI subsystem. }
  IMAGE_SUBSYSTEM_WINDOWS_CUI              = 3;  { Image runs in the Windows character subsystem. }
  IMAGE_SUBSYSTEM_OS2_CUI                  = 5;  { image runs in the OS/2 character subsystem. }
  IMAGE_SUBSYSTEM_POSIX_CUI                = 7;  { image run  in the Posix character subsystem. }
  IMAGE_SUBSYSTEM_RESERVED8                = 8;  { image run  in the 8 subsystem. }


{ Directory Entries }

  IMAGE_DIRECTORY_ENTRY_EXPORT             = 0;  { Export Directory }
  IMAGE_DIRECTORY_ENTRY_IMPORT             = 1;  { Import Directory }
  IMAGE_DIRECTORY_ENTRY_RESOURCE           = 2;  { Resource Directory }
  IMAGE_DIRECTORY_ENTRY_EXCEPTION          = 3;  { Exception Directory }
  IMAGE_DIRECTORY_ENTRY_SECURITY           = 4;  { Security Directory }
  IMAGE_DIRECTORY_ENTRY_BASERELOC          = 5;  { Base Relocation Table }
  IMAGE_DIRECTORY_ENTRY_DEBUG              = 6;  { Debug Directory }
  IMAGE_DIRECTORY_ENTRY_COPYRIGHT          = 7;  { Description String }
  IMAGE_DIRECTORY_ENTRY_GLOBALPTR          = 8;  { Machine Value (MIPS GP) }
  IMAGE_DIRECTORY_ENTRY_TLS                = 9;  { TLS Directory }
  IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG       = 10;  { Load Configuration Directory }
  IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT      = 11;  { Bound Import Directory in headers }
  IMAGE_DIRECTORY_ENTRY_IAT               = 12;  { Import Address Table }

{ Section header format. }

  IMAGE_SIZEOF_SHORT_NAME                  = 8;

type
  TISHMisc = packed record
    case Integer of
      0: (PhysicalAddress: DWORD);
      1: (VirtualSize: DWORD);
  end;

  _IMAGE_SECTION_HEADER = packed record
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=IMAGE_SIZEOF_SHORT_NAME)]
    Name: packed array[0..IMAGE_SIZEOF_SHORT_NAME-1] of Byte;
    Misc: TISHMisc;
    VirtualAddress: DWORD;
    SizeOfRawData: DWORD;
    PointerToRawData: DWORD;
    PointerToRelocations: DWORD;
    PointerToLinenumbers: DWORD;
    NumberOfRelocations: Word;
    NumberOfLinenumbers: Word;
    Characteristics: DWORD;
  end;
  TImageSectionHeader = _IMAGE_SECTION_HEADER;
  IMAGE_SECTION_HEADER = _IMAGE_SECTION_HEADER;


const
  IMAGE_SIZEOF_SECTION_HEADER              = 40;


{ Section characteristics. }

{      IMAGE_SCN_TYPE_REG                   0x00000000  // Reserved. }
{      IMAGE_SCN_TYPE_DSECT                 0x00000001  // Reserved. }
{      IMAGE_SCN_TYPE_NOLOAD                0x00000002  // Reserved. }
{      IMAGE_SCN_TYPE_GROUP                 0x00000004  // Reserved. }
  IMAGE_SCN_TYPE_NO_PAD                    = $00000008;  { Reserved. }
{      IMAGE_SCN_TYPE_COPY                  0x00000010  // Reserved. }

  IMAGE_SCN_CNT_CODE                       = $00000020;  { Section contains code. }
  IMAGE_SCN_CNT_INITIALIZED_DATA           = $00000040;  { Section contains initialized data. }
  IMAGE_SCN_CNT_UNINITIALIZED_DATA         = $00000080;  { Section contains uninitialized data. }

  IMAGE_SCN_LNK_OTHER                      = $00000100;  { Reserved. }
  IMAGE_SCN_LNK_INFO                       = $00000200;  { Section contains comments or some other type of information. }
{      IMAGE_SCN_TYPE_OVER                  0x00000400  // Reserved. }
  IMAGE_SCN_LNK_REMOVE                     = $00000800;  { Section contents will not become part of image. }
  IMAGE_SCN_LNK_COMDAT                     = $00001000;  { Section contents comdat. }
{                                           0x00002000  // Reserved. }

{      IMAGE_SCN_MEM_PROTECTED - Obsolete   0x00004000 }
  IMAGE_SCN_MEM_FARDATA                    = $00008000;
{      IMAGE_SCN_MEM_SYSHEAP  - Obsolete    0x00010000 }
  IMAGE_SCN_MEM_PURGEABLE                  = $00020000;
  IMAGE_SCN_MEM_16BIT                      = $00020000;
  IMAGE_SCN_MEM_LOCKED                     = $00040000;
  IMAGE_SCN_MEM_PRELOAD                    = $00080000;

  IMAGE_SCN_ALIGN_1BYTES                   = $00100000;
  IMAGE_SCN_ALIGN_2BYTES                   = $00200000;
  IMAGE_SCN_ALIGN_4BYTES                   = $00300000;
  IMAGE_SCN_ALIGN_8BYTES                   = $00400000;
  IMAGE_SCN_ALIGN_16BYTES                  = $00500000;  { Default alignment if no others are specified. }
  IMAGE_SCN_ALIGN_32BYTES                  = $00600000;
  IMAGE_SCN_ALIGN_64BYTES                  = $00700000;
{ Unused                                    0x00800000 }

  IMAGE_SCN_LNK_NRELOC_OVFL                = $01000000;  { Section contains extended relocations. }
  IMAGE_SCN_MEM_DISCARDABLE                = $02000000;  { Section can be discarded. }
  IMAGE_SCN_MEM_NOT_CACHED                 = $04000000;  { Section is not cachable. }
  IMAGE_SCN_MEM_NOT_PAGED                  = $08000000;  { Section is not pageable. }
  IMAGE_SCN_MEM_SHARED                     = $10000000;  { Section is shareable. }
  IMAGE_SCN_MEM_EXECUTE                    = $20000000;  { Section is executable. }
  IMAGE_SCN_MEM_READ                       = $40000000;  { Section is readable. }
  IMAGE_SCN_MEM_WRITE                      = DWORD($80000000);  { Section is writeable. }


type
  IMAGE_LOAD_CONFIG_DIRECTORY = packed record
    Characteristics: DWORD;
    TimeDateStamp: DWORD;
    MajorVersion: Word;
    MinorVersion: Word;
    GlobalFlagsClear: DWORD;
    GlobalFlagsSet: DWORD;
    CriticalSectionDefaultTimeout: DWORD;
    DeCommitFreeBlockThreshold: DWORD;
    DeCommitTotalFreeThreshold: DWORD;
    LockPrefixTable: IntPtr; { Pointer }
    MaximumAllocationSize: DWORD;
    VirtualMemoryThreshold: DWORD;
    ProcessHeapFlags: DWORD;
    ProcessAffinityMask: DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=3)]
    Reserved: array[0..2] of DWORD;
  end;
  TImageLoadConfigDirectory = IMAGE_LOAD_CONFIG_DIRECTORY;
//  IMAGE_LOAD_CONFIG_DIRECTORY = _IMAGE_LOAD_CONFIG_DIRECTORY;


// Function table entry format for MIPS/ALPHA images.  Function table is
// pointed to by the IMAGE_DIRECTORY_ENTRY_EXCEPTION directory entry.
// This definition duplicates ones in ntmips.h and ntalpha.h for use
// by portable image file mungers.

  [StructLayout(LayoutKind.Sequential)]
  IMAGE_RUNTIME_FUNCTION_ENTRY = record
    BeginAddress: DWORD;
    EndAddress: DWORD;
    ExceptionHandler: IntPtr;
    HandlerData: IntPtr;
    PrologEndAddress: DWORD;
  end;
  TImageRuntimeFunctionEntry = IMAGE_RUNTIME_FUNCTION_ENTRY;
// IMAGE_RUNTIME_FUNCTION_ENTRY = _IMAGE_RUNTIME_FUNCTION_ENTRY;


//
// Debug Format
//

  _IMAGE_DEBUG_DIRECTORY = packed record
    Characteristics: DWORD;
    TimeDateStamp: DWORD;
    MajorVersion: Word;
    MinorVersion: Word;
    _Type: DWORD;
    SizeOfData: DWORD;
    AddressOfRawData: DWORD;
    PointerToRawData: DWORD;
  end;
  TImageDebugDirectory = _IMAGE_DEBUG_DIRECTORY;
  IMAGE_DEBUG_DIRECTORY = _IMAGE_DEBUG_DIRECTORY;


const
  IMAGE_DEBUG_TYPE_UNKNOWN          = 0;
  IMAGE_DEBUG_TYPE_COFF             = 1;
  IMAGE_DEBUG_TYPE_CODEVIEW         = 2;
  IMAGE_DEBUG_TYPE_FPO              = 3;
  IMAGE_DEBUG_TYPE_MISC             = 4;
  IMAGE_DEBUG_TYPE_EXCEPTION        = 5;
  IMAGE_DEBUG_TYPE_FIXUP            = 6;
  IMAGE_DEBUG_TYPE_OMAP_TO_SRC      = 7;
  IMAGE_DEBUG_TYPE_OMAP_FROM_SRC    = 8;

type
  [StructLayout(LayoutKind.Sequential)]
  _IMAGE_COFF_SYMBOLS_HEADER = record
    NumberOfSymbols: DWORD;
    LvaToFirstSymbol: DWORD;
    NumberOfLinenumbers: DWORD;
    LvaToFirstLinenumber: DWORD;
    RvaToFirstByteOfCode: DWORD;
    RvaToLastByteOfCode: DWORD;
    RvaToFirstByteOfData: DWORD;
    RvaToLastByteOfData: DWORD;
  end;
  TImageCOFFSymbolsHeader = _IMAGE_COFF_SYMBOLS_HEADER;
  IMAGE_COFF_SYMBOLS_HEADER = _IMAGE_COFF_SYMBOLS_HEADER;


const
  FRAME_FPO       = 0;
  FRAME_TRAP      = 1;
  FRAME_TSS       = 2;
  FRAME_NONFPO    = 3;

type
  _FPO_DATA = packed record
    ulOffStart: DWORD;             // offset 1st byte of function code
    cbProcSize: DWORD;             // # bytes in function
    cdwLocals: DWORD;              // # bytes in locals/4
    cdwParams: Word;              // # bytes in params/4
{    WORD        cbProlog : 8;           // # bytes in prolog
     WORD        cbRegs   : 3;           // # regs saved
     WORD        fHasSEH  : 1;           // TRUE if SEH in func
     WORD        fUseBP   : 1;           // TRUE if EBP has been allocated
     WORD        reserved : 1;           // reserved for future use
     WORD        cbFrame  : 2;}           // frame type
     cbProlog: Byte;
     OtherStuff: Byte;
  end;
  TFpoData = _FPO_DATA;
  FPO_DATA = _FPO_DATA;


const
  SIZEOF_RFPO_DATA         = 16;
  IMAGE_DEBUG_MISC_EXENAME = 1;

type
  _IMAGE_DEBUG_MISC = packed record
    DataType: DWORD;               // type of misc data, see defines
    Length: DWORD;                 // total length of record, rounded to four
                                   // byte multiple.
    Unicode: ByteBool;             // TRUE if data is unicode string
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=3)]
    Reserved: array[0..2] of Byte;
    Data: IntPtr;                  // array[0..0] of Byte - Actual data
  end;
  TImageDebugMisc = _IMAGE_DEBUG_MISC;
  IMAGE_DEBUG_MISC = _IMAGE_DEBUG_MISC;


//
// Function table extracted from MIPS/ALPHA images.  Does not contain
// information needed only for runtime support.  Just those fields for
// each entry needed by a debugger.
//
  [StructLayout(LayoutKind.Sequential)]
  _IMAGE_FUNCTION_ENTRY = record
    StartingAddress: DWORD;
    EndingAddress: DWORD;
    EndOfPrologue: DWORD;
  end;
  TImageFunctionEntry = _IMAGE_FUNCTION_ENTRY;
  IMAGE_FUNCTION_ENTRY = _IMAGE_FUNCTION_ENTRY;

{$IFNDEF LINUXCRITSECTION}
type
  [StructLayout(LayoutKind.Sequential)]
  _RTL_CRITICAL_SECTION_DEBUG = record
    Type_18: Word;
    CreatorBackTraceIndex: Word;
    CriticalSection: IntPtr; { PRTLCriticalSection }
    ProcessLocksList: TListEntry;
    EntryCount: DWORD;
    ContentionCount: DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=2)]
    Spare: array[0..1] of DWORD;
  end;
  TRTLCriticalSectionDebug = _RTL_CRITICAL_SECTION_DEBUG;
  RTL_CRITICAL_SECTION_DEBUG = _RTL_CRITICAL_SECTION_DEBUG;

  [StructLayout(LayoutKind.Sequential)]
  _RTL_CRITICAL_SECTION = record
    DebugInfo: IntPtr; { PRTLCriticalSectionDebug }
    LockCount: Longint;
    RecursionCount: Longint;
    OwningThread: THandle;
    LockSemaphore: THandle;
    Reserved: DWORD;
  end;
  TRTLCriticalSection = _RTL_CRITICAL_SECTION;
  RTL_CRITICAL_SECTION = _RTL_CRITICAL_SECTION;
{$ELSE}
  PRTLCriticalSection = Libc.PRTLCriticalSection;
  TRTLCriticalSection = Libc.TRTLCriticalSection;
{$ENDIF}

const
  RTL_CRITSECT_TYPE = 0;
  RTL_RESOURCE_TYPE = 1;


  DLL_PROCESS_ATTACH = 1;
  DLL_THREAD_ATTACH = 2;
  DLL_THREAD_DETACH = 3;
  DLL_PROCESS_DETACH = 0;

{ The types of events that can be logged. }

  EVENTLOG_SUCCESS          = $0000;
  EVENTLOG_ERROR_TYPE       = $0001;
  EVENTLOG_WARNING_TYPE     = $0002;
  EVENTLOG_INFORMATION_TYPE = $0004;
  EVENTLOG_AUDIT_SUCCESS    = $0008;
  EVENTLOG_AUDIT_FAILURE    = $0010;

{ Registry Specific Access Rights. }

  KEY_QUERY_VALUE    = $0001;
  KEY_SET_VALUE      = $0002;
  KEY_CREATE_SUB_KEY = $0004;
  KEY_ENUMERATE_SUB_KEYS = $0008;
  KEY_NOTIFY         = $0010;
  KEY_CREATE_LINK    = $0020;


  KEY_READ           = (STANDARD_RIGHTS_READ or
                        KEY_QUERY_VALUE or
                        KEY_ENUMERATE_SUB_KEYS or
                        KEY_NOTIFY) and not
                        SYNCHRONIZE;



  KEY_WRITE          = (STANDARD_RIGHTS_WRITE or
                        KEY_SET_VALUE or
                        KEY_CREATE_SUB_KEY) and not
                        SYNCHRONIZE;

  KEY_EXECUTE        =  KEY_READ and not SYNCHRONIZE;


  KEY_ALL_ACCESS     = (STANDARD_RIGHTS_ALL or
                        KEY_QUERY_VALUE or
                        KEY_SET_VALUE or
                        KEY_CREATE_SUB_KEY or
                        KEY_ENUMERATE_SUB_KEYS or
                        KEY_NOTIFY or
                        KEY_CREATE_LINK) and not
                        SYNCHRONIZE;

  { Registry Open/Create Options }

  REG_OPTION_RESERVED     = DWORD($00000000);    { Parameter is reserved }

  REG_OPTION_NON_VOLATILE = DWORD($00000000);    { Key is preserved }
                                                 { when system is rebooted }

  REG_OPTION_VOLATILE     = DWORD($00000001);    { Key is not preserved }
                                                 { when system is rebooted }

  REG_OPTION_CREATE_LINK  = DWORD($00000002);    { Created key is a }
                                                 { symbolic link }

  REG_OPTION_BACKUP_RESTORE = DWORD($00000004);  { open for backup or restore }
                                                 { special access rules }
                                                 { privilege required   }

  REG_LEGAL_OPTION  = (REG_OPTION_RESERVED or
                       REG_OPTION_NON_VOLATILE or
                       REG_OPTION_VOLATILE or
                       REG_OPTION_CREATE_LINK or
                       REG_OPTION_BACKUP_RESTORE);

  { Registry Key creation/open disposition }

  REG_CREATED_NEW_KEY     = DWORD($00000001);    { New Registry Key created }
  REG_OPENED_EXISTING_KEY = DWORD($00000002);    { Existing Key opened }

  { Registry Key restore flags }

  REG_WHOLE_HIVE_VOLATILE = DWORD($00000001);    { Restore whole hive volatile }
  REG_REFRESH_HIVE        = DWORD($00000002);    { Unwind changes to last flush }

  { Registry Notify filter values }

  REG_NOTIFY_CHANGE_NAME       = DWORD($00000001); { Create or delete (child) }
  REG_NOTIFY_CHANGE_ATTRIBUTES = DWORD($00000002);
  REG_NOTIFY_CHANGE_LAST_SET   = DWORD($00000004); { time stamp }
  REG_NOTIFY_CHANGE_SECURITY   = DWORD($00000008);

  REG_LEGAL_CHANGE_FILTER = (REG_OPTION_RESERVED or
                             REG_NOTIFY_CHANGE_NAME or
                             REG_NOTIFY_CHANGE_ATTRIBUTES or
                             REG_NOTIFY_CHANGE_LAST_SET or
                             REG_NOTIFY_CHANGE_SECURITY);

  { Registry Predefined Value Types }

  REG_NONE                    = 0;
  REG_SZ                      = 1;
  REG_EXPAND_SZ               = 2;
  REG_BINARY                  = 3;
  REG_DWORD                   = 4;
  REG_DWORD_LITTLE_ENDIAN     = 4;
  REG_DWORD_BIG_ENDIAN        = 5;
  REG_LINK                    = 6;
  REG_MULTI_SZ                = 7;
  REG_RESOURCE_LIST           = 8;
  REG_FULL_RESOURCE_DESCRIPTOR = 9;
  REG_RESOURCE_REQUIREMENTS_LIST = 10;

{ END Translated from WINNT.H }

type
  WPARAM = Longint;
  LPARAM = Longint;
  LRESULT = Longint;

function MakeWord(a, b: Byte): Word;
function MakeLong(a, b: Word): Longint;

type
  LOWORD = Word;

function HiWord(l: DWORD): Word;

type
  LOBYTE = Byte;

function HiByte(W: Word): Byte;

type
  HWND = type LongWord;
  HHOOK = type LongWord;

  ATOM = Word;
  TAtom = Word;

  HGLOBAL = THandle;
  HLOCAL = THandle;
  FARPROC = IntPtr;  { Pointer }
  TFarProc = IntPtr; { Pointer }
  PROC_22 = IntPtr;  { Pointer }

  HGDIOBJ = type LongWord;
  HACCEL = type LongWord;
  HBITMAP = type LongWord;
  HBRUSH = type LongWord;
  HCOLORSPACE = type LongWord;
  HDC = type LongWord;
  HGLRC = type LongWord;
  HDESK = type LongWord;
  HENHMETAFILE = type LongWord;
  HFONT = type LongWord;
  HICON = type LongWord;
  HMENU = type LongWord;
  HMETAFILE = type LongWord;
  HINST = type THandle;
  HMODULE = type THandle;
  HPALETTE = type LongWord;
  HPEN = type LongWord;
  HRGN = type LongWord;
  HRSRC = type THandle;
  HSTR = type LongWord;
  HTASK = type LongWord;
  HWINSTA = type LongWord;
  HKL = type LongWord;

  HFILE = LongWord;
  HCURSOR = HICON;              { HICONs & HCURSORs are polymorphic }

  COLORREF = DWORD;
  TColorRef = DWORD;

const
  HFILE_ERROR = HFILE(-1);

type
  TPoint = Types.TPoint;
  TRect = Types.TRect;
  TSize = Types.TSize;
  TSmallPoint = Types.TSmallPoint;
  tagPoint = TPoint;
  _POINTL = TPoint; { pt1 }
  TPointL = _POINTL;
  tagSIZE = TSize;
  SIZE = tagSize;

{$NODEFINE TPoint}
{$NODEFINE TRect}
{$NODEFINE tagPoint}

{ Translated from WINBASE.H }

{ Compatiblity functions and procedures }

function DefineHandleTable(Offset: Word): Bool;
procedure LimitEmsPages(Kbytes: Longint);
function SetSwapAreaSize(Size: Word): Longint;
                                           
function GetCurrentTime: Longint;
function Yield: Bool;

const
  INVALID_HANDLE_VALUE = THandle(-1);
  INVALID_FILE_SIZE = DWORD($FFFFFFFF);

  FILE_BEGIN = 0;
  FILE_CURRENT = 1;
  FILE_END = 2;

  TIME_ZONE_ID_INVALID = DWORD($FFFFFFFF);
  TIME_ZONE_ID_UNKNOWN  = 0;
  TIME_ZONE_ID_STANDARD = 1;
  TIME_ZONE_ID_DAYLIGHT = 2;


  WAIT_FAILED  = DWORD($FFFFFFFF);
  WAIT_OBJECT_0 = ((STATUS_WAIT_0 ) + 0 );

  WAIT_ABANDONED = ((STATUS_ABANDONED_WAIT_0 ) + 0 );
  WAIT_ABANDONED_0 = ((STATUS_ABANDONED_WAIT_0 ) + 0 );

  WAIT_TIMEOUT = STATUS_TIMEOUT;
  WAIT_IO_COMPLETION = STATUS_USER_APC;
  STILL_ACTIVE = STATUS_PENDING;
  EXCEPTION_ACCESS_VIOLATION = STATUS_ACCESS_VIOLATION;
  EXCEPTION_DATATYPE_MISALIGNMENT = STATUS_DATATYPE_MISALIGNMENT;
  EXCEPTION_BREAKPOINT = STATUS_BREAKPOINT;
  EXCEPTION_SINGLE_STEP = STATUS_SINGLE_STEP;
  EXCEPTION_ARRAY_BOUNDS_EXCEEDED = STATUS_ARRAY_BOUNDS_EXCEEDED;
  EXCEPTION_FLT_DENORMAL_OPERAND = STATUS_FLOAT_DENORMAL_OPERAND;
  EXCEPTION_FLT_DIVIDE_BY_ZERO = STATUS_FLOAT_DIVIDE_BY_ZERO;
  EXCEPTION_FLT_INEXACT_RESULT = STATUS_FLOAT_INEXACT_RESULT;
  EXCEPTION_FLT_INVALID_OPERATION = STATUS_FLOAT_INVALID_OPERATION;
  EXCEPTION_FLT_OVERFLOW = STATUS_FLOAT_OVERFLOW;
  EXCEPTION_FLT_STACK_CHECK = STATUS_FLOAT_STACK_CHECK;
  EXCEPTION_FLT_UNDERFLOW = STATUS_FLOAT_UNDERFLOW;
  EXCEPTION_INT_DIVIDE_BY_ZERO = STATUS_INTEGER_DIVIDE_BY_ZERO;
  EXCEPTION_INT_OVERFLOW = STATUS_INTEGER_OVERFLOW;
  EXCEPTION_PRIV_INSTRUCTION = STATUS_PRIVILEGED_INSTRUCTION;
  EXCEPTION_IN_PAGE_ERROR = STATUS_IN_PAGE_ERROR;
  EXCEPTION_ILLEGAL_INSTRUCTION = STATUS_ILLEGAL_INSTRUCTION;
  EXCEPTION_NONCONTINUABLE_EXCEPTION = STATUS_NONCONTINUABLE_EXCEPTION;
  EXCEPTION_STACK_OVERFLOW = STATUS_STACK_OVERFLOW;
  EXCEPTION_INVALID_DISPOSITION = STATUS_INVALID_DISPOSITION;
  EXCEPTION_GUARD_PAGE = STATUS_GUARD_PAGE_VIOLATION;
  EXCEPTION_INVALID_HANDLE = STATUS_INVALID_HANDLE;
  CONTROL_C_EXIT = STATUS_CONTROL_C_EXIT;

{$IFNDEF CLR}
procedure MoveMemory(Destination: Pointer; Source: Pointer; Length: DWORD);
procedure CopyMemory(Destination: Pointer; Source: Pointer; Length: DWORD);
procedure FillMemory(Destination: Pointer; Length: DWORD; Fill: Byte);
procedure ZeroMemory(Destination: Pointer; Length: DWORD);
{$ENDIF}

const
  { File creation flags must start at the high end since they }
  { are combined with the attributes}

  FILE_FLAG_WRITE_THROUGH = DWORD($80000000);
  FILE_FLAG_OVERLAPPED = $40000000;
  FILE_FLAG_NO_BUFFERING = $20000000;
  FILE_FLAG_RANDOM_ACCESS = $10000000;
  FILE_FLAG_SEQUENTIAL_SCAN = $8000000;
  FILE_FLAG_DELETE_ON_CLOSE = $4000000;
  FILE_FLAG_BACKUP_SEMANTICS = $2000000;
  FILE_FLAG_POSIX_SEMANTICS = $1000000;

  CREATE_NEW = 1;
  CREATE_ALWAYS = 2;
  OPEN_EXISTING = 3;
  OPEN_ALWAYS = 4;
  TRUNCATE_EXISTING = 5;


{ Define possible return codes from the CopyFileEx callback routine }

  PROGRESS_CONTINUE = 0;
  PROGRESS_CANCEL = 1;
  PROGRESS_STOP = 2;
  PROGRESS_QUIET = 3;


{ Define CopyFileEx callback routine state change values }

  CALLBACK_CHUNK_FINISHED = $00000000;
  CALLBACK_STREAM_SWITCH = $00000001;


{ Define CopyFileEx option flags }

  COPY_FILE_FAIL_IF_EXISTS = $00000001;
  COPY_FILE_RESTARTABLE = $00000002;


{ Define the NamedPipe definitions}

  { Define the dwOpenMode values for CreateNamedPipe }

  PIPE_ACCESS_INBOUND = 1;
  PIPE_ACCESS_OUTBOUND = 2;
  PIPE_ACCESS_DUPLEX = 3;

  { Define the Named Pipe End flags for GetNamedPipeInfo }

  PIPE_CLIENT_END = 0;
  PIPE_SERVER_END = 1;

  { Define the dwPipeMode values for CreateNamedPipe }

  PIPE_WAIT = 0;
  PIPE_NOWAIT = 1;
  PIPE_READMODE_BYTE = 0;
  PIPE_READMODE_MESSAGE = 2;
  PIPE_TYPE_BYTE = 0;
  PIPE_TYPE_MESSAGE = 4;

  { Define the well known values for CreateNamedPipe nMaxInstances }

  PIPE_UNLIMITED_INSTANCES = 255;

  { Define the Security Quality of Service bits to be passed into CreateFile }

  SECURITY_ANONYMOUS = (Ord(SecurityAnonymous) shl 16);
  SECURITY_IDENTIFICATION = (Ord(SecurityIdentification) shl 16);
  SECURITY_IMPERSONATION = (Ord(SecurityImpersonation) shl 16);
  SECURITY_DELEGATION = (Ord(SecurityDelegation) shl 16);

  SECURITY_CONTEXT_TRACKING = $40000;
  SECURITY_EFFECTIVE_ONLY = $80000;

  SECURITY_SQOS_PRESENT = $100000;
  SECURITY_VALID_SQOS_FLAGS = $1F0000;

{ File structures }

type
  [StructLayout(LayoutKind.Sequential)]
  _OVERLAPPED = record
    Internal: DWORD;
    InternalHigh: DWORD;
    Offset: DWORD;
    OffsetHigh: DWORD;
    hEvent: THandle;
  end;
  TOverlapped = _OVERLAPPED;
  OVERLAPPED = _OVERLAPPED;

  [StructLayout(LayoutKind.Sequential)]
  _SECURITY_ATTRIBUTES = record
    nLength: DWORD;
    lpSecurityDescriptor: IntPtr; { PSecurityDescriptor }
    bInheritHandle: BOOL;
  end;
  TSecurityAttributes = _SECURITY_ATTRIBUTES;
  SECURITY_ATTRIBUTES = _SECURITY_ATTRIBUTES;

  [StructLayout(LayoutKind.Sequential)]
  _PROCESS_INFORMATION = record
    hProcess: THandle;
    hThread: THandle;
    dwProcessId: DWORD;
    dwThreadId: DWORD;
  end;
  TProcessInformation = _PROCESS_INFORMATION;
  PROCESS_INFORMATION = _PROCESS_INFORMATION;

  { File System time stamps are represented with the following structure: }
  [StructLayout(LayoutKind.Sequential)]
  _FILETIME = record
    dwLowDateTime: DWORD;
    dwHighDateTime: DWORD;
  end;
  TFileTime = _FILETIME;
  FILETIME = _FILETIME;

  { System time is represented with the following structure: }
  [StructLayout(LayoutKind.Sequential)]
  _SYSTEMTIME = record
    wYear: Word;
    wMonth: Word;
    wDayOfWeek: Word;
    wDay: Word;
    wHour: Word;
    wMinute: Word;
    wSecond: Word;
    wMilliseconds: Word;
  end;
  TSystemTime = _SYSTEMTIME;
  SYSTEMTIME = _SYSTEMTIME;

  TFNThreadStartRoutine = function (lpThreadParameter: IntPtr): DWORD;
  TFNFiberStartRoutine = function(lpFiberParameter: IntPtr): IntPtr;

const
  MUTEX_MODIFY_STATE = MUTANT_QUERY_STATE;
  MUTEX_ALL_ACCESS = MUTANT_ALL_ACCESS;

  { Serial provider type. }

  SP_SERIALCOMM = $00000001;

  { Provider SubTypes }

  PST_UNSPECIFIED = $00000000;
  PST_RS232 = $00000001;
  PST_PARALLELPORT = $00000002;
  PST_RS422 = $00000003;
  PST_RS423 = $00000004;
  PST_RS449 = $00000005;
  PST_MODEM = $00000006;
  PST_FAX = $00000021;
  PST_SCANNER = $00000022;
  PST_NETWORK_BRIDGE = $00000100;
  PST_LAT = $00000101;
  PST_TCPIP_TELNET = $00000102;
  PST_X25 = $00000103;

  { Provider capabilities flags. }

  PCF_DTRDSR = $0001;
  PCF_RTSCTS = $0002;
  PCF_RLSD = $0004;
  PCF_PARITY_CHECK = $0008;
  PCF_XONXOFF = $0010;
  PCF_SETXCHAR = $0020;
  PCF_TOTALTIMEOUTS = $0040;
  PCF_INTTIMEOUTS = $0080;
  PCF_SPECIALCHARS = $0100;
  PCF_16BITMODE = $0200;

  { Comm provider settable parameters. }

  SP_PARITY = $0001;
  SP_BAUD = $0002;
  SP_DATABITS = $0004;
  SP_STOPBITS = $0008;
  SP_HANDSHAKING = $0010;
  SP_PARITY_CHECK = $0020;
  SP_RLSD = $0040;

  { Settable baud rates in the provider. }

  BAUD_075 = $00000001;
  BAUD_110 = $00000002;
  BAUD_134_5 = $00000004;
  BAUD_150 = $00000008;
  BAUD_300 = $00000010;
  BAUD_600 = $00000020;
  BAUD_1200 = $00000040;
  BAUD_1800 = $00000080;
  BAUD_2400 = $00000100;
  BAUD_4800 = $00000200;
  BAUD_7200 = $00000400;
  BAUD_9600 = $00000800;
  BAUD_14400 = $00001000;
  BAUD_19200 = $00002000;
  BAUD_38400 = $00004000;
  BAUD_56K = $00008000;
  BAUD_128K = $00010000;
  BAUD_115200 = $00020000;
  BAUD_57600 = $00040000;
  BAUD_USER = $10000000;

  { Settable Data Bits }

  DATABITS_5 = $0001;
  DATABITS_6 = $0002;
  DATABITS_7 = $0004;
  DATABITS_8 = $0008;
  DATABITS_16 = $0010;
  DATABITS_16X = $0020;

  { Settable Stop and Parity bits. }

  STOPBITS_10 = $0001;
  STOPBITS_15 = $0002;
  STOPBITS_20 = $0004;
  PARITY_NONE = $0100;
  PARITY_ODD = $0200;
  PARITY_EVEN = $0400;
  PARITY_MARK = $0800;
  PARITY_SPACE = $1000;

type
  [StructLayout(LayoutKind.Sequential)]
  _COMMPROP = record
    wPacketLength: Word;
    wPacketVersion: Word;
    dwServiceMask: DWORD;
    dwReserved1: DWORD;
    dwMaxTxQueue: DWORD;
    dwMaxRxQueue: DWORD;
    dwMaxBaud: DWORD;
    dwProvSubType: DWORD;
    dwProvCapabilities: DWORD;
    dwSettableParams: DWORD;
    dwSettableBaud: DWORD;
    wSettableData: Word;
    wSettableStopParity: Word;
    dwCurrentTxQueue: DWORD;
    dwCurrentRxQueue: DWORD;
    dwProvSpec1: DWORD;
    dwProvSpec2: DWORD;
    wcProvChar: IntPtr; { array[0..0] of WCHAR }
  end;
  TCommProp = _COMMPROP;
  COMMPROP = _COMMPROP;

  { Set dwProvSpec1 to COMMPROP_INITIALIZED to indicate that wPacketLength
    is valid before a call to GetCommProperties(). }
const
  COMMPROP_INITIALIZED = DWORD($E73CF52E);

type
  TComStateFlag = (fCtlHold, fDsrHold, fRlsHold, fXoffHold, fXOffSent, fEof,
    fTxim);  // not in Windows Headers
  TComStateFlags = set of TComStateFlag;

  [StructLayout(LayoutKind.Sequential)]
  _COMSTAT = record
    Flags: TComStateFlags;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=3)]
    Reserved: array[0..2] of Byte;
    cbInQue: DWORD;
    cbOutQue: DWORD;
  end;
  TComStat = _COMSTAT;
  COMSTAT = _COMSTAT;

const
  { DTR Control Flow Values. }
  DTR_CONTROL_DISABLE = 0;
  DTR_CONTROL_ENABLE = 1;
  DTR_CONTROL_HANDSHAKE = 2;

  { RTS Control Flow Values}
  RTS_CONTROL_DISABLE = 0;
  RTS_CONTROL_ENABLE = 1;
  RTS_CONTROL_HANDSHAKE = 2;
  RTS_CONTROL_TOGGLE = 3;

type
  _DCB = packed record
    DCBlength: DWORD;
    BaudRate: DWORD;
    Flags: Longint;
    wReserved: Word;
    XonLim: Word;
    XoffLim: Word;
    ByteSize: Byte;
    Parity: Byte;
    StopBits: Byte;
    XonChar: CHAR;
    XoffChar: CHAR;
    ErrorChar: CHAR;
    EofChar: CHAR;
    EvtChar: CHAR;
    wReserved1: Word;
  end;
  TDCB = _DCB;
  DCB = _DCB;

  [StructLayout(LayoutKind.Sequential)]
  _COMMTIMEOUTS = record
    ReadIntervalTimeout: DWORD;
    ReadTotalTimeoutMultiplier: DWORD;
    ReadTotalTimeoutConstant: DWORD;
    WriteTotalTimeoutMultiplier: DWORD;
    WriteTotalTimeoutConstant: DWORD;
  end;
  TCommTimeouts = _COMMTIMEOUTS;
  COMMTIMEOUTS = _COMMTIMEOUTS;

  [StructLayout(LayoutKind.Sequential)]
  _COMMCONFIG = record
    dwSize: DWORD;
    wVersion: Word;
    wReserved: Word;
    dcb: TDCB;
    dwProviderSubType: DWORD;
    dwProviderOffset: DWORD;
    dwProviderSize: DWORD;
    wcProviderData: IntPtr; { array[0..0] of WCHAR }
  end;
  TCommConfig = _COMMCONFIG;
  COMMCONFIG = _COMMCONFIG;

  _SYSTEM_INFO = record
    case Integer of
      0: (
        dwOemId: DWORD);
      1: (
        wProcessorArchitecture: Word;
        wReserved: Word;
        dwPageSize: DWORD;
        lpMinimumApplicationAddress: IntPtr; { Pointer }
        lpMaximumApplicationAddress: IntPtr; { Pointer }
        dwActiveProcessorMask: DWORD;
        dwNumberOfProcessors: DWORD;
        dwProcessorType: DWORD;
        dwAllocationGranularity: DWORD;
        wProcessorLevel: Word;
        wProcessorRevision: Word);
  end;
  TSystemInfo = _SYSTEM_INFO;
  SYSTEM_INFO = _SYSTEM_INFO;

function FreeModule(var hLibModule: HINST): BOOL; 
function MakeProcInstance(Proc: FARPROC; Instance: THandle): FARPROC;
procedure FreeProcInstance(Proc: FARPROC);


const
  { Global Memory Flags }

  GMEM_FIXED = 0;
  GMEM_MOVEABLE = 2;
  GMEM_NOCOMPACT = $10;
  GMEM_NODISCARD = $20;
  GMEM_ZEROINIT = $40;
  GMEM_MODIFY = $80;
  GMEM_DISCARDABLE = $100;
  GMEM_NOT_BANKED = $1000;
  GMEM_SHARE = $2000;
  GMEM_DDESHARE = $2000;
  GMEM_NOTIFY = $4000;
  GMEM_LOWER = GMEM_NOT_BANKED;
  GMEM_VALID_FLAGS = 32626;
  GMEM_INVALID_HANDLE = $8000;

  GHND = GMEM_MOVEABLE or GMEM_ZEROINIT;
  GPTR = GMEM_FIXED or GMEM_ZEROINIT;

                                           

{$IFNDEF CLR}
function GlobalAllocPtr(Flags: Integer; Bytes: Longint): Pointer;
function GlobalReAllocPtr(P: Pointer; Bytes: Longint; Flags: Integer): Pointer;
function GlobalFreePtr(P: Pointer): THandle;
{$ENDIF}

const
  { Flags returned by GlobalFlags (in addition to GMEM_DISCARDABLE) }
  GMEM_DISCARDED = $4000;
  GMEM_LOCKCOUNT = 255;

type
  [StructLayout(LayoutKind.Sequential)]
  _MEMORYSTATUS = record
    dwLength: DWORD;
    dwMemoryLoad: DWORD;
    dwTotalPhys: DWORD;
    dwAvailPhys: DWORD;
    dwTotalPageFile: DWORD;
    dwAvailPageFile: DWORD;
    dwTotalVirtual: DWORD;
    dwAvailVirtual: DWORD;
  end;
  TMemoryStatus = _MEMORYSTATUS;
  MEMORYSTATUS = _MEMORYSTATUS;

const
  { Local Memory Flags }

  LMEM_FIXED = 0;
  LMEM_MOVEABLE = 2;
  LMEM_NOCOMPACT = $10;
  LMEM_NODISCARD = $20;
  LMEM_ZEROINIT = $40;
  LMEM_MODIFY = $80;
  LMEM_DISCARDABLE = $F00;
  LMEM_VALID_FLAGS = $F72;
  LMEM_INVALID_HANDLE = $8000;

  LHND = LMEM_MOVEABLE or LMEM_ZEROINIT;
  LPTR = LMEM_FIXED or LMEM_ZEROINIT;

  NONZEROLPTR = LMEM_FIXED;


                                           

const
  { Flags returned by LocalFlags (in addition to LMEM_DISCARDABLE) }

  LMEM_DISCARDED = $4000;
  LMEM_LOCKCOUNT = 255;

  { dwCreationFlag values }

{ dwCreationFlag values }


  DEBUG_PROCESS                   = $00000001;
  DEBUG_ONLY_THIS_PROCESS         = $00000002;

  CREATE_SUSPENDED                = $00000004;

  DETACHED_PROCESS                = $00000008;

  CREATE_NEW_CONSOLE              = $00000010;

  NORMAL_PRIORITY_CLASS           = $00000020;
  IDLE_PRIORITY_CLASS             = $00000040;
  HIGH_PRIORITY_CLASS             = $00000080;
  REALTIME_PRIORITY_CLASS         = $00000100;

  CREATE_NEW_PROCESS_GROUP        = $00000200;
  CREATE_UNICODE_ENVIRONMENT      = $00000400;

  CREATE_SEPARATE_WOW_VDM         = $00000800;
  CREATE_SHARED_WOW_VDM           = $00001000;
  CREATE_FORCEDOS                 = $00002000;

  CREATE_DEFAULT_ERROR_MODE       = $04000000;
  CREATE_NO_WINDOW                = $08000000;

  PROFILE_USER                    = $10000000;
  PROFILE_KERNEL                  = $20000000;
  PROFILE_SERVER                  = $40000000;

  THREAD_PRIORITY_LOWEST              = THREAD_BASE_PRIORITY_MIN;
  THREAD_PRIORITY_BELOW_NORMAL        = THREAD_PRIORITY_LOWEST + 1;
  THREAD_PRIORITY_NORMAL              = 0;
  THREAD_PRIORITY_HIGHEST             = THREAD_BASE_PRIORITY_MAX;
  THREAD_PRIORITY_ABOVE_NORMAL        = THREAD_PRIORITY_HIGHEST - 1;
  THREAD_PRIORITY_ERROR_RETURN        = MAXLONG;

  THREAD_PRIORITY_TIME_CRITICAL       = THREAD_BASE_PRIORITY_LOWRT;
  THREAD_PRIORITY_IDLE                = THREAD_BASE_PRIORITY_IDLE;

{ Debug APIs }

  DBG_CONTINUE               = $00010002;
  DBG_TERMINATE_THREAD       = $40010003;
  DBG_TERMINATE_PROCESS      = $40010004;
  DBG_CONTROL_C              = $40010005;
  DBG_CONTROL_BREAK          = $40010008;
  DBG_EXCEPTION_NOT_HANDLED  = $80010001;

  EXCEPTION_DEBUG_EVENT = 1;
  CREATE_THREAD_DEBUG_EVENT = 2;
  CREATE_PROCESS_DEBUG_EVENT = 3;
  EXIT_THREAD_DEBUG_EVENT = 4;
  EXIT_PROCESS_DEBUG_EVENT = 5;
  LOAD_DLL_DEBUG_EVENT = 6;
  UNLOAD_DLL_DEBUG_EVENT = 7;
  OUTPUT_DEBUG_STRING_EVENT = 8;
  RIP_EVENT = 9;

type
  [StructLayout(LayoutKind.Sequential)]
  _EXCEPTION_DEBUG_INFO = record
    ExceptionRecord: TExceptionRecord;
    dwFirstChance: DWORD;
  end;
  TExceptionDebugInfo = _EXCEPTION_DEBUG_INFO;
  EXCEPTION_DEBUG_INFO = _EXCEPTION_DEBUG_INFO;

  [StructLayout(LayoutKind.Sequential)]
  _CREATE_THREAD_DEBUG_INFO = record
    hThread: THandle;
    lpThreadLocalBase: IntPtr;
    [MarshalAs(UnmanagedType.FunctionPtr)]
    lpStartAddress: TFNThreadStartRoutine;
  end;
  TCreateThreadDebugInfo = _CREATE_THREAD_DEBUG_INFO;
  CREATE_THREAD_DEBUG_INFO = _CREATE_THREAD_DEBUG_INFO;

  [StructLayout(LayoutKind.Sequential)]
  _CREATE_PROCESS_DEBUG_INFO = record
    hFile: THandle;
    hProcess: THandle;
    hThread: THandle;
    lpBaseOfImage: IntPtr; { Pointer }
    dwDebugInfoFileOffset: DWORD;
    nDebugInfoSize: DWORD;
    lpThreadLocalBase: IntPtr; { Pointer }
    [MarshalAs(UnmanagedType.FunctionPtr)]
    lpStartAddress: TFNThreadStartRoutine;
    lpImageName: IntPtr; { Pointer }
    fUnicode: Word;
  end;
  TCreateProcessDebugInfo = _CREATE_PROCESS_DEBUG_INFO;
  CREATE_PROCESS_DEBUG_INFO = _CREATE_PROCESS_DEBUG_INFO;

  [StructLayout(LayoutKind.Sequential)]
  _EXIT_THREAD_DEBUG_INFO = record
    dwExitCode: DWORD;
  end;
  TExitThreadDebugInfo = _EXIT_THREAD_DEBUG_INFO;
  EXIT_THREAD_DEBUG_INFO = _EXIT_THREAD_DEBUG_INFO;

  [StructLayout(LayoutKind.Sequential)]
  _EXIT_PROCESS_DEBUG_INFO = record
    dwExitCode: DWORD;
  end;
  TExitProcessDebugInfo = _EXIT_PROCESS_DEBUG_INFO;
  EXIT_PROCESS_DEBUG_INFO = _EXIT_PROCESS_DEBUG_INFO;

  [StructLayout(LayoutKind.Sequential)]
  _LOAD_DLL_DEBUG_INFO = record
    hFile: THandle;
    lpBaseOfDll: IntPtr; { Pointer }
    dwDebugInfoFileOffset: DWORD;
    nDebugInfoSize: DWORD;
    lpImageName: IntPtr; { Pointer }
    fUnicode: Word;
  end;
  TLoadDLLDebugInfo = _LOAD_DLL_DEBUG_INFO;
  LOAD_DLL_DEBUG_INFO = _LOAD_DLL_DEBUG_INFO;

  [StructLayout(LayoutKind.Sequential)]
  _UNLOAD_DLL_DEBUG_INFO = record
    lpBaseOfDll: IntPtr; { Pointer }
  end;
  TUnloadDLLDebugInfo = _UNLOAD_DLL_DEBUG_INFO;
  UNLOAD_DLL_DEBUG_INFO = _UNLOAD_DLL_DEBUG_INFO;

  [StructLayout(LayoutKind.Sequential)]
  _OUTPUT_DEBUG_STRING_INFO = record
    [MarshalAs(UnmanagedType.LPStr)]
    lpDebugStringData: string;
    fUnicode: Word;
    nDebugStringLength: Word;
  end;
  TOutputDebugStringInfo = _OUTPUT_DEBUG_STRING_INFO;
  OUTPUT_DEBUG_STRING_INFO = _OUTPUT_DEBUG_STRING_INFO;

  [StructLayout(LayoutKind.Sequential)]
  _RIP_INFO = record
    dwError: DWORD;
    dwType: DWORD;
  end;
  TRIPInfo = _RIP_INFO;
  RIP_INFO = _RIP_INFO;

{ TDebugEvent record violates rules for variant records
  in CLR. This declaration is provided as documentation
  only. Use IntPtr and Masrhal class instead of the
  TDebugEvent record when calling WaitForDebugEvent.

 _DEBUG_EVENT = record
    dwDebugEventCode: DWORD;
    dwProcessId: DWORD;
    dwThreadId: DWORD;
    case Integer of
      0: (Exception: TExceptionDebugInfo);
      1: (CreateThread: TCreateThreadDebugInfo);
      2: (CreateProcessInfo: TCreateProcessDebugInfo);
      3: (ExitThread: TExitThreadDebugInfo);
      4: (ExitProcess: TExitProcessDebugInfo);
      5: (LoadDll: TLoadDLLDebugInfo);
      6: (UnloadDll: TUnloadDLLDebugInfo);
      7: (DebugString: TOutputDebugStringInfo);
      8: (RipInfo: TRIPInfo);
  end;
  TDebugEvent = _DEBUG_EVENT;
  DEBUG_EVENT = _DEBUG_EVENT; }

const
  DRIVE_UNKNOWN = 0;
  DRIVE_NO_ROOT_DIR = 1;
  DRIVE_REMOVABLE = 2;
  DRIVE_FIXED = 3;
  DRIVE_REMOTE = 4;
  DRIVE_CDROM = 5;
  DRIVE_RAMDISK = 6;

function GetFreeSpace(w: Word): DWORD;

const
  FILE_TYPE_UNKNOWN = 0;
  FILE_TYPE_DISK = 1;
  FILE_TYPE_CHAR = 2;
  FILE_TYPE_PIPE = 3;
  FILE_TYPE_REMOTE = $8000;

  STD_INPUT_HANDLE = DWORD(-10);
  STD_OUTPUT_HANDLE = DWORD(-11);
  STD_ERROR_HANDLE = DWORD(-12);

  NOPARITY = 0;
  ODDPARITY = 1;
  EVENPARITY = 2;
  MARKPARITY = 3;
  SPACEPARITY = 4;

  ONESTOPBIT = 0;
  ONE5STOPBITS = 1;
  TWOSTOPBITS = 2;

  IGNORE = 0;               { Ignore signal }
  INFINITE = DWORD($FFFFFFFF);     { Infinite timeout }

  { Baud rates at which the communication device operates }

  CBR_110 = 110;
  CBR_300 = 300;
  CBR_600 = 600;
  CBR_1200 = 1200;
  CBR_2400 = 2400;
  CBR_4800 = 4800;
  CBR_9600 = 9600;
  CBR_14400 = 14400;
  CBR_19200 = 19200;
  CBR_38400 = 38400;
  CBR_56000 = 56000;
  CBR_57600 = 57600;
  CBR_115200 = $1C200;
  CBR_128000 = $1F400;
  CBR_256000 = $3E800;

  { Error Flags }

  CE_RXOVER = 1;        { Receive Queue overflow }
  CE_OVERRUN = 2;       { Receive Overrun Error }
  CE_RXPARITY = 4;      { Receive Parity Error }
  CE_FRAME = 8;         { Receive Framing error }
  CE_BREAK = $10;       { Break Detected }
  CE_TXFULL = $100;     { TX Queue is full }
  CE_PTO = $200;        { LPTx Timeout }
  CE_IOE = $400;        { LPTx I/O Error }
  CE_DNS = $800;        { LPTx Device not selected }
  CE_OOP = $1000;       { LPTx Out-Of-Paper }
  CE_MODE = $8000;      { Requested mode unsupported }

  IE_BADID = LongWord(-1);        { Invalid or unsupported id }
  IE_OPEN = LongWord(-2);         { Device Already Open }
  IE_NOPEN = LongWord(-3);        { Device Not Open }
  IE_MEMORY = LongWord(-4);       { Unable to allocate queues }
  IE_DEFAULT = LongWord(-5);      { Error in default parameters }
  IE_HARDWARE = LongWord(-10);    { Hardware Not Present }
  IE_BYTESIZE = LongWord(-11);    { Illegal Byte Size }
  IE_BAUDRATE = LongWord(-12);    { Unsupported BaudRate }

  { Events }

  EV_RXCHAR = 1;        { Any Character received }
  EV_RXFLAG = 2;        { Received certain character }
  EV_TXEMPTY = 4;       { Transmitt Queue Empty }
  EV_CTS = 8;           { CTS changed state }
  EV_DSR = $10;         { DSR changed state }
  EV_RLSD = $20;        { RLSD changed state }
  EV_BREAK = $40;       { BREAK received }
  EV_ERR = $80;         { Line status error occurred }
  EV_RING = $100;       { Ring signal detected }
  EV_PERR = $200;       { Printer error occured }
  EV_RX80FULL = $400;   { Receive buffer is 80 percent full }
  EV_EVENT1 = $800;     { Provider specific event 1 }
  EV_EVENT2 = $1000;    { Provider specific event 2 }

  { Escape functions }

  SETXOFF = 1;    { Simulate XOFF received }
  SETXON = 2;     { Simulate XON received }
  SETRTS = 3;     { Set RTS high }
  CLRRTS = 4;     { Set RTS low }
  SETDTR = 5;     { Set DTR high }
  CLRDTR = 6;     { Set DTR low }
  RESETDEV = 7;   { Reset device if possible }
  SETBREAK = 8;   { Set the device break line. }
  CLRBREAK = 9;   { Clear the device break line. }

  { PURGE function flags. }

  PURGE_TXABORT = 1;     { Kill the pending/current writes to the comm port. }
  PURGE_RXABORT = 2;     { Kill the pending/current reads to the comm port. }
  PURGE_TXCLEAR = 4;     { Kill the transmit queue if there. }
  PURGE_RXCLEAR = 8;     { Kill the typeahead buffer if there. }

  LPTx = $80;     { Set if ID is for LPT device }

  { Modem Status Flags }

  MS_CTS_ON = DWORD($0010);
  MS_DSR_ON = DWORD($0020);
  MS_RING_ON = DWORD($0040);
  MS_RLSD_ON = DWORD($0080);

  { WaitSoundState() Constants }

  S_QUEUEEMPTY = 0;
  S_THRESHOLD = 1;
  S_ALLTHRESHOLD = 2;

  { Accent Modes }

  S_NORMAL = 0;
  S_LEGATO = 1;
  S_STACCATO = 2;

  { SetSoundNoise() Sources }

  S_PERIOD512 = 0;     { Freq = N/512 high pitch, less coarse hiss }
  S_PERIOD1024 = 1;    { Freq = N/1024 }
  S_PERIOD2048 = 2;    { Freq = N/2048 low pitch, more coarse hiss }
  S_PERIODVOICE = 3;   { Source is frequency from voice channel (3) }
  S_WHITE512 = 4;      { Freq = N/512 high pitch, less coarse hiss }
  S_WHITE1024 = 5;     { Freq = N/1024 }
  S_WHITE2048 = 6;     { Freq = N/2048 low pitch, more coarse hiss }
  S_WHITEVOICE = 7;    { Source is frequency from voice channel (3) }

  S_SERDVNA = LongWord(-1);     { Device not available  }
  S_SEROFM = LongWord(-2);      { Out of memory }
  S_SERMACT = LongWord(-3);     { Music active }
  S_SERQFUL = LongWord(-4);     { Queue full }
  S_SERBDNT = LongWord(-5);     { Invalid note }
  S_SERDLN = LongWord(-6);      { Invalid note length }
  S_SERDCC = LongWord(-7);      { Invalid note count }
  S_SERDTP = LongWord(-8);      { Invalid tempo }
  S_SERDVL = LongWord(-9);      { Invalid volume }
  S_SERDMD = LongWord(-10);     { Invalid mode }
  S_SERDSH = LongWord(-11);     { Invalid shape }
  S_SERDPT = LongWord(-12);     { Invalid pitch }
  S_SERDFQ = LongWord(-13);     { Invalid frequency }
  S_SERDDR = LongWord(-14);     { Invalid duration }
  S_SERDSR = LongWord(-15);     { Invalid source }
  S_SERDST = LongWord(-16);     { Invalid state }

  NMPWAIT_WAIT_FOREVER = DWORD($FFFFFFFF);
  NMPWAIT_NOWAIT = 1;
  NMPWAIT_USE_DEFAULT_WAIT = 0;

  FS_CASE_IS_PRESERVED = FILE_CASE_PRESERVED_NAMES;
  FS_CASE_SENSITIVE = FILE_CASE_SENSITIVE_SEARCH;
  FS_UNICODE_STORED_ON_DISK = FILE_UNICODE_ON_DISK;
  FS_PERSISTENT_ACLS = FILE_PERSISTENT_ACLS;
  FS_VOL_IS_COMPRESSED = FILE_VOLUME_IS_COMPRESSED;
  FS_FILE_COMPRESSION = FILE_FILE_COMPRESSION;

  FILE_MAP_COPY = SECTION_QUERY;
  FILE_MAP_WRITE = SECTION_MAP_WRITE;
  FILE_MAP_READ = SECTION_MAP_READ;
  FILE_MAP_ALL_ACCESS = SECTION_ALL_ACCESS;

  OF_READ = 0;
  OF_WRITE = 1;
  OF_READWRITE = 2;
  OF_SHARE_COMPAT = 0;
  OF_SHARE_EXCLUSIVE = $10;
  OF_SHARE_DENY_WRITE = $20;
  OF_SHARE_DENY_READ = 48;
  OF_SHARE_DENY_NONE = $40;
  OF_PARSE = $100;
  OF_DELETE = $200;
  OF_VERIFY = $400;
  OF_CANCEL = $800;
  OF_CREATE = $1000;
  OF_PROMPT = $2000;
  OF_EXIST = $4000;
  OF_REOPEN = $8000;

  OFS_MAXPATHNAME = 128;

type
  [StructLayout(LayoutKind.Sequential)]
  _OFSTRUCT = record
    cBytes: Byte;
    fFixedDisk: Byte;
    nErrCode: Word;
    Reserved1: Word;
    Reserved2: Word;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=OFS_MAXPATHNAME)]
    szPathName: string;
  end;
  TOFStruct = _OFSTRUCT;
  OFSTRUCT = _OFSTRUCT;

                                           

function FreeResource(hResData: HGLOBAL): BOOL;
function LockResource(hResData: HGLOBAL): IntPtr;
function UnlockResource(hResData: THandle): BOOL;

const
  MAXINTATOM = $C000;
  INVALID_ATOM = 0;

type
  MakeIntAtomA = TAtom;
  MakeIntAtomW = TAtom;
  MakeIntAtom = TAtom;

function FreeLibrary(hLibModule: HMODULE): BOOL;
procedure FreeLibraryAndExitThread(hLibModule: HMODULE; dwExitCode: DWORD);
function DisableThreadLibraryCalls(hLibModule: HMODULE): BOOL;
function GetProcAddress(hModule: HMODULE; lpProcName: string): FARPROC;
function GetVersion: DWORD;

function GlobalAlloc(uFlags: UINT; dwBytes: DWORD): HGLOBAL; deprecated;
function GlobalReAlloc(hMem: HGLOBAL; dwBytes: DWORD; uFlags: UINT): HGLOBAL; deprecated;
function GlobalSize(hMem: HGLOBAL): DWORD; deprecated;
function GlobalFlags(hMem: HGLOBAL): UINT; deprecated;
function GlobalLock(hMem: HGLOBAL): IntPtr; deprecated;
function GlobalHandle(Mem: IntPtr): HGLOBAL; deprecated;
function GlobalUnlock(hMem: HGLOBAL): BOOL; deprecated;
function GlobalFree(hMem: HGLOBAL): HGLOBAL; deprecated;
function GlobalCompact(dwMinFree: DWORD): UINT; deprecated;
procedure GlobalFix(hMem: HGLOBAL); deprecated;
procedure GlobalUnfix(hMem: HGLOBAL); deprecated;
function GlobalWire(hMem: HGLOBAL): IntPtr; deprecated;
function GlobalUnWire(hMem: HGLOBAL): BOOL; deprecated;
procedure GlobalMemoryStatus(out lpBuffer: TMemoryStatus); deprecated;

                                           

type
  _PROCESS_HEAP_ENTRY = record
    lpData: IntPtr;
    cbData: DWORD;
    cbOverhead: Byte;
    iRegionIndex: Byte;
    wFlags: Word;
    case Integer of
      0: (
        hMem: THandle);
      1: (
        dwCommittedSize: DWORD;
        dwUnCommittedSize: DWORD;
        lpFirstBlock: IntPtr;
        lpLastBlock: IntPtr);
  end;
  TProcessHeapEntry = _PROCESS_HEAP_ENTRY;
  PROCESS_HEAP_ENTRY = _PROCESS_HEAP_ENTRY;

const
  PROCESS_HEAP_REGION = 1;
  PROCESS_HEAP_UNCOMMITTED_RANGE = 2;
  PROCESS_HEAP_ENTRY_BUSY = 4;
  PROCESS_HEAP_ENTRY_MOVEABLE = $10;
  PROCESS_HEAP_ENTRY_DDESHARE = $20;

                                           

{ GetBinaryType return values.}

const
  SCS_32BIT_BINARY = 0;
  SCS_DOS_BINARY = 1;
  SCS_WOW_BINARY = 2;
  SCS_PIF_BINARY = 3;
  SCS_POSIX_BINARY = 4;
  SCS_OS216_BINARY = 5;


function GetBinaryType(lpApplicationName: string; out lpBinaryType: DWORD): BOOL;
function GetBinaryTypeA(lpApplicationName: string; out lpBinaryType: DWORD): BOOL;
function GetBinaryTypeW(lpApplicationName: string; out lpBinaryType: DWORD): BOOL;
function GetShortPathName(lpszLongPath: string; lpszShortPath: StringBuilder;
  cchBuffer: DWORD): DWORD;
function GetShortPathNameA(lpszLongPath: string; lpszShortPath: StringBuilder;
  cchBuffer: DWORD): DWORD;
function GetShortPathNameW(lpszLongPath: string; lpszShortPath: StringBuilder;
  cchBuffer: DWORD): DWORD;
function GetProcessAffinityMask(hProcess: THandle;
  out lpProcessAffinityMask, lpSystemAffinityMask: DWORD): BOOL;
function SetProcessAffinityMask(hProcess: THandle;
  dwProcessAffinityMask: DWORD): BOOL;
function GetProcessTimes(hProcess: THandle;
  out lpCreationTime, lpExitTime, lpKernelTime, lpUserTime: TFileTime): BOOL;
function GetProcessWorkingSetSize(hProcess: THandle;
  out lpMinimumWorkingSetSize, lpMaximumWorkingSetSize: DWORD): BOOL;
function SetProcessWorkingSetSize(hProcess: THandle;
  dwMinimumWorkingSetSize, dwMaximumWorkingSetSize: DWORD): BOOL;
function OpenProcess(dwDesiredAccess: DWORD; bInheritHandle: BOOL; dwProcessId: DWORD): THandle;
function GetCurrentProcess: THandle;
function GetCurrentProcessId: DWORD;
procedure ExitProcess(uExitCode: UINT);
function TerminateProcess(hProcess: THandle; uExitCode: UINT): BOOL;
function GetExitCodeProcess(hProcess: THandle; out lpExitCode: DWORD): BOOL;
procedure FatalExit(ExitCode: Integer);
function GetEnvironmentStrings: IntPtr;
function GetEnvironmentStringsA: IntPtr;
function GetEnvironmentStringsW: IntPtr;
function FreeEnvironmentStrings(EnvBlock: string): BOOL;
function FreeEnvironmentStringsA(EnvBlock: string): BOOL;
function FreeEnvironmentStringsW(EnvBlock: string): BOOL;
procedure RaiseException(dwExceptionCode, dwExceptionFlags, nNumberOfArguments: DWORD;
  [in] lpArguments: TBytes);
function UnhandledExceptionFilter(const ExceptionInfo: TExceptionPointers): Longint;
function CreateFiber(dwStackSize: DWORD; lpStartAddress: TFNFiberStartRoutine;
  lpParameter: IntPtr): BOOL;
function DeleteFiber(lpFiber: IntPtr): BOOL;
function ConvertThreadToFiber(lpParameter: IntPtr): BOOL;
function SwitchToFiber(lpFiber: IntPtr): BOOL;
function SwitchToThread: BOOL;

type
  TFNTopLevelExceptionFilter = function ([in] var ExceptionInfo: TExceptionPointers): Longint;

function SetUnhandledExceptionFilter(lpTopLevelExceptionFilter: TFNTopLevelExceptionFilter):
  TFNTopLevelExceptionFilter;
function CreateThread(lpThreadAttributes: IntPtr;
  dwStackSize: DWORD; lpStartAddress: TFNThreadStartRoutine;
  lpParameter: IntPtr; dwCreationFlags: DWORD; out lpThreadId: DWORD): THandle; overload;
function CreateThread(const lpThreadAttributes: TSecurityAttributes;
  dwStackSize: DWORD; lpStartAddress: TFNThreadStartRoutine;
  lpParameter: IntPtr; dwCreationFlags: DWORD; out lpThreadId: DWORD): THandle; overload;
function CreateRemoteThread(hProcess: THandle; const lpThreadAttributes: TSecurityAttributes;
  dwStackSize: DWORD; lpStartAddress: TFNThreadStartRoutine; lpParameter: IntPtr;
  dwCreationFlags: DWORD; out lpThreadId: DWORD): THandle; overload;
function CreateRemoteThread(hProcess: THandle; lpThreadAttributes: IntPtr;
  dwStackSize: DWORD; lpStartAddress: TFNThreadStartRoutine; lpParameter: IntPtr;
  dwCreationFlags: DWORD; out lpThreadId: DWORD): THandle; overload;
function GetCurrentThread: THandle;
function GetCurrentThreadId: DWORD;
function SetThreadAffinityMask(hThread: THandle; dwThreadAffinityMask: DWORD): DWORD;
function SetThreadIdealProcessor(hThread: THandle; dwIdealProcessor: DWORD): BOOL;
function SetProcessPriorityBoost(hThread: THandle; DisablePriorityBoost: Bool): BOOL;
function GetProcessPriorityBoost(hThread: THandle; out DisablePriorityBoost: Bool): BOOL;
function SetThreadPriority(hThread: THandle; nPriority: Integer): BOOL;
function GetThreadPriority(hThread: THandle): Integer;
function SetThreadPriorityBoost(hThread: THandle; DisablePriorityBoost: Bool): BOOL;
function GetThreadPriorityBoost(hThread: THandle; out DisablePriorityBoost: Bool): BOOL;
function GetThreadTimes(hThread: THandle;
  out lpCreationTime, lpExitTime, lpKernelTime, lpUserTime: TFileTime): BOOL;
procedure ExitThread(dwExitCode: DWORD);
function TerminateThread(hThread: THandle; dwExitCode: DWORD): BOOL;
function GetExitCodeThread(hThread: THandle; out lpExitCode: DWORD): BOOL;
function GetThreadSelectorEntry(hThread: THandle; dwSelector: DWORD;
  out lpSelectorEntry: TLDTEntry): BOOL;
function GetLastError: DWORD;
procedure SetLastError(dwErrCode: DWORD);
function GetOverlappedResult(hFile: THandle; const lpOverlapped: TOverlapped;
  out lpNumberOfBytesTransferred: DWORD; bWait: BOOL): BOOL;
function CreateIoCompletionPort(FileHandle, ExistingCompletionPort: THandle;
  CompletionKey, NumberOfConcurrentThreads: DWORD): THandle;
function GetQueuedCompletionStatus(CompletionPort: THandle;
  out lpNumberOfBytesTransferred, lpCompletionKey: DWORD;
  out lpOverlapped: IntPtr; dwMilliseconds: DWORD): BOOL;
function PostQueuedCompletionStatus(CompletionPort: THandle; dwNumberOfBytesTransferred: DWORD;
  dwCompletionKey: DWORD; lpOverlapped: IntPtr): BOOL;

const
  SEM_FAILCRITICALERRORS = 1;
  SEM_NOGPFAULTERRORBOX = 2;
  SEM_NOALIGNMENTFAULTEXCEPT = 4;
  SEM_NOOPENFILEERRORBOX = $8000;

function SetErrorMode(uMode: UINT): UINT;
function ReadProcessMemory(hProcess: THandle; const lpBaseAddress: IntPtr; lpBuffer: IntPtr;
  nSize: DWORD; out lpNumberOfBytesRead: DWORD): BOOL;
function WriteProcessMemory(hProcess: THandle; const lpBaseAddress: IntPtr; lpBuffer: IntPtr;
  nSize: DWORD; out lpNumberOfBytesWritten: DWORD): BOOL;
function GetThreadContext(hThread: THandle; var lpContext: TContext): BOOL;
function SetThreadContext(hThread: THandle; const lpContext: TContext): BOOL;
function SuspendThread(hThread: THandle): DWORD;
function ResumeThread(hThread: THandle): DWORD;

type
  TFNAPCProc = procedure (dwParam: DWORD);

function QueueUserAPC(pfnAPC: TFNAPCProc; hThread: THandle; dwData: DWORD): BOOL;
procedure DebugBreak;
function WaitForDebugEvent(lpDebugEvent: IntPtr; dwMilliseconds: DWORD): BOOL;
function ContinueDebugEvent(dwProcessId, dwThreadId, dwContinueStatus: DWORD): BOOL;
function DebugActiveProcess(dwProcessId: DWORD): BOOL;
{$IFNDEF LINUXCRITSECTION}
procedure InitializeCriticalSection(out lpCriticalSection: TRTLCriticalSection);
procedure EnterCriticalSection(var lpCriticalSection: TRTLCriticalSection);
procedure LeaveCriticalSection(var lpCriticalSection: TRTLCriticalSection);
function InitializeCriticalSectionAndSpinCount(var lpCriticalSection: TRTLCriticalSection; dwSpinCount: DWORD): BOOL;
function SetCriticalSectionSpinCount(var lpCriticalSection: TRTLCriticalSection; dwSpinCount: DWORD): DWORD;
function TryEnterCriticalSection(var lpCriticalSection: TRTLCriticalSection): BOOL;
procedure DeleteCriticalSection(var lpCriticalSection: TRTLCriticalSection);
{$ENDIF}
function SetEvent(hEvent: THandle): BOOL;
function ResetEvent(hEvent: THandle): BOOL;
function PulseEvent(hEvent: THandle): BOOL;
function ReleaseSemaphore(hSemaphore: THandle; lReleaseCount: Longint;
  out lpPreviousCount: LongInt): BOOL; overload;
function ReleaseSemaphore(hSemaphore: THandle; lReleaseCount: Longint;
  lpPreviousCount: IntPtr): BOOL; overload;
function ReleaseMutex(hMutex: THandle): BOOL;
function WaitForSingleObject(hHandle: THandle; dwMilliseconds: DWORD): DWORD;
                               
type
  TWOHandleArray = array[0..MAXIMUM_WAIT_OBJECTS - 1] of THandle;

function WaitForMultipleObjects(nCount: DWORD; [in] lpHandles: array of THandle;
  bWaitAll: BOOL; dwMilliseconds: DWORD): DWORD;
procedure Sleep(dwMilliseconds: DWORD);
function LoadResource(hModule: HINST; hResInfo: HRSRC): HGLOBAL;
function SizeofResource(hModule: HINST; hResInfo: HRSRC): DWORD;
function GlobalDeleteAtom(nAtom: ATOM): ATOM;
function InitAtomTable(nSize: DWORD): BOOL;
function DeleteAtom(nAtom: ATOM): ATOM;
function SetHandleCount(uNumber: UINT): UINT;
function GetLogicalDrives: DWORD;
function LockFile(hFile: THandle; dwFileOffsetLow, dwFileOffsetHigh: DWORD;
  nNumberOfBytesToLockLow, nNumberOfBytesToLockHigh: DWORD): BOOL;
function UnlockFile(hFile: THandle; dwFileOffsetLow, dwFileOffsetHigh: DWORD;
  nNumberOfBytesToUnlockLow, nNumberOfBytesToUnlockHigh: DWORD): BOOL;
function LockFileEx(hFile: THandle; dwFlags, dwReserved: DWORD;
  nNumberOfBytesToLockLow, nNumberOfBytesToLockHigh: DWORD;
  const lpOverlapped: TOverlapped): BOOL;

const
  LOCKFILE_FAIL_IMMEDIATELY = 1;
  LOCKFILE_EXCLUSIVE_LOCK = 2;

function UnlockFileEx(hFile: THandle; dwReserved, nNumberOfBytesToUnlockLow: DWORD;
  nNumberOfBytesToUnlockHigh: DWORD; const lpOverlapped: TOverlapped): BOOL;

type
  [StructLayout(LayoutKind.Sequential)]
  _BY_HANDLE_FILE_INFORMATION = record
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    dwVolumeSerialNumber: DWORD;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
    nNumberOfLinks: DWORD;
    nFileIndexHigh: DWORD;
    nFileIndexLow: DWORD;
  end;
  TByHandleFileInformation = _BY_HANDLE_FILE_INFORMATION;
  BY_HANDLE_FILE_INFORMATION = _BY_HANDLE_FILE_INFORMATION;

function GetFileInformationByHandle(hFile: THandle; out lpFileInformation: TByHandleFileInformation): BOOL;
function GetFileType(hFile: THandle): DWORD;
function GetFileSize(hFile: THandle; out lpFileSizeHigh: DWORD): DWORD; overload;
function GetFileSize(hFile: THandle; lpFileSizeHigh: IntPtr): DWORD; overload;
function GetStdHandle(nStdHandle: DWORD): THandle;
function SetStdHandle(nStdHandle: DWORD; hHandle: THandle): BOOL;
function WriteFile(hFile: THandle; [in] Buffer: TBytes; nNumberOfBytesToWrite: DWORD;
  out lpNumberOfBytesWritten: DWORD; const lpOverlapped: TOverlapped): BOOL; overload;
function WriteFile(hFile: THandle; [in] Buffer: TBytes; nNumberOfBytesToWrite: DWORD;
  lpNumberOfBytesWritten: IntPtr; lpOverlapped: IntPtr): BOOL; overload;
function WriteFile(hFile: THandle; [in] Buffer: TBytes; nNumberOfBytesToWrite: DWORD;
  out lpNumberOfBytesWritten: DWORD; lpOverlapped: IntPtr): BOOL; overload;
function WriteFile(hFile: THandle; [in] Buffer: TBytes; nNumberOfBytesToWrite: DWORD;
  lpNumberOfBytesWritten: IntPtr; const lpOverlapped: TOverlapped): BOOL; overload;
function ReadFile(hFile: THandle; [out] Buffer: TBytes; nNumberOfBytesToRead: DWORD;
  out lpNumberOfBytesRead: DWORD; const lpOverlapped: TOverlapped): BOOL; overload;
function ReadFile(hFile: THandle; [out] Buffer: TBytes; nNumberOfBytesToRead: DWORD;
  lpNumberOfBytesRead: IntPtr; lpOverlapped: IntPtr): BOOL; overload;
function ReadFile(hFile: THandle; [out] Buffer: TBytes; nNumberOfBytesToRead: DWORD;
  out lpNumberOfBytesRead: DWORD; lpOverlapped: IntPtr): BOOL; overload;
function ReadFile(hFile: THandle; [out] Buffer: TBytes; nNumberOfBytesToRead: DWORD;
  lpNumberOfBytesRead: IntPtr; const lpOverlapped: TOverlapped): BOOL; overload;
function FlushFileBuffers(hFile: THandle): BOOL;
function DeviceIoControl(hDevice: THandle; dwIoControlCode: DWORD; lpInBuffer: IntPtr;
  nInBufferSize: DWORD; lpOutBuffer: IntPtr; nOutBufferSize: DWORD;
  out lpBytesReturned: DWORD; const lpOverlapped: TOverlapped): BOOL; overload;
function DeviceIoControl(hDevice: THandle; dwIoControlCode: DWORD; lpInBuffer: IntPtr;
  nInBufferSize: DWORD; lpOutBuffer: IntPtr; nOutBufferSize: DWORD;
  out lpBytesReturned: DWORD; lpOverlapped: IntPtr): BOOL; overload;
function SetEndOfFile(hFile: THandle): BOOL;
function SetFilePointer(hFile: THandle; lDistanceToMove: Longint;
  [in] var lpDistanceToMoveHigh: LongInt; dwMoveMethod: DWORD): DWORD; overload;
function SetFilePointer(hFile: THandle; lDistanceToMove: Longint;
  lpDistanceToMoveHigh: IntPtr; dwMoveMethod: DWORD): DWORD; overload;
function FindClose(hFindFile: THandle): BOOL;

function GetFileTime(hFile: THandle; out lpCreationTime: TFileTime;
  out lpLastAccessTime: TFileTime; out lpLastWriteTime: TFileTime): BOOL; overload;
function GetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  lpLastAccessTime: IntPtr; lpLastWriteTime: IntPtr): BOOL; overload;
function GetFileTime(hFile: THandle; out lpCreationTime: TFileTime;
  lpLastAccessTime: IntPtr; lpLastWriteTime: IntPtr): BOOL; overload;
function GetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  out lpLastAccessTime: TFileTime; out lpLastWriteTime: TFileTime): BOOL; overload;
function GetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  out lpLastAccessTime: TFileTime; lpLastWriteTime: IntPtr): BOOL; overload;
function GetFileTime(hFile: THandle; out lpCreationTime: TFileTime;
  lpLastAccessTime: IntPtr; out lpLastWriteTime: TFileTime): BOOL; overload;
function GetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  lpLastAccessTime: IntPtr; out lpLastWriteTime: TFileTime): BOOL; overload;
function GetFileTime(hFile: THandle; out lpCreationTime: TFileTime;
  out lpLastAccessTime: TFileTime; lpLastWriteTime: IntPtr): BOOL; overload;

function SetFileTime(hFile: THandle; const lpCreationTime: TFileTime;
  const lpLastAccessTime: TFileTime; const lpLastWriteTime: TFileTime): BOOL; overload;
function SetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  lpLastAccessTime: IntPtr; lpLastWriteTime: IntPtr): BOOL; overload;
function SetFileTime(hFile: THandle; const lpCreationTime: TFileTime;
  lpLastAccessTime: IntPtr; lpLastWriteTime: IntPtr): BOOL; overload;
function SetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  const lpLastAccessTime: TFileTime; const lpLastWriteTime: TFileTime): BOOL; overload;
function SetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  const lpLastAccessTime: TFileTime; lpLastWriteTime: IntPtr): BOOL; overload;
function SetFileTime(hFile: THandle; const lpCreationTime: TFileTime;
  lpLastAccessTime: IntPtr; const lpLastWriteTime: TFileTime): BOOL; overload;
function SetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  lpLastAccessTime: IntPtr; const lpLastWriteTime: TFileTime): BOOL; overload;
function SetFileTime(hFile: THandle; const lpCreationTime: TFileTime;
  const lpLastAccessTime: TFileTime; lpLastWriteTime: IntPtr): BOOL; overload;

function CloseHandle(hObject: THandle): BOOL;
function DuplicateHandle(hSourceProcessHandle, hSourceHandle, hTargetProcessHandle: THandle;
  out lpTargetHandle: THandle; dwDesiredAccess: DWORD;
  bInheritHandle: BOOL; dwOptions: DWORD): BOOL; overload;
function DuplicateHandle(hSourceProcessHandle, hSourceHandle, hTargetProcessHandle: THandle;
  lpTargetHandle: IntPtr; dwDesiredAccess: DWORD;
  bInheritHandle: BOOL; dwOptions: DWORD): BOOL; overload;
function GetHandleInformation(hObject: THandle; out lpdwFlags: DWORD): BOOL;
function SetHandleInformation(hObject: THandle; dwMask: DWORD; dwFlags: DWORD): BOOL;

const
  HANDLE_FLAG_INHERIT = 1;
  HANDLE_FLAG_PROTECT_FROM_CLOSE = 2;
  HINSTANCE_ERROR = $20;

function LoadModule(lpModuleName: string; lpParameterBlock: IntPtr): DWORD;
function WinExec(lpCmdLine: string; uCmdShow: UINT): UINT;
function ClearCommBreak(hFile: THandle): BOOL;
function ClearCommError(hFile: THandle; out lpErrors: DWORD;
  out lpStat: TComStat): BOOL; overload;
function ClearCommError(hFile: THandle; out lpErrors: DWORD;
  lpStat: IntPtr): BOOL; overload;
function SetupComm(hFile: THandle; dwInQueue, dwOutQueue: DWORD): BOOL;
function EscapeCommFunction(hFile: THandle; dwFunc: DWORD): BOOL;
function GetCommConfig(hCommDev: THandle; out lpCC: TCommConfig; var lpdwSize: DWORD): BOOL;
function GetCommMask(hFile: THandle; out lpEvtMask: DWORD): BOOL;
function GetCommProperties(hFile: THandle; out lpCommProp: TCommProp): BOOL;
function GetCommModemStatus(hFile: THandle; out lpModemStat: DWORD): BOOL;
function GetCommState(hFile: THandle; out lpDCB: TDCB): BOOL;
function GetCommTimeouts(hFile: THandle; out lpCommTimeouts: TCommTimeouts): BOOL;
function PurgeComm(hFile: THandle; dwFlags: DWORD): BOOL;
function SetCommBreak(hFile: THandle): BOOL;
function SetCommConfig(hCommDev: THandle; const lpCC: TCommConfig; dwSize: DWORD): BOOL;
function SetCommMask(hFile: THandle; dwEvtMask: DWORD): BOOL;
function SetCommState(hFile: THandle; const lpDCB: TDCB): BOOL;
function SetCommTimeouts(hFile: THandle; const lpCommTimeouts: TCommTimeouts): BOOL;
function TransmitCommChar(hFile: THandle; cChar: CHAR): BOOL;
function WaitCommEvent(hFile: THandle; out lpEvtMask: DWORD;
  const lpOverlapped: TOverlapped): BOOL; overload;
function WaitCommEvent(hFile: THandle; out lpEvtMask: DWORD;
  lpOverlapped: IntPtr): BOOL; overload;
function SetTapePosition(hDevice: THandle; dwPositionMethod, dwPartition: DWORD;
  dwOffsetLow, dwOffsetHigh: DWORD; bImmediate: BOOL): DWORD;
function GetTapePosition(hDevice: THandle; dwPositionType: DWORD;
  out lpdwPartition, lpdwOffsetLow, lpdwOffsetHigh: DWORD): DWORD; overload;
function GetTapePosition(hDevice: THandle; dwPositionType: DWORD;
  out lpdwPartition, lpdwOffsetLow: DWORD; lpdwOffsetHigh: IntPtr): DWORD; overload;
function PrepareTape(hDevice: THandle; dwOperation: DWORD; bImmediate: BOOL): DWORD;
function EraseTape(hDevice: THandle; dwEraseType: DWORD; bImmediate: BOOL): DWORD;
function CreateTapePartition(hDevice: THandle; dwPartitionMethod, dwCount, dwSize: DWORD): DWORD;
function WriteTapemark(hDevice: THandle;
  dwTapemarkType, dwTapemarkCount: DWORD; bImmediate: BOOL): DWORD;
function GetTapeStatus(hDevice: THandle): DWORD;
function GetTapeParameters(hDevice: THandle; dwOperation: DWORD;
  out lpdwSize: DWORD; lpTapeInformation: IntPtr): DWORD;

const
  GET_TAPE_MEDIA_INFORMATION = 0;
  GET_TAPE_DRIVE_INFORMATION = 1;

function SetTapeParameters(hDevice: THandle; dwOperation: DWORD; lpTapeInformation: IntPtr): DWORD;

const
  SET_TAPE_MEDIA_INFORMATION = 0;
  SET_TAPE_DRIVE_INFORMATION = 1;

function Beep(dwFreq, dwDuration: DWORD): BOOL;
function MulDiv(nNumber, nNumerator, nDenominator: Integer): Integer;
procedure GetSystemTime(out lpSystemTime: TSystemTime);
procedure GetSystemTimeAsFileTime(out lpSystemTimeAsFileTime: TFileTime);
function SetSystemTime(const lpSystemTime: TSystemTime): BOOL;
procedure GetLocalTime(out lpSystemTime: TSystemTime);
function SetLocalTime(const lpSystemTime: TSystemTime): BOOL;
procedure GetSystemInfo(out lpSystemInfo: TSystemInfo);
function IsProcessorFeaturePresent(ProcessorFeature: DWORD): BOOL;


type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _TIME_ZONE_INFORMATION = record
    Bias: Longint;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=32)]
    StandardName: string;
    StandardDate: TSystemTime;
    StandardBias: Longint;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=32)]
    DaylightName: string;
    DaylightDate: TSystemTime;
    DaylightBias: Longint;
  end;
  TTimeZoneInformation = _TIME_ZONE_INFORMATION;
  TIME_ZONE_INFORMATION = _TIME_ZONE_INFORMATION;

function SystemTimeToTzSpecificLocalTime(const lpTimeZoneInformation: TTimeZoneInformation;
  const lpUniversalTime: TSystemTime; out lpLocalTime: TSystemTime): BOOL; overload;
function SystemTimeToTzSpecificLocalTime(lpTimeZoneInformation: IntPtr;
  const lpUniversalTime: TSystemTime; out lpLocalTime: TSystemTime): BOOL; overload;
function GetTimeZoneInformation(out lpTimeZoneInformation: TTimeZoneInformation): DWORD;
function SetTimeZoneInformation(const lpTimeZoneInformation: TTimeZoneInformation): BOOL;

{ Routines to convert back and forth between system time and file time }

function SystemTimeToFileTime(const lpSystemTime: TSystemTime; out lpFileTime: TFileTime): BOOL;
function FileTimeToLocalFileTime(const lpFileTime: TFileTime; out lpLocalFileTime: TFileTime): BOOL;
function LocalFileTimeToFileTime(const lpLocalFileTime: TFileTime; out lpFileTime: TFileTime): BOOL;
function FileTimeToSystemTime(const lpFileTime: TFileTime; out lpSystemTime: TSystemTime): BOOL;
function CompareFileTime(const lpFileTime1, lpFileTime2: TFileTime): Longint;
function FileTimeToDosDateTime(const lpFileTime: TFileTime;
  out lpFatDate, lpFatTime: Word): BOOL;
function DosDateTimeToFileTime(wFatDate, wFatTime: Word; out lpFileTime: TFileTime): BOOL;
function GetTickCount: DWORD;
function SetSystemTimeAdjustment(dwTimeAdjustment: DWORD; bTimeAdjustmentDisabled: BOOL): BOOL;
function GetSystemTimeAdjustment(var{out} lpTimeAdjustment, lpTimeIncrement: DWORD;
  var lpTimeAdjustmentDisabled: BOOL): BOOL;
function FormatMessage(dwFlags: DWORD; lpSource: IntPtr; dwMessageId: DWORD; dwLanguageId: DWORD;
  lpBuffer: StringBuilder; nSize: DWORD; Arguments: IntPtr): DWORD;
function FormatMessageA(dwFlags: DWORD; lpSource: IntPtr; dwMessageId: DWORD; dwLanguageId: DWORD;
  lpBuffer: StringBuilder; nSize: DWORD; Arguments: IntPtr): DWORD;
function FormatMessageW(dwFlags: DWORD; lpSource: IntPtr; dwMessageId: DWORD; dwLanguageId: DWORD;
  lpBuffer: StringBuilder; nSize: DWORD; Arguments: IntPtr): DWORD;

const
  FORMAT_MESSAGE_ALLOCATE_BUFFER = $100;
  FORMAT_MESSAGE_IGNORE_INSERTS = $200;
  FORMAT_MESSAGE_FROM_STRING = $400;
  FORMAT_MESSAGE_FROM_HMODULE = $800;
  FORMAT_MESSAGE_FROM_SYSTEM = $1000;
  FORMAT_MESSAGE_ARGUMENT_ARRAY = $2000;
  FORMAT_MESSAGE_MAX_WIDTH_MASK = 255;

function CreatePipe(out hReadPipe, hWritePipe: THandle;
  const lpPipeAttributes: TSecurityAttributes; nSize: DWORD): BOOL; overload;
function CreatePipe(out hReadPipe, hWritePipe: THandle;
  lpPipeAttributes: IntPtr; nSize: DWORD): BOOL; overload;
function ConnectNamedPipe(hNamedPipe: THandle; const lpOverlapped: TOverlapped): BOOL; overload;
function ConnectNamedPipe(hNamedPipe: THandle; lpOverlapped: IntPtr): BOOL; overload;
function DisconnectNamedPipe(hNamedPipe: THandle): BOOL;

function SetNamedPipeHandleState(hNamedPipe: THandle; [in] var lpMode: DWORD;
  [in] var lpMaxCollectionCount: DWORD; [in] var lpCollectDataTimeout: DWORD): BOOL; overload;
function SetNamedPipeHandleState(hNamedPipe: THandle; lpMode: IntPtr;
  lpMaxCollectionCount: IntPtr; lpCollectDataTimeout: IntPtr): BOOL; overload;
function SetNamedPipeHandleState(hNamedPipe: THandle; [in] var lpMode: DWORD;
  lpMaxCollectionCount: IntPtr; lpCollectDataTimeout: IntPtr): BOOL; overload;
function SetNamedPipeHandleState(hNamedPipe: THandle; lpMode: IntPtr;
  [in] var lpMaxCollectionCount: DWORD; [in] var lpCollectDataTimeout: DWORD): BOOL; overload;
function SetNamedPipeHandleState(hNamedPipe: THandle; lpMode: IntPtr;
  [in] var lpMaxCollectionCount: DWORD; lpCollectDataTimeout: IntPtr): BOOL; overload;
function SetNamedPipeHandleState(hNamedPipe: THandle; [in] var lpMode: DWORD;
  lpMaxCollectionCount: IntPtr; [in] var lpCollectDataTimeout: DWORD): BOOL; overload;
function SetNamedPipeHandleState(hNamedPipe: THandle; lpMode: IntPtr;
  lpMaxCollectionCount: IntPtr; [in] var lpCollectDataTimeout: DWORD): BOOL; overload;
function SetNamedPipeHandleState(hNamedPipe: THandle; [in] var lpMode: DWORD;
  [in] var lpMaxCollectionCount: DWORD; lpCollectDataTimeout: IntPtr): BOOL; overload;

function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  out lpOutBufferSize: DWORD; out lpInBufferSize: DWORD;
  out lpMaxInstances: DWORD): BOOL; overload;
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  lpOutBufferSize: IntPtr; lpInBufferSize: IntPtr;
  lpMaxInstances: IntPtr): BOOL; overload;
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  lpOutBufferSize: IntPtr; out lpInBufferSize: DWORD;
  out lpMaxInstances: DWORD): BOOL; overload;
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  out lpOutBufferSize: DWORD; lpInBufferSize: IntPtr;
  lpMaxInstances: IntPtr): BOOL; overload;
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  out lpOutBufferSize: DWORD; lpInBufferSize: IntPtr;
  out lpMaxInstances: DWORD): BOOL; overload;
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  lpOutBufferSize: IntPtr; out lpInBufferSize: DWORD;
  lpMaxInstances: IntPtr): BOOL; overload;
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  out lpOutBufferSize: DWORD; out lpInBufferSize: DWORD;
  lpMaxInstances: IntPtr): BOOL; overload;
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  lpOutBufferSize: IntPtr; lpInBufferSize: IntPtr;
  out lpMaxInstances: DWORD): BOOL; overload;

function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; out lpBytesRead: DWORD; out lpTotalBytesAvail: DWORD;
  out lpBytesLeftThisMessage: DWORD): BOOL; overload;
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; lpBytesRead: IntPtr; lpTotalBytesAvail: IntPtr;
  lpBytesLeftThisMessage: IntPtr): BOOL; overload;
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; lpBytesRead: IntPtr; out lpTotalBytesAvail: DWORD;
  out lpBytesLeftThisMessage: DWORD): BOOL; overload;
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; out lpBytesRead: DWORD; lpTotalBytesAvail: IntPtr;
  lpBytesLeftThisMessage: IntPtr): BOOL; overload;
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; out lpBytesRead: DWORD; lpTotalBytesAvail: IntPtr;
  out lpBytesLeftThisMessage: DWORD): BOOL; overload;
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; lpBytesRead: IntPtr; out lpTotalBytesAvail: DWORD;
  lpBytesLeftThisMessage: IntPtr): BOOL; overload;
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; out lpBytesRead: DWORD; out lpTotalBytesAvail: DWORD;
  lpBytesLeftThisMessage: IntPtr): BOOL; overload;
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; lpBytesRead: IntPtr; lpTotalBytesAvail: IntPtr;
  out lpBytesLeftThisMessage: DWORD): BOOL; overload;

function TransactNamedPipe(hNamedPipe: THandle; [in] lpInBuffer: TBytes;
  nInBufferSize: DWORD; [out] lpOutBuffer: TBytes; nOutBufferSize: DWORD;
  out lpBytesRead: DWORD; const lpOverlapped: TOverlapped): BOOL; overload;
function TransactNamedPipe(hNamedPipe: THandle; [in] lpInBuffer: TBytes;
  nInBufferSize: DWORD; [out] lpOutBuffer: TBytes; nOutBufferSize: DWORD;
  out lpBytesRead: DWORD; lpOverlapped: IntPtr): BOOL; overload;

function CreateMailslot(lpName: string; nMaxMessageSize: DWORD;
  lReadTimeout: DWORD; const lpSecurityAttributes: TSecurityAttributes): THandle; overload;
function CreateMailslot(lpName: string; nMaxMessageSize: DWORD;
  lReadTimeout: DWORD; lpSecurityAttributes: IntPtr): THandle; overload;
function CreateMailslotA(lpName: string; nMaxMessageSize: DWORD;
  lReadTimeout: DWORD; const lpSecurityAttributes: TSecurityAttributes): THandle;
function CreateMailslotW(lpName: string; nMaxMessageSize: DWORD;
  lReadTimeout: DWORD; const lpSecurityAttributes: TSecurityAttributes): THandle;

function GetMailslotInfo(hMailslot: THandle; [in] var lpMaxMessageSize: DWORD;
  [in] var lpNextSize: DWORD; [in] var lpMessageCount: DWORD;
  [in] var lpReadTimeout: DWORD): BOOL; overload;
function GetMailslotInfo(hMailslot: THandle; lpMaxMessageSize: IntPtr;
  [in] var lpNextSize: DWORD; lpMessageCount: IntPtr;
  lpReadTimeout: IntPtr): BOOL; overload;
function GetMailslotInfo(hMailslot: THandle; lpMaxMessageSize: IntPtr;
  [in] var lpNextSize: DWORD; [in] var lpMessageCount: DWORD;
  [in] var lpReadTimeout: DWORD): BOOL; overload;
function GetMailslotInfo(hMailslot: THandle; [in] var lpMaxMessageSize: DWORD;
  [in] var lpNextSize: DWORD; lpMessageCount: IntPtr;
  lpReadTimeout: IntPtr): BOOL; overload;
function GetMailslotInfo(hMailslot: THandle; [in] var lpMaxMessageSize: DWORD;
  [in] var lpNextSize: DWORD; lpMessageCount: IntPtr;
  [in] var lpReadTimeout: DWORD): BOOL; overload;
function GetMailslotInfo(hMailslot: THandle; lpMaxMessageSize: IntPtr;
  [in] var lpNextSize: DWORD; [in] var lpMessageCount: DWORD;
  lpReadTimeout: IntPtr): BOOL; overload;
function GetMailslotInfo(hMailslot: THandle; [in] var lpMaxMessageSize: DWORD;
  [in] var lpNextSize: DWORD; [in] var lpMessageCount: DWORD;
  lpReadTimeout: IntPtr): BOOL; overload;
function GetMailslotInfo(hMailslot: THandle; lpMaxMessageSize: IntPtr;
  [in] var lpNextSize: DWORD; lpMessageCount: IntPtr;
  [in] var lpReadTimeout: DWORD): BOOL; overload;

function SetMailslotInfo(hMailslot: THandle; lReadTimeout: DWORD): BOOL;
function MapViewOfFile(hFileMappingObject: THandle; dwDesiredAccess: DWORD;
  dwFileOffsetHigh, dwFileOffsetLow, dwNumberOfBytesToMap: DWORD): IntPtr;
function FlushViewOfFile(const lpBaseAddress: IntPtr; dwNumberOfBytesToFlush: DWORD): BOOL;
function UnmapViewOfFile(lpBaseAddress: IntPtr): BOOL;
function EncryptFile(lpFilename: string): BOOL;
function EncryptFileA(lpFilename: string): BOOL;
function EncryptFileW(lpFilename: string): BOOL;
function DecryptFile(lpFilename: string; dwReserved: DWORD): BOOL;
function DecryptFileA(lpFilename: string; dwReserved: DWORD): BOOL;
function DecryptFileW(lpFilename: string; dwReserved: DWORD): BOOL;

const
  { Currently defined recovery flags }
  EFS_USE_RECOVERY_KEYS = $1;

type
  TFNExportFunc = function (pbData, pvCallbackContext: IntPtr; ulLength: ULONG): DWORD;
  TFNImportFunc = function (pbData, pvCallbackContext: IntPtr; ulLength: ULONG): DWORD;

const
  { OpenRaw flag values }
  CREATE_FOR_IMPORT = 1;
  CREATE_FOR_DIR = 2;

function OpenRaw(lpFilename: string; ulFlags: ULONG; pvContext: IntPtr): DWORD;
function OpenRawA(lpFilename: string; ulFlags: ULONG; pvContext: IntPtr): DWORD;
function OpenRawW(lpFilename: string; ulFlags: ULONG; pvContext: IntPtr): DWORD;
function ReadRaw(pfExportCallback: TFNExportFunc; pvCallbackContext, pvContext: IntPtr): DWORD;
function WriteRaw(pfExportCallback: TFNImportFunc; pvCallbackContext, pvContext: IntPtr): DWORD;
procedure CloseRaw(pvContext: IntPtr);

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  _RECOVERY_AGENT_INFORMATION = record
    NextEntryOffset: DWORD;
    AgentNameLength: DWORD;
    AgentInformation: IntPtr; { array[0..0] of CHAR }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  _RECOVERY_AGENT_INFORMATIONA = record
    NextEntryOffset: DWORD;
    AgentNameLength: DWORD;
    AgentInformation: IntPtr; { array[0..0] of CHAR }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  _RECOVERY_AGENT_INFORMATIONW = record
    NextEntryOffset: DWORD;
    AgentNameLength: DWORD;
    AgentInformation: IntPtr; { array[0..0] of CHAR }
  end;
  TRecoveryAgentInformation = _RECOVERY_AGENT_INFORMATION;
  TRecoveryAgentInformationA = _RECOVERY_AGENT_INFORMATIONA;
  TRecoveryAgentInformationW = _RECOVERY_AGENT_INFORMATIONW;
  RECOVERY_AGENT_INFORMATION = _RECOVERY_AGENT_INFORMATION;
  RECOVERY_AGENT_INFORMATIONA = _RECOVERY_AGENT_INFORMATIONA;
  RECOVERY_AGENT_INFORMATIONW = _RECOVERY_AGENT_INFORMATIONW;

const
  IS_TEXT_UNICODE_ASCII16               = $0001;
  IS_TEXT_UNICODE_REVERSE_ASCII16       = $0010;
  IS_TEXT_UNICODE_STATISTICS            = $0002;
  IS_TEXT_UNICODE_REVERSE_STATISTICS    = $0020;
  IS_TEXT_UNICODE_CONTROLS              = $0004;
  IS_TEXT_UNICODE_REVERSE_CONTROLS      = $0040;
  IS_TEXT_UNICODE_SIGNATURE             = $0008;
  IS_TEXT_UNICODE_REVERSE_SIGNATURE     = $0080;
  IS_TEXT_UNICODE_ILLEGAL_CHARS         = $0100;
  IS_TEXT_UNICODE_ODD_LENGTH            = $0200;
  IS_TEXT_UNICODE_DBCS_LEADBYTE         = $0400;
  IS_TEXT_UNICODE_NULL_BYTES            = $1000;
  IS_TEXT_UNICODE_UNICODE_MASK          = $000F;
  IS_TEXT_UNICODE_REVERSE_MASK          = $00F0;
  IS_TEXT_UNICODE_NOT_UNICODE_MASK      = $0F00;
  IS_TEXT_UNICODE_NOT_ASCII_MASK        = $F000;

                                       
function QueryRecoveryAgents(p1: string; var p2: IntPtr; var p3: TRecoveryAgentInformation): DWORD;
function QueryRecoveryAgentsA(p1: string; var p2: IntPtr; var p3: TRecoveryAgentInformationA): DWORD;
function QueryRecoveryAgentsW(p1: string; var p2: IntPtr; var p3: TRecoveryAgentInformationW): DWORD;

function OpenFile(lpFileName: string; out lpReOpenBuff: TOFStruct; uStyle: UINT): HFILE;
function IsTextUnicode([in] lpBuffer: TBytes; cb: Integer; var lpi: Integer): BOOL; overload;
function IsTextUnicode([in] lpBuffer: TBytes; cb: Integer; lpi: IntPtr): BOOL; overload;
function TlsAlloc: DWORD;

const
  TLS_OUT_OF_INDEXES = DWORD($FFFFFFFF);

function TlsGetValue(dwTlsIndex: DWORD): IntPtr;
function TlsSetValue(dwTlsIndex: DWORD; lpTlsValue: IntPtr): BOOL;
function TlsFree(dwTlsIndex: DWORD): BOOL;

type
  TPROverlappedCompletionRoutine =
    procedure (dwErrorCode, dwNumberOfBytesTransfered: DWORD;
    const lpOverlapped: TOverlapped);

function SleepEx(dwMilliseconds: DWORD; bAlertable: BOOL): DWORD;
function WaitForSingleObjectEx(hHandle: THandle; dwMilliseconds: DWORD; bAlertable: BOOL): DWORD;
function WaitForMultipleObjectsEx(nCount: DWORD; [in] lpHandles: array of THandle;
  bWaitAll: BOOL; dwMilliseconds: DWORD; bAlertable: BOOL): DWORD;
function SignalObjectAndWait(hObjectToSignal: THandle; hObjectToWaitOn: THandle;
  dwMilliseconds: DWORD; bAlertable: BOOL): BOOL;
function ReadFileEx(hFile: THandle; [out] lpBuffer: TBytes; nNumberOfBytesToRead: DWORD;
  const lpOverlapped: TOverlapped; lpCompletionRoutine: TPROverlappedCompletionRoutine): BOOL;
function WriteFileEx(hFile: THandle; [in] lpBuffer: TBytes; nNumberOfBytesToWrite: DWORD;
  const lpOverlapped: TOverlapped; lpCompletionRoutine: FARPROC): BOOL;
function BackupRead(hFile: THandle; [out] lpBuffer: TBytes; nNumberOfBytesToRead: DWORD;
  out lpNumberOfBytesRead: DWORD; bAbort: BOOL;
  bProcessSecurity: BOOL; out lpContext: IntPtr): BOOL;
function BackupSeek(hFile: THandle; dwLowBytesToSeek, dwHighBytesToSeek: DWORD;
  out lpdwLowByteSeeked, lpdwHighByteSeeked: DWORD; lpContext: IntPtr): BOOL;
function BackupWrite(hFile: THandle; [in] lpBuffer: TBytes; nNumberOfBytesToWrite: DWORD;
  out lpNumberOfBytesWritten: DWORD; bAbort, bProcessSecurity: BOOL; out lpContext: IntPtr): BOOL;

type
  [StructLayout(LayoutKind.Sequential)]
  _WIN32_STREAM_ID = record
    dwStreamId: DWORD;
    dwStreamAttributes: DWORD;
    Size: TLargeInteger;
    dwStreamNameSize: DWORD;
    cStreamName: IntPtr; { array[0..0] of WCHAR }
  end;
  TWIN32StreamID = _WIN32_STREAM_ID;
  WIN32_STREAM_ID = _WIN32_STREAM_ID;

const
  { Stream IDs }
  BACKUP_INVALID = 0;
  BACKUP_DATA = 1;
  BACKUP_EA_DATA = 2;
  BACKUP_SECURITY_DATA = 3;
  BACKUP_ALTERNATE_DATA = 4;
  BACKUP_LINK = 5;
  BACKUP_PROPERTY_DATA = 6;

  { Stream Attributes}
  STREAM_NORMAL_ATTRIBUTE = 0;
  STREAM_MODIFIED_WHEN_READ = 1;
  STREAM_CONTAINS_SECURITY = 2;
  STREAM_CONTAINS_PROPERTIES = 4;

  { Dual Mode API below this line. Dual Mode Structures also included. }
  STARTF_USESHOWWINDOW = 1;
  STARTF_USESIZE = 2;
  STARTF_USEPOSITION = 4;
  STARTF_USECOUNTCHARS = 8;
  STARTF_USEFILLATTRIBUTE = $10;
  STARTF_RUNFULLSCREEN = $20;  { ignored for non-x86 platforms }
  STARTF_FORCEONFEEDBACK = $40;
  STARTF_FORCEOFFFEEDBACK = $80;
  STARTF_USESTDHANDLES = $100;
  STARTF_USEHOTKEY = $200;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  _STARTUPINFO = record
    cb: DWORD;
    lpReserved: IntPtr;
    lpDesktop: IntPtr;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpTitle: string;
    dwX: DWORD;
    dwY: DWORD;
    dwXSize: DWORD;
    dwYSize: DWORD;
    dwXCountChars: DWORD;
    dwYCountChars: DWORD;
    dwFillAttribute: DWORD;
    dwFlags: DWORD;
    wShowWindow: Word;
    cbReserved2: Word;
    lpReserved2: IntPtr;
    hStdInput: THandle;
    hStdOutput: THandle;
    hStdError: THandle;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  _STARTUPINFOA = record
    cb: DWORD;
    lpReserved: IntPtr;
    lpDesktop: IntPtr;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpTitle: string;
    dwX: DWORD;
    dwY: DWORD;
    dwXSize: DWORD;
    dwYSize: DWORD;
    dwXCountChars: DWORD;
    dwYCountChars: DWORD;
    dwFillAttribute: DWORD;
    dwFlags: DWORD;
    wShowWindow: Word;
    cbReserved2: Word;
    lpReserved2: IntPtr;
    hStdInput: THandle;
    hStdOutput: THandle;
    hStdError: THandle;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  _STARTUPINFOW = record
    cb: DWORD;
    lpReserved: IntPtr;
    lpDesktop: IntPtr;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpTitle: string;
    dwX: DWORD;
    dwY: DWORD;
    dwXSize: DWORD;
    dwYSize: DWORD;
    dwXCountChars: DWORD;
    dwYCountChars: DWORD;
    dwFillAttribute: DWORD;
    dwFlags: DWORD;
    wShowWindow: Word;
    cbReserved2: Word;
    lpReserved2: IntPtr;
    hStdInput: THandle;
    hStdOutput: THandle;
    hStdError: THandle;
  end;
  TStartupInfo = _STARTUPINFO;
  TStartupInfoA = _STARTUPINFOA;
  TStartupInfoW = _STARTUPINFOW;
  STARTUPINFO = _STARTUPINFO;
  STARTUPINFOA = _STARTUPINFOA;
  STARTUPINFOW = _STARTUPINFOW;

const
  SHUTDOWN_NORETRY = 1;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  _WIN32_FIND_DATA = record
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
    dwReserved0: DWORD;
    dwReserved1: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_PATH)]
    cFileName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=14)]
    cAlternateFileName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  _WIN32_FIND_DATAA = record
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
    dwReserved0: DWORD;
    dwReserved1: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_PATH)]
    cFileName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=14)]
    cAlternateFileName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  _WIN32_FIND_DATAW = record
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
    dwReserved0: DWORD;
    dwReserved1: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_PATH)]
    cFileName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=14)]
    cAlternateFileName: string;
  end;
  TWin32FindData = _WIN32_FIND_DATA;
  TWin32FindDataA = _WIN32_FIND_DATAA;
  TWin32FindDataW = _WIN32_FIND_DATAW;
  WIN32_FIND_DATA = _WIN32_FIND_DATA;
  WIN32_FIND_DATAA = _WIN32_FIND_DATAA;
  WIN32_FIND_DATAW = _WIN32_FIND_DATAW;

  [StructLayout(LayoutKind.Sequential)]
  _WIN32_FILE_ATTRIBUTE_DATA = record
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
  end;
  TWin32FileAttributeData = _WIN32_FILE_ATTRIBUTE_DATA;
  WIN32_FILE_ATTRIBUTE_DATA = _WIN32_FILE_ATTRIBUTE_DATA;

function CreateMutex(const lpMutexAttributes: TSecurityAttributes; bInitialOwner: BOOL; lpName: string): THandle; overload;
function CreateMutex(lpMutexAttributes: IntPtr; bInitialOwner: BOOL; lpName: string): THandle; overload;
function CreateMutexA(const lpMutexAttributes: TSecurityAttributes; bInitialOwner: BOOL; lpName: string): THandle;
function CreateMutexW(const lpMutexAttributes: TSecurityAttributes; bInitialOwner: BOOL; lpName: string): THandle;

function OpenMutex(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: string): THandle;
function OpenMutexA(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: string): THandle;
function OpenMutexW(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: string): THandle;
function CreateEvent(const lpEventAttributes: TSecurityAttributes;
  bManualReset, bInitialState: BOOL; lpName: string): THandle; overload;
function CreateEvent(lpEventAttributes: IntPtr;
  bManualReset, bInitialState: BOOL; lpName: string): THandle; overload;
function CreateEventA(const lpEventAttributes: TSecurityAttributes;
  bManualReset, bInitialState: BOOL; lpName: string): THandle;
function CreateEventW(const lpEventAttributes: TSecurityAttributes;
  bManualReset, bInitialState: BOOL; lpName: string): THandle;
function OpenEvent(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: string): THandle;
function OpenEventA(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: string): THandle;
function OpenEventW(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: string): THandle;
function CreateSemaphore(const lpSemaphoreAttributes: TSecurityAttributes;
  lInitialCount, lMaximumCount: Longint; lpName: string): THandle; overload;
function CreateSemaphore(lpSemaphoreAttributes: IntPtr;
  lInitialCount, lMaximumCount: Longint; lpName: string): THandle; overload;
function CreateSemaphoreA(const lpSemaphoreAttributes: TSecurityAttributes;
  lInitialCount, lMaximumCount: Longint; lpName: string): THandle;
function CreateSemaphoreW(const lpSemaphoreAttributes: TSecurityAttributes;
  lInitialCount, lMaximumCount: Longint; lpName: string): THandle;
function OpenSemaphore(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: string): THandle;
function OpenSemaphoreA(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: string): THandle;
function OpenSemaphoreW(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: string): THandle;

type
  TFNTimerAPCRoutine = procedure (lpArgToCompletionRoutine: IntPtr;
    dwTimerLowValue, dwTimerHighValue: DWORD);

function CreateWaitableTimer(const lpTimerAttributes: TSecurityAttributes;
  bManualReset: BOOL; lpTimerName: string): THandle; overload;
function CreateWaitableTimer(lpTimerAttributes: IntPtr;
  bManualReset: BOOL; lpTimerName: string): THandle; overload;
function CreateWaitableTimerA(const lpTimerAttributes: TSecurityAttributes;
  bManualReset: BOOL; lpTimerName: string): THandle;
function CreateWaitableTimerW(const lpTimerAttributes: TSecurityAttributes;
  bManualReset: BOOL; lpTimerName: string): THandle;
function OpenWaitableTimer(dwDesiredAccess: DWORD; bInheritHandle: BOOL;
  lpTimerName: string): THandle;
function OpenWaitableTimerA(dwDesiredAccess: DWORD; bInheritHandle: BOOL;
  lpTimerName: string): THandle;
function OpenWaitableTimerW(dwDesiredAccess: DWORD; bInheritHandle: BOOL;
  lpTimerName: string): THandle;
function SetWaitableTimer(hTimer: THandle; const lpDueTime: TLargeInteger;
  lPeriod: Longint; pfnCompletionRoutine: TFNTimerAPCRoutine;
  lpArgToCompletionRoutine: IntPtr; fResume: BOOL): BOOL;
function CancelWaitableTimer(hTimer: THandle): BOOL;
function CreateFileMapping(hFile: THandle; const lpFileMappingAttributes: TSecurityAttributes;
  flProtect, dwMaximumSizeHigh, dwMaximumSizeLow: DWORD; lpName: string): THandle; overload;
function CreateFileMapping(hFile: THandle; lpFileMappingAttributes: IntPtr;
  flProtect, dwMaximumSizeHigh, dwMaximumSizeLow: DWORD; lpName: string): THandle; overload;
function CreateFileMappingA(hFile: THandle; const lpFileMappingAttributes: TSecurityAttributes;
  flProtect, dwMaximumSizeHigh, dwMaximumSizeLow: DWORD; lpName: string): THandle;
function CreateFileMappingW(hFile: THandle; const lpFileMappingAttributes: TSecurityAttributes;
  flProtect, dwMaximumSizeHigh, dwMaximumSizeLow: DWORD; lpName: string): THandle;
function OpenFileMapping(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: string): THandle;
function OpenFileMappingA(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: string): THandle;
function OpenFileMappingW(dwDesiredAccess: DWORD; bInheritHandle: BOOL; lpName: string): THandle;
function GetLogicalDriveStrings(nBufferLength: DWORD; [out] lpBuffer: TBytes): DWORD;
function GetLogicalDriveStringsA(nBufferLength: DWORD; [out] lpBuffer: TBytes): DWORD;
function GetLogicalDriveStringsW(nBufferLength: DWORD; [out] lpBuffer: TBytes): DWORD;
function LoadLibrary(lpLibFileName: string): HMODULE;
function LoadLibraryA(lpLibFileName: string): HMODULE;
function LoadLibraryW(lpLibFileName: string): HMODULE;
function LoadLibraryEx(lpLibFileName: string; hFile: THandle; dwFlags: DWORD): HMODULE;
function LoadLibraryExA(lpLibFileName: string; hFile: THandle; dwFlags: DWORD): HMODULE;
function LoadLibraryExW(lpLibFileName: string; hFile: THandle; dwFlags: DWORD): HMODULE;

const
  DONT_RESOLVE_DLL_REFERENCES = 1;
  LOAD_LIBRARY_AS_DATAFILE = 2;
  LOAD_WITH_ALTERED_SEARCH_PATH = 8;

function GetModuleFileName(hModule: HINST; lpFilename: StringBuilder; nSize: DWORD): DWORD;
function GetModuleFileNameA(hModule: HINST; lpFilename: StringBuilder; nSize: DWORD): DWORD;
function GetModuleFileNameW(hModule: HINST; lpFilename: StringBuilder; nSize: DWORD): DWORD;
function GetModuleHandle(lpModuleName: string): HMODULE;
function GetModuleHandleA(lpModuleName: string): HMODULE;
function GetModuleHandleW(lpModuleName: string): HMODULE;

function CreateProcess(lpApplicationName: string; lpCommandLine: StringBuilder;
  const lpProcessAttributes, lpThreadAttributes: TSecurityAttributes;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: string;
  lpCurrentDirectory: string; const lpStartupInfo: TStartupInfo;
  out lpProcessInformation: TProcessInformation): BOOL; overload;
function CreateProcess(lpApplicationName: string; lpCommandLine: StringBuilder;
  lpProcessAttributes, lpThreadAttributes: IntPtr;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: string;
  lpCurrentDirectory: string; const lpStartupInfo: TStartupInfo;
  out lpProcessInformation: TProcessInformation): BOOL; overload;
function CreateProcess(lpApplicationName: string; lpCommandLine: StringBuilder;
  lpProcessAttributes: IntPtr; const lpThreadAttributes: TSecurityAttributes;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: string;
  lpCurrentDirectory: string; const lpStartupInfo: TStartupInfo;
  out lpProcessInformation: TProcessInformation): BOOL; overload;
function CreateProcess(lpApplicationName: string; lpCommandLine: StringBuilder;
  const lpProcessAttributes: TSecurityAttributes; lpThreadAttributes: IntPtr;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: string;
  lpCurrentDirectory: string; const lpStartupInfo: TStartupInfo;
  out lpProcessInformation: TProcessInformation): BOOL; overload;
function CreateProcessA(lpApplicationName: string; lpCommandLine: StringBuilder;
  const lpProcessAttributes, lpThreadAttributes: TSecurityAttributes;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: string;
  lpCurrentDirectory: string; const lpStartupInfo: TStartupInfoA;
  out lpProcessInformation: TProcessInformation): BOOL;
function CreateProcessW(lpApplicationName: string; lpCommandLine: StringBuilder;
  const lpProcessAttributes, lpThreadAttributes: TSecurityAttributes;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: string;
  lpCurrentDirectory: string; const lpStartupInfo: TStartupInfoA;
  out lpProcessInformation: TProcessInformation): BOOL;

function SetProcessShutdownParameters(dwLevel, dwFlags: DWORD): BOOL;
function GetProcessShutdownParameters(out lpdwLevel, lpdwFlags: DWORD): BOOL;
function GetProcessVersion(ProcessId: DWORD): DWORD;
procedure FatalAppExit(uAction: UINT; lpMessageText: string);
procedure FatalAppExitA(uAction: UINT; lpMessageText: string);
procedure FatalAppExitW(uAction: UINT; lpMessageText: string);
procedure GetStartupInfo(out lpStartupInfo: TStartupInfo);
procedure GetStartupInfoA(out lpStartupInfo: TStartupInfo);
procedure GetStartupInfoW(out lpStartupInfo: TStartupInfo);
function GetCommandLine: IntPtr;
function GetCommandLineA: IntPtr;
function GetCommandLineW: IntPtr;
function GetEnvironmentVariable(lpName: string; lpBuffer: StringBuilder; nSize: DWORD): DWORD; overload;
function GetEnvironmentVariableA(lpName: string; lpBuffer: StringBuilder; nSize: DWORD): DWORD;  overload;
function GetEnvironmentVariableW(lpName: string; lpBuffer: StringBuilder; nSize: DWORD): DWORD;  overload;
function SetEnvironmentVariable(lpName, lpValue: string): BOOL;
function SetEnvironmentVariableA(lpName, lpValue: string): BOOL;
function SetEnvironmentVariableW(lpName, lpValue: string): BOOL;
function ExpandEnvironmentStrings(lpSrc: string; lpDst: StringBuilder; nSize: DWORD): DWORD;
function ExpandEnvironmentStringsA(lpSrc: string; lpDst: StringBuilder; nSize: DWORD): DWORD;
function ExpandEnvironmentStringsW(lpSrc: string; lpDst: StringBuilder; nSize: DWORD): DWORD;
procedure OutputDebugString(lpOutputString: string);
procedure OutputDebugStringA(lpOutputString: string);
procedure OutputDebugStringW(lpOutputString: string);
function FindResource(hModule: HMODULE; lpName, lpType: string): HRSRC; overload;
function FindResource(hModule: HMODULE; lpName: string; lpType: Integer): HRSRC; overload;
function FindResource(hModule: HMODULE; lpName, lpType: Integer): HRSRC; overload;
function FindResource(hModule: HMODULE; lpName: Integer; lpType: string): HRSRC; overload;
function FindResourceA(hModule: HMODULE; lpName, lpType: string): HRSRC;
function FindResourceW(hModule: HMODULE; lpName, lpType: string): HRSRC;
function FindResourceEx(hModule: HMODULE; lpType, lpName: string; wLanguage: Word): HRSRC;
function FindResourceExA(hModule: HMODULE; lpType, lpName: string; wLanguage: Word): HRSRC;
function FindResourceExW(hModule: HMODULE; lpType, lpName: string; wLanguage: Word): HRSRC;

type
  ENUMRESTYPEPROC = FARPROC;
  ENUMRESNAMEPROC = FARPROC;
  ENUMRESLANGPROC = FARPROC;

function EnumResourceTypes(hModule: HMODULE; lpEnumFunc: ENUMRESTYPEPROC;
  lParam: Longint): BOOL;
function EnumResourceTypesA(hModule: HMODULE; lpEnumFunc: ENUMRESTYPEPROC;
  lParam: Longint): BOOL;
function EnumResourceTypesW(hModule: HMODULE; lpEnumFunc: ENUMRESTYPEPROC;
  lParam: Longint): BOOL;
function EnumResourceNames(hModule: HMODULE; lpType: string;
  lpEnumFunc: ENUMRESNAMEPROC; lParam: Longint): BOOL;
function EnumResourceNamesA(hModule: HMODULE; lpType: string;
  lpEnumFunc: ENUMRESNAMEPROC; lParam: Longint): BOOL;
function EnumResourceNamesW(hModule: HMODULE; lpType: string;
  lpEnumFunc: ENUMRESNAMEPROC; lParam: Longint): BOOL;
function EnumResourceLanguages(hModule: HMODULE; lpType, lpName: string;
  lpEnumFunc: ENUMRESLANGPROC; lParam: Longint): BOOL;
function EnumResourceLanguagesA(hModule: HMODULE; lpType, lpName: string;
  lpEnumFunc: ENUMRESLANGPROC; lParam: Longint): BOOL;
function EnumResourceLanguagesW(hModule: HMODULE; lpType, lpName: string;
  lpEnumFunc: ENUMRESLANGPROC; lParam: Longint): BOOL;
function BeginUpdateResource(pFileName: string; bDeleteExistingResources: BOOL): THandle;
function BeginUpdateResourceA(pFileName: string; bDeleteExistingResources: BOOL): THandle;
function BeginUpdateResourceW(pFileName: string; bDeleteExistingResources: BOOL): THandle;
function UpdateResource(hUpdate: THandle; lpType, lpName: string;
  wLanguage: Word; lpData: IntPtr; cbData: DWORD): BOOL;
function UpdateResourceA(hUpdate: THandle; lpType, lpName: string;
  wLanguage: Word; lpData: IntPtr; cbData: DWORD): BOOL;
function UpdateResourceW(hUpdate: THandle; lpType, lpName: string;
  wLanguage: Word; lpData: IntPtr; cbData: DWORD): BOOL;
function EndUpdateResource(hUpdate: THandle; fDiscard: BOOL): BOOL;
function EndUpdateResourceA(hUpdate: THandle; fDiscard: BOOL): BOOL;
function EndUpdateResourceW(hUpdate: THandle; fDiscard: BOOL): BOOL;
function GlobalAddAtom(lpString: string): ATOM;
function GlobalAddAtomA(lpString: string): ATOM;
function GlobalAddAtomW(lpString: string): ATOM;
function GlobalFindAtom(lpString: string): ATOM;
function GlobalFindAtomA(lpString: string): ATOM;
function GlobalFindAtomW(lpString: string): ATOM;
function GlobalGetAtomName(nAtom: ATOM; lpBuffer: StringBuilder; nSize: Integer): UINT;
function GlobalGetAtomNameA(nAtom: ATOM; lpBuffer: StringBuilder; nSize: Integer): UINT;
function GlobalGetAtomNameW(nAtom: ATOM; lpBuffer: StringBuilder; nSize: Integer): UINT;
function AddAtom(lpString: string): ATOM;
function AddAtomA(lpString: string): ATOM;
function AddAtomW(lpString: string): ATOM;
function FindAtom(lpString: string): ATOM;
function FindAtomA(lpString: string): ATOM;
function FindAtomW(lpString: string): ATOM;
function GetAtomName(nAtom: ATOM; lpBuffer: StringBuilder; nSize: Integer): UINT;
function GetAtomNameA(nAtom: ATOM; lpBuffer: StringBuilder; nSize: Integer): UINT;
function GetAtomNameW(nAtom: ATOM; lpBuffer: StringBuilder; nSize: Integer): UINT;

function GetProfileInt(lpAppName, lpKeyName: string; nDefault: Integer): UINT;
function GetProfileIntA(lpAppName, lpKeyName: string; nDefault: Integer): UINT;
function GetProfileIntW(lpAppName, lpKeyName: string; nDefault: Integer): UINT;

function GetProfileString(lpAppName, lpKeyName, lpDefault: string;
  lpReturnedString: StringBuilder; nSize: DWORD): DWORD; overload;
function GetProfileString(lpAppName, lpKeyName: string; lpDefault: IntPtr;
  lpReturnedString: StringBuilder; nSize: DWORD): DWORD; overload;
function GetProfileString(lpAppName: string; lpKeyName, lpDefault: IntPtr;
  [out] lpReturnedString: TBytes; nSize: DWORD): DWORD; overload;
function GetProfileString(lpAppName, lpKeyName, lpDefault: IntPtr;
  [out] lpReturnedString: TBytes; nSize: DWORD): DWORD; overload;
function GetProfileStringA(lpAppName, lpKeyName, lpDefault: string;
  [out] lpReturnedString: TBytes; nSize: DWORD): DWORD;
function GetProfileStringW(lpAppName, lpKeyName, lpDefault: string;
  [out] lpReturnedString: TBytes; nSize: DWORD): DWORD;

function WriteProfileString(lpAppName, lpKeyName, lpString: string): BOOL; overload;
function WriteProfileString(lpAppName: string; lpKeyName, lpString: IntPtr): BOOL; overload;
function WriteProfileString(lpAppName: string; lpKeyName: IntPtr; lpString: string): BOOL; overload;
function WriteProfileString(lpAppName, lpKeyName: string; lpString: IntPtr): BOOL; overload;
function WriteProfileStringA(lpAppName, lpKeyName, lpString: string): BOOL;
function WriteProfileStringW(lpAppName, lpKeyName, lpString: string): BOOL;

function GetProfileSection(lpAppName: string; [out] lpReturnedString: TBytes; nSize: DWORD): DWORD;
function GetProfileSectionA(lpAppName: string; [out] lpReturnedString: TBytes; nSize: DWORD): DWORD;
function GetProfileSectionW(lpAppName: string; [out] lpReturnedString: TBytes; nSize: DWORD): DWORD;
function WriteProfileSection(lpAppName, lpString: string): BOOL;
function WriteProfileSectionA(lpAppName, lpString: string): BOOL;
function WriteProfileSectionW(lpAppName, lpString: string): BOOL;
function GetPrivateProfileInt(lpAppName, lpKeyName: string; nDefault: Integer; lpFileName: string): UINT;
function GetPrivateProfileIntA(lpAppName, lpKeyName: string; nDefault: Integer; lpFileName: string): UINT;
function GetPrivateProfileIntW(lpAppName, lpKeyName: string; nDefault: Integer; lpFileName: string): UINT;

function GetPrivateProfileString(lpAppName, lpKeyName, lpDefault: string;
  lpReturnedString: StringBuilder; nSize: DWORD; lpFileName: string): DWORD; overload;
function GetPrivateProfileString(lpAppName, lpKeyName: string; lpDefault: IntPtr;
  lpReturnedString: StringBuilder; nSize: DWORD; lpFileName: string): DWORD; overload;
function GetPrivateProfileString(lpAppName: string; lpKeyName, lpDefault: IntPtr;
  [out] lpReturnedString: TBytes; nSize: DWORD; lpFileName: string): DWORD; overload;
function GetPrivateProfileString(lpAppName, lpKeyName, lpDefault: IntPtr;
  [out] lpReturnedString: TBytes; nSize: DWORD; lpFileName: string): DWORD; overload;
function GetPrivateProfileStringA(lpAppName, lpKeyName, lpDefault: string;
  [out] lpReturnedString: TBytes; nSize: DWORD; lpFileName: string): DWORD;
function GetPrivateProfileStringW(lpAppName, lpKeyName, lpDefault: string;
  [out] lpReturnedString: TBytes; nSize: DWORD; lpFileName: string): DWORD;

function WritePrivateProfileString(lpAppName, lpKeyName, lpString, lpFileName: string): BOOL; overload;
function WritePrivateProfileString(lpAppName, lpKeyName: string; lpString: IntPtr; lpFileName: string): BOOL; overload;
function WritePrivateProfileString(lpAppName: string; lpKeyName, lpString: IntPtr; lpFileName: string): BOOL; overload;
function WritePrivateProfileString(lpAppName, lpKeyName, lpString: IntPtr; lpFileName: string): BOOL; overload;
function WritePrivateProfileStringA(lpAppName, lpKeyName, lpString, lpFileName: string): BOOL;
function WritePrivateProfileStringW(lpAppName, lpKeyName, lpString, lpFileName: string): BOOL;

function GetPrivateProfileSection(lpAppName: string; [out] lpReturnedString: TBytes;
  nSize: DWORD; lpFileName: string): DWORD;
function GetPrivateProfileSectionA(lpAppName: string; [out] lpReturnedString: TBytes;
  nSize: DWORD; lpFileName: string): DWORD;
function GetPrivateProfileSectionW(lpAppName: string; [out] lpReturnedString: TBytes;
  nSize: DWORD; lpFileName: string): DWORD;
function WritePrivateProfileSection(lpAppName, lpString, lpFileName: string): BOOL;
function WritePrivateProfileSectionA(lpAppName, lpString, lpFileName: string): BOOL;
function WritePrivateProfileSectionW(lpAppName, lpString, lpFileName: string): BOOL;

function GetPrivateProfileSectionNames([out] lpszReturnBuffer: TBytes; nSize: DWORD;
  lpFileName: string): DWORD; overload;
function GetPrivateProfileSectionNames([out] lpszReturnBuffer: TBytes; nSize: DWORD;
  lpFileName: IntPtr): DWORD; overload;
function GetPrivateProfileSectionNamesA([out] lpszReturnBuffer: TBytes; nSize: DWORD;
  lpFileName: string): DWORD;
function GetPrivateProfileSectionNamesW([out] lpszReturnBuffer: TBytes; nSize: DWORD;
  lpFileName: string): DWORD;

function GetPrivateProfileStruct(lpszSection, lpszKey: string;
  [out] lpStruct: TBytes; uSizeStruct: UINT; szFile: string): BOOL;
function GetPrivateProfileStructA(lpszSection, lpszKey: string;
  [out] lpStruct: TBytes; uSizeStruct: UINT; szFile: string): BOOL;
function GetPrivateProfileStructW(lpszSection, lpszKey: string;
  [out] lpStruct: TBytes; uSizeStruct: UINT; szFile: string): BOOL;

function WritePrivateProfileStruct(lpszSection: string; lpszKey: string;
  [in] lpStruct: TBytes; uSizeStruct: UINT; szFile: string): BOOL; overload;
function WritePrivateProfileStruct(lpszSection: string; lpszKey: IntPtr;
  [in] lpStruct: TBytes; uSizeStruct: UINT; szFile: string): BOOL; overload;
function WritePrivateProfileStructA(lpszSection, lpszKey: string;
  [in] lpStruct: TBytes; uSizeStruct: UINT; szFile: string): BOOL;
function WritePrivateProfileStructW(lpszSection, lpszKey: string;
  [in] lpStruct: TBytes; uSizeStruct: UINT; szFile: string): BOOL;

function GetDriveType(lpRootPathName: string): UINT;
function GetDriveTypeA(lpRootPathName: string): UINT;
function GetDriveTypeW(lpRootPathName: string): UINT;
function GetSystemDirectory(lpBuffer: StringBuilder; uSize: UINT): UINT;
function GetSystemDirectoryA(lpBuffer: StringBuilder; uSize: UINT): UINT;
function GetSystemDirectoryW(lpBuffer: StringBuilder; uSize: UINT): UINT;
function GetTempPath(nBufferLength: DWORD; lpBuffer: StringBuilder): DWORD;
function GetTempPathA(nBufferLength: DWORD; lpBuffer: StringBuilder): DWORD;
function GetTempPathW(nBufferLength: DWORD; lpBuffer: StringBuilder): DWORD;
function GetTempFileName(lpPathName, lpPrefixString: string;
  uUnique: UINT; lpTempFileName: StringBuilder): UINT;
function GetTempFileNameA(lpPathName, lpPrefixString: string;
  uUnique: UINT; lpTempFileName: StringBuilder): UINT;
function GetTempFileNameW(lpPathName, lpPrefixString: string;
  uUnique: UINT; lpTempFileName: StringBuilder): UINT;
function GetWindowsDirectory(lpBuffer: StringBuilder; uSize: UINT): UINT;
function GetWindowsDirectoryA(lpBuffer: StringBuilder; uSize: UINT): UINT;
function GetWindowsDirectoryW(lpBuffer: StringBuilder; uSize: UINT): UINT;
function SetCurrentDirectory(lpPathName: string): BOOL;
function SetCurrentDirectoryA(lpPathName: string): BOOL;
function SetCurrentDirectoryW(lpPathName: string): BOOL;
function GetCurrentDirectory(nBufferLength: DWORD; lpBuffer: StringBuilder): DWORD;
function GetCurrentDirectoryA(nBufferLength: DWORD; lpBuffer: StringBuilder): DWORD;
function GetCurrentDirectoryW(nBufferLength: DWORD; lpBuffer: StringBuilder): DWORD;

function GetDiskFreeSpace(lpRootPathName: string; out lpSectorsPerCluster,
  lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters: DWORD): BOOL; overload;
function GetDiskFreeSpace(lpRootPathName: IntPtr; out lpSectorsPerCluster,
  lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters: DWORD): BOOL; overload;
function GetDiskFreeSpaceA(lpRootPathName: string; out lpSectorsPerCluster,
  lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters: DWORD): BOOL;
function GetDiskFreeSpaceW(lpRootPathName: string; out lpSectorsPerCluster,
  lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters: DWORD): BOOL;

function GetDiskFreeSpaceEx(lpDirectoryName: string;
  out lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes,
  lpTotalNumberOfFreeBytes: TLargeInteger): BOOL; overload;
function GetDiskFreeSpaceEx(lpDirectoryName: string;
  out lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes: TLargeInteger;
  lpTotalNumberOfFreeBytes: IntPtr): BOOL; overload;
function GetDiskFreeSpaceEx(lpDirectoryName: IntPtr;
  out lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes: TLargeInteger;
  lpTotalNumberOfFreeBytes: IntPtr): BOOL; overload;
function GetDiskFreeSpaceExA(lpDirectoryName: string;
  out lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes,
  lpTotalNumberOfFreeBytes: TLargeInteger): BOOL;
function GetDiskFreeSpaceExW(lpDirectoryName: string;
  out lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes,
  lpTotalNumberOfFreeBytes: TLargeInteger): BOOL;

function CreateDirectory(lpPathName: string;
  const lpSecurityAttributes: TSecurityAttributes): BOOL; overload;
function CreateDirectory(lpPathName: string;
  lpSecurityAttributes: IntPtr): BOOL; overload;
function CreateDirectoryA(lpPathName: string;
  const lpSecurityAttributes: TSecurityAttributes): BOOL;
function CreateDirectoryW(lpPathName: string;
  const lpSecurityAttributes: TSecurityAttributes): BOOL;

function CreateDirectoryEx(lpTemplateDirectory, lpNewDirectory: string;
  const lpSecurityAttributes: TSecurityAttributes): BOOL; overload;
function CreateDirectoryEx(lpTemplateDirectory, lpNewDirectory: string;
  lpSecurityAttributes: IntPtr): BOOL; overload;
function CreateDirectoryExA(lpTemplateDirectory, lpNewDirectory: string;
  const lpSecurityAttributes: TSecurityAttributes): BOOL;
function CreateDirectoryExW(lpTemplateDirectory, lpNewDirectory: string;
  const lpSecurityAttributes: TSecurityAttributes): BOOL;

function RemoveDirectory(lpPathName: string): BOOL;
function RemoveDirectoryA(lpPathName: string): BOOL;
function RemoveDirectoryW(lpPathName: string): BOOL;
function GetFullPathName(lpFileName: string; nBufferLength: DWORD;
  lpBuffer: StringBuilder; out lpFilePart: IntPtr): DWORD;
function GetFullPathNameA(lpFileName: string; nBufferLength: DWORD;
  lpBuffer: StringBuilder; out lpFilePart: IntPtr): DWORD;
function GetFullPathNameW(lpFileName: string; nBufferLength: DWORD;
  lpBuffer: StringBuilder; out lpFilePart: IntPtr): DWORD;

const
  DDD_RAW_TARGET_PATH             = $00000001;
  DDD_REMOVE_DEFINITION           = $00000002;
  DDD_EXACT_MATCH_ON_REMOVE       = $00000004;
  DDD_NO_BROADCAST_SYSTEM         = $00000008;

function DefineDosDevice(dwFlags: DWORD; lpDeviceName, lpTargetPath: string): BOOL;
function DefineDosDeviceA(dwFlags: DWORD; lpDeviceName, lpTargetPath: string): BOOL;
function DefineDosDeviceW(dwFlags: DWORD; lpDeviceName, lpTargetPath: string): BOOL;

function QueryDosDevice(lpDeviceName: string; [out] lpTargetPath: TBytes;
  ucchMax: DWORD): DWORD; overload;
function QueryDosDevice(lpDeviceName: IntPtr; [out] lpTargetPath: TBytes;
  ucchMax: DWORD): DWORD; overload;
function QueryDosDeviceA(lpDeviceName: string; [out] lpTargetPath: TBytes; ucchMax: DWORD): DWORD;
function QueryDosDeviceW(lpDeviceName: string; [out] lpTargetPath: TBytes; ucchMax: DWORD): DWORD;

function CreateFile(lpFileName: string; dwDesiredAccess, dwShareMode: DWORD;
  const lpSecurityAttributes: TSecurityAttributes; dwCreationDisposition,
  dwFlagsAndAttributes: DWORD; hTemplateFile: THandle): THandle; overload;
function CreateFile(lpFileName: string; dwDesiredAccess, dwShareMode: DWORD;
  lpSecurityAttributes: IntPtr; dwCreationDisposition, dwFlagsAndAttributes: DWORD;
  hTemplateFile: THandle): THandle; overload;
function CreateFileA(lpFileName: string; dwDesiredAccess, dwShareMode: DWORD;
  const lpSecurityAttributes: TSecurityAttributes; dwCreationDisposition, dwFlagsAndAttributes: DWORD;
  hTemplateFile: THandle): THandle;
function CreateFileW(lpFileName: string; dwDesiredAccess, dwShareMode: DWORD;
  const lpSecurityAttributes: TSecurityAttributes; dwCreationDisposition, dwFlagsAndAttributes: DWORD;
  hTemplateFile: THandle): THandle;

function SetFileAttributes(lpFileName: string; dwFileAttributes: DWORD): BOOL;
function SetFileAttributesA(lpFileName: string; dwFileAttributes: DWORD): BOOL;
function SetFileAttributesW(lpFileName: string; dwFileAttributes: DWORD): BOOL;
function GetFileAttributes(lpFileName: string): DWORD;
function GetFileAttributesA(lpFileName: string): DWORD;
function GetFileAttributesW(lpFileName: string): DWORD;

type
  _GET_FILEEX_INFO_LEVELS = (GetFileExInfoStandard, GetFileExMaxInfoLevel);
  TGetFileExInfoLevels = _GET_FILEEX_INFO_LEVELS;
  GET_FILEEX_INFO_LEVELS = _GET_FILEEX_INFO_LEVELS;

function GetFileAttributesEx(lpFileName: string; fInfoLevelId: TGetFileExInfoLevels;
  out lpFileInformation: TWin32FindData): BOOL; overload;
function GetFileAttributesEx(lpFileName: string; fInfoLevelId: TGetFileExInfoLevels;
  lpFileInformation: IntPtr): BOOL; overload;
function GetFileAttributesExA(lpFileName: string; fInfoLevelId: TGetFileExInfoLevels;
  out lpFileInformation: TWin32FindData): BOOL;
function GetFileAttributesExW(lpFileName: string; fInfoLevelId: TGetFileExInfoLevels;
  out lpFileInformation: TWin32FindData): BOOL;

function GetCompressedFileSize(lpFileName: string; out lpFileSizeHigh: DWORD): DWORD;
function GetCompressedFileSizeA(lpFileName: string; out lpFileSizeHigh: DWORD): DWORD;
function GetCompressedFileSizeW(lpFileName: string; out lpFileSizeHigh: DWORD): DWORD;
function DeleteFile(lpFileName: string): BOOL;
function DeleteFileA(lpFileName: string): BOOL;
function DeleteFileW(lpFileName: string): BOOL;

type
  _FINDEX_INFO_LEVELS = (FindExInfoStandard, FindExInfoMaxInfoLevel);
  TFindexInfoLevels = _FINDEX_INFO_LEVELS;
  FINDEX_INFO_LEVELS = _FINDEX_INFO_LEVELS;

  _FINDEX_SEARCH_OPS = (FindExSearchNameMatch, FindExSearchLimitToDirectories,
    FindExSearchLimitToDevices, FindExSearchMaxSearchOp);
  TFindexSearchOps = _FINDEX_SEARCH_OPS;
  FINDEX_SEARCH_OPS = _FINDEX_SEARCH_OPS;

const
  FIND_FIRST_EX_CASE_SENSITIVE = $00000001;

function FindFirstFileEx(lpFileName: string; fInfoLevelId: TFindexInfoLevels;
  out lpFindFileData: TWin32FindData; fSearchOp: TFindexSearchOps; lpSearchFilter: IntPtr;
  dwAdditionalFlags: DWORD): BOOL;
function FindFirstFileExA(lpFileName: string; fInfoLevelId: TFindexInfoLevels;
  out lpFindFileData: TWin32FindData; fSearchOp: TFindexSearchOps; lpSearchFilter: IntPtr;
  dwAdditionalFlags: DWORD): BOOL;
function FindFirstFileExW(lpFileName: string; fInfoLevelId: TFindexInfoLevels;
  out lpFindFileData: TWin32FindData; fSearchOp: TFindexSearchOps; lpSearchFilter: IntPtr;
  dwAdditionalFlags: DWORD): BOOL;
function FindFirstFile(lpFileName: string; out lpFindFileData: TWIN32FindData): THandle;
function FindFirstFileA(lpFileName: string; out lpFindFileData: TWIN32FindDataA): THandle;
function FindFirstFileW(lpFileName: string; out lpFindFileData: TWIN32FindDataW): THandle;
function FindNextFile(hFindFile: THandle; out lpFindFileData: TWIN32FindData): BOOL;
function FindNextFileA(hFindFile: THandle; out lpFindFileData: TWIN32FindDataA): BOOL;
function FindNextFileW(hFindFile: THandle; out lpFindFileData: TWIN32FindDataW): BOOL;
function SearchPath(lpPath, lpFileName, lpExtension: string;
  nBufferLength: DWORD; lpBuffer: StringBuilder; out lpFilePart: IntPtr): DWORD;
function SearchPathA(lpPath, lpFileName, lpExtension: string;
  nBufferLength: DWORD; lpBuffer: StringBuilder; out lpFilePart: IntPtr): DWORD;
function SearchPathW(lpPath, lpFileName, lpExtension: string;
  nBufferLength: DWORD; lpBuffer: StringBuilder; out lpFilePart: IntPtr): DWORD;
function CopyFile(lpExistingFileName, lpNewFileName: string; bFailIfExists: BOOL): BOOL;
function CopyFileA(lpExistingFileName, lpNewFileName: string; bFailIfExists: BOOL): BOOL;
function CopyFileW(lpExistingFileName, lpNewFileName: string; bFailIfExists: BOOL): BOOL;

type
  TFNProgressRoutine = function(TotalFileSize, TotalBytesTransferred,
    StreamSize, StreamBytesTransferred: TLargeInteger; dwStreamNumber,
    dwCallbackReason: DWORD; hSourceFile, hDestinationFile: THandle;
    lpData: IntPtr): DWORD;

function CopyFileEx(lpExistingFileName, lpNewFileName: string;
  lpProgressRoutine: TFNProgressRoutine; lpData: IntPtr; pbCancel: IntPtr;
  dwCopyFlags: DWORD): BOOL;
function CopyFileExA(lpExistingFileName, lpNewFileName: string;
  lpProgressRoutine: TFNProgressRoutine; lpData: IntPtr; pbCancel: IntPtr;
  dwCopyFlags: DWORD): BOOL;
function CopyFileExW(lpExistingFileName, lpNewFileName: string;
  lpProgressRoutine: TFNProgressRoutine; lpData: IntPtr; pbCancel: IntPtr;
  dwCopyFlags: DWORD): BOOL;
function MoveFile(lpExistingFileName, lpNewFileName: string): BOOL;
function MoveFileA(lpExistingFileName, lpNewFileName: string): BOOL;
function MoveFileW(lpExistingFileName, lpNewFileName: string): BOOL;
function MoveFileEx(lpExistingFileName, lpNewFileName: string; dwFlags: DWORD): BOOL;
function MoveFileExA(lpExistingFileName, lpNewFileName: string; dwFlags: DWORD): BOOL;
function MoveFileExW(lpExistingFileName, lpNewFileName: string; dwFlags: DWORD): BOOL;
function MoveFileWithProgress(lpExistingFileName, lpNewFileName: string;
  lpProgressRoutine: TFNProgressRoutine; lpData: IntPtr; dwFlags: DWORD): BOOL;
function MoveFileWithProgressA(lpExistingFileName, lpNewFileName: string;
  lpProgressRoutine: TFNProgressRoutine; lpData: IntPtr; dwFlags: DWORD): BOOL;
function MoveFileWithProgressW(lpExistingFileName, lpNewFileName: string;
  lpProgressRoutine: TFNProgressRoutine; lpData: IntPtr; dwFlags: DWORD): BOOL;

const
  MOVEFILE_REPLACE_EXISTING       = $00000001;
  MOVEFILE_COPY_ALLOWED           = $00000002;
  MOVEFILE_DELAY_UNTIL_REBOOT     = $00000004;
  MOVEFILE_WRITE_THROUGH          = $00000008;
  MOVEFILE_CREATE_HARDLINK        = $00000010;
  MOVEFILE_FAIL_IF_NOT_TRACKABLE  = $00000020;

function CreateHardLink(lpFileName, lpExistingFileName: string;
  lpSecurityAttributes: IntPtr): BOOL;
function CreateHardLinkA(lpFileName, lpExistingFileName: string;
  lpSecurityAttributes: IntPtr): BOOL;
function CreateHardLinkW(lpFileName, lpExistingFileName: string;
  lpSecurityAttributes: IntPtr): BOOL;

function CreateNamedPipe(lpName: string;
  dwOpenMode, dwPipeMode, nMaxInstances, nOutBufferSize, nInBufferSize, nDefaultTimeOut: DWORD;
  const lpSecurityAttributes: TSecurityAttributes): THandle; overload;
function CreateNamedPipe(lpName: string;
  dwOpenMode, dwPipeMode, nMaxInstances, nOutBufferSize, nInBufferSize, nDefaultTimeOut: DWORD;
  lpSecurityAttributes: IntPtr): THandle; overload;
function CreateNamedPipeA(lpName: string;
  dwOpenMode, dwPipeMode, nMaxInstances, nOutBufferSize, nInBufferSize, nDefaultTimeOut: DWORD;
  const lpSecurityAttributes: TSecurityAttributes): THandle;
function CreateNamedPipeW(lpName: string;
  dwOpenMode, dwPipeMode, nMaxInstances, nOutBufferSize, nInBufferSize, nDefaultTimeOut: DWORD;
  const lpSecurityAttributes: TSecurityAttributes): THandle;

function GetNamedPipeHandleState(hNamedPipe: THandle;
  out lpState, lpCurInstances, lpMaxCollectionCount, lpCollectDataTimeout: DWORD;
  lpUserName: StringBuilder; nMaxUserNameSize: DWORD): BOOL;
function GetNamedPipeHandleStateA(hNamedPipe: THandle;
  out lpState, lpCurInstances, lpMaxCollectionCount, lpCollectDataTimeout: DWORD;
  lpUserName: StringBuilder; nMaxUserNameSize: DWORD): BOOL;
function GetNamedPipeHandleStateW(hNamedPipe: THandle;
  out lpState, lpCurInstances, lpMaxCollectionCount, lpCollectDataTimeout: DWORD;
  lpUserName: StringBuilder; nMaxUserNameSize: DWORD): BOOL;

function CallNamedPipe(lpNamedPipeName: string; [in] lpInBuffer: TBytes;
  nInBufferSize: DWORD; [out] lpOutBuffer: TBytes; nOutBufferSize: DWORD;
  out lpBytesRead: DWORD; nTimeOut: DWORD): BOOL;
function CallNamedPipeA(lpNamedPipeName: string; [in] lpInBuffer: TBytes;
  nInBufferSize: DWORD; [out] lpOutBuffer: TBytes; nOutBufferSize: DWORD;
  out lpBytesRead: DWORD; nTimeOut: DWORD): BOOL;
function CallNamedPipeW(lpNamedPipeName: string; [in] lpInBuffer: TBytes;
  nInBufferSize: DWORD; [out] lpOutBuffer: TBytes; nOutBufferSize: DWORD;
  out lpBytesRead: DWORD; nTimeOut: DWORD): BOOL;

function WaitNamedPipe(lpNamedPipeName: string; nTimeOut: DWORD): BOOL;
function WaitNamedPipeA(lpNamedPipeName: string; nTimeOut: DWORD): BOOL;
function WaitNamedPipeW(lpNamedPipeName: string; nTimeOut: DWORD): BOOL;

function SetVolumeLabel(lpRootPathName: string; lpVolumeName: string): BOOL; overload;
function SetVolumeLabel(lpRootPathName: IntPtr; lpVolumeName: string): BOOL; overload;
function SetVolumeLabel(lpRootPathName: IntPtr; lpVolumeName: IntPtr): BOOL; overload;
function SetVolumeLabel(lpRootPathName: string; lpVolumeName: IntPtr): BOOL; overload;
function SetVolumeLabelA(lpRootPathName: string; lpVolumeName: string): BOOL;
function SetVolumeLabelW(lpRootPathName: string; lpVolumeName: string): BOOL;

procedure SetFileApisToOEM;
procedure SetFileApisToANSI;
function AreFileApisANSI: BOOL;

function GetVolumeInformation(lpRootPathName: string; lpVolumeNameBuffer: StringBuilder;
  nVolumeNameSize: DWORD; out lpVolumeSerialNumber: DWORD;
  out lpMaximumComponentLength, lpFileSystemFlags: DWORD;
  lpFileSystemNameBuffer: StringBuilder; nFileSystemNameSize: DWORD): BOOL; overload;
function GetVolumeInformation(lpRootPathName: string; lpVolumeNameBuffer: StringBuilder;
  nVolumeNameSize: DWORD; lpVolumeSerialNumber: IntPtr;
  out lpMaximumComponentLength, lpFileSystemFlags: DWORD;
  lpFileSystemNameBuffer: StringBuilder; nFileSystemNameSize: DWORD): BOOL; overload;
function GetVolumeInformationA(lpRootPathName: string; lpVolumeNameBuffer: StringBuilder;
  nVolumeNameSize: DWORD; out lpVolumeSerialNumber: DWORD;
  out lpMaximumComponentLength, lpFileSystemFlags: DWORD;
  lpFileSystemNameBuffer: StringBuilder; nFileSystemNameSize: DWORD): BOOL;
function GetVolumeInformationW(lpRootPathName: string; lpVolumeNameBuffer: StringBuilder;
  nVolumeNameSize: DWORD; out lpVolumeSerialNumber: DWORD;
  out lpMaximumComponentLength, lpFileSystemFlags: DWORD;
  lpFileSystemNameBuffer: StringBuilder; nFileSystemNameSize: DWORD): BOOL;

function CancelIo(hFile: THandle): BOOL;

{ Event logging APIs }

function ClearEventLog(hEventLog: THandle; lpBackupFileName: string): BOOL;
function ClearEventLogA(hEventLog: THandle; lpBackupFileName: string): BOOL;
function ClearEventLogW(hEventLog: THandle; lpBackupFileName: string): BOOL;
function BackupEventLog(hEventLog: THandle; lpBackupFileName: string): BOOL;
function BackupEventLogA(hEventLog: THandle; lpBackupFileName: string): BOOL;
function BackupEventLogW(hEventLog: THandle; lpBackupFileName: string): BOOL;
function CloseEventLog(hEventLog: THandle): BOOL;
function DeregisterEventSource(hEventLog: THandle): BOOL;
function NotifyChangeEventLog(hEventLog, hEvent: THandle): BOOL;
function GetNumberOfEventLogRecords(hEventLog: THandle; out NumberOfRecords: DWORD): BOOL;
function GetOldestEventLogRecord(hEventLog: THandle; out OldestRecord: DWORD): BOOL;
function OpenEventLog(lpUNCServerName, lpSourceName: string): THandle;
function OpenEventLogA(lpUNCServerName, lpSourceName: string): THandle;
function OpenEventLogW(lpUNCServerName, lpSourceName: string): THandle;
function RegisterEventSource(lpUNCServerName, lpSourceName: string): THandle; overload;
function RegisterEventSource(lpUNCServerName: IntPtr; lpSourceName: string): THandle; overload;
function RegisterEventSourceA(lpUNCServerName, lpSourceName: string): THandle;
function RegisterEventSourceW(lpUNCServerName, lpSourceName: string): THandle;
function OpenBackupEventLog(lpUNCServerName, lpFileName: string): THandle;
function OpenBackupEventLogA(lpUNCServerName, lpFileName: string): THandle;
function OpenBackupEventLogW(lpUNCServerName, lpFileName: string): THandle;
function ReadEventLog(hEventLog: THandle; dwReadFlags, dwRecordOffset: DWORD;
  lpBuffer: IntPtr; nNumberOfBytesToRead: DWORD;
  out pnBytesRead, pnMinNumberOfBytesNeeded: DWORD): BOOL;
function ReadEventLogA(hEventLog: THandle; dwReadFlags, dwRecordOffset: DWORD;
  lpBuffer: IntPtr; nNumberOfBytesToRead: DWORD;
  out pnBytesRead, pnMinNumberOfBytesNeeded: DWORD): BOOL;
function ReadEventLogW(hEventLog: THandle; dwReadFlags, dwRecordOffset: DWORD;
  lpBuffer: IntPtr; nNumberOfBytesToRead: DWORD;
  out pnBytesRead, pnMinNumberOfBytesNeeded: DWORD): BOOL;
function ReportEvent(hEventLog: THandle; wType, wCategory: Word;
  dwEventID: DWORD; lpUserSid: PSID; wNumStrings: Word;
  dwDataSize: DWORD; lpStrings, lpRawData: IntPtr): BOOL;
function ReportEventA(hEventLog: THandle; wType, wCategory: Word;
  dwEventID: DWORD; lpUserSid: PSID; wNumStrings: Word;
  dwDataSize: DWORD; lpStrings, lpRawData: IntPtr): BOOL;
function ReportEventW(hEventLog: THandle; wType, wCategory: Word;
  dwEventID: DWORD; lpUserSid: PSID; wNumStrings: Word;
  dwDataSize: DWORD; lpStrings, lpRawData: IntPtr): BOOL;

{ Security APIs }

                                           

type
  [StructLayout(LayoutKind.Sequential)]
  _FILE_NOTIFY_INFORMATION = record
    NextEntryOffset: DWORD;
    Action: DWORD;
    FileNameLength: DWORD;
    FileName: IntPtr; { array[0..0] of Char }
  end;
  TFileNotifyInformation = _FILE_NOTIFY_INFORMATION;

function SetFileSecurity(lpFileName: string; SecurityInformation: SECURITY_INFORMATION;
  const pSecurityDescriptor: TSecurityDescriptor): BOOL;
function SetFileSecurityA(lpFileName: string; SecurityInformation: SECURITY_INFORMATION;
  const pSecurityDescriptor: TSecurityDescriptor): BOOL;
function SetFileSecurityW(lpFileName: string; SecurityInformation: SECURITY_INFORMATION;
  const pSecurityDescriptor: TSecurityDescriptor): BOOL;
function GetFileSecurity(lpFileName: string; RequestedInformation: SECURITY_INFORMATION;
  out pSecurityDescriptor: TSecurityDescriptor; nLength: DWORD; out lpnLengthNeeded: DWORD): BOOL;
function GetFileSecurityA(lpFileName: string; RequestedInformation: SECURITY_INFORMATION;
  out pSecurityDescriptor: TSecurityDescriptor; nLength: DWORD; out lpnLengthNeeded: DWORD): BOOL;
function GetFileSecurityW(lpFileName: string; RequestedInformation: SECURITY_INFORMATION;
  out pSecurityDescriptor: TSecurityDescriptor; nLength: DWORD; out lpnLengthNeeded: DWORD): BOOL;
function SetKernelObjectSecurity(Handle: THandle; SecurityInformation: SECURITY_INFORMATION;
  const SecurityDescriptor: TSecurityDescriptor): BOOL;
function FindFirstChangeNotification(lpPathName: string;
  bWatchSubtree: BOOL; dwNotifyFilter: DWORD): THandle;
function FindFirstChangeNotificationA(lpPathName: string;
  bWatchSubtree: BOOL; dwNotifyFilter: DWORD): THandle;
function FindFirstChangeNotificationW(lpPathName: string;
  bWatchSubtree: BOOL; dwNotifyFilter: DWORD): THandle;
function FindNextChangeNotification(hChangeHandle: THandle): BOOL;
function FindCloseChangeNotification(hChangeHandle: THandle): BOOL;

function ReadDirectoryChanges(hDirectory: THandle; var lpBuffer: TFileNotifyInformation;
  nBufferLength: DWORD; bWatchSubtree: Bool; dwNotifyFilter: DWORD; out lpBytesReturned: DWORD;
  const lpOverlapped: TOverlapped; lpCompletionRoutine: FARPROC): BOOL; overload;
function ReadDirectoryChanges(hDirectory: THandle; var lpBuffer: TFileNotifyInformation;
  nBufferLength: DWORD; bWatchSubtree: Bool; dwNotifyFilter: DWORD; out lpBytesReturned: DWORD;
  lpOverlapped: IntPtr; lpCompletionRoutine: FARPROC): BOOL; overload;
function ReadDirectoryChangesW(hDirectory: THandle; var lpBuffer: TFileNotifyInformation;
  nBufferLength: DWORD; bWatchSubtree: Bool; dwNotifyFilter: DWORD;
  out lpBytesReturned: DWORD; const lpOverlapped: TOverlapped; lpCompletionRoutine: FARPROC): BOOL;

                                           

function MapViewOfFileEx(hFileMappingObject: THandle;
  dwDesiredAccess, dwFileOffsetHigh, dwFileOffsetLow, dwNumberOfBytesToMap: DWORD;
  lpBaseAddress: IntPtr): IntPtr;
function SetPriorityClass(hProcess: THandle; dwPriorityClass: DWORD): BOOL;
function GetPriorityClass(hProcess: THandle): DWORD;

                                           

function LookupAccountSid(lpSystemName: string; Sid: PSID;
  Name: StringBuilder; var cbName: DWORD; ReferencedDomainName: StringBuilder;
  var cbReferencedDomainName: DWORD; out peUse: SID_NAME_USE): BOOL;
function LookupAccountSidA(lpSystemName: string; Sid: PSID;
  Name: StringBuilder; var cbName: DWORD; ReferencedDomainName: StringBuilder;
  var cbReferencedDomainName: DWORD; out peUse: SID_NAME_USE): BOOL;
function LookupAccountSidW(lpSystemName: string; Sid: PSID;
  Name: StringBuilder; var cbName: DWORD; ReferencedDomainName: StringBuilder;
  var cbReferencedDomainName: DWORD; out peUse: SID_NAME_USE): BOOL;
function LookupAccountName(lpSystemName, lpAccountName: string;
  Sid: PSID; var cbSid: DWORD; ReferencedDomainName: StringBuilder;
  var cbReferencedDomainName: DWORD; out peUse: SID_NAME_USE): BOOL;
function LookupAccountNameA(lpSystemName, lpAccountName: string;
  Sid: PSID; var cbSid: DWORD; ReferencedDomainName: StringBuilder;
  var cbReferencedDomainName: DWORD; out peUse: SID_NAME_USE): BOOL;
function LookupAccountNameW(lpSystemName, lpAccountName: string;
  Sid: PSID; var cbSid: DWORD; ReferencedDomainName: StringBuilder;
  var cbReferencedDomainName: DWORD; out peUse: SID_NAME_USE): BOOL;
function LookupPrivilegeValue(lpSystemName, lpName: string;
  out lpLuid: TLargeInteger): BOOL;
function LookupPrivilegeValueA(lpSystemName, lpName: string;
  out lpLuid: TLargeInteger): BOOL;
function LookupPrivilegeValueW(lpSystemName, lpName: string;
  out lpLuid: TLargeInteger): BOOL;
function LookupPrivilegeName(lpSystemName: string;
  const lpLuid: TLargeInteger; lpName: StringBuilder; var cbName: DWORD): BOOL;
function LookupPrivilegeNameA(lpSystemName: string;
  const lpLuid: TLargeInteger; lpName: StringBuilder; var cbName: DWORD): BOOL;
function LookupPrivilegeNameW(lpSystemName: string;
  const lpLuid: TLargeInteger; lpName: StringBuilder; var cbName: DWORD): BOOL;
function LookupPrivilegeDisplayName(lpSystemName, lpName: string;
  lpDisplayName: StringBuilder; var cbDisplayName: DWORD; out lpLanguageId: DWORD): BOOL;
function LookupPrivilegeDisplayNameA(lpSystemName, lpName: string;
  lpDisplayName: StringBuilder; var cbDisplayName: DWORD; out lpLanguageId: DWORD): BOOL;
function LookupPrivilegeDisplayNameW(lpSystemName, lpName: string;
  lpDisplayName: StringBuilder; var cbDisplayName: DWORD; out lpLanguageId: DWORD): BOOL;
function AllocateLocallyUniqueId(out Luid: TLargeInteger): BOOL;
function BuildCommDCB(lpDef: string; out lpDCB: TDCB): BOOL;
function BuildCommDCBA(lpDef: string; out lpDCB: TDCB): BOOL;
function BuildCommDCBW(lpDef: string; out lpDCB: TDCB): BOOL;
function BuildCommDCBAndTimeouts(lpDef: string; out lpDCB: TDCB;
  const lpCommTimeouts: TCommTimeouts): BOOL;
function BuildCommDCBAndTimeoutsA(lpDef: string; out lpDCB: TDCB;
  const lpCommTimeouts: TCommTimeouts): BOOL;
function BuildCommDCBAndTimeoutsW(lpDef: string; out lpDCB: TDCB;
  const lpCommTimeouts: TCommTimeouts): BOOL;
function CommConfigDialog(lpszName: string; hWnd: HWND; var lpCC: TCommConfig): BOOL;
function CommConfigDialogA(lpszName: string; hWnd: HWND; var lpCC: TCommConfig): BOOL;
function CommConfigDialogW(lpszName: string; hWnd: HWND; var lpCC: TCommConfig): BOOL;
function GetDefaultCommConfig(lpszName: string;
  out lpCC: TCommConfig; var lpdwSize: DWORD): BOOL;
function GetDefaultCommConfigA(lpszName: string;
  out lpCC: TCommConfig; var lpdwSize: DWORD): BOOL;
function GetDefaultCommConfigW(lpszName: string;
  out lpCC: TCommConfig; var lpdwSize: DWORD): BOOL;
function SetDefaultCommConfig(lpszName: string; const lpCC: TCommConfig; dwSize: DWORD): BOOL;
function SetDefaultCommConfigA(lpszName: string; const lpCC: TCommConfig; dwSize: DWORD): BOOL;
function SetDefaultCommConfigW(lpszName: string; const lpCC: TCommConfig; dwSize: DWORD): BOOL;

const
  MAX_COMPUTERNAME_LENGTH = 15;

function GetComputerName(lpBuffer: StringBuilder; var nSize: DWORD): BOOL;
function GetComputerNameA(lpBuffer: StringBuilder; var nSize: DWORD): BOOL;
function GetComputerNameW(lpBuffer: StringBuilder; var nSize: DWORD): BOOL;
function SetComputerName(lpComputerName: string): BOOL;
function SetComputerNameA(lpComputerName: string): BOOL;
function SetComputerNameW(lpComputerName: string): BOOL;
function GetUserName(lpBuffer: StringBuilder; var nSize: DWORD): BOOL;
function GetUserNameA(lpBuffer: StringBuilder; var nSize: DWORD): BOOL;
function GetUserNameW(lpBuffer: StringBuilder; var nSize: DWORD): BOOL;

{ Logon Support APIs }

const
  LOGON32_LOGON_INTERACTIVE = 2;
  LOGON32_LOGON_NETWORK = 3;
  LOGON32_LOGON_BATCH = 4;
  LOGON32_LOGON_SERVICE = 5;

  LOGON32_PROVIDER_DEFAULT = 0;
  LOGON32_PROVIDER_WINNT35 = 1;
  LOGON32_PROVIDER_WINNT40 = 2;
  LOGON32_PROVIDER_WINNT50 = 3;

function LogonUser(lpszUsername, lpszDomain, lpszPassword: string;
  dwLogonType, dwLogonProvider: DWORD; out phToken: THandle): BOOL; overload;
function LogonUser(lpszUsername: string; lpszDomain: IntPtr; lpszPassword: string;
  dwLogonType, dwLogonProvider: DWORD; out phToken: THandle): BOOL; overload;
function LogonUserA(lpszUsername, lpszDomain, lpszPassword: string;
  dwLogonType, dwLogonProvider: DWORD; out phToken: THandle): BOOL;
function LogonUserW(lpszUsername, lpszDomain, lpszPassword: string;
  dwLogonType, dwLogonProvider: DWORD; out phToken: THandle): BOOL;
function ImpersonateLoggedOnUser(hToken: THandle): BOOL;

function CreateProcessAsUser(hToken: THandle; lpApplicationName: string;
  lpCommandLine: string; const lpProcessAttributes: TSecurityAttributes;
  const lpThreadAttributes: TSecurityAttributes; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: string; lpCurrentDirectory: string;
  const lpStartupInfo: TStartupInfo; out lpProcessInformation: TProcessInformation): BOOL; overload;
function CreateProcessAsUser(hToken: THandle; lpApplicationName: string;
  lpCommandLine: string; lpProcessAttributes: IntPtr;
  lpThreadAttributes: IntPtr; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: string; lpCurrentDirectory: string;
  const lpStartupInfo: TStartupInfo; out lpProcessInformation: TProcessInformation): BOOL; overload;
function CreateProcessAsUser(hToken: THandle; lpApplicationName: string;
  lpCommandLine: string; lpProcessAttributes: IntPtr;
  const lpThreadAttributes: TSecurityAttributes; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: string; lpCurrentDirectory: string;
  const lpStartupInfo: TStartupInfo; out lpProcessInformation: TProcessInformation): BOOL; overload;
function CreateProcessAsUser(hToken: THandle; lpApplicationName: string;
  lpCommandLine: string; const lpProcessAttributes: TSecurityAttributes;
  lpThreadAttributes: IntPtr; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: string; lpCurrentDirectory: string;
  const lpStartupInfo: TStartupInfo; out lpProcessInformation: TProcessInformation): BOOL; overload;
function CreateProcessAsUserA(hToken: THandle; lpApplicationName: string;
  lpCommandLine: string; const lpProcessAttributes: TSecurityAttributes;
  const lpThreadAttributes: TSecurityAttributes; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: string; lpCurrentDirectory: string;
  const lpStartupInfo: TStartupInfo; out lpProcessInformation: TProcessInformation): BOOL;
function CreateProcessAsUserW(hToken: THandle; lpApplicationName: string;
  lpCommandLine: string; const lpProcessAttributes: TSecurityAttributes;
  const lpThreadAttributes: TSecurityAttributes; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: string; lpCurrentDirectory: string;
  const lpStartupInfo: TStartupInfo; out lpProcessInformation: TProcessInformation): BOOL;

                                           

{ Plug-and-Play API's }
const
  HW_PROFILE_GUIDLEN = 39;                 { 36-characters plus NULL terminator }
  MAX_PROFILE_LEN = 80;

  DOCKINFO_UNDOCKED = $1;
  DOCKINFO_DOCKED = $2;
  DOCKINFO_USER_SUPPLIED = $4;
  DOCKINFO_USER_UNDOCKED = DOCKINFO_USER_SUPPLIED or DOCKINFO_UNDOCKED;
  DOCKINFO_USER_DOCKED = DOCKINFO_USER_SUPPLIED or DOCKINFO_DOCKED;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto, Pack=1)]
  tagHW_PROFILE_INFO = packed record
    dwDockInfo: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=HW_PROFILE_GUIDLEN)]
    szHwProfileGuid: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_PROFILE_LEN)]
    szHwProfileName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi, Pack=1)]
  tagHW_PROFILE_INFOA = packed record
    dwDockInfo: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=HW_PROFILE_GUIDLEN)]
    szHwProfileGuid: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_PROFILE_LEN)]
    szHwProfileName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode, Pack=1)]
  tagHW_PROFILE_INFOW = packed record
    dwDockInfo: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=HW_PROFILE_GUIDLEN)]
    szHwProfileGuid: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_PROFILE_LEN)]
    szHwProfileName: string;
  end;
  THWProfileInfo = tagHW_PROFILE_INFO;
  THWProfileInfoA = tagHW_PROFILE_INFOA;
  THWProfileInfoW = tagHW_PROFILE_INFOW;
  HW_PROFILE_INFO = tagHW_PROFILE_INFO;
  HW_PROFILE_INFOA = tagHW_PROFILE_INFOA;
  HW_PROFILE_INFOW = tagHW_PROFILE_INFOW;

function GetCurrentHwProfile(out lpHwProfileInfo: THWProfileInfo): BOOL;
function GetCurrentHwProfileA(out lpHwProfileInfo: THWProfileInfoA): BOOL;
function GetCurrentHwProfileW(out lpHwProfileInfo: THWProfileInfoW): BOOL;

{ Performance counter API's }

function QueryPerformanceCounter(out lpPerformanceCount: TLargeInteger): BOOL;
function QueryPerformanceFrequency(out lpFrequency: TLargeInteger): BOOL;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  _OSVERSIONINFO = record
    dwOSVersionInfoSize: DWORD;
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwPlatformId: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=128)]
    szCSDVersion: string; { Maintenance string for PSS usage }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  _OSVERSIONINFOA = record
    dwOSVersionInfoSize: DWORD;
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwPlatformId: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=128)]
    szCSDVersion: string;  { Maintenance string for PSS usage }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  _OSVERSIONINFOW = record
    dwOSVersionInfoSize: DWORD;
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwPlatformId: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=128)]
    szCSDVersion: string;  { Maintenance string for PSS usage }
  end;
  TOSVersionInfo = _OSVERSIONINFO;
  TOSVersionInfoA = _OSVERSIONINFOA;
  TOSVersionInfoW = _OSVERSIONINFOW;
  OSVERSIONINFO = _OSVERSIONINFO;
  OSVERSIONINFOA = _OSVERSIONINFOA;
  OSVERSIONINFOW = _OSVERSIONINFOW;

{ dwPlatformId defines }
const
  VER_PLATFORM_WIN32s = 0;
  VER_PLATFORM_WIN32_WINDOWS = 1;
  VER_PLATFORM_WIN32_NT = 2;

function GetVersionEx(var lpVersionInformation: TOSVersionInfo): BOOL;
function GetVersionExA(var lpVersionInformation: TOSVersionInfo): BOOL;
function GetVersionExW(var lpVersionInformation: TOSVersionInfo): BOOL;

{ DOS and OS/2 Compatible Error Code definitions returned by the Win32 Base
  API functions. }


{ Translated from WINERROR.H }
{ Error code definitions for the Win32 API functions }

(*
  Values are 32 bit values layed out as follows:
   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
  +---+-+-+-----------------------+-------------------------------+
  |Sev|C|R|     Facility          |               Code            |
  +---+-+-+-----------------------+-------------------------------+

  where
      Sev - is the severity code
          00 - Success
          01 - Informational
          10 - Warning
          11 - Error

      C - is the Customer code flag
      R - is a reserved bit
      Facility - is the facility code
      Code - is the facility's status code
*)

{ Define the facility codes }

const
  FACILITY_WINDOWS                     = 8;
  FACILITY_STORAGE                     = 3;
  FACILITY_RPC                         = 1;
  FACILITY_SSPI                        = 9;
  FACILITY_WIN32                       = 7;
  FACILITY_CONTROL                     = 10;
  FACILITY_NULL                        = 0;
  FACILITY_INTERNET                    = 12;
  FACILITY_ITF                         = 4;
  FACILITY_DISPATCH                    = 2;
  FACILITY_CERT                        = 11;


{ Define the severity codes }

  { The operation completed successfully. }
  ERROR_SUCCESS = 0;
  NO_ERROR = 0;   { dderror }

  { Incorrect function. }
  ERROR_INVALID_FUNCTION = 1;   { dderror }

  { The system cannot find the file specified. }
  ERROR_FILE_NOT_FOUND = 2;

  { The system cannot find the path specified. }
  ERROR_PATH_NOT_FOUND = 3;

  { The system cannot open the file. }
  ERROR_TOO_MANY_OPEN_FILES = 4;

  { Access is denied. }
  ERROR_ACCESS_DENIED = 5;

  { The handle is invalid. }
  ERROR_INVALID_HANDLE = 6;

  { The storage control blocks were destroyed. }
  ERROR_ARENA_TRASHED = 7;

  { Not enough storage is available to process this command. }
  ERROR_NOT_ENOUGH_MEMORY = 8;   { dderror }

  { The storage control block address is invalid. }
  ERROR_INVALID_BLOCK = 9;

  { The environment is incorrect. }
  ERROR_BAD_ENVIRONMENT = 10;

  { An attempt was made to load a program with an incorrect format. }
  ERROR_BAD_FORMAT = 11;

  { The access code is invalid. }
  ERROR_INVALID_ACCESS = 12;

  { The data is invalid. }
  ERROR_INVALID_DATA = 13;

  { Not enough storage is available to complete this operation. }
  ERROR_OUTOFMEMORY = 14;

  { The system cannot find the drive specified. }
  ERROR_INVALID_DRIVE = 15;

  { The directory cannot be removed. }
  ERROR_CURRENT_DIRECTORY = $10;

  { The system cannot move the file }
  { to a different disk drive. }
  ERROR_NOT_SAME_DEVICE = 17;

  { There are no more files. }
  ERROR_NO_MORE_FILES = 18;

  { The media is write protected. }
  ERROR_WRITE_PROTECT = 19;

  { The system cannot find the device specified. }
  ERROR_BAD_UNIT = 20;

  { The device is not ready. }
  ERROR_NOT_READY = 21;

  { The device does not recognize the command. }
  ERROR_BAD_COMMAND = 22;

  { Data error (cyclic redundancy check) }
  ERROR_CRC = 23;

  { The program issued a command but the command length is incorrect. }
  ERROR_BAD_LENGTH = 24;

  { The drive cannot locate a specific area or track on the disk. }
  ERROR_SEEK = 25;

  { The specified disk or diskette cannot be accessed. }
  ERROR_NOT_DOS_DISK = 26;

  { The drive cannot find the sector requested. }
  ERROR_SECTOR_NOT_FOUND = 27;

  { The printer is out of paper. }
  ERROR_OUT_OF_PAPER = 28;

  { The system cannot write to the specified device. }
  ERROR_WRITE_FAULT = 29;

  { The system cannot read from the specified device. }
  ERROR_READ_FAULT = 30;

  { A device attached to the system is not functioning. }
  ERROR_GEN_FAILURE = 31;

  { The process cannot access the file because it is being used by another process. }
  ERROR_SHARING_VIOLATION = $20;

  { The process cannot access the file because }
  { another process has locked a portion of the file. }
  ERROR_LOCK_VIOLATION = 33;

  { The wrong diskette is in the drive. Insert %2 (Volume Serial Number: %3) }
  { into drive %1. }
  ERROR_WRONG_DISK = 34;

  { Too many files opened for sharing. }
  ERROR_SHARING_BUFFER_EXCEEDED = 36;

  { Reached end of file. }
  ERROR_HANDLE_EOF = 38;

  { The disk is full. }
  ERROR_HANDLE_DISK_FULL = 39;

  { The network request is not supported. }
  ERROR_NOT_SUPPORTED = 50;

  { The remote computer is not available. }
  ERROR_REM_NOT_LIST = 51;

  { A duplicate name exists on the network. }
  ERROR_DUP_NAME = 52;

  { The network path was not found. }
  ERROR_BAD_NETPATH = 53;

  { The network is busy. }
  ERROR_NETWORK_BUSY = 54;

  { The specified network resource or device is no longer }
  { available. }
  ERROR_DEV_NOT_EXIST = 55;   { dderror }

  { The network BIOS command limit has been reached. }
  ERROR_TOO_MANY_CMDS = 56;

  { A network adapter hardware error occurred. }
  ERROR_ADAP_HDW_ERR = 57;

  { The specified server cannot perform the requested }
  { operation. }
  ERROR_BAD_NET_RESP = 58;

  { An unexpected network error occurred. }
  ERROR_UNEXP_NET_ERR = 59;

  { The remote adapter is not compatible. }
  ERROR_BAD_REM_ADAP = 60;

  { The printer queue is full. }
  ERROR_PRINTQ_FULL = 61;

  { Space to store the file waiting to be printed is }
  { not available on the server. }
  ERROR_NO_SPOOL_SPACE = 62;

  { Your file waiting to be printed was deleted. }
  ERROR_PRINT_CANCELLED = 63;

  { The specified network name is no longer available. }
  ERROR_NETNAME_DELETED = $40;

  { Network access is denied. }
  ERROR_NETWORK_ACCESS_DENIED = 65;

  { The network resource type is not correct. }
  ERROR_BAD_DEV_TYPE = 66;

  { The network name cannot be found. }
  ERROR_BAD_NET_NAME = 67;

  { The name limit for the local computer network }
  { adapter card was exceeded. }
  ERROR_TOO_MANY_NAMES = 68;

  { The network BIOS session limit was exceeded. }
  ERROR_TOO_MANY_SESS = 69;

  { The remote server has been paused or is in the }
  { process of being started. }
  ERROR_SHARING_PAUSED = 70;

  { No more connections can be made to this remote computer at this time }
  { because there are already as many connections as the computer can accept. }
  ERROR_REQ_NOT_ACCEP = 71;

  { The specified printer or disk device has been paused. }
  ERROR_REDIR_PAUSED = 72;

  { The file exists. }
  ERROR_FILE_EXISTS = 80;

  { The directory or file cannot be created. }
  ERROR_CANNOT_MAKE = 82;

  { Fail on INT 24 }
  ERROR_FAIL_I24 = 83;

  { Storage to process this request is not available. }
  ERROR_OUT_OF_STRUCTURES = 84;

  { The local device name is already in use. }
  ERROR_ALREADY_ASSIGNED = 85;

  { The specified network password is not correct. }
  ERROR_INVALID_PASSWORD = 86;

  { The parameter is incorrect. }
  ERROR_INVALID_PARAMETER = 87;   { dderror }

  { A write fault occurred on the network. }
  ERROR_NET_WRITE_FAULT = 88;

  { The system cannot start another process at }
  { this time. }
  ERROR_NO_PROC_SLOTS = 89;

  { Cannot create another system semaphore. }
  ERROR_TOO_MANY_SEMAPHORES = 100;

  { The exclusive semaphore is owned by another process. }
  ERROR_EXCL_SEM_ALREADY_OWNED = 101;

  { The semaphore is set and cannot be closed. }
  ERROR_SEM_IS_SET = 102;

  { The semaphore cannot be set again. }
  ERROR_TOO_MANY_SEM_REQUESTS = 103;

  { Cannot request exclusive semaphores at interrupt time. }
  ERROR_INVALID_AT_INTERRUPT_TIME = 104;

  { The previous ownership of this semaphore has ended. }
  ERROR_SEM_OWNER_DIED = 105;

  { Insert the diskette for drive %1. }
  ERROR_SEM_USER_LIMIT = 106;

  { Program stopped because alternate diskette was not inserted. }
  ERROR_DISK_CHANGE = 107;

  { The disk is in use or locked by }
  { another process. }
  ERROR_DRIVE_LOCKED = 108;

  { The pipe has been ended. }
  ERROR_BROKEN_PIPE = 109;

  { The system cannot open the device or file specified. }
  ERROR_OPEN_FAILED = 110;

  { The file name is too long. }
  ERROR_BUFFER_OVERFLOW = 111;

  { There is not enough space on the disk. }
  ERROR_DISK_FULL = 112;

  { No more internal file identifiers available. }
  ERROR_NO_MORE_SEARCH_HANDLES = 113;

  { The target internal file identifier is incorrect. }
  ERROR_INVALID_TARGET_HANDLE = 114;

  { The IOCTL call made by the application program is not correct. }
  ERROR_INVALID_CATEGORY = 117;

  { The verify-on-write switch parameter value is not correct. }
  ERROR_INVALID_VERIFY_SWITCH = 118;

  { The system does not support the command requested. }
  ERROR_BAD_DRIVER_LEVEL = 119;

  { This function is only valid in Windows NT mode. }
  ERROR_CALL_NOT_IMPLEMENTED = 120;

  { The semaphore timeout period has expired. }
  ERROR_SEM_TIMEOUT = 121;

  { The data area passed to a system call is too small. }
  ERROR_INSUFFICIENT_BUFFER = 122;   { dderror }

  { The filename, directory name, or volume label syntax is incorrect. }
  ERROR_INVALID_NAME = 123;

  { The system call level is not correct. }
  ERROR_INVALID_LEVEL = 124;

  { The disk has no volume label. }
  ERROR_NO_VOLUME_LABEL = 125;

  { The specified module could not be found. }
  ERROR_MOD_NOT_FOUND = 126;

  { The specified procedure could not be found. }
  ERROR_PROC_NOT_FOUND = 127;

  { There are no child processes to wait for. }
  ERROR_WAIT_NO_CHILDREN = $80;

  { The %1 application cannot be run in Windows NT mode. }
  ERROR_CHILD_NOT_COMPLETE = 129;

  { Attempt to use a file handle to an open disk partition for an }
  { operation other than raw disk I/O. }
  ERROR_DIRECT_ACCESS_HANDLE = 130;

  { An attempt was made to move the file pointer before the beginning of the file. }
  ERROR_NEGATIVE_SEEK = 131;

  { The file pointer cannot be set on the specified device or file. }
  ERROR_SEEK_ON_DEVICE = 132;

  { A JOIN or SUBST command }
  { cannot be used for a drive that }
  { contains previously joined drives. }
  ERROR_IS_JOIN_TARGET = 133;

  { An attempt was made to use a }
  { JOIN or SUBST command on a drive that has }
  { already been joined. }
  ERROR_IS_JOINED = 134;

  { An attempt was made to use a }
  { JOIN or SUBST command on a drive that has }
  { already been substituted. }
  ERROR_IS_SUBSTED = 135;

  { The system tried to delete }
  { the JOIN of a drive that is not joined. }
  ERROR_NOT_JOINED = 136;

  { The system tried to delete the }
  { substitution of a drive that is not substituted. }
  ERROR_NOT_SUBSTED = 137;

  { The system tried to join a drive to a directory on a joined drive. }
  ERROR_JOIN_TO_JOIN = 138;

  { The system tried to substitute a drive to a directory on a substituted drive. }
  ERROR_SUBST_TO_SUBST = 139;

  { The system tried to join a drive to a directory on a substituted drive. }
  ERROR_JOIN_TO_SUBST = 140;

  { The system tried to SUBST a drive to a directory on a joined drive. }
  ERROR_SUBST_TO_JOIN = 141;

  { The system cannot perform a JOIN or SUBST at this time. }
  ERROR_BUSY_DRIVE = 142;

  { The system cannot join or substitute a }
  { drive to or for a directory on the same drive. }
  ERROR_SAME_DRIVE = 143;

  { The directory is not a subdirectory of the root directory. }
  ERROR_DIR_NOT_ROOT = 144;

  { The directory is not empty. }
  ERROR_DIR_NOT_EMPTY = 145;

  { The path specified is being used in a substitute. }
  ERROR_IS_SUBST_PATH = 146;

  { Not enough resources are available to process this command. }
  ERROR_IS_JOIN_PATH = 147;

  { The path specified cannot be used at this time. }
  ERROR_PATH_BUSY = 148;

  { An attempt was made to join or substitute a drive for which a directory }
  { on the drive is the target of a previous substitute. }
  ERROR_IS_SUBST_TARGET = 149;

  { System trace information was not specified in your }
  { CONFIG.SYS file, or tracing is disallowed. }
  ERROR_SYSTEM_TRACE = 150;

  { The number of specified semaphore events for }
  { DosMuxSemWait is not correct. }
  ERROR_INVALID_EVENT_COUNT = 151;

  { DosMuxSemWait did not execute; too many semaphores }
  { are already set. }
  ERROR_TOO_MANY_MUXWAITERS = 152;

  { The DosMuxSemWait list is not correct. }
  ERROR_INVALID_LIST_FORMAT = 153;

  {  The volume label you entered exceeds the label character }
  {  limit of the target file system. }
  ERROR_LABEL_TOO_LONG = 154;

  { Cannot create another thread. }
  ERROR_TOO_MANY_TCBS = 155;

  { The recipient process has refused the signal. }
  ERROR_SIGNAL_REFUSED = 156;

  { The segment is already discarded and cannot be locked. }
  ERROR_DISCARDED = 157;

  { The segment is already unlocked. }
  ERROR_NOT_LOCKED = 158;

  { The address for the thread ID is not correct. }
  ERROR_BAD_THREADID_ADDR = 159;

  { The argument string passed to DosExecPgm is not correct. }
  ERROR_BAD_ARGUMENTS = 160;

  { The specified path is invalid. }
  ERROR_BAD_PATHNAME = 161;

  { A signal is already pending. }
  ERROR_SIGNAL_PENDING = 162;

  { No more threads can be created in the system. }
  ERROR_MAX_THRDS_REACHED = 164;

  { Unable to lock a region of a file. }
  ERROR_LOCK_FAILED = 167;

  { The requested resource is in use. }
  ERROR_BUSY = 170;

  { A lock request was not outstanding for the supplied cancel region. }
  ERROR_CANCEL_VIOLATION = 173;

  { The file system does not support atomic changes to the lock type. }
  ERROR_ATOMIC_LOCKS_NOT_SUPPORTED = 174;

  { The system detected a segment number that was not correct. }
  ERROR_INVALID_SEGMENT_NUMBER = 180;

  { The operating system cannot run %1. }
  ERROR_INVALID_ORDINAL = 182;

  { Cannot create a file when that file already exists. }
  ERROR_ALREADY_EXISTS = 183;

  { The flag passed is not correct. }
  ERROR_INVALID_FLAG_NUMBER = 186;

  { The specified system semaphore name was not found. }
  ERROR_SEM_NOT_FOUND = 187;

  { The operating system cannot run %1. }
  ERROR_INVALID_STARTING_CODESEG = 188;

  { The operating system cannot run %1. }
  ERROR_INVALID_STACKSEG = 189;

  { The operating system cannot run %1. }
  ERROR_INVALID_MODULETYPE = 190;

  { Cannot run %1 in Windows NT mode. }
  ERROR_INVALID_EXE_SIGNATURE = 191;

  { The operating system cannot run %1. }
  ERROR_EXE_MARKED_INVALID = 192;

  { %1 is not a valid Windows NT application. }
  ERROR_BAD_EXE_FORMAT = 193;

  { The operating system cannot run %1. }
  ERROR_ITERATED_DATA_EXCEEDS_64k = 194;

  { The operating system cannot run %1. }
  ERROR_INVALID_MINALLOCSIZE = 195;

  { The operating system cannot run this application program. }
  ERROR_DYNLINK_FROM_INVALID_RING = 196;

  { The operating system is not presently configured to run this application. }
  ERROR_IOPL_NOT_ENABLED = 197;

  { The operating system cannot run %1. }
  ERROR_INVALID_SEGDPL = 198;

  { The operating system cannot run this }
  { application program. }
  ERROR_AUTODATASEG_EXCEEDS_64k = 199;

  { The code segment cannot be greater than or equal to 64KB. }
  ERROR_RING2SEG_MUST_BE_MOVABLE = 200;

  { The operating system cannot run %1. }
  ERROR_RELOC_CHAIN_XEEDS_SEGLIM = 201;

  { The operating system cannot run %1. }
  ERROR_INFLOOP_IN_RELOC_CHAIN = 202;

  { The system could not find the environment option that was entered. }
  ERROR_ENVVAR_NOT_FOUND = 203;

  { No process in the command subtree has a signal handler. }
  ERROR_NO_SIGNAL_SENT = 205;

  { The filename or extension is too long. }
  ERROR_FILENAME_EXCED_RANGE = 206;

  { The ring 2 stack is in use. }
  ERROR_RING2_STACK_IN_USE = 207;

  { The global filename characters, * or ?, are entered }
  { incorrectly or too many global filename characters are specified. }
  ERROR_META_EXPANSION_TOO_LONG = 208;

  { The signal being posted is not correct. }
  ERROR_INVALID_SIGNAL_NUMBER = 209;

  { The signal handler cannot be set. }
  ERROR_THREAD_1_INACTIVE = 210;

  { The segment is locked and cannot be reallocated. }
  ERROR_LOCKED = 212;

  { Too many dynamic link modules are attached to this }
  { program or dynamic link module. }
  ERROR_TOO_MANY_MODULES = 214;

  { Can't nest calls to LoadModule. }
  ERROR_NESTING_NOT_ALLOWED = 215;

  {  The image file %1 is valid, but is for a machine type other }
  {  than the current machine. }
  ERROR_EXE_MACHINE_TYPE_MISMATCH = 216;

  { The pipe state is invalid. }
  ERROR_BAD_PIPE = 230;

  { All pipe instances are busy. }
  ERROR_PIPE_BUSY = 231;

  { The pipe is being closed. }
  ERROR_NO_DATA = 232;

  { No process is on the other end of the pipe. }
  ERROR_PIPE_NOT_CONNECTED = 233;

  { More data is available. }
  ERROR_MORE_DATA = 234;   { dderror }

  { The session was cancelled. }
  ERROR_VC_DISCONNECTED = 240;

  { The specified extended attribute name was invalid. }
  ERROR_INVALID_EA_NAME = 254;

  { The extended attributes are inconsistent. }
  ERROR_EA_LIST_INCONSISTENT = 255;

  { No more data is available. }
  ERROR_NO_MORE_ITEMS = 259;

  { The Copy API cannot be used. }
  ERROR_CANNOT_COPY = 266;

  { The directory name is invalid. }
  ERROR_DIRECTORY = 267;

  { The extended attributes did not fit in the buffer. }
  ERROR_EAS_DIDNT_FIT = 275;

  { The extended attribute file on the mounted file system is corrupt. }
  ERROR_EA_FILE_CORRUPT = 276;

  { The extended attribute table file is full. }
  ERROR_EA_TABLE_FULL = 277;

  { The specified extended attribute handle is invalid. }
  ERROR_INVALID_EA_HANDLE = 278;

  { The mounted file system does not support extended attributes. }
  ERROR_EAS_NOT_SUPPORTED = 282;

  { Attempt to release mutex not owned by caller. }
  ERROR_NOT_OWNER = 288;

  { Too many posts were made to a semaphore. }
  ERROR_TOO_MANY_POSTS = 298;

  { Only part of a Read/WriteProcessMemory request was completed. }
  ERROR_PARTIAL_COPY = 299;

  { The system cannot find message for message number $%1 }
  { in message file for %2. }
  ERROR_MR_MID_NOT_FOUND = 317;

  { Attempt to access invalid address. }
  ERROR_INVALID_ADDRESS = 487;

  { Arithmetic result exceeded 32 bits. }
  ERROR_ARITHMETIC_OVERFLOW = 534;

  { There is a process on other end of the pipe. }
  ERROR_PIPE_CONNECTED = 535;

  { Waiting for a process to open the other end of the pipe. }
  ERROR_PIPE_LISTENING = 536;

  { Access to the extended attribute was denied. }
  ERROR_EA_ACCESS_DENIED = 994;

  { The I/O operation has been aborted because of either a thread exit }
  { or an application request. }
  ERROR_OPERATION_ABORTED = 995;

  { Overlapped I/O event is not in a signalled state. }
  ERROR_IO_INCOMPLETE = 996;

  { Overlapped I/O operation is in progress. }
  ERROR_IO_PENDING = 997;   { dderror }

  { Invalid access to memory location. }
  ERROR_NOACCESS = 998;

  { Error performing inpage operation. }
  ERROR_SWAPERROR = 999;

  { Recursion too deep, stack overflowed. }
  ERROR_STACK_OVERFLOW = 1001;

  { The window cannot act on the sent message. }
  ERROR_INVALID_MESSAGE = 1002;

  { Cannot complete this function. }
  ERROR_CAN_NOT_COMPLETE = 1003;

  { Invalid flags. }
  ERROR_INVALID_FLAGS = 1004;

  { The volume does not contain a recognized file system. }
  { Please make sure that all required file system drivers are loaded and that the }
  { volume is not corrupt. }
  ERROR_UNRECOGNIZED_VOLUME = 1005;

  { The volume for a file has been externally altered such that the }
  { opened file is no longer valid. }
  ERROR_FILE_INVALID = 1006;

  { The requested operation cannot be performed in full-screen mode. }
  ERROR_FULLSCREEN_MODE = 1007;

  { An attempt was made to reference a token that does not exist. }
  ERROR_NO_TOKEN = 1008;

  { The configuration registry database is corrupt. }
  ERROR_BADDB = 1009;

  { The configuration registry key is invalid. }
  ERROR_BADKEY = 1010;

  { The configuration registry key could not be opened. }
  ERROR_CANTOPEN = 1011;

  { The configuration registry key could not be read. }
  ERROR_CANTREAD = 1012;

  { The configuration registry key could not be written. }
  ERROR_CANTWRITE = 1013;

  { One of the files in the Registry database had to be recovered }
  { by use of a log or alternate copy.  The recovery was successful. }
  ERROR_REGISTRY_RECOVERED = 1014;

  { The Registry is corrupt. The structure of one of the files that contains }
  { Registry data is corrupt, or the system's image of the file in memory }
  { is corrupt, or the file could not be recovered because the alternate }
  { copy or log was absent or corrupt. }
  ERROR_REGISTRY_CORRUPT = 1015;

  { An I/O operation initiated by the Registry failed unrecoverably. }
  { The Registry could not read in, or write out, or flush, one of the files }
  { that contain the system's image of the Registry. }
  ERROR_REGISTRY_IO_FAILED = 1016;

  { The system has attempted to load or restore a file into the Registry, but the }
  { specified file is not in a Registry file format. }
  ERROR_NOT_REGISTRY_FILE = 1017;

  { Illegal operation attempted on a Registry key which has been marked for deletion. }
  ERROR_KEY_DELETED = 1018;

  { System could not allocate the required space in a Registry log. }
  ERROR_NO_LOG_SPACE = 1019;

  { Cannot create a symbolic link in a Registry key that already }
  { has subkeys or values. }
  ERROR_KEY_HAS_CHILDREN = 1020;

  { Cannot create a stable subkey under a volatile parent key. }
  ERROR_CHILD_MUST_BE_VOLATILE = 1021;

  { A notify change request is being completed and the information }
  { is not being returned in the caller's buffer. The caller now }
  { needs to enumerate the files to find the changes. }
  ERROR_NOTIFY_ENUM_DIR = 1022;

  { A stop control has been sent to a service which other running services }
  { are dependent on. }
  ERROR_DEPENDENT_SERVICES_RUNNING = 1051;

  { The requested control is not valid for this service }
  ERROR_INVALID_SERVICE_CONTROL = 1052;

  { The service did not respond to the start or control request in a timely }
  { fashion. }
  ERROR_SERVICE_REQUEST_TIMEOUT = 1053;

  { A thread could not be created for the service. }
  ERROR_SERVICE_NO_THREAD = 1054;

  { The service database is locked. }
  ERROR_SERVICE_DATABASE_LOCKED = 1055;

  { An instance of the service is already running. }
  ERROR_SERVICE_ALREADY_RUNNING = 1056;

  { The account name is invalid or does not exist. }
  ERROR_INVALID_SERVICE_ACCOUNT = 1057;

  { The specified service is disabled and cannot be started. }
  ERROR_SERVICE_DISABLED = 1058;

  { Circular service dependency was specified. }
  ERROR_CIRCULAR_DEPENDENCY = 1059;

  { The specified service does not exist as an installed service. }
  ERROR_SERVICE_DOES_NOT_EXIST = 1060;

  { The service cannot accept control messages at this time. }
  ERROR_SERVICE_CANNOT_ACCEPT_CTRL = 1061;

  { The service has not been started. }
  ERROR_SERVICE_NOT_ACTIVE = 1062;

  { The service process could not connect to the service controller. }
  ERROR_FAILED_SERVICE_CONTROLLER_ = 1063;

  { An exception occurred in the service when handling the control request. }
  ERROR_EXCEPTION_IN_SERVICE = 1064;

  { The database specified does not exist. }
  ERROR_DATABASE_DOES_NOT_EXIST = 1065;

  { The service has returned a service-specific error code. }
  ERROR_SERVICE_SPECIFIC_ERROR = 1066;

  { The process terminated unexpectedly. }
  ERROR_PROCESS_ABORTED = 1067;

  { The dependency service or group failed to start. }
  ERROR_SERVICE_DEPENDENCY_FAIL = 1068;

  { The service did not start due to a logon failure. }
  ERROR_SERVICE_LOGON_FAILED = 1069;

  { After starting, the service hung in a start-pending state. }
  ERROR_SERVICE_START_HANG = 1070;

  { The specified service database lock is invalid. }
  ERROR_INVALID_SERVICE_LOCK = 1071;

  { The specified service has been marked for deletion. }
  ERROR_SERVICE_MARKED_FOR_DELETE = 1072;

  { The specified service already exists. }
  ERROR_SERVICE_EXISTS = 1073;

  { The system is currently running with the last-known-good configuration. }
  ERROR_ALREADY_RUNNING_LKG = 1074;

  { The dependency service does not exist or has been marked for }
  { deletion. }
  ERROR_SERVICE_DEPENDENCY_DELETED = 1075;

  { The current boot has already been accepted for use as the }
  { last-known-good control set. }
  ERROR_BOOT_ALREADY_ACCEPTED = 1076;

  { No attempts to start the service have been made since the last boot. }
  ERROR_SERVICE_NEVER_STARTED = 1077;

  { The name is already in use as either a service name or a service display }
  { name. }
  ERROR_DUPLICATE_SERVICE_NAME = 1078;

  {  The account specified for this service is different from the account }
  {  specified for other services running in the same process. }
  ERROR_DIFFERENT_SERVICE_ACCOUNT = 1079;

  { The physical end of the tape has been reached. }
  ERROR_END_OF_MEDIA = 1100;

  { A tape access reached a filemark. }
  ERROR_FILEMARK_DETECTED = 1101;

  { Beginning of tape or partition was encountered. }
  ERROR_BEGINNING_OF_MEDIA = 1102;

  { A tape access reached the end of a set of files. }
  ERROR_SETMARK_DETECTED = 1103;

  { No more data is on the tape. }
  ERROR_NO_DATA_DETECTED = 1104;

  { Tape could not be partitioned. }
  ERROR_PARTITION_FAILURE = 1105;

  { When accessing a new tape of a multivolume partition, the current }
  { blocksize is incorrect. }
  ERROR_INVALID_BLOCK_LENGTH = 1106;

  { Tape partition information could not be found when loading a tape. }
  ERROR_DEVICE_NOT_PARTITIONED = 1107;

  { Unable to lock the media eject mechanism. }
  ERROR_UNABLE_TO_LOCK_MEDIA = 1108;

  { Unable to unload the media. }
  ERROR_UNABLE_TO_UNLOAD_MEDIA = 1109;

  { Media in drive may have changed. }
  ERROR_MEDIA_CHANGED = 1110;

  { The I/O bus was reset. }
  ERROR_BUS_RESET = 1111;

  { No media in drive. }
  ERROR_NO_MEDIA_IN_DRIVE = 1112;

  { No mapping for the Unicode character exists in the target multi-byte code page. }
  ERROR_NO_UNICODE_TRANSLATION = 1113;

  { A dynamic link library (DLL) initialization routine failed. }
  ERROR_DLL_INIT_FAILED = 1114;

  { A system shutdown is in progress. }
  ERROR_SHUTDOWN_IN_PROGRESS = 1115;

  { Unable to abort the system shutdown because no shutdown was in progress. }
  ERROR_NO_SHUTDOWN_IN_PROGRESS = 1116;

  { The request could not be performed because of an I/O device error. }
  ERROR_IO_DEVICE = 1117;

  { No serial device was successfully initialized.  The serial driver will unload. }
  ERROR_SERIAL_NO_DEVICE = 1118;

  { Unable to open a device that was sharing an interrupt request (IRQ) }
  { with other devices. At least one other device that uses that IRQ }
  { was already opened. }
  ERROR_IRQ_BUSY = 1119;

  { A serial I/O operation was completed by another write to the serial port. }
  { (The IOCTL_SERIAL_XOFF_COUNTER reached zero.) }
  ERROR_MORE_WRITES = 1120;

  { A serial I/O operation completed because the time-out period expired. }
  { (The IOCTL_SERIAL_XOFF_COUNTER did not reach zero.) }
  ERROR_COUNTER_TIMEOUT = 1121;

  { No ID address mark was found on the floppy disk. }
  ERROR_FLOPPY_ID_MARK_NOT_FOUND = 1122;

  { Mismatch between the floppy disk sector ID field and the floppy disk }
  { controller track address. }
  ERROR_FLOPPY_WRONG_CYLINDER = 1123;

  { The floppy disk controller reported an error that is not recognized }
  { by the floppy disk driver. }
  ERROR_FLOPPY_UNKNOWN_ERROR = 1124;

  { The floppy disk controller returned inconsistent results in its registers. }
  ERROR_FLOPPY_BAD_REGISTERS = 1125;

  { While accessing the hard disk, a recalibrate operation failed, even after retries. }
  ERROR_DISK_RECALIBRATE_FAILED = 1126;

  { While accessing the hard disk, a disk operation failed even after retries. }
  ERROR_DISK_OPERATION_FAILED = 1127;

  { While accessing the hard disk, a disk controller reset was needed, but }
  { even that failed. }
  ERROR_DISK_RESET_FAILED = 1128;

  { Physical end of tape encountered. }
  ERROR_EOM_OVERFLOW = 1129;

  { Not enough server storage is available to process this command. }
  ERROR_NOT_ENOUGH_SERVER_MEMORY = 1130;

  { A potential deadlock condition has been detected. }
  ERROR_POSSIBLE_DEADLOCK = 1131;

  { The base address or the file offset specified does not have the proper }
  { alignment. }
  ERROR_MAPPED_ALIGNMENT = 1132;

  { An attempt to change the system power state was vetoed by another }
  { application or driver. }
  ERROR_SET_POWER_STATE_VETOED = 1140;

  { The system BIOS failed an attempt to change the system power state. }
  ERROR_SET_POWER_STATE_FAILED = 1141;

  {  An attempt was made to create more links on a file than }
  {  the file system supports. }
  ERROR_TOO_MANY_LINKS = 1142;

  { The specified program requires a newer version of Windows. }
  ERROR_OLD_WIN_VERSION = 1150;

  { The specified program is not a Windows or MS-DOS program. }
  ERROR_APP_WRONG_OS = 1151;

  { Cannot start more than one instance of the specified program. }
  ERROR_SINGLE_INSTANCE_APP = 1152;

  {  The specified program was written for an older version of Windows. }
  ERROR_RMODE_APP = 1153;

  { One of the library files needed to run this application is damaged. }
  ERROR_INVALID_DLL = 1154;

  { No application is associated with the specified file for this operation. }
  ERROR_NO_ASSOCIATION = 1155;

  { An error occurred in sending the command to the application. }
  ERROR_DDE_FAIL = 1156;

  { One of the library files needed to run this application cannot be found. }
  ERROR_DLL_NOT_FOUND = 1157;


{ Winnet32 Status Codes }

  { The specified username is invalid. }
  ERROR_BAD_USERNAME = 2202;

  { This network connection does not exist. }
  ERROR_NOT_CONNECTED = 2250;

  { This network connection has files open or requests pending. }
  ERROR_OPEN_FILES = 2401;

  { Active connections still exist. }
  ERROR_ACTIVE_CONNECTIONS = 2402;

  { The device is in use by an active process and cannot be disconnected. }
  ERROR_DEVICE_IN_USE = 2404;

  { The specified device name is invalid. }
  ERROR_BAD_DEVICE = 1200;

  { The device is not currently connected but it is a remembered connection. }
  ERROR_CONNECTION_UNAVAIL = 1201;

  { An attempt was made to remember a device that had previously been remembered. }
  ERROR_DEVICE_ALREADY_REMEMBERED = 1202;

  { No network provider accepted the given network path. }
  ERROR_NO_NET_OR_BAD_PATH = 1203;

  { The specified network provider name is invalid. }
  ERROR_BAD_PROVIDER = 1204;

  { Unable to open the network connection profile. }
  ERROR_CANNOT_OPEN_PROFILE = 1205;

  { The network connection profile is corrupt. }
  ERROR_BAD_PROFILE = 1206;

  { Cannot enumerate a non-container. }
  ERROR_NOT_CONTAINER = 1207;

  { An extended error has occurred. }
  ERROR_EXTENDED_ERROR = 1208;

  { The format of the specified group name is invalid. }
  ERROR_INVALID_GROUPNAME = 1209;

  { The format of the specified computer name is invalid. }
  ERROR_INVALID_COMPUTERNAME = 1210;

  { The format of the specified event name is invalid. }
  ERROR_INVALID_EVENTNAME = 1211;

  { The format of the specified domain name is invalid. }
  ERROR_INVALID_DOMAINNAME = 1212;

  { The format of the specified service name is invalid. }
  ERROR_INVALID_SERVICENAME = 1213;

  { The format of the specified network name is invalid. }
  ERROR_INVALID_NETNAME = 1214;

  { The format of the specified share name is invalid. }
  ERROR_INVALID_SHARENAME = 1215;

  { The format of the specified password is invalid. }
  ERROR_INVALID_PASSWORDNAME = 1216;

  { The format of the specified message name is invalid. }
  ERROR_INVALID_MESSAGENAME = 1217;

  { The format of the specified message destination is invalid. }
  ERROR_INVALID_MESSAGEDEST = 1218;

  { The credentials supplied conflict with an existing set of credentials. }
  ERROR_SESSION_CREDENTIAL_CONFLICT = 1219;

  { An attempt was made to establish a session to a network server, but there }
  { are already too many sessions established to that server. }
  ERROR_REMOTE_SESSION_LIMIT_EXCEEDED = 1220;

  { The workgroup or domain name is already in use by another computer on the }
  { network. }
  ERROR_DUP_DOMAINNAME = 1221;

  { The network is not present or not started. }
  ERROR_NO_NETWORK = 1222;

  { The operation was cancelled by the user. }
  ERROR_CANCELLED = 1223;

  { The requested operation cannot be performed on a file with a user mapped section open. }
  ERROR_USER_MAPPED_FILE = 1224;

  { The remote system refused the network connection. }
  ERROR_CONNECTION_REFUSED = 1225;

  { The network connection was gracefully closed. }
  ERROR_GRACEFUL_DISCONNECT = 1226;

  { The network transport endpoint already has an address associated with it. }
  ERROR_ADDRESS_ALREADY_ASSOCIATED = 1227;

  { An address has not yet been associated with the network endpoint. }
  ERROR_ADDRESS_NOT_ASSOCIATED = 1228;

  { An operation was attempted on a non-existent network connection. }
  ERROR_CONNECTION_INVALID = 1229;

  { An invalid operation was attempted on an active network connection. }
  ERROR_CONNECTION_ACTIVE = 1230;

  { The remote network is not reachable by the transport. }
  ERROR_NETWORK_UNREACHABLE = 1231;

  { The remote system is not reachable by the transport. }
  ERROR_HOST_UNREACHABLE = 1232;

  { The remote system does not support the transport protocol. }
  ERROR_PROTOCOL_UNREACHABLE = 1233;

  { No service is operating at the destination network endpoint }
  { on the remote system. }
  ERROR_PORT_UNREACHABLE = 1234;

  { The request was aborted. }
  ERROR_REQUEST_ABORTED = 1235;

  { The network connection was aborted by the local system. }
  ERROR_CONNECTION_ABORTED = 1236;

  { The operation could not be completed.  A retry should be performed. }
  ERROR_RETRY = 1237;

  { A connection to the server could not be made because the limit on the number of }
  { concurrent connections for this account has been reached. }
  ERROR_CONNECTION_COUNT_LIMIT = 1238;

  { Attempting to login during an unauthorized time of day for this account. }
  ERROR_LOGIN_TIME_RESTRICTION = 1239;

  { The account is not authorized to login from this station. }
  ERROR_LOGIN_WKSTA_RESTRICTION = 1240;

  { The network address could not be used for the operation requested. }
  ERROR_INCORRECT_ADDRESS = 1241;

  { The service is already registered. }
  ERROR_ALREADY_REGISTERED = 1242;

  { The specified service does not exist. }
  ERROR_SERVICE_NOT_FOUND = 1243;

  { The operation being requested was not performed because the user }
  { has not been authenticated. }
  ERROR_NOT_AUTHENTICATED = 1244;

  { The operation being requested was not performed because the user }
  { has not logged on to the network. }
  { The specified service does not exist. }
  ERROR_NOT_LOGGED_ON = 1245;

  { Return that wants caller to continue with work in progress. }
  ERROR_CONTINUE = 1246;

  { An attempt was made to perform an initialization operation when }
  { initialization has already been completed. }
  ERROR_ALREADY_INITIALIZED = 1247;

  { No more local devices. }
  ERROR_NO_MORE_DEVICES = 1248;


{ Security Status Codes }

  { Not all privileges referenced are assigned to the caller. }
  ERROR_NOT_ALL_ASSIGNED = 1300;

  { Some mapping between account names and security IDs was not done. }
  ERROR_SOME_NOT_MAPPED = 1301;

  { No system quota limits are specifically set for this account. }
  ERROR_NO_QUOTAS_FOR_ACCOUNT = 1302;

  { No encryption key is available.  A well-known encryption key was returned. }
  ERROR_LOCAL_USER_SESSION_KEY = 1303;

  { The NT password is too complex to be converted to a LAN Manager }
  { password.  The LAN Manager password returned is a NULL string. }
  ERROR_NULL_LM_PASSWORD = 1304;

  { The revision level is unknown. }
  ERROR_UNKNOWN_REVISION = 1305;

  { Indicates two revision levels are incompatible. }
  ERROR_REVISION_MISMATCH = 1306;

  { This security ID may not be assigned as the owner of this object. }
  ERROR_INVALID_OWNER = 1307;

  { This security ID may not be assigned as the primary group of an object. }
  ERROR_INVALID_PRIMARY_GROUP = 1308;

  { An attempt has been made to operate on an impersonation token }

  { by a thread that is not currently impersonating a client. }
  ERROR_NO_IMPERSONATION_TOKEN = 1309;

  { The group may not be disabled. }
  ERROR_CANT_DISABLE_MANDATORY = 1310;

  { There are currently no logon servers available to service the logon }
  { request. }
  ERROR_NO_LOGON_SERVERS = 1311;

  {  A specified logon session does not exist.  It may already have }
  {  been terminated. }
  ERROR_NO_SUCH_LOGON_SESSION = 1312;

  {  A specified privilege does not exist. }
  ERROR_NO_SUCH_PRIVILEGE = 1313;

  {  A required privilege is not held by the client. }
  ERROR_PRIVILEGE_NOT_HELD = 1314;

  { The name provided is not a properly formed account name. }
  ERROR_INVALID_ACCOUNT_NAME = 1315;

  { The specified user already exists. }
  ERROR_USER_EXISTS = 1316;

  { The specified user does not exist. }
  ERROR_NO_SUCH_USER = 1317;

  { The specified group already exists. }
  ERROR_GROUP_EXISTS = 1318;

  { The specified group does not exist. }
  ERROR_NO_SUCH_GROUP = 1319;

  { Either the specified user account is already a member of the specified }
  { group, or the specified group cannot be deleted because it contains }
  { a member. }
  ERROR_MEMBER_IN_GROUP = 1320;

  { The specified user account is not a member of the specified group account. }
  ERROR_MEMBER_NOT_IN_GROUP = 1321;

  { The last remaining administration account cannot be disabled }
  { or deleted. }
  ERROR_LAST_ADMIN = 1322;

  { Unable to update the password.  The value provided as the current }
  { password is incorrect. }
  ERROR_WRONG_PASSWORD = 1323;

  { Unable to update the password.  The value provided for the new password }
  { contains values that are not allowed in passwords. }
  ERROR_ILL_FORMED_PASSWORD = 1324;

  { Unable to update the password because a password update rule has been }
  { violated. }
  ERROR_PASSWORD_RESTRICTION = 1325;

  { Logon failure: unknown user name or bad password. }
  ERROR_LOGON_FAILURE = 1326;

  { Logon failure: user account restriction. }
  ERROR_ACCOUNT_RESTRICTION = 1327;

  { Logon failure: account logon time restriction violation. }
  ERROR_INVALID_LOGON_HOURS = 1328;

  { Logon failure: user not allowed to log on to this computer. }
  ERROR_INVALID_WORKSTATION = 1329;

  { Logon failure: the specified account password has expired. }
  ERROR_PASSWORD_EXPIRED = 1330;

  { Logon failure: account currently disabled. }
  ERROR_ACCOUNT_DISABLED = 1331;

  { No mapping between account names and security IDs was done. }
  ERROR_NONE_MAPPED = 1332;

  { Too many local user identifiers (LUIDs) were requested at one time. }
  ERROR_TOO_MANY_LUIDS_REQUESTED = 1333;

  { No more local user identifiers (LUIDs) are available. }
  ERROR_LUIDS_EXHAUSTED = 1334;

  { The subauthority part of a security ID is invalid for this particular use. }
  ERROR_INVALID_SUB_AUTHORITY = 1335;

  { The access control list (ACL) structure is invalid. }
  ERROR_INVALID_ACL = 1336;

  { The security ID structure is invalid. }
  ERROR_INVALID_SID = 1337;

  { The security descriptor structure is invalid. }
  ERROR_INVALID_SECURITY_DESCR = 1338;

  { The inherited access control list (ACL) or access control entry (ACE) }
  { could not be built. }
  ERROR_BAD_INHERITANCE_ACL = 1340;

  { The server is currently disabled. }
  ERROR_SERVER_DISABLED = 1341;

  { The server is currently enabled. }
  ERROR_SERVER_NOT_DISABLED = 1342;

  { The value provided was an invalid value for an identifier authority. }
  ERROR_INVALID_ID_AUTHORITY = 1343;

  { No more memory is available for security information updates. }
  ERROR_ALLOTTED_SPACE_EXCEEDED = 1344;

  { The specified attributes are invalid, or incompatible with the }

  { attributes for the group as a whole. }
  ERROR_INVALID_GROUP_ATTRIBUTES = 1345;

  { Either a required impersonation level was not provided, or the }
  { provided impersonation level is invalid. }
  ERROR_BAD_IMPERSONATION_LEVEL = 1346;

  { Cannot open an anonymous level security token. }
  ERROR_CANT_OPEN_ANONYMOUS = 1347;

  { The validation information class requested was invalid. }
  ERROR_BAD_VALIDATION_CLASS = 1348;

  { The type of the token is inappropriate for its attempted use. }
  ERROR_BAD_TOKEN_TYPE = 1349;

  { Unable to perform a security operation on an object }
  { which has no associated security. }
  ERROR_NO_SECURITY_ON_OBJECT = 1350;

  { Indicates a Windows NT Server could not be contacted or that }
  { objects within the domain are protected such that necessary }
  { information could not be retrieved. }
  ERROR_CANT_ACCESS_DOMAIN_INFO = 1351;

  { The security account manager (SAM) or local security }
  { authority (LSA) server was in the wrong state to perform }
  { the security operation. }
  ERROR_INVALID_SERVER_STATE = 1352;

  { The domain was in the wrong state to perform the security operation. }
  ERROR_INVALID_DOMAIN_STATE = 1353;

  { This operation is only allowed for the Primary Domain Controller of the domain. }
  ERROR_INVALID_DOMAIN_ROLE = 1354;

  { The specified domain did not exist. }
  ERROR_NO_SUCH_DOMAIN = 1355;

  { The specified domain already exists. }
  ERROR_DOMAIN_EXISTS = 1356;

  { An attempt was made to exceed the limit on the number of domains per server. }
  ERROR_DOMAIN_LIMIT_EXCEEDED = 1357;

  { Unable to complete the requested operation because of either a }
  { catastrophic media failure or a data structure corruption on the disk. }
  ERROR_INTERNAL_DB_CORRUPTION = 1358;

  { The security account database contains an internal inconsistency. }
  ERROR_INTERNAL_ERROR = 1359;

  { Generic access types were contained in an access mask which should }
  { already be mapped to non-generic types. }
  ERROR_GENERIC_NOT_MAPPED = 1360;

  { A security descriptor is not in the right format (absolute or self-relative). }
  ERROR_BAD_DESCRIPTOR_FORMAT = 1361;

  { The requested action is restricted for use by logon processes }
  { only.  The calling process has not registered as a logon process. }
  ERROR_NOT_LOGON_PROCESS = 1362;

  { Cannot start a new logon session with an ID that is already in use. }
  ERROR_LOGON_SESSION_EXISTS = 1363;

  { A specified authentication package is unknown. }
  ERROR_NO_SUCH_PACKAGE = 1364;

  { The logon session is not in a state that is consistent with the }
  { requested operation. }
  ERROR_BAD_LOGON_SESSION_STATE = 1365;

  { The logon session ID is already in use. }
  ERROR_LOGON_SESSION_COLLISION = 1366;

  { A logon request contained an invalid logon type value. }
  ERROR_INVALID_LOGON_TYPE = 1367;

  { Unable to impersonate via a named pipe until data has been read }
  { from that pipe. }
  ERROR_CANNOT_IMPERSONATE = 1368;

  { The transaction state of a Registry subtree is incompatible with the }
  { requested operation. }
  ERROR_RXACT_INVALID_STATE = 1369;

  { An internal security database corruption has been encountered. }
  ERROR_RXACT_COMMIT_FAILURE = 1370;

  { Cannot perform this operation on built-in accounts. }
  ERROR_SPECIAL_ACCOUNT = 1371;

  { Cannot perform this operation on this built-in special group. }
  ERROR_SPECIAL_GROUP = 1372;

  { Cannot perform this operation on this built-in special user. }
  ERROR_SPECIAL_USER = 1373;

  { The user cannot be removed from a group because the group }
  { is currently the user's primary group. }
  ERROR_MEMBERS_PRIMARY_GROUP = 1374;

  { The token is already in use as a primary token. }
  ERROR_TOKEN_ALREADY_IN_USE = 1375;

  { The specified local group does not exist. }
  ERROR_NO_SUCH_ALIAS = 1376;

  { The specified account name is not a member of the local group. }
  ERROR_MEMBER_NOT_IN_ALIAS = 1377;

  { The specified account name is already a member of the local group. }
  ERROR_MEMBER_IN_ALIAS = 1378;

  { The specified local group already exists. }
  ERROR_ALIAS_EXISTS = 1379;

  { Logon failure: the user has not been granted the requested }
  { logon type at this computer. }
  ERROR_LOGON_NOT_GRANTED = 1380;

  { The maximum number of secrets that may be stored in a single system has been }
  { exceeded. }
  ERROR_TOO_MANY_SECRETS = 1381;

  { The length of a secret exceeds the maximum length allowed. }
  ERROR_SECRET_TOO_LONG = 1382;

  { The local security authority database contains an internal inconsistency. }
  ERROR_INTERNAL_DB_ERROR = 1383;

  { During a logon attempt, the user's security context accumulated too many }
  { security IDs. }
  ERROR_TOO_MANY_CONTEXT_IDS = 1384;

  { Logon failure: the user has not been granted the requested logon type }
  { at this computer. }
  ERROR_LOGON_TYPE_NOT_GRANTED = 1385;

  { A cross-encrypted password is necessary to change a user password. }
  ERROR_NT_CROSS_ENCRYPTION_REQUIRED = 1386;

  { A new member could not be added to a local group because the member does }
  { not exist. }
  ERROR_NO_SUCH_MEMBER = 1387;

  { A new member could not be added to a local group because the member has the }
  { wrong account type. }
  ERROR_INVALID_MEMBER = 1388;

  { Too many security IDs have been specified. }
  ERROR_TOO_MANY_SIDS = 1389;

  { A cross-encrypted password is necessary to change this user password. }
  ERROR_LM_CROSS_ENCRYPTION_REQUIRED = 1390;

  { Indicates an TACL contains no inheritable components }
  ERROR_NO_INHERITANCE = 1391;

  { The file or directory is corrupt and non-readable. }
  ERROR_FILE_CORRUPT = 1392;

  { The disk structure is corrupt and non-readable. }
  ERROR_DISK_CORRUPT = 1393;

  { There is no user session key for the specified logon session. }
  ERROR_NO_USER_SESSION_KEY = 1394;

  { The service being accessed is licensed for a particular number of connections. }
  { No more connections can be made to the service at this time }
  { because there are already as many connections as the service can accept. }
  ERROR_LICENSE_QUOTA_EXCEEDED = 1395;


{ WinUser Error Codes }

  { Invalid window handle. }
  ERROR_INVALID_WINDOW_HANDLE = 1400;

  { Invalid menu handle. }
  ERROR_INVALID_MENU_HANDLE = 1401;

  { Invalid cursor handle. }
  ERROR_INVALID_CURSOR_HANDLE = 1402;

  { Invalid accelerator table handle. }
  ERROR_INVALID_ACCEL_HANDLE = 1403;

  { Invalid hook handle. }
  ERROR_INVALID_HOOK_HANDLE = 1404;

  { Invalid handle to a multiple-window position structure. }
  ERROR_INVALID_DWP_HANDLE = 1405;

  { Cannot create a top-level child window. }
  ERROR_TLW_WITH_WSCHILD = 1406;

  { Cannot find window class. }
  ERROR_CANNOT_FIND_WND_CLASS = 1407;

  { Invalid window, belongs to other thread. }
  ERROR_WINDOW_OF_OTHER_THREAD = 1408;

  { Hot key is already registered. }
  ERROR_HOTKEY_ALREADY_REGISTERED = 1409;

  { Class already exists. }
  ERROR_CLASS_ALREADY_EXISTS = 1410;

  { Class does not exist. }
  ERROR_CLASS_DOES_NOT_EXIST = 1411;

  { Class still has open windows. }
  ERROR_CLASS_HAS_WINDOWS = 1412;

  { Invalid index. }
  ERROR_INVALID_INDEX = 1413;

  { Invalid icon handle. }
  ERROR_INVALID_ICON_HANDLE = 1414;

  { Using private DIALOG window words. }
  ERROR_PRIVATE_DIALOG_INDEX = 1415;

  { The listbox identifier was not found. }
  ERROR_LISTBOX_ID_NOT_FOUND = 1416;

  { No wildcards were found. }
  ERROR_NO_WILDCARD_CHARACTERS = 1417;

  { Thread does not have a clipboard open. }
  ERROR_CLIPBOARD_NOT_OPEN = 1418;

  { Hot key is not registered. }
  ERROR_HOTKEY_NOT_REGISTERED = 1419;

  { The window is not a valid dialog window. }
  ERROR_WINDOW_NOT_DIALOG = 1420;

  { Control ID not found. }
  ERROR_CONTROL_ID_NOT_FOUND = 1421;

  { Invalid message for a combo box because it does not have an edit control. }
  ERROR_INVALID_COMBOBOX_MESSAGE = 1422;

  { The window is not a combo box. }
  ERROR_WINDOW_NOT_COMBOBOX = 1423;

  { Height must be less than 256. }
  ERROR_INVALID_EDIT_HEIGHT = 1424;

  { Invalid device context (DC) handle. }
  ERROR_DC_NOT_FOUND = 1425;

  { Invalid hook procedure type. }
  ERROR_INVALID_HOOK_FILTER = 1426;

  { Invalid hook procedure. }
  ERROR_INVALID_FILTER_PROC = 1427;

  { Cannot set non-local hook without a module handle. }
  ERROR_HOOK_NEEDS_HMOD = 1428;

  { This hook procedure can only be set globally. }
  ERROR_GLOBAL_ONLY_HOOK = 1429;

  { The journal hook procedure is already installed. }
  ERROR_JOURNAL_HOOK_SET = 1430;

  { The hook procedure is not installed. }
  ERROR_HOOK_NOT_INSTALLED = 1431;

  { Invalid message for single-selection listbox. }
  ERROR_INVALID_LB_MESSAGE = 1432;

  { LB_SETCOUNT sent to non-lazy listbox. }
  ERROR_SETCOUNT_ON_BAD_LB = 1433;

  { This list box does not support tab stops. }
  ERROR_LB_WITHOUT_TABSTOPS = 1434;

  { Cannot destroy object created by another thread. }
  ERROR_DESTROY_OBJECT_OF_OTHER_THREAD = 1435;

  { Child windows cannot have menus. }
  ERROR_CHILD_WINDOW_MENU = 1436;

  { The window does not have a system menu. }
  ERROR_NO_SYSTEM_MENU = 1437;

  { Invalid message box style. }
  ERROR_INVALID_MSGBOX_STYLE = 1438;

  { Invalid system-wide (SPI_*) parameter. }
  ERROR_INVALID_SPI_VALUE = 1439;

  { Screen already locked. }
  ERROR_SCREEN_ALREADY_LOCKED = 1440;

  { All handles to windows in a multiple-window position structure must }
  { have the same parent. }
  ERROR_HWNDS_HAVE_DIFF_PARENT = 1441;

  { The window is not a child window. }
  ERROR_NOT_CHILD_WINDOW = 1442;

  { Invalid GW_* command. }
  ERROR_INVALID_GW_COMMAND = 1443;

  { Invalid thread identifier. }
  ERROR_INVALID_THREAD_ID = 1444;

  { Cannot process a message from a window that is not a multiple document }
  { interface (MDI) window. }
  ERROR_NON_MDICHILD_WINDOW = 1445;

  { Popup menu already active. }
  ERROR_POPUP_ALREADY_ACTIVE = 1446;

  { The window does not have scroll bars. }
  ERROR_NO_SCROLLBARS = 1447;

  { Scroll bar range cannot be greater than $7FFF. }
  ERROR_INVALID_SCROLLBAR_RANGE = 1448;

  { Cannot show or remove the window in the way specified. }
  ERROR_INVALID_SHOWWIN_COMMAND = 1449;

  { Insufficient system resources exist to complete the requested service. }
  ERROR_NO_SYSTEM_RESOURCES = 1450;

  { Insufficient system resources exist to complete the requested service. }
  ERROR_NONPAGED_SYSTEM_RESOURCES = 1451;

  { Insufficient system resources exist to complete the requested service. }
  ERROR_PAGED_SYSTEM_RESOURCES = 1452;

  { Insufficient quota to complete the requested service. }
  ERROR_WORKING_SET_QUOTA = 1453;

  { Insufficient quota to complete the requested service. }
  ERROR_PAGEFILE_QUOTA = 1454;

  { The paging file is too small for this operation to complete. }
  ERROR_COMMITMENT_LIMIT = 1455;

  { A menu item was not found. }
  ERROR_MENU_ITEM_NOT_FOUND = 1456;

  { Invalid keyboard layout handle. }
  ERROR_INVALID_KEYBOARD_HANDLE = 1457;

  { Hook type not allowed. }
  ERROR_HOOK_TYPE_NOT_ALLOWED = 1458;

  { This operation requires an interactive windowstation. }
  ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION = 1459;

  { This operation returned because the timeout period expired. }
  ERROR_TIMEOUT = 1460;


{ Eventlog Status Codes }

  { The event log file is corrupt. }
  ERROR_EVENTLOG_FILE_CORRUPT = 1500;

  { No event log file could be opened, so the event logging service did not start. }
  ERROR_EVENTLOG_CANT_START = 1501;

  { The event log file is full. }
  ERROR_LOG_FILE_FULL = 1502;

  { The event log file has changed between reads. }
  ERROR_EVENTLOG_FILE_CHANGED = 1503;


{ RPC Status Codes }

  { The string binding is invalid. }
  RPC_S_INVALID_STRING_BINDING = 1700;

  { The binding handle is not the correct type. }
  RPC_S_WRONG_KIND_OF_BINDING = 1701;

  { The binding handle is invalid. }
  RPC_S_INVALID_BINDING = 1702;

  { The RPC protocol sequence is not supported. }
  RPC_S_PROTSEQ_NOT_SUPPORTED = 1703;

  { The RPC protocol sequence is invalid. }
  RPC_S_INVALID_RPC_PROTSEQ = 1704;

  { The string universal unique identifier (UUID) is invalid. }
  RPC_S_INVALID_STRING_UUID = 1705;

  { The endpoint format is invalid. }
  RPC_S_INVALID_ENDPOINT_FORMAT = 1706;

  { The network address is invalid. }
  RPC_S_INVALID_NET_ADDR = 1707;

  { No endpoint was found. }
  RPC_S_NO_ENDPOINT_FOUND = 1708;

  { The timeout value is invalid. }
  RPC_S_INVALID_TIMEOUT = 1709;

  { The object universal unique identifier (UUID) was not found. }
  RPC_S_OBJECT_NOT_FOUND = 1710;

  { The object universal unique identifier (UUID) has already been registered. }
  RPC_S_ALREADY_REGISTERED = 1711;

  { The type universal unique identifier (UUID) has already been registered. }
  RPC_S_TYPE_ALREADY_REGISTERED = 1712;

  { The RPC server is already listening. }
  RPC_S_ALREADY_LISTENING = 1713;

  { No protocol sequences have been registered. }
  RPC_S_NO_PROTSEQS_REGISTERED = 1714;

  { The RPC server is not listening. }
  RPC_S_NOT_LISTENING = 1715;

  { The manager type is unknown. }
  RPC_S_UNKNOWN_MGR_TYPE = 1716;

  { The interface is unknown. }
  RPC_S_UNKNOWN_IF = 1717;

  { There are no bindings. }
  RPC_S_NO_BINDINGS = 1718;

  { There are no protocol sequences. }
  RPC_S_NO_PROTSEQS = 1719;

  { The endpoint cannot be created. }
  RPC_S_CANT_CREATE_ENDPOINT = 1720;

  { Not enough resources are available to complete this operation. }
  RPC_S_OUT_OF_RESOURCES = 1721;

  { The RPC server is unavailable. }
  RPC_S_SERVER_UNAVAILABLE = 1722;

  { The RPC server is too busy to complete this operation. }
  RPC_S_SERVER_TOO_BUSY = 1723;

  { The network options are invalid. }
  RPC_S_INVALID_NETWORK_OPTIONS = 1724;

  { There is not a remote procedure call active in this thread. }
  RPC_S_NO_CALL_ACTIVE = 1725;

  { The remote procedure call failed. }
  RPC_S_CALL_FAILED = 1726;

  { The remote procedure call failed and did not execute. }
  RPC_S_CALL_FAILED_DNE = 1727;

  { A remote procedure call (RPC) protocol error occurred. }
  RPC_S_PROTOCOL_ERROR = 1728;

  { The transfer syntax is not supported by the RPC server. }
  RPC_S_UNSUPPORTED_TRANS_SYN = 1730;

  { The universal unique identifier (UUID) type is not supported. }
  RPC_S_UNSUPPORTED_TYPE = 1732;

  { The tag is invalid. }
  RPC_S_INVALID_TAG = 1733;

  { The array bounds are invalid. }
  RPC_S_INVALID_BOUND = 1734;

  { The binding does not contain an entry name. }
  RPC_S_NO_ENTRY_NAME = 1735;

  { The name syntax is invalid. }
  RPC_S_INVALID_NAME_SYNTAX = 1736;

  { The name syntax is not supported. }
  RPC_S_UNSUPPORTED_NAME_SYNTAX = 1737;

  { No network address is available to use to construct a universal }

  { unique identifier (UUID). }
  RPC_S_UUID_NO_ADDRESS = 1739;

  { The endpoint is a duplicate. }
  RPC_S_DUPLICATE_ENDPOINT = 1740;

  { The authentication type is unknown. }
  RPC_S_UNKNOWN_AUTHN_TYPE = 1741;

  { The maximum number of calls is too small. }
  RPC_S_MAX_CALLS_TOO_SMALL = 1742;

  { The string is too long. }
  RPC_S_STRING_TOO_LONG = 1743;

  { The RPC protocol sequence was not found. }
  RPC_S_PROTSEQ_NOT_FOUND = 1744;

  { The procedure number is out of range. }
  RPC_S_PROCNUM_OUT_OF_RANGE = 1745;

  { The binding does not contain any authentication information. }
  RPC_S_BINDING_HAS_NO_AUTH = 1746;

  { The authentication service is unknown. }
  RPC_S_UNKNOWN_AUTHN_SERVICE = 1747;

  { The authentication level is unknown. }
  RPC_S_UNKNOWN_AUTHN_LEVEL = 1748;

  { The security context is invalid. }
  RPC_S_INVALID_AUTH_IDENTITY = 1749;

  { The authorization service is unknown. }
  RPC_S_UNKNOWN_AUTHZ_SERVICE = 1750;

  { The entry is invalid. }
  EPT_S_INVALID_ENTRY = 1751;

  { The server endpoint cannot perform the operation. }
  EPT_S_CANT_PERFORM_OP = 1752;

  { There are no more endpoints available from the endpoint mapper. }
  EPT_S_NOT_REGISTERED = 1753;

  { No interfaces have been exported. }
  RPC_S_NOTHING_TO_EXPORT = 1754;

  { The entry name is incomplete. }
  RPC_S_INCOMPLETE_NAME = 1755;

  { The version option is invalid. }
  RPC_S_INVALID_VERS_OPTION = 1756;

  { There are no more members. }
  RPC_S_NO_MORE_MEMBERS = 1757;

  { There is nothing to unexport. }
  RPC_S_NOT_ALL_OBJS_UNEXPORTED = 1758;

  { The interface was not found. }
  RPC_S_INTERFACE_NOT_FOUND = 1759;

  { The entry already exists. }
  RPC_S_ENTRY_ALREADY_EXISTS = 1760;

  { The entry is not found. }
  RPC_S_ENTRY_NOT_FOUND = 1761;

  { The name service is unavailable. }
  RPC_S_NAME_SERVICE_UNAVAILABLE = 1762;

  { The network address family is invalid. }
  RPC_S_INVALID_NAF_ID = 1763;

  { The requested operation is not supported. }
  RPC_S_CANNOT_SUPPORT = 1764;

  { No security context is available to allow impersonation. }
  RPC_S_NO_CONTEXT_AVAILABLE = 1765;

  { An internal error occurred in a remote procedure call (RPC). }
  RPC_S_INTERNAL_ERROR = 1766;

  { The RPC server attempted an integer division by zero. }
  RPC_S_ZERO_DIVIDE = 1767;

  { An addressing error occurred in the RPC server. }
  RPC_S_ADDRESS_ERROR = 1768;

  { A floating-point operation at the RPC server caused a division by zero. }
  RPC_S_FP_DIV_ZERO = 1769;

  { A floating-point underflow occurred at the RPC server. }
  RPC_S_FP_UNDERFLOW = 1770;

  { A floating-point overflow occurred at the RPC server. }
  RPC_S_FP_OVERFLOW = 1771;

  { The list of RPC servers available for the binding of auto handles }
  { has been exhausted. }
  RPC_X_NO_MORE_ENTRIES = 1772;

  { Unable to open the character translation table file. }
  RPC_X_SS_CHAR_TRANS_OPEN_FAIL = 1773;

  { The file containing the character translation table has fewer than }
  { 512 bytes. }
  RPC_X_SS_CHAR_TRANS_SHORT_FILE = 1774;

  { A null context handle was passed from the client to the host during }
  { a remote procedure call. }
  RPC_X_SS_IN_NULL_CONTEXT = 1775;

  { The context handle changed during a remote procedure call. }
  RPC_X_SS_CONTEXT_DAMAGED = 1777;

  { The binding handles passed to a remote procedure call do not match. }
  RPC_X_SS_HANDLES_MISMATCH = 1778;

  { The stub is unable to get the remote procedure call handle. }
  RPC_X_SS_CANNOT_GET_CALL_HANDLE = 1779;

  { A null reference pointer was passed to the stub. }
  RPC_X_NULL_REF_POINTER = 1780;

  { The enumeration value is out of range. }
  RPC_X_ENUM_VALUE_OUT_OF_RANGE = 1781;

  { The byte count is too small. }
  RPC_X_BYTE_COUNT_TOO_SMALL = 1782;

  { The stub received bad data. }
  RPC_X_BAD_STUB_DATA = 1783;

  { The supplied user buffer is not valid for the requested operation. }
  ERROR_INVALID_USER_BUFFER = 1784;

  { The disk media is not recognized.  It may not be formatted. }
  ERROR_UNRECOGNIZED_MEDIA = 1785;

  { The workstation does not have a trust secret. }
  ERROR_NO_TRUST_LSA_SECRET = 1786;

  { The SAM database on the Windows NT Server does not have a computer }
  { account for this workstation trust relationship. }
  ERROR_NO_TRUST_SAM_ACCOUNT = 1787;

  { The trust relationship between the primary domain and the trusted }
  { domain failed. }
  ERROR_TRUSTED_DOMAIN_FAILURE = 1788;

  { The trust relationship between this workstation and the primary }
  { domain failed. }
  ERROR_TRUSTED_RELATIONSHIP_FAILURE = 1789;

  { The network logon failed. }
  ERROR_TRUST_FAILURE = 1790;

  { A remote procedure call is already in progress for this thread. }
  RPC_S_CALL_IN_PROGRESS = 1791;

  { An attempt was made to logon, but the network logon service was not started. }
  ERROR_NETLOGON_NOT_STARTED = 1792;

  { The user's account has expired. }
  ERROR_ACCOUNT_EXPIRED = 1793;

  { The redirector is in use and cannot be unloaded. }
  ERROR_REDIRECTOR_HAS_OPEN_HANDLES = 1794;

  { The specified printer driver is already installed. }
  ERROR_PRINTER_DRIVER_ALREADY_INSTALLED = 1795;

  { The specified port is unknown. }
  ERROR_UNKNOWN_PORT = 1796;

  { The printer driver is unknown. }
  ERROR_UNKNOWN_PRINTER_DRIVER = 1797;

  { The print processor is unknown. }
  ERROR_UNKNOWN_PRINTPROCESSOR = 1798;

  { The specified separator file is invalid. }
  ERROR_INVALID_SEPARATOR_FILE = 1799;

  { The specified priority is invalid. }
  ERROR_INVALID_PRIORITY = 1800;

  { The printer name is invalid. }
  ERROR_INVALID_PRINTER_NAME = 1801;

  { The printer already exists. }
  ERROR_PRINTER_ALREADY_EXISTS = 1802;

  { The printer command is invalid. }
  ERROR_INVALID_PRINTER_COMMAND = 1803;

  { The specified datatype is invalid. }
  ERROR_INVALID_DATATYPE = 1804;

  { The Environment specified is invalid. }
  ERROR_INVALID_ENVIRONMENT = 1805;

  { There are no more bindings. }
  RPC_S_NO_MORE_BINDINGS = 1806;

  { The account used is an interdomain trust account.  Use your global user account or local user account to access this server. }
  ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = 1807;

  { The account used is a Computer Account.  Use your global user account or local user account to access this server. }
  ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT = 1808;

  { The account used is an server trust account.  Use your global user account or local user account to access this server. }
  ERROR_NOLOGON_SERVER_TRUST_ACCOUNT = 1809;

  { The name or security ID (SID) of the domain specified is inconsistent }
  { with the trust information for that domain. }
  ERROR_DOMAIN_TRUST_INCONSISTENT = 1810;

  { The server is in use and cannot be unloaded. }
  ERROR_SERVER_HAS_OPEN_HANDLES = 1811;

  { The specified image file did not contain a resource section. }
  ERROR_RESOURCE_DATA_NOT_FOUND = 1812;

  { The specified resource type can not be found in the image file. }
  ERROR_RESOURCE_TYPE_NOT_FOUND = 1813;

  { The specified resource name can not be found in the image file. }
  ERROR_RESOURCE_NAME_NOT_FOUND = 1814;

  { The specified resource language ID cannot be found in the image file. }
  ERROR_RESOURCE_LANG_NOT_FOUND = 1815;

  { Not enough quota is available to process this command. }
  ERROR_NOT_ENOUGH_QUOTA = 1816;

  { No interfaces have been registered. }
  RPC_S_NO_INTERFACES = 1817;

  { The server was altered while processing this call. }
  RPC_S_CALL_CANCELLED = 1818;

  { The binding handle does not contain all required information. }
  RPC_S_BINDING_INCOMPLETE = 1819;

  { Communications failure. }
  RPC_S_COMM_FAILURE = 1820;

  { The requested authentication level is not supported. }
  RPC_S_UNSUPPORTED_AUTHN_LEVEL = 1821;

  { No principal name registered. }
  RPC_S_NO_PRINC_NAME = 1822;

  { The error specified is not a valid Windows NT RPC error code. }
  RPC_S_NOT_RPC_ERROR = 1823;

  { A UUID that is valid only on this computer has been allocated. }
  RPC_S_UUID_LOCAL_ONLY = 1824;

  { A security package specific error occurred. }
  RPC_S_SEC_PKG_ERROR = 1825;

  { Thread is not cancelled. }
  RPC_S_NOT_CANCELLED = 1826;

  { Invalid operation on the encoding/decoding handle. }
  RPC_X_INVALID_ES_ACTION = 1827;

  { Incompatible version of the serializing package. }
  RPC_X_WRONG_ES_VERSION = 1828;

  { Incompatible version of the RPC stub. }
  RPC_X_WRONG_STUB_VERSION = 1829;

  { The idl pipe object is invalid or corrupted. }
  RPC_X_INVALID_PIPE_OBJECT = 1830;

  { The operation is invalid for a given idl pipe object. }
  RPC_X_INVALID_PIPE_OPERATION = 1831;

  { The idl pipe version is not supported. }
  RPC_X_WRONG_PIPE_VERSION = 1832;

  { The group member was not found. }
  RPC_S_GROUP_MEMBER_NOT_FOUND = 1898;

  { The endpoint mapper database could not be created. }
  EPT_S_CANT_CREATE = 1899;

  { The object universal unique identifier (UUID) is the nil UUID. }
  RPC_S_INVALID_OBJECT = 1900;

  { The specified time is invalid. }
  ERROR_INVALID_TIME = 1901;

  { The specified Form name is invalid. }
  ERROR_INVALID_FORM_NAME = 1902;

  { The specified Form size is invalid }
  ERROR_INVALID_FORM_SIZE = 1903;

  { The specified Printer handle is already being waited on }
  ERROR_ALREADY_WAITING = 1904;

  { The specified Printer has been deleted }
  ERROR_PRINTER_DELETED = 1905;

  { The state of the Printer is invalid }
  ERROR_INVALID_PRINTER_STATE = 1906;

  { The user must change his password before he logs on the first time. }
  ERROR_PASSWORD_MUST_CHANGE = 1907;

  { Could not find the domain controller for this domain. }
  ERROR_DOMAIN_CONTROLLER_NOT_FOUND = 1908;

  { The referenced account is currently locked out and may not be logged on to. }
  ERROR_ACCOUNT_LOCKED_OUT = 1909;

  { The object exporter specified was not found. }
  OR_INVALID_OXID = 1910;

  { The object specified was not found. }
  OR_INVALID_OID = 1911;

  { The object resolver set specified was not found. }
  OR_INVALID_SET = 1912;

  { Some data remains to be sent in the request buffer. }
  RPC_S_SEND_INCOMPLETE = 1913;

  { The list of servers for this workgroup is not currently available }
  ERROR_NO_BROWSER_SERVERS_FOUND = 6118;


{ OpenGL Error Code }

  { The pixel format is invalid. }
  ERROR_INVALID_PIXEL_FORMAT = 2000;

  { The specified driver is invalid. }
  ERROR_BAD_DRIVER = 2001;

  { The window style or class attribute is invalid for this operation. }
  ERROR_INVALID_WINDOW_STYLE = 2002;

  { The requested metafile operation is not supported. }
  ERROR_METAFILE_NOT_SUPPORTED = 2003;

  { The requested transformation operation is not supported. }
  ERROR_TRANSFORM_NOT_SUPPORTED = 2004;

  { The requested clipping operation is not supported. }
  ERROR_CLIPPING_NOT_SUPPORTED = 2005;


{ Win32 Spooler Error Codes }

  { The specified print monitor is unknown. }
  ERROR_UNKNOWN_PRINT_MONITOR = 3000;

  { The specified printer driver is currently in use. }
  ERROR_PRINTER_DRIVER_IN_USE = 3001;

  { The spool file was not found. }
  ERROR_SPOOL_FILE_NOT_FOUND = 3002;

  { A StartDocPrinter call was not issued. }
  ERROR_SPL_NO_STARTDOC = 3003;

  { An AddJob call was not issued. }
  ERROR_SPL_NO_ADDJOB = 3004;

  { The specified print processor has already been installed. }
  ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED = 3005;

  { The specified print monitor has already been installed. }
  ERROR_PRINT_MONITOR_ALREADY_INSTALLED = 3006;

  { The specified print monitor does not have the required functions. }
  ERROR_INVALID_PRINT_MONITOR = 3007;

  { The specified print monitor is currently in use. }
  ERROR_PRINT_MONITOR_IN_USE = 3008;

  { The requested operation is not allowed when there are jobs queued to the printer. }
  ERROR_PRINTER_HAS_JOBS_QUEUED = 3009;

  { The requested operation is successful.  Changes will not be effective until the system is rebooted. }
  ERROR_SUCCESS_REBOOT_REQUIRED = 3010;

  { The requested operation is successful.  Changes will not be effective until the service is restarted. }
  ERROR_SUCCESS_RESTART_REQUIRED = 3011;


{ Wins Error Codes }

  { WINS encountered an error while processing the command. }
  ERROR_WINS_INTERNAL = 4000;

  { The local WINS can not be deleted. }
  ERROR_CAN_NOT_DEL_LOCAL_WINS = 4001;

  { The importation from the file failed. }
  ERROR_STATIC_INIT = 4002;

  { The backup Failed.  Was a full backup done before ? }
  ERROR_INC_BACKUP = 4003;

  { The backup Failed.  Check the directory that you are backing the database to. }
  ERROR_FULL_BACKUP = 4004;

  { The name does not exist in the WINS database. }
  ERROR_REC_NON_EXISTENT = 4005;

  { Replication with a non-configured partner is not allowed. }
  ERROR_RPL_NOT_ALLOWED = 4006;


{------------------------------}
{     OLE Error Codes          }
{------------------------------}

(*
  The return value of OLE APIs and methods is an HRESULT.
  This is not a handle to anything, but is merely a 32-bit value
  with several fields encoded in the value.  The parts of an
  HRESULT are shown below.

  HRESULTs are 32 bit values layed out as follows:

   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
  +-+-+-+-+-+---------------------+-------------------------------+
  |S|R|C|N|r|    Facility         |               Code            |
  +-+-+-+-+-+---------------------+-------------------------------+

  where

      S - Severity - indicates success/fail
          0 - Success
          1 - Fail (COERROR)

      R - reserved portion of the facility code, corresponds to NT's
              second severity bit.

      C - reserved portion of the facility code, corresponds to NT's
              C field.

      N - reserved portion of the facility code. Used to indicate a
              mapped NT status value.

      r - reserved portion of the facility code. Reserved for internal
              use. Used to indicate HRESULT values that are not status
              values, but are instead message ids for display strings.

      Facility - is the facility code

      Code - is the facility's status code
*)

type
  HRESULT = type Longint;

const
  { Severity values }
  SEVERITY_SUCCESS = 0;
  SEVERITY_ERROR = 1;

function Succeeded(Status: HRESULT): BOOL;

{ and the inverse }
function Failed(Status: HRESULT): BOOL;

{ Generic test for error on any status value. }
function IsError(Status: HRESULT): BOOL;

{ Return the code }
function HResultCode(hr: HRESULT): Integer;

{ Return the facility }
function HResultFacility(hr: HRESULT): Integer;

{ Return the severity }
function HResultSeverity(hr: HRESULT): Integer;

{ Create an HRESULT value from component pieces }
function MakeResult(sev, fac, code: Integer): HResult;

{ Map a WIN32 error value into a HRESULT }
{ Note: This assumes that WIN32 errors fall in the range -32k to 32k. }
const
  { Define bits here so macros are guaranteed to work }
  FACILITY_NT_BIT = $10000000;
function HResultFromWin32(x: Integer): HRESULT;

{ Map an NT status value into a HRESULT }
function HResultFromNT(x: Integer): HRESULT;

const
  { HRESULT value definitions }
  { Codes $4000-$40ff are reserved for OLE }

  { Success codes }
  S_OK    = $00000000;
  S_FALSE = $00000001;

  NOERROR = 0;

  { Catastrophic failure }
  E_UNEXPECTED = HRESULT($8000FFFF);

  { Not implemented }
  E_NOTIMPL = HRESULT($80004001);

  { Ran out of memory }
  E_OUTOFMEMORY = HRESULT($8007000E);

  { One or more arguments are invalid }
  E_INVALIDARG = HRESULT($80070057);

  { No such interface supported }
  E_NOINTERFACE = HRESULT($80004002);

  { Invalid pointer }
  E_POINTER = HRESULT($80004003);

  { Invalid handle }
  E_HANDLE = HRESULT($80070006);

  { Operation aborted }
  E_ABORT = HRESULT($80004004);

  { Unspecified error }
  E_FAIL = HRESULT($80004005);

  { General access denied error }
  E_ACCESSDENIED = HRESULT($80070005);

  { The data necessary to complete this operation is not yet available. }
  E_PENDING = HRESULT($8000000A);

  { Thread local storage failure }
  CO_E_INIT_TLS = HRESULT($80004006);

  { Get shared memory allocator failure }
  CO_E_INIT_SHARED_ALLOCATOR = HRESULT($80004007);

  { Get memory allocator failure }
  CO_E_INIT_MEMORY_ALLOCATOR = HRESULT($80004008);

  { Unable to initialize class cache }
  CO_E_INIT_CLASS_CACHE = HRESULT($80004009);

  { Unable to initialize RPC services }
  CO_E_INIT_RPC_CHANNEL = HRESULT($8000400A);

  { Cannot set thread local storage channel control }
  CO_E_INIT_TLS_SET_CHANNEL_CONTROL = HRESULT($8000400B);

  { Could not allocate thread local storage channel control }
  CO_E_INIT_TLS_CHANNEL_CONTROL = HRESULT($8000400C);

  { The user supplied memory allocator is unacceptable }
  CO_E_INIT_UNACCEPTED_USER_ALLOCATOR = HRESULT($8000400D);

  { The OLE service mutex already exists }
  CO_E_INIT_SCM_MUTEX_EXISTS = HRESULT($8000400E);

  { The OLE service file mapping already exists }
  CO_E_INIT_SCM_FILE_MAPPING_EXISTS = HRESULT($8000400F);

  { Unable to map view of file for OLE service }
  CO_E_INIT_SCM_MAP_VIEW_OF_FILE = HRESULT($80004010);

  { Failure attempting to launch OLE service }
  CO_E_INIT_SCM_EXEC_FAILURE = HRESULT($80004011);

  { There was an attempt to call CoInitialize a second time while single threaded }
  CO_E_INIT_ONLY_SINGLE_THREADED = HRESULT($80004012);

  { A Remote activation was necessary but was not allowed }
  CO_E_CANT_REMOTE = HRESULT($80004013);

  { A Remote activation was necessary but the server name provided was invalid }
  CO_E_BAD_SERVER_NAME = HRESULT($80004014);

  { The class is configured to run as a security id different from the caller }
  CO_E_WRONG_SERVER_IDENTITY = HRESULT($80004015);

  { Use of Ole1 services requiring DDE windows is disabled }
  CO_E_OLE1DDE_DISABLED = HRESULT($80004016);

  { A RunAs specification must be <domain name>\<user name> or simply <user name> }
  CO_E_RUNAS_SYNTAX = HRESULT($80004017);

  { The server process could not be started.  The pathname may be incorrect. }
  CO_E_CREATEPROCESS_FAILURE = HRESULT($80004018);

  { The server process could not be started as the configured identity.  The pathname may be incorrect or unavailable. }
  CO_E_RUNAS_CREATEPROCESS_FAILURE = HRESULT($80004019);

  { The server process could not be started because the configured identity is incorrect.  Check the username and password. }
  CO_E_RUNAS_LOGON_FAILURE = HRESULT($8000401A);

  { The client is not allowed to launch this server. }
  CO_E_LAUNCH_PERMSSION_DENIED = HRESULT($8000401B);

  { The service providing this server could not be started. }
  CO_E_START_SERVICE_FAILURE = HRESULT($8000401C);

  { This computer was unable to communicate with the computer providing the server. }
  CO_E_REMOTE_COMMUNICATION_FAILURE = HRESULT($8000401D);

  { The server did not respond after being launched. }
  CO_E_SERVER_START_TIMEOUT = HRESULT($8000401E);

  { The registration information for this server is inconsistent or incomplete. }
  CO_E_CLSREG_INCONSISTENT = HRESULT($8000401F);

  { The registration information for this interface is inconsistent or incomplete. }
  CO_E_IIDREG_INCONSISTENT = HRESULT($80004020);

  { The operation attempted is not supported. }
  CO_E_NOT_SUPPORTED = HRESULT($80004021);


  { FACILITY_ITF }
  { Codes $0-$01ff are reserved for the OLE group of }

  { Generic OLE errors that may be returned by many inerfaces}
  OLE_E_FIRST = HRESULT($80040000);
  OLE_E_LAST  = HRESULT($800400FF);
  OLE_S_FIRST = $40000;
  OLE_S_LAST  = $400FF;

  { Invalid OLEVERB structure }
  OLE_E_OLEVERB = HRESULT($80040000);

  { Invalid advise flags }
  OLE_E_ADVF = HRESULT($80040001);

  { Can't enumerate any more, because the associated data is missing }
  OLE_E_ENUM_NOMORE = HRESULT($80040002);

  { This implementation doesn't take advises }
  OLE_E_ADVISENOTSUPPORTED = HRESULT($80040003);

  { There is no connection for this connection ID }
  OLE_E_NOCONNECTION = HRESULT($80040004);

  { Need to run the object to perform this operation }
  OLE_E_NOTRUNNING = HRESULT($80040005);

  { There is no cache to operate on }
  OLE_E_NOCACHE = HRESULT($80040006);

  { Uninitialized object }
  OLE_E_BLANK = HRESULT($80040007);

  { Linked object's source class has changed }
  OLE_E_CLASSDIFF = HRESULT($80040008);

  { Not able to get the moniker of the object }
  OLE_E_CANT_GETMONIKER = HRESULT($80040009);

  { Not able to bind to the source }
  OLE_E_CANT_BINDTOSOURCE = HRESULT($8004000A);

  { Object is static; operation not allowed }
  OLE_E_STATIC = HRESULT($8004000B);

  { User cancelled out of save dialog }
  OLE_E_PROMPTSAVECANCELLED = HRESULT($8004000C);

  { Invalid rectangle }
  OLE_E_INVALIDRECT = HRESULT($8004000D);

  { compobj.dll is too old for the ole2.dll initialized }
  OLE_E_WRONGCOMPOBJ = HRESULT($8004000E);

  { Invalid window handle }
  OLE_E_INVALIDHWND = HRESULT($8004000F);

  { Object is not in any of the inplace active states }
  OLE_E_NOT_INPLACEACTIVE = HRESULT($80040010);

  { Not able to convert object }
  OLE_E_CANTCONVERT = HRESULT($80040011);

  OLE_E_NOSTORAGE = HRESULT($80040012);

  { Invalid FORMATETC structure }
  DV_E_FORMATETC = HRESULT($80040064);

  { Invalid DVTARGETDEVICE structure }
  DV_E_DVTARGETDEVICE = HRESULT($80040065);

  { Invalid STDGMEDIUM structure }
  DV_E_STGMEDIUM = HRESULT($80040066);

  { Invalid STATDATA structure }
  DV_E_STATDATA = HRESULT($80040067);

  { Invalid lindex }
  DV_E_LINDEX = HRESULT($80040068);

  { Invalid tymed }
  DV_E_TYMED = HRESULT($80040069);

  { Invalid clipboard format }
  DV_E_CLIPFORMAT = HRESULT($8004006A);

  { Invalid aspect(s) }
  DV_E_DVASPECT = HRESULT($8004006B);

  { tdSize parameter of the DVTARGETDEVICE structure is invalid }
  DV_E_DVTARGETDEVICE_SIZE = HRESULT($8004006C);

  { Object doesn't support IViewObject interface }
  DV_E_NOIVIEWOBJECT = HRESULT($8004006D);

  DRAGDROP_E_FIRST = HRESULT($80040100);
  DRAGDROP_E_LAST  = HRESULT($8004010F);
  DRAGDROP_S_FIRST = $40100;

  { Trying to revoke a drop target that has not been registered }
  DRAGDROP_E_NOTREGISTERED = HRESULT($80040100);

  { This window has already been registered as a drop target }
  DRAGDROP_E_ALREADYREGISTERED = HRESULT($80040101);

  { Invalid window handle }
  DRAGDROP_E_INVALIDHWND = HRESULT($80040102);

  CLASSFACTORY_E_FIRST = HRESULT($80040110);
  CLASSFACTORY_E_LAST  = HRESULT($8004011F);
  CLASSFACTORY_S_FIRST = $40110;

  { Class does not support aggregation (or class object is remote) }
  CLASS_E_NOAGGREGATION = HRESULT($80040110);

  { ClassFactory cannot supply requested class }
  CLASS_E_CLASSNOTAVAILABLE = HRESULT($80040111);

  MARSHAL_E_FIRST = HRESULT($80040120);
  MARSHAL_E_LAST  = HRESULT($8004012F);
  MARSHAL_S_FIRST = $40120;
  MARSHAL_S_LAST  = $4012F;
  DATA_E_FIRST    = HRESULT($80040130);
  DATA_E_LAST     = HRESULT($8004013F);
  DATA_S_FIRST    = $40130;
  DATA_S_LAST     = $4013F;
  VIEW_E_FIRST    = HRESULT($80040140);
  VIEW_E_LAST     = HRESULT($8004014F);
  VIEW_S_FIRST    = $40140;

  { Error drawing view }
  VIEW_E_DRAW = HRESULT($80040140);

  REGDB_E_FIRST = HRESULT($80040150);
  REGDB_E_LAST  = HRESULT($8004015F);
  REGDB_S_FIRST = $40150;

  { Could not read key from registry }
  REGDB_E_READREGDB = HRESULT($80040150);

  { Could not write key to registry }
  REGDB_E_WRITEREGDB = HRESULT($80040151);

  { Could not find the key in the registry }
  REGDB_E_KEYMISSING = HRESULT($80040152);

  { Invalid value for registry }
  REGDB_E_INVALIDVALUE = HRESULT($80040153);

  { Class not registered }
  REGDB_E_CLASSNOTREG = HRESULT($80040154);

  { Interface not registered }
  REGDB_E_IIDNOTREG = HRESULT($80040155);

  CACHE_E_FIRST = HRESULT($80040170);
  CACHE_E_LAST  = HRESULT($8004017F);
  CACHE_S_FIRST = $40170;

  { Cache not updated }
  CACHE_E_NOCACHE_UPDATED = HRESULT($80040170);

  OLEOBJ_E_FIRST = HRESULT($80040180);
  OLEOBJ_E_LAST  = HRESULT($8004018F);
  OLEOBJ_S_FIRST = $40180;

  { No verbs for OLE object }
  OLEOBJ_E_NOVERBS = HRESULT($80040180);

  { Invalid verb for OLE object }
  OLEOBJ_E_INVALIDVERB = HRESULT($80040181);

  CLIENTSITE_E_FIRST = HRESULT($80040190);
  CLIENTSITE_E_LAST = HRESULT($8004019F);
  CLIENTSITE_S_FIRST = $40190;

  { Undo is not available }
  INPLACE_E_NOTUNDOABLE = HRESULT($800401A0);

  { Space for tools is not available }
  INPLACE_E_NOTOOLSPACE = HRESULT($800401A1);

  INPLACE_E_FIRST = HRESULT($800401A0);
  INPLACE_E_LAST  = HRESULT($800401AF);
  INPLACE_S_FIRST = $401A0;
  INPLACE_S_LAST  = $401AF;
  ENUM_E_FIRST = HRESULT($800401B0);
  ENUM_E_LAST  = HRESULT($800401BF);
  ENUM_S_FIRST = $401B0;
  ENUM_S_LAST  = $401BF;
  CONVERT10_E_FIRST = HRESULT($800401C0);
  CONVERT10_E_LAST  = HRESULT($800401CF);
  CONVERT10_S_FIRST = $401C0;

  { OLESTREAM Get method failed }
  CONVERT10_E_OLESTREAM_GET = HRESULT($800401C0);

  { OLESTREAM Put method failed }
  CONVERT10_E_OLESTREAM_PUT = HRESULT($800401C1);

  { Contents of the OLESTREAM not in correct format }
  CONVERT10_E_OLESTREAM_FMT = HRESULT($800401C2);

  { There was an error in a Windows GDI call while converting the bitmap to a DIB }
  CONVERT10_E_OLESTREAM_BITMAP_TO_DIB = HRESULT($800401C3);

  { Contents of the IStorage not in correct format }
  CONVERT10_E_STG_FMT = HRESULT($800401C4);

  { Contents of IStorage is missing one of the standard streams }
  CONVERT10_E_STG_NO_STD_STREAM = HRESULT($800401C5);

  CONVERT10_E_STG_DIB_TO_BITMAP = HRESULT($800401C6);

  CLIPBRD_E_FIRST = HRESULT($800401D0);
  CLIPBRD_E_LAST  = HRESULT($800401DF);
  CLIPBRD_S_FIRST = $401D0;

  { OpenClipboard Failed }
  CLIPBRD_E_CANT_OPEN = HRESULT($800401D0);

  { EmptyClipboard Failed }
  CLIPBRD_E_CANT_EMPTY = HRESULT($800401D1);

  { SetClipboard Failed }
  CLIPBRD_E_CANT_SET = HRESULT($800401D2);

  { Data on clipboard is invalid }
  CLIPBRD_E_BAD_DATA = HRESULT($800401D3);

  { CloseClipboard Failed }
  CLIPBRD_E_CANT_CLOSE = HRESULT($800401D4);

  MK_E_FIRST = HRESULT($800401E0);
  MK_E_LAST  = HRESULT($800401EF);
  MK_S_FIRST = $401E0;

  { Moniker needs to be connected manually }
  MK_E_CONNECTMANUALLY = HRESULT($800401E0);

  { Operation exceeded deadline }
  MK_E_EXCEEDEDDEADLINE = HRESULT($800401E1);

  { Moniker needs to be generic }
  MK_E_NEEDGENERIC = HRESULT($800401E2);

  { Operation unavailable }
  MK_E_UNAVAILABLE = HRESULT($800401E3);

  { Invalid syntax }
  MK_E_SYNTAX = HRESULT($800401E4);

  { No object for moniker }
  MK_E_NOOBJECT = HRESULT($800401E5);

  { Bad extension for file }
  MK_E_INVALIDEXTENSION = HRESULT($800401E6);

  { Intermediate operation failed }
  MK_E_INTERMEDIATEINTERFACENOTSUPPORTED = HRESULT($800401E7);

  { Moniker is not bindable }
  MK_E_NOTBINDABLE = HRESULT($800401E8);

  { Moniker is not bound }
  MK_E_NOTBOUND = HRESULT($800401E9);

  { Moniker cannot open file }
  MK_E_CANTOPENFILE = HRESULT($800401EA);

  { User input required for operation to succeed }
  MK_E_MUSTBOTHERUSER = HRESULT($800401EB);

  { Moniker class has no inverse }
  MK_E_NOINVERSE = HRESULT($800401EC);

  { Moniker does not refer to storage }
  MK_E_NOSTORAGE = HRESULT($800401ED);

  { No common prefix }
  MK_E_NOPREFIX = HRESULT($800401EE);

  { Moniker could not be enumerated }
  MK_E_ENUMERATION_FAILED = HRESULT($800401EF);

  CO_E_FIRST = HRESULT($800401F0);
  CO_E_LAST  = HRESULT($800401FF);
  CO_S_FIRST = $401F0;

  { CoInitialize has not been called. }
  CO_E_NOTINITIALIZED = HRESULT($800401F0);

  { CoInitialize has already been called. }
  CO_E_ALREADYINITIALIZED = HRESULT($800401F1);

  { Class of object cannot be determined }
  CO_E_CANTDETERMINECLASS = HRESULT($800401F2);

  { Invalid class string }
  CO_E_CLASSSTRING = HRESULT($800401F3);

  { Invalid interface string }
  CO_E_IIDSTRING = HRESULT($800401F4);

  { Application not found }
  CO_E_APPNOTFOUND = HRESULT($800401F5);

  { Application cannot be run more than once }
  CO_E_APPSINGLEUSE = HRESULT($800401F6);

  { Some error in application program }
  CO_E_ERRORINAPP = HRESULT($800401F7);

  { DLL for class not found }
  CO_E_DLLNOTFOUND = HRESULT($800401F8);

  { Error in the DLL }
  CO_E_ERRORINDLL = HRESULT($800401F9);

  { Wrong OS or OS version for application }
  CO_E_WRONGOSFORAPP = HRESULT($800401FA);

  { Object is not registered }
  CO_E_OBJNOTREG = HRESULT($800401FB);

  { Object is already registered }
  CO_E_OBJISREG = HRESULT($800401FC);

  { Object is not connected to server }
  CO_E_OBJNOTCONNECTED = HRESULT($800401FD);

  { Application was launched but it didn't register a class factory }
  CO_E_APPDIDNTREG = HRESULT($800401FE);

  { Object has been released }
  CO_E_RELEASED = HRESULT($800401FF);

  { Use the registry database to provide the requested information }
  OLE_S_USEREG = $40000;

  { Success, but static }
  OLE_S_STATIC = $40001;

  { Macintosh clipboard format }
  OLE_S_MAC_CLIPFORMAT = $40002;

  { Successful drop took place }
  DRAGDROP_S_DROP = $40100;

  { Drag-drop operation canceled }
  DRAGDROP_S_CANCEL = $40101;

  { Use the default cursor }
  DRAGDROP_S_USEDEFAULTCURSORS = $40102;

  { Data has same FORMATETC }
  DATA_S_SAMEFORMATETC = $40130;

  { View is already frozen }
  VIEW_S_ALREADY_FROZEN = $40140;

  { FORMATETC not supported }
  CACHE_S_FORMATETC_NOTSUPPORTED = $40170;

  { Same cache }
  CACHE_S_SAMECACHE = $40171;

  { Some cache(s) not updated }
  CACHE_S_SOMECACHES_NOTUPDATED = $40172;

  { Invalid verb for OLE object }
  OLEOBJ_S_INVALIDVERB = $40180;

  { Verb number is valid but verb cannot be done now }
  OLEOBJ_S_CANNOT_DOVERB_NOW = $40181;

  { Invalid window handle passed }
  OLEOBJ_S_INVALIDHWND = $40182;

  { Message is too long; some of it had to be truncated before displaying }
  INPLACE_S_TRUNCATED = $401A0;

  { Unable to convert OLESTREAM to IStorage }
  CONVERT10_S_NO_PRESENTATION = $401C0;

  { Moniker reduced to itself }
  MK_S_REDUCED_TO_SELF = $401E2;

  { Common prefix is this moniker }
  MK_S_ME = $401E4;

  { Common prefix is input moniker }
  MK_S_HIM = $401E5;

  { Common prefix is both monikers }
  MK_S_US = $401E6;

  { Moniker is already registered in running object table }
  MK_S_MONIKERALREADYREGISTERED = $401E7;


  { FACILITY_WINDOWS }
  { Codes $0-$01ff are reserved for the OLE group of}

  { Attempt to create a class object failed }
  CO_E_CLASS_CREATE_FAILED = HRESULT($80080001);

  { OLE service could not bind object }
  CO_E_SCM_ERROR = HRESULT($80080002);

  { RPC communication failed with OLE service }
  CO_E_SCM_RPC_FAILURE = HRESULT($80080003);

  { Bad path to object }
  CO_E_BAD_PATH = HRESULT($80080004);

  { Server execution failed }
  CO_E_SERVER_EXEC_FAILURE = HRESULT($80080005);

  { OLE service could not communicate with the object server }
  CO_E_OBJSRV_RPC_FAILURE = HRESULT($80080006);

  { Moniker path could not be normalized }
  MK_E_NO_NORMALIZED = HRESULT($80080007);

  { Object server is stopping when OLE service contacts it }
  CO_E_SERVER_STOPPING = HRESULT($80080008);

  { An invalid root block pointer was specified }
  MEM_E_INVALID_ROOT = HRESULT($80080009);

  { An allocation chain contained an invalid link pointer }
  MEM_E_INVALID_LINK = HRESULT($80080010);

  { The requested allocation size was too large }
  MEM_E_INVALID_SIZE = HRESULT($80080011);

  { Not all the requested interfaces were available }
  CO_S_NOTALLINTERFACES = $00080012;


  { FACILITY_DISPATCH }

  { Unknown interface. }
  DISP_E_UNKNOWNINTERFACE = HRESULT($80020001);

  { Member not found. }
  DISP_E_MEMBERNOTFOUND = HRESULT($80020003);

  { Parameter not found. }
  DISP_E_PARAMNOTFOUND = HRESULT($80020004);

  { Type mismatch. }
  DISP_E_TYPEMISMATCH = HRESULT($80020005);

  { Unknown name. }
  DISP_E_UNKNOWNNAME = HRESULT($80020006);

  { No named arguments. }
  DISP_E_NONAMEDARGS = HRESULT($80020007);

  { Bad variable type. }
  DISP_E_BADVARTYPE = HRESULT($80020008);

  { Exception occurred. }
  DISP_E_EXCEPTION = HRESULT($80020009);

  { Out of present range. }
  DISP_E_OVERFLOW = HRESULT($8002000A);

  { Invalid index. }
  DISP_E_BADINDEX = HRESULT($8002000B);

  { Unknown language. }
  DISP_E_UNKNOWNLCID = HRESULT($8002000C);

  { Memory is locked. }
  DISP_E_ARRAYISLOCKED = HRESULT($8002000D);

  { Invalid number of parameters. }
  DISP_E_BADPARAMCOUNT = HRESULT($8002000E);

  { Parameter not optional. }
  DISP_E_PARAMNOTOPTIONAL = HRESULT($8002000F);

  { Invalid callee. }
  DISP_E_BADCALLEE = HRESULT($80020010);

  { Does not support a collection. }
  DISP_E_NOTACOLLECTION = HRESULT($80020011);

  { Buffer too small. }
  TYPE_E_BUFFERTOOSMALL = HRESULT($80028016);

  { Old format or invalid type library. }
  TYPE_E_INVDATAREAD = HRESULT($80028018);

  { Old format or invalid type library. }
  TYPE_E_UNSUPFORMAT = HRESULT($80028019);

  { Error accessing the OLE registry. }
  TYPE_E_REGISTRYACCESS = HRESULT($8002801C);

  { Library not registered. }
  TYPE_E_LIBNOTREGISTERED = HRESULT($8002801D);

  { Bound to unknown type. }
  TYPE_E_UNDEFINEDTYPE = HRESULT($80028027);

  { Qualified name disallowed. }
  TYPE_E_QUALIFIEDNAMEDISALLOWED = HRESULT($80028028);

  { Invalid forward reference, or reference to uncompiled type. }
  TYPE_E_INVALIDSTATE = HRESULT($80028029);

  { Type mismatch. }
  TYPE_E_WRONGTYPEKIND = HRESULT($8002802A);

  { Element not found. }
  TYPE_E_ELEMENTNOTFOUND = HRESULT($8002802B);

  { Ambiguous name. }
  TYPE_E_AMBIGUOUSNAME = HRESULT($8002802C);

  { Name already exists in the library. }
  TYPE_E_NAMECONFLICT = HRESULT($8002802D);

  { Unknown LCID. }
  TYPE_E_UNKNOWNLCID = HRESULT($8002802E);

  { Function not defined in specified DLL. }
  TYPE_E_DLLFUNCTIONNOTFOUND = HRESULT($8002802F);

  { Wrong module kind for the operation. }
  TYPE_E_BADMODULEKIND = HRESULT($800288BD);

  { Size may not exceed 64K. }
  TYPE_E_SIZETOOBIG = HRESULT($800288C5);

  { Duplicate ID in inheritance hierarchy. }
  TYPE_E_DUPLICATEID = HRESULT($800288C6);

  { Incorrect inheritance depth in standard OLE hmember. }
  TYPE_E_INVALIDID = HRESULT($800288CF);

  { Type mismatch. }
  TYPE_E_TYPEMISMATCH = HRESULT($80028CA0);

  { Invalid number of arguments. }
  TYPE_E_OUTOFBOUNDS = HRESULT($80028CA1);

  { I/O Error. }
  TYPE_E_IOERROR = HRESULT($80028CA2);

  { Error creating unique tmp file. }
  TYPE_E_CANTCREATETMPFILE = HRESULT($80028CA3);

  { Error loading type library/DLL. }
  TYPE_E_CANTLOADLIBRARY = HRESULT($80029C4A);

  { Inconsistent property functions. }
  TYPE_E_INCONSISTENTPROPFUNCS = HRESULT($80029C83);

  { Circular dependency between types/modules. }
  TYPE_E_CIRCULARTYPE = HRESULT($80029C84);


  { FACILITY_STORAGE }

  { Unable to perform requested operation. }
  STG_E_INVALIDFUNCTION = HRESULT($80030001);

  { %l could not be found. }
  STG_E_FILENOTFOUND = HRESULT($80030002);

  { The path %l could not be found. }
  STG_E_PATHNOTFOUND = HRESULT($80030003);

  { There are insufficient resources to open another file. }
  STG_E_TOOMANYOPENFILES = HRESULT($80030004);

  { Access Denied. }
  STG_E_ACCESSDENIED = HRESULT($80030005);

  { Attempted an operation on an invalid object. }
  STG_E_INVALIDHANDLE = HRESULT($80030006);

  { There is insufficient memory available to complete operation. }
  STG_E_INSUFFICIENTMEMORY = HRESULT($80030008);

  { Invalid pointer error. }
  STG_E_INVALIDPOINTER = HRESULT($80030009);

  { There are no more entries to return. }
  STG_E_NOMOREFILES = HRESULT($80030012);

  { Disk is write-protected. }
  STG_E_DISKISWRITEPROTECTED = HRESULT($80030013);

  { An error occurred during a seek operation. }
  STG_E_SEEKERROR = HRESULT($80030019);

  { A disk error occurred during a write operation. }
  STG_E_WRITEFAULT = HRESULT($8003001D);

  { A disk error occurred during a read operation. }
  STG_E_READFAULT = HRESULT($8003001E);

  { A share violation has occurred. }
  STG_E_SHAREVIOLATION = HRESULT($80030020);

  { A lock violation has occurred. }
  STG_E_LOCKVIOLATION = HRESULT($80030021);

  { %l already exists. }
  STG_E_FILEALREADYEXISTS = HRESULT($80030050);

  { Invalid parameter error. }
  STG_E_INVALIDPARAMETER = HRESULT($80030057);

  { There is insufficient disk space to complete operation. }
  STG_E_MEDIUMFULL = HRESULT($80030070);

  { Illegal write of non-simple property to simple property set. }
  STG_E_PROPSETMISMATCHED = HRESULT($800300F0);

  { An API call exited abnormally. }
  STG_E_ABNORMALAPIEXIT = HRESULT($800300FA);

  { The file %l is not a valid compound file. }
  STG_E_INVALIDHEADER = HRESULT($800300FB);

  { The name %l is not valid. }
  STG_E_INVALIDNAME = HRESULT($800300FC);

  { An unexpected error occurred. }
  STG_E_UNKNOWN = HRESULT($800300FD);

  { That function is not implemented. }
  STG_E_UNIMPLEMENTEDFUNCTION = HRESULT($800300FE);

  { Invalid flag error. }
  STG_E_INVALIDFLAG = HRESULT($800300FF);

  { Attempted to use an object that is busy. }
  STG_E_INUSE = HRESULT($80030100);

  { The storage has been changed since the last commit. }
  STG_E_NOTCURRENT = HRESULT($80030101);

  { Attempted to use an object that has ceased to exist. }
  STG_E_REVERTED = HRESULT($80030102);

  { Can't save. }
  STG_E_CANTSAVE = HRESULT($80030103);

  { The compound file %l was produced with an incompatible version of storage. }
  STG_E_OLDFORMAT = HRESULT($80030104);

  { The compound file %l was produced with a newer version of storage. }
  STG_E_OLDDLL = HRESULT($80030105);

  { Share.exe or equivalent is required for operation. }
  STG_E_SHAREREQUIRED = HRESULT($80030106);

  { Illegal operation called on non-file based storage. }
  STG_E_NOTFILEBASEDSTORAGE = HRESULT($80030107);

  { Illegal operation called on object with extant marshallings. }
  STG_E_EXTANTMARSHALLINGS = HRESULT($80030108);

  { The docfile has been corrupted. }
  STG_E_DOCFILECORRUPT = HRESULT($80030109);

  { OLE32.DLL has been loaded at the wrong address. }
  STG_E_BADBASEADDRESS = HRESULT($80030110);

  { The file download was aborted abnormally.  The file is incomplete. }
  STG_E_INCOMPLETE = HRESULT($80030201);

  { The file download has been terminated. }
  STG_E_TERMINATED = HRESULT($80030202);

  { The underlying file was converted to compound file format. }
  STG_S_CONVERTED = $00030200;

  { The storage operation should block until more data is available. }
  STG_S_BLOCK = $00030201;

  { The storage operation should retry immediately. }
  STG_S_RETRYNOW = $00030202;

  { The notified event sink will not influence the storage operation. }
  STG_S_MONITORING = $00030203;

  { FACILITY_RPC }

  { Call was rejected by callee. }
  RPC_E_CALL_REJECTED = HRESULT($80010001);

  { Call was canceled by the message filter. }
  RPC_E_CALL_CANCELED = HRESULT($80010002);

  { The caller is dispatching an intertask SendMessage call and }
  { cannot call out via PostMessage. }
  RPC_E_CANTPOST_INSENDCALL = HRESULT($80010003);

  { The caller is dispatching an asynchronous call and cannot }
  { make an outgoing call on behalf of this call. }
  RPC_E_CANTCALLOUT_INASYNCCALL = HRESULT($80010004);

  { It is illegal to call out while inside message filter. }
  RPC_E_CANTCALLOUT_INEXTERNALCALL = HRESULT($80010005);

  { The connection terminated or is in a bogus state }
  { and cannot be used any more. Other connections }
  { are still valid. }
  RPC_E_CONNECTION_TERMINATED = HRESULT($80010006);

  { The callee (server [not server application]) is not available }
  { and disappeared; all connections are invalid.  The call may }
  { have executed. }
  RPC_E_SERVER_DIED = HRESULT($80010007);

  { The caller (client) disappeared while the callee (server) was }
  { processing a call. }
  RPC_E_CLIENT_DIED = HRESULT($80010008);

  { The data packet with the marshalled parameter data is incorrect. }
  RPC_E_INVALID_DATAPACKET = HRESULT($80010009);

  { The call was not transmitted properly; the message queue }
  { was full and was not emptied after yielding. }
  RPC_E_CANTTRANSMIT_CALL = HRESULT($8001000A);

  { The client (caller) cannot marshall the parameter data - low memory, etc. }
  RPC_E_CLIENT_CANTMARSHAL_DATA = HRESULT($8001000B);

  { The client (caller) cannot unmarshall the return data - low memory, etc. }
  RPC_E_CLIENT_CANTUNMARSHAL_DATA = HRESULT($8001000C);

  { The server (callee) cannot marshall the return data - low memory, etc. }
  RPC_E_SERVER_CANTMARSHAL_DATA = HRESULT($8001000D);

  { The server (callee) cannot unmarshall the parameter data - low memory, etc. }
  RPC_E_SERVER_CANTUNMARSHAL_DATA = HRESULT($8001000E);

  { Received data is invalid; could be server or client data. }
  RPC_E_INVALID_DATA = HRESULT($8001000F);

  { A particular parameter is invalid and cannot be (un)marshalled. }
  RPC_E_INVALID_PARAMETER = HRESULT($80010010);

  { There is no second outgoing call on same channel in DDE conversation. }
  RPC_E_CANTCALLOUT_AGAIN = HRESULT($80010011);

  { The callee (server [not server application]) is not available }
  { and disappeared; all connections are invalid.  The call did not execute. }
  RPC_E_SERVER_DIED_DNE = HRESULT($80010012);

  { System call failed. }
  RPC_E_SYS_CALL_FAILED = HRESULT($80010100);

  { Could not allocate some required resource (memory, events, ...) }
  RPC_E_OUT_OF_RESOURCES = HRESULT($80010101);

  { Attempted to make calls on more than one thread in single threaded mode. }
  RPC_E_ATTEMPTED_MULTITHREAD = HRESULT($80010102);

  { The requested interface is not registered on the server object. }
  RPC_E_NOT_REGISTERED = HRESULT($80010103);

  { RPC could not call the server or could not return the results of calling the server. }
  RPC_E_FAULT = HRESULT($80010104);

  { The server threw an exception. }
  RPC_E_SERVERFAULT = HRESULT($80010105);

  { Cannot change thread mode after it is set. }
  RPC_E_CHANGED_MODE = HRESULT($80010106);

  { The method called does not exist on the server. }
  RPC_E_INVALIDMETHOD = HRESULT($80010107);

  { The object invoked has disconnected from its clients. }
  RPC_E_DISCONNECTED = HRESULT($80010108);

  { The object invoked chose not to process the call now.  Try again later. }
  RPC_E_RETRY = HRESULT($80010109);

  { The message filter indicated that the application is busy. }
  RPC_E_SERVERCALL_RETRYLATER = HRESULT($8001010A);

  { The message filter rejected the call. }
  RPC_E_SERVERCALL_REJECTED = HRESULT($8001010B);

  { A call control interfaces was called with invalid data. }
  RPC_E_INVALID_CALLDATA = HRESULT($8001010C);

  { An outgoing call cannot be made since the application is dispatching an input-synchronous call. }
  RPC_E_CANTCALLOUT_ININPUTSYNCCALL = HRESULT($8001010D);

  { The application called an interface that was marshalled for a different thread. }
  RPC_E_WRONG_THREAD = HRESULT($8001010E);

  { CoInitialize has not been called on the current thread. }
  RPC_E_THREAD_NOT_INIT = HRESULT($8001010F);

  { The version of OLE on the client and server machines does not match. }
  RPC_E_VERSION_MISMATCH = HRESULT($80010110);

  { OLE received a packet with an invalid header. }
  RPC_E_INVALID_HEADER = HRESULT($80010111);

  { OLE received a packet with an invalid extension. }
  RPC_E_INVALID_EXTENSION = HRESULT($80010112);

  { The requested object or interface does not exist. }
  RPC_E_INVALID_IPID = HRESULT($80010113);

  { The requested object does not exist. }
  RPC_E_INVALID_OBJECT = HRESULT($80010114);

  { OLE has sent a request and is waiting for a reply. }
  RPC_S_CALLPENDING = HRESULT($80010115);

  { OLE is waiting before retrying a request. }
  RPC_S_WAITONTIMER = HRESULT($80010116);

  { Call context cannot be accessed after call completed. }
  RPC_E_CALL_COMPLETE = HRESULT($80010117);

  { Impersonate on unsecure calls is not supported. }
  RPC_E_UNSECURE_CALL = HRESULT($80010118);

  { Security must be initialized before any interfaces are marshalled or }
  RPC_E_TOO_LATE = HRESULT($80010119);

  { No security packages are installed on this machine or the user is not logged }
  RPC_E_NO_GOOD_SECURITY_PACKAGES = HRESULT($8001011A);

  { Access is denied. }
  RPC_E_ACCESS_DENIED = HRESULT($8001011B);

  { Remote calls are not allowed for this process. }
  RPC_E_REMOTE_DISABLED = HRESULT($8001011C);

  { The marshaled interface data packet (OBJREF) has an invalid or unknown format. }
  RPC_E_INVALID_OBJREF = HRESULT($8001011D);

{ No context is associated with this call.
    This happens for some custom marshalled calls and on the client side of the call. }
  RPC_E_NO_CONTEXT = HRESULT($8001011E);

  { This operation returned because the timeout period expired. }
  RPC_E_TIMEOUT = HRESULT($8001011F);

  { An internal error occurred. }
  RPC_E_UNEXPECTED = HRESULT($8001FFFF);


{ FACILITY_SSPI }

  { Bad UID. }
  NTE_BAD_UID = HRESULT($80090001);

  { Bad Hash. }
  NTE_BAD_HASH = HRESULT($80090002);

  { Bad Key. }
  NTE_BAD_KEY = HRESULT($80090003);

  { Bad Length. }
  NTE_BAD_LEN = HRESULT($80090004);

  { Bad Data. }
  NTE_BAD_DATA = HRESULT($80090005);

  { Invalid Signature. }
  NTE_BAD_SIGNATURE = HRESULT($80090006);

  { Bad Version of provider. }
  NTE_BAD_VER = HRESULT($80090007);

  { Invalid algorithm specified. }
  NTE_BAD_ALGID = HRESULT($80090008);

  { Invalid flags specified. }
  NTE_BAD_FLAGS = HRESULT($80090009);

  { Invalid type specified. }
  NTE_BAD_TYPE = HRESULT($8009000A);

  { Key not valid for use in specified state. }
  NTE_BAD_KEY_STATE = HRESULT($8009000B);

  { Hash not valid for use in specified state. }
  NTE_BAD_HASH_STATE = HRESULT($8009000C);

  { Key does not exist. }
  NTE_NO_KEY = HRESULT($8009000D);

  { Insufficient memory available for the operation. }
  NTE_NO_MEMORY = HRESULT($8009000E);

  { Object already exists. }
  NTE_EXISTS = HRESULT($8009000F);

  { Access denied. }
  NTE_PERM = HRESULT($80090010);

  { Object was not found. }
  NTE_NOT_FOUND = HRESULT($80090011);

  { Data already encrypted. }
  NTE_DOUBLE_ENCRYPT = HRESULT($80090012);

  { Invalid provider specified. }
  NTE_BAD_PROVIDER = HRESULT($80090013);

  { Invalid provider type specified. }
  NTE_BAD_PROV_TYPE = HRESULT($80090014);

  { Provider's public key is invalid. }
  NTE_BAD_PUBLIC_KEY = HRESULT($80090015);

  { Keyset does not exist }
  NTE_BAD_KEYSET = HRESULT($80090016);

  { Provider type not defined. }
  NTE_PROV_TYPE_NOT_DEF = HRESULT($80090017);

  { Provider type as registered is invalid. }
  NTE_PROV_TYPE_ENTRY_BAD = HRESULT($80090018);

  { The keyset is not defined. }
  NTE_KEYSET_NOT_DEF = HRESULT($80090019);

  { Keyset as registered is invalid. }
  NTE_KEYSET_ENTRY_BAD = HRESULT($8009001A);

  { Provider type does not match registered value. }
  NTE_PROV_TYPE_NO_MATCH = HRESULT($8009001B);

  { The digital signature file is corrupt. }
  NTE_SIGNATURE_FILE_BAD = HRESULT($8009001C);

  { Provider DLL failed to initialize correctly. }
  NTE_PROVIDER_DLL_FAIL = HRESULT($8009001D);

  { Provider DLL could not be found. }
  NTE_PROV_DLL_NOT_FOUND = HRESULT($8009001E);

  { The Keyset parameter is invalid. }
  NTE_BAD_KEYSET_PARAM = HRESULT($8009001F);

  { An internal error occurred. }
  NTE_FAIL = HRESULT($80090020);

  { A base error occurred. }
  NTE_SYS_ERR = HRESULT($80090021);

  NTE_OP_OK = 0;

{ FACILITY_CERT }

  { The specified trust provider is not known on this system. }
  TRUST_E_PROVIDER_UNKNOWN = HRESULT($800B0001);

  { The trust verification action specified is not supported by the specified trust provider. }
  TRUST_E_ACTION_UNKNOWN = HRESULT($800B0002);

  { The form specified for the subject is not one supported or known by the specified trust provider. }
  TRUST_E_SUBJECT_FORM_UNKNOWN = HRESULT($800B0003);

  { The subject is not trusted for the specified action. }
  TRUST_E_SUBJECT_NOT_TRUSTED = HRESULT($800B0004);

  { Error due to problem in ASN.1 encoding process. }
  DIGSIG_E_ENCODE = HRESULT($800B0005);

  { Error due to problem in ASN.1 decoding process. }
  DIGSIG_E_DECODE = HRESULT($800B0006);

  { Reading / writing Extensions where Attributes are appropriate, and visa versa. }
  DIGSIG_E_EXTENSIBILITY = HRESULT($800B0007);

  { Unspecified cryptographic failure. }
  DIGSIG_E_CRYPTO = HRESULT($800B0008);

  { The size of the data could not be determined. }
  PERSIST_E_SIZEDEFINITE = HRESULT($800B0009);

  { The size of the indefinite-sized data could not be determined. }
  PERSIST_E_SIZEINDEFINITE = HRESULT($800B000A);

  { This object does not read and write self-sizing data. }
  PERSIST_E_NOTSELFSIZING = HRESULT($800B000B);

  { No signature was present in the subject. }
  TRUST_E_NOSIGNATURE = HRESULT($800B0100);

  { A required certificate is not within its validity period. }
  CERT_E_EXPIRED = HRESULT($800B0101);

  { The validity periods of the certification chain do not nest correctly. }
  CERT_E_VALIDIYPERIODNESTING = HRESULT($800B0102);

  { A certificate that can only be used as an end-entity is being used as a CA or visa versa. }
  CERT_E_ROLE = HRESULT($800B0103);

  { A path length constraint in the certification chain has been violated. }
  CERT_E_PATHLENCONST = HRESULT($800B0104);

  { An extension of unknown type that is labeled 'critical' is present in a certificate. }
  CERT_E_CRITICAL = HRESULT($800B0105);

  { A certificate is being used for a purpose other than that for which it is permitted. }
  CERT_E_PURPOSE = HRESULT($800B0106);

  { A parent of a given certificate in fact did not issue that child certificate. }
  CERT_E_ISSUERCHAINING = HRESULT($800B0107);

  { A certificate is missing or has an empty value for an important field, such as a subject or issuer name. }
  CERT_E_MALFORMED = HRESULT($800B0108);

  { A certification chain processed correctly, but terminated in a root certificate which isn't trusted by the trust provider. }
  CERT_E_UNTRUSTEDROOT = HRESULT($800B0109);

  { A chain of certs didn't chain as they should in a certain application of chaining. }
  CERT_E_CHAINING = HRESULT($800B010A);

{ End WINERROR.H }


  { Abnormal termination codes }

  TC_NORMAL = 0;
  TC_HARDERR = 1;
  TC_GP_TRAP = 2;
  TC_SIGNAL = 3;

  { Power Management APIs }

  AC_LINE_OFFLINE = 0;
  AC_LINE_ONLINE = 1;
  AC_LINE_BACKUP_POWER = 2;
  AC_LINE_UNKNOWN = 255;

  BATTERY_FLAG_HIGH = 1;
  BATTERY_FLAG_LOW = 2;
  BATTERY_FLAG_CRITICAL = 4;
  BATTERY_FLAG_CHARGING = 8;
  BATTERY_FLAG_NO_BATTERY = $80;
  BATTERY_FLAG_UNKNOWN = 255;
  BATTERY_PERCENTAGE_UNKNOWN = 255;
  BATTERY_LIFE_UNKNOWN = DWORD($FFFFFFFF);

type
  _SYSTEM_POWER_STATUS = packed record
    ACLineStatus : Byte;
    BatteryFlag : Byte;
    BatteryLifePercent : Byte;
    Reserved1 : Byte;
    BatteryLifeTime : DWORD;
    BatteryFullLifeTime : DWORD;
  end;
  TSystemPowerStatus = _SYSTEM_POWER_STATUS;
  SYSTEM_POWER_STATUS = _SYSTEM_POWER_STATUS;

function GetSystemPowerStatus(out lpSystemPowerStatus: TSystemPowerStatus): BOOL;
function SetSystemPowerState(fSuspend, fForce: BOOL): BOOL;


{ Win Certificate API and Structures }

{ Structures }
type
  _WIN_CERTIFICATE = packed record
    dwLength: DWORD;
    wRevision: Word;
    wCertificateType: Word;         { WIN_CERT_TYPE_xxx }
    bCertificate: IntPtr; { packed array[0..0] of Byte }
  end;
  TWinCertificate = _WIN_CERTIFICATE;
  WIN_CERTIFICATE = _WIN_CERTIFICATE;

{ Currently, the only defined certificate revision is WIN_CERT_REVISION_1_0 }

const
  WIN_CERT_REVISION_1_0 = $0100;

{ Possible certificate types are specified by the following values }

  WIN_CERT_TYPE_X509 = $0001;                        { bCertificate contains an X.509 Certificate }
  WIN_CERT_TYPE_PKCS_SIGNED_DATA = $0002;            { bCertificate contains a PKCS SignedData structure }
  WIN_CERT_TYPE_RESERVED_1 = $0003;                  { Reserved }

{ API }

                                       
function WinSubmitCertificate(var lpCertificate: TWinCertificate): BOOL;

{ Trust API and Structures }

function WinVerifyTrust(hwnd: HWND;
  [MarshalAs(UnmanagedType.LPStruct)] ActionID: TGUID; ActionData: IntPtr): Longint;

                                       
function WinLoadTrustProvider(var ActionID: TGUID): BOOL;

{ Common Trust API Data Structures }

{ Data type commonly used in ActionData structures }

type
  TWinTrustSubject = IntPtr; { Pointer }

{ Two commonly used ActionData structures }

  [StructLayout(LayoutKind.Sequential)]
  _WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT = record
    hClientToken: THandle;
    SubjectType: IntPtr; { PGUID }
    Subject: TWinTrustSubject;
  end;
  TWinTrustActdataContextWithSubject = _WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT;
  WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT = _WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT;


  [StructLayout(LayoutKind.Sequential)]
  _WIN_TRUST_ACTDATA_SUBJECT_ONLY = record
    SubjectType: IntPtr; { PGUID }
    Subject: TWinTrustSubject;
  end;
  TWinTrustActdataSubjectOnly = _WIN_TRUST_ACTDATA_SUBJECT_ONLY;
  WIN_TRUST_ACTDATA_SUBJECT_ONLY = _WIN_TRUST_ACTDATA_SUBJECT_ONLY;


{ SUBJECT FORM DEFINITIONS }
{$IFNDEF CLR}
{ Currently defined Subject Type Identifiers.  All of the below
  use the WIN_TRUST_SUBJECT_FILE subject form, defined below. }

const
{ RawFile = 959dc450-8d9e-11cf-8736-00aa00a485eb }
  WIN_TRUST_SUBJTYPE_RAW_FILE: TGUID =
    '{959dc450-8d9e-11cf-8736-00aa00a485eb}';

{ PeImage = 43c9a1e0-8da0-11cf-8736-00aa00a485eb }
  WIN_TRUST_SUBJTYPE_PE_IMAGE: TGUID =
    '{43c9a1e0-8da0-11cf-8736-00aa00a485eb}';

{ JavaClass = 08ad3990-8da1-11cf-8736-00aa00a485eb }
  WIN_TRUST_SUBJTYPE_JAVA_CLASS: TGUID =
    '{08ad3990-8da1-11cf-8736-00aa00a485eb}';

{ Cabinet = d17c5374-a392-11cf-9df5-00aa00c184e0 }
  WIN_TRUST_SUBJTYPE_CABINET: TGUID =
    '{d17c5374-a392-11cf-9df5-00aa00c184e0}';

{ Associated Subject Data Structure: }


type
  [StructLayout(LayoutKind.Sequential)]
  _WIN_TRUST_SUBJECT_FILE = record
    hFile: THandle;
    [MarshalAs(UnmanagedType.LPWStr)]
    lpPath: string;
  end;
  TWinTrustSubjectFile = _WIN_TRUST_SUBJECT_FILE;
  WIN_TRUST_SUBJECT_FILE = _WIN_TRUST_SUBJECT_FILE;

{ The following subject types use the
  WIN_TRUST_SUBJECT_FILE_AND_DISPLAY subject type, defined
  below. }

const
  WIN_TRUST_SUBJTYPE_RAW_FILEEX: TGUID = (
          D1:$6f458110; D2:$c2f1; D3:$11cf; D4:($8a, $69, $0, $aa, $0, $6c, $37, $6 ));

  WIN_TRUST_SUBJTYPE_PE_IMAGEEX: TGUID = (
          D1:$6f458111; D2:$c2f1; D3:$11cf; D4:($8a, $69, $0, $aa, $0, $6c, $37, $6 ));

  WIN_TRUST_SUBJTYPE_JAVA_CLASSEX: TGUID = (
          D1:$6f458113; D2:$c2f1; D3:$11cf; D4:($8a, $69, $0, $aa, $0, $6c, $37, $6 ));

  WIN_TRUST_SUBJTYPE_CABINETEX: TGUID = (
          D1:$6f458114; D2:$c2f1; D3:$11cf; D4:($8a, $69, $0, $aa, $0, $6c, $37, $6 ));

{ Associated Subject Data Structure: }

type
  [StructLayout(LayoutKind.Sequential)]
  _WIN_TRUST_SUBJECT_FILE_AND_DISPLAY = record
    hFile: THandle;              { handle to the open file if you got it }
    [MarshalAs(UnmanagedType.LPWStr)]
    lpPath: string;              { the path to open if you don't }
    [MarshalAs(UnmanagedType.LPWStr)]
    lpDisplayName: string;       { (optional) display name to show to user }
                                 {      in place of path }
  end;
  TWinTrustSubjectFileAndDisplay = _WIN_TRUST_SUBJECT_FILE_AND_DISPLAY;
  WIN_TRUST_SUBJECT_FILE_AND_DISPLAY = _WIN_TRUST_SUBJECT_FILE_AND_DISPLAY;

{ Other subject types: }

const
{ OleStorage == c257e740-8da0-11cf-8736-00aa00a485eb }
WIN_TRUST_SUBJTYPE_OLE_STORAGE: TGUID = (
          D1:$c257e740; D2:$8da0; D3:$11cf; D4:($87, $36, $00, $aa, $00, $a4, $85, $eb));


{ TRUST PROVIDER SPECIFIC DEFINITIONS

      Each trust provider will have the following
      sections defined:

      Actions - What actions are supported by the trust
          provider.
      SubjectForms - Subjects that may be evaluated by this
          trust provider.
                     and
      Data structures to support the subject forms. }


{ Software Publisher Trust Provider }

{ Actions: }

{ TrustedPublisher == 66426730-8da1-11cf-8736-00aa00a485eb }
  WIN_SPUB_ACTION_TRUSTED_PUBLISHER: TGUID = (
          D1:$66426730; D2:$8da1; D3:$11cf; D4:($87, $36, $00, $aa, $00, $a4, $85, $eb));

{ NtActivateImage == 8bc96b00-8da1-11cf-8736-00aa00a485eb }
  WIN_SPUB_ACTION_NT_ACTIVATE_IMAGE: TGUID = (
          D1:$8bc96b00; D2:$8da1; D3:$11cf; D4:($87, $36, $00, $aa, $00, $a4, $85, $eb));

{ PublishedSoftware == 64b9d180-8da2-11cf-8736-00aa00a485eb }
  WIN_SPUB_ACTION_PUBLISHED_SOFTWARE: TGUID = (
          D1:$64b9d180; D2:$8da2; D3:$11cf; D4:($87, $36, $00, $aa, $00, $a4, $85, $eb));

{ Data Structures: }

{ WIN_SPUB_ACTION_TRUSTED_PUBLISHER:
      Uses WIN_SPUB_TRUSTED_PUBLISHER_DATA }

{ WIN_SPUB_ACTION_NT_ACTIVATE_IMAGE:
      Uses WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT }

{ WIN_SPUB_ACTION_PUBLISHED_SOFTWARE:
      Uses WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT }

type
  [StructLayout(LayoutKind.Sequential)]
  _WIN_SPUB_TRUSTED_PUBLISHER_DATA = record
    hClientToken: THandle;
    lpCertificate: IntPtr; { PWinCertificate }
  end;
  TWinSpubTrustedPublisherData = _WIN_SPUB_TRUSTED_PUBLISHER_DATA;
  WIN_SPUB_TRUSTED_PUBLISHER_DATA = _WIN_SPUB_TRUSTED_PUBLISHER_DATA;

{$ENDIF}

{ Translated from WINGDI.H }

const
  { Binary raster ops }
  R2_BLACK       = 1;     {  0   }
  R2_NOTMERGEPEN = 2;     { DPon }
  R2_MASKNOTPEN  = 3;     { DPna }
  R2_NOTCOPYPEN  = 4;     { PN   }
  R2_MASKPENNOT  = 5;     { PDna }
  R2_NOT         = 6;     { Dn   }
  R2_XORPEN      = 7;     { DPx  }
  R2_NOTMASKPEN  = 8;     { DPan }
  R2_MASKPEN     = 9;     { DPa  }
  R2_NOTXORPEN   = 10;    { DPxn }
  R2_NOP         = 11;    { D    }
  R2_MERGENOTPEN = 12;    { DPno }
  R2_COPYPEN     = 13;    { P    }
  R2_MERGEPENNOT = 14;    { PDno }
  R2_MERGEPEN    = 15;    { DPo  }
  R2_WHITE       = $10;   {  1   }
  R2_LAST        = $10;


  { Ternary raster operations }
  SRCCOPY     = $00CC0020;     { dest = source                    }
  SRCPAINT    = $00EE0086;     { dest = source OR dest            }
  SRCAND      = $008800C6;     { dest = source AND dest           }
  SRCINVERT   = $00660046;     { dest = source XOR dest           }
  SRCERASE    = $00440328;     { dest = source AND (NOT dest )    }
  NOTSRCCOPY  = $00330008;     { dest = (NOT source)              }
  NOTSRCERASE = $001100A6;     { dest = (NOT src) AND (NOT dest)  }
  MERGECOPY   = $00C000CA;     { dest = (source AND pattern)      }
  MERGEPAINT  = $00BB0226;     { dest = (NOT source) OR dest      }
  PATCOPY     = $00F00021;     { dest = pattern                   }
  PATPAINT    = $00FB0A09;     { dest = DPSnoo                    }
  PATINVERT   = $005A0049;     { dest = pattern XOR dest          }
  DSTINVERT   = $00550009;     { dest = (NOT dest)                }
  BLACKNESS   = $00000042;     { dest = BLACK                     }
  WHITENESS   = $00FF0062;     { dest = WHITE                     }


{ Quaternary raster codes }

function MakeROP4(fore,back: DWORD): DWORD;

const
  GDI_ERROR = DWORD($FFFFFFFF);
  HGDI_ERROR = DWORD($FFFFFFFF);


  { Region Flags }
  ERROR = 0;
  NULLREGION = 1;
  SIMPLEREGION = 2;
  COMPLEXREGION = 3;
  RGN_ERROR = ERROR;


  { CombineRgn() Styles }
  RGN_AND = 1;
  RGN_OR = 2;
  RGN_XOR = 3;
  RGN_DIFF = 4;
  RGN_COPY = 5;
  RGN_MIN = RGN_AND;
  RGN_MAX = RGN_COPY;

  { StretchBlt() Modes }
  BLACKONWHITE = 1;
  WHITEONBLACK = 2;
  COLORONCOLOR = 3;
  HALFTONE = 4;
  MAXSTRETCHBLTMODE = 4;


  { New StretchBlt() Modes }
  STRETCH_ANDSCANS = BLACKONWHITE;
  STRETCH_ORSCANS = WHITEONBLACK;
  STRETCH_DELETESCANS = COLORONCOLOR;
  STRETCH_HALFTONE = HALFTONE;


  { PolyFill() Modes }
  ALTERNATE = 1;
  WINDING = 2;
  POLYFILL_LAST = 2;


  { Text Alignment Options }
  TA_NOUPDATECP = 0;
  TA_UPDATECP = 1;
  TA_LEFT = 0;
  TA_RIGHT = 2;
  TA_CENTER = 6;
  TA_TOP = 0;
  TA_BOTTOM = 8;
  TA_BASELINE = 24;
  TA_RTLREADING = $100;
  TA_MASK =  (TA_BASELINE+TA_CENTER+TA_UPDATECP+TA_RTLREADING);

  VTA_BASELINE = TA_BASELINE;
  VTA_LEFT = TA_BOTTOM;
  VTA_RIGHT = TA_TOP;
  VTA_CENTER = TA_CENTER;
  VTA_BOTTOM = TA_RIGHT;
  VTA_TOP = TA_LEFT;

  ETO_OPAQUE = 2;
  ETO_CLIPPED = 4;
  ETO_GLYPH_INDEX = $10;
  ETO_RTLREADING = $80;
  ETO_NUMERICSLOCAL = $400;
  ETO_NUMERICSLATIN = $800;
  ETO_IGNORELANGUAGE = $1000;
  ETO_PDY = $2000;

  ASPECT_FILTERING = 1;


  { Bounds Accumulation APIs }
  DCB_RESET = 1;
  DCB_ACCUMULATE = 2;
  DCB_DIRTY = DCB_ACCUMULATE;
  DCB_SET = (DCB_RESET or DCB_ACCUMULATE);
  DCB_ENABLE = 4;
  DCB_DISABLE = 8;

  { Metafile Functions }
  META_SETBKCOLOR = 513;
  META_SETBKMODE = 258;
  META_SETMAPMODE = 259;
  META_SETROP2 = 260;
  META_SETRELABS = 261;
  META_SETPOLYFILLMODE = 262;
  META_SETSTRETCHBLTMODE = 263;
  META_SETTEXTCHAREXTRA = 264;
  META_SETTEXTCOLOR = 521;
  META_SETTEXTJUSTIFICATION = 522;
  META_SETWINDOWORG = 523;
  META_SETWINDOWEXT = 524;
  META_SETVIEWPORTORG = 525;
  META_SETVIEWPORTEXT = 526;
  META_OFFSETWINDOWORG = 527;
  META_SCALEWINDOWEXT = 1040;
  META_OFFSETVIEWPORTORG = 529;
  META_SCALEVIEWPORTEXT = 1042;
  META_LINETO = 531;
  META_MOVETO = 532;
  META_EXCLUDECLIPRECT = 1045;
  META_INTERSECTCLIPRECT = 1046;
  META_ARC = 2071;
  META_ELLIPSE = 1048;
  META_FLOODFILL = 1049;
  META_PIE = 2074;
  META_RECTANGLE = 1051;
  META_ROUNDRECT = 1564;
  META_PATBLT = 1565;
  META_SAVEDC = 30;
  META_SETPIXEL = 1055;
  META_OFFSETCLIPRGN = 544;
  META_TEXTOUT = 1313;
  META_BITBLT = 2338;
  META_STRETCHBLT = 2851;
  META_POLYGON = 804;
  META_POLYLINE = 805;
  META_ESCAPE = 1574;
  META_RESTOREDC = 295;
  META_FILLREGION = 552;
  META_FRAMEREGION = 1065;
  META_INVERTREGION = 298;
  META_PAINTREGION = 299;
  META_SELECTCLIPREGION = 300;
  META_SELECTOBJECT = 301;
  META_SETTEXTALIGN = 302;
  META_CHORD = 2096;
  META_SETMAPPERFLAGS = 561;
  META_EXTTEXTOUT = 2610;
  META_SETDIBTODEV = 3379;
  META_SELECTPALETTE = 564;
  META_REALIZEPALETTE = 53;
  META_ANIMATEPALETTE = 1078;
  META_SETPALENTRIES = 55;
  META_POLYPOLYGON = 1336;
  META_RESIZEPALETTE = 313;
  META_DIBBITBLT = 2368;
  META_DIBSTRETCHBLT = 2881;
  META_DIBCREATEPATTERNBRUSH = 322;
  META_STRETCHDIB = 3907;
  META_EXTFLOODFILL = 1352;
  META_DELETEOBJECT = 496;
  META_CREATEPALETTE = 247;
  META_CREATEPATTERNBRUSH = 505;
  META_CREATEPENINDIRECT = 762;
  META_CREATEFONTINDIRECT = 763;
  META_CREATEBRUSHINDIRECT = 764;
  META_CREATEREGION = 1791;


  { GDI Escapes }
  NEWFRAME = 1;
  _ABORTDOC = 2; { Renamed }
  NEXTBAND = 3;
  SETCOLORTABLE = 4;
  GETCOLORTABLE = 5;
  FLUSHOUTPUT = 6;
  DRAFTMODE = 7;
  QUERYESCSUPPORT = 8;
  _SETABORTPROC = 9; { Renamed }
  _STARTDOC = 10; { Renamed }
  _ENDDOC = 11; { Renamed }
  GETPHYSPAGESIZE = 12;
  GETPRINTINGOFFSET = 13;
  GETSCALINGFACTOR = 14;
  MFCOMMENT = 15;
  GETPENWIDTH = $10;
  SETCOPYCOUNT = 17;
  SELECTPAPERSOURCE = 18;
  DEVICEDATA = 19;
  PASSTHROUGH = 19;
  GETTECHNOLGY = 20;
  GETTECHNOLOGY = 20;
  SETLINECAP = 21;
  SETLINEJOIN = 22;
  _SETMITERLIMIT = 23; { Renamed }
  BANDINFO = 24;
  DRAWPATTERNRECT = 25;
  GETVECTORPENSIZE = 26;
  GETVECTORBRUSHSIZE = 27;
  ENABLEDUPLEX = 28;
  GETSETPAPERBINS = 29;
  GETSETPRINTORIENT = 30;
  ENUMPAPERBINS = 31;
  SETDIBSCALING = $20;
  EPSPRINTING = 33;
  ENUMPAPERMETRICS = 34;
  GETSETPAPERMETRICS = 35;
  POSTSCRIPT_DATA = 37;
  POSTSCRIPT_IGNORE = 38;
  MOUSETRAILS = 39;
  GETDEVICEUNITS = 42;

  GETEXTENDEDTEXTMETRICS = 256;
  GETEXTENTTABLE = 257;
  GETPAIRKERNTABLE = 258;
  GETTRACKKERNTABLE = 259;
  _EXTTEXTOUT = $200; { Renamed }
  GETFACENAME = 513;
  DOWNLOADFACE = 514;
  ENABLERELATIVEWIDTHS = 768;
  ENABLEPAIRKERNING = 769;
  SETKERNTRACK = 770;
  SETALLJUSTVALUES = 771;
  SETCHARSET = 772;

  _STRETCHBLT = $800; { Renamed }
  GETSETSCREENPARAMS = 3072;
  QUERYDIBSUPPORT = 3073;
  BEGIN_PATH = $1000;
  CLIP_TO_PATH = 4097;
  END_PATH = 4098;
  EXT_DEVICE_CAPS = 4099;
  RESTORE_CTM = 4100;
  SAVE_CTM = 4101;
  SET_ARC_DIRECTION = 4102;
  SET_BACKGROUND_COLOR = 4103;
  SET_POLY_MODE = 4104;
  SET_SCREEN_ANGLE = 4105;
  SET_SPREAD = 4106;
  TRANSFORM_CTM = 4107;
  SET_CLIP_BOX = 4108;
  SET_BOUNDS = 4109;
  SET_MIRROR_MODE = 4110;
  OPENCHANNEL = 4110;
  DOWNLOADHEADER = 4111;
  CLOSECHANNEL = 4112;
  POSTSCRIPT_PASSTHROUGH = 4115;
  ENCAPSULATED_POSTSCRIPT = 4116;

  { Flag returned from QUERYDIBSUPPORT }
  QDI_SETDIBITS = 1;
  QDI_GETDIBITS = 2;
  QDI_DIBTOSCREEN = 4;
  QDI_STRETCHDIB = 8;


  { Spooler Error Codes }
  SP_NOTREPORTED = $4000;
  SP_ERROR = LongWord(-1);
  SP_APPABORT = LongWord(-2);
  SP_USERABORT = LongWord(-3);
  SP_OUTOFDISK = LongWord(-4);
  SP_OUTOFMEMORY = LongWord(-5);

  PR_JOBSTATUS = 0;


  { Object Definitions for EnumObjects() }
  OBJ_PEN = 1;
  OBJ_BRUSH = 2;
  OBJ_DC = 3;
  OBJ_METADC = 4;
  OBJ_PAL = 5;
  OBJ_FONT = 6;
  OBJ_BITMAP = 7;
  OBJ_REGION = 8;
  OBJ_METAFILE = 9;
  OBJ_MEMDC = 10;
  OBJ_EXTPEN = 11;
  OBJ_ENHMETADC = 12;
  OBJ_ENHMETAFILE = 13;


  { xform stuff }
  MWT_IDENTITY = 1;
  MWT_LEFTMULTIPLY = 2;
  MWT_RIGHTMULTIPLY = 3;

  MWT_MIN = MWT_IDENTITY;
  MWT_MAX = MWT_RIGHTMULTIPLY;


type
  tagXFORM = packed record
    eM11: Single;
    eM12: Single;
    eM21: Single;
    eM22: Single;
    eDx: Single;
    eDy: Single;
  end;
  TXForm = tagXFORM;
  XFORM = tagXFORM;

{ Bitmap Header Definition }
  tagBITMAP = packed record
    bmType: Longint;
    bmWidth: Longint;
    bmHeight: Longint;
    bmWidthBytes: Longint;
    bmPlanes: Word;
    bmBitsPixel: Word;
    bmBits: IntPtr;
  end;
  TBitmap = tagBITMAP;
  BITMAP = tagBITMAP;

  tagRGBTRIPLE = packed record
    rgbtBlue: Byte;
    rgbtGreen: Byte;
    rgbtRed: Byte;
  end;
  TRGBTriple = tagRGBTRIPLE;
  RGBTRIPLE = tagRGBTRIPLE;

  tagRGBQUAD = packed record
    rgbBlue: Byte;
    rgbGreen: Byte;
    rgbRed: Byte;
    rgbReserved: Byte;
  end;
  TRGBQuad = tagRGBQUAD;
  RGBQUAD = tagRGBQUAD;


  { Image Color Matching color definitions }
  LCSCSTYPE = Longint;
const
  LCS_CALIBRATED_RGB = 0;
  LCS_DEVICE_RGB = 1;
  LCS_DEVICE_CMYK = 2;

type
  LCSGAMUTMATCH = Longint;
const
  LCS_GM_BUSINESS = 1;
  LCS_GM_GRAPHICS = 2;
  LCS_GM_IMAGES = 4;


  { ICM Defines for results from CheckColorInGamut() }
  CM_OUT_OF_GAMUT = 255;
  CM_IN_GAMUT = 0;


{ functions to retrieve CMYK values from a COLORREF }

function GetCValue(cmyk: COLORREF): Byte;
function GetMValue(cmyk: COLORREF): Byte;
function GetYValue(cmyk: COLORREF): Byte;
function GetKValue(cmyk: COLORREF): Byte;
function CMYK(c, m, y, k: Byte): COLORREF;

type
  FXPT16DOT16 = Longint;
  FXPT2DOT30 = Longint;


  { ICM Color Definitions }
  { The following two structures are used for defining RGB's in terms of
    CIEXYZ. The values are fixed point 16.16. }

  tagCIEXYZ = packed record
    ciexyzX: FXPT2DOT30;
    ciexyzY: FXPT2DOT30;
    ciexyzZ: FXPT2DOT30;
  end;
  TCIEXYZ = tagCIEXYZ;
  CIEXYZ = tagCIEXYZ;

  tagICEXYZTRIPLE = packed record
    ciexyzRed: TCIEXYZ;
    ciexyzGreen: TCIEXYZ;
    ciexyzBlue: TCIEXYZ;
  end;
  TCIEXYZTriple = tagICEXYZTRIPLE;
  CIEXYZTRIPLE = tagICEXYZTRIPLE;

  { The next structures the logical color space. Unlike pens and brushes,
    but like palettes, there is only one way to create a LogColorSpace.
    A pointer to it must be passed, its elements can't be pushed as
    arguments. }

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagLOGCOLORSPACE = packed record
    lcsSignature: DWORD;
    lcsVersion: DWORD;
    lcsSize: DWORD;
    lcsCSType: LCSCSTYPE;
    lcsIntent: LCSGAMUTMATCH;
    lcsEndpoints: TCIEXYZTriple;
    lcsGammaRed: DWORD;
    lcsGammaGreen: DWORD;
    lcsGammaBlue: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=260)]
    lcsFilename: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagLOGCOLORSPACEA = packed record
    lcsSignature: DWORD;
    lcsVersion: DWORD;
    lcsSize: DWORD;
    lcsCSType: LCSCSTYPE;
    lcsIntent: LCSGAMUTMATCH;
    lcsEndpoints: TCIEXYZTriple;
    lcsGammaRed: DWORD;
    lcsGammaGreen: DWORD;
    lcsGammaBlue: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=260)]
    lcsFilename: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagLOGCOLORSPACEW = packed record
    lcsSignature: DWORD;
    lcsVersion: DWORD;
    lcsSize: DWORD;
    lcsCSType: LCSCSTYPE;
    lcsIntent: LCSGAMUTMATCH;
    lcsEndpoints: TCIEXYZTriple;
    lcsGammaRed: DWORD;
    lcsGammaGreen: DWORD;
    lcsGammaBlue: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=260)]
    lcsFilename: string;
  end;
  TLogColorSpace = tagLOGCOLORSPACE;
  TLogColorSpaceA = tagLOGCOLORSPACEA;
  TLogColorSpaceW = tagLOGCOLORSPACEW;
  LOGCOLORSPACE = tagLOGCOLORSPACE;
  LOGCOLORSPACEA = tagLOGCOLORSPACEA;
  LOGCOLORSPACEW = tagLOGCOLORSPACEW;

  { structures for defining DIBs - used to get to color table }
  tagBITMAPCOREHEADER = packed record
    bcSize: DWORD;
    bcWidth: Word;
    bcHeight: Word;
    bcPlanes: Word;
    bcBitCount: Word;
  end;
  TBitmapCoreHeader = tagBITMAPCOREHEADER;
  BITMAPCOREHEADER = tagBITMAPCOREHEADER;

  tagBITMAPINFOHEADER = packed record
    biSize: DWORD;
    biWidth: Longint;
    biHeight: Longint;
    biPlanes: Word;
    biBitCount: Word;
    biCompression: DWORD;
    biSizeImage: DWORD;
    biXPelsPerMeter: Longint;
    biYPelsPerMeter: Longint;
    biClrUsed: DWORD;
    biClrImportant: DWORD;
  end;
  TBitmapInfoHeader = tagBITMAPINFOHEADER;
  BITMAPINFOHEADER = tagBITMAPINFOHEADER;

  BITMAPV4HEADER = packed record
    bV4Size: DWORD;
    bV4Width: Longint;
    bV4Height: Longint;
    bV4Planes: Word;
    bV4BitCount: Word;
    bV4V4Compression: DWORD;
    bV4SizeImage: DWORD;
    bV4XPelsPerMeter: Longint;
    bV4YPelsPerMeter: Longint;
    bV4ClrUsed: DWORD;
    bV4ClrImportant: DWORD;
    bV4RedMask: DWORD;
    bV4GreenMask: DWORD;
    bV4BlueMask: DWORD;
    bV4AlphaMask: DWORD;
    bV4CSType: DWORD;
    bV4Endpoints: TCIEXYZTriple;
    bV4GammaRed: DWORD;
    bV4GammaGreen: DWORD;
    bV4GammaBlue: DWORD;
  end;
  TBitmapV4Header = BITMAPV4HEADER;

  BITMAPV5HEADER = packed record
    bV5Size: DWORD;
    bV5Width: Longint;
    bV5Height: Longint;
    bV5Planes: Word;
    bV5BitCount: Word;
    bV5Compression: DWORD;
    bV5SizeImage: DWORD;
    bV5XPelsPerMeter: Longint;
    bV5YPelsPerMeter: Longint;
    bV5ClrUsed: DWORD;
    bV5ClrImportant: DWORD;
    bV5RedMask: DWORD;
    bV5GreenMask: DWORD;
    bV5BlueMask: DWORD;
    bV5AlphaMask: DWORD;
    bV5CSType: DWORD;
    bV5Endpoints: TCIEXYZTriple;
    bV5GammaRed: DWORD;
    bV5GammaGreen: DWORD;
    bV5GammaBlue: DWORD;
    bV5Intent: DWORD;
    bV5ProfileData: DWORD;
    bV5ProfileSize: DWORD;
    bV5Reserved: DWORD;
  end;
  TBitmapV5Header = BITMAPV5HEADER;

const
  { constants for the biCompression field }
  BI_RGB = 0;
  BI_RLE8 = 1;
  BI_RLE4 = 2;
  BI_BITFIELDS = 3;

type
  tagBITMAPINFO = packed record
    bmiHeader: TBitmapInfoHeader;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
    bmiColors: array[0..255] of COLORREF;
  end;
  TBitmapInfo = tagBITMAPINFO;
  BITMAPINFO = tagBITMAPINFO;

  [StructLayout(LayoutKind.Sequential)]
  tagBITMAPCOREINFO = record
    bmciHeader: TBitmapCoreHeader;
    bmciColors: IntPtr; { array[0..0] of TRGBTriple }
    Reserved: IntPtr;   { array[0..0] of Char }
  end;
  TBitmapCoreInfo = tagBITMAPCOREINFO;
  BITMAPCOREINFO = tagBITMAPCOREINFO;

  tagBITMAPFILEHEADER = packed record
    bfType: Word;
    bfSize: DWORD;
    bfReserved1: Word;
    bfReserved2: Word;
    bfOffBits: DWORD;
  end;
  TBitmapFileHeader = tagBITMAPFILEHEADER;
  BITMAPFILEHEADER = tagBITMAPFILEHEADER;

  tagFONTSIGNATURE = packed record
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=4)]
    fsUsb: array[0..3] of DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=2)]
    fsCsb: array[0..1] of DWORD;
  end;
  TFontSignature = tagFONTSIGNATURE;
  FONTSIGNATURE = tagFONTSIGNATURE;

  tagCHARSETINFO = packed record
    ciCharset: UINT;
    ciACP: UINT;
    fs: TFontSignature;
  end;
  TCharsetInfo = tagCHARSETINFO;
  CHARSETINFO = tagCHARSETINFO;

const
  TCI_SRCCHARSET = 1;
  TCI_SRCCODEPAGE = 2;
  TCI_SRCFONTSIG = 3;

type
  tagLOCALESIGNATURE = packed record
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=4)]
    lsUsb: array[0..3] of DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=2)]
    lsCsbDefault: array[0..1] of DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=2)]
    lsCsbSupported: array[0..1] of DWORD;
  end;
  TLocaleSignature = tagLOCALESIGNATURE;
  LOCALESIGNATURE = tagLOCALESIGNATURE;

  { Clipboard Metafile Picture Structure }
  tagHANDLETABLE = packed record
    objectHandle: array[0..0] of HGDIOBJ;
  end;
  THandleTable = tagHANDLETABLE;
  HANDLETABLE = tagHANDLETABLE;

  tagMETARECORD = packed record
    rdSize: DWORD;
    rdFunction: Word;
    rdParm: array[0..0] of Word;
  end;
  TMetaRecord = tagMETARECORD;
  METARECORD = tagMETARECORD;

  tagMETAFILEPICT = packed record
    mm: Longint;
    xExt: Longint;
    yExt: Longint;
    hMF: HMETAFILE;
  end;
  TMetafilePict = tagMETAFILEPICT;
  METAFILEPICT = tagMETAFILEPICT;

  tagMETAHEADER = packed record
    mtType: Word;
    mtHeaderSize: Word;
    mtVersion: Word;
    mtSize: DWORD;
    mtNoObjects: Word;
    mtMaxRecord: DWORD;
    mtNoParameters: Word;
  end;
  TMetaHeader = tagMETAHEADER;
  METAHEADER = tagMETAHEADER;

  { Enhanced Metafile structures }

  tagENHMETARECORD = packed record
    iType: DWORD; { Record type EMR_XXX}
    nSize: DWORD; { Record size in bytes}
    dParm: array[0..0] of DWORD; { Parameters}
  end;
  TEnhMetaRecord = tagENHMETARECORD;
  ENHMETARECORD = tagENHMETARECORD;

  tagENHMETAHEADER = packed record
    iType: DWORD;          { Record type EMR_HEADER}
    nSize: DWORD;          { Record size in bytes.  This may be greater
                             than the sizeof(TEnhMetaHeader). }
    rclBounds: TRect;     { Inclusive-inclusive bounds in device units}
    rclFrame: TRect;      { Inclusive-inclusive Picture Frame of metafile in .01 mm units}
    dSignature: DWORD;     { Signature.  Must be ENHMETA_SIGNATURE.}
    nVersion: DWORD;       { Version number}
    nBytes: DWORD;         { Size of the metafile in bytes}
    nRecords: DWORD;       { Number of records in the metafile}
    nHandles: Word;        { Number of handles in the handle table
                             Handle index zero is reserved. }
    sReserved: Word;       { Reserved.  Must be zero.}
    nDescription: DWORD;   { Number of chars in the unicode description string
                             This is 0 if there is no description string }
    offDescription: DWORD; { Offset to the metafile description record. }
                           { This is 0 if there is no description string }
    nPalEntries: DWORD;    { Number of entries in the metafile palette.}
    szlDevice: TSize;      { Size of the reference device in pels}
    szlMillimeters: TSize; { Size of the reference device in millimeters}
    cbPixelFormat: DWORD;  { Size of TPixelFormatDescriptor information }
                           { This is 0 if no pixel format is set }
    offPixelFormat: DWORD; { Offset to TPixelFormatDescriptor }
                           { This is 0 if no pixel format is set }
    bOpenGL: DWORD;        { True if OpenGL commands are present in }
                           { the metafile, otherwise FALSE }
  end;
  TEnhMetaHeader = tagENHMETAHEADER;
  ENHMETAHEADER = tagENHMETAHEADER;

const
  { tmPitchAndFamily flags }
  TMPF_FIXED_PITCH = 1;
  TMPF_VECTOR = 2;
  TMPF_DEVICE = 8;
  TMPF_TRUETYPE = 4;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagTEXTMETRIC = record
    tmHeight: Longint;
    tmAscent: Longint;
    tmDescent: Longint;
    tmInternalLeading: Longint;
    tmExternalLeading: Longint;
    tmAveCharWidth: Longint;
    tmMaxCharWidth: Longint;
    tmWeight: Longint;
    tmOverhang: Longint;
    tmDigitizedAspectX: Longint;
    tmDigitizedAspectY: Longint;
    tmFirstChar: Char;
    tmLastChar: Char;
    tmDefaultChar: Char;
    tmBreakChar: Char;
    tmItalic: Byte;
    tmUnderlined: Byte;
    tmStruckOut: Byte;
    tmPitchAndFamily: Byte;
    tmCharSet: Byte;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagTEXTMETRICA = record
    tmHeight: Longint;
    tmAscent: Longint;
    tmDescent: Longint;
    tmInternalLeading: Longint;
    tmExternalLeading: Longint;
    tmAveCharWidth: Longint;
    tmMaxCharWidth: Longint;
    tmWeight: Longint;
    tmOverhang: Longint;
    tmDigitizedAspectX: Longint;
    tmDigitizedAspectY: Longint;
    tmFirstChar: AnsiChar;
    tmLastChar: AnsiChar;
    tmDefaultChar: AnsiChar;
    tmBreakChar: AnsiChar;
    tmItalic: Byte;
    tmUnderlined: Byte;
    tmStruckOut: Byte;
    tmPitchAndFamily: Byte;
    tmCharSet: Byte;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagTEXTMETRICW = record
    tmHeight: Longint;
    tmAscent: Longint;
    tmDescent: Longint;
    tmInternalLeading: Longint;
    tmExternalLeading: Longint;
    tmAveCharWidth: Longint;
    tmMaxCharWidth: Longint;
    tmWeight: Longint;
    tmOverhang: Longint;
    tmDigitizedAspectX: Longint;
    tmDigitizedAspectY: Longint;
    tmFirstChar: WideChar;
    tmLastChar: WideChar;
    tmDefaultChar: WideChar;
    tmBreakChar: WideChar;
    tmItalic: Byte;
    tmUnderlined: Byte;
    tmStruckOut: Byte;
    tmPitchAndFamily: Byte;
    tmCharSet: Byte;
  end;
  TTextMetric = tagTEXTMETRIC;
  TTextMetricA = tagTEXTMETRICA;
  TTextMetricW = tagTEXTMETRICW;
  TEXTMETRIC = tagTEXTMETRIC;
  TEXTMETRICA = tagTEXTMETRICA;
  TEXTMETRICW = tagTEXTMETRICW;

const
  { ntmFlags field flags }
  NTM_REGULAR = $40;
  NTM_BOLD = $20;
  NTM_ITALIC = 1;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagNEWTEXTMETRIC = record
    tmHeight: Longint;
    tmAscent: Longint;
    tmDescent: Longint;
    tmInternalLeading: Longint;
    tmExternalLeading: Longint;
    tmAveCharWidth: Longint;
    tmMaxCharWidth: Longint;
    tmWeight: Longint;
    tmOverhang: Longint;
    tmDigitizedAspectX: Longint;
    tmDigitizedAspectY: Longint;
    tmFirstChar: Char;
    tmLastChar: Char;
    tmDefaultChar: Char;
    tmBreakChar: Char;
    tmItalic: Byte;
    tmUnderlined: Byte;
    tmStruckOut: Byte;
    tmPitchAndFamily: Byte;
    tmCharSet: Byte;
    ntmFlags: DWORD;
    ntmSizeEM: UINT;
    ntmCellHeight: UINT;
    ntmAvgWidth: UINT;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagNEWTEXTMETRICA = record
    tmHeight: Longint;
    tmAscent: Longint;
    tmDescent: Longint;
    tmInternalLeading: Longint;
    tmExternalLeading: Longint;
    tmAveCharWidth: Longint;
    tmMaxCharWidth: Longint;
    tmWeight: Longint;
    tmOverhang: Longint;
    tmDigitizedAspectX: Longint;
    tmDigitizedAspectY: Longint;
    tmFirstChar: AnsiChar;
    tmLastChar: AnsiChar;
    tmDefaultChar: AnsiChar;
    tmBreakChar: AnsiChar;
    tmItalic: Byte;
    tmUnderlined: Byte;
    tmStruckOut: Byte;
    tmPitchAndFamily: Byte;
    tmCharSet: Byte;
    ntmFlags: DWORD;
    ntmSizeEM: UINT;
    ntmCellHeight: UINT;
    ntmAvgWidth: UINT;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagNEWTEXTMETRICW = record
    tmHeight: Longint;
    tmAscent: Longint;
    tmDescent: Longint;
    tmInternalLeading: Longint;
    tmExternalLeading: Longint;
    tmAveCharWidth: Longint;
    tmMaxCharWidth: Longint;
    tmWeight: Longint;
    tmOverhang: Longint;
    tmDigitizedAspectX: Longint;
    tmDigitizedAspectY: Longint;
    tmFirstChar: WideChar;
    tmLastChar: WideChar;
    tmDefaultChar: WideChar;
    tmBreakChar: WideChar;
    tmItalic: Byte;
    tmUnderlined: Byte;
    tmStruckOut: Byte;
    tmPitchAndFamily: Byte;
    tmCharSet: Byte;
    ntmFlags: DWORD;
    ntmSizeEM: UINT;
    ntmCellHeight: UINT;
    ntmAvgWidth: UINT;
  end;
  TNewTextMetric = tagNEWTEXTMETRIC;
  TNewTextMetricA = tagNEWTEXTMETRICA;
  TNewTextMetricW = tagNEWTEXTMETRICW;
  NEWTEXTMETRIC = tagNEWTEXTMETRIC;
  NEWTEXTMETRICA = tagNEWTEXTMETRICA;
  NEWTEXTMETRICW = tagNEWTEXTMETRICW;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagNEWTEXTMETRICEX = packed record
    ntmTm: TNewTextMetric;
    ntmFontSig: TFontSignature;
  end;
  TNewTextMetricEx = tagNEWTEXTMETRICEX;
  NEWTEXTMETRICEX = tagNEWTEXTMETRICEX;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagNEWTEXTMETRICEXA = packed record
    ntmTm: TNewTextMetricA;
    ntmFontSig: TFontSignature;
  end;
  TNewTextMetricExA = tagNEWTEXTMETRICEXA;
  NEWTEXTMETRICEXA = tagNEWTEXTMETRICEXA;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagNEWTEXTMETRICEXW = packed record
    ntmTm: TNewTextMetricW;
    ntmFontSig: TFontSignature;
  end;
  TNewTextMetricExW = tagNEWTEXTMETRICEXW;
  NEWTEXTMETRICEXW = tagNEWTEXTMETRICEXW;

{ GDI Logical Objects: }

  { Pel Array }
  [StructLayout(LayoutKind.Sequential)]
  tagPELARRAY = record
    paXCount: Longint;
    paYCount: Longint;
    paXExt: Longint;
    paYExt: Longint;
    paRGBs: Byte;
  end;
  TPelArray = tagPELARRAY;
  PELARRAY = tagPELARRAY;

  { Logical Brush (or Pattern) }
  tagLOGBRUSH = packed record
    lbStyle: UINT;
    lbColor: COLORREF;
    lbHatch: Longint;
  end;
  TLogBrush = tagLOGBRUSH;
  LOGBRUSH = tagLOGBRUSH;

  TPattern = TLogBrush;

  { Logical Pen }
  tagLOGPEN = packed record
    lopnStyle: UINT;
    lopnWidth: TPoint;
    lopnColor: COLORREF;
  end;
  TLogPen = tagLOGPEN;
  LOGPEN = tagLOGPEN;

  tagEXTLOGPEN = packed record
    elpPenStyle: DWORD;
    elpWidth: DWORD;
    elpBrushStyle: UINT;
    elpColor: COLORREF;
    elpHatch: Longint;
    elpNumEntries: DWORD;
    elpStyleEntry: array[0..0] of DWORD;
  end;
  TExtLogPen = tagEXTLOGPEN;
  EXTLOGPEN = tagEXTLOGPEN;

  tagPALETTEENTRY = packed record
    peRed: Byte;
    peGreen: Byte;
    peBlue: Byte;
    peFlags: Byte;
  end;
  TPaletteEntry = tagPALETTEENTRY;
  PALETTEENTRY = tagPALETTEENTRY;


  { Logical Palette }
  tagLOGPALETTE = packed record
    palVersion: Word;
    palNumEntries: Word;
    palPalEntry: IntPtr; { array[0..0] of TPaletteEntry }
  end;
  TLogPalette = tagLOGPALETTE;
  LOGPALETTE = tagLOGPALETTE;

  TMaxLogPalette = packed record  // not in Windows Headers
    palVersion: Word;
    palNumEntries: Word;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=256)]
    palPalEntry: array [Byte] of ColorRef; { TPaletteEntry }
  end;

const
  { Logical Font }
  LF_FACESIZE = 32;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagLOGFONT = packed record
    lfHeight: Longint;
    lfWidth: Longint;
    lfEscapement: Longint;
    lfOrientation: Longint;
    lfWeight: Longint;
    lfItalic: Byte;
    lfUnderline: Byte;
    lfStrikeOut: Byte;
    lfCharSet: Byte;
    lfOutPrecision: Byte;
    lfClipPrecision: Byte;
    lfQuality: Byte;
    lfPitchAndFamily: Byte;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    lfFaceName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagLOGFONTA = packed record
    lfHeight: Longint;
    lfWidth: Longint;
    lfEscapement: Longint;
    lfOrientation: Longint;
    lfWeight: Longint;
    lfItalic: Byte;
    lfUnderline: Byte;
    lfStrikeOut: Byte;
    lfCharSet: Byte;
    lfOutPrecision: Byte;
    lfClipPrecision: Byte;
    lfQuality: Byte;
    lfPitchAndFamily: Byte;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    lfFaceName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagLOGFONTW = packed record
    lfHeight: Longint;
    lfWidth: Longint;
    lfEscapement: Longint;
    lfOrientation: Longint;
    lfWeight: Longint;
    lfItalic: Byte;
    lfUnderline: Byte;
    lfStrikeOut: Byte;
    lfCharSet: Byte;
    lfOutPrecision: Byte;
    lfClipPrecision: Byte;
    lfQuality: Byte;
    lfPitchAndFamily: Byte;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    lfFaceName: string;
  end;
  TLogFont = tagLOGFONT;
  TLogFontA = tagLOGFONTA;
  TLogFontW = tagLOGFONTW;
  LOGFONT = tagLOGFONT;
  LOGFONTA = tagLOGFONTA;
  LOGFONTW = tagLOGFONTW;

const
  LF_FULLFACESIZE = 64;

type
  { Structure passed to FONTENUMPROC }
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagENUMLOGFONT = packed record
    elfLogFont: TLogFont;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FULLFACESIZE)]
    elfFullName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    elfStyle: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagENUMLOGFONTA = packed record
    elfLogFont: TLogFontA;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FULLFACESIZE)]
    elfFullName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    elfStyle: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagENUMLOGFONTW = packed record
    elfLogFont: TLogFontW;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FULLFACESIZE)]
    elfFullName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    elfStyle: string;
  end;
  TEnumLogFont = tagENUMLOGFONT;
  TEnumLogFontA = tagENUMLOGFONTA;
  TEnumLogFontW = tagENUMLOGFONTW;
  ENUMLOGFONT = tagENUMLOGFONT;
  ENUMLOGFONTA = tagENUMLOGFONTA;
  ENUMLOGFONTW = tagENUMLOGFONTW;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagENUMLOGFONTEX = packed record
    elfLogFont: TLogFont;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FULLFACESIZE)]
    elfFullName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    elfStyle: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    elfScript: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagENUMLOGFONTEXA = packed record
    elfLogFont: TLogFontA;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FULLFACESIZE)]
    elfFullName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    elfStyle: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    elfScript: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagENUMLOGFONTEXW = packed record
    elfLogFont: TLogFontW;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FULLFACESIZE)]
    elfFullName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    elfStyle: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    elfScript: string;
  end;
  TEnumLogFontEx = tagENUMLOGFONTEX;
  TEnumLogFontExA = tagENUMLOGFONTEXA;
  TEnumLogFontExW = tagENUMLOGFONTEXW;
  ENUMLOGFONTEX = tagENUMLOGFONTEX;
  ENUMLOGFONTEXA = tagENUMLOGFONTEXA;
  ENUMLOGFONTEXW = tagENUMLOGFONTEXW;

const
  OUT_DEFAULT_PRECIS = 0;
  OUT_STRING_PRECIS = 1;
  OUT_CHARACTER_PRECIS = 2;
  OUT_STROKE_PRECIS = 3;
  OUT_TT_PRECIS = 4;
  OUT_DEVICE_PRECIS = 5;
  OUT_RASTER_PRECIS = 6;
  OUT_TT_ONLY_PRECIS = 7;
  OUT_OUTLINE_PRECIS = 8;
  OUT_SCREEN_OUTLINE_PRECIS = 9;

  CLIP_DEFAULT_PRECIS = 0;
  CLIP_CHARACTER_PRECIS = 1;
  CLIP_STROKE_PRECIS = 2;
  CLIP_MASK = 15;
  CLIP_LH_ANGLES = (1 shl 4);
  CLIP_TT_ALWAYS = (2 shl 4);
  CLIP_EMBEDDED  = (8 shl 4);

  DEFAULT_QUALITY = 0;
  DRAFT_QUALITY = 1;
  PROOF_QUALITY = 2;
  NONANTIALIASED_QUALITY = 3;
  ANTIALIASED_QUALITY = 4;

  DEFAULT_PITCH = 0;
  FIXED_PITCH = 1;
  VARIABLE_PITCH = 2;
  MONO_FONT = 8;

  ANSI_CHARSET = 0;
  DEFAULT_CHARSET = 1;
  SYMBOL_CHARSET = 2;
  SHIFTJIS_CHARSET = $80;
  HANGEUL_CHARSET = 129;
  GB2312_CHARSET = 134;
  CHINESEBIG5_CHARSET = 136;
  OEM_CHARSET = 255;
  JOHAB_CHARSET = 130;
  HEBREW_CHARSET = 177;
  ARABIC_CHARSET = 178;
  GREEK_CHARSET = 161;
  TURKISH_CHARSET = 162;
  VIETNAMESE_CHARSET = 163;
  THAI_CHARSET = 222;
  EASTEUROPE_CHARSET = 238;
  RUSSIAN_CHARSET = 204;

  MAC_CHARSET = 77;
  BALTIC_CHARSET = 186;

  FS_LATIN1 = 1;
  FS_LATIN2 = 2;
  FS_CYRILLIC = 4;
  FS_GREEK = 8;
  FS_TURKISH = $10;
  FS_HEBREW = $20;
  FS_ARABIC = $40;
  FS_BALTIC = $80;
  FS_VIETNAMESE = $00000100;
  FS_THAI = $10000;
  FS_JISJAPAN = $20000;
  FS_CHINESESIMP = $40000;
  FS_WANSUNG = $80000;
  FS_CHINESETRAD = $100000;
  FS_JOHAB = $200000;
  FS_SYMBOL = DWORD($80000000);

  { Font Families }
  FF_DONTCARE   = (0 shl 4);     { Don't care or don't know. }
  FF_ROMAN      = (1 shl 4);     { Variable stroke width, serifed. }
                                 { Times Roman, Century Schoolbook, etc. }
  FF_SWISS      = (2 shl 4);     { Variable stroke width, sans-serifed. }
                                 { Helvetica, Swiss, etc. }
  FF_MODERN     = (3 shl 4);     { Constant stroke width, serifed or sans-serifed. }
                                 { Pica, Elite, Courier, etc. }
  FF_SCRIPT     = (4 shl 4);     { Cursive, etc. }
  FF_DECORATIVE = (5 shl 4);     { Old English, etc. }

  { Font Weights }
  FW_DONTCARE = 0;
  FW_THIN = 100;
  FW_EXTRALIGHT = 200;
  FW_LIGHT = 300;
  FW_NORMAL = 400;
  FW_MEDIUM = 500;
  FW_SEMIBOLD = 600;
  FW_BOLD = 700;
  FW_EXTRABOLD = 800;
  FW_HEAVY = 900;
  FW_ULTRALIGHT = FW_EXTRALIGHT;
  FW_REGULAR = FW_NORMAL;
  FW_DEMIBOLD = FW_SEMIBOLD;
  FW_ULTRABOLD = FW_EXTRABOLD;
  FW_BLACK = FW_HEAVY;

  PANOSE_COUNT = 10;
  PAN_FAMILYTYPE_INDEX = 0;
  PAN_SERIFSTYLE_INDEX = 1;
  PAN_WEIGHT_INDEX = 2;
  PAN_PROPORTION_INDEX = 3;
  PAN_CONTRAST_INDEX = 4;
  PAN_STROKEVARIATION_INDEX = 5;
  PAN_ARMSTYLE_INDEX = 6;
  PAN_LETTERFORM_INDEX = 7;
  PAN_MIDLINE_INDEX = 8;
  PAN_XHEIGHT_INDEX = 9;

  PAN_CULTURE_LATIN = 0;

type
  tagPANOSE = packed record
    bFamilyType: Byte;
    bSerifStyle: Byte;
    bWeight: Byte;
    bProportion: Byte;
    bContrast: Byte;
    bStrokeVariation: Byte;
    bArmStyle: Byte;
    bLetterform: Byte;
    bMidline: Byte;
    bXHeight: Byte;
  end;
  TPanose = tagPANOSE;
  PANOSE = tagPANOSE;

const
  PAN_ANY = 0;
  PAN_NO_FIT = 1;

  PAN_FAMILY_TEXT_DISPLAY = 2;
  PAN_FAMILY_SCRIPT = 3;
  PAN_FAMILY_DECORATIVE = 4;
  PAN_FAMILY_PICTORIAL = 5;

  PAN_SERIF_COVE = 2;
  PAN_SERIF_OBTUSE_COVE = 3;
  PAN_SERIF_SQUARE_COVE = 4;
  PAN_SERIF_OBTUSE_SQUARE_COVE = 5;
  PAN_SERIF_SQUARE = 6;
  PAN_SERIF_THIN = 7;
  PAN_SERIF_BONE = 8;
  PAN_SERIF_EXAGGERATED = 9;
  PAN_SERIF_TRIANGLE = 10;
  PAN_SERIF_NORMAL_SANS = 11;
  PAN_SERIF_OBTUSE_SANS = 12;
  PAN_SERIF_PERP_SANS = 13;
  PAN_SERIF_FLARED = 14;
  PAN_SERIF_ROUNDED = 15;

  PAN_WEIGHT_VERY_LIGHT = 2;
  PAN_WEIGHT_LIGHT = 3;
  PAN_WEIGHT_THIN = 4;
  PAN_WEIGHT_BOOK = 5;
  PAN_WEIGHT_MEDIUM = 6;
  PAN_WEIGHT_DEMI = 7;
  PAN_WEIGHT_BOLD = 8;
  PAN_WEIGHT_HEAVY = 9;
  PAN_WEIGHT_BLACK = 10;
  PAN_WEIGHT_NORD = 11;

  PAN_PROP_OLD_STYLE = 2;
  PAN_PROP_MODERN = 3;
  PAN_PROP_EVEN_WIDTH = 4;
  PAN_PROP_EXPANDED = 5;
  PAN_PROP_CONDENSED = 6;
  PAN_PROP_VERY_EXPANDED = 7;
  PAN_PROP_VERY_CONDENSED = 8;
  PAN_PROP_MONOSPACED = 9;

  PAN_CONTRAST_NONE = 2;
  PAN_CONTRAST_VERY_LOW = 3;
  PAN_CONTRAST_LOW = 4;
  PAN_CONTRAST_MEDIUM_LOW = 5;
  PAN_CONTRAST_MEDIUM = 6;
  PAN_CONTRAST_MEDIUM_HIGH = 7;
  PAN_CONTRAST_HIGH = 8;
  PAN_CONTRAST_VERY_HIGH = 9;

  PAN_STROKE_GRADUAL_DIAG = 2;
  PAN_STROKE_GRADUAL_TRAN = 3;
  PAN_STROKE_GRADUAL_VERT = 4;
  PAN_STROKE_GRADUAL_HORZ = 5;
  PAN_STROKE_RAPID_VERT = 6;
  PAN_STROKE_RAPID_HORZ = 7;
  PAN_STROKE_INSTANT_VERT = 8;

  PAN_STRAIGHT_ARMS_HORZ = 2;
  PAN_STRAIGHT_ARMS_WEDGE = 3;
  PAN_STRAIGHT_ARMS_VERT = 4;
  PAN_STRAIGHT_ARMS_SINGLE_SERIF = 5;
  PAN_STRAIGHT_ARMS_DOUBLE_SERIF = 6;
  PAN_BENT_ARMS_HORZ = 7;
  PAN_BENT_ARMS_WEDGE = 8;
  PAN_BENT_ARMS_VERT = 9;
  PAN_BENT_ARMS_SINGLE_SERIF = 10;
  PAN_BENT_ARMS_DOUBLE_SERIF = 11;

  PAN_LETT_NORMAL_CONTACT = 2;
  PAN_LETT_NORMAL_WEIGHTED = 3;
  PAN_LETT_NORMAL_BOXED = 4;
  PAN_LETT_NORMAL_FLATTENED = 5;
  PAN_LETT_NORMAL_ROUNDED = 6;
  PAN_LETT_NORMAL_OFF_CENTER = 7;
  PAN_LETT_NORMAL_SQUARE = 8;
  PAN_LETT_OBLIQUE_CONTACT = 9;
  PAN_LETT_OBLIQUE_WEIGHTED = 10;
  PAN_LETT_OBLIQUE_BOXED = 11;
  PAN_LETT_OBLIQUE_FLATTENED = 12;
  PAN_LETT_OBLIQUE_ROUNDED = 13;
  PAN_LETT_OBLIQUE_OFF_CENTER = 14;
  PAN_LETT_OBLIQUE_SQUARE = 15;

  PAN_MIDLINE_STANDARD_TRIMMED = 2;
  PAN_MIDLINE_STANDARD_POINTED = 3;
  PAN_MIDLINE_STANDARD_SERIFED = 4;
  PAN_MIDLINE_HIGH_TRIMMED = 5;
  PAN_MIDLINE_HIGH_POINTED = 6;
  PAN_MIDLINE_HIGH_SERIFED = 7;
  PAN_MIDLINE_CONSTANT_TRIMMED = 8;
  PAN_MIDLINE_CONSTANT_POINTED = 9;
  PAN_MIDLINE_CONSTANT_SERIFED = 10;
  PAN_MIDLINE_LOW_TRIMMED = 11;
  PAN_MIDLINE_LOW_POINTED = 12;
  PAN_MIDLINE_LOW_SERIFED = 13;

  PAN_XHEIGHT_CONSTANT_SMALL = 2;
  PAN_XHEIGHT_CONSTANT_STD = 3;
  PAN_XHEIGHT_CONSTANT_LARGE = 4;
  PAN_XHEIGHT_DUCKING_SMALL = 5;
  PAN_XHEIGHT_DUCKING_STD = 6;
  PAN_XHEIGHT_DUCKING_LARGE = 7;

  ELF_VENDOR_SIZE = 4;

{ The extended logical font       }
{ An extension of the ENUMLOGFONT }

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagEXTLOGFONT = record
    elfLogFont: TLogFont;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FULLFACESIZE)]
    elfFullName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    elfStyle: string;
    elfVersion: DWORD;     { 0 for the first release of NT }
    elfStyleSize: DWORD;
    elfMatch: DWORD;
    elfReserved: DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=ELF_VENDOR_SIZE)]
    elfVendorId: array[0..ELF_VENDOR_SIZE - 1] of Byte;
    elfCulture: DWORD;     { 0 for Latin }
    elfPanose: TPanose;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagEXTLOGFONTA = record
    elfLogFont: TLogFontA;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FULLFACESIZE)]
    elfFullName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    elfStyle: string;
    elfVersion: DWORD;     { 0 for the first release of NT }
    elfStyleSize: DWORD;
    elfMatch: DWORD;
    elfReserved: DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=ELF_VENDOR_SIZE)]
    elfVendorId: array[0..ELF_VENDOR_SIZE - 1] of Byte;
    elfCulture: DWORD;     { 0 for Latin }
    elfPanose: TPanose;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagEXTLOGFONTW = record
    elfLogFont: TLogFontW;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FULLFACESIZE)]
    elfFullName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=LF_FACESIZE)]
    elfStyle: string;
    elfVersion: DWORD;     { 0 for the first release of NT }
    elfStyleSize: DWORD;
    elfMatch: DWORD;
    elfReserved: DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=ELF_VENDOR_SIZE)]
    elfVendorId: array[0..ELF_VENDOR_SIZE - 1] of Byte;
    elfCulture: DWORD;     { 0 for Latin }
    elfPanose: TPanose;
  end;
  TExtLogFont = tagEXTLOGFONT;
  TExtLogFontA = tagEXTLOGFONTA;
  TExtLogFontW = tagEXTLOGFONTW;
  EXTLOGFONT = tagEXTLOGFONT;
  EXTLOGFONTA = tagEXTLOGFONTA;
  EXTLOGFONTW = tagEXTLOGFONTW;

const
  ELF_VERSION = 0;
  ELF_CULTURE_LATIN = 0;


  { EnumFonts Masks }
  RASTER_FONTTYPE = 1;
  DEVICE_FONTTYPE = 2;
  TRUETYPE_FONTTYPE = 4;

function RGB(r, g, b: Byte): COLORREF;
function PaletteRGB(r, g, b: Byte): COLORREF;
function PaletteIndex(i: Word): COLORREF;

const
  { palette entry flags }
  PC_RESERVED = 1;     { palette index used for animation }
  PC_EXPLICIT = 2;     { palette index is explicit to device }
  PC_NOCOLLAPSE = 4;   { do not match color to system palette }

function GetRValue(rgb: DWORD): Byte;
function GetGValue(rgb: DWORD): Byte;
function GetBValue(rgb: DWORD): Byte;

const
  { Background Modes }
  TRANSPARENT = 1;
  OPAQUE = 2;
  BKMODE_LAST = 2;

  { Graphics Modes }
  GM_COMPATIBLE = 1;
  GM_ADVANCED = 2;
  GM_LAST = 2;

  { PolyDraw and GetPath point types }
  PT_CLOSEFIGURE = 1;
  PT_LINETO = 2;
  PT_BEZIERTO = 4;
  PT_MOVETO = 6;

  { Mapping Modes }
  MM_TEXT = 1;
  MM_LOMETRIC = 2;
  MM_HIMETRIC = 3;
  MM_LOENGLISH = 4;
  MM_HIENGLISH = 5;
  MM_TWIPS = 6;
  MM_ISOTROPIC = 7;
  MM_ANISOTROPIC = 8;

  { Min and Max Mapping Mode values }
  MM_MIN = MM_TEXT;
  MM_MAX = MM_ANISOTROPIC;
  MM_MAX_FIXEDSCALE = MM_TWIPS;

  { Coordinate Modes }
  ABSOLUTE = 1;
  RELATIVE = 2;

  { Stock Logical Objects }
  WHITE_BRUSH = 0;
  LTGRAY_BRUSH = 1;
  GRAY_BRUSH = 2;
  DKGRAY_BRUSH = 3;
  BLACK_BRUSH = 4;
  NULL_BRUSH = 5;
  HOLLOW_BRUSH = NULL_BRUSH;
  WHITE_PEN = 6;
  BLACK_PEN = 7;
  NULL_PEN = 8;
  OEM_FIXED_FONT = 10;
  ANSI_FIXED_FONT = 11;
  ANSI_VAR_FONT = 12;
  SYSTEM_FONT = 13;
  DEVICE_DEFAULT_FONT = 14;
  DEFAULT_PALETTE = 15;
  SYSTEM_FIXED_FONT = $10;
  DEFAULT_GUI_FONT = 17;
  DC_BRUSH = 18;
  DC_PEN = 19;
  STOCK_LAST = 19;

  CLR_INVALID = DWORD($FFFFFFFF);

  { Brush Styles }
  BS_SOLID                = 0;
  BS_NULL                 = 1;
  BS_HOLLOW               = BS_NULL;
  BS_HATCHED              = 2;
  BS_PATTERN              = 3;
  BS_INDEXED              = 4;
  BS_DIBPATTERN           = 5;
  BS_DIBPATTERNPT         = 6;
  BS_PATTERN8X8           = 7;
  BS_DIBPATTERN8X8        = 8;
  BS_MONOPATTERN          = 9;

  { Hatch Styles }
  HS_HORIZONTAL = 0;       { ----- }
  HS_VERTICAL   = 1;       { ||||| }
  HS_FDIAGONAL  = 2;       { ///// }
  HS_BDIAGONAL  = 3;       { \\\\\ }
  HS_CROSS      = 4;       { +++++ }
  HS_DIAGCROSS  = 5;       { xxxxx }


  { Pen Styles }
  PS_SOLID       = 0;
  PS_DASH        = 1;      { ------- }
  PS_DOT         = 2;      { ....... }
  PS_DASHDOT     = 3;      { _._._._ }
  PS_DASHDOTDOT  = 4;      { _.._.._ }
  PS_NULL = 5;
  PS_INSIDEFRAME = 6;
  PS_USERSTYLE = 7;
  PS_ALTERNATE = 8;
  PS_STYLE_MASK = 15;

  PS_ENDCAP_ROUND = 0;
  PS_ENDCAP_SQUARE = $100;
  PS_ENDCAP_FLAT = $200;
  PS_ENDCAP_MASK = 3840;

  PS_JOIN_ROUND = 0;
  PS_JOIN_BEVEL = $1000;
  PS_JOIN_MITER = $2000;
  PS_JOIN_MASK = 61440;

  PS_COSMETIC = 0;
  PS_GEOMETRIC = $10000;
  PS_TYPE_MASK = $F0000;

  AD_COUNTERCLOCKWISE = 1;
  AD_CLOCKWISE = 2;

  { Device Parameters for GetDeviceCaps() }
  DRIVERVERSION = 0;     { Device driver version                     }
  TECHNOLOGY    = 2;     { Device classification                     }
  HORZSIZE      = 4;     { Horizontal size in millimeters            }
  VERTSIZE      = 6;     { Vertical size in millimeters              }
  HORZRES       = 8;     { Horizontal width in pixels                }
  VERTRES       = 10;    { Vertical height in pixels                 }
  BITSPIXEL     = 12;    { Number of bits per pixel                  }
  PLANES        = 14;    { Number of planes                          }
  NUMBRUSHES    = $10;   { Number of brushes the device has          }
  NUMPENS       = 18;    { Number of pens the device has             }
  NUMMARKERS    = 20;    { Number of markers the device has          }
  NUMFONTS      = 22;    { Number of fonts the device has            }
  NUMCOLORS     = 24;    { Number of colors the device supports      }
  PDEVICESIZE   = 26;    { Size required for device descriptor       }
  CURVECAPS     = 28;    { Curve capabilities                        }
  LINECAPS      = 30;    { Line capabilities                         }
  POLYGONALCAPS = $20;   { Polygonal capabilities                    }
  TEXTCAPS      = 34;    { Text capabilities                         }
  CLIPCAPS      = 36;    { Clipping capabilities                     }
  RASTERCAPS    = 38;    { Bitblt capabilities                       }
  ASPECTX       = 40;    { Length of the X leg                       }
  ASPECTY       = 42;    { Length of the Y leg                       }
  ASPECTXY      = 44;    { Length of the hypotenuse                  }
  SHADEBLENDCAPS = 45;   { Shading and Blending caps                 }

  LOGPIXELSX    = 88;    { Logical pixelsinch in X                  }
  LOGPIXELSY    = 90;    { Logical pixelsinch in Y                  }

  SIZEPALETTE   = 104;   { Number of entries in physical palette     }
  NUMRESERVED   = 106;   { Number of reserved entries in palette     }
  COLORRES      = 108;   { Actual color resolution                   }

  { Printing related DeviceCaps. These replace the appropriate Escapes }
  PHYSICALWIDTH   = 110;     { Physical Width in device units            }
  PHYSICALHEIGHT  = 111;     { Physical Height in device units           }
  PHYSICALOFFSETX = 112;     { Physical Printable Area x margin          }
  PHYSICALOFFSETY = 113;     { Physical Printable Area y margin          }
  SCALINGFACTORX  = 114;     { Scaling factor x                          }
  SCALINGFACTORY  = 115;     { Scaling factor y                          }


  { Display driver specific}
  VREFRESH       = 116;     { Current vertical refresh rate of the     }
                            { display device (for displays only) in Hz}
  DESKTOPVERTRES = 117;     { Horizontal width of entire desktop in    }
                            { pixels                                  }
  DESKTOPHORZRES = 118;     { Vertical height of entire desktop in     }
                            { pixels                                  }
  BLTALIGNMENT   = 119;     { Preferred blt alignment                  }


{ Device Capability Masks: }

{ Device Technologies }

  DT_PLOTTER    = 0;     { Vector plotter                    }
  DT_RASDISPLAY = 1;     { Raster display                    }
  DT_RASPRINTER = 2;     { Raster printer                    }
  DT_RASCAMERA  = 3;     { Raster camera                     }
  DT_CHARSTREAM = 4;     { Character-stream, PLP             }
  DT_METAFILE   = 5;     { Metafile, VDM                     }
  DT_DISPFILE   = 6;     { Display-file                      }

{ Curve Capabilities }

  CC_NONE       = 0;     { Curves not supported              }
  CC_CIRCLES    = 1;     { Can do circles                    }
  CC_PIE        = 2;     { Can do pie wedges                 }
  CC_CHORD      = 4;     { Can do chord arcs                 }
  CC_ELLIPSES   = 8;     { Can do ellipese                   }
  CC_WIDE       = $10;   { Can do wide lines                 }
  CC_STYLED     = $20;   { Can do styled lines               }
  CC_WIDESTYLED = $40;   { Can do wide styled lines          }
  CC_INTERIORS  = $80;   { Can do interiors                  }
  CC_ROUNDRECT  = $100;

{ Line Capabilities }

  LC_NONE       = 0;     { Lines not supported               }
  LC_POLYLINE   = 2;     { Can do polylines                  }
  LC_MARKER     = 4;     { Can do markers                    }
  LC_POLYMARKER = 8;     { Can do polymarkers                }
  LC_WIDE       = $10;   { Can do wide lines                 }
  LC_STYLED     = $20;   { Can do styled lines               }
  LC_WIDESTYLED = $40;   { Can do wide styled lines          }
  LC_INTERIORS  = $80;   { Can do interiors                  }

{ Polygonal Capabilities }

  PC_NONE        = 0;     { Polygonals not supported          }
  PC_POLYGON     = 1;     { Can do polygons                   }
  PC_RECTANGLE   = 2;     { Can do rectangles                 }
  PC_WINDPOLYGON = 4;     { Can do winding polygons           }
  PC_TRAPEZOID   = 4;     { Can do trapezoids                 }
  PC_SCANLINE    = 8;     { Can do scanlines                  }
  PC_WIDE        = $10;   { Can do wide borders               }
  PC_STYLED      = $20;   { Can do styled borders             }
  PC_WIDESTYLED  = $40;   { Can do wide styled borders        }
  PC_INTERIORS   = $80;   { Can do interiors                  }
  PC_POLYPOLYGON = $100;  { Can do polypolygons               }
  PC_PATHS       = $200;  { Can do paths                      }

{ Clipping Capabilities }

  CP_NONE      = 0;     { No clipping of output             }
  CP_RECTANGLE = 1;     { Output clipped to rects           }
  CP_REGION    = 2;     { obsolete                          }

{ Text Capabilities }

  TC_OP_CHARACTER = 1;      { Can do OutputPrecision   CHARACTER       }
  TC_OP_STROKE    = 2;      { Can do OutputPrecision   STROKE          }
  TC_CP_STROKE    = 4;      { Can do ClipPrecision     STROKE          }
  TC_CR_90        = 8;      { Can do CharRotAbility    90              }
  TC_CR_ANY       = $10;    { Can do CharRotAbility    ANY             }
  TC_SF_X_YINDEP  = $20;    { Can do ScaleFreedom      X_YINDEPENDENT  }
  TC_SA_DOUBLE    = $40;    { Can do ScaleAbility      DOUBLE          }
  TC_SA_INTEGER   = $80;    { Can do ScaleAbility      INTEGER         }
  TC_SA_CONTIN    = $100;   { Can do ScaleAbility      CONTINUOUS      }
  TC_EA_DOUBLE    = $200;   { Can do EmboldenAbility   DOUBLE          }
  TC_IA_ABLE      = $400;   { Can do ItalisizeAbility  ABLE            }
  TC_UA_ABLE      = $800;   { Can do UnderlineAbility  ABLE            }
  TC_SO_ABLE      = $1000;  { Can do StrikeOutAbility  ABLE            }
  TC_RA_ABLE      = $2000;  { Can do RasterFontAble    ABLE            }
  TC_VA_ABLE      = $4000;  { Can do VectorFontAble    ABLE            }
  TC_RESERVED     = $8000;
  TC_SCROLLBLT    = $10000; { Don't do text scroll with blt            }

{ Raster Capabilities }

  RC_BITBLT       = 1;     { Can do standard BLT.              }
  RC_BANDING      = 2;     { Device requires banding support   }
  RC_SCALING      = 4;     { Device requires scaling support   }
  RC_BITMAP64     = 8;     { Device can support >64K bitmap    }
  RC_GDI20_OUTPUT = $10;   { has 2.0 output calls          }
  RC_GDI20_STATE  = $20;
  RC_SAVEBITMAP   = $40;
  RC_DI_BITMAP    = $80;   { supports DIB to memory        }
  RC_PALETTE      = $100;  { supports a palette            }
  RC_DIBTODEV     = $200;  { supports DIBitsToDevice       }
  RC_BIGFONT      = $400;  { supports >64K fonts           }
  RC_STRETCHBLT   = $800;  { supports StretchBlt           }
  RC_FLOODFILL    = $1000; { supports FloodFill            }
  RC_STRETCHDIB   = $2000; { supports StretchDIBits        }
  RC_OP_DX_OUTPUT = $4000;
  RC_DEVBITS      = $8000;

{ Shading and blending caps }
  SB_NONE = 0;
  SB_CONST_ALPHA = 1;
  SB_PIXEL_ALPHA = 2;
  SB_PREMULT_ALPHA = 4;
  SB_GRAD_RECT = $10;
  SB_GRAD_TRI = $20;

{ DIB color table identifiers }

  DIB_RGB_COLORS = 0;     { color table in RGBs  }
  DIB_PAL_COLORS = 1;     { color table in palette indices  }

{ constants for GetSetSystemPaletteUse() }

  SYSPAL_ERROR = 0;
  SYSPAL_STATIC = 1;
  SYSPAL_NOSTATIC = 2;

{ constants for CreateDIBitmap }

  CBM_INIT = 4;     { initialize bitmap  }

{ ExtFloodFill style flags }

  FLOODFILLBORDER = 0;
  FLOODFILLSURFACE = 1;

  CCHDEVICENAME = 32;     { size of a device name string  }
  CCHFORMNAME   = 32;     { size of a form name string  }

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  _devicemode = packed record
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=CCHDEVICENAME)]
    dmDeviceName: string;
    dmSpecVersion: Word;
    dmDriverVersion: Word;
    dmSize: Word;
    dmDriverExtra: Word;
    dmFields: DWORD;
    dmOrientation: SHORT;
    dmPaperSize: SHORT;
    dmPaperLength: SHORT;
    dmPaperWidth: SHORT;
    dmScale: SHORT;
    dmCopies: SHORT;
    dmDefaultSource: SHORT;
    dmPrintQuality: SHORT;
    dmColor: SHORT;
    dmDuplex: SHORT;
    dmYResolution: SHORT;
    dmTTOption: SHORT;
    dmCollate: SHORT;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=CCHFORMNAME)]
    dmFormName: string;
    dmLogPixels: Word;
    dmBitsPerPel: DWORD;
    dmPelsWidth: DWORD;
    dmPelsHeight: DWORD;
    dmDisplayFlags: DWORD;
    dmDisplayFrequency: DWORD;
    dmICMMethod: DWORD;
    dmICMIntent: DWORD;
    dmMediaType: DWORD;
    dmDitherType: DWORD;
    dmICCManufacturer: DWORD;
    dmICCModel: DWORD;
    dmPanningWidth: DWORD;
    dmPanningHeight: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  _devicemodeA = packed record
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=CCHDEVICENAME)]
    dmDeviceName: string;
    dmSpecVersion: Word;
    dmDriverVersion: Word;
    dmSize: Word;
    dmDriverExtra: Word;
    dmFields: DWORD;
    dmOrientation: SHORT;
    dmPaperSize: SHORT;
    dmPaperLength: SHORT;
    dmPaperWidth: SHORT;
    dmScale: SHORT;
    dmCopies: SHORT;
    dmDefaultSource: SHORT;
    dmPrintQuality: SHORT;
    dmColor: SHORT;
    dmDuplex: SHORT;
    dmYResolution: SHORT;
    dmTTOption: SHORT;
    dmCollate: SHORT;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=CCHFORMNAME)]
    dmFormName: string;
    dmLogPixels: Word;
    dmBitsPerPel: DWORD;
    dmPelsWidth: DWORD;
    dmPelsHeight: DWORD;
    dmDisplayFlags: DWORD;
    dmDisplayFrequency: DWORD;
    dmICMMethod: DWORD;
    dmICMIntent: DWORD;
    dmMediaType: DWORD;
    dmDitherType: DWORD;
    dmICCManufacturer: DWORD;
    dmICCModel: DWORD;
    dmPanningWidth: DWORD;
    dmPanningHeight: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  _devicemodeW = packed record
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=CCHDEVICENAME)]
    dmDeviceName: string;
    dmSpecVersion: Word;
    dmDriverVersion: Word;
    dmSize: Word;
    dmDriverExtra: Word;
    dmFields: DWORD;
    dmOrientation: SHORT;
    dmPaperSize: SHORT;
    dmPaperLength: SHORT;
    dmPaperWidth: SHORT;
    dmScale: SHORT;
    dmCopies: SHORT;
    dmDefaultSource: SHORT;
    dmPrintQuality: SHORT;
    dmColor: SHORT;
    dmDuplex: SHORT;
    dmYResolution: SHORT;
    dmTTOption: SHORT;
    dmCollate: SHORT;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=CCHFORMNAME)]
    dmFormName: string;
    dmLogPixels: Word;
    dmBitsPerPel: DWORD;
    dmPelsWidth: DWORD;
    dmPelsHeight: DWORD;
    dmDisplayFlags: DWORD;
    dmDisplayFrequency: DWORD;
    dmICMMethod: DWORD;
    dmICMIntent: DWORD;
    dmMediaType: DWORD;
    dmDitherType: DWORD;
    dmICCManufacturer: DWORD;
    dmICCModel: DWORD;
    dmPanningWidth: DWORD;
    dmPanningHeight: DWORD;
  end;
  TDeviceMode = _devicemode;
  TDeviceModeA = _devicemodeA;
  TDeviceModeW = _devicemodeW;
  DEVMODE = _devicemode;
  DEVMODEA = _devicemodeA;
  DEVMODEW = _devicemodeW;

  TDevMode = TDeviceMode;  {compatibility with Delphi 1.0}

const
  DM_SPECVERSION = $401;  { current version of specification }

{ field selection bits }

  DM_ORIENTATION = 1;
  DM_PAPERSIZE = 2;
  DM_PAPERLENGTH = 4;
  DM_PAPERWIDTH = 8;
  DM_SCALE = $10;
  DM_POSITION = $20;
  DM_COPIES = $100;
  DM_DEFAULTSOURCE = $200;
  DM_PRINTQUALITY = $400;
  DM_COLOR = $800;
  DM_DUPLEX = $1000;
  DM_YRESOLUTION = $2000;
  DM_TTOPTION = $4000;
  DM_COLLATE = $8000;
  DM_FORMNAME = $10000;
  DM_LOGPIXELS = $20000;
  DM_BITSPERPEL = $40000;
  DM_PELSWIDTH = $80000;
  DM_PELSHEIGHT = $100000;
  DM_DISPLAYFLAGS = $200000;
  DM_DISPLAYFREQUENCY = $400000;
  DM_PANNINGWIDTH = $00800000;
  DM_PANNINGHEIGHT = $01000000;
  DM_ICMMETHOD = $2000000;
  DM_ICMINTENT = $4000000;
  DM_MEDIATYPE = $8000000;
  DM_DITHERTYPE = $10000000;
  DM_ICCMANUFACTURER = $20000000;
  DM_ICCMODEL = $40000000;

{ orientation selections }

  DMORIENT_PORTRAIT = 1;
  DMORIENT_LANDSCAPE = 2;

{ paper selections }

  DMPAPER_LETTER      = 1;  { Letter 8 12 x 11 in               }
  DMPAPER_FIRST       = DMPAPER_LETTER;
  DMPAPER_LETTERSMALL = 2;  { Letter Small 8 12 x 11 in         }
  DMPAPER_TABLOID     = 3;  { Tabloid 11 x 17 in                }
  DMPAPER_LEDGER      = 4;  { Ledger 17 x 11 in                 }
  DMPAPER_LEGAL       = 5;  { Legal 8 12 x 14 in                }
  DMPAPER_STATEMENT   = 6;  { Statement 5 12 x 8 12 in          }
  DMPAPER_EXECUTIVE   = 7;  { Executive 7 14 x 10 12 in         }
  DMPAPER_A3      = 8;      { A3 297 x 420 mm                     }
  DMPAPER_A4      = 9;      { A4 210 x 297 mm                     }
  DMPAPER_A4SMALL = 10;     { A4 Small 210 x 297 mm               }
  DMPAPER_A5      = 11;     { A5 148 x 210 mm                     }
  DMPAPER_B4      = 12;     { B4 (JIS) 250 x 354                  }
  DMPAPER_B5      = 13;     { B5 (JIS) 182 x 257 mm               }
  DMPAPER_FOLIO   = 14;     { Folio 8 12 x 13 in                  }
  DMPAPER_QUARTO  = 15;     { Quarto 215 x 275 mm                 }
  DMPAPER_10X14   = 16;     { 10x14 in                            }
  DMPAPER_11X17   = 17;     { 11x17 in                            }
  DMPAPER_NOTE    = 18;     { Note 8 12 x 11 in                   }
  DMPAPER_ENV_9   = 19;     { Envelope #9 3 78 x 8 78             }
  DMPAPER_ENV_10  = 20;     { Envelope #10 4 18 x 9 12            }
  DMPAPER_ENV_11  = 21;     { Envelope #11 4 12 x 10 38           }
  DMPAPER_ENV_12  = 22;     { Envelope #12 4 \276 x 11            }
  DMPAPER_ENV_14  = 23;     { Envelope #14 5 x 11 12              }
  DMPAPER_CSHEET  = 24;     { C size sheet                        }
  DMPAPER_DSHEET  = 25;     { D size sheet                        }
  DMPAPER_ESHEET  = 26;     { E size sheet                        }
  DMPAPER_ENV_DL  = 27;     { Envelope DL 110 x 220mm             }
  DMPAPER_ENV_C5  = 28;     { Envelope C5 162 x 229 mm            }
  DMPAPER_ENV_C3  = 29;     { Envelope C3  324 x 458 mm           }
  DMPAPER_ENV_C4  = 30;     { Envelope C4  229 x 324 mm           }
  DMPAPER_ENV_C6  = 31;     { Envelope C6  114 x 162 mm           }
  DMPAPER_ENV_C65  = 32;    { Envelope C65 114 x 229 mm           }
  DMPAPER_ENV_B4   = 33;    { Envelope B4  250 x 353 mm           }
  DMPAPER_ENV_B5   = 34;    { Envelope B5  176 x 250 mm           }
  DMPAPER_ENV_B6   = 35;    { Envelope B6  176 x 125 mm           }
  DMPAPER_ENV_ITALY          = 36;  { Envelope 110 x 230 mm               }
  DMPAPER_ENV_MONARCH        = 37;  { Envelope Monarch 3.875 x 7.5 in     }
  DMPAPER_ENV_PERSONAL       = 38;  { 6 34 Envelope 3 58 x 6 12 in        }
  DMPAPER_FANFOLD_US         = 39;  { US Std Fanfold 14 78 x 11 in        }
  DMPAPER_FANFOLD_STD_GERMAN = 40;  { German Std Fanfold 8 12 x 12 in    }
  DMPAPER_FANFOLD_LGL_GERMAN = 41;  { German Legal Fanfold 8 12 x 13 in  }
  DMPAPER_ISO_B4             = 42;  { B4 (ISO) 250 x 353 mm               }
  DMPAPER_JAPANESE_POSTCARD  = 43;  { Japanese Postcard 100 x 148 mm      }
  DMPAPER_9X11               = 44;  { 9 x 11 in                           }
  DMPAPER_10X11              = 45;  { 10 x 11 in                          }
  DMPAPER_15X11              = 46;  { 15 x 11 in                          }
  DMPAPER_ENV_INVITE         = 47;  { Envelope Invite 220 x 220 mm        }
  DMPAPER_RESERVED_48        = 48;  { RESERVED--DO NOT USE                }
  DMPAPER_RESERVED_49        = 49;  { RESERVED--DO NOT USE                }
  DMPAPER_LETTER_EXTRA       = 50;  { Letter Extra 9 \275 x 12 in         }
  DMPAPER_LEGAL_EXTRA        = 51;  { Legal Extra 9 \275 x 15 in          }
  DMPAPER_TABLOID_EXTRA      = 52;  { Tabloid Extra 11.69 x 18 in         }
  DMPAPER_A4_EXTRA           = 53;  { A4 Extra 9.27 x 12.69 in            }
  DMPAPER_LETTER_TRANSVERSE  = 54;  { Letter Transverse 8 \275 x 11 in    }
  DMPAPER_A4_TRANSVERSE      = 55;  { A4 Transverse 210 x 297 mm          }
  DMPAPER_LETTER_EXTRA_TRANSVERSE = 56;     { Letter Extra Transverse 9\275 x 12 in  }
  DMPAPER_A_PLUS        = 57;     { SuperASuperAA4 227 x 356 mm       }
  DMPAPER_B_PLUS        = 58;     { SuperBSuperBA3 305 x 487 mm       }
  DMPAPER_LETTER_PLUS   = 59;     { Letter Plus 8.5 x 12.69 in          }
  DMPAPER_A4_PLUS       = 60;     { A4 Plus 210 x 330 mm                }
  DMPAPER_A5_TRANSVERSE = 61;     { A5 Transverse 148 x 210 mm          }
  DMPAPER_B5_TRANSVERSE = 62;     { B5 (JIS) Transverse 182 x 257 mm    }
  DMPAPER_A3_EXTRA      = 63;     { A3 Extra 322 x 445 mm               }
  DMPAPER_A5_EXTRA      = $40;    { A5 Extra 174 x 235 mm               }
  DMPAPER_B5_EXTRA      = 65;     { B5 (ISO) Extra 201 x 276 mm         }
  DMPAPER_A2            = 66;     { A2 420 x 594 mm                     }
  DMPAPER_A3_TRANSVERSE = 67;     { A3 Transverse 297 x 420 mm          }
  DMPAPER_A3_EXTRA_TRANSVERSE = 68;     { A3 Extra Transverse 322 x 445 mm    }
{
 ** the following sizes are reserved for the Far East version of Win95.
 ** Rotated papers rotate the physical page but not the logical page.
}
  DMPAPER_DBL_JAPANESE_POSTCARD = 69; { Japanese Double Postcard 200 x 148 mm }

  DMPAPER_A6                  = 70;  { A6 105 x 148 mm                 }

  DMPAPER_JENV_KAKU2          = 71;  { Japanese Envelope Kaku #2       }
  DMPAPER_JENV_KAKU3          = 72;  { Japanese Envelope Kaku #3       }
  DMPAPER_JENV_CHOU3          = 73;  { Japanese Envelope Chou #3       }
  DMPAPER_JENV_CHOU4          = 74;  { Japanese Envelope Chou #4       }
  DMPAPER_LETTER_ROTATED      = 75;  { Letter Rotated 11 x 8 1/2 11 in }
  DMPAPER_A3_ROTATED          = 76;  { A3 Rotated 420 x 297 mm         }
  DMPAPER_A4_ROTATED          = 77;  { A4 Rotated 297 x 210 mm         }
  DMPAPER_A5_ROTATED          = 78;  { A5 Rotated 210 x 148 mm         }
  DMPAPER_B4_JIS_ROTATED      = 79;  { B4 (JIS) Rotated 364 x 257 mm   }
  DMPAPER_B5_JIS_ROTATED      = 80;  { B5 (JIS) Rotated 257 x 182 mm   }
  DMPAPER_JAPANESE_POSTCARD_ROTATED = 81; { Japanese Postcard Rotated 148 x 100 mm }
  DMPAPER_DBL_JAPANESE_POSTCARD_ROTATED = 82; { Double Japanese Postcard Rotated 148 x 200 mm }
  DMPAPER_A6_ROTATED          = 83;  { A6 Rotated 148 x 105 mm         }
  DMPAPER_JENV_KAKU2_ROTATED  = 84;  { Japanese Envelope Kaku #2 Rotated}
  DMPAPER_JENV_KAKU3_ROTATED  = 85;  { Japanese Envelope Kaku #3 Rotated}
  DMPAPER_JENV_CHOU3_ROTATED  = 86;  { Japanese Envelope Chou #3 Rotated}
  DMPAPER_JENV_CHOU4_ROTATED  = 87;  { Japanese Envelope Chou #4 Rotated}
  DMPAPER_B6_JIS              = 88;  { B6 (JIS) 128 x 182 mm           }
  DMPAPER_B6_JIS_ROTATED      = 89;  { B6 (JIS) Rotated 182 x 128 mm   }
  DMPAPER_12X11               = 90;  { 12 x 11 in                      }
  DMPAPER_JENV_YOU4           = 91;  { Japanese Envelope You #4        }
  DMPAPER_JENV_YOU4_ROTATED   = 92;  { Japanese Envelope You #4 Rotated}
  DMPAPER_P16K                = 93;  { PRC 16K 146 x 215 mm            }
  DMPAPER_P32K                = 94;  { PRC 32K 97 x 151 mm             }
  DMPAPER_P32KBIG             = 95;  { PRC 32K(Big) 97 x 151 mm        }
  DMPAPER_PENV_1              = 96;  { PRC Envelope #1 102 x 165 mm    }
  DMPAPER_PENV_2              = 97;  { PRC Envelope #2 102 x 176 mm    }
  DMPAPER_PENV_3              = 98;  { PRC Envelope #3 125 x 176 mm    }
  DMPAPER_PENV_4              = 99;  { PRC Envelope #4 110 x 208 mm    }
  DMPAPER_PENV_5              = 100; { PRC Envelope #5 110 x 220 mm    }
  DMPAPER_PENV_6              = 101; { PRC Envelope #6 120 x 230 mm    }
  DMPAPER_PENV_7              = 102; { PRC Envelope #7 160 x 230 mm    }
  DMPAPER_PENV_8              = 103; { PRC Envelope #8 120 x 309 mm    }
  DMPAPER_PENV_9              = 104; { PRC Envelope #9 229 x 324 mm    }
  DMPAPER_PENV_10             = 105; { PRC Envelope #10 324 x 458 mm   }
  DMPAPER_P16K_ROTATED        = 106; { PRC 16K Rotated                 }
  DMPAPER_P32K_ROTATED        = 107; { PRC 32K Rotated                 }
  DMPAPER_P32KBIG_ROTATED     = 108; { PRC 32K(Big) Rotated            }
  DMPAPER_PENV_1_ROTATED      = 109; { PRC Envelope #1 Rotated 165 x 102 mm}
  DMPAPER_PENV_2_ROTATED      = 110; { PRC Envelope #2 Rotated 176 x 102 mm}
  DMPAPER_PENV_3_ROTATED      = 111; { PRC Envelope #3 Rotated 176 x 125 mm}
  DMPAPER_PENV_4_ROTATED      = 112; { PRC Envelope #4 Rotated 208 x 110 mm}
  DMPAPER_PENV_5_ROTATED      = 113; { PRC Envelope #5 Rotated 220 x 110 mm}
  DMPAPER_PENV_6_ROTATED      = 114; { PRC Envelope #6 Rotated 230 x 120 mm}
  DMPAPER_PENV_7_ROTATED      = 115; { PRC Envelope #7 Rotated 230 x 160 mm}
  DMPAPER_PENV_8_ROTATED      = 116; { PRC Envelope #8 Rotated 309 x 120 mm}
  DMPAPER_PENV_9_ROTATED      = 117; { PRC Envelope #9 Rotated 324 x 229 mm}
  DMPAPER_PENV_10_ROTATED     = 118; { PRC Envelope #10 Rotated 458 x 324 mm }
  DMPAPER_LAST                = DMPAPER_PENV_10_ROTATED;
  DMPAPER_USER                = $100;

{ bin selections }

  DMBIN_UPPER = 1;
  DMBIN_FIRST = DMBIN_UPPER;
  DMBIN_ONLYONE = 1;
  DMBIN_LOWER = 2;
  DMBIN_MIDDLE = 3;
  DMBIN_MANUAL = 4;
  DMBIN_ENVELOPE = 5;
  DMBIN_ENVMANUAL = 6;
  DMBIN_AUTO = 7;
  DMBIN_TRACTOR = 8;
  DMBIN_SMALLFMT = 9;
  DMBIN_LARGEFMT = 10;
  DMBIN_LARGECAPACITY = 11;
  DMBIN_CASSETTE = 14;
  DMBIN_FORMSOURCE = 15;
  DMBIN_LAST = DMBIN_FORMSOURCE;
  DMBIN_USER = $100;   { device specific bins start here }

  { print qualities }
  DMRES_DRAFT = LongWord(-1);
  DMRES_LOW = LongWord(-2);
  DMRES_MEDIUM = LongWord(-3);
  DMRES_HIGH = LongWord(-4);

  { color enabledisable for color printers }
  DMCOLOR_MONOCHROME = 1;
  DMCOLOR_COLOR = 2;

  { duplex enable }
  DMDUP_SIMPLEX = 1;
  DMDUP_VERTICAL = 2;
  DMDUP_HORIZONTAL = 3;

  { TrueType options }
  DMTT_BITMAP           = 1;     { print TT fonts as graphics  }
  DMTT_DOWNLOAD         = 2;     { download TT fonts as soft fonts  }
  DMTT_SUBDEV           = 3;     { substitute device fonts for TT fonts  }
  DMTT_DOWNLOAD_OUTLINE = 4;     { download TT fonts as outline soft fonts  }

  { Collation selections }
  DMCOLLATE_FALSE = 0;
  DMCOLLATE_TRUE = 1;

  { DEVMODE dmDisplayFlags flags }
  DM_GRAYSCALE = $00000001;  { removed in 4.0 SDK }
  DM_INTERLACED = $00000002; { removed in 4.0 SDK }
  DM_TEXTMODE = $00000004;   { removed in 4.0 SDK }
  DMDISPLAYFLAGS_TEXTMODE     = $00000004;

  { ICM methods }
  DMICMMETHOD_NONE   = 1;     { ICM disabled  }
  DMICMMETHOD_SYSTEM = 2;     { ICM handled by system  }
  DMICMMETHOD_DRIVER = 3;     { ICM handled by driver  }
  DMICMMETHOD_DEVICE = 4;     { ICM handled by device  }

  DMICMMETHOD_USER = $100;    { Device-specific methods start here  }

  { ICM Intents }
  DMICM_SATURATE    = 1;     { Maximize color saturation  }
  DMICM_CONTRAST    = 2;     { Maximize color contrast  }
  DMICM_COLORMETRIC = 3;     { Use specific color metric  }

  DMICM_USER = $100;     { Device-specific intents start here  }


  { Media types }
  DMMEDIA_STANDARD     = 1;     { Standard paper  }
  DMMEDIA_TRANSPARENCY = 2;     { Transparency  }
  DMMEDIA_GLOSSY       = 3;     { Glossy paper  }

  DMMEDIA_USER = $100;     { Device-specific media start here  }


  { Dither types }
  DMDITHER_NONE      = 1;     { No dithering  }
  DMDITHER_COARSE    = 2;     { Dither with a coarse brush  }
  DMDITHER_FINE      = 3;     { Dither with a fine brush  }
  DMDITHER_LINEART   = 4;     { LineArt dithering  }
  DMDITHER_ERRORDIFFUSION = 5; { LineArt dithering }
  DMDITHER_RESERVED6 = 6;      { LineArt dithering }
  DMDITHER_RESERVED7 = 7;      { LineArt dithering }
  DMDITHER_RESERVED8 = 8;      { LineArt dithering }
  DMDITHER_RESERVED9 = 9;      { LineArt dithering }
  DMDITHER_GRAYSCALE = 10;     { Device does grayscaling  }

  DMDITHER_USER = 256;        { Device-specific dithers start here  }

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  _DISPLAY_DEVICE = packed record
    cb: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=32)]
    DeviceName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=128)]
    DeviceString: string;
    StateFlags: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  _DISPLAY_DEVICEA = packed record
    cb: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=32)]
    DeviceName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=128)]
    DeviceString: string;
    StateFlags: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  _DISPLAY_DEVICEW = packed record
    cb: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=32)]
    DeviceName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=128)]
    DeviceString: string;
    StateFlags: DWORD;
  end;
  TDisplayDevice = _DISPLAY_DEVICE;
  TDisplayDeviceA = _DISPLAY_DEVICEA;
  TDisplayDeviceW = _DISPLAY_DEVICEW;

const
  DISPLAY_DEVICE_ATTACHED_TO_DESKTOP = $00000001;
  DISPLAY_DEVICE_MULTI_DRIVER = $00000002;
  DISPLAY_DEVICE_PRIMARY_DEVICE = $00000004;
  DISPLAY_DEVICE_MIRRORING_DRIVER = $00000008;
  DISPLAY_DEVICE_VGA_COMPATIBLE = $00000010;

{ GetRegionData / ExtCreateRegion }

  RDH_RECTANGLES = 1;

type
  _RGNDATAHEADER = packed record
    dwSize: DWORD;
    iType: DWORD;
    nCount: DWORD;
    nRgnSize: DWORD;
    rcBound: TRect;
  end;
  TRgnDataHeader = _RGNDATAHEADER;
  RGNDATAHEADER = _RGNDATAHEADER;

  [StructLayout(LayoutKind.Sequential)]
  _RGNDATA = record
    rdh: TRgnDataHeader;
    Buffer: IntPtr; { array[0..0] of Char }
  end;
  TRgnData = _RGNDATA;
  RGNDATA = _RGNDATA;

  _ABC = packed record
    abcA: Integer;
    abcB: UINT;
    abcC: Integer;
  end;
  TABC = _ABC;
  ABC = _ABC;

  _ABCFLOAT = packed record
    abcfA: Single;
    abcfB: Single;
    abcfC: Single;
  end;
  TABCFloat = _ABCFLOAT;
  ABCFLOAT = _ABCFLOAT;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  _OUTLINETEXTMETRIC = record
    otmSize: UINT;
    otmTextMetrics: TTextMetric;
    otmFiller: Byte;
    otmPanoseNumber: TPanose;
    otmfsSelection: UINT;
    otmfsType: UINT;
    otmsCharSlopeRise: Integer;
    otmsCharSlopeRun: Integer;
    otmItalicAngle: Integer;
    otmEMSquare: UINT;
    otmAscent: Integer;
    otmDescent: Integer;
    otmLineGap: UINT;
    otmsCapEmHeight: UINT;
    otmsXHeight: UINT;
    otmrcFontBox: TRect;
    otmMacAscent: Integer;
    otmMacDescent: Integer;
    otmMacLineGap: UINT;
    otmusMinimumPPEM: UINT;
    otmptSubscriptSize: TPoint;
    otmptSubscriptOffset: TPoint;
    otmptSuperscriptSize: TPoint;
    otmptSuperscriptOffset: TPoint;
    otmsStrikeoutSize: UINT;
    otmsStrikeoutPosition: Integer;
    otmsUnderscoreSize: Integer;
    otmsUnderscorePosition: Integer;
    [MarshalAs(UnmanagedType.LPTStr)]
    otmpFamilyName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    otmpFaceName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    otmpStyleName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    otmpFullName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  _OUTLINETEXTMETRICA = record
    otmSize: UINT;
    otmTextMetrics: TTextMetricA;
    otmFiller: Byte;
    otmPanoseNumber: TPanose;
    otmfsSelection: UINT;
    otmfsType: UINT;
    otmsCharSlopeRise: Integer;
    otmsCharSlopeRun: Integer;
    otmItalicAngle: Integer;
    otmEMSquare: UINT;
    otmAscent: Integer;
    otmDescent: Integer;
    otmLineGap: UINT;
    otmsCapEmHeight: UINT;
    otmsXHeight: UINT;
    otmrcFontBox: TRect;
    otmMacAscent: Integer;
    otmMacDescent: Integer;
    otmMacLineGap: UINT;
    otmusMinimumPPEM: UINT;
    otmptSubscriptSize: TPoint;
    otmptSubscriptOffset: TPoint;
    otmptSuperscriptSize: TPoint;
    otmptSuperscriptOffset: TPoint;
    otmsStrikeoutSize: UINT;
    otmsStrikeoutPosition: Integer;
    otmsUnderscoreSize: Integer;
    otmsUnderscorePosition: Integer;
    [MarshalAs(UnmanagedType.LPTStr)]
    otmpFamilyName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    otmpFaceName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    otmpStyleName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    otmpFullName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  _OUTLINETEXTMETRICW = record
    otmSize: UINT;
    otmTextMetrics: TTextMetricW;
    otmFiller: Byte;
    otmPanoseNumber: TPanose;
    otmfsSelection: UINT;
    otmfsType: UINT;
    otmsCharSlopeRise: Integer;
    otmsCharSlopeRun: Integer;
    otmItalicAngle: Integer;
    otmEMSquare: UINT;
    otmAscent: Integer;
    otmDescent: Integer;
    otmLineGap: UINT;
    otmsCapEmHeight: UINT;
    otmsXHeight: UINT;
    otmrcFontBox: TRect;
    otmMacAscent: Integer;
    otmMacDescent: Integer;
    otmMacLineGap: UINT;
    otmusMinimumPPEM: UINT;
    otmptSubscriptSize: TPoint;
    otmptSubscriptOffset: TPoint;
    otmptSuperscriptSize: TPoint;
    otmptSuperscriptOffset: TPoint;
    otmsStrikeoutSize: UINT;
    otmsStrikeoutPosition: Integer;
    otmsUnderscoreSize: Integer;
    otmsUnderscorePosition: Integer;
    [MarshalAs(UnmanagedType.LPTStr)]
    otmpFamilyName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    otmpFaceName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    otmpStyleName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    otmpFullName: string;
  end;
  TOutlineTextmetric = _OUTLINETEXTMETRIC;
  TOutlineTextmetricA = _OUTLINETEXTMETRICA;
  TOutlineTextmetricW = _OUTLINETEXTMETRICW;
  OUTLINETEXTMETRIC = _OUTLINETEXTMETRIC;
  OUTLINETEXTMETRICA = _OUTLINETEXTMETRICA;
  OUTLINETEXTMETRICW = _OUTLINETEXTMETRICW;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagPOLYTEXT = packed record
    x: Integer;
    y: Integer;
    n: UINT;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstr: string;
    uiFlags: UINT;
    rcl: TRect;
    pdx: IntPtr; { PINT }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagPOLYTEXTA = packed record
    x: Integer;
    y: Integer;
    n: UINT;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstr: string;
    uiFlags: UINT;
    rcl: TRect;
    pdx: IntPtr; { PINT }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagPOLYTEXTW = packed record
    x: Integer;
    y: Integer;
    n: UINT;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstr: string;
    uiFlags: UINT;
    rcl: TRect;
    pdx: IntPtr; { PINT }
  end;
  TPolyText = tagPOLYTEXT;
  TPolyTextA = tagPOLYTEXTA;
  TPolyTextW = tagPOLYTEXTW;
  POLYTEXT = tagPOLYTEXT;
  POLYTEXTA = tagPOLYTEXTA;
  POLYTEXTW = tagPOLYTEXTW;

  _FIXED = packed record
    fract: Word;
    value: SHORT;
  end;
  TFixed = _FIXED;
  FIXED = _FIXED;

  _MAT2 = packed record
    eM11: TFixed;
    eM12: TFixed;
    eM21: TFixed;
    eM22: TFixed;
  end;
  TMat2 = _MAT2;
  MAT2 = _MAT2;

  _GLYPHMETRICS = packed record
    gmBlackBoxX: UINT;
    gmBlackBoxY: UINT;
    gmptGlyphOrigin: TPoint;
    gmCellIncX: SHORT;
    gmCellIncY: SHORT;
  end;
  TGlyphMetrics = _GLYPHMETRICS;
  GLYPHMETRICS = _GLYPHMETRICS;

const
  { GetGlyphOutline constants }
  GGO_METRICS = 0;
  GGO_BITMAP = 1;
  GGO_NATIVE = 2;

  GGO_GRAY2_BITMAP = 4;
  GGO_GRAY4_BITMAP = 5;
  GGO_GRAY8_BITMAP = 6;
  GGO_GLYPH_INDEX = $80;

  TT_POLYGON_TYPE = 24;
  TT_PRIM_LINE = 1;
  TT_PRIM_QSPLINE = 2;

type
  tagPOINTFX = packed record
    x: TFixed;
    y: TFixed;
  end;
  TPointfx = tagPOINTFX;
  POINTFX = tagPOINTFX;

  tagTTPOLYCURVE = packed record
    wType: Word;
    cpfx: Word;
    apfx: array[0..0] of TPointFX;
  end;
  TTTPolyCurve = tagTTPOLYCURVE;
  TTPOLYCURVE = tagTTPOLYCURVE;

  tagTTPOLYGONHEADER = packed record
    cb: DWORD;
    dwType: DWORD;
    pfxStart: TPointFX;
  end;
  TTTPolygonHeader = tagTTPOLYGONHEADER;
  TTPOLYGONHEADER = tagTTPOLYGONHEADER;

const
  GCP_DBCS = 1;
  GCP_REORDER = 2;
  GCP_USEKERNING = 8;
  GCP_GLYPHSHAPE = $10;
  GCP_LIGATE = 32;
  GCP_GLYPHINDEXING = $0080; // commented out in Windows Headers

  GCP_DIACRITIC = $100;
  GCP_KASHIDA = $400;
  GCP_ERROR = $8000;
  FLI_MASK = 4155;

  GCP_JUSTIFY = $10000;
  GCP_NODIACRITICS = $00020000; // commented out in Windows Headers

  FLI_GLYPHS = $40000;
  GCP_CLASSIN = $80000;
  GCP_MAXEXTENT = $100000;
  GCP_JUSTIFYIN = $200000;
  GCP_DISPLAYZWG = $400000;
  GCP_SYMSWAPOFF = $800000;
  GCP_NUMERICOVERRIDE = $1000000;
  GCP_NEUTRALOVERRIDE = $2000000;
  GCP_NUMERICSLATIN = $4000000;
  GCP_NUMERICSLOCAL = $8000000;

  GCPCLASS_LATIN = 1;
  GCPCLASS_HEBREW = 2;
  GCPCLASS_ARABIC = 2;
  GCPCLASS_NEUTRAL = 3;
  GCPCLASS_LOCALNUMBER = 4;
  GCPCLASS_LATINNUMBER = 5;
  GCPCLASS_LATINNUMERICTERMINATOR = 6;
  GCPCLASS_LATINNUMERICSEPARATOR = 7;
  GCPCLASS_NUMERICSEPARATOR = 8;
  GCPCLASS_PREBOUNDRTL = $80;
  GCPCLASS_PREBOUNDLTR = $40;
  GCPCLASS_POSTBOUNDLTR        = $20;
  GCPCLASS_POSTBOUNDRTL        = $10;

  GCPGLYPH_LINKBEFORE          = $8000;
  GCPGLYPH_LINKAFTER           = $4000;


type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagGCP_RESULTS = packed record
    lStructSize: DWORD;
    lpOutString: IntPtr;
    lpOrder: IntPtr;
    lpDx: IntPtr;
    lpCaretPos: IntPtr;
    lpClass: IntPtr;
    lpGlyphs: IntPtr;
    nGlyphs: UINT;
    nMaxFit: Integer;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagGCP_RESULTSA = packed record
    lStructSize: DWORD;
    lpOutString: IntPtr;
    lpOrder: IntPtr;
    lpDx: IntPtr;
    lpCaretPos: IntPtr;
    lpClass: IntPtr;
    lpGlyphs: IntPtr;
    nGlyphs: UINT;
    nMaxFit: Integer;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagGCP_RESULTSW = packed record
    lStructSize: DWORD;
    lpOutString: IntPtr;
    lpOrder: IntPtr;
    lpDx: IntPtr;
    lpCaretPos: IntPtr;
    lpClass: IntPtr;
    lpGlyphs: IntPtr;
    nGlyphs: UINT;
    nMaxFit: Integer;
  end;
  TGCPResults = tagGCP_RESULTS;
  TGCPResultsA = tagGCP_RESULTSA;
  TGCPResultsW = tagGCP_RESULTSW;
  GCP_RESULTS = tagGCP_RESULTS;
  GCP_RESULTSA = tagGCP_RESULTSA;
  GCP_RESULTSW = tagGCP_RESULTSW;

  _RASTERIZER_STATUS = packed record
    nSize: SHORT;
    wFlags: SHORT;
    nLanguageID: SHORT;
  end;
  TRasterizerStatus = _RASTERIZER_STATUS;
  RASTERIZER_STATUS = _RASTERIZER_STATUS;

const
  { bits defined in wFlags of RASTERIZER_STATUS }
  TT_AVAILABLE = 1;
  TT_ENABLED = 2;

type
  { Pixel format descriptor }
  tagPIXELFORMATDESCRIPTOR = packed record
    nSize: Word;
    nVersion: Word;
    dwFlags: DWORD;
    iPixelType: Byte;
    cColorBits: Byte;
    cRedBits: Byte;
    cRedShift: Byte;
    cGreenBits: Byte;
    cGreenShift: Byte;
    cBlueBits: Byte;
    cBlueShift: Byte;
    cAlphaBits: Byte;
    cAlphaShift: Byte;
    cAccumBits: Byte;
    cAccumRedBits: Byte;
    cAccumGreenBits: Byte;
    cAccumBlueBits: Byte;
    cAccumAlphaBits: Byte;
    cDepthBits: Byte;
    cStencilBits: Byte;
    cAuxBuffers: Byte;
    iLayerType: Byte;
    bReserved: Byte;
    dwLayerMask: DWORD;
    dwVisibleMask: DWORD;
    dwDamageMask: DWORD;
  end;
  TPixelFormatDescriptor = tagPIXELFORMATDESCRIPTOR;
  PIXELFORMATDESCRIPTOR = tagPIXELFORMATDESCRIPTOR;

const
  { pixel types }
  PFD_TYPE_RGBA = 0;
  PFD_TYPE_COLORINDEX = 1;

  { layer types }
  PFD_MAIN_PLANE = 0;
  PFD_OVERLAY_PLANE = 1;
  PFD_UNDERLAY_PLANE = LongWord(-1);

  { TPixelFormatDescriptor flags }
  PFD_DOUBLEBUFFER                = $00000001;
  PFD_STEREO                      = $00000002;
  PFD_DRAW_TO_WINDOW              = $00000004;
  PFD_DRAW_TO_BITMAP              = $00000008;
  PFD_SUPPORT_GDI                 = $00000010;
  PFD_SUPPORT_OPENGL              = $00000020;
  PFD_GENERIC_FORMAT              = $00000040;
  PFD_NEED_PALETTE                = $00000080;
  PFD_NEED_SYSTEM_PALETTE         = $00000100;
  PFD_SWAP_EXCHANGE               = $00000200;
  PFD_SWAP_COPY                   = $00000400;
  PFD_SWAP_LAYER_BUFFERS          = $00000800;
  PFD_GENERIC_ACCELERATED         = $00001000;

  { TPixelFormatDescriptor flags for use in ChoosePixelFormat only }
  PFD_DEPTH_DONTCARE              = $20000000;
  PFD_DOUBLEBUFFER_DONTCARE       = $40000000;
  PFD_STEREO_DONTCARE             = DWORD($80000000);

type
  TFNOldFontEnumProc = function ([in] var logfont: TLogFont;
    [in] var textmetric: TTextMetric; dword: DWORD; lparam: LPARAM): Integer;
  TFNOldFontEnumProcA = function ([in] var logfont: TLogFontA;
    [in] var textmetric: TTextMetricA; dword: DWORD; lparam: LPARAM): Integer;
  TFNOldFontEnumProcW = function ([in] var logfont: TLogFontW;
    [in] var textmetric: TTextMetricW; dword: DWORD; lparam: LPARAM): Integer;
  TFNGObjEnumProc = function (lpvoid: IntPtr; lparam: LPARAM): Integer;
  TFNLineDDAProc = procedure (p1, p2: Integer; lparam: LPARAM);
  TFNFontEnumProc = TFNOldFontEnumProc;
  TFNFontEnumProcA = TFNOldFontEnumProcA;
  TFNFontEnumProcW = TFNOldFontEnumProcW;


function AddFontResource(FileName: string): Integer;
function AddFontResourceA(FileName: string): Integer;
function AddFontResourceW(FileName: string): Integer;
function AnimatePalette(PHandle: HPALETTE; StartIndex, Entries: UINT;
  [in] Replacement: array of TPaletteEntry): BOOL;
function Arc(hDC: HDC; left, top, right, bottom, startX, startY, endX, endY: Integer): BOOL;
function BitBlt(DestDC: HDC; X, Y, Width, Height: Integer; SrcDC: HDC;
  XSrc, YSrc: Integer; Rop: DWORD): BOOL;
function CancelDC(DC: HDC): BOOL;
function Chord(DC: HDC; X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer): BOOL;
function ChoosePixelFormat(DC: HDC; var p2: TPixelFormatDescriptor): Integer;
function CloseMetaFile(DC: HDC): HMETAFILE;
function CombineRgn(p1, p2, p3: HRGN; p4: Integer): Integer;
function CopyMetaFile(Handle: HMETAFILE; lpszFile: string): HMETAFILE;
function CopyMetaFileA(Handle: HMETAFILE; lpszFile: string): HMETAFILE;
function CopyMetaFileW(Handle: HMETAFILE; lpszFile: string): HMETAFILE;
function CreateBitmap(Width, Height: Integer; Planes, BitCount: Longint;
  Bits: IntPtr): HBITMAP;
function CreateBitmapIndirect(const p1: TBitmap): HBITMAP;
function CreateBrushIndirect(const p1: TLogBrush): HBRUSH;
function CreateCompatibleBitmap(DC: HDC; Width, Height: Integer): HBITMAP;
function CreateDiscardableBitmap(DC: HDC; p2, p3: Integer): HBITMAP;
function CreateCompatibleDC(DC: HDC): HDC;
function CreateDC(lpszDriver, lpszDevice: string; lpszOutput: IntPtr;
  const lpdvmInit: TDeviceMode): HDC; overload;
function CreateDC(lpszDriver: string; lpszDevice, lpszOutput: IntPtr;
  const lpdvmInit: TDeviceMode): HDC; overload;
function CreateDC(lpszDriver: IntPtr; lpszDevice: string; lpszOutput: IntPtr;
  const lpdvmInit: TDeviceMode): HDC; overload;
function CreateDC(lpszDriver, lpszDevice, lpszOutput: IntPtr;
  const lpdvmInit: TDeviceMode): HDC; overload;
function CreateDC(lpszDriver, lpszDevice: string; lpszOutput: IntPtr;
  lpdvmInit: IntPtr): HDC; overload;
function CreateDC(lpszDriver: string; lpszDevice, lpszOutput: IntPtr;
  lpdvmInit: IntPtr): HDC; overload;
function CreateDC(lpszDriver: IntPtr; lpszDevice: string; lpszOutput: IntPtr;
  lpdvmInit: IntPtr): HDC; overload;
function CreateDC(lpszDriver, lpszDevice, lpszOutput: IntPtr;
  lpdvmInit: IntPtr): HDC; overload;
function CreateDCA(lpszDriver, lpszDevice, lpszOutput: string;
  const lpdvmInit: TDeviceModeA): HDC;
function CreateDCW(lpszDriver, lpszDevice, lpszOutput: string;
  const lpdvmInit: TDeviceModeW): HDC;
function CreateDIBitmap(DC: HDC; const InfoHeader: TBitmapInfoHeader;
  dwUsage: DWORD; [in] InitBits: TBytes; const InitInfo: TBitmapInfo;
  wUsage: UINT): HBITMAP;
function CreateDIBPatternBrush(p1: HGLOBAL; p2: UINT): HBRUSH;
function CreateDIBPatternBrushPt([in] p1: TBytes; p2: UINT): HBRUSH;
function CreateEllipticRgn(p1, p2, p3, p4: Integer): HRGN;
function CreateEllipticRgnIndirect(const p1: TRect): HRGN;
function CreateFontIndirect(const p1: TLogFont): HFONT;
function CreateFontIndirectA(const p1: TLogFontA): HFONT;
function CreateFontIndirectW(const p1: TLogFontW): HFONT;
function CreateFont(nHeight, nWidth, nEscapement, nOrientaion, fnWeight: Integer;
  fdwItalic, fdwUnderline, fdwStrikeOut, fdwCharSet, fdwOutputPrecision,
  fdwClipPrecision, fdwQuality, fdwPitchAndFamily: DWORD; lpszFace: string): HFONT;
function CreateFontA(nHeight, nWidth, nEscapement, nOrientaion, fnWeight: Integer;
  fdwItalic, fdwUnderline, fdwStrikeOut, fdwCharSet, fdwOutputPrecision,
  fdwClipPrecision, fdwQuality, fdwPitchAndFamily: DWORD; lpszFace: string): HFONT;
function CreateFontW(nHeight, nWidth, nEscapement, nOrientaion, fnWeight: Integer;
  fdwItalic, fdwUnderline, fdwStrikeOut, fdwCharSet, fdwOutputPrecision,
  fdwClipPrecision, fdwQuality, fdwPitchAndFamily: DWORD; lpszFace: string): HFONT;
function CreateHatchBrush(p1: Integer; p2: COLORREF): HBRUSH;

function CreateIC(lpszDriver: string; lpszDevice: string;
  lpszOutput: IntPtr; const lpdvmInit: TDeviceMode): HDC; overload;
function CreateIC(lpszDriver: IntPtr; lpszDevice: string;
  lpszOutput: IntPtr; const lpdvmInit: TDeviceMode): HDC; overload;
function CreateIC(lpszDriver: IntPtr; lpszDevice: IntPtr;
  lpszOutput: IntPtr; lpdvmInit: IntPtr): HDC; overload;
function CreateIC(lpszDriver: string; lpszDevice: IntPtr;
  lpszOutput: IntPtr; lpdvmInit: IntPtr): HDC; overload;
function CreateIC(lpszDriver: string; lpszDevice: IntPtr;
  lpszOutput: IntPtr; const lpdvmInit: TDeviceMode): HDC; overload;
function CreateIC(lpszDriver: IntPtr; lpszDevice: string;
  lpszOutput: IntPtr; lpdvmInit: IntPtr): HDC; overload;
function CreateIC(lpszDriver: string; lpszDevice: string;
  lpszOutput: IntPtr; lpdvmInit: IntPtr): HDC; overload;
function CreateIC(lpszDriver: IntPtr; lpszDevice: IntPtr;
  lpszOutput: IntPtr; const lpdvmInit: TDeviceMode): HDC; overload;
function CreateICA(lpszDriver, lpszDevice: string;
  lpszOutput: IntPtr; const lpdvmInit: TDeviceModeA): HDC;
function CreateICW(lpszDriver, lpszDevice: string;
  lpszOutput: IntPtr; const lpdvmInit: TDeviceModeW): HDC;

function CreateMetaFile(p1: string): HDC;
function CreateMetaFileA(p1: string): HDC;
function CreateMetaFileW(p1: string): HDC;
function CreatePalette(const LogPalette: TLogPalette): HPalette; overload;
function CreatePalette(const LogPalette: TMaxLogPalette): HPalette; overload;
function CreatePen(Style, Width: Integer; Color: COLORREF): HPEN;
function CreatePenIndirect(const LogPen: TLogPen): HPEN;
function CreatePolyPolygonRgn([in] lpPt: array of TPoint;
  [in] lpPolyCounts: TIntegerDynArray; p3, p4: Integer): HRGN;
function CreatePatternBrush(Bitmap: HBITMAP): HBRUSH;
function CreateRectRgn(p1, p2, p3, p4: Integer): HRGN;
function CreateRectRgnIndirect(const p1: TRect): HRGN;
function CreateRoundRectRgn(p1, p2, p3, p4, p5, p6: Integer): HRGN;
function CreateScalableFontResource(p1: DWORD; p2, p3, p4: string): BOOL;
function CreateScalableFontResourceA(p1: DWORD; p2, p3, p4: string): BOOL;
function CreateScalableFontResourceW(p1: DWORD; p2, p3, p4: string): BOOL;
function CreateSolidBrush(p1: COLORREF): HBRUSH;
function DeleteDC(DC: HDC): BOOL;
function DeleteMetaFile(p1: HMETAFILE): BOOL;
function DeleteObject(p1: HGDIOBJ): BOOL;
function DescribePixelFormat(DC: HDC; p2: Integer; p3: UINT;
  var p4: TPixelFormatDescriptor): BOOL; 

{ define types of pointers to ExtDeviceMode() and DeviceCapabilities()
  functions for Win 3.1 compatibility }

type
  TFNDevMode = function(Wnd: HWND; Driver: HMODULE;
    var DevModeOutput: TDeviceMode; DeciveName, Port: string;
    var DevModeInput: TDeviceMode; Profile: string; Mode: UINT): UINT;

  TFNDevCaps = function(DeviceName, Port: string;
    Index: UINT; Output: string; var DevMode: TDeviceMode): DWORD;

const
  { mode selections for the device mode function }
  DM_UPDATE = 1;
  DM_COPY = 2;
  DM_PROMPT = 4;
  DM_MODIFY = 8;

  DM_IN_BUFFER = DM_MODIFY;
  DM_IN_PROMPT = DM_PROMPT;
  DM_OUT_BUFFER = DM_COPY;
  DM_OUT_DEFAULT = DM_UPDATE;

  { device capabilities indices }
  DC_FIELDS = 1;
  DC_PAPERS = 2;
  DC_PAPERSIZE = 3;
  DC_MINEXTENT = 4;
  DC_MAXEXTENT = 5;
  DC_BINS = 6;
  DC_DUPLEX = 7;
  DC_SIZE = 8;
  DC_EXTRA = 9;
  DC_VERSION = 10;
  DC_DRIVER = 11;
  DC_BINNAMES = 12;
  DC_ENUMRESOLUTIONS = 13;
  DC_FILEDEPENDENCIES = 14;
  DC_TRUETYPE = 15;
  DC_PAPERNAMES = 16;
  DC_ORIENTATION = 17;
  DC_COPIES = 18;
  DC_BINADJUST = 19;
  DC_EMF_COMPLIANT = 20;
  DC_DATATYPE_PRODUCED = 21;
  DC_COLLATE = 22;
  DC_MANUFACTURER = 23;
  DC_MODEL = 24;
  DC_COLORDEVICE = 23;
  DC_NUP = 24;
  DC_PERSONALITY = 25;
  DC_PRINTRATE = 26;
  DC_PRINTRATEUNIT = 27;
  PRINTRATEUNIT_PPM = 1;
  PRINTRATEUNIT_CPS = 2;
  PRINTRATEUNIT_LPM = 3;
  PRINTRATEUNIT_IPM = 4;
  DC_PRINTERMEM = 28;
  DC_MEDIAREADY = 29;


  { bit fields of the return value (DWORD) for DC_TRUETYPE }
  DCTT_BITMAP = 1;
  DCTT_DOWNLOAD = 2;
  DCTT_SUBDEV = 4;
  DCTT_DOWNLOAD_OUTLINE = 8;


  { return values for DC_BINADJUST }
  DCBA_FACEUPNONE = 0;
  DCBA_FACEUPCENTER = 1;
  DCBA_FACEUPLEFT = 2;
  DCBA_FACEUPRIGHT = 3;
  DCBA_FACEDOWNNONE = $100;
  DCBA_FACEDOWNCENTER = 257;
  DCBA_FACEDOWNLEFT = 258;
  DCBA_FACEDOWNRIGHT = 259;


function DeviceCapabilities(pDriverName, pDeviceName, pPort: string;
  iIndex: Integer; pOutput: IntPtr; const DevMode: TDeviceMode): Integer; overload;
function DeviceCapabilities(pDriverName, pDeviceName, pPort: string;
  iIndex: Integer; pOutput: IntPtr; DevMode: IntPtr): Integer; overload;
function DeviceCapabilitiesA(pDriverName, pDeviceName, pPort: string;
  iIndex: Integer; pOutput: IntPtr; const DevMode: TDeviceModeA): Integer;
function DeviceCapabilitiesW(pDriverName, pDeviceName, pPort: string;
  iIndex: Integer; pOutput: IntPtr; const DevMode: TDeviceModeW): Integer;

function DrawEscape(DC: HDC; nEscape, cbInput: Integer;
  [in] lpszInData: array of Byte): BOOL; overload;
function DrawEscape(DC: HDC; nEscape, cbInput: Integer;
  lpszInData: IntPtr): BOOL; overload;
function Ellipse(DC: HDC; X1, Y1, X2, Y2: Integer): BOOL;
function EnumFontFamiliesEx(DC: HDC; const p2: TLogFont;
  p3: TFNFontEnumProc; p4: LPARAM; p5: DWORD): BOOL;
function EnumFontFamiliesExA(DC: HDC; const p2: TLogFontA;
  p3: TFNFontEnumProcA; p4: LPARAM; p5: DWORD): BOOL;
function EnumFontFamiliesExW(DC: HDC; const p2: TLogFontW;
  p3: TFNFontEnumProcW; p4: LPARAM; p5: DWORD): BOOL;
function EnumFontFamilies(DC: HDC; p2: string; p3: TFNFontEnumProc; p4: LPARAM): BOOL; overload;
function EnumFontFamilies(DC: HDC; p2: IntPtr; p3: TFNFontEnumProc; p4: LPARAM): BOOL; overload;
function EnumFontFamiliesA(DC: HDC; p2: string; p3: TFNFontEnumProcA; p4: LPARAM): BOOL;
function EnumFontFamiliesW(DC: HDC; p2: string; p3: TFNFontEnumProcW; p4: LPARAM): BOOL;
function EnumFonts(DC: HDC; lpszFace: string; fntenmprc: TFNFontEnumProc;
  LParam: Longint): Integer; overload;
function EnumFonts(DC: HDC; lpszFace: IntPtr; fntenmprc: TFNFontEnumProc;
  LParam: Longint): Integer; overload;
function EnumFontsA(DC: HDC; lpszFace: string; fntenmprc: TFNFontEnumProcA;
  LParam: Longint): Integer;
function EnumFontsW(DC: HDC; lpszFace: string; fntenmprc: TFNFontEnumProcW;
  LParam: Longint): Integer;
function EnumObjects(DC: HDC; p2: Integer; p3: TFNGObjEnumProc; p4: LPARAM): Integer;
function EqualRgn(p1, p2: HRGN): BOOL;
function Escape(DC: HDC; p2, p3: Integer; p4, p5: IntPtr): Integer;
function ExtEscape(DC: HDC; p2, p3: Integer; p4: IntPtr; p5: Integer; p6: IntPtr): Integer;
function ExcludeClipRect(DC: HDC; LeftRect, TopRect, RightRect, BottomRect: Integer): Integer;
function ExtCreateRegion(const XForm: TXForm; Count: DWORD; RgnData: IntPtr): HRGN; overload;
function ExtCreateRegion(XForm: IntPtr; Count: DWORD; RgnData: IntPtr): HRGN; overload;
function ExtFloodFill(DC: HDC; X, Y: Integer; Color: COLORREF; FillType: UINT): BOOL;
function FillRgn(DC: HDC; hrgn: HRGN; hbr: HBRUSH): BOOL;
function FloodFill(DC: HDC; nXStart, nYStart: Integer; crFill: COLORREF): BOOL;
function FrameRgn(DC: HDC; hrgn: HRGN; hbr: HBRUSH; Width, Height: Integer): BOOL;
function GetROP2(DC: HDC): Integer;
function GetAspectRatioFilterEx(DC: HDC; out AspectRatio: TSize): BOOL;
function GetBkColor(hDC: HDC): COLORREF;
function GetDCBrushColor(DC: HDC): COLORREF;
function GetDCPenColor(DC: HDC): COLORREF;
function GetBkMode(hDC: HDC): Integer;
function GetBitmapBits(Bitmap: HBITMAP; Count: Longint;
  [out] Bits: array of Byte): Longint; overload;
function GetBitmapBits(Bitmap: HBITMAP; Count: Longint;
  Bits: IntPtr): Longint; overload;
function GetBitmapDimensionEx(Bitmap: HBITMAP; out Dimension: TSize): BOOL;
function GetBoundsRect(DC: HDC; out Bounds: TRect; Flags: UINT): UINT;
function GetBrushOrgEx(DC: HDC; out lppt: TPoint): BOOL;

function GetCharWidth(DC: HDC; FirstChar, LastChar: UINT;
  [out] Widths: TIntegerDynArray): BOOL;
function GetCharWidthA(DC: HDC; FirstChar, LastChar: UINT;
  [out] Widths: TIntegerDynArray): BOOL;
function GetCharWidthW(DC: HDC; FirstChar, LastChar: UINT;
  [out] Widths: TIntegerDynArray): BOOL;
function GetCharWidth32(DC: HDC; FirstChar, LastChar: UINT;
  [out] Widths: TIntegerDynArray): BOOL;
function GetCharWidth32A(DC: HDC; FirstChar, LastChar: UINT;
  [out] Widths: TIntegerDynArray): BOOL;
function GetCharWidth32W(DC: HDC; FirstChar, LastChar: UINT;
  [out] Widths: TIntegerDynArray): BOOL;
function GetCharWidthFloat(DC: HDC; FirstChar, LastChar: UINT;
  [out] Widths: array of Single): BOOL;
function GetCharWidthFloatA(DC: HDC; FirstChar, LastChar: UINT;
  [out] Widths: array of Single): BOOL;
function GetCharWidthFloatW(DC: HDC; FirstChar, LastChar: UINT;
  [out] Widths: array of Single): BOOL;
function GetCharABCWidths(DC: HDC; FirstChar, LastChar: UINT;
  [out] ABCStructs: array of TABC): BOOL;
function GetCharABCWidthsA(DC: HDC; FirstChar, LastChar: UINT;
  [out] ABCStructs: array of TABC): BOOL;
function GetCharABCWidthsW(DC: HDC; FirstChar, LastChar: UINT;
  [out] ABCStructs: array of TABC): BOOL;
function GetCharABCWidthsFloat(DC: HDC; FirstChar, LastChar: UINT;
  [out] ABCFloatStructs: array of TABCFloat): BOOL;
function GetCharABCWidthsFloatA(DC: HDC; FirstChar, LastChar: UINT;
  [out] ABCFloatStructs: array of TABCFloat): BOOL;
function GetCharABCWidthsFloatW(DC: HDC; FirstChar, LastChar: UINT;
  [out] ABCFloatStructs: array of TABCFloat): BOOL;

function GetClipBox(DC: HDC; out Rect: TRect): Integer;
function GetClipRgn(DC: HDC; rgn: HRGN): Integer;
function GetMetaRgn(DC: HDC; rgn: HRGN): Integer;
function GetCurrentObject(DC: HDC; p2: UINT): HGDIOBJ;
function GetCurrentPositionEx(DC: HDC; out Point: TPoint): BOOL;
function GetDeviceCaps(DC: HDC; Index: Integer): Integer;
function GetDIBits(DC: HDC; Bitmap: HBitmap; StartScan, NumScans: UINT;
  [out] Bits: array of Byte; BitInfo: IntPtr; Usage: UINT): Integer; overload;
function GetDIBits(DC: HDC; Bitmap: HBitmap; StartScan, NumScans: UINT;
  Bits: IntPtr; var BitInfo: TBitmapInfo; Usage: UINT): Integer; overload;
function GetFontData(DC: HDC; p2, p3: DWORD; [out] p4: array of Byte;
  p5: DWORD): DWORD; overload;
function GetFontData(DC: HDC; p2, p3: DWORD; p4: IntPtr;
  p5: DWORD): DWORD; overload;
function GetGlyphOutline(DC: HDC; uChar, uFormat: UINT;
  out lpgm: TGlyphMetrics; cbBuffer: DWORD; [out] lpvBuffer: array of Byte;
  const lpmat2: TMat2): DWORD; overload;
function GetGlyphOutline(DC: HDC; uChar, uFormat: UINT;
  out lpgm: TGlyphMetrics; cbBuffer: DWORD; lpvBuffer: IntPtr;
  const lpmat2: TMat2): DWORD; overload;
function GetGlyphOutlineA(DC: HDC; uChar, uFormat: UINT;
  out lpgm: TGlyphMetrics; cbBuffer: DWORD; [out] lpvBuffer: TBytes;
  const lpmat2: TMat2): DWORD;
function GetGlyphOutlineW(DC: HDC; uChar, uFormat: UINT;
  out lpgm: TGlyphMetrics; cbBuffer: DWORD; [out] lpvBuffer: TBytes;
  const lpmat2: TMat2): DWORD;

function GetGraphicsMode(DC: HDC): Integer;
function GetMapMode(DC: HDC): Integer;
function GetMetaFileBitsEx(p1: HMETAFILE; Size: Cardinal; [out] p3: array of Byte): UINT; overload;
function GetMetaFileBitsEx(p1: HMETAFILE; Size: Cardinal; p3: IntPtr): UINT; overload;
function GetMetaFile(p1: string): HMETAFILE;
function GetMetaFileA(p1: string): HMETAFILE;
function GetMetaFileW(p1: string): HMETAFILE;
function GetNearestColor(DC: HDC; p2: COLORREF): COLORREF;
function GetNearestPaletteIndex(p1: HPALETTE; p2: COLORREF): UINT;
function GetObjectType(h: HGDIOBJ): DWORD;
function GetOutlineTextMetrics(DC: HDC; Size: Cardinal;
  [out] OTMetricStructs: array of TOutlineTextMetric): UINT; overload;
function GetOutlineTextMetrics(DC: HDC; Size: Cardinal;
  OTMetricStructs: IntPtr): UINT; overload;
function GetOutlineTextMetricsA(DC: HDC; Size: Cardinal;
  [out] OTMetricStructs: array of TOutlineTextMetricA): UINT;
function GetOutlineTextMetricsW(DC: HDC; Size: Cardinal;
  [out] OTMetricStructs: array of TOutlineTextMetricW): UINT;
function GetPaletteEntries(Palette: HPALETTE; StartIndex, NumEntries: UINT;
  [out] PaletteEntries: array of ColorRef): UINT; overload;
function GetPaletteEntries(Palette: HPALETTE; StartIndex, NumEntries: UINT;
  [out] PaletteEntries: array of TPaletteEntry): UINT; overload;
function GetPixel(DC: HDC; X, Y: Integer): COLORREF;
function GetPixelFormat(DC: HDC): Integer;
function GetPolyFillMode(DC: HDC): Integer;
function GetRasterizerCaps(out p1: TRasterizerStatus; Size: Cardinal): BOOL;
function GetRegionData(RGN: HRGN; p2: DWORD; out p3: TRgnData): DWORD; overload;
function GetRegionData(RGN: HRGN; p2: DWORD; p3: IntPtr): DWORD; overload;
function GetRgnBox(RGN: HRGN; out p2: TRect): Integer;
function GetStockObject(Index: Integer): HGDIOBJ;
function GetStretchBltMode(DC: HDC): Integer;
function GetSystemPaletteEntries(DC: HDC; StartIndex, NumEntries: UINT;
  [out] PaletteEntries: array of ColorRef): UINT; overload;
function GetSystemPaletteEntries(DC: HDC; StartIndex, NumEntries: UINT;
  PaletteEntries: IntPtr): UINT; overload;
function GetSystemPaletteUse(DC: HDC): UINT;
function GetTextCharacterExtra(DC: HDC): Integer;
function GetTextAlign(DC: HDC): UINT;
function GetTextColor(DC: HDC): COLORREF;
function GetTextExtentPoint(DC: HDC; Str: string; Count: Integer;
  out Size: TSize): BOOL;
function GetTextExtentPointA(DC: HDC; Str: string; Count: Integer;
  out Size: TSize): BOOL;
function GetTextExtentPointW(DC: HDC; Str: string; Count: Integer;
  out Size: TSize): BOOL;
function GetTextExtentPoint32(DC: HDC; Str: string; Count: Integer;
  out Size: TSize): BOOL;
function GetTextExtentPoint32A(DC: HDC; Str: string; Count: Integer;
  out Size: TSize): BOOL;
function GetTextExtentPoint32W(DC: HDC; Str: string; Count: Integer;
  out Size: TSize): BOOL;

function GetTextExtentExPoint(DC: HDC; p2: string; p3, p4: Integer; out p5: Integer;
  out p6: Integer; out p7: TSize): BOOL; overload;
function GetTextExtentExPoint(DC: HDC; p2: string; p3, p4: Integer; p5: IntPtr;
  p6: IntPtr; out p7: TSize): BOOL; overload;
function GetTextExtentExPoint(DC: HDC; p2: string; p3, p4: Integer; out p5: Integer;
  p6: IntPtr; out p7: TSize): BOOL; overload;
function GetTextExtentExPoint(DC: HDC; p2: string; p3, p4: Integer; p5: IntPtr;
  out p6: Integer; out p7: TSize): BOOL; overload;
function GetTextExtentExPointA(DC: HDC; p2: string;
  p3, p4: Integer; out p5, p6: Integer; out p7: TSize): BOOL;
function GetTextExtentExPointW(DC: HDC; p2: string;
  p3, p4: Integer; out p5, p6: Integer; out p7: TSize): BOOL;

function GetTextCharset(hdc: HDC): Integer;
function GetTextCharsetInfo(hdc: HDC; out lpSig: TFontSignature;
  dwFlags: DWORD): BOOL; overload;
function GetTextCharsetInfo(hdc: HDC; lpSig: IntPtr;
  dwFlags: DWORD): BOOL; overload;
function TranslateCharsetInfo(var lpSrc: DWORD; out lpCs: TCharsetInfo; dwFlags: DWORD): BOOL;
function GetFontLanguageInfo(DC: HDC): DWORD;
function GetCharacterPlacement(DC: HDC; p2: string; p3, p4: BOOL;
  var p5: TGCPResults; p6: DWORD): DWORD;
function GetCharacterPlacementA(DC: HDC; p2: string; p3, p4: BOOL;
  var p5: TGCPResults; p6: DWORD): DWORD;
function GetCharacterPlacementW(DC: HDC; p2: string; p3, p4: BOOL;
  var p5: TGCPResults; p6: DWORD): DWORD;

type
  tagWCRANGE = packed record
    wcLow: WCHAR;
    cGlyphs: SHORT;
  end;
  TWCRange = tagWCRANGE;

  tagGLYPHSET = packed record
    cbThis: DWORD;
    flAccel: DWORD;
    cGlyphsSupported: DWORD;
    cRanges: DWORD;
    ranges: IntPtr; { array[0..0] of TWCRange }
  end;
  TGlyphSet = tagGLYPHSET;

const
  { flAccel flags for the TGlyphSet structure above }
  GS_8BIT_INDICES = 1;
  { flags for GetGlyphIndices }
  GGI_MARK_NONEXISTING_GLYPHS = 1;

function GetFontUnicodeRanges(DC: HDC; out lpgs: TGlyphSet): DWORD; overload;
function GetFontUnicodeRanges(DC: HDC; lpgs: IntPtr): DWORD; overload;
function GetGlyphIndices(DC: HDC; p2: string; p3: Integer; [out] p4: TWordDynArray; p5: DWORD): DWORD;
function GetGlyphIndicesA(DC: HDC; p2: string; p3: Integer; [out] p4: TWordDynArray; p5: DWORD): DWORD;
function GetGlyphIndicesW(DC: HDC; p2: string; p3: Integer; [out] p4: TWordDynArray; p5: DWORD): DWORD;
function GetTextExtentPointI(DC: HDC; [in] p2: TWordDynArray; p3: Integer; out p4: TSize): BOOL;
function GetTextExtentExPointI(DC: HDC; [in] p2: TWordDynArray; p3, p4: Integer;
  p5, p6: IntPtr; out p7: TSize): BOOL; overload;
function GetTextExtentExPointI(DC: HDC; [in] p2: TWordDynArray; p3, p4: Integer;
  out p5: Integer; [out] p6: TIntegerDynArray; out p7: TSize): BOOL; overload;
function GetCharWidthI(DC: HDC; p2, p3: UINT; [in] p4: array of Word;
  [out] Widths: TIntegerDynArray): BOOL; overload;
function GetCharWidthI(DC: HDC; p2, p3: UINT; p4: IntPtr;
  [out] Widths: TIntegerDynArray): BOOL; overload;
function GetCharABCWidthsI(DC: HDC; p2, p3: UINT; [in] p4: array of Word;
  [out] Widths: array of TABC): BOOL; overload;
function GetCharABCWidthsI(DC: HDC; p2, p3: UINT; p4: IntPtr;
  [out] Widths: array of TABC): BOOL; overload;

const
  STAMP_DESIGNVECTOR = $80000000 + Ord('d') + (Ord('v') shl 8);
  STAMP_AXESLIST = $80000000 + Ord('a') + (Ord('l') shl 8);
  MM_MAX_NUMAXES = 16;

type
  tagDESIGNVECTOR = packed record
    dvReserved: DWORD;
    dvNumAxes: DWORD;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=MM_MAX_NUMAXES)]
    dvValues: array[0..MM_MAX_NUMAXES-1] of Longint;
  end;
  TDesignVector = tagDESIGNVECTOR;

function AddFontResourceEx(p1: string; p2: DWORD; p3: IntPtr): Integer;
function AddFontResourceExA(p1: string; p2: DWORD; p3: IntPtr): Integer;
function AddFontResourceExW(p1: string; p2: DWORD; p3: IntPtr): Integer;
function RemoveFontResourceEx(p1: string; p2: DWORD; p3: IntPtr): BOOL;
function RemoveFontResourceExA(p1: string; p2: DWORD; p3: IntPtr): BOOL;
function RemoveFontResourceExW(p1: string; p2: DWORD; p3: IntPtr): BOOL;

function AddFontMemResourceEx(p1: IntPtr; p2: DWORD; p3: IntPtr; [in] var p: DWORD): THandle;
function RemoveFontMemResourceEx(p1: THandle): BOOL;

const
  FR_PRIVATE = $10;
  FR_NOT_ENUM = $20;
  MM_MAX_AXES_NAMELEN = 16;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagAXISINFO = packed record
    axMinValue: Longint;
    axMaxValue: Longint;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MM_MAX_AXES_NAMELEN)]
    axAxisName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagAXISINFOA = packed record
    axMinValue: Longint;
    axMaxValue: Longint;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MM_MAX_AXES_NAMELEN)]
    axAxisName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagAXISINFOW = packed record
    axMinValue: Longint;
    axMaxValue: Longint;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MM_MAX_AXES_NAMELEN)]
    axAxisName: string;
  end;
  TAxisInfo = tagAXISINFO;
  TAxisInfoA = tagAXISINFOA;
  TAxisInfoW = tagAXISINFOW;

{$IF MM_MAX_NUMAXES <> 16}
{$MESSAGE ERROR 'TAxesList requires MM_MAX_NUMAXES to be 16'}
{$IFEND}

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagAXESLIST = packed record
    axlReserved: DWORD;
    axlNumAxes: DWORD;
    axlAxisInfo0: TAxisInfo; { axlAxisInfo: array[0..MM_MAX_NUMAXES-1] of TAxisInfo }
    axlAxisInfo1: TAxisInfo;
    axlAxisInfo2: TAxisInfo;
    axlAxisInfo3: TAxisInfo;
    axlAxisInfo4: TAxisInfo;
    axlAxisInfo5: TAxisInfo;
    axlAxisInfo6: TAxisInfo;
    axlAxisInfo7: TAxisInfo;
    axlAxisInfo8: TAxisInfo;
    axlAxisInfo9: TAxisInfo;
    axlAxisInfo10: TAxisInfo;
    axlAxisInfo11: TAxisInfo;
    axlAxisInfo12: TAxisInfo;
    axlAxisInfo13: TAxisInfo;
    axlAxisInfo14: TAxisInfo;
    axlAxisInfo15: TAxisInfo;
  end;
  TAxesList = tagAXESLIST;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagAXESLISTA = packed record
    axlReserved: DWORD;
    axlNumAxes: DWORD;
    axlAxisInfo0: TAxisInfoA; { axlAxisInfo: array[0..MM_MAX_NUMAXES-1] of TAxisInfoA }
    axlAxisInfo1: TAxisInfoA;
    axlAxisInfo2: TAxisInfoA;
    axlAxisInfo3: TAxisInfoA;
    axlAxisInfo4: TAxisInfoA;
    axlAxisInfo5: TAxisInfoA;
    axlAxisInfo6: TAxisInfoA;
    axlAxisInfo7: TAxisInfoA;
    axlAxisInfo8: TAxisInfoA;
    axlAxisInfo9: TAxisInfoA;
    axlAxisInfo10: TAxisInfoA;
    axlAxisInfo11: TAxisInfoA;
    axlAxisInfo12: TAxisInfoA;
    axlAxisInfo13: TAxisInfoA;
    axlAxisInfo14: TAxisInfoA;
    axlAxisInfo15: TAxisInfoA;
  end;
  TAxesListA = tagAXESLISTA;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagAXESLISTW = packed record
    axlReserved: DWORD;
    axlNumAxes: DWORD;
    axlAxisInfo0: TAxisInfoW; { axlAxisInfo: array[0..MM_MAX_NUMAXES-1] of TAxisInfoW }
    axlAxisInfo1: TAxisInfoW;
    axlAxisInfo2: TAxisInfoW;
    axlAxisInfo3: TAxisInfoW;
    axlAxisInfo4: TAxisInfoW;
    axlAxisInfo5: TAxisInfoW;
    axlAxisInfo6: TAxisInfoW;
    axlAxisInfo7: TAxisInfoW;
    axlAxisInfo8: TAxisInfoW;
    axlAxisInfo9: TAxisInfoW;
    axlAxisInfo10: TAxisInfoW;
    axlAxisInfo11: TAxisInfoW;
    axlAxisInfo12: TAxisInfoW;
    axlAxisInfo13: TAxisInfoW;
    axlAxisInfo14: TAxisInfoW;
    axlAxisInfo15: TAxisInfoW;
  end;
  TAxesListW = tagAXESLISTW;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagENUMLOGFONTEXDV = packed record
    elfEnumLogfontEx: TEnumLogFontEx;
    elfDesignVector: TDesignVector;
  end;
  TEnumLogFontExDV = tagENUMLOGFONTEXDV;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagENUMLOGFONTEXDVA = packed record
    elfEnumLogfontEx: TEnumLogFontExA;
    elfDesignVector: TDesignVector;
  end;
  TEnumLogFontExDVA = tagENUMLOGFONTEXDVA;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagENUMLOGFONTEXDVW = packed record
    elfEnumLogfontEx: TEnumLogFontExW;
    elfDesignVector: TDesignVector;
  end;
  TEnumLogFontExDVW = tagENUMLOGFONTEXDVW;

function CreateFontIndirectEx(const p1: TEnumLogFontExDV): HFONT;
function CreateFontIndirectExA(const p1: TEnumLogFontExDVA): HFONT;
function CreateFontIndirectExW(const p1: TEnumLogFontExDVW): HFONT;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagENUMTEXTMETRIC = packed record
    etmNewTextMetricEx: TNewTextMetricEx;
    etmAxesList: TAxesList;
  end;
  TEnumTextMetric = tagENUMTEXTMETRIC;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagENUMTEXTMETRICA = packed record
    etmNewTextMetricEx: TNewTextMetricExA;
    etmAxesList: TAxesListA;
  end;
  TEnumTextMetricA = tagENUMTEXTMETRICA;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagENUMTEXTMETRICW = packed record
    etmNewTextMetricEx: TNewTextMetricExW;
    etmAxesList: TAxesListW;
  end;
  TEnumTextMetricW = tagENUMTEXTMETRICW;


function GetViewportExtEx(DC: HDC; out Size: TSize): BOOL;
function GetViewportOrgEx(DC: HDC; out Point: TPoint): BOOL;
function GetWindowExtEx(DC: HDC; out Size: TSize): BOOL;
function GetWindowOrgEx(DC: HDC; out Point: TPoint): BOOL;
function IntersectClipRect(DC: HDC; X1, Y1, X2, Y2: Integer): Integer;
function InvertRgn(DC: HDC; p2: HRGN): BOOL;
function LineDDA(XStart, YStart, XEnd, YEnd: Integer; LineFunc: TFNLineDDAProc; Data: LPARAM): BOOL;
function LineTo(DC: HDC; X, Y: Integer): BOOL;
function MaskBlt(DestDC: HDC; XDest, YDest, Width, Height: Integer; SrcDC: HDC;
  XScr, YScr: Integer; Mask: HBITMAP; xMask, yMask: Integer; Rop: DWORD): BOOL;
function PlgBlt(DestDC: HDC; [in] PointsArray: array of TPoint; SrcDC: HDC;
  XSrc, YSrc, Width, Height: Integer; Mask: HBITMAP; xMask, yMask: Integer): BOOL;
function OffsetClipRgn(DC: HDC; XOffset, YOffset: Integer): Integer;
function OffsetRgn(RGN: HRGN; XOffset, YOffset: Integer): Integer;
function PatBlt(DC: HDC; X, Y, Width, Height: Integer; Rop: DWORD): BOOL;
function Pie(DC: HDC; X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer): BOOL;
function PlayMetaFile(DC: HDC; MF: HMETAFILE): BOOL;
function PaintRgn(DC: HDC; RGN: HRGN): BOOL;
function PolyPolygon(DC: HDC; [in] Points: array of TPoint;
  [in] nPoints: TIntegerDynArray; p4: Integer): BOOL;
function PtInRegion(RGN: HRGN; X, Y: Integer): BOOL;
function PtVisible(DC: HDC; X, Y: Integer): BOOL;
function RectInRegion(RGN: HRGN; const Rect: TRect): BOOL;
function RectVisible(DC: HDC; const Rect: TRect): BOOL;
function Rectangle(DC: HDC; X1, Y1, X2, Y2: Integer): BOOL;
function RestoreDC(DC: HDC; SavedDC: Integer): BOOL;
function ResetDC(DC: HDC; const InitData: TDeviceMode): HDC;
function ResetDCA(DC: HDC; const InitData: TDeviceModeA): HDC;
function ResetDCW(DC: HDC; const InitData: TDeviceModeW): HDC;
function RealizePalette(DC: HDC): UINT;
function RemoveFontResource(FileName: string): BOOL;
function RemoveFontResourceA(FileName: string): BOOL;
function RemoveFontResourceW(FileName: string): BOOL;
function RoundRect(DC: HDC; X1, Y1, X2, Y2, X3, Y3: Integer): BOOL;
function ResizePalette(Palette: HPALETTE; Entries: UINT): BOOL;
function SaveDC(DC: HDC): Integer;
function SelectClipRgn(DC: HDC; Region: HRGN): Integer;
function ExtSelectClipRgn(DC: HDC; Region: HRGN; Mode: Integer): Integer;
function SetMetaRgn(DC: HDC): Integer;
function SelectObject(DC: HDC; p2: HGDIOBJ): HGDIOBJ;
function SelectPalette(DC: HDC; Palette: HPALETTE;
  ForceBackground: Bool): HPALETTE;
function SetBkColor(DC: HDC; Color: COLORREF): COLORREF;
function SetDCBrushColor(DC: HDC; Color: COLORREF): COLORREF;
function SetDCPenColor(DC: HDC; Color: COLORREF): COLORREF;
function SetBkMode(DC: HDC; BkMode: Integer): Integer;
function SetBitmapBits(p1: HBITMAP; p2: DWORD; [in] bits: TBytes): Longint;
function SetBoundsRect(DC: HDC; const p2: TRect; p3: UINT): UINT; overload;
function SetBoundsRect(DC: HDC; p2: IntPtr; p3: UINT): UINT; overload;
function SetDIBits(DC: HDC; Bitmap: HBITMAP; StartScan, NumScans: UINT;
  [in] Bits: TBytes; const BitsInfo: TBitmapInfo; Usage: UINT): Integer;
function SetDIBitsToDevice(DC: HDC; DestX, DestY: Integer; Width, Height: DWORD;
  SrcX, SrcY: Integer; nStartScan, NumScans: UINT; [in] Bits: TBytes;
  const BitsInfo: TBitmapInfo; Usage: UINT): Integer;
function SetMapperFlags(DC: HDC; Flag: DWORD): DWORD;
function SetGraphicsMode(hdc: HDC; iMode: Integer): Integer;
function SetMapMode(DC: HDC; p2: Integer): Integer;
function SetMetaFileBitsEx(Size: UINT; [in] Data: TBytes): HMETAFILE;
function SetPaletteEntries(Palette: HPALETTE; StartIndex, NumEntries: UINT;
  [in] PaletteEntries: array of TPaletteEntry): UINT;
function SetPixel(DC: HDC; X, Y: Integer; Color: COLORREF): COLORREF;
function SetPixelV(DC: HDC; X, Y: Integer; Color: COLORREF): BOOL;
function SetPixelFormat(DC: HDC; PixelFormat: Integer; const FormatDef: TPixelFormatDescriptor): BOOL;
function SetPolyFillMode(DC: HDC; PolyFillMode: Integer): Integer;
function StretchBlt(DestDC: HDC; X, Y, Width, Height: Integer; SrcDC: HDC;
  XSrc, YSrc, SrcWidth, SrcHeight: Integer; Rop: DWORD): BOOL;
function SetRectRgn(Rgn: HRgn; X1, Y1, X2, Y2: Integer): BOOL;
function StretchDIBits(DC: HDC; DestX, DestY, DestWidth, DestHeight, SrcX,
  SrcY, SrcWidth, SrcHeight: Integer; [in] Bits: TBytes; BitsInfo: IntPtr;
  Usage: UINT; Rop: DWORD): Integer;
function SetROP2(DC: HDC; p2: Integer): Integer;
function SetStretchBltMode(DC: HDC; StretchMode: Integer): Integer;
function SetSystemPaletteUse(DC: HDC; p2: UINT): UINT;
function SetTextCharacterExtra(DC: HDC; CharExtra: Integer): Integer;
function SetTextColor(DC: HDC; Color: COLORREF): COLORREF;
function SetTextAlign(DC: HDC; Flags: UINT): UINT;
function SetTextJustification(DC: HDC; BreakExtra, BreakCount: Integer): Integer;
function UpdateColors(DC: HDC): BOOL;

type
  COLOR16 = Shortint;

  _TRIVERTEX = packed record
    x: Longint;
    y: Longint;
    Red: COLOR16;
    Green: COLOR16;
    Blue: COLOR16;
    Alpha: COLOR16;
  end;
  TTriVertex = _TRIVERTEX;
  TRIVERTEX = _TRIVERTEX;

  _GRADIENT_TRIANGLE = packed record
    Vertex1: ULONG;
    Vertex2: ULONG;
    Vertex3: ULONG;
  end;
  TGradientTriangle = _GRADIENT_TRIANGLE;
  GRADIENT_TRIANGLE = _GRADIENT_TRIANGLE;

  _GRADIENT_RECT = packed record
    UpperLeft: ULONG;
    LowerRight: ULONG;
  end;
  TGradientRect = _GRADIENT_RECT;
  GRADIENT_RECT = _GRADIENT_RECT;

  _BLENDFUNCTION = packed record
    BlendOp: BYTE;
    BlendFlags: BYTE;
    SourceConstantAlpha: BYTE;
    AlphaFormat: BYTE;
  end;
  TBlendFunction = _BLENDFUNCTION;
  BLENDFUNCTION = _BLENDFUNCTION;

const
  { currentlly defined blend function }
  AC_SRC_OVER = $00;
  AC_SRC_ALPHA = $01;

  { alpha format flags }
  AC_SRC_NO_PREMULT_ALPHA = $01;
  AC_SRC_NO_ALPHA = $02;
  AC_DST_NO_PREMULT_ALPHA = $10;
  AC_DST_NO_ALPHA = $20;

function AlphaBlend(DC: HDC; p2, p3, p4, p5: Integer; DC6: HDC; p7, p8, p9, p10: Integer; p11: TBlendFunction): BOOL;
                                       
function AlphaDIBBlend(DC: HDC; p2, p3, p4, p5: Integer; const p6: IntPtr;
        const p7: TBitmapInfo; p8: UINT; p9, p10, p11, p12: Integer; p13: TBlendFunction): BOOL;
function TransparentBlt(DC: HDC; p2, p3, p4, p5: Integer; DC6: HDC; p7, p8, p9, p10: Integer; p11: UINT): BOOL;
                                       
function TransparentDIBits(DC: HDC; p2, p3, p4, p5: Integer; const p6: IntPtr;
        const p7: TBitmapInfo; p8: UINT; p9, p10, p11, p12: Integer; p13: UINT): BOOL;

const
  { gradient drawing modes }
  GRADIENT_FILL_RECT_H = $00000000;
  GRADIENT_FILL_RECT_V = $00000001;
   GRADIENT_FILL_TRIANGLE = $00000002;
  GRADIENT_FILL_OP_FLAG = $000000ff;

function GradientFill(DC: HDC; [in] Vertex: array of TTriVertex;
  NumVertex: ULONG; const Mesh: TGradientTriangle; NumMesh, Mode: ULONG): BOOL; overload;
function GradientFill(DC: HDC; [in] Vertex: array of TTriVertex;
  NumVertex: ULONG; const Mesh: TGradientRect; NumMesh, Mode: ULONG): BOOL; overload;

function PlayMetaFileRecord(DC: HDC; const p2: THandleTable; const p3: TMetaRecord; p4: UINT): BOOL;

type
  TFNMFEnumProc = function (DC: HDC; [in] var p2: THandleTable; [in] var p3: TMetaRecord;
    p4: Integer; p5: LPARAM): Integer;
  TFNEnhMFEnumProc = function (DC: HDC; [in] var p2: THandleTable; [in] var p3: TEnhMetaRecord;
    p4: Integer; p5: LPARAM): Integer;

function EnumMetaFile(DC: HDC; Handle: HMETAFILE; MetaFunc: TFNMFEnumProc; lParam: LPARAM): BOOL;

{ Enhanced Metafile Function Declarations }

function CloseEnhMetaFile(DC: HDC): HENHMETAFILE;
function CopyEnhMetaFile(Handle: HENHMETAFILE; p2: string): HENHMETAFILE; overload;
function CopyEnhMetaFile(Handle: HENHMETAFILE; p2: IntPtr): HENHMETAFILE; overload;
function CopyEnhMetaFileA(Handle: HENHMETAFILE; p2: string): HENHMETAFILE;
function CopyEnhMetaFileW(Handle: HENHMETAFILE; p2: string): HENHMETAFILE;
function CreateEnhMetaFile(DC: HDC; FileName: string; const Rect: TRect; Desc: string): HDC; overload;
function CreateEnhMetaFile(DC: HDC; FileName: IntPtr; const Rect: TRect; Desc: string): HDC; overload;
function CreateEnhMetaFile(DC: HDC; FileName: IntPtr; const Rect: TRect; Desc: IntPtr): HDC; overload;
function CreateEnhMetaFile(DC: HDC; FileName: IntPtr; const Rect: TRect; Desc: StringBuilder): HDC; overload;
function CreateEnhMetaFileA(DC: HDC; FileName: string; const Rect: TRect; Desc: string): HDC;
function CreateEnhMetaFileW(DC: HDC; FileName: string; const Rect: TRect; Desc: string): HDC;
function DeleteEnhMetaFile(Handle: HENHMETAFILE): BOOL;
function EnumEnhMetaFile(DC: HDC; Emf: HENHMETAFILE; EnhMetaFunc: TFNEnhMFEnumProc; Data: IntPtr; const Rect: TRect): BOOL;
function GetEnhMetaFile(p1: string): HENHMETAFILE;
function GetEnhMetaFileA(p1: string): HENHMETAFILE;
function GetEnhMetaFileW(p1: string): HENHMETAFILE;
function GetEnhMetaFileBits(Handle: HENHMETAFILE; Size: Cardinal; [out] p3: array of Byte): UINT; overload;
function GetEnhMetaFileBits(Handle: HENHMETAFILE; Size: Cardinal; p3: IntPtr): UINT; overload;
function GetEnhMetaFileDescription(Handle: HENHMETAFILE; Size: Cardinal; [out] p3: TBytes): UINT; overload;
function GetEnhMetaFileDescription(Handle: HENHMETAFILE; Size: Cardinal; p3: StringBuilder): UINT; overload;
function GetEnhMetaFileDescriptionA(Handle: HENHMETAFILE; Size: Cardinal; [out] p3: TBytes): UINT;
function GetEnhMetaFileDescriptionW(Handle: HENHMETAFILE; Size: Cardinal; [out] p3: TBytes): UINT;
function GetEnhMetaFileHeader(Handle: HENHMETAFILE; Size: Cardinal; out p3: TEnhMetaHeader): UINT; overload;
function GetEnhMetaFileHeader(Handle: HENHMETAFILE; Size: Cardinal; p3: IntPtr): UINT; overload;
function GetEnhMetaFilePaletteEntries(Handle: HENHMETAFILE; Size: Cardinal;
  [out] p3: array of TPaletteEntry): UINT; overload;
function GetEnhMetaFilePaletteEntries(Handle: HENHMETAFILE; Size: Cardinal;
  [out] p3: array of ColorRef): UINT; overload;
function GetEnhMetaFilePaletteEntries(Handle: HENHMETAFILE; Size: Cardinal;
  p3: IntPtr): UINT; overload;
function GetEnhMetaFilePixelFormat(Handle: HENHMETAFILE; p2: Cardinal;
  const p3: TPixelFormatDescriptor): UINT; 
function GetWinMetaFileBits(Handle: HENHMETAFILE; Size: Cardinal; [out] p3: array of Byte;
  p4: Integer; p5: HDC): UINT; overload;
function GetWinMetaFileBits(Handle: HENHMETAFILE; Size: Cardinal; p3: IntPtr;
  p4: Integer; p5: HDC): UINT; overload;
function PlayEnhMetaFile(DC: HDC; p2: HENHMETAFILE; const p3: TRect): BOOL;
function PlayEnhMetaFileRecord(DC: HDC; const p2: THandleTable;
  const p3: TEnhMetaRecord; p4: UINT): BOOL;
function SetEnhMetaFileBits(p1: UINT; [in] p2: TBytes): HENHMETAFILE; overload;
function SetEnhMetaFileBits(p1: UINT; p2: IntPtr): HENHMETAFILE; overload;
function SetWinMetaFileBits(p1: UINT; [in] p2: TBytes; p3: HDC;
  const p4: TMetaFilePict): HENHMETAFILE; overload;
function SetWinMetaFileBits(p1: UINT; [in] p2: TBytes; p3: HDC;
  p4: IntPtr): HENHMETAFILE; overload;
function GdiComment(DC: HDC; Size: Cardinal; p3: string): BOOL;
function GetTextMetrics(DC: HDC; out TM: TTextMetric): BOOL;
function GetTextMetricsA(DC: HDC; out TM: TTextMetricA): BOOL;
function GetTextMetricsW(DC: HDC; out TM: TTextMetricW): BOOL;

{ new GDI }

type
  tagDIBSECTION = packed record
    dsBm: TBitmap;
    dsBmih: TBitmapInfoHeader;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=3)]
    dsBitfields: array[0..2] of DWORD;
    dshSection: THandle;
    dsOffset: DWORD;
  end;
  TDIBSection = tagDIBSECTION;
  DIBSECTION = tagDIBSECTION;

function AngleArc(DC: HDC; p2, p3: Integer; p4: DWORD; p5, p6: Single): BOOL;
function PolyPolyline(DC: HDC; [in] PointStructs: array of TPoint; [in] Points: array of DWORD; p4: DWORD): BOOL;
function GetWorldTransform(DC: HDC; out p2: TXForm): BOOL;
function SetWorldTransform(DC: HDC; const p2: TXForm): BOOL;
function ModifyWorldTransform(DC: HDC; const p2: TXForm; p3: DWORD): BOOL;
function CombineTransform(out p1: TXForm; const p2, p3: TXForm): BOOL;
function CreateDIBSection(DC: HDC; const p2: TBitmapInfo; p3: UINT;
  out p4: IntPtr; p5: THandle; p6: DWORD): HBITMAP;
function GetDIBColorTable(DC: HDC; p2, p3: UINT; [out] RGBQuadStructs: array of COLORREF): UINT;
function SetDIBColorTable(DC: HDC; p2, p3: UINT; [in] RGBQuadStructs: array of COLORREF): UINT;

const
  { Flags value for COLORADJUSTMENT }
  CA_NEGATIVE = 1;
  CA_LOG_FILTER = 2;

  { IlluminantIndex values }
  ILLUMINANT_DEVICE_DEFAULT = 0;
  ILLUMINANT_A = 1;
  ILLUMINANT_B = 2;
  ILLUMINANT_C = 3;
  ILLUMINANT_D50 = 4;
  ILLUMINANT_D55 = 5;
  ILLUMINANT_D65 = 6;
  ILLUMINANT_D75 = 7;
  ILLUMINANT_F2 = 8;

  ILLUMINANT_MAX_INDEX = ILLUMINANT_F2;
  ILLUMINANT_TUNGSTEN = ILLUMINANT_A;
  ILLUMINANT_DAYLIGHT = ILLUMINANT_C;
  ILLUMINANT_FLUORESCENT = ILLUMINANT_F2;
  ILLUMINANT_NTSC = ILLUMINANT_C;

  { Min and max for RedGamma, GreenGamma, BlueGamma }
  RGB_GAMMA_MIN = 02500;
  RGB_GAMMA_MAX = 65000;

  { Min and max for ReferenceBlack and ReferenceWhite }
  REFERENCE_WHITE_MIN = 6000;
  REFERENCE_WHITE_MAX = 10000;
  REFERENCE_BLACK_MIN = 0;
  REFERENCE_BLACK_MAX = 4000;

  { Min and max for Contrast, Brightness, Colorfulness, RedGreenTint }
  COLOR_ADJ_MIN = -100;
  COLOR_ADJ_MAX = 100;

type
  tagCOLORADJUSTMENT = packed record
    caSize: Word;
    caFlags: Word;
    caIlluminantIndex: Word;
    caRedGamma: Word;
    caGreenGamma: Word;
    caBlueGamma: Word;
    caReferenceBlack: Word;
    caReferenceWhite: Word;
    caContrast: SHORT;
    caBrightness: SHORT;
    caColorfulness: SHORT;
    caRedGreenTint: SHORT;
  end;
  TColorAdjustment = tagCOLORADJUSTMENT;
  COLORADJUSTMENT = tagCOLORADJUSTMENT;

function SetColorAdjustment(DC: HDC; const p2: TColorAdjustment): BOOL;
function GetColorAdjustment(DC: HDC; out p2: TColorAdjustment): BOOL;
function CreateHalftonePalette(DC: HDC): HPALETTE;

type
  TFNAbortProc = function (DC: HDC; p2: Integer): BOOL;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  _DOCINFO = packed record
    cbSize: Integer;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDocName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszOutput: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDatatype: string;
    fwType: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  _DOCINFOA = packed record
    cbSize: Integer;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDocName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszOutput: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDatatype: string;
    fwType: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  _DOCINFOW = packed record
    cbSize: Integer;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDocName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszOutput: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDatatype: string;
    fwType: DWORD;
  end;
  TDocInfo = _DOCINFO;
  TDocInfoA = _DOCINFOA;
  TDocInfoW = _DOCINFOW;
  DOCINFOA = _DOCINFOA;
  DOCINFOW = _DOCINFOW;
  DOCINFO = _DOCINFO;

const
  DI_APPBANDING = 1;

function StartDoc(DC: HDC; const p2: TDocInfo): Integer;
function StartDocA(DC: HDC; const p2: TDocInfoA): Integer;
function StartDocW(DC: HDC; const p2: TDocInfoW): Integer;
function EndDoc(DC: HDC): Integer;
function StartPage(DC: HDC): Integer;
function EndPage(DC: HDC): Integer;
function AbortDoc(DC: HDC): Integer;
function SetAbortProc(DC: HDC; lpAbortProc: TFNAbortProc): Integer;
function AbortPath(DC: HDC): BOOL;
function ArcTo(DC: HDC; RLeft, RTop, RRight, RBottom: Integer;
  X1, Y1, X2, Y2: Integer): BOOL;
function BeginPath(DC: HDC): BOOL;
function CloseFigure(DC: HDC): BOOL;
function EndPath(DC: HDC): BOOL;
function FillPath(DC: HDC): BOOL;
function FlattenPath(DC: HDC): BOOL;
function GetPath(DC: HDC; [out] Points: array of TPoint;
  [out] Types: array of Byte; nSize: Integer): Integer;
function PathToRegion(DC: HDC): HRGN;
function PolyDraw(DC: HDC; const Points, Types; cCount: Integer): BOOL;
function SelectClipPath(DC: HDC; Mode: Integer): BOOL;
function SetArcDirection(DC: HDC; Direction: Integer): Integer;
function SetMiterLimit(DC: HDC; NewLimit: Single; out OldLimit: Single): BOOL; overload;
function SetMiterLimit(DC: HDC; NewLimit: Single; OldLimit: IntPtr): BOOL; overload;
function StrokeAndFillPath(DC: HDC): BOOL;
function StrokePath(DC: HDC): BOOL;
function WidenPath(DC: HDC): BOOL;
function ExtCreatePen(PenStyle, Width: DWORD; const Brush: TLogBrush;
  StyleCount: DWORD; [in] Style: array of DWORD): HPEN; overload;
function ExtCreatePen(PenStyle, Width: DWORD; const Brush: TLogBrush;
  StyleCount: DWORD; Style: IntPtr): HPEN; overload;
function GetMiterLimit(DC: HDC; out Limit: Single): BOOL;
function GetArcDirection(DC: HDC): Integer;
function GetObject(Handle: HGDIOBJ; cbBuffer: Integer; out lpvObject: TLogFont): Integer; overload;
function GetObject(Handle: HGDIOBJ; cbBuffer: Integer; out lpvObject: TBitmap): Integer; overload;
function GetObject(Handle: HGDIOBJ; cbBuffer: Integer; out lpvObject: TDIBSection): Integer; overload;
function GetObject(Handle: HGDIOBJ; cbBuffer: Integer; out lpvObject: Integer): Integer; overload;
function GetObject(Handle: HGDIOBJ; cbBuffer: Integer; lpvObject: IntPtr): Integer; overload;
function GetObjectA(Handle: HGDIOBJ; cbBuffer: Integer; lpvObject: IntPtr): Integer;
function GetObjectW(Handle: HGDIOBJ; cbBuffer: Integer; lpvObject: IntPtr): Integer;
function MoveToEx(DC: HDC; X, Y: Integer; out lpPoint: TPoint): BOOL; overload;
function MoveToEx(DC: HDC; X, Y: Integer; lpPoint: IntPtr): BOOL; overload;
function TextOut(DC: HDC; X, Y: Integer; Str: string; Count: Integer): BOOL;
function TextOutA(DC: HDC; X, Y: Integer; Str: string; Count: Integer): BOOL;
function TextOutW(DC: HDC; X, Y: Integer; Str: string; Count: Integer): BOOL;
function ExtTextOut(DC: HDC; X, Y: Integer; Options: Longint;
  const Rect: TRect; Str: string; Count: Longint; [in] Dx: TIntegerDynArray): BOOL; overload;
function ExtTextOut(DC: HDC; X, Y: Integer; Options: Longint;
  Rect: IntPtr; Str: string; Count: Longint; [in] Dx: TIntegerDynArray): BOOL; overload;
function ExtTextOut(DC: HDC; X, Y: Integer; Options: Longint;
  const Rect: TRect; Str: IntPtr; Count: Longint; Dx: IntPtr): BOOL; overload;
function ExtTextOutA(DC: HDC; X, Y: Integer; Options: Longint;
  const Rect: TRect; Str: string; Count: Longint; [in] Dx: TIntegerDynArray): BOOL;
function ExtTextOutW(DC: HDC; X, Y: Integer; Options: Longint;
  const Rect: TRect; Str: string; Count: Longint; [in] Dx: TIntegerDynArray): BOOL;
function PolyTextOut(DC: HDC; [in] pptxt: array of TPolyText; cStrings: Integer): BOOL;
function PolyTextOutA(DC: HDC; [in] pptxt: array of TPolyTextA; cStrings: Integer): BOOL;
function PolyTextOutW(DC: HDC; [in] pptxt: array of TPolyTextW; cStrings: Integer): BOOL;
function CreatePolygonRgn([in] Points: array of TPoint; Count, FillMode: Integer): HRGN;
function DPtoLP(DC: HDC; [in, out] Points: array of TPoint; Count: Integer): BOOL;
function LPtoDP(DC: HDC; [in, out] Points: array of TPoint; Count: Integer): BOOL;
function Polygon(DC: HDC; [in] Points: array of TPoint; Count: Integer): BOOL;
function Polyline(DC: HDC; [in] Points: array of TPoint; Count: Integer): BOOL;
function PolyBezier(DC: HDC; [in] Points: array of TPoint; Count: DWORD): BOOL;
function PolyBezierTo(DC: HDC; [in] Points: array of TPoint; Count: DWORD): BOOL;
function PolyLineTo(DC: HDC; [in] Points: array of TPoint; Count: DWORD): BOOL;
function SetViewportExtEx(DC: HDC; XExt, YExt: Integer; out Size: TSize): BOOL; overload;
function SetViewportExtEx(DC: HDC; XExt, YExt: Integer; Size: IntPtr): BOOL; overload;
function SetViewportOrgEx(DC: HDC; X, Y: Integer; out Point: TPoint): BOOL; overload;
function SetViewportOrgEx(DC: HDC; X, Y: Integer; Point: IntPtr): BOOL; overload;
function SetWindowExtEx(DC: HDC; XExt, YExt: Integer; out Size: TSize): BOOL; overload;
function SetWindowExtEx(DC: HDC; XExt, YExt: Integer; Size: IntPtr): BOOL; overload;
function SetWindowOrgEx(DC: HDC; X, Y: Integer; out Point: TPoint): BOOL; overload;
function SetWindowOrgEx(DC: HDC; X, Y: Integer; Point: IntPtr): BOOL; overload;
function OffsetViewportOrgEx(DC: HDC; X, Y: Integer; out Point: TPoint): BOOL; overload;
function OffsetViewportOrgEx(DC: HDC; X, Y: Integer; Point: IntPtr): BOOL; overload;
function OffsetWindowOrgEx(DC: HDC; X, Y: Integer; out Point: TPoint): BOOL; overload;
function OffsetWindowOrgEx(DC: HDC; X, Y: Integer; Point: IntPtr): BOOL; overload;
function ScaleViewportExtEx(DC: HDC; XM, XD, YM, YD: Integer; out Size: TSize): BOOL; overload;
function ScaleViewportExtEx(DC: HDC; XM, XD, YM, YD: Integer; Size: IntPtr): BOOL; overload;
function ScaleWindowExtEx(DC: HDC; XM, XD, YM, YD: Integer; out Size: TSize): BOOL; overload;
function ScaleWindowExtEx(DC: HDC; XM, XD, YM, YD: Integer; Size: IntPtr): BOOL; overload;
function SetBitmapDimensionEx(hBitmap: HBITMAP; Width, Height: Integer; out Size: TSize): BOOL; overload;
function SetBitmapDimensionEx(hBitmap: HBITMAP; Width, Height: Integer; Size: IntPtr): BOOL; overload;
function SetBrushOrgEx(DC: HDC; X, Y: Integer; out PrevPt: TPoint): BOOL; overload;
function SetBrushOrgEx(DC: HDC; X, Y: Integer; PrevPt: IntPtr): BOOL; overload;
function GetTextFace(DC: HDC; Count: Integer; Buffer: StringBuilder): Integer;
function GetTextFaceA(DC: HDC; Count: Integer; Buffer: StringBuilder): Integer;
function GetTextFaceW(DC: HDC; Count: Integer; Buffer: StringBuilder): Integer;

const
  FONTMAPPER_MAX = 10;

type
  tagKERNINGPAIR = packed record
    wFirst: Word;
    wSecond: Word;
    iKernAmount: Integer;
  end;
  TKerningPair = tagKERNINGPAIR;
  KERNINGPAIR = tagKERNINGPAIR;

function GetKerningPairs(DC: HDC; Count: DWORD; [out] KerningPairs: array of TKerningPair): DWORD; overload;
function GetKerningPairs(DC: HDC; Count: DWORD; KerningPairs: IntPtr): DWORD; overload;
function GetDCOrgEx(DC: HDC; out Origin: TPoint): BOOL;
function UnrealizeObject(hGDIObj: HGDIOBJ): BOOL;
function GdiFlush: BOOL;
function GdiSetBatchLimit(Limit: DWORD): DWORD;
function GdiGetBatchLimit: DWORD;

const
  ICM_OFF = 1;
  ICM_ON = 2;
  ICM_QUERY = 3;

  ICM_ADDPROFILE = 1; { removed in 4.0 SDK }
  ICM_DELETEPROFILE = 2; { removed in 4.0 SDK }
  ICM_QUERYPROFILE = 3; { removed in 4.0 SDK }
  ICM_SETDEFAULTPROFILE = 4; { removed in 4.0 SDK }
  ICM_REGISTERICMATCHER = 5; { removed in 4.0 SDK }
  ICM_UNREGISTERICMATCHER = 6; { removed in 4.0 SDK }
  ICM_QUERYMATCH = 7; { removed in 4.0 SDK }

type
  TDeviceGammaRamp = packed record
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=256)]
    Red: array[Byte] of Word;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=256)]
    Green: array[Byte] of Word;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=256)]
    Blue: array[Byte] of Word;
  end;

function SetICMMode(DC: HDC; Mode: Integer): Integer;
function CheckColorsInGamut(DC: HDC; RGBQuads: array of TRGBTriple;
  Results: array of Byte; Count: DWORD): BOOL;
function GetColorSpace(DC: HDC): THandle;
function GetLogColorSpace(p1: HCOLORSPACE; var ColorSpace: TLogColorSpace; Size: DWORD): BOOL;
function GetLogColorSpaceA(p1: HCOLORSPACE; var ColorSpace: TLogColorSpaceA; Size: DWORD): BOOL;
function GetLogColorSpaceW(p1: HCOLORSPACE; var ColorSpace: TLogColorSpaceW; Size: DWORD): BOOL;
function CreateColorSpace(var ColorSpace: TLogColorSpace): HCOLORSPACE;
function CreateColorSpaceA(var ColorSpace: TLogColorSpaceA): HCOLORSPACE;
function CreateColorSpaceW(var ColorSpace: TLogColorSpaceW): HCOLORSPACE;
function SetColorSpace(DC: HDC; ColorSpace: HCOLORSPACE): BOOL;
function DeleteColorSpace(ColorSpace: HCOLORSPACE): BOOL;
function GetICMProfile(DC: HDC; var Size: DWORD; Name: StringBuilder): BOOL;
function GetICMProfileA(DC: HDC; var Size: DWORD; Name: StringBuilder): BOOL;
function GetICMProfileW(DC: HDC; var Size: DWORD; Name: StringBuilder): BOOL;
function SetICMProfile(DC: HDC; Name: string): BOOL;
function SetICMProfileA(DC: HDC; Name: string): BOOL;
function SetICMProfileW(DC: HDC; Name: string): BOOL;
function GetDeviceGammaRamp(DC: HDC; var Ramp: TDeviceGammaRamp): BOOL; 
function SetDeviceGammaRamp(DC: HDC; const Ramp: TDeviceGammaRamp): BOOL;
function ColorMatchToTarget(DC: HDC; Target: HDC; Action: DWORD): BOOL;

type
  TFNICMEnumProc = function (p1: string; p2: LPARAM): Integer;

function EnumICMProfiles(DC: HDC; ICMProc: TFNICMEnumProc; p3: LPARAM): Integer;
function EnumICMProfilesA(DC: HDC; ICMProc: TFNICMEnumProc; p3: LPARAM): Integer;
function EnumICMProfilesW(DC: HDC; ICMProc: TFNICMEnumProc; p3: LPARAM): Integer;

function UpdateICMRegKey(p1: DWORD; p2, p3: string; p4: UINT): BOOL;
function UpdateICMRegKeyA(p1: DWORD; p2, p3: string; p4: UINT): BOOL;
function UpdateICMRegKeyW(p1: DWORD; p2, p3: string; p4: UINT): BOOL;

function ColorCorrectPalette(DC: HDC; p2: HPALETTE; p3, p4: DWORD): BOOL;

const
  ENHMETA_SIGNATURE = $464D4520;  { Enhanced metafile constants. }

{ Stock object flag used in the object handle index in the enhanced
  metafile records.
  E.g. The object handle index (META_STOCK_OBJECT or BLACK_BRUSH)
  represents the stock object BLACK_BRUSH. }

  ENHMETA_STOCK_OBJECT = DWORD($80000000);

{ Enhanced metafile record types.}

  EMR_HEADER = 1;
  EMR_POLYBEZIER = 2;
  EMR_POLYGON = 3;
  EMR_POLYLINE = 4;
  EMR_POLYBEZIERTO = 5;
  EMR_POLYLINETO = 6;
  EMR_POLYPOLYLINE = 7;
  EMR_POLYPOLYGON = 8;
  EMR_SETWINDOWEXTEX = 9;
  EMR_SETWINDOWORGEX = 10;
  EMR_SETVIEWPORTEXTEX = 11;
  EMR_SETVIEWPORTORGEX = 12;
  EMR_SETBRUSHORGEX = 13;
  EMR_EOF = 14;
  EMR_SETPIXELV = 15;
  EMR_SETMAPPERFLAGS = $10;
  EMR_SETMAPMODE = 17;
  EMR_SETBKMODE = 18;
  EMR_SETPOLYFILLMODE = 19;
  EMR_SETROP2 = 20;
  EMR_SETSTRETCHBLTMODE = 21;
  EMR_SETTEXTALIGN = 22;
  EMR_SETCOLORADJUSTMENT = 23;
  EMR_SETTEXTCOLOR = 24;
  EMR_SETBKCOLOR = 25;
  EMR_OFFSETCLIPRGN = 26;
  EMR_MOVETOEX = 27;
  EMR_SETMETARGN = 28;
  EMR_EXCLUDECLIPRECT = 29;
  EMR_INTERSECTCLIPRECT = 30;
  EMR_SCALEVIEWPORTEXTEX = 31;
  EMR_SCALEWINDOWEXTEX = 32;
  EMR_SAVEDC = 33;
  EMR_RESTOREDC = 34;
  EMR_SETWORLDTRANSFORM = 35;
  EMR_MODIFYWORLDTRANSFORM = 36;
  EMR_SELECTOBJECT = 37;
  EMR_CREATEPEN = 38;
  EMR_CREATEBRUSHINDIRECT = 39;
  EMR_DELETEOBJECT = 40;
  EMR_ANGLEARC = 41;
  EMR_ELLIPSE = 42;
  EMR_RECTANGLE = 43;
  EMR_ROUNDRECT = 44;
  EMR_ARC = 45;
  EMR_CHORD = 46;
  EMR_PIE = 47;
  EMR_SELECTPALETTE = 48;
  EMR_CREATEPALETTE = 49;
  EMR_SETPALETTEENTRIES = 50;
  EMR_RESIZEPALETTE = 51;
  EMR_REALIZEPALETTE = 52;
  EMR_EXTFLOODFILL = 53;
  EMR_LINETO = 54;
  EMR_ARCTO = 55;
  EMR_POLYDRAW = 56;
  EMR_SETARCDIRECTION = 57;
  EMR_SETMITERLIMIT = 58;
  EMR_BEGINPATH = 59;
  EMR_ENDPATH = 60;
  EMR_CLOSEFIGURE = 61;
  EMR_FILLPATH = 62;
  EMR_STROKEANDFILLPATH = 63;
  EMR_STROKEPATH = $40;
  EMR_FLATTENPATH = 65;
  EMR_WIDENPATH = 66;
  EMR_SELECTCLIPPATH = 67;
  EMR_ABORTPATH = 68;

  EMR_GDICOMMENT = 70;
  EMR_FILLRGN = 71;
  EMR_FRAMERGN = 72;
  EMR_INVERTRGN = 73;
  EMR_PAINTRGN = 74;
  EMR_EXTSELECTCLIPRGN = 75;
  EMR_BITBLT = 76;
  EMR_STRETCHBLT = 77;
  EMR_MASKBLT = 78;
  EMR_PLGBLT = 79;
  EMR_SETDIBITSTODEVICE = 80;
  EMR_STRETCHDIBITS = 81;
  EMR_EXTCREATEFONTINDIRECTW = 82;
  EMR_EXTTEXTOUTA = 83;
  EMR_EXTTEXTOUTW = 84;
  EMR_POLYBEZIER16 = 85;
  EMR_POLYGON16 = 86;
  EMR_POLYLINE16 = 87;
  EMR_POLYBEZIERTO16 = 88;
  EMR_POLYLINETO16 = 89;
  EMR_POLYPOLYLINE16 = 90;
  EMR_POLYPOLYGON16 = 91;
  EMR_POLYDRAW16 = 92;
  EMR_CREATEMONOBRUSH = 93;
  EMR_CREATEDIBPATTERNBRUSHPT = 94;
  EMR_EXTCREATEPEN = 95;
  EMR_POLYTEXTOUTA = 96;
  EMR_POLYTEXTOUTW = 97;
  EMR_SETICMMODE = 98;
  EMR_CREATECOLORSPACE = 99;
  EMR_SETCOLORSPACE = 100;
  EMR_DELETECOLORSPACE = 101;
  EMR_GLSRECORD = 102;
  EMR_GLSBOUNDEDRECORD = 103;
  EMR_PIXELFORMAT = 104;
  EMR_DRAWESCAPE = 105;
  EMR_EXTESCAPE = 106;
  EMR_STARTDOC = 107;
  EMR_SMALLTEXTOUT = 108;
  EMR_FORCEUFIMAPPING = 109;
  EMR_NAMEDESCAPE = 110;
  EMR_COLORCORRECTPALETTE = 111;
  EMR_SETICMPROFILEA = 112;
  EMR_SETICMPROFILEW = 113;
  EMR_ALPHABLEND = 114;
  EMR_ALPHADIBBLEND = 115;
  EMR_TRANSPARENTBLT = 116;
  EMR_TRANSPARENTDIB = 117;
  EMR_GRADIENTFILL = 118;
  EMR_SETLINKEDUFIS = 119;
  EMR_SETTEXTJUSTIFICATION = 120;
  EMR_MAX = 120;
  EMR_MIN = 1;


type
  { Base record type for the enhanced metafile.}
  tagEMR = packed record
    iType: DWORD; { Enhanced metafile record type}
    nSize: DWORD; { Length of the record in bytes.}
                  { This must be a multiple of 4.}
  end;
  TEMR = tagEMR;
  EMR = tagEMR;

  { Base text record type for the enhanced metafile.}
  tagEMRTEXT = packed record
    ptlReference: TPoint;
    nChars: DWORD;
    offString: DWORD; { Offset to the string}
    fOptions: DWORD;
    rcl: TRect;
    offDx: DWORD;     { Offset to the inter-character spacing array.}
                      { This is always given.}
  end;
  TEMRText = tagEMRTEXT;
  EMRTEXT = tagEMRTEXT;


  { Record structures for the enhanced metafile.}
  tagABORTPATH = packed record
    emr: TEMR;
  end;
  TAbortPath = tagABORTPATH;
  EMRABORTPATH = tagABORTPATH;
  TEMRAbortPath = TAbortPath;
  TEMRBeginPath = TAbortPath;
  TEMREndPath = TAbortPath;
  TEMRCloseFigure = TAbortPath;
  TEMRFlattenPath = TAbortPath;
  TEMRWidenPath = TAbortPath;
  TEMRSetMetaRgn = TAbortPath;
  TEMRSaveDC = TAbortPath;
  TEMRRealizePalette = TAbortPath;

  tagEMRSELECTCLIPPATH = packed record
    emr: TEMR;
    iMode: DWORD;
  end;
  TEMRSelectClipPath = tagEMRSELECTCLIPPATH;
  EMRSELECTCLIPPATH = tagEMRSELECTCLIPPATH;
  TEMRSetBkMode = TEMRSelectClipPath;
  TEMRSetMapMode = TEMRSelectClipPath;
  TEMRSetPolyFillMode = TEMRSelectClipPath;
  TEMRSetRop2 = TEMRSelectClipPath;
  TEMRSetStretchBltMode = TEMRSelectClipPath;
  TEMRSetICMMode = TEMRSelectClipPath;
  TEMRSetTextAlign = TEMRSelectClipPath;

  tagEMRSETMITERLIMIT = packed record
    emr: TEMR;
    eMiterLimit: Single;
  end;
  TEMRSetMiterLimit = tagEMRSETMITERLIMIT;
  EMRSETMITERLIMIT = tagEMRSETMITERLIMIT;

  tagEMRRESTOREDC = packed record
    emr: TEMR;
    iRelative: Longint;   { Specifies a relative instance}
  end;
  TEMRRestoreDC = tagEMRRESTOREDC;
  EMRRESTOREDC = tagEMRRESTOREDC;

  tagEMRSETARCDIRECTION = packed record
    emr: TEMR;
    iArcDirection: DWORD; { Specifies the arc direction in the advanced graphics mode.}
  end;
  TEMRSetArcDirection = tagEMRSETARCDIRECTION;
  EMRSETARCDIRECTION = tagEMRSETARCDIRECTION;

  tagEMRSETMAPPERFLAGS = packed record
    emr: TEMR;
    dwFlags: DWORD;
  end;
  TEMRSetMapperFlags = tagEMRSETMAPPERFLAGS;
  EMRSETMAPPERFLAGS = tagEMRSETMAPPERFLAGS;

  tagEMRSETTEXTCOLOR = packed record
    emr: TEMR;
    crColor: COLORREF;
  end;
  TEMRSetTextColor = tagEMRSETTEXTCOLOR;
  EMRSETTEXTCOLOR = tagEMRSETTEXTCOLOR;
  TEMRSetBkColor = TEMRSetTextColor;

  tagEMRSELECTOBJECT = packed record
    emr: TEMR;
    ihObject: DWORD;   { Object handle index }
  end;
  TEMRSelectObject = tagEMRSELECTOBJECT;
  EMRSELECTOBJECT = tagEMRSELECTOBJECT;
  EMRDeleteObject = TEMRSelectObject;

  tagEMRSETCOLORSPACE = packed record
    emr: TEMR;
    ihCS: DWORD;  { ColorSpace handle index }
  end;
  TEMRSelectColorSpace = tagEMRSETCOLORSPACE;
  EMRSELECTCOLORSPACE = tagEMRSETCOLORSPACE;
  EMRDeleteColorSpace = TEMRSelectColorSpace;

  tagEMRSELECTPALETTE = packed record
    emr: TEMR;
    ihPal: DWORD;   { Palette handle index, background mode only }
  end;
  TEMRSelectPalette = tagEMRSELECTPALETTE;
  EMRSELECTPALETTE = tagEMRSELECTPALETTE;

  tagEMRRESIZEPALETTE = packed record
    emr: TEMR;
    ihPal: DWORD;   { Palette handle index }
    cEntries: DWORD;
  end;
  TEMRResizePalette = tagEMRRESIZEPALETTE;
  EMRRESIZEPALETTE = tagEMRRESIZEPALETTE;

  tagEMRSETPALETTEENTRIES = packed record
    emr: TEMR;
    ihPal: DWORD;      { Palette handle index }
    iStart: DWORD;
    cEntries: DWORD;
    aPalEntries: array[0..0] of TPaletteEntry; { The peFlags fields do not contain any flags }
  end;
  TEMRSetPaletteEntries = tagEMRSETPALETTEENTRIES;
  EMRSETPALETTEENTRIES = tagEMRSETPALETTEENTRIES;

  tagEMRSETCOLORADJUSTMENT = packed record
    emr: TEMR;
    ColorAdjustment: TColorAdjustment;
  end;
  TEMRSetColorAdjustment = tagEMRSETCOLORADJUSTMENT;
  EMRSETCOLORADJUSTMENT = tagEMRSETCOLORADJUSTMENT;

  [StructLayout(LayoutKind.Sequential)]
  tagEMRGDICOMMENT = record
    emr: TEMR;
    cbData: DWORD;   { Size of data in bytes}
    Data: IntPtr; { array[0..0] of Byte }
  end;
  TEMRGDIComment = tagEMRGDICOMMENT;
  EMRGDICOMMENT = tagEMRGDICOMMENT;

  tagEMREOF = packed record
    emr: TEMR;
    nPalEntries: DWORD;   { Number of palette entries }
    offPalEntries: DWORD; { Offset to the palette entries }
    nSizeLast: DWORD;     { Same as nSize and must be the last DWORD }
                          { of the record.  The palette entries, }
                          { if exist, precede this field. }
  end;
  TEMREOF = tagEMREOF;
  EMREOF = tagEMREOF;

  tagEMRLINETO = packed record
    emr: TEMR;
    ptl: TPoint;
  end;
  TEMRLineTo = tagEMRLINETO;
  EMRLINETO = tagEMRLINETO;
  EMRMoveToEx = TEMRLineTo;

  tagEMROFFSETCLIPRGN = packed record
    emr: TEMR;
    ptlOffset: TPoint;
  end;
  TEMROffsetClipRgn = tagEMROFFSETCLIPRGN;
  EMROFFSETCLIPRGN = tagEMROFFSETCLIPRGN;

  tagEMRFILLPATH = packed record
    emr: TEMR;
    rclBounds: TRect; { Inclusive-inclusive bounds in device units}
  end;
  TEMRFillPath = tagEMRFILLPATH;
  EMRFILLPATH = tagEMRFILLPATH;
  EMRStrokeAndFillPath = TEMRFillPath;
  EMRStrokePath = TEMRFillPath;

  tagEMREXCLUDECLIPRECT = packed record
    emr: TEMR;
    rclClip: TRect;
  end;
  TEMRExcludeClipRect = tagEMREXCLUDECLIPRECT;
  EMREXCLUDECLIPRECT = tagEMREXCLUDECLIPRECT;
  EMRIntersectClipRect = TEMRExcludeClipRect;

  tagEMRSETVIEWPORTORGEX = packed record
    emr: TEMR;
    ptlOrigin: TPoint;
  end;
  TEMRSetViewportOrgEx = tagEMRSETVIEWPORTORGEX;
  EMRSETVIEWPORTORGEX = tagEMRSETVIEWPORTORGEX;
  EMRSetWindowOrgEx = TEMRSetViewportOrgEx;
  EMRSetBrushOrgEx = TEMRSetViewportOrgEx;

  tagEMRSETVIEWPORTEXTEX = packed record
    emr: TEMR;
    szlExtent: TSize;
  end;
  TEMRSetViewportExtEx = tagEMRSETVIEWPORTEXTEX;
  EMRSETVIEWPORTEXTEX = tagEMRSETVIEWPORTEXTEX;
  EMRSetWindowExtEx = TEMRSetViewportExtEx;

  tagEMRSCALEVIEWPORTEXTEX = packed record
    emr: TEMR;
    xNum: Longint;
    xDenom: Longint;
    yNum: Longint;
    yDenom: Longint;
  end;
  TEMRScaleViewportExtEx = tagEMRSCALEVIEWPORTEXTEX;
  EMRSCALEVIEWPORTEXTEX = tagEMRSCALEVIEWPORTEXTEX;
  EMRScaleWindowExtEx = TEMRScaleViewportExtEx;

  tagEMRSETWORLDTRANSFORM = packed record
    emr: TEMR;
    xform: TXForm;
  end;
  TEMRSetWorldTransform = tagEMRSETWORLDTRANSFORM;
  EMRSETWORLDTRANSFORM = tagEMRSETWORLDTRANSFORM;

  tagEMRMODIFYWORLDTRANSFORM = packed record
    emr: TEMR;
    xform: TXForm;
    iMode: DWORD;
  end;
  TEMRModifyWorldTransform = tagEMRMODIFYWORLDTRANSFORM;
  EMRMODIFYWORLDTRANSFORM = tagEMRMODIFYWORLDTRANSFORM;

  tagEMRSETPIXELV = packed record
    emr: TEMR;
    ptlPixel: TPoint;
    crColor: COLORREF;
  end;
  TEMRSetPixelV = tagEMRSETPIXELV;
  EMRSETPIXELV = tagEMRSETPIXELV;

  tagEMREXTFLOODFILL = packed record
    emr: TEMR;
    ptlStart: TPoint;
    crColor: COLORREF;
    iMode: DWORD;
  end;
  TEMRExtFloodFill = tagEMREXTFLOODFILL;
  EMREXTFLOODFILL = tagEMREXTFLOODFILL;

  tagEMRELLIPSE = packed record
    emr: TEMR;
    rclBox: TRect; { Inclusive-inclusive bounding rectangle}
  end;
  TEMREllipse = tagEMRELLIPSE;
  EMRELLIPSE = tagEMRELLIPSE;
  EMRRectangle = TEMREllipse;

  tagEMRROUNDRECT = packed record
    emr: TEMR;
    rclBox: TRect;     { Inclusive-inclusive bounding rectangle }
    szlCorner: TSize;
  end;
  TEMRRoundRect = tagEMRROUNDRECT;
  EMRROUNDRECT = tagEMRROUNDRECT;

  tagEMRARC = packed record
    emr: TEMR;
    rclBox: TRect;     { Inclusive-inclusive bounding rectangle }
    ptlStart: TPoint;
    ptlEnd: TPoint;
  end;
  TEMRArc = tagEMRARC;
  EMRARC = tagEMRARC;
  EMRArcTo = TEMRArc;
  EMRChord = TEMRArc;
  EMRPie = TEMRArc;

  tagEMRANGLEARC = packed record
    emr: TEMR;
    ptlCenter: TPoint;
    nRadius: DWORD;
    eStartAngle: Single;
    eSweepAngle: Single;
  end;
  TEMRAngleArc = tagEMRANGLEARC;
  EMRANGLEARC = tagEMRANGLEARC;

  tagEMRPOLYLINE = packed record
    emr: TEMR;
    rclBounds: TRect;    { Inclusive-inclusive bounds in device units }
    cptl: DWORD;
    aptl: IntPtr; { array[0..0] of TPoint }
  end;
  TEMRPolyline = tagEMRPOLYLINE;
  EMRPOLYLINE = tagEMRPOLYLINE;
  EMRPolyBezier = TEMRPolyLine;
  EMRPolyGON = TEMRPolyLine;
  EMRPolyBezierTo = TEMRPolyLine;
  EMRPolyLineTo = TEMRPolyLine;

  tagEMRPOLYLINE16 = packed record
    emr: TEMR;
    rclBounds: TRect; { Inclusive-inclusive bounds in device units}
    cpts: DWORD;
    apts: IntPtr; { array[0..0] of TSmallPoint }
  end;
  TEMRPolyline16 = tagEMRPOLYLINE16;
  EMRPOLYLINE16 = tagEMRPOLYLINE16;
  EMRPolyBezier16 = TEMRPolyLine16;
  EMRPolygon16 = TEMRPolyLine16;
  EMRPolyBezierTo16 = TEMRPolyLine16;
  EMRPolyLineTo16 = TEMRPolyLine16;

  [StructLayout(LayoutKind.Sequential)]
  tagEMRPOLYDRAW = record
    emr: TEMR;
    rclBounds: TRect;    { Inclusive-inclusive bounds in device units}
    cptl: DWORD;         { Number of points}
    aptl: IntPtr;        { array[0..0] of TPoint } {Array of points}
    abTypes: IntPtr;     { array[0..0] of Byte   } {Array of point types}
  end;
  TEMRPolyDraw = tagEMRPOLYDRAW;
  EMRPOLYDRAW = tagEMRPOLYDRAW;

  [StructLayout(LayoutKind.Sequential)]
  tagEMRPOLYDRAW16 = record
    emr: TEMR;
    rclBounds: TRect;
    cpts: DWORD;
    apts: IntPtr;    { array[0..0] of TSmallPoint }
    abTypes: IntPtr; { array[0..0] of Byte }
  end;
  TEMRPolyDraw16 = tagEMRPOLYDRAW16;
  EMRPOLYDRAW16 = tagEMRPOLYDRAW16;

  tagEMRPOLYPOLYLINE = packed record
    emr: TEMR;
    rclBounds: TRect; { Inclusive-inclusive bounds in device units}
    nPolys: DWORD;    { Number of polys}
    cptl: DWORD;      { Total number of points in all polys}
    aPolyCounts: IntPtr; { array[0..0] of DWORD  } { Array of point counts for each poly}
    aptl: IntPtr;        { array[0..0] of TPoint } { Array of points}
  end;
  TEMRPolyPolyline = tagEMRPOLYPOLYLINE;
  EMRPOLYPOLYLINE = tagEMRPOLYPOLYLINE;
  EMRPolyPolygon = TEMRPolyPolyline;

  tagEMRPOLYPOLYLINE16 = packed record
    emr: TEMR;
    rclBounds: TRect;
    nPolys: DWORD;
    cpts: DWORD;
    aPolyCounts: IntPtr; { array[0..0] of DWORD }
    apts: IntPtr;        { array[0..0] of TSmallPoint }
  end;
  TEMRPolyPolyline16 = tagEMRPOLYPOLYLINE16;
  EMRPOLYPOLYLINE16 = tagEMRPOLYPOLYLINE16;
  EMRPolyPolygon16 = TEMRPolyPolyline16;

  [StructLayout(LayoutKind.Sequential)]
  tagEMRINVERTRGN = record
    emr: TEMR;
    rclBounds: TRect; { Inclusive-inclusive bounds in device units }
    cbRgnData: DWORD; { Size of region data in bytes}
    RgnData: IntPtr;  { array[0..0] of Byte }
  end;
  TEMRInvertRgn = tagEMRINVERTRGN;
  EMRINVERTRGN = tagEMRINVERTRGN;
  EMRPaintRgn = TEMRInvertRgn;

  [StructLayout(LayoutKind.Sequential)]
  tagEMRFILLRGN = record
    emr: TEMR;
    rclBounds: TRect;  { Inclusive-inclusive bounds in device units}
    cbRgnData: DWORD;  { Size of region data in bytes}
    ihBrush: DWORD;    { Brush handle index }
    RgnData: IntPtr;   { array[0..0] of Byte }
  end;
  TEMRFillRgn = tagEMRFILLRGN;
  EMRFILLRGN = tagEMRFILLRGN;

  [StructLayout(LayoutKind.Sequential)]
  tagEMRFRAMERGN = record
    emr: TEMR;
    rclBounds: TRect;   { Inclusive-inclusive bounds in device units}
    cbRgnData: DWORD;   { Size of region data in bytes}
    ihBrush: DWORD;     { Brush handle index}
    szlStroke: TSize;
    RgnData: IntPtr;    { array[0..0] of Byte }
  end;
  TEMRFrameRgn = tagEMRFRAMERGN;
  EMRFRAMERGN = tagEMRFRAMERGN;

  [StructLayout(LayoutKind.Sequential)]
  tagEMRGRADIENTFILL = record
    emr: TEMR;
    rclBounds: TRect;   { Inclusive-inclusive bounds in device units}
    nVer: DWORD;
    nTri: DWORD;
    ulMode: ULONG;
    Ver: IntPtr;   { array[0..0] of TTriVertex }
  end;
  TEMGradientFill = tagEMRGRADIENTFILL;
  EMRGRADIENTFILL = tagEMRGRADIENTFILL;

  [StructLayout(LayoutKind.Sequential)]
  tagEMREXTSELECTCLIPRGN = record
    emr: TEMR;
    cbRgnData: DWORD; { Size of region data in bytes}
    iMode: DWORD;
    RgnData: IntPtr;  { array[0..0] of Byte }
  end;
  TEMRExtSelectClipRgn = tagEMREXTSELECTCLIPRGN;
  EMREXTSELECTCLIPRGN = tagEMREXTSELECTCLIPRGN;

  tagEMREXTTEXTOUTA = packed record
    emr: TEMR;
    rclBounds: TRect;     { Inclusive-inclusive bounds in device units}
    iGraphicsMode: DWORD; { Current graphics mode}
    exScale: Single;       { X and Y scales from Page units to .01mm units}
    eyScale: Single;       {   if graphics mode is GM_COMPATIBLE.}
    emrtext: TEMRText;    { This is followed by the string and spacing array}
  end;
  TEMRExtTextOut = tagEMREXTTEXTOUTA;
  EMREXTTEXTOUTA = tagEMREXTTEXTOUTA;

  tagEMRPOLYTEXTOUTA = packed record
    emr: TEMR;
    rclBounds: TRect;     { Inclusive-inclusive bounds in device units}
    iGraphicsMode: DWORD; { Current graphics mode}
    exScale: Single;       { X and Y scales from Page units to .01mm units}
    eyScale: Single;       {   if graphics mode is GM_COMPATIBLE.}
    cStrings: Longint;
    aemrtext: IntPtr; { array[0..0] of TEMRText } { array of TEMRText structures.  This is}
                                                  { followed by the strings and spacing arrays.}
  end;
  TEMRPolyTextOut = tagEMRPOLYTEXTOUTA;
  EMRPOLYTEXTOUTA = tagEMRPOLYTEXTOUTA;

  tagEMRBITBLT = packed record
    emr: TEMR;
    rclBounds: TRect;        { Inclusive-inclusive bounds in device units}
    xDest: Longint;
    yDest: Longint;
    cxDest: Longint;
    cyDest: Longint;
    dwRop: DWORD;
    xSrc: Longint;
    ySrc: Longint;
    xformSrc: TXForm;        { Source DC transform}
    crBkColorSrc: COLORREF; { Source DC BkColor in RGB}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
                             { (DIB_RGB_COLORS)}
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
  end;
  TEMRBitBlt = tagEMRBITBLT;
  EMRBITBLT = tagEMRBITBLT;

  tagEMRSTRETCHBLT = packed record
    emr: TEMR;
    rclBounds: TRect; { Inclusive-inclusive bounds in device units}
    xDest: Longint;
    yDest: Longint;
    cxDest: Longint;
    cyDest: Longint;
    dwRop: DWORD;
    xSrc: Longint;
    ySrc: Longint;
    xformSrc: TXForm;        { Source DC transform}
    crBkColorSrc: COLORREF; { Source DC BkColor in RGB}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
                             { (DIB_RGB_COLORS)}
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    cxSrc: Longint;
    cySrc: Longint;
  end;
  TEMRStretchBlt = tagEMRSTRETCHBLT;
  EMRSTRETCHBLT = tagEMRSTRETCHBLT;

  tagEMRMASKBLT = packed record
    emr: TEMR;
    rclBounds: TRect;        { Inclusive-inclusive bounds in device units}
    xDest: Longint;
    yDest: Longint;
    cxDest: Longint;
    cyDest: Longint;
    dwRop: DWORD;
    xSrc: Longint;
    ySrc: Longint;
    xformSrc: TXForm;        { Source DC transform}
    crBkColorSrc: COLORREF; { Source DC BkColor in RGB}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
                             { (DIB_RGB_COLORS)}
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    xMask: Longint;
    yMask: Longint;
    iUsageMask: DWORD;       { Mask bitmap info color table usage}
    offBmiMask: DWORD;       { Offset to the mask TBitmapInfo structure if any}
    cbBmiMask: DWORD;        { Size of the mask TBitmapInfo structure if any}
    offBitsMask: DWORD;      { Offset to the mask bitmap bits if any}
    cbBitsMask: DWORD;       { Size of the mask bitmap bits if any}
  end;
  TEMRMaskBlt = tagEMRMASKBLT;
  EMRMASKBLT = tagEMRMASKBLT;

  tagEMRPLGBLT = packed record
    emr: TEMR;
    rclBounds: TRect;
    aptlDest0: TPoint; { aptlDest: array[0..2] of TPoint }
    aptlDest1: TPoint;
    aptlDest2: TPoint;
    xSrc: Longint;
    ySrc: Longint;
    cxSrc: Longint;
    cySrc: Longint;
    xformSrc: TXForm;        { Source DC transform}
    crBkColorSrc: COLORREF; { Source DC BkColor in RGB}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
                             { (DIB_RGB_COLORS)}
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    xMask: Longint;
    yMask: Longint;
    iUsageMask: DWORD;       { Mask bitmap info color table usage}
    offBmiMask: DWORD;       { Offset to the mask TBitmapInfo structure if any}
    cbBmiMask: DWORD;        { Size of the mask TBitmapInfo structure if any}
    offBitsMask: DWORD;      { Offset to the mask bitmap bits if any}
    cbBitsMask: DWORD;       { Size of the mask bitmap bits if any}
  end;
  TEMRPLGBlt = tagEMRPLGBLT;
  EMRPLGBLT = tagEMRPLGBLT;

  tagEMRSETDIBITSTODEVICE = packed record
    emr: TEMR;
    rclBounds: TRect;
    xDest: Longint;
    yDest: Longint;
    xSrc: Longint;
    ySrc: Longint;
    cxSrc: Longint;
    cySrc: Longint;
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
    iStartScan: DWORD;
    cScans: DWORD;
  end;
  TEMRSetDIBitsToDevice = tagEMRSETDIBITSTODEVICE;
  EMRSETDIBITSTODEVICE = tagEMRSETDIBITSTODEVICE;

  tagEMRSTRETCHDIBITS = packed record
    emr: TEMR;
    rclBounds: TRect;
    xDest: Longint;
    yDest: Longint;
    xSrc: Longint;
    ySrc: Longint;
    cxSrc: Longint;
    cySrc: Longint;
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
    dwRop: DWORD;
    cxDest: Longint;
    cyDest: Longint;
  end;
  TEMRStretchDIBits = tagEMRSTRETCHDIBITS;
  EMRSTRETCHDIBITS = tagEMRSTRETCHDIBITS;

  tagEMRALPHABLEND = packed record
    emr: TEMR;
    rclBounds: TRect;
    xDest: Longint;
    yDest: Longint;
    cxDest: Longint;
    cyDest: Longint;
    dwRop: DWORD;
    xSrc: Longint;
    ySrc: Longint;
    xformSrc: XFORM;         { Source DC transform}
    crBkColorSrc: COLORREF;  { Source DC BkColor in RGB}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    cxSrc: Longint;
    cySrc: Longint;
  end;
  TEMRAlphaBlend = tagEMRALPHABLEND;
  EMRALPHABLEND = tagEMRALPHABLEND;

  tagEMRTRANSPARENTBLT = packed record
    emr: TEMR;
    rclBounds: TRect;
    xDest: Longint;
    yDest: Longint;
    cxDest: Longint;
    cyDest: Longint;
    dwRop: DWORD;
    xSrc: Longint;
    ySrc: Longint;
    xformSrc: XFORM;         { Source DC transform}
    crBkColorSrc: COLORREF;  { Source DC BkColor in RGB}
    iUsageSrc: DWORD;        { Source bitmap info color table usage}
    offBmiSrc: DWORD;        { Offset to the source TBitmapInfo structure}
    cbBmiSrc: DWORD;         { Size of the source TBitmapInfo structure}
    offBitsSrc: DWORD;       { Offset to the source bitmap bits}
    cbBitsSrc: DWORD;        { Size of the source bitmap bits}
    cxSrc: Longint;
    cySrc: Longint;
  end;
  TEMRTransparentBLT = tagEMRTRANSPARENTBLT;
  EMRTRANSPARENTBLT = tagEMRTRANSPARENTBLT;

  [StructLayout(LayoutKind.Sequential)]
  tagEMREXTCREATEFONTINDIRECTW = record
    emr: TEMR;
    ihFont: DWORD;     { Font handle index}
    elfw: TExtLogFontW;
  end;
  TEMRExtCreateFontIndirect = tagEMREXTCREATEFONTINDIRECTW;
  EMREXTCREATEFONTINDIRECTW = tagEMREXTCREATEFONTINDIRECTW;

  tagEMRCREATEPALETTE = packed record
    emr: TEMR;
    ihPal: DWORD;        { Palette handle index}
    lgpl: TLogPalette;   { The peFlags fields in the palette entries}
                         { do not contain any flags}
  end;
  TEMRCreatePalette = tagEMRCREATEPALETTE;
  EMRCREATEPALETTE = tagEMRCREATEPALETTE;

  tagEMRCREATECOLORSPACE = packed record
    emr: TEMR;
    ihCS: DWORD;          { ColorSpace handle index}
    lcs: TLogColorSpaceW;
  end;
  TEMRCreateColorSpace = tagEMRCREATECOLORSPACE;
  EMRCREATECOLORSPACE = tagEMRCREATECOLORSPACE;

  tagEMRCREATEPEN = packed record
    emr: TEMR;
    ihPen: DWORD;   { Pen handle index}
    lopn: TLogPen;
  end;
  TEMRCreatePen = tagEMRCREATEPEN;
  EMRCREATEPEN = tagEMRCREATEPEN;

  tagEMREXTCREATEPEN = packed record
    emr: TEMR;
    ihPen: DWORD;      { Pen handle index}
    offBmi: DWORD;     { Offset to the TBitmapInfo structure if any}
    cbBmi: DWORD;      { Size of the TBitmapInfo structure if any}
                       { The bitmap info is followed by the bitmap}
                       { bits to form a packed DIB.}
    offBits: DWORD;    { Offset to the brush bitmap bits if any}
    cbBits: DWORD;     { Size of the brush bitmap bits if any}
    elp: TExtLogPen;   { The extended pen with the style array.}
  end;
  TEMRExtCreatePen = tagEMREXTCREATEPEN;
  EMREXTCREATEPEN = tagEMREXTCREATEPEN;

  tagEMRCREATEBRUSHINDIRECT = packed record
    emr: TEMR;
    ihBrush: DWORD; { Brush handle index}
    lb: TLogBrush;  { The style must be BS_SOLID, BS_HOLLOW,}
                    { BS_NULL or BS_HATCHED.}
  end;
  TEMRCreateBrushIndirect = tagEMRCREATEBRUSHINDIRECT;
  EMRCREATEBRUSHINDIRECT = tagEMRCREATEBRUSHINDIRECT;

  tagEMRCREATEMONOBRUSH = packed record
    emr: TEMR;
    ihBrush: DWORD; { Brush handle index}
    iUsage: DWORD;  { Bitmap info color table usage}
    offBmi: DWORD;  { Offset to the TBitmapInfo structure}
    cbBmi: DWORD;   { Size of the TBitmapInfo structure if any}
                    { The bitmap info is followed by the bitmap}
                    { bits to form a packed DIB.}
    offBits: DWORD; { Offset to the bitmap bits}
    cbBits: DWORD;  { Size of the bitmap bits}
  end;
  TEMRCreateMonoBrush = tagEMRCREATEMONOBRUSH;
  EMRCREATEMONOBRUSH = tagEMRCREATEMONOBRUSH;

  tagEMRCREATEDIBPATTERNBRUSHPT = packed record
    emr: TEMR;
    ihBrush: DWORD; { Brush handle index}
    iUsage: DWORD;  { Bitmap info color table usage}
    offBmi: DWORD;  { Offset to the TBitmapInfo structure}
    cbBmi: DWORD;   { Size of the TBitmapInfo structure if any}
                    { The bitmap info is followed by the bitmap}
                    { bits to form a packed DIB.}
    offBits: DWORD; { Offset to the bitmap bits}
    cbBits: DWORD;  { Size of the bitmap bits}
  end;
  TEMRCreateDIBPatternBrushPt = tagEMRCREATEDIBPATTERNBRUSHPT;
  EMRCREATEDIBPATTERNBRUSHPT = tagEMRCREATEDIBPATTERNBRUSHPT;

  tagEMRFORMAT = packed record
    dSignature: DWORD; { Format signature, e.g. ENHMETA_SIGNATURE.}
    nVersion: DWORD;   { Format version number.}
    cbData: DWORD;     { Size of data in bytes.}
    offData: DWORD;    { Offset to data from GDICOMMENT_IDENTIFIER.}
                       { It must begin at a DWORD offset.}
  end;
  TEMRFormat = tagEMRFORMAT;
  EMRFORMAT = tagEMRFORMAT;

  tagEMRGLSRECORD = packed record
    emr: TEMR;
    cbData: DWORD;  { Size of data in bytes }
    Data: IntPtr;   { packed array[0..0] of Byte }
  end;
  TEMRGLSRecord = tagEMRGLSRECORD;
  EMRGLSRECORD = tagEMRGLSRECORD;


  tagEMRGLSBOUNDEDRECORD = packed record
    emr: TEMR;
    rclBounds: TRect;  { Bounds in recording coordinates }
    cbData: DWORD;     { Size of data in bytes }
    Data: IntPtr;      { packed array[0..0] of Byte }
  end;
  TEMRGLSBoundedRecord = tagEMRGLSBOUNDEDRECORD;
  EMRGLSBOUNDEDRECORD = tagEMRGLSBOUNDEDRECORD;

  tagEMRPIXELFORMAT = packed record
    emr: TEMR;
    pfd: TPixelFormatDescriptor;
  end;
  TEMRPixelFormat = tagEMRPIXELFORMAT;
  EMRPIXELFORMAT = tagEMRPIXELFORMAT;

const
  GDICOMMENT_IDENTIFIER = $43494447;
  GDICOMMENT_WINDOWS_METAFILE = DWORD($80000001);
  GDICOMMENT_BEGINGROUP = 2;
  GDICOMMENT_ENDGROUP = 3;
  GDICOMMENT_MULTIFORMATS = $40000004;
  EPS_SIGNATURE = $46535045;

{ OpenGL wgl prototypes}

function wglCopyContext(p1: HGLRC; p2: HGLRC; p3: Cardinal): BOOL;
function wglCreateContext(DC: HDC): HGLRC;
function wglCreateLayerContext(p1: HDC; p2: Integer): HGLRC;
function wglDeleteContext(p1: HGLRC): BOOL;
function wglGetCurrentContext: HGLRC;
function wglGetCurrentDC: HDC;
function wglMakeCurrent(DC: HDC; p2: HGLRC): BOOL;
function wglShareLists(p1, p2: HGLRC): BOOL;
function wglUseFontBitmaps(DC: HDC; p2, p3, p4: DWORD): BOOL;
function wglUseFontBitmapsA(DC: HDC; p2, p3, p4: DWORD): BOOL;
function wglUseFontBitmapsW(DC: HDC; p2, p3, p4: DWORD): BOOL;
function SwapBuffers(DC: HDC): BOOL;

type
  _POINTFLOAT = packed record
    x: Single;
    y: Single;
  end;
  TPointFloat = _POINTFLOAT;
  POINTFLOAT = _POINTFLOAT;

  _GLYPHMETRICSFLOAT = packed record
    gmfBlackBoxX: Single;
    gmfBlackBoxY: Single;
    gmfptGlyphOrigin: TPointFloat;
    gmfCellIncX: Single;
    gmfCellIncY: Single;
  end;
  TGlyphMetricsFloat = _GLYPHMETRICSFLOAT;
  GLYPHMETRICSFLOAT = _GLYPHMETRICSFLOAT;

const
  WGL_FONT_LINES = 0;
  WGL_FONT_POLYGONS = 1;

function wglUseFontOutlines(p1: HDC; p2, p3, p4: DWORD;
  p5, p6: Single; p7: Integer; var p8: TGlyphMetricsFloat): BOOL; overload;
function wglUseFontOutlines(p1: HDC; p2, p3, p4: DWORD;
  p5, p6: Single; p7: Integer; p8: IntPtr): BOOL; overload;
function wglUseFontOutlinesA(p1: HDC; p2, p3, p4: DWORD;
  p5, p6: Single; p7: Integer; var p8: TGlyphMetricsFloat): BOOL;
function wglUseFontOutlinesW(p1: HDC; p2, p3, p4: DWORD;
  p5, p6: Single; p7: Integer; var p8: TGlyphMetricsFloat): BOOL;

{ Layer plane descriptor }
type
  tagLAYERPLANEDESCRIPTOR = packed record   { lpd }
    nSize: Word;
    nVersion: Word;
    dwFlags: DWORD;
    iPixelType: Byte;
    cColorBits: Byte;
    cRedBits: Byte;
    cRedShift: Byte;
    cGreenBits: Byte;
    cGreenShift: Byte;
    cBlueBits: Byte;
    cBlueShift: Byte;
    cAlphaBits: Byte;
    cAlphaShift: Byte;
    cAccumBits: Byte;
    cAccumRedBits: Byte;
    cAccumGreenBits: Byte;
    cAccumBlueBits: Byte;
    cAccumAlphaBits: Byte;
    cDepthBits: Byte;
    cStencilBits: Byte;
    cAuxBuffers: Byte;
    iLayerPlane: Byte;
    bReserved: Byte;
    crTransparent: COLORREF;
  end;
  TLayerPlaneDescriptor = tagLAYERPLANEDESCRIPTOR;
  LAYERPLANEDESCRIPTOR = tagLAYERPLANEDESCRIPTOR;


{ TLayerPlaneDescriptor flags }
const
  LPD_DOUBLEBUFFER = $00000001;
  LPD_STEREO = $00000002;
  LPD_SUPPORT_GDI = $00000010;
  LPD_SUPPORT_OPENGL = $00000020;
  LPD_SHARE_DEPTH = $00000040;
  LPD_SHARE_STENCIL = $00000080;
  LPD_SHARE_ACCUM = $00000100;
  LPD_SWAP_EXCHANGE = $00000200;
  LPD_SWAP_COPY = $00000400;
  LPD_TRANSPARENT = $00001000;

  LPD_TYPE_RGBA = 0;
  LPD_TYPE_COLORINDEX = 1;

{ wglSwapLayerBuffers flags }
  WGL_SWAP_MAIN_PLANE = $00000001;
  WGL_SWAP_OVERLAY1 = $00000002;
  WGL_SWAP_OVERLAY2 = $00000004;
  WGL_SWAP_OVERLAY3 = $00000008;
  WGL_SWAP_OVERLAY4 = $00000010;
  WGL_SWAP_OVERLAY5 = $00000020;
  WGL_SWAP_OVERLAY6 = $00000040;
  WGL_SWAP_OVERLAY7 = $00000080;
  WGL_SWAP_OVERLAY8 = $00000100;
  WGL_SWAP_OVERLAY9 = $00000200;
  WGL_SWAP_OVERLAY10 = $00000400;
  WGL_SWAP_OVERLAY11 = $00000800;
  WGL_SWAP_OVERLAY12 = $00001000;
  WGL_SWAP_OVERLAY13 = $00002000;
  WGL_SWAP_OVERLAY14 = $00004000;
  WGL_SWAP_OVERLAY15 = $00008000;
  WGL_SWAP_UNDERLAY1 = $00010000;
  WGL_SWAP_UNDERLAY2 = $00020000;
  WGL_SWAP_UNDERLAY3 = $00040000;
  WGL_SWAP_UNDERLAY4 = $00080000;
  WGL_SWAP_UNDERLAY5 = $00100000;
  WGL_SWAP_UNDERLAY6 = $00200000;
  WGL_SWAP_UNDERLAY7 = $00400000;
  WGL_SWAP_UNDERLAY8 = $00800000;
  WGL_SWAP_UNDERLAY9 = $01000000;
  WGL_SWAP_UNDERLAY10 = $02000000;
  WGL_SWAP_UNDERLAY11 = $04000000;
  WGL_SWAP_UNDERLAY12 = $08000000;
  WGL_SWAP_UNDERLAY13 = $10000000;
  WGL_SWAP_UNDERLAY14 = $20000000;
  WGL_SWAP_UNDERLAY15 = $40000000;

function wglDescribeLayerPlane(p1: HDC; p2, p3: Integer; p4: Cardinal;
  var p5: TLayerPlaneDescriptor): BOOL;
function wglSetLayerPaletteEntries(p1: HDC; p2, p3, p4: Integer;
  [in] pcr: array of ColorRef): Integer;
function wglGetLayerPaletteEntries(p1: HDC; p2, p3, p4: Integer;
  [out] pcr: array of ColorRef): Integer;
function wglRealizeLayerPalette(p1: HDC; p2: Integer; p3: BOOL): BOOL;
function wglSwapLayerBuffers(p1: HDC; p2: Cardinal): BOOL;

type
  _WGLSWAP = packed record
    hdc: HDC;
    uiFlags: UINT;
  end;
  TWGLSwap = _WGLSWAP;
  WGLSWAP = _WGLSWAP;

const
  WGL_SWAPMULTIPLE_MAX = 16;

function wglSwapMultipleBuffers(p1: UINT; var p2: TWGLSwap): DWORD;

{ Translated from WINUSER.H }

type
  HDWP = THandle;
  PMENUTEMPLATE = Pointer;
  va_list = PChar;

  TFNWndProc = function (p1: HWND; p2: UINT; p3: WPARAM; p4: LPARAM): LRESULT;
  TFNDlgProc = function (p1: HWND; p2: UINT; p3: WPARAM; p4: LPARAM): BOOL;
  TFNTimerProc = procedure (p1: HWND; p2, p3: UINT; p4: DWORD);
  TFNGrayStringProc = function (DC: HDC; p2: LPARAM; p3: Integer): BOOL;
  TFNWndEnumProc = function (p1: HWND; p2: LPARAM): BOOL;
  TFNSendAsyncProc = procedure (p1: HWND; p2: UINT; p3: DWORD; p4: LRESULT);
  TFNDrawStateProc = function (hdc: HDC; lData: LPARAM; wData: WPARAM; cx,cy: Integer): BOOL;

  TFNHookProc = function (code: Integer; wparam: WPARAM; lparam: LPARAM): LRESULT;
  TFNMsgHookProc = function (code: Integer; wparam: WPARAM; lparam: IntPtr): LRESULT;

type
  TFNPropEnumProc = function (p1: HWND; p2: string; p3: THandle): BOOL;
  TFNPropEnumProcEx = function (p1: HWND; p2: string; p3: THandle;
    p4: DWORD): BOOL;
  TFNEditWordBreakProc = function (lpch: string; ichCurrent, cch, code: Integer): Integer;
  TFNNameEnumProc = function (p1: string; p2: LPARAM): BOOL;
  TFNWinStaEnumProc = TFNNameEnumProc;
  TFNDeskTopEnumProc = TFNNameEnumProc;

  MakeIntResourceA = Integer;
  MakeIntResourceW = Integer;
  MakeIntResource = Integer;

const
  { Predefined Resource Types }
  RT_CURSOR       = MakeIntResource(1);
  RT_BITMAP       = MakeIntResource(2);
  RT_ICON         = MakeIntResource(3);
  RT_MENU         = MakeIntResource(4);
  RT_DIALOG       = MakeIntResource(5);
  RT_STRING       = MakeIntResource(6);
  RT_FONTDIR      = MakeIntResource(7);
  RT_FONT         = MakeIntResource(8);
  RT_ACCELERATOR  = MakeIntResource(9);
  RT_RCDATA       = MakeIntResource(10);
  RT_MESSAGETABLE = MakeIntResource(11);

  DIFFERENCE = 11;

  RT_GROUP_CURSOR = MakeIntResource(DWORD(RT_CURSOR + DIFFERENCE));
  RT_GROUP_ICON   = MakeIntResource(DWORD(RT_ICON + DIFFERENCE));
  RT_VERSION      = MakeIntResource(16);
  RT_DLGINCLUDE   = MakeIntResource(17);
  RT_PLUGPLAY     = MakeIntResource(19);
  RT_VXD          = MakeIntResource(20);
  RT_ANICURSOR    = MakeIntResource(21);
  RT_ANIICON      = MakeIntResource(22);

const
  { Scroll Bar Constants }
  SB_HORZ = 0;
  SB_VERT = 1;
  SB_CTL = 2;
  SB_BOTH = 3;

  { Scroll Bar Commands }
  SB_LINEUP = 0;
  SB_LINELEFT = 0;
  SB_LINEDOWN = 1;
  SB_LINERIGHT = 1;
  SB_PAGEUP = 2;
  SB_PAGELEFT = 2;
  SB_PAGEDOWN = 3;
  SB_PAGERIGHT = 3;
  SB_THUMBPOSITION = 4;
  SB_THUMBTRACK = 5;
  SB_TOP = 6;
  SB_LEFT = 6;
  SB_BOTTOM = 7;
  SB_RIGHT = 7;
  SB_ENDSCROLL = 8;

  { ShowWindow() Commands }
  SW_HIDE = 0;
  SW_SHOWNORMAL = 1;
  SW_NORMAL = 1;
  SW_SHOWMINIMIZED = 2;
  SW_SHOWMAXIMIZED = 3;
  SW_MAXIMIZE = 3;
  SW_SHOWNOACTIVATE = 4;
  SW_SHOW = 5;
  SW_MINIMIZE = 6;
  SW_SHOWMINNOACTIVE = 7;
  SW_SHOWNA = 8;
  SW_RESTORE = 9;
  SW_SHOWDEFAULT = 10;
  SW_MAX = 10;

  { Old ShowWindow() Commands }
  HIDE_WINDOW = 0;
  SHOW_OPENWINDOW = 1;
  SHOW_ICONWINDOW = 2;
  SHOW_FULLSCREEN = 3;
  SHOW_OPENNOACTIVATE = 4;

  { Identifiers for the WM_SHOWWINDOW message }
  SW_PARENTCLOSING = 1;
  SW_OTHERZOOM = 2;
  SW_PARENTOPENING = 3;
  SW_OTHERUNZOOM = 4;

  AW_HOR_POSITIVE = $00000001;
  AW_HOR_NEGATIVE = $00000002;
  AW_VER_POSITIVE = $00000004;
  AW_VER_NEGATIVE = $00000008;
  AW_CENTER = $00000010;
  AW_HIDE = $00010000;
  AW_ACTIVATE = $00020000;
  AW_SLIDE = $00040000;
  AW_BLEND = $00080000;

  { WM_KEYUPDOWNCHAR HiWord(lParam) flags }
  KF_EXTENDED = $100;
  KF_DLGMODE = $800;
  KF_MENUMODE = $1000;
  KF_ALTDOWN = $2000;
  KF_REPEAT = $4000;
  KF_UP = $8000;

  { Virtual Keys, Standard Set }
  VK_LBUTTON = 1;
  VK_RBUTTON = 2;
  VK_CANCEL = 3;
  VK_MBUTTON = 4;  { NOT contiguous with L & RBUTTON }
  VK_BACK = 8;
  VK_TAB = 9;
  VK_CLEAR = 12;
  VK_RETURN = 13;
  VK_SHIFT = $10;
  VK_CONTROL = 17;
  VK_MENU = 18;
  VK_PAUSE = 19;
  VK_CAPITAL = 20;
  VK_KANA = 21;
  VK_HANGUL = 21;
  VK_JUNJA = 23;
  VK_FINAL = 24;
  VK_HANJA = 25;
  VK_KANJI = 25;
  VK_CONVERT = 28;
  VK_NONCONVERT = 29;
  VK_ACCEPT = 30;
  VK_MODECHANGE = 31;
  VK_ESCAPE = 27;
  VK_SPACE = $20;
  VK_PRIOR = 33;
  VK_NEXT = 34;
  VK_END = 35;
  VK_HOME = 36;
  VK_LEFT = 37;
  VK_UP = 38;
  VK_RIGHT = 39;
  VK_DOWN = 40;
  VK_SELECT = 41;
  VK_PRINT = 42;
  VK_EXECUTE = 43;
  VK_SNAPSHOT = 44;
  VK_INSERT = 45;
  VK_DELETE = 46;
  VK_HELP = 47;
{ VK_0 thru VK_9 are the same as ASCII '0' thru '9' ($30 - $39) }
{ VK_A thru VK_Z are the same as ASCII 'A' thru 'Z' ($41 - $5A) }
  VK_LWIN = 91;
  VK_RWIN = 92;
  VK_APPS = 93;
  VK_NUMPAD0 = 96;
  VK_NUMPAD1 = 97;
  VK_NUMPAD2 = 98;
  VK_NUMPAD3 = 99;
  VK_NUMPAD4 = 100;
  VK_NUMPAD5 = 101;
  VK_NUMPAD6 = 102;
  VK_NUMPAD7 = 103;
  VK_NUMPAD8 = 104;
  VK_NUMPAD9 = 105;
  VK_MULTIPLY = 106;
  VK_ADD = 107;
  VK_SEPARATOR = 108;
  VK_SUBTRACT = 109;
  VK_DECIMAL = 110;
  VK_DIVIDE = 111;
  VK_F1 = 112;
  VK_F2 = 113;
  VK_F3 = 114;
  VK_F4 = 115;
  VK_F5 = 116;
  VK_F6 = 117;
  VK_F7 = 118;
  VK_F8 = 119;
  VK_F9 = 120;
  VK_F10 = 121;
  VK_F11 = 122;
  VK_F12 = 123;
  VK_F13 = 124;
  VK_F14 = 125;
  VK_F15 = 126;
  VK_F16 = 127;
  VK_F17 = 128;
  VK_F18 = 129;
  VK_F19 = 130;
  VK_F20 = 131;
  VK_F21 = 132;
  VK_F22 = 133;
  VK_F23 = 134;
  VK_F24 = 135;
  VK_NUMLOCK = 144;
  VK_SCROLL = 145;
{ VK_L & VK_R - left and right Alt, Ctrl and Shift virtual keys.
  Used only as parameters to GetAsyncKeyState() and GetKeyState().
  No other API or message will distinguish left and right keys in this way. }
  VK_LSHIFT = 160;
  VK_RSHIFT = 161;
  VK_LCONTROL = 162;
  VK_RCONTROL = 163;
  VK_LMENU = 164;
  VK_RMENU = 165;
  VK_PROCESSKEY = 229;
  VK_ATTN = 246;
  VK_CRSEL = 247;
  VK_EXSEL = 248;
  VK_EREOF = 249;
  VK_PLAY = 250;
  VK_ZOOM = 251;
  VK_NONAME = 252;
  VK_PA1 = 253;
  VK_OEM_CLEAR = 254;


  { SetWindowsHook() codes }
  WH_MIN = -1;
  WH_MSGFILTER = -1;
  WH_JOURNALRECORD = 0;
  WH_JOURNALPLAYBACK = 1;
  WH_KEYBOARD = 2;
  WH_GETMESSAGE = 3;
  WH_CALLWNDPROC = 4;
  WH_CBT = 5;
  WH_SYSMSGFILTER = 6;
  WH_MOUSE = 7;
  WH_HARDWARE = 8;
  WH_DEBUG = 9;
  WH_SHELL = 10;
  WH_FOREGROUNDIDLE = 11;
  WH_CALLWNDPROCRET = 12;
  WH_MAX = 12;
  WH_MINHOOK = WH_MIN;
  WH_MAXHOOK = WH_MAX;

  { Hook Codes }
  HC_ACTION = 0;
  HC_GETNEXT = 1;
  HC_SKIP = 2;
  HC_NOREMOVE = 3;
  HC_NOREM = HC_NOREMOVE;
  HC_SYSMODALON = 4;
  HC_SYSMODALOFF = 5;

  { CBT Hook Codes }
  HCBT_MOVESIZE = 0;
  HCBT_MINMAX = 1;
  HCBT_QS = 2;
  HCBT_CREATEWND = 3;
  HCBT_DESTROYWND = 4;
  HCBT_ACTIVATE = 5;
  HCBT_CLICKSKIPPED = 6;
  HCBT_KEYSKIPPED = 7;
  HCBT_SYSCOMMAND = 8;
  HCBT_SETFOCUS = 9;


type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagCREATESTRUCT = packed record
    lpCreateParams: IntPtr; { Pointer }
    hInstance: HINST;
    hMenu: HMENU;
    hwndParent: HWND;
    cy: Integer;
    cx: Integer;
    y: Integer;
    x: Integer;
    style: Longint;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszClass: string;
    dwExStyle: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagCREATESTRUCTA = packed record
    lpCreateParams: IntPtr; { Pointer }
    hInstance: HINST;
    hMenu: HMENU;
    hwndParent: HWND;
    cy: Integer;
    cx: Integer;
    y: Integer;
    x: Integer;
    style: Longint;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszClass: string;
    dwExStyle: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagCREATESTRUCTW = packed record
    lpCreateParams: IntPtr; { Pointer }
    hInstance: HINST;
    hMenu: HMENU;
    hwndParent: HWND;
    cy: Integer;
    cx: Integer;
    y: Integer;
    x: Integer;
    style: Longint;
    lpszName: string;
    lpszClass: string;
    dwExStyle: DWORD;
  end;
  TCreateStruct = tagCREATESTRUCT;
  TCreateStructA = tagCREATESTRUCTA;
  TCreateStructW = tagCREATESTRUCTW;
  CREATESTRUCT = tagCREATESTRUCT;
  CREATESTRUCTA = tagCREATESTRUCTA;
  CREATESTRUCTW = tagCREATESTRUCTW;

  { HCBT_CREATEWND parameters pointed to by lParam }
  tagCBT_CREATEWNDA = packed record
    lpcs: IntPtr; { PCreateStruct }
    hwndInsertAfter: HWND;
  end;
  TCBTCreateWnd = tagCBT_CREATEWNDA;
  CBT_CREATEWND = tagCBT_CREATEWNDA;

  { HCBT_ACTIVATE structure pointed to by lParam }
  tagCBTACTIVATESTRUCT = packed record
    fMouse: BOOL;
    hWndActive: HWND;
  end;
  TCBTActivateStruct = tagCBTACTIVATESTRUCT;
  CBTACTIVATESTRUCT = tagCBTACTIVATESTRUCT;

const

{ codes passed in WPARAM for WM_WTSSESSION_CHANGE }

  WTS_CONSOLE_CONNECT = $1;
  WTS_CONSOLE_DISCONNECT = $2;
  WTS_REMOTE_CONNECT = $3;
  WTS_REMOTE_DISCONNECT = $4;
  WTS_SESSION_LOGON = $5;
  WTS_SESSION_LOGOFF = $6;
  WTS_SESSION_LOCK = $7;
  WTS_SESSION_UNLOCK = $8;

  { WH_MSGFILTER Filter Proc Codes }
  MSGF_DIALOGBOX = 0;
  MSGF_MESSAGEBOX = 1;
  MSGF_MENU = 2;
  MSGF_MOVE = 3;
  MSGF_SIZE = 4;
  MSGF_SCROLLBAR = 5;
  MSGF_NEXTWINDOW = 6;
  MSGF_MAINLOOP = 8;
  MSGF_MAX = 8;
  MSGF_USER = $1000;

  { Shell support }
  HSHELL_WINDOWCREATED = 1;
  HSHELL_WINDOWDESTROYED = 2;
  HSHELL_ACTIVATESHELLWINDOW = 3;
  HSHELL_WINDOWACTIVATED = 4;
  HSHELL_GETMINRECT = 5;
  HSHELL_REDRAW = 6;
  HSHELL_TASKMAN = 7;
  HSHELL_LANGUAGE = 8;
  HSHELL_ACCESSIBILITYSTATE = 11;
  HSHELL_APPCOMMAND = 12;
  HSHELL_WINDOWREPLACED = 13;
  ACCESS_STICKYKEYS = $0001;
  ACCESS_FILTERKEYS = $0002;
  ACCESS_MOUSEKEYS = $0003;


type
  { Message Structure used in Journaling }
  tagEVENTMSG = packed record
    message: UINT;
    paramL: UINT;
    paramH: UINT;
    time: DWORD;
    hwnd: HWND;
  end;
  TEventMsg = tagEVENTMSG;
  EVENTMSG = tagEVENTMSG;

  { Message structure used by WH_CALLWNDPROC }
  tagCWPSTRUCT = packed record
    lParam: LPARAM;
    wParam: WPARAM;
    message: UINT;
    hwnd: HWND;
  end;
  TCWPStruct = tagCWPSTRUCT;
  CWPSTRUCT = tagCWPSTRUCT;

  { Message structure used by WH_CALLWNDPROCRET }
  tagCWPRETSTRUCT = packed record
    lResult: LRESULT;
    lParam: LPARAM;
    wParam: WPARAM;
    message: UINT;
    hwnd: HWND;
  end;
  TCWPRetStruct = tagCWPRETSTRUCT;
  CWPRETSTRUCT = tagCWPRETSTRUCT;

  { Structure used by WH_DEBUG }
  tagDEBUGHOOKINFO = packed record
    idThread: DWORD;
    idThreadInstaller: DWORD;
    lParam: LPARAM;
    wParam: WPARAM;
    code: Integer;
  end;
  TDebugHookInfo = tagDEBUGHOOKINFO;
  DEBUGHOOKINFO = tagDEBUGHOOKINFO;

  { Structure used by WH_MOUSE }
  tagMOUSEHOOKSTRUCT = packed record
    pt: TPoint;
    hwnd: HWND;
    wHitTestCode: UINT;
    dwExtraInfo: DWORD;
  end;
  TMouseHookStruct = tagMOUSEHOOKSTRUCT;
  MOUSEHOOKSTRUCT = tagMOUSEHOOKSTRUCT;

  { Structure used by WH_HARDWARE }
  tagHARDWAREHOOKSTRUCT = packed record
    hwnd: HWND;
    message: UINT;
    wParam: WPARAM;
    lParam: LPARAM;
  end;
  THardwareHookStruct = tagHARDWAREHOOKSTRUCT;
  HARDWAREHOOKSTRUCT = tagHARDWAREHOOKSTRUCT;

const
  { Keyboard Layout API }
  HKL_PREV = 0;
  HKL_NEXT = 1;

  KLF_ACTIVATE = 1;
  KLF_SUBSTITUTE_OK = 2;
  KLF_UNLOADPREVIOUS = 4;
  KLF_REORDER = 8;
  KLF_REPLACELANG = $10;
  KLF_NOTELLSHELL = 128;

  { Size of KeyboardLayoutName (number of characters), including nul terminator }
  KL_NAMELENGTH = 9;

type
  TKeyboardState = array[0..255] of Byte;

function LoadKeyboardLayout(pwszKLID: string; Flags: UINT): HKL;
function LoadKeyboardLayoutA(pwszKLID: string; Flags: UINT): HKL;
function LoadKeyboardLayoutW(pwszKLID: string; Flags: UINT): HKL;
function ActivateKeyboardLayout(hkl: HKL; Flags: UINT): HKL;
function UnloadKeyboardLayout(hkl: HKL): BOOL;
function ToUnicodeEx(wVirtKey, wScanCode: UINT; [in] lpKeyState: TKeyboardState;
  pwszBuff: StringBuilder; cchBuff: Integer; wFlags: UINT; dwhkl: HKL): Integer;
function GetKeyboardLayoutName(pwszKLID: StringBuilder): BOOL;
function GetKeyboardLayoutNameA(pwszKLID: StringBuilder): BOOL;
function GetKeyboardLayoutNameW(pwszKLID: StringBuilder): BOOL;
function GetKeyboardLayoutList(nBuff: Integer; [out] List: array of HKL): UINT;
function GetKeyboardLayout(dwLayout: DWORD): HKL;

type
  tagMOUSEMOVEPOINT = packed record
    x: Integer;
    y: Integer;
    time: DWORD;
    dwExtraInfo: DWORD;
  end;
  TMouseMovePoint = tagMOUSEMOVEPOINT;
  MOUSEMOVEPOINT = tagMOUSEMOVEPOINT;

const
  { Values for resolution parameter of GetMouseMovePoints }
  GMMP_USE_DISPLAY_POINTS = 1;
  GMMP_USE_DRIVER_POINTS = 2;

function GetMouseMovePoints(cbSize: UINT; const lppt, lpptBuf: TMouseMovePoint;
  nBufPoints: Integer; resolution: DWORD): Integer;


const
  { Desktop-specific access flags }
  DESKTOP_READOBJECTS = 1;
  DESKTOP_CREATEWINDOW = 2;
  DESKTOP_CREATEMENU = 4;
  DESKTOP_HOOKCONTROL = 8;
  DESKTOP_JOURNALRECORD = $10;
  DESKTOP_JOURNALPLAYBACK = $20;
  DESKTOP_ENUMERATE = $40;
  DESKTOP_WRITEOBJECTS = 128;
  DESKTOP_SWITCHDESKTOP = $100;

  { Desktop-specific control flags }
  DF_ALLOWOTHERACCOUNTHOOK = 1;


function CreateDesktop(lpszDesktop: string; lpszDevice,
  pDevmode: IntPtr; dwFlags: DWORD; dwDesiredAccess:
  DWORD; const lpsa: TSecurityAttributes): HDESK; overload;
function CreateDesktop(lpszDesktop: string; lpszDevice,
  pDevmode: IntPtr; dwFlags: DWORD; dwDesiredAccess:
  DWORD; lpsa: IntPtr): HDESK; overload;
function CreateDesktopA(lpszDesktop: string; lpszDevice,
  pDevmode: IntPtr; dwFlags: DWORD; dwDesiredAccess:
  DWORD; const lpsa: TSecurityAttributes): HDESK;
function CreateDesktopW(lpszDesktop: string; lpszDevice,
  pDevmode: IntPtr; dwFlags: DWORD; dwDesiredAccess:
  DWORD; const lpsa: TSecurityAttributes): HDESK;
function OpenDesktop(lpszDesktop: string; dwFlags: DWORD; fInherit: BOOL;
  dwDesiredAccess: DWORD): HDESK;
function OpenDesktopA(lpszDesktop: string; dwFlags: DWORD; fInherit: BOOL;
  dwDesiredAccess: DWORD): HDESK;
function OpenDesktopW(lpszDesktop: string; dwFlags: DWORD; fInherit: BOOL;
  dwDesiredAccess: DWORD): HDESK;
function EnumDesktops(hwinsta: HWINSTA; lpEnumFunc: TFNDeskTopEnumProc; lParam: LPARAM): BOOL;
function EnumDesktopsA(hwinsta: HWINSTA; lpEnumFunc: TFNDeskTopEnumProc; lParam: LPARAM): BOOL;
function EnumDesktopsW(hwinsta: HWINSTA; lpEnumFunc: TFNDeskTopEnumProc; lParam: LPARAM): BOOL;
function OpenInputDesktop(dwFlags: DWORD; fInherit: BOOL; dwDesiredAccess: DWORD): HDESK;
function EnumDesktopWindows(hDesktop: HDESK; lpfn: TFNWndEnumProc; lParam: LPARAM): BOOL;
function SwitchDesktop(hDesktop: HDESK): BOOL;
function SetThreadDesktop(hDesktop: HDESK): BOOL;
function CloseDesktop(hDesktop: HDESK): BOOL;
function GetThreadDesktop(dwThreadId: DWORD): HDESK;

const
  { Windowstation-specific access flags }
  WINSTA_ENUMDESKTOPS = 1;
  WINSTA_READATTRIBUTES = 2;
  WINSTA_ACCESSCLIPBOARD = 4;
  WINSTA_CREATEDESKTOP = 8;
  WINSTA_WRITEATTRIBUTES = $10;
  WINSTA_ACCESSGLOBALATOMS = $20;
  WINSTA_EXITWINDOWS = $40;
  WINSTA_ENUMERATE = $100;
  WINSTA_READSCREEN = $200;

  { Windowstation-specific attribute flags }
  WSF_VISIBLE = 1;

function CreateWindowStation(lpwinsta: string; dwReserved, dwDesiredAccess: DWORD;
  const lpsa: TSecurityAttributes): HWINSTA; overload;
function CreateWindowStation(lpwinsta: string; dwReserved, dwDesiredAccess: DWORD;
  lpsa: IntPtr): HWINSTA; overload;
function CreateWindowStationA(lpwinsta: string; dwReserved, dwDesiredAccess: DWORD;
  const lpsa: TSecurityAttributes): HWINSTA;
function CreateWindowStationW(lpwinsta: string; dwReserved, dwDesiredAccess: DWORD;
  const lpsa: TSecurityAttributes): HWINSTA;

function OpenWindowStation(lpszWinSta: string; fInherit: BOOL;
  dwDesiredAccess: DWORD): HWINSTA;
function OpenWindowStationA(lpszWinSta: string; fInherit: BOOL;
  dwDesiredAccess: DWORD): HWINSTA;
function OpenWindowStationW(lpszWinSta: string; fInherit: BOOL;
  dwDesiredAccess: DWORD): HWINSTA;
function EnumWindowStations(lpEnumFunc: TFNWinStaEnumProc; lParam: LPARAM): BOOL;
function EnumWindowStationsA(lpEnumFunc: TFNWinStaEnumProc; lParam: LPARAM): BOOL;
function EnumWindowStationsW(lpEnumFunc: TFNWinStaEnumProc; lParam: LPARAM): BOOL;
function CloseWindowStation(hWinSta: HWINSTA): BOOL;
function SetProcessWindowStation(hWinSta: HWINSTA): BOOL;
function GetProcessWindowStation: HWINSTA;
function SetUserObjectSecurity(hObj: THandle; [in] var pSIRequested: DWORD;
  const pSID: TSecurityDescriptor): BOOL;
function GetUserObjectSecurity(hObj: THandle; [in] var pSIRequested: DWORD;
  var pSID: TSecurityDescriptor; nLength: DWORD; out lpnLengthNeeded: DWORD): BOOL;

const
  UOI_FLAGS = 1;
  UOI_NAME = 2;
  UOI_TYPE = 3;
  UOI_USER_SID = 4;

type
  tagUSEROBJECTFLAGS = packed record
    fInherit: BOOL;
    fReserved: BOOL;
    dwFlags: DWORD;
  end;
  TUserObjectFlags = tagUSEROBJECTFLAGS;
  USEROBJECTFLAGS = tagUSEROBJECTFLAGS;

function GetUserObjectInformation(hObj: THandle; nIndex: Integer; pvInfo: IntPtr;
  nLength: DWORD; out lpnLengthNeeded: DWORD): BOOL;
function GetUserObjectInformationA(hObj: THandle; nIndex: Integer; pvInfo: IntPtr;
  nLength: DWORD; out lpnLengthNeeded: DWORD): BOOL;
function GetUserObjectInformationW(hObj: THandle; nIndex: Integer; pvInfo: IntPtr;
  nLength: DWORD; out lpnLengthNeeded: DWORD): BOOL;
function SetUserObjectInformation(hObj: THandle; nIndex: Integer;
  pvInfo: IntPtr; nLength: DWORD): BOOL;
function SetUserObjectInformationA(hObj: THandle; nIndex: Integer;
  pvInfo: IntPtr; nLength: DWORD): BOOL;
function SetUserObjectInformationW(hObj: THandle; nIndex: Integer;
  pvInfo: IntPtr; nLength: DWORD): BOOL;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagWNDCLASSEX = packed record
    cbSize: UINT;
    style: UINT;
    [MarshalAs(UnmanagedType.FunctionPtr)]
    lpfnWndProc: TFNWndProc;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszMenuName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszClassName: string;
    hIconSm: HICON;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagWNDCLASSEXA = packed record
    cbSize: UINT;
    style: UINT;
    [MarshalAs(UnmanagedType.FunctionPtr)]
    lpfnWndProc: TFNWndProc;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszMenuName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszClassName: string;
    hIconSm: HICON;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagWNDCLASSEXW = packed record
    cbSize: UINT;
    style: UINT;
    [MarshalAs(UnmanagedType.FunctionPtr)]
    lpfnWndProc: TFNWndProc;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszMenuName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszClassName: string;
    hIconSm: HICON;
  end;
  TWndClassEx = tagWNDCLASSEX;
  TWndClassExA = tagWNDCLASSEXA;
  TWndClassExW = tagWNDCLASSEXW;
  WNDCLASSEX = tagWNDCLASSEX;
  WNDCLASSEXA = tagWNDCLASSEXA;
  WNDCLASSEXW = tagWNDCLASSEXW;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagWNDCLASS = packed record
    style: UINT;
    [MarshalAs(UnmanagedType.FunctionPtr)]
    lpfnWndProc: TFNWndProc;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszMenuName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszClassName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagWNDCLASSA = packed record
    style: UINT;
    [MarshalAs(UnmanagedType.FunctionPtr)]
    lpfnWndProc: TFNWndProc;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszMenuName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszClassName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagWNDCLASSW = packed record
    style: UINT;
    [MarshalAs(UnmanagedType.FunctionPtr)]
    lpfnWndProc: TFNWndProc;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszMenuName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszClassName: string;
  end;
  TWndClass = tagWNDCLASS;
  TWndClassA = tagWNDCLASSA;
  TWndClassW = tagWNDCLASSW;
  WNDCLASS = tagWNDCLASS;
  WNDCLASSA = tagWNDCLASSA;
  WNDCLASSW = tagWNDCLASSW;

{ Message structure }
  tagMSG = packed record
    hwnd: HWND;
    message: UINT;
    wParam: WPARAM;
    lParam: LPARAM;
    time: DWORD;
    pt: TPoint;
  end;
  TMsg = tagMSG;
  MSG = tagMSG;

function SmallPointToPoint(const P: TSmallPoint): TPoint;
function PointToSmallPoint(const P: TPoint): TSmallPoint;
function MakeWParam(l, h: Word): WPARAM;
function MakeLParam(l, h: Word): LPARAM;
function MakeLResult(l, h: Word): LRESULT;


const
{ Window field offsets for GetWindowLong() }

  GWL_WNDPROC = -4;
  GWL_HINSTANCE = -6;
  GWL_HWNDPARENT = -8;
  GWL_STYLE = -16;
  GWL_EXSTYLE = -20;
  GWL_USERDATA = -21;
  GWL_ID = -12;

  { Class field offsets for GetClassLong() }
  GCL_MENUNAME = -8;
  GCL_HBRBACKGROUND = -10;
  GCL_HCURSOR = -12;
  GCL_HICON = -14;
  GCL_HMODULE = -16;
  GCL_CBWNDEXTRA = -18;
  GCL_CBCLSEXTRA = -20;
  GCL_WNDPROC = -24;
  GCL_STYLE = -26;
  GCW_ATOM = -32;
  GCL_HICONSM = -34;

const
  { WM_ACTIVATE state values }
  WA_INACTIVE = 0;
  WA_ACTIVE = 1;
  WA_CLICKACTIVE = 2;

type
  { Struct pointed to by WM_GETMINMAXINFO lParam }
  tagMINMAXINFO = packed record
    ptReserved: TPoint;
    ptMaxSize: TPoint;
    ptMaxPosition: TPoint;
    ptMinTrackSize: TPoint;
    ptMaxTrackSize: TPoint;
  end;
  TMinMaxInfo = tagMINMAXINFO;
  MINMAXINFO = tagMINMAXINFO;

const
  { wParam for WM_POWER window message and DRV_POWER driver notification }
  PWR_OK = 1;
  PWR_FAIL = -1;
  PWR_SUSPENDREQUEST = 1;
  PWR_SUSPENDRESUME = 2;
  PWR_CRITICALRESUME = 3;

type
  { lParam of WM_COPYDATA message points to... }
  tagCOPYDATASTRUCT = packed record
    dwData: DWORD;
    cbData: DWORD;
    lpData: IntPtr; { Pointer }
  end;
  TCopyDataStruct = tagCOPYDATASTRUCT;
  COPYDATASTRUCT = tagCOPYDATASTRUCT;

const
  NFR_ANSI = 1;
  NFR_UNICODE = 2;
  NF_QUERY = 3;
  NF_REQUERY = 4;

  WHEEL_DELTA = 120;            { Value for rolling one detent }
  WHEEL_PAGESCROLL = MAXDWORD;  { Scroll one page }

  MENULOOP_WINDOW = 0;
  MENULOOP_POPUP = 1;

type
  tagMDINEXTMENU = packed record
    hmenuIn: HMENU;
    hmenuNext: HMENU;
    hwndNext: HWND;
  end;
  TMDINextMenu = tagMDINEXTMENU;
  MDINEXTMENU = tagMDINEXTMENU;

const
  { LOWORD(wParam) values in WM_*UISTATE* }
  UIS_SET = 1;
  UIS_CLEAR = 2;
  UIS_INITIALIZE = 3;

  { HIWORD(wParam) values in WM_*UISTATE* }
  UISF_HIDEFOCUS = $1;
  UISF_HIDEACCEL = $2;
  UISF_ACTIVE =$4;

const
  { wParam for WM_NOTIFYWOW message  }

  { wParam for WM_SIZING message  }
  WMSZ_LEFT = 1;
  WMSZ_RIGHT = 2;
  WMSZ_TOP = 3;
  WMSZ_TOPLEFT = 4;
  WMSZ_TOPRIGHT = 5;
  WMSZ_BOTTOM = 6;
  WMSZ_BOTTOMLEFT = 7;
  WMSZ_BOTTOMRIGHT = 8;

  { WM_SYNCTASK Commands }
  ST_BEGINSWP = 0;
  ST_ENDSWP = 1;

  { WM_NCHITTEST and MOUSEHOOKSTRUCT Mouse Position Codes }
  HTERROR = -2;
  HTTRANSPARENT = -1;
  HTNOWHERE = 0;
  HTCLIENT = 1;
  HTCAPTION = 2;
  HTSYSMENU = 3;
  HTGROWBOX = 4;
  HTSIZE = HTGROWBOX;
  HTMENU = 5;
  HTHSCROLL = 6;
  HTVSCROLL = 7;
  HTMINBUTTON = 8;
  HTMAXBUTTON = 9;
  HTLEFT = 10;
  HTRIGHT = 11;
  HTTOP = 12;
  HTTOPLEFT = 13;
  HTTOPRIGHT = 14;
  HTBOTTOM = 15;
  HTBOTTOMLEFT = $10;
  HTBOTTOMRIGHT = 17;
  HTBORDER = 18;
  HTREDUCE = HTMINBUTTON;
  HTZOOM = HTMAXBUTTON;
  HTSIZEFIRST = HTLEFT;
  HTSIZELAST = HTBOTTOMRIGHT;
  HTOBJECT = 19;
  HTCLOSE = 20;
  HTHELP = 21;

  { SendMessageTimeout values }
  SMTO_NORMAL = 0;
  SMTO_BLOCK = 1;
  SMTO_ABORTIFHUNG = 2;
  SMTO_NOTIMEOUTIFNOTHUNG = 8;

  { WM_MOUSEACTIVATE Return Codes }
  MA_ACTIVATE = 1;
  MA_ACTIVATEANDEAT = 2;
  MA_NOACTIVATE = 3;
  MA_NOACTIVATEANDEAT = 4;

  { WM_SETICON / WM_GETICON Type Codes }
  ICON_SMALL = 0;
  ICON_BIG = 1;
  ICON_SMALL2 = 2;

function RegisterWindowMessage(lpString: string): UINT;
function RegisterWindowMessageA(lpString: string): UINT;
function RegisterWindowMessageW(lpString: string): UINT;

const
  { WM_SIZE message wParam values }
  SIZE_RESTORED = 0;
  SIZE_MINIMIZED = 1;
  SIZE_MAXIMIZED = 2;
  SIZE_MAXSHOW = 3;
  SIZE_MAXHIDE = 4;

  { Obsolete constant names }
  SIZENORMAL = SIZE_RESTORED;
  SIZEICONIC = SIZE_MINIMIZED;
  SIZEFULLSCREEN = SIZE_MAXIMIZED;
  SIZEZOOMSHOW = SIZE_MAXSHOW;
  SIZEZOOMHIDE = SIZE_MAXHIDE;


type
  { WM_WINDOWPOSCHANGINGCHANGED struct pointed to by lParam }
  tagWINDOWPOS = packed record
    hwnd: HWND;
    hwndInsertAfter: HWND;
    x: Integer;
    y: Integer;
    cx: Integer;
    cy: Integer;
    flags: UINT;
  end;
  TWindowPos = tagWINDOWPOS;
  WINDOWPOS = tagWINDOWPOS;

  { WM_NCCALCSIZE parameter structure }
  tagNCCALCSIZE_PARAMS = packed record
    rgrc0: TRect; { rgrc: array[0..2] of TRect }
    rgrc1: TRect;
    rgrc2: TRect;
    lppos: IntPtr; { PWindowPos }
  end;
  TNCCalcSizeParams = tagNCCALCSIZE_PARAMS;
  NCCALCSIZE_PARAMS = tagNCCALCSIZE_PARAMS;


const
  { WM_NCCALCSIZE "window valid rect" return values }
  WVR_ALIGNTOP = $10;
  WVR_ALIGNLEFT = $20;
  WVR_ALIGNBOTTOM = $40;
  WVR_ALIGNRIGHT = $80;
  WVR_HREDRAW = $100;
  WVR_VREDRAW = $200;
  WVR_REDRAW = (WVR_HREDRAW or WVR_VREDRAW);
  WVR_VALIDRECTS = $400;

  { Key State Masks for Mouse Messages }
  MK_LBUTTON = 1;
  MK_RBUTTON = 2;
  MK_SHIFT = 4;
  MK_CONTROL = 8;
  MK_MBUTTON = $10;

  TME_HOVER           = $00000001;
  TME_LEAVE           = $00000002;
  TME_QUERY           = $40000000;
  TME_CANCEL          = DWORD($80000000);

  HOVER_DEFAULT       = DWORD($FFFFFFFF);

type
  [StructLayout(LayoutKind.Sequential)]
  tagTRACKMOUSEEVENT = record
    cbSize: DWORD;
    dwFlags: DWORD;
    hwndTrack: HWND;
    dwHoverTime: DWORD;
  end;
  TTrackMouseEvent = tagTRACKMOUSEEVENT;

function TrackMouseEvent(var EventTrack: TTrackMouseEvent): BOOL;

const
  { Window Styles }
  WS_OVERLAPPED = 0;
  WS_POPUP = DWORD($80000000);
  WS_CHILD = $40000000;
  WS_MINIMIZE = $20000000;
  WS_VISIBLE = $10000000;
  WS_DISABLED = $8000000;
  WS_CLIPSIBLINGS = $4000000;
  WS_CLIPCHILDREN = $2000000;
  WS_MAXIMIZE = $1000000;
  WS_CAPTION = $C00000;      { WS_BORDER or WS_DLGFRAME  }
  WS_BORDER = $800000;
  WS_DLGFRAME = $400000;
  WS_VSCROLL = $200000;
  WS_HSCROLL = $100000;
  WS_SYSMENU = $80000;
  WS_THICKFRAME = $40000;
  WS_GROUP = $20000;
  WS_TABSTOP = $10000;

  WS_MINIMIZEBOX = $20000;
  WS_MAXIMIZEBOX = $10000;

  WS_TILED = WS_OVERLAPPED;
  WS_ICONIC = WS_MINIMIZE;
  WS_SIZEBOX = WS_THICKFRAME;

  { Common Window Styles }
  WS_OVERLAPPEDWINDOW = (WS_OVERLAPPED or WS_CAPTION or WS_SYSMENU or
    WS_THICKFRAME or WS_MINIMIZEBOX or WS_MAXIMIZEBOX);
  WS_TILEDWINDOW = WS_OVERLAPPEDWINDOW;
  WS_POPUPWINDOW = (WS_POPUP or WS_BORDER or WS_SYSMENU);
  WS_CHILDWINDOW = (WS_CHILD);

  { Extended Window Styles }
  WS_EX_DLGMODALFRAME = 1;
  WS_EX_NOPARENTNOTIFY = 4;
  WS_EX_TOPMOST = 8;
  WS_EX_ACCEPTFILES = $10;
  WS_EX_TRANSPARENT = $20;
  WS_EX_MDICHILD = $40;
  WS_EX_TOOLWINDOW = $80;
  WS_EX_WINDOWEDGE = $100;
  WS_EX_CLIENTEDGE = $200;
  WS_EX_CONTEXTHELP = $400;

  WS_EX_RIGHT = $1000;
  WS_EX_LEFT = 0;
  WS_EX_RTLREADING = $2000;
  WS_EX_LTRREADING = 0;
  WS_EX_LEFTSCROLLBAR = $4000;
  WS_EX_RIGHTSCROLLBAR = 0;

  WS_EX_CONTROLPARENT = $10000;
  WS_EX_STATICEDGE = $20000;
  WS_EX_APPWINDOW = $40000;
  WS_EX_OVERLAPPEDWINDOW = (WS_EX_WINDOWEDGE or WS_EX_CLIENTEDGE);
  WS_EX_PALETTEWINDOW = (WS_EX_WINDOWEDGE or WS_EX_TOOLWINDOW or WS_EX_TOPMOST);

  WS_EX_LAYERED = $00080000;
  WS_EX_NOINHERITLAYOUT = $00100000; // Disable inheritence of mirroring by children
  WS_EX_LAYOUTRTL = $00400000; // Right to left mirroring
  WS_EX_COMPOSITED = $02000000;
  WS_EX_NOACTIVATE = $08000000;

  { Class styles }
  CS_VREDRAW = DWORD(1);
  CS_HREDRAW = DWORD(2);
  CS_KEYCVTWINDOW = 4;
  CS_DBLCLKS = 8;
  CS_OWNDC = $20;
  CS_CLASSDC = $40;
  CS_PARENTDC = $80;
  CS_NOKEYCVT = $100;
  CS_NOCLOSE = $200;
  CS_SAVEBITS = $800;
  CS_BYTEALIGNCLIENT = $1000;
  CS_BYTEALIGNWINDOW = $2000;
  CS_GLOBALCLASS = $4000;

  CS_IME = $10000;
  CS_DROPSHADOW = $20000;

  { WM_PRINT flags }
  PRF_CHECKVISIBLE = 1;
  PRF_NONCLIENT = 2;
  PRF_CLIENT = 4;
  PRF_ERASEBKGND = 8;
  PRF_CHILDREN = $10;
  PRF_OWNED = $20;

  { 3D border styles }
  BDR_RAISEDOUTER = 1;
  BDR_SUNKENOUTER = 2;
  BDR_RAISEDINNER = 4;
  BDR_SUNKENINNER = 8;

  BDR_OUTER = 3;
  BDR_INNER = 12;
  BDR_RAISED = 5;
  BDR_SUNKEN = 10;

  EDGE_RAISED = (BDR_RAISEDOUTER or BDR_RAISEDINNER);
  EDGE_SUNKEN = (BDR_SUNKENOUTER or BDR_SUNKENINNER);
  EDGE_ETCHED = (BDR_SUNKENOUTER or BDR_RAISEDINNER);
  EDGE_BUMP = (BDR_RAISEDOUTER or BDR_SUNKENINNER);

  { Border flags }
  BF_LEFT = 1;
  BF_TOP = 2;
  BF_RIGHT = 4;
  BF_BOTTOM = 8;

  BF_TOPLEFT = (BF_TOP or BF_LEFT);
  BF_TOPRIGHT = (BF_TOP or BF_RIGHT);
  BF_BOTTOMLEFT = (BF_BOTTOM or BF_LEFT);
  BF_BOTTOMRIGHT = (BF_BOTTOM or BF_RIGHT);
  BF_RECT = (BF_LEFT or BF_TOP or BF_RIGHT or BF_BOTTOM);

  BF_DIAGONAL = $10;

  { For diagonal lines, the BF_RECT flags specify the end point of the}
  { vector bounded by the rectangle parameter.}
  BF_DIAGONAL_ENDTOPRIGHT = (BF_DIAGONAL or BF_TOP or BF_RIGHT);
  BF_DIAGONAL_ENDTOPLEFT = (BF_DIAGONAL or BF_TOP or BF_LEFT);
  BF_DIAGONAL_ENDBOTTOMLEFT = (BF_DIAGONAL or BF_BOTTOM or BF_LEFT);
  BF_DIAGONAL_ENDBOTTOMRIGHT = (BF_DIAGONAL or BF_BOTTOM or BF_RIGHT);

  BF_MIDDLE = $800;   { Fill in the middle }
  BF_SOFT = $1000;    { For softer buttons }
  BF_ADJUST = $2000;  { Calculate the space left over }
  BF_FLAT = $4000;    { For flat rather than 3D borders }
  BF_MONO = $8000;    { For monochrome borders }

function DrawEdge(hdc: HDC; var qrc: TRect; edge: UINT; grfFlags: UINT): BOOL;

const
  { flags for DrawFrameControl }
  DFC_CAPTION = 1;
  DFC_MENU = 2;
  DFC_SCROLL = 3;
  DFC_BUTTON = 4;
  DFC_POPUPMENU = 5;

  DFCS_CAPTIONCLOSE = 0;
  DFCS_CAPTIONMIN = 1;
  DFCS_CAPTIONMAX = 2;
  DFCS_CAPTIONRESTORE = 3;
  DFCS_CAPTIONHELP = 4;

  DFCS_MENUARROW = 0;
  DFCS_MENUCHECK = 1;
  DFCS_MENUBULLET = 2;
  DFCS_MENUARROWRIGHT = 4;

  DFCS_SCROLLUP = 0;
  DFCS_SCROLLDOWN = 1;
  DFCS_SCROLLLEFT = 2;
  DFCS_SCROLLRIGHT = 3;
  DFCS_SCROLLCOMBOBOX = 5;
  DFCS_SCROLLSIZEGRIP = 8;
  DFCS_SCROLLSIZEGRIPRIGHT = $10;

  DFCS_BUTTONCHECK = 0;
  DFCS_BUTTONRADIOIMAGE = 1;
  DFCS_BUTTONRADIOMASK = 2;
  DFCS_BUTTONRADIO = 4;
  DFCS_BUTTON3STATE = 8;
  DFCS_BUTTONPUSH = $10;

  DFCS_INACTIVE = $100;
  DFCS_PUSHED = $200;
  DFCS_CHECKED = $400;
  DFCS_TRANSPARENT = $800;
  DFCS_HOT = $1000;
  DFCS_ADJUSTRECT = $2000;
  DFCS_FLAT = $4000;
  DFCS_MONO = $8000;

function DrawFrameControl(DC: HDC; const Rect: TRect; uType, uState: UINT): BOOL;

const
  { flags for DrawCaption }
  DC_ACTIVE = 1;
  DC_SMALLCAP = 2;
  DC_ICON = 4;
  DC_TEXT = 8;
  DC_INBUTTON = $10;
  DC_GRADIENT = $20;
  DC_BUTTONS = $1000;

{+ !! doesn't match help !!!}
function DrawCaption(p1: HWND; p2: HDC; const p3: TRect; p4: UINT): BOOL;

const
  IDANI_OPEN = 1;
  IDANI_CLOSE = 2;
  IDANI_CAPTION = 3;

function DrawAnimatedRects(hwnd: HWND; idAni: Integer; const lprcFrom, lprcTo: TRect): BOOL;

const
  { Predefined Clipboard Formats }
  CF_TEXT = 1;
  CF_BITMAP = 2;
  CF_METAFILEPICT = 3;
  CF_SYLK = 4;
  CF_DIF = 5;
  CF_TIFF = 6;
  CF_OEMTEXT = 7;
  CF_DIB = 8;
  CF_PALETTE = 9;
  CF_PENDATA = 10;
  CF_RIFF = 11;
  CF_WAVE = 12;
  CF_UNICODETEXT = 13;
  CF_ENHMETAFILE = 14;
  CF_HDROP = 15;
  CF_LOCALE = $10;
  CF_MAX = 17;

  CF_OWNERDISPLAY = 128;
  CF_DSPTEXT = 129;
  CF_DSPBITMAP = 130;
  CF_DSPMETAFILEPICT = 131;
  CF_DSPENHMETAFILE = 142;

  { "Private" formats don't get GlobalFree()'d }
  CF_PRIVATEFIRST = $200;
  CF_PRIVATELAST = 767;

  { "GDIOBJ" formats do get DeleteObject()'d }
  CF_GDIOBJFIRST = 768;
  CF_GDIOBJLAST = 1023;


  { Defines for the fVirt field of the Accelerator table structure. }
  FVIRTKEY = 1;
  FNOINVERT = 2;
  FSHIFT = 4;
  FCONTROL = 8;
  FALT = $10;

type
  tagACCEL = packed record
    fVirt: Word;     { Also called the flags field }
    key: Word;
    cmd: Word;
  end;
  TAccel = tagACCEL;
  ACCEL = tagACCEL;

  tagPAINTSTRUCT = packed record
    hdc: HDC;
    fErase: BOOL;
    rcPaint: TRect;
    fRestore: BOOL;
    fIncUpdate: BOOL;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=32)]
    rgbReserved: array[0..31] of Byte;
  end;
  TPaintStruct = tagPAINTSTRUCT;
  PAINTSTRUCT = tagPAINTSTRUCT;

  tagWINDOWPLACEMENT = packed record
    length: UINT;
    flags: UINT;
    showCmd: UINT;
    ptMinPosition: TPoint;
    ptMaxPosition: TPoint;
    rcNormalPosition: TRect;
  end;
  TWindowPlacement = tagWINDOWPLACEMENT;
  WINDOWPLACEMENT = tagWINDOWPLACEMENT;

const
  WPF_SETMINPOSITION = 1;
  WPF_RESTORETOMAXIMIZED = 2;

type
  tagNMHDR = packed record
    hwndFrom: HWND;
    idFrom: UINT;
    code: Integer;     { NM_ code }
  end;
  TNMHdr = tagNMHDR;
  NMHDR = tagNMHDR;

  tagSTYLESTRUCT = packed record
    styleOld: DWORD;
    styleNew: DWORD;
  end;
  TStyleStruct = tagSTYLESTRUCT;
  STYLESTRUCT = tagSTYLESTRUCT;

const
  { Owner draw control types }
  ODT_MENU = 1;
  ODT_LISTBOX = 2;
  ODT_COMBOBOX = 3;
  ODT_BUTTON = 4;
  ODT_STATIC = 5;

  { Owner draw actions }
  ODA_DRAWENTIRE = 1;
  ODA_SELECT = 2;
  ODA_FOCUS = 4;

  { Owner draw state }
  ODS_SELECTED = 1;
  ODS_GRAYED = 2;
  ODS_DISABLED = 4;
  ODS_CHECKED = 8;
  ODS_FOCUS = $10;
  ODS_DEFAULT = $20;
  ODS_COMBOBOXEDIT = $1000;
  ODS_HOTLIGHT = $40;
  ODS_INACTIVE = $80;

type
  TOwnerDrawState = set of (odSelected, odGrayed, odDisabled, odChecked,
    odFocused, odDefault, odHotLight, odInactive, odNoAccel, odNoFocusRect,
    odReserved1, odReserved2, odComboBoxEdit);

type
  { for ownerdraw }
  tagMEASUREITEMSTRUCT = packed record
    CtlType: UINT;
    CtlID: UINT;
    itemID: UINT;
    itemWidth: UINT;
    itemHeight: UINT;
    itemData: DWORD;
  end;
  TMeasureItemStruct = tagMEASUREITEMSTRUCT;
  MEASUREITEMSTRUCT = tagMEASUREITEMSTRUCT;

  { for ownerdraw }
  tagDRAWITEMSTRUCT = packed record
    CtlType: UINT;
    CtlID: UINT;
    itemID: UINT;
    itemAction: UINT;
    itemState: UINT;
    hwndItem: HWND;
    hDC: HDC;
    rcItem: TRect;
    itemData: DWORD;
  end;
  TDrawItemStruct = tagDRAWITEMSTRUCT;
  DRAWITEMSTRUCT = tagDRAWITEMSTRUCT;

  { for ownerdraw }
  tagDELETEITEMSTRUCT = packed record
    CtlType: UINT;
    CtlID: UINT;
    itemID: UINT;
    hwndItem: HWND;
    itemData: UINT;
  end;
  TDeleteItemStruct = tagDELETEITEMSTRUCT;
  DELETEITEMSTRUCT = tagDELETEITEMSTRUCT;

  { for ownerdraw sorting }
  tagCOMPAREITEMSTRUCT = packed record
    CtlType: UINT;
    CtlID: UINT;
    hwndItem: HWND;
    itemID1: UINT;
    itemData1: DWORD;
    itemID2: UINT;
    itemData2: DWORD;
    dwLocaleId: DWORD;
  end;
  TCompareItemStruct = tagCOMPAREITEMSTRUCT;
  COMPAREITEMSTRUCT = tagCOMPAREITEMSTRUCT;

{ Message Function Templates }

function GetMessage(out lpMsg: TMsg; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax: UINT): BOOL;
function GetMessageA(out lpMsg: TMsg; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax: UINT): BOOL;
function GetMessageW(out lpMsg: TMsg; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax: UINT): BOOL;
function DispatchMessage(const lpMsg: TMsg): Longint;
function DispatchMessageA(const lpMsg: TMsg): Longint;
function DispatchMessageW(const lpMsg: TMsg): Longint;
function TranslateMessage(const lpMsg: TMsg): BOOL;
function SetMessageQueue(cMessagesMax: Integer): BOOL;
function PeekMessage(out lpMsg: TMsg; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax, wRemoveMsg: UINT): BOOL;
function PeekMessageA(out lpMsg: TMsg; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax, wRemoveMsg: UINT): BOOL;
function PeekMessageW(out lpMsg: TMsg; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax, wRemoveMsg: UINT): BOOL;

const
  { PeekMessage() Options }
  PM_NOREMOVE = 0;
  PM_REMOVE = 1;
  PM_NOYIELD = 2;

function RegisterHotKey(hWnd: HWND; id: Integer; fsModifiers, vk: UINT): BOOL;
function UnregisterHotKey(hWnd: HWND; id: Integer): BOOL;

const
  MOD_ALT = 1;
  MOD_CONTROL = 2;
  MOD_SHIFT = 4;
  MOD_WIN = 8;

  IDHOT_SNAPWINDOW = -1;    { SHIFT-PRINTSCRN  }
  IDHOT_SNAPDESKTOP = -2;   { PRINTSCRN        }

  EW_RESTARTWINDOWS        = $0042;
  EW_REBOOTSYSTEM          = $0043;
  EW_EXITANDEXECAPP        = $0044;

  ENDSESSION_LOGOFF        = DWORD($80000000);

  EWX_LOGOFF = 0;
  EWX_SHUTDOWN = 1;
  EWX_REBOOT = 2;
  EWX_FORCE = 4;
  EWX_POWEROFF = 8;
  EWX_FORCEIFHUNG = $10;


function ExitWindows(dwReserved: DWORD; Code: Word): BOOL;

function ExitWindowsEx(uFlags: UINT; dwReserved: DWORD): BOOL;
function SwapMouseButton(fSwap: BOOL): BOOL;
function GetMessagePos: DWORD;
function GetMessageTime: Longint;
function GetMessageExtraInfo: Longint;
function SetMessageExtraInfo(lParam: LPARAM): LPARAM;

function SendMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function SendMessageA(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function SendMessageW(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function SendMessageTimeout(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; fuFlags, uTimeout: UINT; [in] var lpdwResult: DWORD): LRESULT;
function SendMessageTimeoutA(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; fuFlags, uTimeout: UINT; [in] var lpdwResult: DWORD): LRESULT;
function SendMessageTimeoutW(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; fuFlags, uTimeout: UINT; [in] var lpdwResult: DWORD): LRESULT;
function SendNotifyMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM): BOOL;
function SendNotifyMessageA(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM): BOOL;
function SendNotifyMessageW(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM): BOOL;
function SendMessageCallback(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; lpResultCallBack: TFNSendAsyncProc; dwData: DWORD): BOOL;
function SendMessageCallbackA(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; lpResultCallBack: TFNSendAsyncProc; dwData: DWORD): BOOL;
function SendMessageCallbackW(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; lpResultCallBack: TFNSendAsyncProc; dwData: DWORD): BOOL;
function BroadcastSystemMessage(Flags: DWORD; [in] var Recipients: DWORD; uiMessage: UINT;
  wParam: WPARAM; lParam: LPARAM): Longint; overload;
function BroadcastSystemMessage(Flags: DWORD; Recipients: IntPtr; uiMessage: UINT;
  wParam: WPARAM; lParam: LPARAM): Longint; overload;
function BroadcastSystemMessageA(Flags: DWORD; [in] var Recipients: DWORD;
  uiMessage: UINT; wParam: WPARAM; lParam: LPARAM): Longint;
function BroadcastSystemMessageW(Flags: DWORD; [in] var Recipients: DWORD;
  uiMessage: UINT; wParam: WPARAM; lParam: LPARAM): Longint;

const
  { Broadcast Special Message Recipient list }
  BSM_ALLCOMPONENTS = $00000000;
  BSM_VXDS = $00000001;
  BSM_NETDRIVER = $00000002;
  BSM_INSTALLABLEDRIVERS = $00000004;
  BSM_APPLICATIONS = $00000008;
  BSM_ALLDESKTOPS = $00000010;

  { Broadcast Special Message Flags }
  BSF_QUERY = $00000001;
  BSF_IGNORECURRENTTASK = $00000002;
  BSF_FLUSHDISK = $00000004;
  BSF_NOHANG = $00000008;
  BSF_POSTMESSAGE = $00000010;
  BSF_FORCEIFHUNG = $00000020;
  BSF_NOTIMEOUTIFNOTHUNG = $00000040;

type
  tagBROADCASTSYSMSG = packed record
    uiMessage: UINT;
    wParam: WPARAM;
    lParam: LPARAM;
  end;
  TBroadcastSysMsg = tagBROADCASTSYSMSG;
  BROADCASTSYSMSG = tagBROADCASTSYSMSG;

const
  DBWF_LPARAMPOINTER = $8000;

  BROADCAST_QUERY_DENY = $424D5144;  { Return this value to deny a query. }

type
  HDEVNOTIFY = IntPtr;

const
  DEVICE_NOTIFY_WINDOW_HANDLE = 0;

function RegisterDeviceNotification(hRecipient: THandle; NotificationFilter: IntPtr; Flags: DWORD): HDEVNOTIFY;
function RegisterDeviceNotificationA(hRecipient: THandle; NotificationFilter: IntPtr; Flags: DWORD): HDEVNOTIFY;
function RegisterDeviceNotificationW(hRecipient: THandle; NotificationFilter: IntPtr; Flags: DWORD): HDEVNOTIFY;
function UnregisterDeviceNotification(Handle: HDEVNOTIFY): BOOL;

function PostMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
function PostMessageA(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
function PostMessageW(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
function PostThreadMessage(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
function PostThreadMessageA(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
function PostThreadMessageW(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
function PostAppMessage(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
function PostAppMessageA(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
function PostAppMessageW(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;

const
  { Special HWND value for use with PostMessage() and SendMessage() }
  HWND_BROADCAST = $FFFF;
  wnd_Broadcast = HWND_BROADCAST;

  HWND_MESSAGE = -3;
  wnd_Message = HWND_MESSAGE;

function AttachThreadInput(idAttach, idAttachTo: DWORD; fAttach: BOOL): BOOL;
function ReplyMessage(lResult: LRESULT): BOOL;
function WaitMessage: BOOL;
function WaitForInputIdle(hProcess: THandle; dwMilliseconds: DWORD): DWORD;
function DefWindowProc(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function DefWindowProcA(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function DefWindowProcW(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function CallWindowProc(lpPrevWndFunc: TFNWndProc; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; overload;
function CallWindowProcA(lpPrevWndFunc: TFNWndProc; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; overload;
function CallWindowProcW(lpPrevWndFunc: TFNWndProc; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; overload;
function CallWindowProc(lpPrevWndFunc: IntPtr; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; overload;
function CallWindowProcA(lpPrevWndFunc: IntPtr; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; overload;
function CallWindowProcW(lpPrevWndFunc: IntPtr; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; overload;
procedure PostQuitMessage(nExitCode: Integer);
function InSendMessage: BOOL;
function InSendMessageEx(lpReserved: IntPtr): DWORD;

const
  { InSendMessageEx return value }
  ISMEX_NOSEND = 0;
  ISMEX_SEND = 1;
  ISMEX_NOTIFY = 2;
  ISMEX_CALLBACK = 4;
  ISMEX_REPLIED = 8;

function GetDoubleClickTime: UINT;
function SetDoubleClickTime(Interval: UINT): BOOL;

type
  { In WINDOWS.H GetClassInfo takes a WNDCLASS. We cannot do that since the
    marshalling rules are different between GetClassInfo and RegisterClass.
    This structure should be used for getting the information and the
    lpfnWndProc should be called via CallWndProc. The lpszMenuName and
    lpszClassName can be retrived via System.Runtime.InteropServices.Marshal.PtrToStringAuto }
  TWndClassInfo = packed record
    style: UINT;
    lpfnWndProc: IntPtr;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName: IntPtr;
    lpszClassName: IntPtr;
  end;

  TWndClassInfoEx = packed record
    cbSize: UINT;
    style: UINT;
    lpfnWndProc: NativeInt;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName: IntPtr;
    lpszClassName: IntPtr;
    hIconSm: HICON;
  end;


function RegisterClass(const lpWndClass: TWndClass): ATOM; overload;
function RegisterClass(const lpWndClassInfo: TWndClassInfo): ATOM; overload;
function RegisterClassA(const lpWndClass: TWndClassA): ATOM;
function RegisterClassW(const lpWndClass: TWndClassW): ATOM;
function UnregisterClass(lpClassName: string; hInstance: HINST): BOOL;
function UnregisterClassA(lpClassName: string; hInstance: HINST): BOOL;
function UnregisterClassW(lpClassName: string; hInstance: HINST): BOOL;

function GetClassInfo(hInstance: HINST; lpClassName: string;
  out lpWndClass: TWndClassInfo): BOOL;
function GetClassInfoA(hInstance: HINST; lpClassName: string;
  out lpWndClass: TWndClassInfo): BOOL;
function GetClassInfoW(hInstance: HINST; lpClassName: string;
  out lpWndClass: TWndClassInfo): BOOL;
function RegisterClassEx(const WndClass: TWndClassEx): ATOM; overload;
function RegisterClassEx(const WndClass: TWndClassInfoEx): ATOM; overload;
function RegisterClassExA(const WndClass: TWndClassExA): ATOM;
function RegisterClassExW(const WndClass: TWndClassExW): ATOM;
function GetClassInfoEx(Instance: HINST; Classname: string; out WndClass: TWndClassInfoEx): BOOL;
function GetClassInfoExA(Instance: HINST; Classname: string; out WndClass: TWndClassInfoEx): BOOL;
function GetClassInfoExW(Instance: HINST; Classname: string; out WndClass: TWndClassInfoEx): BOOL;

const
  CW_USEDEFAULT = DWORD($80000000);

  { Special value for CreateWindow, et al. }
  HWND_DESKTOP = 0;

type
  tagCLIENTCREATESTRUCT = packed record
    hWindowMenu: THandle;
    idFirstChild: UINT;
  end;
  TClientCreateStruct = tagCLIENTCREATESTRUCT;
  CLIENTCREATESTRUCT = tagCLIENTCREATESTRUCT;

function CreateWindowEx(dwExStyle: DWORD; lpClassName: string;
  lpWindowName: string; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; const lpParam: TCreateStruct): HWND; overload;
function CreateWindowEx(dwExStyle: DWORD; lpClassName: string;
  lpWindowName: string; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; const lpParam: TClientCreateStruct): HWND; overload;
function CreateWindowEx(dwExStyle: DWORD; lpClassName: string;
  lpWindowName: string; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; lpParam: IntPtr): HWND; overload;
function CreateWindowEx(dwExStyle: DWORD; lpClassName: string;
  lpWindowName: IntPtr; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; lpParam: IntPtr): HWND; overload;
function CreateWindowExA(dwExStyle: DWORD; lpClassName: string;
  lpWindowName: string; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; lpParam: IntPtr): HWND;
function CreateWindowExW(dwExStyle: DWORD; lpClassName: string;
  lpWindowName: string; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; lpParam: IntPtr): HWND;

function CreateWindow(lpClassName: string; lpWindowName: string;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer; hWndParent: HWND;
  hMenu: HMENU; hInstance: HINST; const lpParam: TCreateStruct): HWND; overload;
function CreateWindow(lpClassName: string; lpWindowName: string;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer; hWndParent: HWND;
  hMenu: HMENU; hInstance: HINST; const lpParam: TClientCreateStruct): HWND; overload;
function CreateWindow(lpClassName: string; lpWindowName: string;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer; hWndParent: HWND;
  hMenu: HMENU; hInstance: HINST; lpParam: IntPtr): HWND; overload;
function CreateWindow(lpClassName: string; lpWindowName: IntPtr;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer; hWndParent: HWND;
  hMenu: HMENU; hInstance: HINST; lpParam: IntPtr): HWND; overload;
function CreateWindowA(lpClassName: string; lpWindowName: string;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer; hWndParent: HWND;
  hMenu: HMENU; hInstance: HINST; lpParam: IntPtr): HWND;
function CreateWindowW(lpClassName: string; lpWindowName: string;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer; hWndParent: HWND;
  hMenu: HMENU; hInstance: HINST; lpParam: IntPtr): HWND;

function IsWindow(hWnd: HWND): BOOL;
function IsMenu(hMenu: HMENU): BOOL;
function IsChild(hWndParent, hWnd: HWND): BOOL;
function DestroyWindow(hWnd: HWND): BOOL;
function ShowWindow(hWnd: HWND; nCmdShow: Integer): BOOL;
function AnimateWindow(hWnd: HWND; dwTime: DWORD; dwFlags: DWORD): BOOL;
function ShowWindowAsync(hWnd: HWND; nCmdShow: Integer): BOOL;
function FlashWindow(hWnd: HWND; bInvert: BOOL): BOOL;

function UpdateLayeredWindow(Handle: THandle; hdcDest: HDC; const pptDst: TPoint;
  const _psize: TSize; hdcSrc: HDC; const pptSrc: TPoint;
  crKey: COLORREF; const pblend: TBLENDFUNCTION; dwFlags: DWORD): Boolean; overload;
function UpdateLayeredWindow(Handle: THandle; hdcDest: HDC; pptDst: IntPtr;
  _psize: IntPtr; hdcSrc: HDC; pptSrc: IntPtr;
  crKey: COLORREF; const pblend: TBLENDFUNCTION; dwFlags: DWORD): Boolean; overload;
function UpdateLayeredWindow(Handle: THandle; hdcDest: HDC; pptDst: IntPtr;
  const _psize: TSize; hdcSrc: HDC; const pptSrc: TPoint;
  crKey: COLORREF; const pblend: TBLENDFUNCTION; dwFlags: DWORD): Boolean; overload;
function UpdateLayeredWindow(Handle: THandle; hdcDest: HDC; const pptDst: TPoint;
  _psize: IntPtr; hdcSrc: HDC; pptSrc: IntPtr;
  crKey: COLORREF; const pblend: TBLENDFUNCTION; dwFlags: DWORD): Boolean; overload;
function UpdateLayeredWindow(Handle: THandle; hdcDest: HDC; const pptDst: TPoint;
  _psize: IntPtr; hdcSrc: HDC; const pptSrc: TPoint;
  crKey: COLORREF; const pblend: TBLENDFUNCTION; dwFlags: DWORD): Boolean; overload;
function UpdateLayeredWindow(Handle: THandle; hdcDest: HDC; pptDst: IntPtr;
  const _psize: TSize; hdcSrc: HDC; pptSrc: IntPtr;
  crKey: COLORREF; const pblend: TBLENDFUNCTION; dwFlags: DWORD): Boolean; overload;
function UpdateLayeredWindow(Handle: THandle; hdcDest: HDC; const pptDst: TPoint;
  const _psize: TSize; hdcSrc: HDC; pptSrc: IntPtr;
  crKey: COLORREF; const pblend: TBLENDFUNCTION; dwFlags: DWORD): Boolean; overload;
function UpdateLayeredWindow(Handle: THandle; hdcDest: HDC; pptDst: IntPtr;
  _psize: IntPtr; hdcSrc: HDC; const pptSrc: TPoint;
  crKey: COLORREF; const pblend: TBLENDFUNCTION; dwFlags: DWORD): Boolean; overload;

function SetLayeredWindowAttributes(Hwnd: THandle; crKey: COLORREF; bAlpha: Byte; dwFlags: DWORD): Boolean;

const
  LWA_COLORKEY = $00000001;
  LWA_ALPHA = $00000002;

  ULW_COLORKEY = $00000001;
  ULW_ALPHA = $00000002;
  ULW_OPAQUE = $00000004;

type
  [StructLayout(LayoutKind.Sequential)]
  FLASHWINFO = record
    cbSize: UINT;
    hwnd: HWND;
    dwFlags: DWORD;
    uCount: UINT;
    dwTimeout: DWORD;
  end;
  TFlashWInfo = FLASHWINFO;

function FlashWindowEx(const pfwi: FLASHWINFO): BOOL;

const
  FLASHW_STOP = $0;
  FLASHW_CAPTION = $1;
  FLASHW_TRAY = $2;
  FLASHW_ALL = FLASHW_CAPTION or FLASHW_TRAY;
  FLASHW_TIMER = $4;
  FLASHW_TIMERNOFG = $C;

function ShowOwnedPopups(hWnd: HWND; fShow: BOOL): BOOL;
function OpenIcon(hWnd: HWND): BOOL;
function CloseWindow(hWnd: HWND): BOOL;
function MoveWindow(hWnd: HWND; X, Y, nWidth, nHeight: Integer; bRepaint: BOOL): BOOL;
function SetWindowPos(hWnd: HWND; hWndInsertAfter: HWND;
  X, Y, cx, cy: Integer; uFlags: UINT): BOOL;
function GetWindowPlacement(hWnd: HWND; out WindowPlacement: TWindowPlacement): BOOL;
function SetWindowPlacement(hWnd: HWND; const WindowPlacement: TWindowPlacement): BOOL;
function BeginDeferWindowPos(nNumWindows: Integer): HDWP;
function DeferWindowPos(hWinPosInfo: HDWP; hWnd: HWND;
  hWndInsertAfter: HWND; x, y, cx, cy: Integer; uFlags: UINT): HDWP;
function EndDeferWindowPos(hWinPosInfo: HDWP): BOOL;
function IsWindowVisible(hWnd: HWND): BOOL;
function IsIconic(hWnd: HWND): BOOL;
function AnyPopup: BOOL;
function BringWindowToTop(hWnd: HWND): BOOL;
function IsZoomed(hWnd: HWND): BOOL;


const
  { SetWindowPos Flags }
  SWP_NOSIZE = 1;
  SWP_NOMOVE = 2;
  SWP_NOZORDER = 4;
  SWP_NOREDRAW = 8;
  SWP_NOACTIVATE = $10;
  SWP_FRAMECHANGED = $20;    { The frame changed: send WM_NCCALCSIZE }
  SWP_SHOWWINDOW = $40;
  SWP_HIDEWINDOW = $80;
  SWP_NOCOPYBITS = $100;
  SWP_NOOWNERZORDER = $200;  { Don't do owner Z ordering }
  SWP_NOSENDCHANGING = $400;  { Don't send WM_WINDOWPOSCHANGING }
  SWP_DRAWFRAME = SWP_FRAMECHANGED;
  SWP_NOREPOSITION = SWP_NOOWNERZORDER;
  SWP_DEFERERASE = $2000;
  SWP_ASYNCWINDOWPOS = $4000;

  HWND_TOP = 0;
  HWND_BOTTOM = 1;
  HWND_TOPMOST = HWND(-1);
  HWND_NOTOPMOST = HWND(-2);


type
  DLGTEMPLATE = packed record
    style: DWORD;
    dwExtendedStyle: DWORD;
    cdit: Word;
    x: SHORT;
    y: SHORT;
    cx: SHORT;
    cy: SHORT;
  end;
  TDlgTemplate = DLGTEMPLATE;

  { 32 bit Dialog item template. }
  DLGITEMTEMPLATE = packed record
    style: DWORD;
    dwExtendedStyle: DWORD;
    x: SHORT;
    y: SHORT;
    cx: SHORT;
    cy: SHORT;
    id: Word;
  end;
  TDlgItemTemplate = DLGITEMTEMPLATE;

function CreateDialogParam(hInstance: HINST; lpTemplateName: string;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND;
function CreateDialogParamA(hInstance: HINST; lpTemplateName: string;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND;
function CreateDialogParamW(hInstance: HINST; lpTemplateName: string;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND;
function CreateDialogIndirectParam(hInstance: HINST; const lpTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND;
function CreateDialogIndirectParamA(hInstance: HINST; const lpTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND;
function CreateDialogIndirectParamW(hInstance: HINST; const lpTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND;
function CreateDialog(hInstance: HINST; lpTemplateName: string;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): HWND;
function CreateDialogA(hInstance: HINST; lpTemplateName: string;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): HWND;
function CreateDialogW(hInstance: HINST; lpTemplateName: string;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): HWND;
function CreateDialogIndirect(hInstance: HINST; const lpTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): HWND;
function CreateDialogIndirectA(hInstance: HINST; const lpTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): HWND;
function CreateDialogIndirectW(hInstance: HINST; const lpTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): HWND;
function DialogBoxParam(hInstance: HINST; lpTemplateName: string;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer;
function DialogBoxParamA(hInstance: HINST; lpTemplateName: string;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer;
function DialogBoxParamW(hInstance: HINST; lpTemplateName: string;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer;
function DialogBoxIndirectParam(hInstance: HINST; const lpDialogTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer;
function DialogBoxIndirectParamA(hInstance: HINST; const lpDialogTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer;
function DialogBoxIndirectParamW(hInstance: HINST; const lpDialogTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer;
function DialogBox(hInstance: HINST; lpTemplate: string;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): Integer;
function DialogBoxA(hInstance: HINST; lpTemplate: string;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): Integer;
function DialogBoxW(hInstance: HINST; lpTemplate: string;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): Integer;
function DialogBoxIndirect(hInstance: HINST; const lpDialogTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): Integer;
function DialogBoxIndirectA(hInstance: HINST; const lpDialogTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): Integer;
function DialogBoxIndirectW(hInstance: HINST; const lpDialogTemplate: TDlgTemplate;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc): Integer;
function EndDialog(hDlg: HWND; nResult: Integer): BOOL;
function GetDlgItem(hDlg: HWND; nIDDlgItem: Integer): HWND;
function SetDlgItemInt(hDlg: HWND; nIDDlgItem: Integer; uValue: UINT; bSigned: BOOL): BOOL;
function GetDlgItemInt(hDlg: HWND; nIDDlgItem: Integer;
  out lpTranslated: BOOL; bSigned: BOOL): UINT;
function SetDlgItemText(hDlg: HWND; nIDDlgItem: Integer; lpString: string): BOOL;
function SetDlgItemTextA(hDlg: HWND; nIDDlgItem: Integer; lpString: string): BOOL;
function SetDlgItemTextW(hDlg: HWND; nIDDlgItem: Integer; lpString: string): BOOL;
function GetDlgItemText(hDlg: HWND; nIDDlgItem: Integer;
  lpString: string; nMaxCount: Integer): UINT;
function GetDlgItemTextA(hDlg: HWND; nIDDlgItem: Integer;
  lpString: string; nMaxCount: Integer): UINT;
function GetDlgItemTextW(hDlg: HWND; nIDDlgItem: Integer;
  lpString: string; nMaxCount: Integer): UINT;
function CheckDlgButton(hDlg: HWND; nIDButton: Integer; uCheck: UINT): BOOL;
function CheckRadioButton(hDlg: HWND; nIDFirstButton, nIDLastButton, nIDCheckButton: Integer): BOOL;
function IsDlgButtonChecked(hDlg: HWND; nIDButton: Integer): UINT;
function SendDlgItemMessage(hDlg: HWND; nIDDlgItem: Integer;
  Msg: UINT; wParam: WPARAM; lParam: LPARAM): Longint;
function SendDlgItemMessageA(hDlg: HWND; nIDDlgItem: Integer;
  Msg: UINT; wParam: WPARAM; lParam: LPARAM): Longint;
function SendDlgItemMessageW(hDlg: HWND; nIDDlgItem: Integer;
  Msg: UINT; wParam: WPARAM; lParam: LPARAM): Longint;
function GetNextDlgGroupItem(hDlg: HWND; hCtl: HWND; bPrevious: BOOL): HWND;
function GetNextDlgTabItem(hDlg: HWND; hCtl: HWND; bPrevious: BOOL): HWND;
function GetDlgCtrlID(hWnd: HWND): Integer;
function GetDialogBaseUnits: Longint;
function DefDlgProc(hDlg: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function DefDlgProcA(hDlg: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function DefDlgProcW(hDlg: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;

const
  { Window extra byted needed for private dialog classes. }
  DLGWINDOWEXTRA = 30;

function CallMsgFilter(const lpMsg: TMsg; nCode: Integer): BOOL;
function CallMsgFilterA(const lpMsg: TMsg; nCode: Integer): BOOL;
function CallMsgFilterW(const lpMsg: TMsg; nCode: Integer): BOOL;

{ Clipboard Manager Functions }

function OpenClipboard(hWndNewOwner: HWND): BOOL;
function CloseClipboard: BOOL;
function GetClipboardSequenceNumber: DWORD;
function GetClipboardOwner: HWND;
function SetClipboardViewer(hWndNewViewer: HWND): HWND;
function GetClipboardViewer: HWND;
function ChangeClipboardChain(hWndRemove, hWndNewNext: HWND): BOOL;
function SetClipboardData(uFormat: UINT; hMem: THandle): THandle;
function GetClipboardData(uFormat: UINT): THandle;
function RegisterClipboardFormat(lpszFormat: string): UINT;
function RegisterClipboardFormatA(lpszFormat: string): UINT;
function RegisterClipboardFormatW(lpszFormat: string): UINT;
function CountClipboardFormats: Integer;
function EnumClipboardFormats(format: UINT): UINT;
function GetClipboardFormatName(format: UINT; lpszFormatName: StringBuilder;
  cchMaxCount: Integer): Integer;
function GetClipboardFormatNameA(format: UINT; lpszFormatName: StringBuilder;
  cchMaxCount: Integer): Integer;
function GetClipboardFormatNameW(format: UINT; lpszFormatName: StringBuilder;
  cchMaxCount: Integer): Integer;
function EmptyClipboard: BOOL;
function IsClipboardFormatAvailable(format: UINT): BOOL;
function GetPriorityClipboardFormat([in] paFormatPriorityList: array of DWORD;
  cFormats: Integer): Integer;
function GetOpenClipboardWindow: HWND;

{ Character Translation Routines }

function CharToOem(lpszSrc: string; lpszDst: StringBuilder): BOOL;
function CharToOemA(lpszSrc: string; lpszDst: StringBuilder): BOOL;
function CharToOemW(lpszSrc: string; lpszDst: StringBuilder): BOOL;
function OemToChar(lpszSrc: string; lpszDst: StringBuilder): BOOL;
function OemToCharA(lpszSrc: string; lpszDst: StringBuilder): BOOL;
function OemToCharW(lpszSrc: string; lpszDst: StringBuilder): BOOL;
function CharToOemBuff(lpszSrc: string; lpszDst: StringBuilder; cchDstLength: DWORD): BOOL;
function CharToOemBuffA(lpszSrc: string; lpszDst: StringBuilder; cchDstLength: DWORD): BOOL;
function CharToOemBuffW(lpszSrc: string; lpszDst: StringBuilder; cchDstLength: DWORD): BOOL;
function OemToCharBuff(lpszSrc: string; lpszDst: StringBuilder; cchDstLength: DWORD): BOOL;
function OemToCharBuffA(lpszSrc: string; lpszDst: StringBuilder; cchDstLength: DWORD): BOOL;
function OemToCharBuffW(lpszSrc: string; lpszDst: StringBuilder; cchDstLength: DWORD): BOOL;
function CharUpper(lpsz: IntPtr): IntPtr;
function CharUpperA(lpsz: IntPtr): IntPtr;
function CharUpperW(lpsz: IntPtr): IntPtr;
function CharUpperBuff(lpsz: StringBuilder; cchLength: DWORD): DWORD;
function CharUpperBuffA(lpsz: StringBuilder; cchLength: DWORD): DWORD;
function CharUpperBuffW(lpsz: StringBuilder; cchLength: DWORD): DWORD;
function CharLower(lpsz: IntPtr): IntPtr;
function CharLowerA(lpsz: IntPtr): IntPtr;
function CharLowerW(lpsz: IntPtr): IntPtr;
function CharLowerBuff(lpsz: StringBuilder; cchLength: DWORD): DWORD;
function CharLowerBuffA(lpsz: StringBuilder; cchLength: DWORD): DWORD;
function CharLowerBuffW(lpsz: StringBuilder; cchLength: DWORD): DWORD;
function CharNext(lpsz: IntPtr): IntPtr;
function CharNextA(lpsz: IntPtr): IntPtr;
function CharNextW(lpsz: IntPtr): IntPtr;
function CharPrev(lpszStart: IntPtr; lpszCurrent: IntPtr): IntPtr;
function CharPrevA(lpszStart: IntPtr; lpszCurrent: IntPtr): IntPtr;
function CharPrevW(lpszStart: IntPtr; lpszCurrent: IntPtr): IntPtr;

function CharNextExA(CodePage: Word; lpCurrentChar: IntPtr; dwFlags: DWORD): IntPtr;
function CharNextEx(CodePage: Word; lpCurrentChar: IntPtr; dwFlags: DWORD): IntPtr;
function CharPrevEx(CodePage: Word; lpStart, lpCurrentChar: IntPtr; dwFlags: DWORD): IntPtr;
function CharPrevExA(CodePage: Word; lpStart, lpCurrentChar: IntPtr; dwFlags: DWORD): IntPtr;

{ Compatibility defines for character translation routines }

function AnsiToOem(lpszSrc: string; lpszDst: StringBuilder): BOOL;
function OemToAnsi(lpszSrc: string; lpszDst: StringBuilder): BOOL;
function AnsiToOemBuff(lpszSrc: string; lpszDst: StringBuilder; cchDstLength: DWORD): BOOL;
function OemToAnsiBuff(lpszSrc: string; lpszDst: StringBuilder; cchDstLength: DWORD): BOOL;
function AnsiUpper(lpsz: IntPtr): IntPtr;
function AnsiUpperBuff(lpsz: StringBuilder; cchLength: DWORD): DWORD;
function AnsiLower(lpsz: IntPtr): IntPtr;
function AnsiLowerBuff(lpsz: StringBuilder; cchLength: DWORD): DWORD;
function AnsiNext(lpsz: IntPtr): IntPtr;
function AnsiPrev(lpszStart: IntPtr; lpszCurrent: IntPtr): IntPtr;


{ Language dependent Routines }

function IsCharAlpha(ch: Char): BOOL;
function IsCharAlphaA(ch: AnsiChar): BOOL;
function IsCharAlphaW(ch: WideChar): BOOL;
function IsCharAlphaNumeric(ch: Char): BOOL;
function IsCharAlphaNumericA(ch: AnsiChar): BOOL;
function IsCharAlphaNumericW(ch: WideChar): BOOL;
function IsCharUpper(ch: Char): BOOL;
function IsCharUpperA(ch: AnsiChar): BOOL;
function IsCharUpperW(ch: WideChar): BOOL;
function IsCharLower(ch: Char): BOOL;
function IsCharLowerA(ch: AnsiChar): BOOL;
function IsCharLowerW(ch: WideChar): BOOL;

function SetFocus(hWnd: HWND): HWND;
function GetActiveWindow: HWND;
function GetFocus: HWND;
function GetKBCodePage: UINT;
function GetKeyState(nVirtKey: Integer): SHORT;
function GetAsyncKeyState(vKey: Integer): SHORT;

function GetKeyboardState([out] KeyState: TKeyboardState): BOOL;
function SetKeyboardState([in] KeyState: TKeyboardState): BOOL;
function GetKeyNameText(lParam: Longint; lpString: StringBuilder; nSize: Integer): Integer;
function GetKeyNameTextA(lParam: Longint; lpString: StringBuilder; nSize: Integer): Integer;
function GetKeyNameTextW(lParam: Longint; lpString: StringBuilder; nSize: Integer): Integer;
function GetKeyboardType(nTypeFlag: Integer): Integer;
function ToAscii(uVirtKey, uScanCode: UINT; [in] KeyState: TKeyboardState;
  lpChar: StringBuilder; uFlags: UINT): Integer;
function ToAsciiEx(uVirtKey: UINT; uScanCode: UINT; [in] KeyState: TKeyboardState;
  lpChar: StringBuilder; uFlags: UINT; dwhkl: HKL): Integer;
function ToUnicode(wVirtKey, wScanCode: UINT; [in] KeyState: TKeyboardState;
  pwszBuff: StringBuilder; cchBuff: Integer; wFlags: UINT): Integer;
function OemKeyScan(wOemChar: Word): DWORD;

function VkKeyScan(ch: Char): SHORT;
function VkKeyScanA(ch: AnsiChar): SHORT;
function VkKeyScanW(ch: WideChar): SHORT;
function VkKeyScanEx(ch: Char; dwhkl: HKL): SHORT;
function VkKeyScanExA(ch: AnsiChar; dwhkl: HKL): SHORT;
function VkKeyScanExW(ch: WideChar; dwhkl: HKL): SHORT;

const
  KEYEVENTF_EXTENDEDKEY = 1;
  KEYEVENTF_KEYUP = 2;

procedure keybd_event(bVk: Byte; bScan: Byte; dwFlags, dwExtraInfo: DWORD);

const
  MOUSEEVENTF_MOVE            = $0001; { mouse move }
  MOUSEEVENTF_LEFTDOWN        = $0002; { left button down }
  MOUSEEVENTF_LEFTUP          = $0004; { left button up }
  MOUSEEVENTF_RIGHTDOWN       = $0008; { right button down }
  MOUSEEVENTF_RIGHTUP         = $0010; { right button up }
  MOUSEEVENTF_MIDDLEDOWN      = $0020; { middle button down }
  MOUSEEVENTF_MIDDLEUP        = $0040; { middle button up }
  MOUSEEVENTF_WHEEL           = $0800; { wheel button rolled }
  MOUSEEVENTF_ABSOLUTE        = $8000; { absolute move }

procedure mouse_event(dwFlags, dx, dy, dwData, dwExtraInfo: DWORD);

type
  tagMOUSEINPUT = packed record
    dx: Longint;
    dy: Longint;
    mouseData: DWORD;
    dwFlags: DWORD;
    time: DWORD;
    dwExtraInfo: DWORD;
  end;
  TMouseInput = tagMOUSEINPUT;

  tagKEYBDINPUT = packed record
    wVk: WORD;
    wScan: WORD;
    dwFlags: DWORD;
    time: DWORD;
    dwExtraInfo: DWORD;
  end;
  TKeybdInput = tagKEYBDINPUT;

  tagHARDWAREINPUT = packed record
    uMsg: DWORD;
    wParamL: WORD;
    wParamH: WORD;
  end;
  THardwareInput = tagHARDWAREINPUT;

const
  INPUT_MOUSE = 0;
  INPUT_KEYBOARD = 1;
  INPUT_HARDWARE = 2;

type
  tagINPUT = packed record
    Itype: DWORD;
    case Integer of
      0: (mi: TMouseInput);
      1: (ki: TKeybdInput);
      2: (hi: THardwareInput);
  end;
  TInput = tagINPUT;

function SendInput(cInputs: UINT; const pInputs: TInput; cbSize: Integer): UINT;

type
  tagLASTINPUTINFO = packed record
    cbSize: UINT;
    dwTime: DWORD;
  end;
  TLastInputInfo = tagLASTINPUTINFO;

function GetLastInputInfo(out plii: TLastInputInfo): BOOL;

function MapVirtualKey(uCode, uMapType: UINT): UINT;
function MapVirtualKeyA(uCode, uMapType: UINT): UINT;
function MapVirtualKeyW(uCode, uMapType: UINT): UINT;
function MapVirtualKeyEx(uCode, uMapType: UINT; dwhkl: HKL): UINT;
function MapVirtualKeyExA(uCode, uMapType: UINT; dwhkl: HKL): UINT;
function MapVirtualKeyExW(uCode, uMapType: UINT; dwhkl: HKL): UINT;
function GetInputState: BOOL;
function GetQueueStatus(flags: UINT): DWORD;
function GetCapture: HWND;
function SetCapture(hWnd: HWND): HWND;
function ReleaseCapture: BOOL;
function MsgWaitForMultipleObjects(nCount: DWORD; [in] pHandles: array of THandle;
  fWaitAll: BOOL; dwMilliseconds, dwWakeMask: DWORD): DWORD;
function MsgWaitForMultipleObjectsEx(nCount: DWORD; [in] pHandles: array of THandle;
  dwMilliseconds, dwWakeMask, dwFlags: DWORD): DWORD;

const
  MWMO_WAITALL = $0001;
  MWMO_ALERTABLE = $0002;

  { Queue status flags for GetQueueStatus() and MsgWaitForMultipleObjects() }
  QS_KEY                  = $0001;
  QS_MOUSEMOVE            = $0002;
  QS_MOUSEBUTTON          = $0004;
  QS_POSTMESSAGE          = $0008;
  QS_TIMER                = $0010;
  QS_PAINT                = $0020;
  QS_SENDMESSAGE          = $0040;
  QS_HOTKEY               = $0080;
  QS_ALLPOSTMESSAGE       = $0100;

  QS_MOUSE = (QS_MOUSEMOVE or QS_MOUSEBUTTON);
  QS_INPUT = (QS_MOUSE or QS_KEY);
  QS_ALLEVENTS = (QS_INPUT or QS_POSTMESSAGE or QS_TIMER or QS_PAINT
    or QS_HOTKEY);
  QS_ALLINPUT = (QS_INPUT or QS_POSTMESSAGE or QS_TIMER or QS_PAINT
    or QS_HOTKEY or QS_SENDMESSAGE);


{ Windows Functions }

function SetTimer(hWnd: HWND; nIDEvent, uElapse: UINT;
  lpTimerFunc: TFNTimerProc): UINT;
function KillTimer(hWnd: HWND; uIDEvent: UINT): BOOL;
function IsWindowUnicode(hWnd: HWND): BOOL;
function EnableWindow(hWnd: HWND; bEnable: BOOL): BOOL;
function IsWindowEnabled(hWnd: HWND): BOOL;
function LoadAccelerators(hInstance: HINST; lpTableName: string): HACCEL;
function LoadAcceleratorsA(hInstance: HINST; lpTableName: string): HACCEL;
function LoadAcceleratorsW(hInstance: HINST; lpTableName: string): HACCEL;
function CreateAcceleratorTable([in] Accel: array of TACCEL; Count: Integer): HACCEL;
function CreateAcceleratorTableA([in] Accel: array of TACCEL; Count: Integer): HACCEL;
function CreateAcceleratorTableW([in] Accel: array of TACCEL; Count: Integer): HACCEL;
function CopyAcceleratorTable(hAccelSrc: HACCEL; [out] lpAccelDst: array of TACCEL;
  cAccelEntries: Integer): Integer;
function CopyAcceleratorTableA(hAccelSrc: HACCEL; [out] lpAccelDst: array of TACCEL;
  cAccelEntries: Integer): Integer;
function CopyAcceleratorTableW(hAccelSrc: HACCEL; [out] lpAccelDst: array of TACCEL;
  cAccelEntries: Integer): Integer;
function TranslateAccelerator(hWnd: HWND; hAccTable: HACCEL; const lpMsg: TMsg): Integer;
function TranslateAcceleratorA(hWnd: HWND; hAccTable: HACCEL; const lpMsg: TMsg): Integer;
function TranslateAcceleratorW(hWnd: HWND; hAccTable: HACCEL; const lpMsg: TMsg): Integer;
function DestroyAcceleratorTable(hAccel: HACCEL): BOOL;

const
  { GetSystemMetrics() codes }
  SM_CXSCREEN = 0;
  SM_CYSCREEN = 1;
  SM_CXVSCROLL = 2;
  SM_CYHSCROLL = 3;
  SM_CYCAPTION = 4;
  SM_CXBORDER = 5;
  SM_CYBORDER = 6;
  SM_CXDLGFRAME = 7;
  SM_CYDLGFRAME = 8;
  SM_CYVTHUMB = 9;
  SM_CXHTHUMB = 10;
  SM_CXICON = 11;
  SM_CYICON = 12;
  SM_CXCURSOR = 13;
  SM_CYCURSOR = 14;
  SM_CYMENU = 15;
  SM_CXFULLSCREEN = $10;
  SM_CYFULLSCREEN = 17;
  SM_CYKANJIWINDOW = 18;
  SM_MOUSEPRESENT = 19;
  SM_CYVSCROLL = 20;
  SM_CXHSCROLL = 21;
  SM_DEBUG = 22;
  SM_SWAPBUTTON = 23;
  SM_RESERVED1 = 24;
  SM_RESERVED2 = 25;
  SM_RESERVED3 = 26;
  SM_RESERVED4 = 27;
  SM_CXMIN = 28;
  SM_CYMIN = 29;
  SM_CXSIZE = 30;
  SM_CYSIZE = 31;
  SM_CXFRAME = $20;
  SM_CYFRAME = 33;
  SM_CXMINTRACK = 34;
  SM_CYMINTRACK = 35;
  SM_CXDOUBLECLK = 36;
  SM_CYDOUBLECLK = 37;
  SM_CXICONSPACING = 38;
  SM_CYICONSPACING = 39;
  SM_MENUDROPALIGNMENT = 40;
  SM_PENWINDOWS = 41;
  SM_DBCSENABLED = 42;
  SM_CMOUSEBUTTONS = 43;

  SM_CXFIXEDFRAME = SM_CXDLGFRAME; { win40 name change }
  SM_CYFIXEDFRAME = SM_CYDLGFRAME; { win40 name change }
  SM_CXSIZEFRAME = SM_CXFRAME;     { win40 name change }
  SM_CYSIZEFRAME = SM_CYFRAME;     { win40 name change }

  SM_SECURE = 44;
  SM_CXEDGE = 45;
  SM_CYEDGE = 46;
  SM_CXMINSPACING = 47;
  SM_CYMINSPACING = 48;
  SM_CXSMICON = 49;
  SM_CYSMICON = 50;
  SM_CYSMCAPTION = 51;
  SM_CXSMSIZE = 52;
  SM_CYSMSIZE = 53;
  SM_CXMENUSIZE = 54;
  SM_CYMENUSIZE = 55;
  SM_ARRANGE = 56;
  SM_CXMINIMIZED = 57;
  SM_CYMINIMIZED = 58;
  SM_CXMAXTRACK = 59;
  SM_CYMAXTRACK = 60;
  SM_CXMAXIMIZED = 61;
  SM_CYMAXIMIZED = 62;
  SM_NETWORK = 63;
  SM_CLEANBOOT = 67;
  SM_CXDRAG = 68;
  SM_CYDRAG = 69;
  SM_SHOWSOUNDS = 70;
  SM_CXMENUCHECK = 71;     { Use instead of GetMenuCheckMarkDimensions()! }
  SM_CYMENUCHECK = 72;
  SM_SLOWMACHINE = 73;
  SM_MIDEASTENABLED = 74;
  SM_MOUSEWHEELPRESENT = 75;
  SM_CMETRICS = 76;
  SM_XVIRTUALSCREEN = 76;
  SM_YVIRTUALSCREEN = 77;
  SM_CXVIRTUALSCREEN = 78;
  SM_CYVIRTUALSCREEN = 79;
  SM_CMONITORS = 80;
  SM_SAMEDISPLAYFORMAT = 81;
  SM_IMMENABLED = 82;
  SM_CXFOCUSBORDER = 83;
  SM_CYFOCUSBORDER = 84;

function GetSystemMetrics(nIndex: Integer): Integer;
function LoadMenu(hInstance: HINST; lpMenuName: string): HMENU;
function LoadMenuA(hInstance: HINST; lpMenuName: string): HMENU;
function LoadMenuW(hInstance: HINST; lpMenuName: string): HMENU;
function LoadMenuIndirect(lpMenuTemplate: IntPtr): HMENU;
function LoadMenuIndirectA(lpMenuTemplate: IntPtr): HMENU;
function LoadMenuIndirectW(lpMenuTemplate: IntPtr): HMENU;
function GetMenu(hWnd: HWND): HMENU;
function SetMenu(hWnd: HWND; hMenu: HMENU): BOOL;
function ChangeMenu(hMenu: HMENU; cmd: UINT; lpszNewItem: string;
  cmdInsert: UINT; flags: UINT): BOOL;
function ChangeMenuA(hMenu: HMENU; cmd: UINT; lpszNewItem: string;
  cmdInsert: UINT; flags: UINT): BOOL;
function ChangeMenuW(hMenu: HMENU; cmd: UINT; lpszNewItem: string;
  cmdInsert: UINT; flags: UINT): BOOL;
function HiliteMenuItem(hWnd: HWND; hMenu: HMENU; uIDHiliteItem: UINT;
  uHilite: UINT): BOOL;
function GetMenuString(hMenu: HMENU; uIDItem: UINT; lpString: StringBuilder;
  nMaxCount: Integer; uFlag: UINT): Integer;
function GetMenuStringA(hMenu: HMENU; uIDItem: UINT; lpString: StringBuilder;
  nMaxCount: Integer; uFlag: UINT): Integer;
function GetMenuStringW(hMenu: HMENU; uIDItem: UINT; lpString: StringBuilder;
  nMaxCount: Integer; uFlag: UINT): Integer;
function GetMenuState(hMenu: HMENU; uId, uFlags: UINT): UINT;
function DrawMenuBar(hWnd: HWND): BOOL;
function GetSystemMenu(hWnd: HWND; bRevert: BOOL): HMENU;
function CreateMenu: HMENU;
function CreatePopupMenu: HMENU;
function DestroyMenu(hMenu: HMENU): BOOL;
function CheckMenuItem(hMenu: HMENU; uIDCheckItem, uCheck: UINT): DWORD;
function EnableMenuItem(hMenu: HMENU; uIDEnableItem, uEnable: UINT): BOOL;
function GetSubMenu(hMenu: HMENU; nPos: Integer): HMENU;
function GetMenuItemID(hMenu: HMENU; nPos: Integer): UINT;
function GetMenuItemCount(hMenu: HMENU): Integer;
function InsertMenu(hMenu: HMENU; uPosition, uFlags, uIDNewItem: UINT;
  lpNewItem: string): BOOL;
function InsertMenuA(hMenu: HMENU; uPosition, uFlags, uIDNewItem: UINT;
  lpNewItem: string): BOOL;
function InsertMenuW(hMenu: HMENU; uPosition, uFlags, uIDNewItem: UINT;
  lpNewItem: string): BOOL;
function AppendMenu(hMenu: HMENU; uFlags, uIDNewItem: UINT;
  lpNewItem: string): BOOL;
function AppendMenuA(hMenu: HMENU; uFlags, uIDNewItem: UINT;
  lpNewItem: string): BOOL;
function AppendMenuW(hMenu: HMENU; uFlags, uIDNewItem: UINT;
  lpNewItem: string): BOOL;
function ModifyMenu(hMnu: HMENU; uPosition, uFlags, uIDNewItem: UINT;
  lpNewItem: string): BOOL;
function ModifyMenuA(hMnu: HMENU; uPosition, uFlags, uIDNewItem: UINT;
  lpNewItem: string): BOOL;
function ModifyMenuW(hMnu: HMENU; uPosition, uFlags, uIDNewItem: UINT;
  lpNewItem: string): BOOL;
function RemoveMenu(hMenu: HMENU; uPosition, uFlags: UINT): BOOL;
function DeleteMenu(hMenu: HMENU; uPosition, uFlags: UINT): BOOL;
function SetMenuItemBitmaps(hMenu: HMENU; uPosition, uFlags: UINT;
  hBitmapUnchecked: HBITMAP; hBitmapChecked: HBITMAP): BOOL;
function GetMenuCheckMarkDimensions: Longint;
function TrackPopupMenu(hMenu: HMENU; uFlags: UINT; x, y, nReserved: Integer;
  hWnd: HWND; prcRect: IntPtr): BOOL;


const
  { return codes for WM_MENUCHAR }
  MNC_IGNORE = 0;
  MNC_CLOSE = 1;
  MNC_EXECUTE = 2;
  MNC_SELECT = 3;

type
  tagTPMPARAMS = packed record
    cbSize: UINT;     { Size of structure }
    rcExclude: TRect; { Screen coordinates of rectangle to exclude when positioning }
  end;
  TTPMParams = tagTPMPARAMS;
  TPMPARAMS = tagTPMPARAMS;

function TrackPopupMenuEx(hMenu: HMENU; Flags: UINT; x, y: Integer;
  Wnd: HWND; const TPMParams: TTPMParams): BOOL; overload;
function TrackPopupMenuEx(hMenu: HMENU; Flags: UINT; x, y: Integer;
  Wnd: HWND; TPMParams: IntPtr): BOOL; overload;

const
  MNS_NOCHECK = $80000000;
  MNS_MODELESS = $40000000;
  MNS_DRAGDROP = $20000000;
  MNS_AUTODISMISS = $10000000;
  MNS_NOTIFYBYPOS = $8000000;
  MNS_CHECKORBMP = $4000000;

  MIM_MAXHEIGHT = 1;
  MIM_BACKGROUND = 2;
  MIM_HELPID = 4;
  MIM_MENUDATA = 8;
  MIM_STYLE = $10;
  MIM_APPLYTOSUBMENUS = $80000000;

type
  tagMENUINFO = packed record
    cbSize: DWORD;
    fMask: DWORD;
    dwStyle: DWORD;
    cyMax: UINT;
    hbrBack: HBRUSH;
    dwContextHelpID: DWORD;
    dwMenuData: DWORD;
  end;
  TMenuInfo = tagMENUINFO;

function GetMenuInfo(hMenu: HMENU; out lpmi: TMenuInfo): BOOL;
function SetMenuInfo(hMenu: HMENU; const lpcmi: TMenuInfo): BOOL;
function EndMenu: BOOL;

const
  { WM_MENUDRAG return values }
  MND_CONTINUE = 0;
  MND_ENDMENU = 1;

type
  tagMENUGETOBJECTINFO = packed record
    dwFlags: DWORD;
    uPos: UINT;
    hmenu: HMENU;
    riid: IntPtr;  { Pointer }
    pvObj: IntPtr; { Pointer }
  end;
  TMenuGetObjectInfo = tagMENUGETOBJECTINFO;


const
  { MENUGETOBJECTINFO dwFlags values }
  MNGOF_GAP = 3;

  { MENUGETOBJECT returns values }
  MNGO_NOINTERFACE = 0;
  MNGO_NOERROR = 1;

  MIIM_STATE = 1;
  MIIM_ID = 2;
  MIIM_SUBMENU = 4;
  MIIM_CHECKMARKS = 8;
  MIIM_TYPE = $10;
  MIIM_DATA = $20;
  MIIM_STRING = $40;
  MIIM_BITMAP = $80;
  MIIM_FTYPE = $100;

  HBMMENU_CALLBACK = -1;
  HBMMENU_SYSTEM = 1;
  HBMMENU_MBAR_RESTORE = 2;
  HBMMENU_MBAR_MINIMIZE = 3;
  HBMMENU_MBAR_CLOSE = 5;
  HBMMENU_MBAR_CLOSE_D = 6;
  HBMMENU_MBAR_MINIMIZE_D = 7;
  HBMMENU_POPUP_CLOSE = 8;
  HBMMENU_POPUP_RESTORE = 9;
  HBMMENU_POPUP_MAXIMIZE = 10;
  HBMMENU_POPUP_MINIMIZE = 11;


type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMENUITEMINFO = packed record
    cbSize: UINT;
    fMask: UINT;
    fType: UINT;             { used if MIIM_TYPE}
    fState: UINT;            { used if MIIM_STATE}
    wID: UINT;               { used if MIIM_ID}
    hSubMenu: HMENU;         { used if MIIM_SUBMENU}
    hbmpChecked: HBITMAP;    { used if MIIM_CHECKMARKS}
    hbmpUnchecked: HBITMAP;  { used if MIIM_CHECKMARKS}
    dwItemData: DWORD;       { used if MIIM_DATA}
    dwTypeData: IntPtr;      { used if MIIM_TYPE}
    cch: UINT;               { used if MIIM_TYPE}
    hbmpItem: HBITMAP;       { used if MIIM_BITMAP}
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMENUITEMINFOA = packed record
    cbSize: UINT;
    fMask: UINT;
    fType: UINT;             { used if MIIM_TYPE}
    fState: UINT;            { used if MIIM_STATE}
    wID: UINT;               { used if MIIM_ID}
    hSubMenu: HMENU;         { used if MIIM_SUBMENU}
    hbmpChecked: HBITMAP;    { used if MIIM_CHECKMARKS}
    hbmpUnchecked: HBITMAP;  { used if MIIM_CHECKMARKS}
    dwItemData: DWORD;       { used if MIIM_DATA}
    dwTypeData: IntPtr;      { used if MIIM_TYPE}
    cch: UINT;               { used if MIIM_TYPE}
    hbmpItem: HBITMAP;       { used if MIIM_BITMAP}
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMENUITEMINFOW = packed record
    cbSize: UINT;
    fMask: UINT;
    fType: UINT;             { used if MIIM_TYPE}
    fState: UINT;            { used if MIIM_STATE}
    wID: UINT;               { used if MIIM_ID}
    hSubMenu: HMENU;         { used if MIIM_SUBMENU}
    hbmpChecked: HBITMAP;    { used if MIIM_CHECKMARKS}
    hbmpUnchecked: HBITMAP;  { used if MIIM_CHECKMARKS}
    dwItemData: DWORD;       { used if MIIM_DATA}
    dwTypeData: IntPtr;      { used if MIIM_TYPE}
    cch: UINT;               { used if MIIM_TYPE}
    hbmpItem: HBITMAP;       { used if MIIM_BITMAP}
  end;
  TMenuItemInfo = tagMENUITEMINFO;
  TMenuItemInfoA = tagMENUITEMINFOA;
  TMenuItemInfoW = tagMENUITEMINFOW;
  MENUITEMINFO = tagMENUITEMINFO;
  MENUITEMINFOA = tagMENUITEMINFOA;
  MENUITEMINFOW = tagMENUITEMINFOW;

function InsertMenuItem(p1: HMENU; p2: UINT; p3: BOOL; const p4: TMenuItemInfo): BOOL;
function InsertMenuItemA(p1: HMENU; p2: UINT; p3: BOOL; const p4: TMenuItemInfoA): BOOL;
function InsertMenuItemW(p1: HMENU; p2: UINT; p3: BOOL; const p4: TMenuItemInfoW): BOOL;
function GetMenuItemInfo(p1: HMENU; p2: UINT; p3: BOOL; var p4: TMenuItemInfo): BOOL;
function GetMenuItemInfoA(p1: HMENU; p2: UINT; p3: BOOL; var p4: TMenuItemInfoA): BOOL;
function GetMenuItemInfoW(p1: HMENU; p2: UINT; p3: BOOL; var p4: TMenuItemInfoW): BOOL;
function SetMenuItemInfo(p1: HMENU; p2: UINT; p3: BOOL; const p4: TMenuItemInfo): BOOL;
function SetMenuItemInfoA(p1: HMENU; p2: UINT; p3: BOOL; const p4: TMenuItemInfoA): BOOL;
function SetMenuItemInfoW(p1: HMENU; p2: UINT; p3: BOOL; const p4: TMenuItemInfoW): BOOL;

const
  GMDI_USEDISABLED = 1;
  GMDI_GOINTOPOPUPS = 2;

function GetMenuDefaultItem(hMenu: HMENU; fByPos, gmdiFlags: UINT): UINT;
function SetMenuDefaultItem(hMenu: HMENU; uItem, fByPos: UINT): BOOL;
function GetMenuItemRect(hWnd: HWND; hMenu: HMENU; uItem: UINT;
  out lprcItem: TRect): BOOL;
function MenuItemFromPoint(hWnd: HWND; hMenu: HMENU; ptScreen: TPoint): BOOL;

const
  { Flags for TrackPopupMenu }
  TPM_LEFTBUTTON = 0;
  TPM_RIGHTBUTTON = 2;
  TPM_LEFTALIGN = 0;
  TPM_CENTERALIGN = 4;
  TPM_RIGHTALIGN = 8;
  TPM_TOPALIGN = 0;
  TPM_VCENTERALIGN = $10;
  TPM_BOTTOMALIGN = $20;

  TPM_HORIZONTAL = 0;   { Horz alignment matters more }
  TPM_VERTICAL = $40;   { Vert alignment matters more }
  TPM_NONOTIFY = $80;   { Don't send any notification msgs }
  TPM_RETURNCMD = $100;
  TPM_RECURSE = $1;
  TPM_HORPOSANIMATION = $0400;
  TPM_HORNEGANIMATION = $0800;
  TPM_VERPOSANIMATION = $1000;
  TPM_VERNEGANIMATION = $2000;
  TPM_NOANIMATION     = $4000;


{ Drag-and-drop support }

type
  tagDROPSTRUCT = packed record
    hwndSource: HWND;
    hwndSink: HWND;
    wFmt: DWORD;
    dwData: DWORD;
    ptDrop: TPoint;
    dwControlData: DWORD;
  end;
  TDropStruct = tagDROPSTRUCT;
  DROPSTRUCT = tagDROPSTRUCT;

const
  DOF_EXECUTABLE = 32769;
  DOF_DOCUMENT = 32770;
  DOF_DIRECTORY = 32771;
  DOF_MULTIPLE = 32772;
  DOF_PROGMAN = 1;
  DOF_SHELLDATA = 2;

  DO_DROPFILE = $454C4946;
  DO_PRINTFILE = $544E5250;

function DragObject(p1, p2: HWND; p3: UINT; p4: DWORD;
  p5: HICON): DWORD;
function DragDetect(p1: HWND; p2: TPoint): BOOL;
function DrawIcon(hDC: HDC; X, Y: Integer; hIcon: HICON): BOOL;

const
  { DrawText() Format Flags }
  DT_TOP = 0;
  DT_LEFT = 0;
  DT_CENTER = 1;
  DT_RIGHT = 2;
  DT_VCENTER = 4;
  DT_BOTTOM = 8;
  DT_WORDBREAK = $10;
  DT_SINGLELINE = $20;
  DT_EXPANDTABS = $40;
  DT_TABSTOP = $80;
  DT_NOCLIP = $100;
  DT_EXTERNALLEADING = $200;
  DT_CALCRECT = $400;
  DT_NOPREFIX = $800;
  DT_INTERNAL = $1000;
  DT_HIDEPREFIX = $00100000;
  DT_PREFIXONLY = $00200000;

  DT_EDITCONTROL = $2000;
  DT_PATH_ELLIPSIS = $4000;
  DT_END_ELLIPSIS = $8000;
  DT_MODIFYSTRING = $10000;
  DT_RTLREADING = $20000;
  DT_WORD_ELLIPSIS = $40000;

type
  tagDRAWTEXTPARAMS = packed record
    cbSize: UINT;
    iTabLength: Integer;
    iLeftMargin: Integer;
    iRightMargin: Integer;
    uiLengthDrawn: UINT;
  end;
  TDrawTextParams = tagDRAWTEXTPARAMS;
  DRAWTEXTPARAMS = tagDRAWTEXTPARAMS;

function DrawText(hDC: HDC; lpString: string; nCount: Integer;
  var lpRect: TRect; uFormat: UINT): Integer;
function DrawTextA(hDC: HDC; lpString: string; nCount: Integer;
  var lpRect: TRect; uFormat: UINT): Integer;
function DrawTextW(hDC: HDC; lpString: string; nCount: Integer;
  var lpRect: TRect; uFormat: UINT): Integer;

function DrawTextEx(DC: HDC; lpchText: string; cchText: Integer; var p4: TRect;
  dwDTFormat: UINT; const DTParams: TDrawTextParams): Integer; overload;
function DrawTextEx(DC: HDC; lpchText: string; cchText: Integer; var p4: TRect;
  dwDTFormat: UINT; DTParams: IntPtr): Integer; overload;
function DrawTextEx(DC: HDC; lpchText: StringBuilder; cchText: Integer; var p4: TRect;
  dwDTFormat: UINT; const DTParams: IntPtr): Integer; overload;
function DrawTextExA(DC: HDC; lpchText: string; cchText: Integer; var p4: TRect;
  dwDTFormat: UINT; const DTParams: TDrawTextParams): Integer;
function DrawTextExW(DC: HDC; lpchText: string; cchText: Integer; var p4: TRect;
  dwDTFormat: UINT; const DTParams: TDrawTextParams): Integer;

function GrayString(hDC: HDC; hBrush: HBRUSH; lpOutputFunc: TFNGrayStringProc;
  lpData: LPARAM; nCount, X, Y, nWidth, nHeight: Integer): BOOL;
function GrayStringA(hDC: HDC; hBrush: HBRUSH; lpOutputFunc: TFNGrayStringProc;
  lpData: LPARAM; nCount, X, Y, nWidth, nHeight: Integer): BOOL;
function GrayStringW(hDC: HDC; hBrush: HBRUSH; lpOutputFunc: TFNGrayStringProc;
  lpData: LPARAM; nCount, X, Y, nWidth, nHeight: Integer): BOOL;


{ Monolithic state-drawing routine }

const
  { Image type }
  DST_COMPLEX = 0;
  DST_TEXT = 1;
  DST_PREFIXTEXT = 2;
  DST_ICON = 3;
  DST_BITMAP = 4;

  { State type }
  DSS_NORMAL = 0;
  DSS_UNION = $10;     { Gray string appearance }
  DSS_DISABLED = $20;
  DSS_MONO = $80;
  DSS_RIGHT = $8000;

function DrawState(DC: HDC; Brush: HBRUSH; CBFunc: TFNDrawStateProc;
  lData: LPARAM; wData: WPARAM; x, y, cx, cy: Integer; Flags: UINT): BOOL;
function DrawStateA(DC: HDC; Brush: HBRUSH; CBFunc: TFNDrawStateProc;
  lData: LPARAM; wData: WPARAM; x, y, cx, cy: Integer; Flags: UINT): BOOL;
function DrawStateW(DC: HDC; Brush: HBRUSH; CBFunc: TFNDrawStateProc;
  lData: LPARAM; wData: WPARAM; x, y, cx, cy: Integer; Flags: UINT): BOOL;
function TabbedTextOut(hDC: HDC; X, Y: Integer; lpString: string; nCount, nTabPositions: Integer;
  [in] lpnTabStopPositions: TIntegerDynArray; nTabOrigin: Integer): Longint;
function TabbedTextOutA(hDC: HDC; X, Y: Integer; lpString: string; nCount, nTabPositions: Integer;
  [in] lpnTabStopPositions: TIntegerDynArray; nTabOrigin: Integer): Longint;
function TabbedTextOutW(hDC: HDC; X, Y: Integer; lpString: string; nCount, nTabPositions: Integer;
  [in] lpnTabStopPositions: TIntegerDynArray; nTabOrigin: Integer): Longint;
function GetTabbedTextExtent(hDC: HDC; lpString: string;
  nCount, nTabPositions: Integer; [in] lpnTabStopPositions: TIntegerDynArray): DWORD;
function GetTabbedTextExtentA(hDC: HDC; lpString: string;
  nCount, nTabPositions: Integer; [in] lpnTabStopPositions: TIntegerDynArray): DWORD;
function GetTabbedTextExtentW(hDC: HDC; lpString: string;
  nCount, nTabPositions: Integer; [in] lpnTabStopPositions: TIntegerDynArray): DWORD;
function UpdateWindow(hWnd: HWND): BOOL;
function SetActiveWindow(hWnd: HWND): HWND;
function GetForegroundWindow: HWND;
function PaintDesktop(hdc: HDC): BOOL;
function SetForegroundWindow(hWnd: HWND): BOOL;
function WindowFromDC(hDC: HDC): HWND;
function GetDC(hWnd: HWND): HDC;
function GetDCEx(hWnd: HWND; hrgnClip: HRGN; flags: DWORD): HDC;

const
  { GetDCEx() flags }
  DCX_WINDOW = 1;
  DCX_CACHE = 2;
  DCX_NORESETATTRS = 4;
  DCX_CLIPCHILDREN = 8;
  DCX_CLIPSIBLINGS = $10;
  DCX_PARENTCLIP = $20;
  DCX_EXCLUDERGN = $40;
  DCX_INTERSECTRGN = $80;
  DCX_EXCLUDEUPDATE = $100;
  DCX_INTERSECTUPDATE = $200;
  DCX_LOCKWINDOWUPDATE = $400;
  DCX_VALIDATE = $200000;

function GetWindowDC(hWnd: HWND): HDC;
function ReleaseDC(hWnd: HWND; hDC: HDC): Integer;
function BeginPaint(hWnd: HWND; out lpPaint: TPaintStruct): HDC;
function EndPaint(hWnd: HWND; const lpPaint: TPaintStruct): BOOL;
function GetUpdateRect(hWnd: HWND; out lpRect: TRect; bErase: BOOL): BOOL;
function GetUpdateRgn(hWnd: HWND; hRgn: HRGN; bErase: BOOL): Integer;
function SetWindowRgn(hWnd: HWND; hRgn: HRGN; bRedraw: BOOL): Integer;
function GetWindowRgn(hWnd: HWND; hRgn: HRGN): Integer;
function ExcludeUpdateRgn(hDC: HDC; hWnd: HWND): Integer;
function InvalidateRect(hWnd: HWND; const lpRect: TRect; bErase: BOOL): BOOL; overload;
function InvalidateRect(hWnd: HWND; lpRect: IntPtr; bErase: BOOL): BOOL; overload;
function ValidateRect(hWnd: HWND; const lpRect: TRect): BOOL; overload;
function ValidateRect(hWnd: HWND; lpRect: IntPtr): BOOL; overload;
function InvalidateRgn(hWnd: HWND; hRgn: HRGN; bErase: BOOL): BOOL;
function ValidateRgn(hWnd: HWND; hRgn: HRGN): BOOL;
function RedrawWindow(hWnd: HWND; const lprcUpdate: TRect;
  hrgnUpdate: HRGN; flags: UINT): BOOL; overload;
function RedrawWindow(hWnd: HWND; lprcUpdate: IntPtr;
  hrgnUpdate: HRGN; flags: UINT): BOOL; overload;

const
  { RedrawWindow() flags }
  RDW_INVALIDATE = 1;
  RDW_INTERNALPAINT = 2;
  RDW_ERASE = 4;
  RDW_VALIDATE = 8;
  RDW_NOINTERNALPAINT = $10;
  RDW_NOERASE = $20;
  RDW_NOCHILDREN = $40;
  RDW_ALLCHILDREN = $80;
  RDW_UPDATENOW = $100;
  RDW_ERASENOW = $200;
  RDW_FRAME = $400;
  RDW_NOFRAME = $800;


{ LockWindowUpdate API }

function LockWindowUpdate(hWndLock: HWND): BOOL;
function ScrollWindow(hWnd: HWND; XAmount, YAmount: Integer; const Rect: TRect;
  const ClipRect: TRect): BOOL; overload;
function ScrollWindow(hWnd: HWND; XAmount, YAmount: Integer; Rect: IntPtr;
  const ClipRect: TRect): BOOL; overload;
function ScrollWindow(hWnd: HWND; XAmount, YAmount: Integer; Rect: IntPtr;
  ClipRect: IntPtr): BOOL; overload;

function ScrollDC(DC: HDC; DX, DY: Integer; const Scroll: TRect;
  const Clip: TRect; Rgn: HRGN; out Update: TRect): BOOL; overload;
function ScrollDC(DC: HDC; DX, DY: Integer; const Scroll: TRect;
  const Clip: TRect; Rgn: HRGN; Update: IntPtr): BOOL; overload;
function ScrollDC(DC: HDC; DX, DY: Integer; Scroll: IntPtr;
  Clip: IntPtr; Rgn: HRGN; out Update: TRect): BOOL; overload;
function ScrollDC(DC: HDC; DX, DY: Integer; Scroll: IntPtr;
  const Clip: TRect; Rgn: HRGN; out Update: TRect): BOOL; overload;
function ScrollDC(DC: HDC; DX, DY: Integer; const Scroll: TRect;
  Clip: IntPtr; Rgn: HRGN; out Update: TRect): BOOL; overload;

function ScrollWindowEx(hWnd: HWND; dx, dy: Integer; const prcScroll, prcClip: TRect;
  hrgnUpdate: HRGN; out prcUpdate: TRect; flags: UINT): BOOL; overload;
function ScrollWindowEx(hWnd: HWND; dx, dy: Integer; const prcScroll, prcClip: TRect;
  hrgnUpdate: HRGN; prcUpdate: IntPtr; flags: UINT): BOOL; overload;

const
  SW_SCROLLCHILDREN = 1;  { Scroll children within lprcScroll. }
  SW_INVALIDATE = 2;      { Invalidate after scrolling }
  SW_ERASE = 4;           { If SW_INVALIDATE, don't send WM_ERASEBACKGROUND }
  SW_SMOOTHSCROLL = $10;   { Use smooth scrolling }

function SetScrollPos(hWnd: HWND; nBar, nPos: Integer; bRedraw: BOOL): Integer;
function GetScrollPos(hWnd: HWND; nBar: Integer): Integer;
function SetScrollRange(hWnd: HWND; nBar, nMinPos, nMaxPos: Integer; bRedraw: BOOL): BOOL;
function GetScrollRange(hWnd: HWND; nBar: Integer; out lpMinPos, lpMaxPos: Integer): BOOL;
function ShowScrollBar(hWnd: HWND; wBar: Integer; bShow: BOOL): BOOL;
function EnableScrollBar(hWnd: HWND; wSBflags, wArrows: UINT): BOOL;


const
  { EnableScrollBar() flags }
  ESB_ENABLE_BOTH = 0;
  ESB_DISABLE_BOTH = 3;
  ESB_DISABLE_LEFT = 1;
  ESB_DISABLE_RIGHT = 2;
  ESB_DISABLE_UP = 1;
  ESB_DISABLE_DOWN = 2;
  ESB_DISABLE_LTUP = ESB_DISABLE_LEFT;
  ESB_DISABLE_RTDN = ESB_DISABLE_RIGHT;

function SetProp(hWnd: HWND; lpString: string; hData: THandle): BOOL; overload;
function SetPropA(hWnd: HWND; lpString: string; hData: THandle): BOOL; overload;
function SetPropW(hWnd: HWND; lpString: string; hData: THandle): BOOL; overload;
function GetProp(hWnd: HWND; lpString: string): THandle; overload;
function GetPropA(hWnd: HWND; lpString: string): THandle; overload;
function GetPropW(hWnd: HWND; lpString: string): THandle; overload;
function RemoveProp(hWnd: HWND; lpString: string): THandle; overload;
function RemovePropA(hWnd: HWND; lpString: string): THandle; overload;
function RemovePropW(hWnd: HWND; lpString: string): THandle; overload;
function SetProp(hWnd: HWND; aAtom: TAtom; hData: THandle): BOOL; overload;
function SetPropA(hWnd: HWND; aAtom: TAtom; hData: THandle): BOOL; overload;
function SetPropW(hWnd: HWND; aAtom: TAtom; hData: THandle): BOOL; overload;
function GetProp(hWnd: HWND; aAtom: TAtom): THandle; overload;
function GetPropA(hWnd: HWND; aAtom: TAtom): THandle; overload;
function GetPropW(hWnd: HWND; aAtom: TAtom): THandle; overload;
function RemoveProp(hWnd: HWND; aAtom: TAtom): THandle; overload;
function RemovePropA(hWnd: HWND; aAtom: TAtom): THandle; overload;
function RemovePropW(hWnd: HWND; aAtom: TAtom): THandle; overload;
function EnumPropsEx(hWnd: HWND; lpEnumFunc: TFNPropEnumProcEx; lParam: LPARAM): Integer;
function EnumPropsExA(hWnd: HWND; lpEnumFunc: TFNPropEnumProcEx; lParam: LPARAM): Integer;
function EnumPropsExW(hWnd: HWND; lpEnumFunc: TFNPropEnumProcEx; lParam: LPARAM): Integer;
function EnumProps(hWnd: HWND; lpEnumFunc: TFNPropEnumProc): Integer;
function EnumPropsA(hWnd: HWND; lpEnumFunc: TFNPropEnumProc): Integer;
function EnumPropsW(hWnd: HWND; lpEnumFunc: TFNPropEnumProc): Integer;
function SetWindowText(hWnd: HWND; lpString: string): BOOL;
function SetWindowTextA(hWnd: HWND; lpString: string): BOOL;
function SetWindowTextW(hWnd: HWND; lpString: string): BOOL;
function GetWindowText(hWnd: HWND; lpString: StringBuilder; nMaxCount: Integer): Integer;
function GetWindowTextA(hWnd: HWND; lpString: StringBuilder; nMaxCount: Integer): Integer;
function GetWindowTextW(hWnd: HWND; lpString: StringBuilder; nMaxCount: Integer): Integer;
function GetWindowTextLength(hWnd: HWND): Integer;
function GetWindowTextLengthA(hWnd: HWND): Integer;
function GetWindowTextLengthW(hWnd: HWND): Integer;

function GetClientRect(hWnd: HWND; out lpRect: TRect): BOOL;
function GetWindowRect(hWnd: HWND; out lpRect: TRect): BOOL;
function AdjustWindowRect(var lpRect: TRect; dwStyle: DWORD; bMenu: BOOL): BOOL;
function AdjustWindowRectEx(var lpRect: TRect; dwStyle: DWORD; bMenu: BOOL;
  dwExStyle: DWORD): BOOL;

const
  HELPINFO_WINDOW = 1;
  HELPINFO_MENUITEM = 2;
type
  tagHELPINFO = packed record       { Structure pointed to by lParam of WM_HELP }
    cbSize: UINT;          { Size in bytes of this struct  }
    iContextType: Integer; { Either HELPINFO_WINDOW or HELPINFO_MENUITEM }
    iCtrlId: Integer;      { Control Id or a Menu item Id. }
    hItemHandle: THandle;  { hWnd of control or hMenu.     }
    dwContextId: DWORD;    { Context Id associated with this item }
    MousePos: TPoint;      { Mouse Position in screen co-ordinates }
  end;
  THelpInfo = tagHELPINFO;
  HELPINFO = tagHELPINFO;

function SetWindowContextHelpId(hWnd: HWND; HelpID: DWORD): BOOL;
function GetWindowContextHelpId(hWnd: HWND): DWORD;
function SetMenuContextHelpId(hMenu: HMENU; HelpID: DWORD): BOOL;
function GetMenuContextHelpId(hMenu: HMENU): DWORD;

const
  { MessageBox() Flags }
  MB_OK = $00000000;
  MB_OKCANCEL = $00000001;
  MB_ABORTRETRYIGNORE = $00000002;
  MB_YESNOCANCEL = $00000003;
  MB_YESNO = $00000004;
  MB_RETRYCANCEL = $00000005;

  MB_ICONHAND = $00000010;
  MB_ICONQUESTION = $00000020;
  MB_ICONEXCLAMATION = $00000030;
  MB_ICONASTERISK = $00000040;
  MB_USERICON = $00000080;
  MB_ICONWARNING                 = MB_ICONEXCLAMATION;
  MB_ICONERROR                   = MB_ICONHAND;
  MB_ICONINFORMATION             = MB_ICONASTERISK;
  MB_ICONSTOP                    = MB_ICONHAND;

  MB_DEFBUTTON1 = $00000000;
  MB_DEFBUTTON2 = $00000100;
  MB_DEFBUTTON3 = $00000200;
  MB_DEFBUTTON4 = $00000300;

  MB_APPLMODAL = $00000000;
  MB_SYSTEMMODAL = $00001000;
  MB_TASKMODAL = $00002000;
  MB_HELP = $00004000;                          { Help Button }

  MB_NOFOCUS = $00008000;
  MB_SETFOREGROUND = $00010000;
  MB_DEFAULT_DESKTOP_ONLY = $00020000;

  MB_TOPMOST = $00040000;
  MB_RIGHT = $00080000;
  MB_RTLREADING = $00100000;

  MB_SERVICE_NOTIFICATION = $00200000;
  MB_SERVICE_NOTIFICATION_NT3X = $00040000;

  MB_TYPEMASK = $0000000F;
  MB_ICONMASK = $000000F0;
  MB_DEFMASK = $00000F00;
  MB_MODEMASK = $00003000;
  MB_MISCMASK = $0000C000;


function MessageBox(hWnd: HWND; lpText, lpCaption: string; uType: UINT): Integer;
function MessageBoxA(hWnd: HWND; lpText, lpCaption: string; uType: UINT): Integer;
function MessageBoxW(hWnd: HWND; lpText, lpCaption: string; uType: UINT): Integer;
function MessageBoxEx(hWnd: HWND; lpText, lpCaption: string;
  uType: UINT; wLanguageId: Word): Integer;
function MessageBoxExA(hWnd: HWND; lpText, lpCaption: string;
  uType: UINT; wLanguageId: Word): Integer;
function MessageBoxExW(hWnd: HWND; lpText, lpCaption: string;
  uType: UINT; wLanguageId: Word): Integer;

type
  TPRMsgBoxCallback = procedure(var lpHelpInfo: THelpInfo);

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMSGBOXPARAMS = packed record
    cbSize: UINT;
    hwndOwner: HWND;
    hInstance: HINST;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszText: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszCaption: string;
    dwStyle: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszIcon: string;
    dwContextHelpId: DWORD;
    [MarshalAs(UnmanagedType.FunctionPtr)]
    lpfnMsgBoxCallback: TPRMsgBoxCallback;
    dwLanguageId: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMSGBOXPARAMSA = packed record
    cbSize: UINT;
    hwndOwner: HWND;
    hInstance: HINST;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszText: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszCaption: string;
    dwStyle: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszIcon: string;
    dwContextHelpId: DWORD;
    [MarshalAs(UnmanagedType.FunctionPtr)]
    lpfnMsgBoxCallback: TPRMsgBoxCallback;
    dwLanguageId: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMSGBOXPARAMSW = packed record
    cbSize: UINT;
    hwndOwner: HWND;
    hInstance: HINST;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszText: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszCaption: string;
    dwStyle: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszIcon: string;
    dwContextHelpId: DWORD;
    [MarshalAs(UnmanagedType.FunctionPtr)]
    lpfnMsgBoxCallback: TPRMsgBoxCallback;
    dwLanguageId: DWORD;
  end;
  TMsgBoxParams = tagMSGBOXPARAMS;
  TMsgBoxParamsA = tagMSGBOXPARAMSA;
  TMsgBoxParamsW = tagMSGBOXPARAMSW;
  MSGBOXPARAMS = tagMSGBOXPARAMS;
  MSGBOXPARAMSA = tagMSGBOXPARAMSA;
  MSGBOXPARAMSW = tagMSGBOXPARAMSW;

function MessageBoxIndirect(const MsgBoxParams: TMsgBoxParams): BOOL;
function MessageBoxIndirectA(const MsgBoxParams: TMsgBoxParamsA): BOOL;
function MessageBoxIndirectW(const MsgBoxParams: TMsgBoxParamsW): BOOL;

function MessageBeep(uType: UINT): BOOL;
function ShowCursor(bShow: BOOL): Integer;
function SetCursorPos(X, Y: Integer): BOOL;
function SetCursor(hCursor: HICON): HCURSOR;
function GetCursorPos(out lpPoint: TPoint): BOOL;
function ClipCursor(const lpRect: TRect): BOOL; overload;
function ClipCursor(lpRect: IntPtr): BOOL; overload;
function GetClipCursor(out lpRect: TRect): BOOL;
function GetCursor: HCURSOR;
function CreateCaret(hWnd: HWND; hBitmap: HBITMAP; nWidth, nHeight: Integer): BOOL;
function GetCaretBlinkTime: UINT;
function SetCaretBlinkTime(uMSeconds: UINT): BOOL;
function DestroyCaret: BOOL;
function HideCaret(hWnd: HWND): BOOL;
function ShowCaret(hWnd: HWND): BOOL;
function SetCaretPos(X, Y: Integer): BOOL;
function GetCaretPos(out lpPoint: TPoint): BOOL;
function ClientToScreen(hWnd: HWND; var lpPoint: TPoint): BOOL;
function ScreenToClient(hWnd: HWND; var lpPoint: TPoint): BOOL;
function MapWindowPoints(hWndFrom, hWndTo: HWND;
  [in, out] lpPoints: array of TPoint; cPoints: UINT): Integer; overload;
function MapWindowPoints(hWndFrom, hWndTo: HWND;
  var lpPoints: TRect; cPoints: UINT): Integer; overload;
function WindowFromPoint(Point: TPoint): HWND;
function ChildWindowFromPoint(hWndParent: HWND; Point: TPoint): HWND;

const
  CWP_ALL = 0;
  CWP_SKIPINVISIBLE = 1;
  CWP_SKIPDISABLED = 2;
  CWP_SKIPTRANSPARENT = 4;

function ChildWindowFromPointEx(hWnd: HWND; Point: TPoint; Flags: UINT): HWND;

const
  { Color Types }
  CTLCOLOR_MSGBOX = 0;
  CTLCOLOR_EDIT = 1;
  CTLCOLOR_LISTBOX = 2;
  CTLCOLOR_BTN = 3;
  CTLCOLOR_DLG = 4;
  CTLCOLOR_SCROLLBAR = 5;
  CTLCOLOR_STATIC = 6;
  CTLCOLOR_MAX = 7;

  COLOR_SCROLLBAR = 0;
  COLOR_BACKGROUND = 1;
  COLOR_ACTIVECAPTION = 2;
  COLOR_INACTIVECAPTION = 3;
  COLOR_MENU = 4;
  COLOR_WINDOW = 5;
  COLOR_WINDOWFRAME = 6;
  COLOR_MENUTEXT = 7;
  COLOR_WINDOWTEXT = 8;
  COLOR_CAPTIONTEXT = 9;
  COLOR_ACTIVEBORDER = 10;
  COLOR_INACTIVEBORDER = 11;
  COLOR_APPWORKSPACE = 12;
  COLOR_HIGHLIGHT = 13;
  COLOR_HIGHLIGHTTEXT = 14;
  COLOR_BTNFACE = 15;
  COLOR_BTNSHADOW = $10;
  COLOR_GRAYTEXT = 17;
  COLOR_BTNTEXT = 18;
  COLOR_INACTIVECAPTIONTEXT = 19;
  COLOR_BTNHIGHLIGHT = 20;

  COLOR_3DDKSHADOW = 21;
  COLOR_3DLIGHT = 22;
  COLOR_INFOTEXT = 23;
  COLOR_INFOBK = 24;

  COLOR_HOTLIGHT = 26;
  COLOR_GRADIENTACTIVECAPTION = 27;
  COLOR_GRADIENTINACTIVECAPTION = 28;

  COLOR_MENUHILIGHT = 29;
  COLOR_MENUBAR = 30;

  COLOR_ENDCOLORS = COLOR_MENUBAR;

  COLOR_DESKTOP = COLOR_BACKGROUND;
  COLOR_3DFACE = COLOR_BTNFACE;
  COLOR_3DSHADOW = COLOR_BTNSHADOW;
  COLOR_3DHIGHLIGHT = COLOR_BTNHIGHLIGHT;
  COLOR_3DHILIGHT = COLOR_BTNHIGHLIGHT;
  COLOR_BTNHILIGHT = COLOR_BTNHIGHLIGHT;

function GetSysColor(nIndex: Integer): DWORD;
function GetSysColorBrush(nIndex: Integer): HBRUSH;
function SetSysColors(cElements: Integer; [in] lpaElements: array of Integer;
  [in] lpaRgbValues: array of COLORREF): BOOL;

function DrawFocusRect(hDC: HDC; const lprc: TRect): BOOL;
function FillRect(hDC: HDC; const lprc: TRect; hbr: HBRUSH): Integer;
function FrameRect(hDC: HDC; const lprc: TRect; hbr: HBRUSH): Integer;
function InvertRect(hDC: HDC; const lprc: TRect): BOOL;
function SetRect(out lprc: TRect; xLeft, yTop, xRight, yBottom: Integer): BOOL;
function SetRectEmpty(out lprc: TRect): BOOL;
function CopyRect(out lprcDst: TRect; const lprcSrc: TRect): BOOL;
function InflateRect(var lprc: TRect; dx, dy: Integer): BOOL;
function IntersectRect(out lprcDst: TRect; const lprcSrc1, lprcSrc2: TRect): BOOL; overload;
function IntersectRect(out lprcDst: TRect; lprcSrc1: IntPtr; const lprcSrc2: TRect): BOOL; overload;
function IntersectRect(out lprcDst: TRect; const lprcSrc1: TRect; lprcSrc2: IntPtr): BOOL; overload;
function IntersectRect(out lprcDst: TRect; lprcSrc1, lprcSrc2: IntPtr): BOOL; overload;
function UnionRect(out lprcDst: TRect; const lprcSrc1, lprcSrc2: TRect): BOOL;
function SubtractRect(out lprcDst: TRect; const lprcSrc1, lprcSrc2: TRect): BOOL;
function OffsetRect(var lprc: TRect; dx, dy: Integer): BOOL;
function IsRectEmpty(const lprc: TRect): BOOL;
function EqualRect(const lprc1, lprc2: TRect): BOOL;
function PtInRect(const lprc: TRect; pt: TPoint): BOOL;

function GetWindowWord(hWnd: HWND; nIndex: Integer): Word;
function SetWindowWord(hWnd: HWND; nIndex: Integer; wNewWord: Word): Word;
function GetWindowLong(hWnd: HWND; nIndex: Integer): Longint;
function GetWindowLongA(hWnd: HWND; nIndex: Integer): Longint;
function GetWindowLongW(hWnd: HWND; nIndex: Integer): Longint;
function SetWindowLong(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): Longint; overload;
function SetWindowLongA(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): Longint; overload;
function SetWindowLongW(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): Longint; overload;
function SetWindowLong(hWnd: HWND; nIndex: Integer; dwNewLong: TFNWndProc): IntPtr; overload;
function SetWindowLongW(hWnd: HWND; nIndex: Integer; dwNewLong: TFNWndProc): IntPtr; overload;
function SetWindowLongA(hWnd: HWND; nIndex: Integer; dwNewLong: TFNWndProc): IntPtr; overload;

function GetClassWord(hWnd: HWND; nIndex: Integer): Word;
function SetClassWord(hWnd: HWND; nIndex: Integer; wNewWord: Word): Word;
function GetClassLong(hWnd: HWND; nIndex: Integer): DWORD;
function GetClassLongA(hWnd: HWND; nIndex: Integer): DWORD;
function GetClassLongW(hWnd: HWND; nIndex: Integer): DWORD;
function SetClassLong(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): DWORD;
function SetClassLongA(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): DWORD;
function SetClassLongW(hWnd: HWND; nIndex: Integer; dwNewLong: Longint): DWORD;
function GetDesktopWindow: HWND;
function GetParent(hWnd: HWND): HWND;
function SetParent(hWndChild, hWndNewParent: HWND): HWND;
function EnumChildWindows(hWndParent: HWND; lpEnumFunc: TFNWndEnumProc;
  lParam: LPARAM): BOOL;
function FindWindow(lpClassName, lpWindowName: string): HWND;
function FindWindowA(lpClassName, lpWindowName: string): HWND;
function FindWindowW(lpClassName, lpWindowName: string): HWND;
function FindWindowEx(Parent, Child: HWND; ClassName, WindowName: string): HWND; overload;
function FindWindowEx(Parent, Child: HWND; ClassName: string; WindowName: IntPtr): HWND; overload;
function FindWindowExA(Parent, Child: HWND; ClassName, WindowName: string): HWND;
function FindWindowExW(Parent, Child: HWND; ClassName, WindowName: string): HWND;
function EnumWindows(lpEnumFunc: TFNWndEnumProc; lParam: LPARAM): BOOL;
function EnumThreadWindows(dwThreadId: DWORD; lpfn: TFNWndEnumProc; lParam: LPARAM): BOOL;
function EnumTaskWindows(hTask: THandle; lpfn: TFNWndEnumPRoc; lParam: LPARAM): BOOL;
function GetClassName(hWnd: HWND; lpClassName: StringBuilder; nMaxCount: Integer): Integer;
function GetClassNameA(hWnd: HWND; lpClassName: StringBuilder; nMaxCount: Integer): Integer;
function GetClassNameW(hWnd: HWND; lpClassName: StringBuilder; nMaxCount: Integer): Integer;
function GetTopWindow(hWnd: HWND): HWND;
function GetNextWindow(hWnd: HWND; uCmd: UINT): HWND;
function GetWindowThreadProcessId(hWnd: HWND; lpdwProcessId: IntPtr): DWORD; overload;
function GetWindowThreadProcessId(hWnd: HWND; out dwProcessId: DWORD): DWORD; overload;
function GetWindowTask(hWnd: HWND): THandle;
function GetLastActivePopup(hWnd: HWND): HWND;

const
  { GetWindow() Constants }
  GW_HWNDFIRST = 0;
  GW_HWNDLAST = 1;
  GW_HWNDNEXT = 2;
  GW_HWNDPREV = 3;
  GW_OWNER = 4;
  GW_CHILD = 5;
  GW_MAX = 5;

function GetWindow(hWnd: HWND; uCmd: UINT): HWND;
function SetWindowsHook(nFilterType: Integer; pfnFilterProc: TFNHookProc): HHOOK;
function SetWindowsHookA(nFilterType: Integer; pfnFilterProc: TFNHookProc): HHOOK;
function SetWindowsHookW(nFilterType: Integer; pfnFilterProc: TFNHookProc): HHOOK;
function SetWindowsHookEx(idHook: Integer; lpfn: TFNHookProc; hmod: HINST;
  dwThreadId: DWORD): HHOOK; overload;
function SetWindowsHookEx(idHook: Integer; lpfn: TFNMsgHookProc; hmod: HINST;
  dwThreadId: DWORD): HHOOK; overload;
function SetWindowsHookExA(idHook: Integer; lpfn: TFNHookProc; hmod: HINST; dwThreadId: DWORD): HHOOK;
function SetWindowsHookExW(idHook: Integer; lpfn: TFNHookProc; hmod: HINST; dwThreadId: DWORD): HHOOK;
function UnhookWindowsHook(nCode: Integer; pfnFilterProc: TFNHookProc): BOOL;
function UnhookWindowsHookEx(hhk: HHOOK): BOOL;
function CallNextHookEx(hhk: HHOOK; nCode: Integer; wParam: WPARAM;
  lParam: LPARAM): LRESULT; overload;
function CallNextHookEx(hhk: HHOOK; nCode: Integer; wParam: WPARAM;
  lParam: IntPtr): LRESULT; overload;

{ Macros for source-level compatibility with old functions. }

function DefHookProc(nCode: Integer; wParam: WPARAM; lParam: LPARAM; phhk: FARPROC): LRESULT;

const
{ Menu flags for AddCheckEnableMenuItem() }

  MF_INSERT = 0;
  MF_CHANGE = $80;
  MF_APPEND = $100;
  MF_DELETE = $200;
  MF_REMOVE = $1000;

  MF_BYCOMMAND = 0;
  MF_BYPOSITION = $400;

  MF_SEPARATOR = $800;

  MF_ENABLED = 0;
  MF_GRAYED = 1;
  MF_DISABLED = 2;

  MF_UNCHECKED = 0;
  MF_CHECKED = 8;
  MF_USECHECKBITMAPS = $200;

  MF_STRING = 0;
  MF_BITMAP = 4;
  MF_OWNERDRAW = $100;

  MF_POPUP = $10;
  MF_MENUBARBREAK = $20;
  MF_MENUBREAK = $40;

  MF_UNHILITE = 0;
  MF_HILITE = $80;

  MF_DEFAULT = $1000;
  MF_SYSMENU = $2000;
  MF_HELP = $4000;
  MF_RIGHTJUSTIFY = $4000;

  MF_MOUSESELECT = $8000;
  MF_END = $80;            { Obsolete -- only used by old RES files }

  MFT_STRING = MF_STRING;
  MFT_BITMAP = MF_BITMAP;
  MFT_MENUBARBREAK = MF_MENUBARBREAK;
  MFT_MENUBREAK = MF_MENUBREAK;
  MFT_OWNERDRAW = MF_OWNERDRAW;
  MFT_RADIOCHECK = $200;
  MFT_SEPARATOR = MF_SEPARATOR;
  MFT_RIGHTORDER = $2000;
  MFT_RIGHTJUSTIFY = MF_RIGHTJUSTIFY;

  { Menu flags for AddCheckEnableMenuItem() }
  MFS_GRAYED = 3;
  MFS_DISABLED = MFS_GRAYED;
  MFS_CHECKED = MF_CHECKED;
  MFS_HILITE = MF_HILITE;
  MFS_ENABLED = MF_ENABLED;
  MFS_UNCHECKED = MF_UNCHECKED;
  MFS_UNHILITE = MF_UNHILITE;
  MFS_DEFAULT = MF_DEFAULT;

  MFS_MASK = $108B;
  MFS_HOTTRACKDRAWN = $10000000;
  MFS_CACHEDBMP = $20000000;
  MFS_BOTTOMGAPDROP = $40000000;
  MFS_TOPGAPDROP = $80000000;
  MFS_GAPDROP = $C0000000;

function CheckMenuRadioItem(hMenu: HMENU; First, Last, Check, Flags: UINT): BOOL;

type
  { Menu item resource format }
  MENUITEMTEMPLATEHEADER = packed record
    versionNumber: Word;
    offset: Word;
  end;
  TMenuItemTemplateHeader = MENUITEMTEMPLATEHEADER;

  MENUITEMTEMPLATE = packed record {Version 0}
    mtOption: Word;
    mtID: Word;
    mtString: array[0..0] of WCHAR;
  end;
  TMenuItemTemplate = MENUITEMTEMPLATE;


const
  { System Menu Command Values }
  SC_SIZE = 61440;
  SC_MOVE = 61456;
  SC_MINIMIZE = 61472;
  SC_MAXIMIZE = 61488;
  SC_NEXTWINDOW = 61504;
  SC_PREVWINDOW = 61520;
  SC_CLOSE = 61536;
  SC_VSCROLL = 61552;
  SC_HSCROLL = 61568;
  SC_MOUSEMENU = 61584;
  SC_KEYMENU = 61696;
  SC_ARRANGE = 61712;
  SC_RESTORE = 61728;
  SC_TASKLIST = 61744;
  SC_SCREENSAVE = 61760;
  SC_HOTKEY = 61776;
  SC_DEFAULT = 61792;
  SC_MONITORPOWER = 61808;
  SC_CONTEXTHELP = 61824;
  SC_SEPARATOR = 61455;

  { Obsolete names }
  SC_ICON = SC_MINIMIZE;
  SC_ZOOM = SC_MAXIMIZE;

{ Resource Loading Routines }

function LoadBitmap(hInstance: HINST; lpBitmapName: string): HBITMAP; overload;
function LoadBitmapA(hInstance: HINST; lpBitmapName: string): HBITMAP; overload;
function LoadBitmapW(hInstance: HINST; lpBitmapName: string): HBITMAP; overload;
function LoadBitmap(hInstance: HINST; lpBitmapID: Integer): HBITMAP; overload;
function LoadBitmapA(hInstance: HINST; lpBitmapID: Integer): HBITMAP; overload;
function LoadBitmapW(hInstance: HINST; lpBitmapID: Integer): HBITMAP; overload;
function LoadCursor(hInstance: HINST; lpCursorName: string): HCURSOR; overload;
function LoadCursorA(hInstance: HINST; lpCursorName: string): HCURSOR; overload;
function LoadCursorW(hInstance: HINST; lpCursorName: string): HCURSOR; overload;
function LoadCursor(hInstance: HINST; lpCursorId: Integer): HCURSOR; overload;
function LoadCursorA(hInstance: HINST; lpCursorId: Integer): HCURSOR; overload;
function LoadCursorW(hInstance: HINST; lpCursorId: Integer): HCURSOR; overload;
function LoadCursorFromFile(lpFileName: string): HCURSOR;
function LoadCursorFromFileA(lpFileName: string): HCURSOR;
function LoadCursorFromFileW(lpFileName: string): HCURSOR;
function CreateCursor(hInst: HINST; xHotSpot, yHotSpot, nWidth, nHeight: Integer;
  [in] pvANDPlaneter, [in] pvXORPlane: TBytes): HCURSOR;
function DestroyCursor(hCursor: HICON): BOOL;

const
  { Standard Cursor IDs }
  IDC_ARROW = MakeIntResource(32512);
  IDC_IBEAM = MakeIntResource(32513);
  IDC_WAIT = MakeIntResource(32514);
  IDC_CROSS = MakeIntResource(32515);
  IDC_UPARROW = MakeIntResource(32516);
  IDC_SIZE = MakeIntResource(32640);
  IDC_ICON = MakeIntResource(32641);
  IDC_SIZENWSE = MakeIntResource(32642);
  IDC_SIZENESW = MakeIntResource(32643);
  IDC_SIZEWE = MakeIntResource(32644);
  IDC_SIZENS = MakeIntResource(32645);
  IDC_SIZEALL = MakeIntResource(32646);
  IDC_NO = MakeIntResource(32648);
  IDC_HAND = MakeIntResource(32649);
  IDC_APPSTARTING = MakeIntResource(32650);
  IDC_HELP = MakeIntResource(32651);

function SetSystemCursor(hcur: HICON; id: DWORD): BOOL;

type
  _ICONINFO = packed record
    fIcon: BOOL;
    xHotspot: DWORD;
    yHotspot: DWORD;
    hbmMask: HBITMAP;
    hbmColor: HBITMAP;
  end;
  TIconInfo = _ICONINFO;
  ICONINFO = _ICONINFO;

function LoadIcon(hInstance: HINST; lpIconName: string): HICON; overload;
function LoadIconA(hInstance: HINST; lpIconName: string): HICON; overload;
function LoadIconW(hInstance: HINST; lpIconName: string): HICON; overload;
function LoadIcon(hInstance: HINST; lpIconId: Integer): HICON; overload;
function LoadIconA(hInstance: HINST; lpIconId: Integer): HICON; overload;
function LoadIconW(hInstance: HINST; lpIconId: Integer): HICON; overload;
function CreateIcon(hInstance: HINST; nWidth, nHeight: Integer;
  cPlanes, cBitsPixel: Byte; [in] lpbANDbits, [in] lpbXORbits: TBytes): HICON;
function DestroyIcon(hIcon: HICON): BOOL;
function LookupIconIdFromDirectory([in] presbits: TBytes; fIcon: BOOL): Integer;
function LookupIconIdFromDirectoryEx([in] presbits: TBytes; fIcon: BOOL;
  cxDesired, cyDesired: Integer; Flags: UINT): Integer;
function CreateIconFromResource([in] presbits: TBytes; dwResSize: DWORD;
  fIcon: BOOL; dwVer: DWORD): HICON;
function CreateIconFromResourceEx([in] presbits: TBytes; dwResSize: DWORD;
  fIcon: BOOL; dwVer: DWORD; cxDesired, cyDesired: Integer; Flags: UINT): HICON;


type
  { IconCursor header }
  [StructLayout(LayoutKind.Sequential)]
  tagCURSORSHAPE = record
    xHotSpot: Integer;
    yHotSpot: Integer;
    cx: Integer;
    cy: Integer;
    cbWidth: Integer;
    Planes: Byte;
    BitsPixel: Byte;
  end;
  TCursorShape = tagCURSORSHAPE;
  CURSORSHAPE = tagCURSORSHAPE;

const
  IMAGE_BITMAP = 0;
  IMAGE_ICON = 1;
  IMAGE_CURSOR = 2;
  IMAGE_ENHMETAFILE = 3;

  LR_DEFAULTCOLOR = $0000;
  LR_MONOCHROME = $0001;
  LR_COLOR = $0002;
  LR_COPYRETURNORG = $0004;
  LR_COPYDELETEORG = $0008;
  LR_LOADFROMFILE = $0010;
  LR_LOADTRANSPARENT = $0020;
  LR_DEFAULTSIZE = $0040;
  LR_VGACOLOR = $0080;
  LR_LOADMAP3DCOLORS = $1000;
  LR_CREATEDIBSECTION = $2000;
  LR_COPYFROMRESOURCE = $4000;
  LR_SHARED = $8000;

function LoadImage(hInst: HINST; ImageName: string; ImageType: UINT; X, Y: Integer; Flags: UINT): THandle; overload;
function LoadImage(hInst: HINST; ImageName: Integer; ImageType: UINT; X, Y: Integer; Flags: UINT): THandle; overload;
function LoadImageA(hInst: HINST; ImageName: string; ImageType: UINT; X, Y: Integer; Flags: UINT): THandle;
function LoadImageW(hInst: HINST; ImageName: string; ImageType: UINT; X, Y: Integer; Flags: UINT): THandle;
function CopyImage(hImage: THandle; ImageType: UINT; X, Y: Integer; Flags: UINT): THandle;

const
  DI_MASK = 1;
  DI_IMAGE = 2;
  DI_NORMAL = 3;
  DI_COMPAT = 4;
  DI_DEFAULTSIZE = 8;

function DrawIconEx(hdc: HDC; xLeft, yTop: Integer; hIcon: HICON;
  cxWidth, cyWidth: Integer; istepIfAniCur: UINT;
  hbrFlickerFreeDraw: HBRUSH; diFlags: UINT): BOOL;
function CreateIconIndirect(const piconinfo: TIconInfo): HICON;
function CopyIcon(hIcon: HICON): HICON;
function GetIconInfo(hIcon: HICON; out piconinfo: TIconInfo): BOOL;

const
  OBM_CLOSE               = 32754;
  OBM_UPARROW             = 32753;
  OBM_DNARROW             = 32752;
  OBM_RGARROW             = 32751;
  OBM_LFARROW             = 32750;
  OBM_REDUCE              = 32749;
  OBM_ZOOM                = 32748;
  OBM_RESTORE             = 32747;
  OBM_REDUCED             = 32746;
  OBM_ZOOMD               = 32745;
  OBM_RESTORED            = 32744;
  OBM_UPARROWD            = 32743;
  OBM_DNARROWD            = 32742;
  OBM_RGARROWD            = 32741;
  OBM_LFARROWD            = 32740;
  OBM_MNARROW             = 32739;
  OBM_COMBO               = 32738;
  OBM_UPARROWI            = 32737;
  OBM_DNARROWI            = 32736;
  OBM_RGARROWI            = 32735;
  OBM_LFARROWI            = 32734;

  OBM_OLD_CLOSE           = 32767;
  OBM_SIZE                = 32766;
  OBM_OLD_UPARROW         = 32765;
  OBM_OLD_DNARROW         = 32764;
  OBM_OLD_RGARROW         = 32763;
  OBM_OLD_LFARROW         = 32762;
  OBM_BTSIZE              = 32761;
  OBM_CHECK               = 32760;
  OBM_CHECKBOXES          = 32759;
  OBM_BTNCORNERS          = 32758;
  OBM_OLD_REDUCE          = 32757;
  OBM_OLD_ZOOM            = 32756;
  OBM_OLD_RESTORE         = 32755;

  OCR_NORMAL              = 32512;
  OCR_IBEAM               = 32513;
  OCR_WAIT                = 32514;
  OCR_CROSS               = 32515;
  OCR_UP                  = 32516;
  OCR_SIZE                = 32640;  { OBSOLETE: use OCR_SIZEALL }
  OCR_ICON                = 32641;  { OBSOLETE: use OCR_NORMAL }
  OCR_SIZENWSE            = 32642;
  OCR_SIZENESW            = 32643;
  OCR_SIZEWE              = 32644;
  OCR_SIZENS              = 32645;
  OCR_SIZEALL             = 32646;
  OCR_ICOCUR              = 32647;  { OBSOLETE: use OIC_WINLOGO }
  OCR_NO                  = 32648;
  OCR_HAND                  = 32649;
  OCR_APPSTARTING         = 32650;

  OIC_SAMPLE              = 32512;
  OIC_HAND                = 32513;
  OIC_QUES                = 32514;
  OIC_BANG                = 32515;
  OIC_NOTE                = 32516;
  OIC_WINLOGO             = 32517;
  OIC_WARNING             = OIC_BANG;
  OIC_ERROR               = OIC_HAND;
  OIC_INFORMATION         = OIC_NOTE;

  RES_ICON = 1;
  RES_CURSOR = 2;

  { The ordinal number for the entry point of language drivers. }
  ORD_LANGDRIVER = 1;

  { Standard Icon IDs }
  IDI_APPLICATION = MakeIntResource(32512);
  IDI_HAND = MakeIntResource(32513);
  IDI_QUESTION = MakeIntResource(32514);
  IDI_EXCLAMATION = MakeIntResource(32515);
  IDI_ASTERISK = MakeIntResource(32516);
  IDI_WINLOGO = MakeIntResource(32517);
  IDI_WARNING = IDI_EXCLAMATION;
  IDI_ERROR = IDI_HAND;
  IDI_INFORMATION = IDI_ASTERISK;

function LoadString(hInstance: HINST; uID: UINT; lpBuffer: StringBuilder; nBufferMax: Integer): Integer;
function LoadStringA(hInstance: HINST; uID: UINT; lpBuffer: StringBuilder; nBufferMax: Integer): Integer;
function LoadStringW(hInstance: HINST; uID: UINT; lpBuffer: StringBuilder; nBufferMax: Integer): Integer;

const
  { Dialog Box Command IDs }
  IDOK = 1;          ID_OK = IDOK;
  IDCANCEL = 2;      ID_CANCEL = IDCANCEL;
  IDABORT = 3;       ID_ABORT = IDABORT;
  IDRETRY = 4;       ID_RETRY = IDRETRY;
  IDIGNORE = 5;      ID_IGNORE = IDIGNORE;
  IDYES = 6;         ID_YES = IDYES;
  IDNO = 7;          ID_NO = IDNO;
  IDCLOSE = 8;       ID_CLOSE = IDCLOSE;
  IDHELP = 9;        ID_HELP = IDHELP;
  IDTRYAGAIN = 10;
  IDCONTINUE = 11;


{ Control Manager Structures and Definitions }

  { Edit Control Styles }
  ES_LEFT = 0;
  ES_CENTER = 1;
  ES_RIGHT = 2;
  ES_MULTILINE = 4;
  ES_UPPERCASE = 8;
  ES_LOWERCASE = $10;
  ES_PASSWORD = $20;
  ES_AUTOVSCROLL = $40;
  ES_AUTOHSCROLL = $80;
  ES_NOHIDESEL = $100;
  ES_OEMCONVERT = $400;
  ES_READONLY = $800;
  ES_WANTRETURN = $1000;
  ES_NUMBER = $2000;

  { Edit control EM_SETMARGIN parameters }
  EC_LEFTMARGIN = 1;
  EC_RIGHTMARGIN = 2;
  EC_USEFONTINFO = 65535;

  { wParam of EM_GET/SETIMESTATUS }
  EMSIS_COMPOSITIONSTRING = 1;

  { lParam for EMSIS_COMPOSITIONSTRING }
  EIMES_GETCOMPSTRATONCE = 1;
  EIMES_CANCELCOMPSTRINGFOCUS = 2;
  EIMES_COMPLETECOMPSTRKILLFOCUS = 4;

  { TFNEditWordBreakProc code values }
  WB_LEFT = 0;
  WB_RIGHT = 1;
  WB_ISDELIMITER = 2;

  { Button Control Styles }
  BS_PUSHBUTTON = 0;
  BS_DEFPUSHBUTTON = 1;
  BS_CHECKBOX = 2;
  BS_AUTOCHECKBOX = 3;
  BS_RADIOBUTTON = 4;
  BS_3STATE = 5;
  BS_AUTO3STATE = 6;
  BS_GROUPBOX = 7;
  BS_USERBUTTON = 8;
  BS_AUTORADIOBUTTON = 9;
  BS_OWNERDRAW = 11;
  BS_LEFTTEXT = $20;
  BS_TEXT = 0;
  BS_ICON = $40;
  BS_BITMAP = $80;
  BS_LEFT = $100;
  BS_RIGHT = $200;
  BS_CENTER = 768;
  BS_TOP = $400;
  BS_BOTTOM = $800;
  BS_VCENTER = 3072;
  BS_PUSHLIKE = $1000;
  BS_MULTILINE = $2000;
  BS_NOTIFY = $4000;
  BS_FLAT = $8000;
  BS_RIGHTBUTTON = BS_LEFTTEXT;

  BST_UNCHECKED = 0;
  BST_CHECKED = 1;
  BST_INDETERMINATE = 2;
  BST_PUSHED = 4;
  BST_FOCUS = 8;

  { Static Control Constants }
  SS_LEFT = 0;
  SS_CENTER = 1;
  SS_RIGHT = 2;
  SS_ICON = 3;
  SS_BLACKRECT = 4;
  SS_GRAYRECT = 5;
  SS_WHITERECT = 6;
  SS_BLACKFRAME = 7;
  SS_GRAYFRAME = 8;
  SS_WHITEFRAME = 9;
  SS_USERITEM = 10;
  SS_SIMPLE = 11;
  SS_LEFTNOWORDWRAP = 12;
  SS_BITMAP = 14;
  SS_OWNERDRAW = 13;
  SS_ENHMETAFILE = 15;
  SS_ETCHEDHORZ = $10;
  SS_ETCHEDVERT = 17;
  SS_ETCHEDFRAME = 18;
  SS_TYPEMASK = 31;
  SS_NOPREFIX = $80;      { Don't do "&" character translation }
  SS_NOTIFY = $100;
  SS_CENTERIMAGE = $200;
  SS_RIGHTJUST = $400;
  SS_REALSIZEIMAGE = $800;
  SS_SUNKEN = $1000;
  SS_ENDELLIPSIS =  $4000;
  SS_PATHELLIPSIS = $8000;
  SS_WORDELLIPSIS = $C000;
  SS_ELLIPSISMASK = $C000;

  { Static Control Mesages }
  STM_SETICON = 368;
  STM_GETICON = 369;
  STM_SETIMAGE = 370;
  STM_GETIMAGE = 371;
  STN_CLICKED = 0;
  STN_DBLCLK = 1;
  STN_ENABLE = 2;
  STN_DISABLE = 3;
  STM_MSGMAX = 372;

  { Dialog window class }
  WC_DIALOG = MakeIntAtom($8002);

  { GetSetWindowWordLong offsets for use with WC_DIALOG windows }
  DWL_MSGRESULT = 0;
  DWL_DLGPROC = 4;
  DWL_USER = 8;

{ Dialog Manager Routines }

function IsDialogMessage(hDlg: HWND; const lpMsg: TMsg): BOOL;
function IsDialogMessageA(hDlg: HWND; const lpMsg: TMsg): BOOL;
function IsDialogMessageW(hDlg: HWND; const lpMsg: TMsg): BOOL;
function MapDialogRect(hDlg: HWND; var lpRect: TRect): BOOL;
function DlgDirList(hDlg: HWND; lpPathSpec: string;
  nIDListBox, nIDStaticPath: Integer; uFileType: UINT): Integer;
function DlgDirListA(hDlg: HWND; lpPathSpec: string;
  nIDListBox, nIDStaticPath: Integer; uFileType: UINT): Integer;
function DlgDirListW(hDlg: HWND; lpPathSpec: string;
  nIDListBox, nIDStaticPath: Integer; uFileType: UINT): Integer;

const
  { DlgDirList, DlgDirListComboBox flags values }
  DDL_READWRITE = 0;
  DDL_READONLY = 1;
  DDL_HIDDEN = 2;
  DDL_SYSTEM = 4;
  DDL_DIRECTORY = $10;
  DDL_ARCHIVE = $20;

  DDL_POSTMSGS = $2000;
  DDL_DRIVES = $4000;
  DDL_EXCLUSIVE = $8000;

function DlgDirSelectEx(hDlg: HWND; lpString: string; nCount, nIDListBox: Integer): BOOL;
function DlgDirSelectExA(hDlg: HWND; lpString: string; nCount, nIDListBox: Integer): BOOL;
function DlgDirSelectExW(hDlg: HWND; lpString: string; nCount, nIDListBox: Integer): BOOL;
function DlgDirListComboBox(hDlg: HWND; lpPathSpec: string;
  nIDComboBox, nIDStaticPath: Integer; uFiletype: UINT): Integer;
function DlgDirListComboBoxA(hDlg: HWND; lpPathSpec: string;
  nIDComboBox, nIDStaticPath: Integer; uFiletype: UINT): Integer;
function DlgDirListComboBoxW(hDlg: HWND; lpPathSpec: string;
  nIDComboBox, nIDStaticPath: Integer; uFiletype: UINT): Integer;
function DlgDirSelectComboBoxEx(hDlg: HWND; lpString: string;
  nCount, nIDComboBox: Integer): BOOL;
function DlgDirSelectComboBoxExA(hDlg: HWND; lpString: string;
  nCount, nIDComboBox: Integer): BOOL;
function DlgDirSelectComboBoxExW(hDlg: HWND; lpString: string;
  nCount, nIDComboBox: Integer): BOOL;

const
  { Dialog Styles }
  DS_ABSALIGN = 1;
  DS_SYSMODAL = 2;
  DS_LOCALEDIT = $20;         { Edit items get Local storage. }
  DS_SETFONT = $40;           { User specified font for Dlg controls }
  DS_MODALFRAME = $80;        { Can be combined with WS_CAPTION  }
  DS_NOIDLEMSG = $100;        { WM_ENTERIDLE message will not be sent }
  DS_SETFOREGROUND = $200;    { not in win3.1 }

  DS_3DLOOK = 4;
  DS_FIXEDSYS = 8;
  DS_NOFAILCREATE = $10;
  DS_CONTROL = $400;
  DS_CENTER = $800;
  DS_CENTERMOUSE = $1000;
  DS_CONTEXTHELP = $2000;

  PSI_SETACTIVE = 1;
  PSI_KILLACTIVE = 2;
  PSI_APPLY = 3;
  PSI_RESET = 4;
  PSI_HASHELP = 5;
  PSI_HELP = 6;

  PSI_CHANGED = 1;
  PSI_GUISTART = 2;
  PSI_REBOOT = 3;
  PSI_GETSIBLINGS = 4;

  { Returned in HiWord() of DM_GETDEFID result if msg is supported }
  DC_HASDEFID = 21323;

  { Dialog Codes }
  DLGC_WANTARROWS = 1;         { Control wants arrow keys         }
  DLGC_WANTTAB = 2;            { Control wants tab keys           }
  DLGC_WANTALLKEYS = 4;        { Control wants all keys           }
  DLGC_WANTMESSAGE = 4;        { Pass message to control          }
  DLGC_HASSETSEL = 8;          { Understands EM_SETSEL message    }
  DLGC_DEFPUSHBUTTON = $10;    { Default pushbutton               }
  DLGC_UNDEFPUSHBUTTON = $20;  { Non-default pushbutton           }
  DLGC_RADIOBUTTON = $40;      { Radio button                     }
  DLGC_WANTCHARS = $80;        { Want WM_CHAR messages            }
  DLGC_STATIC = $100;          { Static item: don't include       }
  DLGC_BUTTON = $2000;         { Button item: can be checked      }
  LB_CTLCODE = 0;

  { Listbox Return Values }
  LB_OKAY = 0;
  LB_ERR = -1;
  LB_ERRSPACE = -2;

  { Listbox Styles }
  LBS_NOTIFY = 1;
  LBS_SORT = 2;
  LBS_NOREDRAW = 4;
  LBS_MULTIPLESEL = 8;
  LBS_OWNERDRAWFIXED = $10;
  LBS_OWNERDRAWVARIABLE = $20;
  LBS_HASSTRINGS = $40;
  LBS_USETABSTOPS = $80;
  LBS_NOINTEGRALHEIGHT = $100;
  LBS_MULTICOLUMN = $200;
  LBS_WANTKEYBOARDINPUT = $400;
  LBS_EXTENDEDSEL = $800;
  LBS_DISABLENOSCROLL = $1000;
  LBS_NODATA = $2000;
  LBS_NOSEL = $4000;
  LBS_STANDARD = (LBS_NOTIFY or LBS_SORT or WS_VSCROLL or WS_BORDER);

  { Combo Box return Values }
  CB_OKAY = 0;
  CB_ERR = -1;
  CB_ERRSPACE = -2;

  { Combo Box styles }
  CBS_SIMPLE = 1;
  CBS_DROPDOWN = 2;
  CBS_DROPDOWNLIST = 3;
  CBS_OWNERDRAWFIXED = $10;
  CBS_OWNERDRAWVARIABLE = $20;
  CBS_AUTOHSCROLL = $40;
  CBS_OEMCONVERT = $80;
  CBS_SORT = $100;
  CBS_HASSTRINGS = $200;
  CBS_NOINTEGRALHEIGHT = $400;
  CBS_DISABLENOSCROLL = $800;
  CBS_UPPERCASE = $2000;
  CBS_LOWERCASE = $4000;

  { Scroll Bar Styles }
  SBS_HORZ = 0;
  SBS_VERT = 1;
  SBS_TOPALIGN = 2;
  SBS_LEFTALIGN = 2;
  SBS_BOTTOMALIGN = 4;
  SBS_RIGHTALIGN = 4;
  SBS_SIZEBOXTOPLEFTALIGN = 2;
  SBS_SIZEBOXBOTTOMRIGHTALIGN = 4;
  SBS_SIZEBOX = 8;
  SBS_SIZEGRIP = $10;

  SIF_RANGE = 1;
  SIF_PAGE = 2;
  SIF_POS = 4;
  SIF_DISABLENOSCROLL = 8;
  SIF_TRACKPOS = $10;
  SIF_ALL = (SIF_RANGE or SIF_PAGE or SIF_POS or SIF_TRACKPOS);

type
  tagSCROLLINFO = packed record
    cbSize: UINT;
    fMask: UINT;
    nMin: Integer;
    nMax: Integer;
    nPage: UINT;
    nPos: Integer;
    nTrackPos: Integer;
  end;
  TScrollInfo = tagSCROLLINFO;
  SCROLLINFO = tagSCROLLINFO;

function SetScrollInfo(hWnd: HWND; BarFlag: Integer; const ScrollInfo: TScrollInfo; Redraw: BOOL): Integer;
function GetScrollInfo(hWnd: HWND; BarFlag: Integer; var ScrollInfo: TScrollInfo): BOOL;


const
  { MDI client style bits }
  MDIS_ALLCHILDSTYLES = 1;

  { wParam Flags for WM_MDITILE and WM_MDICASCADE messages. }
  MDITILE_VERTICAL = 0;       { not in win3.1  }
  MDITILE_HORIZONTAL = 1;     { not in win3.1  }
  MDITILE_SKIPDISABLED = 2;   { not in win3.1  }

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMDICREATESTRUCT = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    szClass: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    szTitle: string;
    hOwner: THandle;
    x: Integer;
    y: Integer;
    cx: Integer;
    cy: Integer;
    style: DWORD;
    lParam: LPARAM;  { app-defined stuff }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMDICREATESTRUCTA = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    szClass: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    szTitle: string;
    hOwner: THandle;
    x: Integer;
    y: Integer;
    cx: Integer;
    cy: Integer;
    style: DWORD;
    lParam: LPARAM;  { app-defined stuff }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMDICREATESTRUCTW = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    szClass: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    szTitle: string;
    hOwner: THandle;
    x: Integer;
    y: Integer;
    cx: Integer;
    cy: Integer;
    style: DWORD;
    lParam: LPARAM;  { app-defined stuff }
  end;
  TMDICreateStruct = tagMDICREATESTRUCT;
  TMDICreateStructA = tagMDICREATESTRUCTA;
  TMDICreateStructW = tagMDICREATESTRUCTW;
  MDICREATESTRUCT = tagMDICREATESTRUCT;
  MDICREATESTRUCTA = tagMDICREATESTRUCTA;
  MDICREATESTRUCTW = tagMDICREATESTRUCTW;

function DefFrameProc(hWnd, hWndMDIClient: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function DefFrameProcA(hWnd, hWndMDIClient: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function DefFrameProcW(hWnd, hWndMDIClient: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function DefMDIChildProc(hWnd: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function DefMDIChildProcA(hWnd: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function DefMDIChildProcW(hWnd: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT;
function TranslateMDISysAccel(hWndClient: HWND; const lpMsg: TMsg): BOOL;
function ArrangeIconicWindows(hWnd: HWND): UINT;
function CreateMDIWindow(lpClassName, lpWindowName: string;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hInstance: HINST; lParam: LPARAM): HWND;
function CreateMDIWindowA(lpClassName, lpWindowName: string;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hInstance: HINST; lParam: LPARAM): HWND;
function CreateMDIWindowW(lpClassName, lpWindowName: string;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hInstance: HINST; lParam: LPARAM): HWND;

function TileWindows(hwndParent: HWND; wHow: UINT; const lpRect: TRect;
  cKids: UINT; [in] lpKids: array of HWND): Word; overload;
function TileWindows(hwndParent: HWND; wHow: UINT; lpRect: IntPtr;
  cKids: UINT; lpKids: IntPtr): Word; overload;
function TileWindows(hwndParent: HWND; wHow: UINT; lpRect: IntPtr;
  cKids: UINT; [in] lpKids: array of HWND): Word; overload;
function TileWindows(hwndParent: HWND; wHow: UINT; const lpRect: TRect;
  cKids: UINT; lpKids: IntPtr): Word; overload;

function CascadeWindows(hwndParent: HWND; wHow: UINT; const lpRect: TRect;
  cKids: UINT; [in] lpKids: array of HWND): Word; overload;
function CascadeWindows(hwndParent: HWND; wHow: UINT; lpRect: IntPtr;
  cKids: UINT; lpKids: IntPtr): Word; overload;
function CascadeWindows(hwndParent: HWND; wHow: UINT; lpRect: IntPtr;
  cKids: UINT; [in] lpKids: array of HWND): Word; overload;
function CascadeWindows(hwndParent: HWND; wHow: UINT; const lpRect: TRect;
  cKids: UINT; lpKids: IntPtr): Word; overload;


{ IME class support }

const
  { wParam for WM_IME_CONTROL (removed from 4.0 SDK) }
  IMC_GETCANDIDATEPOS = 7;
  IMC_SETCANDIDATEPOS = 8;
  IMC_GETCOMPOSITIONFONT = 9;
  IMC_SETCOMPOSITIONFONT = $0A;
  IMC_GETCOMPOSITIONWINDOW = $0B;
  IMC_SETCOMPOSITIONWINDOW = $0C;
  IMC_GETSTATUSWINDOWPOS = $0F;
  IMC_SETSTATUSWINDOWPOS = $10;
  IMC_CLOSESTATUSWINDOW = $21;
  IMC_OPENSTATUSWINDOW = $22;

  { wParam of report message WM_IME_NOTIFY (removed from 4.0 SDK) }
  IMN_CLOSESTATUSWINDOW = 1;
  IMN_OPENSTATUSWINDOW = 2;
  IMN_CHANGECANDIDATE = 3;
  IMN_CLOSECANDIDATE = 4;
  IMN_OPENCANDIDATE = 5;
  IMN_SETCONVERSIONMODE = 6;
  IMN_SETSENTENCEMODE = 7;
  IMN_SETOPENSTATUS = 8;
  IMN_SETCANDIDATEPOS = 9;
  IMN_SETCOMPOSITIONFONT = 10;
  IMN_SETCOMPOSITIONWINDOW = 11;
  IMN_SETSTATUSWINDOWPOS = 12;
  IMN_GUIDELINE = 13;
  IMN_PRIVATE = 14;

{ Help support }

type
  HELPPOLY = DWORD;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMULTIKEYHELP = record
    mkSize: DWORD;
    mkKeylist: Char;
    szKeyphrase: IntPtr; { array[0..0] of AnsiChar }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMULTIKEYHELPA = record
    mkSize: DWORD;
    mkKeylist: AnsiChar;
    szKeyphrase: IntPtr; { array[0..0] of AnsiChar }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMULTIKEYHELPW = record
    mkSize: DWORD;
    mkKeylist: WideChar;
    szKeyphrase: IntPtr; { array[0..0] of AnsiChar }
  end;
  TMultiKeyHelp = tagMULTIKEYHELP;
  TMultiKeyHelpA = tagMULTIKEYHELPA;
  TMultiKeyHelpW = tagMULTIKEYHELPW;
  MULTIKEYHELP = tagMULTIKEYHELP;
  MULTIKEYHELPA = tagMULTIKEYHELPA;
  MULTIKEYHELPW = tagMULTIKEYHELPW;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagHELPWININFO = record
    wStructSize: Integer;
    x: Integer;
    y: Integer;
    dx: Integer;
    dy: Integer;
    wMax: Integer;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=2)]
    rgchMember: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagHELPWININFOA = record
    wStructSize: Integer;
    x: Integer;
    y: Integer;
    dx: Integer;
    dy: Integer;
    wMax: Integer;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=2)]
    rgchMember: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagHELPWININFOW = record
    wStructSize: Integer;
    x: Integer;
    y: Integer;
    dx: Integer;
    dy: Integer;
    wMax: Integer;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=2)]
    rgchMember: string;
  end;
  THelpWinInfo = tagHELPWININFO;
  THelpWinInfoA = tagHELPWININFOA;
  THelpWinInfoW = tagHELPWININFOW;
  HELPWININFO = tagHELPWININFO;
  HELPWININFOA = tagHELPWININFOA;
  HELPWININFOW = tagHELPWININFOW;

const
  { Commands to pass to WinHelp() }
  HELP_CONTEXT = 1;       { Display topic in ulTopic  }
  HELP_QUIT = 2;          { Terminate help  }
  HELP_INDEX = 3;         { Display index  }
  HELP_CONTENTS = 3;
  HELP_HELPONHELP = 4;    { Display help on using help  }
  HELP_SETINDEX = 5;      { Set current Index for multi index help  }
  HELP_SETCONTENTS = 5;
  HELP_CONTEXTPOPUP = 8;
  HELP_FORCEFILE = 9;
  HELP_KEY = 257;         { Display topic for keyword in offabData  }
  HELP_COMMAND = 258;
  HELP_PARTIALKEY = 261;
  HELP_MULTIKEY = 513;
  HELP_SETWINPOS = 515;
  HELP_CONTEXTMENU = 10;
  HELP_FINDER = 11;
  HELP_WM_HELP = 12;
  HELP_SETPOPUP_POS = 13;

  HELP_TCARD = $8000;
  HELP_TCARD_DATA = $10;
  HELP_TCARD_OTHER_CALLER = 17;

  { These are in winhelp.h in Win95. }
  IDH_NO_HELP = 28440;
  IDH_MISSING_CONTEXT = 28441;      { Control doesn't have matching help context }
  IDH_GENERIC_HELP_BUTTON = 28442;  { Property sheet help button }
  IDH_OK = 28443;
  IDH_CANCEL = 28444;
  IDH_HELP = 28445;

function WinHelp(hWndMain: HWND; lpszHelp: string; uCommand: UINT; dwData: DWORD): BOOL; overload;
function WinHelp(hWndMain: HWND; lpszHelp: string; uCommand: UINT; dwData: string): BOOL; overload;
function WinHelpA(hWndMain: HWND; lpszHelp: string; uCommand: UINT; dwData: DWORD): BOOL;
function WinHelpW(hWndMain: HWND; lpszHelp: string; uCommand: UINT; dwData: DWORD): BOOL;

const
  GR_GDIOBJECTS = 0;    { Count of GDI objects }
  GR_USEROBJECTS = 1;    { Count of USER objects }

function GetGuiResources(hProcess: THandle; uiFlags: DWORD): DWORD;

const
  { Parameter for SystemParametersInfo() }
  SPI_GETBEEP = 1;
  SPI_SETBEEP = 2;
  SPI_GETMOUSE = 3;
  SPI_SETMOUSE = 4;
  SPI_GETBORDER = 5;
  SPI_SETBORDER = 6;
  SPI_GETKEYBOARDSPEED = 10;
  SPI_SETKEYBOARDSPEED = 11;
  SPI_LANGDRIVER = 12;
  SPI_ICONHORIZONTALSPACING = 13;
  SPI_GETSCREENSAVETIMEOUT = 14;
  SPI_SETSCREENSAVETIMEOUT = 15;
  SPI_GETSCREENSAVEACTIVE = $10;
  SPI_SETSCREENSAVEACTIVE = 17;
  SPI_GETGRIDGRANULARITY = 18;
  SPI_SETGRIDGRANULARITY = 19;
  SPI_SETDESKWALLPAPER = 20;
  SPI_SETDESKPATTERN = 21;
  SPI_GETKEYBOARDDELAY = 22;
  SPI_SETKEYBOARDDELAY = 23;
  SPI_ICONVERTICALSPACING = 24;
  SPI_GETICONTITLEWRAP = 25;
  SPI_SETICONTITLEWRAP = 26;
  SPI_GETMENUDROPALIGNMENT = 27;
  SPI_SETMENUDROPALIGNMENT = 28;
  SPI_SETDOUBLECLKWIDTH = 29;
  SPI_SETDOUBLECLKHEIGHT = 30;
  SPI_GETICONTITLELOGFONT = 31;
  SPI_SETDOUBLECLICKTIME = $20;
  SPI_SETMOUSEBUTTONSWAP = 33;
  SPI_SETICONTITLELOGFONT = 34;
  SPI_GETFASTTASKSWITCH = 35;
  SPI_SETFASTTASKSWITCH = 36;
  SPI_SETDRAGFULLWINDOWS = 37;
  SPI_GETDRAGFULLWINDOWS = 38;
  SPI_GETNONCLIENTMETRICS = 41;
  SPI_SETNONCLIENTMETRICS = 42;
  SPI_GETMINIMIZEDMETRICS = 43;
  SPI_SETMINIMIZEDMETRICS = 44;
  SPI_GETICONMETRICS = 45;
  SPI_SETICONMETRICS = 46;
  SPI_SETWORKAREA = 47;
  SPI_GETWORKAREA = 48;
  SPI_SETPENWINDOWS = 49;

  SPI_GETHIGHCONTRAST = 66;
  SPI_SETHIGHCONTRAST = 67;
  SPI_GETKEYBOARDPREF = 68;
  SPI_SETKEYBOARDPREF = 69;
  SPI_GETSCREENREADER = 70;
  SPI_SETSCREENREADER = 71;
  SPI_GETANIMATION = 72;
  SPI_SETANIMATION = 73;
  SPI_GETFONTSMOOTHING = 74;
  SPI_SETFONTSMOOTHING = 75;
  SPI_SETDRAGWIDTH = 76;
  SPI_SETDRAGHEIGHT = 77;
  SPI_SETHANDHELD = 78;
  SPI_GETLOWPOWERTIMEOUT = 79;
  SPI_GETPOWEROFFTIMEOUT = 80;
  SPI_SETLOWPOWERTIMEOUT = 81;
  SPI_SETPOWEROFFTIMEOUT = 82;
  SPI_GETLOWPOWERACTIVE = 83;
  SPI_GETPOWEROFFACTIVE = 84;
  SPI_SETLOWPOWERACTIVE = 85;
  SPI_SETPOWEROFFACTIVE = 86;
  SPI_SETCURSORS = 87;
  SPI_SETICONS = 88;
  SPI_GETDEFAULTINPUTLANG = 89;
  SPI_SETDEFAULTINPUTLANG = 90;
  SPI_SETLANGTOGGLE = 91;
  SPI_GETWINDOWSEXTENSION = 92;
  SPI_SETMOUSETRAILS = 93;
  SPI_GETMOUSETRAILS = 94;
  SPI_SCREENSAVERRUNNING = 97;
  SPI_GETFILTERKEYS = 50;
  SPI_SETFILTERKEYS = 51;
  SPI_GETTOGGLEKEYS = 52;
  SPI_SETTOGGLEKEYS = 53;
  SPI_GETMOUSEKEYS = 54;
  SPI_SETMOUSEKEYS = 55;
  SPI_GETSHOWSOUNDS = 56;
  SPI_SETSHOWSOUNDS = 57;
  SPI_GETSTICKYKEYS = 58;
  SPI_SETSTICKYKEYS = 59;
  SPI_GETACCESSTIMEOUT = 60;
  SPI_SETACCESSTIMEOUT = 61;
  SPI_GETSERIALKEYS = 62;
  SPI_SETSERIALKEYS = 63;
  SPI_GETSOUNDSENTRY = 64;
  SPI_SETSOUNDSENTRY = 65;

  SPI_GETSNAPTODEFBUTTON = 95;
  SPI_SETSNAPTODEFBUTTON = 96;
  SPI_GETMOUSEHOVERWIDTH = 98;
  SPI_SETMOUSEHOVERWIDTH = 99;
  SPI_GETMOUSEHOVERHEIGHT = 100;
  SPI_SETMOUSEHOVERHEIGHT = 101;
  SPI_GETMOUSEHOVERTIME = 102;
  SPI_SETMOUSEHOVERTIME = 103;
  SPI_GETWHEELSCROLLLINES = 104;
  SPI_SETWHEELSCROLLLINES = 105;         // For Win95 and WinNT3.51,
                                         // Mswheel broadcasts the message
                                         // WM_SETTINGCHANGE (equivalent to
                                         // WM_WININICHANGE) when the scroll
                                         // lines has changed.  Applications
                                         // will receive the WM_SETTINGCHANGE
                                         // message with the wParam set to
                                         // SPI_SETWHEELSCROLLLINES.  When
                                         // this message is received the
                                         // application should query Mswheel for
                                         // the new setting.
  SPI_GETMENUSHOWDELAY = 106;
  SPI_SETMENUSHOWDELAY = 107;
  SPI_GETSHOWIMEUI = 110;
  SPI_SETSHOWIMEUI = 111;
  SPI_GETMOUSESPEED = 112;
  SPI_SETMOUSESPEED = 113;
  SPI_GETSCREENSAVERRUNNING = 114;

  SPI_GETACTIVEWINDOWTRACKING = $1000;
  SPI_SETACTIVEWINDOWTRACKING = $1001;
  SPI_GETMENUANIMATION = $1002;
  SPI_SETMENUANIMATION = $1003;
  SPI_GETCOMBOBOXANIMATION = $1004;
  SPI_SETCOMBOBOXANIMATION = $1005;
  SPI_GETLISTBOXSMOOTHSCROLLING = $1006;
  SPI_SETLISTBOXSMOOTHSCROLLING = $1007;
  SPI_GETGRADIENTCAPTIONS = $1008;
  SPI_SETGRADIENTCAPTIONS = $1009;
  SPI_GETKEYBOARDCUES = $100A;
  SPI_SETKEYBOARDCUES = $100B;
  SPI_GETMENUUNDERLINES = SPI_GETKEYBOARDCUES;
  SPI_SETMENUUNDERLINES = SPI_SETKEYBOARDCUES;
  SPI_GETACTIVEWNDTRKZORDER = $100C;
  SPI_SETACTIVEWNDTRKZORDER = $100D;
  SPI_GETHOTTRACKING = $100E;
  SPI_SETHOTTRACKING = $100F;

  SPI_GETMENUFADE = $1012;
  SPI_SETMENUFADE = $1013;
  SPI_GETSELECTIONFADE = $1014;
  SPI_SETSELECTIONFADE = $1015;
  SPI_GETTOOLTIPANIMATION = $1016;
  SPI_SETTOOLTIPANIMATION = $1017;
  SPI_GETTOOLTIPFADE = $1018;
  SPI_SETTOOLTIPFADE = $1019;
  SPI_GETCURSORSHADOW = $101A;
  SPI_SETCURSORSHADOW = $101B;

  SPI_GETMOUSESONAR = $101C;
  SPI_SETMOUSESONAR = $101D;
  SPI_GETMOUSECLICKLOCK = $101E;
  SPI_SETMOUSECLICKLOCK = $101F;
  SPI_GETMOUSEVANISH = $1020;
  SPI_SETMOUSEVANISH = $1021;
  SPI_GETFLATMENU = $1022;
  SPI_SETFLATMENU = $1023;
  SPI_GETDROPSHADOW = $1024;
  SPI_SETDROPSHADOW = $1025;

  SPI_GETUIEFFECTS = $103E;
  SPI_SETUIEFFECTS = $103F;

  SPI_GETFOREGROUNDLOCKTIMEOUT = $2000;
  SPI_SETFOREGROUNDLOCKTIMEOUT = $2001;
  SPI_GETACTIVEWNDTRKTIMEOUT = $2002;
  SPI_SETACTIVEWNDTRKTIMEOUT = $2003;
  SPI_GETFOREGROUNDFLASHCOUNT = $2004;
  SPI_SETFOREGROUNDFLASHCOUNT = $2005;
  SPI_GETCARETWIDTH = $2006;
  SPI_SETCARETWIDTH = $2007;
  SPI_GETMOUSECLICKLOCKTIME = $2008;
  SPI_SETMOUSECLICKLOCKTIME = $2009;
  SPI_GETFONTSMOOTHINGTYPE = $200A;
  SPI_SETFONTSMOOTHINGTYPE = $200B;

  { constants for SPI_GETFONTSMOOTHINGTYPE and SPI_SETFONTSMOOTHINGTYPE: }
  FE_FONTSMOOTHINGSTANDARD = $0001;
  FE_FONTSMOOTHINGCLEARTYPE = $0002;
  FE_FONTSMOOTHINGDOCKING = $8000;

  SPI_GETFONTSMOOTHINGCONTRAST = $200C;
  SPI_SETFONTSMOOTHINGCONTRAST = $200D;
  SPI_GETFOCUSBORDERWIDTH = $200E;
  SPI_SETFOCUSBORDERWIDTH = $200F;
  SPI_GETFOCUSBORDERHEIGHT = $2010;
  SPI_SETFOCUSBORDERHEIGHT = $2011;

  { Flags }
  SPIF_UPDATEINIFILE = 1;
  SPIF_SENDWININICHANGE = 2;
  SPIF_SENDCHANGE = SPIF_SENDWININICHANGE;

  METRICS_USEDEFAULT = LongWord(-1);

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagNONCLIENTMETRICS = packed record
    cbSize: UINT;
    iBorderWidth: Integer;
    iScrollWidth: Integer;
    iScrollHeight: Integer;
    iCaptionWidth: Integer;
    iCaptionHeight: Integer;
    lfCaptionFont: TLogFont;
    iSmCaptionWidth: Integer;
    iSmCaptionHeight: Integer;
    lfSmCaptionFont: TLogFont;
    iMenuWidth: Integer;
    iMenuHeight: Integer;
    lfMenuFont: TLogFont;
    lfStatusFont: TLogFont;
    lfMessageFont: TLogFont;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagNONCLIENTMETRICSA = packed record
    cbSize: UINT;
    iBorderWidth: Integer;
    iScrollWidth: Integer;
    iScrollHeight: Integer;
    iCaptionWidth: Integer;
    iCaptionHeight: Integer;
    lfCaptionFont: TLogFontA;
    iSmCaptionWidth: Integer;
    iSmCaptionHeight: Integer;
    lfSmCaptionFont: TLogFontA;
    iMenuWidth: Integer;
    iMenuHeight: Integer;
    lfMenuFont: TLogFontA;
    lfStatusFont: TLogFontA;
    lfMessageFont: TLogFontA;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagNONCLIENTMETRICSW = packed record
    cbSize: UINT;
    iBorderWidth: Integer;
    iScrollWidth: Integer;
    iScrollHeight: Integer;
    iCaptionWidth: Integer;
    iCaptionHeight: Integer;
    lfCaptionFont: TLogFontW;
    iSmCaptionWidth: Integer;
    iSmCaptionHeight: Integer;
    lfSmCaptionFont: TLogFontW;
    iMenuWidth: Integer;
    iMenuHeight: Integer;
    lfMenuFont: TLogFontW;
    lfStatusFont: TLogFontW;
    lfMessageFont: TLogFontW;
  end;
  TNonClientMetrics = tagNONCLIENTMETRICS;
  TNonClientMetricsA = tagNONCLIENTMETRICSA;
  TNonClientMetricsW = tagNONCLIENTMETRICSW;
  NONCLIENTMETRICS = tagNONCLIENTMETRICS;
  NONCLIENTMETRICSA = tagNONCLIENTMETRICSA;
  NONCLIENTMETRICSW = tagNONCLIENTMETRICSW;

const
  ARW_BOTTOMLEFT = 0;
  ARW_BOTTOMRIGHT = 1;
  ARW_TOPLEFT = 2;
  ARW_TOPRIGHT = 3;
  ARW_STARTMASK = 3;
  ARW_STARTRIGHT = 1;
  ARW_STARTTOP = 2;

  ARW_LEFT = 0;
  ARW_RIGHT = 0;
  ARW_UP = 4;
  ARW_DOWN = 4;
  ARW_HIDE = 8;
  ARW_VALID = 15;

type
  tagMINIMIZEDMETRICS = packed record
    cbSize: UINT;
    iWidth: Integer;
    iHorzGap: Integer;
    iVertGap: Integer;
    iArrange: Integer;
  end;
  TMinimizedMetrics = tagMINIMIZEDMETRICS;
  MINIMIZEDMETRICS = tagMINIMIZEDMETRICS;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagICONMETRICS = packed record
    cbSize: UINT;
    iHorzSpacing: Integer;
    iVertSpacing: Integer;
    iTitleWrap: Integer;
    lfFont: TLogFont;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagICONMETRICSA = packed record
    cbSize: UINT;
    iHorzSpacing: Integer;
    iVertSpacing: Integer;
    iTitleWrap: Integer;
    lfFont: TLogFontA;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagICONMETRICSW = packed record
    cbSize: UINT;
    iHorzSpacing: Integer;
    iVertSpacing: Integer;
    iTitleWrap: Integer;
    lfFont: TLogFontW;
  end;
  TIconMetrics = tagICONMETRICS;
  TIconMetricsA = tagICONMETRICSA;
  TIconMetricsW = tagICONMETRICSW;
  ICONMETRICS = tagICONMETRICS;
  ICONMETRICSA = tagICONMETRICSA;
  ICONMETRICSW = tagICONMETRICSW;

  tagANIMATIONINFO = packed record
    cbSize: UINT;
    iMinAnimate: Integer;
  end;
  TAnimationInfo = tagANIMATIONINFO;
  ANIMATIONINFO = tagANIMATIONINFO;


type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagSERIALKEYS = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszActivePort: string;
    lpszPort: IntPtr;
    iBaudRate: UINT;
    iPortState: UINT;
    iActive: UINT;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagSERIALKEYSA = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszActivePort: string;
    lpszPort: IntPtr;
    iBaudRate: UINT;
    iPortState: UINT;
    iActive: UINT;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagSERIALKEYSW = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszActivePort: string;
    lpszPort: IntPtr;
    iBaudRate: UINT;
    iPortState: UINT;
    iActive: UINT;
  end;
  TSerialKeys = tagSERIALKEYS;
  TSerialKeysA = tagSERIALKEYSA;
  TSerialKeysW = tagSERIALKEYSW;
  SERIALKEYS = tagSERIALKEYS;
  SERIALKEYSA = tagSERIALKEYSA;
  SERIALKEYSW = tagSERIALKEYSW;

const
  { flags for SERIALKEYS dwFlags field }
  SERKF_SERIALKEYSON = 1;
  SERKF_AVAILABLE = 2;
  SERKF_INDICATOR = 4;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagHIGHCONTRAST = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDefaultScheme: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagHIGHCONTRASTA = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDefaultScheme: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagHIGHCONTRASTW = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDefaultScheme: string;
  end;
  THighContrast = tagHIGHCONTRAST;
  THighContrastA = tagHIGHCONTRASTA;
  THighContrastW = tagHIGHCONTRASTW;
  HIGHCONTRAST = tagHIGHCONTRAST;
  HIGHCONTRASTA = tagHIGHCONTRASTA;
  HIGHCONTRASTW = tagHIGHCONTRASTW;


const
  { flags for HIGHCONTRAST dwFlags field }
  HCF_HIGHCONTRASTON      = $00000001;
  HCF_AVAILABLE           = $00000002;
  HCF_HOTKEYACTIVE        = $00000004;
  HCF_CONFIRMHOTKEY       = $00000008;
  HCF_HOTKEYSOUND         = $00000010;
  HCF_INDICATOR           = $00000020;
  HCF_HOTKEYAVAILABLE     = $00000040;

  { Flags for ChangeDisplaySettings }
  CDS_UPDATEREGISTRY      = $00000001;
  CDS_TEST                = $00000002;
  CDS_FULLSCREEN          = $00000004;
  CDS_GLOBAL              = $00000008;
  CDS_SET_PRIMARY         = $00000010;
  CDS_RESET               = $40000000;
  CDS_SETRECT             = $20000000;
  CDS_NORESET             = $10000000;

  { Return values for ChangeDisplaySettings }
  DISP_CHANGE_SUCCESSFUL           = 0;
  DISP_CHANGE_RESTART              = 1;
  DISP_CHANGE_FAILED              = -1;
  DISP_CHANGE_BADMODE             = -2;
  DISP_CHANGE_NOTUPDATED          = -3;
  DISP_CHANGE_BADFLAGS            = -4;
  DISP_CHANGE_BADPARAM            = -5;


function ChangeDisplaySettings(const lpDevMode: TDeviceMode; dwFlags: DWORD): Longint; overload;
function ChangeDisplaySettings(lpDevMode: IntPtr; dwFlags: DWORD): Longint; overload;
function ChangeDisplaySettingsA(const lpDevMode: TDeviceModeA; dwFlags: DWORD): Longint;
function ChangeDisplaySettingsW(const lpDevMode: TDeviceModeW; dwFlags: DWORD): Longint;

function ChangeDisplaySettingsEx(lpszDeviceName: string; const lpDevMode: TDeviceMode;
        wnd: HWND; dwFlags: DWORD; lParam: IntPtr): Longint; overload;
function ChangeDisplaySettingsEx(lpszDeviceName: IntPtr; const lpDevMode: TDeviceMode;
        wnd: HWND; dwFlags: DWORD; lParam: IntPtr): Longint; overload;
function ChangeDisplaySettingsEx(lpszDeviceName, lpDevMode: IntPtr;
        wnd: HWND; dwFlags: DWORD; lParam: IntPtr): Longint; overload;
function ChangeDisplaySettingsEx(lpszDeviceName: string; lpDevMode: IntPtr;
        wnd: HWND; dwFlags: DWORD; lParam: IntPtr): Longint; overload;
function ChangeDisplaySettingsExA(lpszDeviceName: string; const lpDevMode: TDeviceModeA;
        wnd: HWND; dwFlags: DWORD; lParam: IntPtr): Longint;
function ChangeDisplaySettingsExW(lpszDeviceName: string; const lpDevMode: TDeviceModeW;
        wnd: HWND; dwFlags: DWORD; lParam: IntPtr): Longint;

function EnumDisplaySettings(lpszDeviceName: string; iModeNum: DWORD;
  out lpDevMode: TDeviceMode): BOOL; overload;
function EnumDisplaySettings(lpszDeviceName: IntPtr; iModeNum: DWORD;
  out lpDevMode: TDeviceMode): BOOL; overload;
function EnumDisplaySettingsA(lpszDeviceName: string; iModeNum: DWORD;
  out lpDevMode: TDeviceModeA): BOOL;
function EnumDisplaySettingsW(lpszDeviceName: string; iModeNum: DWORD;
  out lpDevMode: TDeviceModeW): BOOL;

function EnumDisplayDevices(lpDevice: string; iDevNum: DWORD;
  out lpDisplayDevice: TDisplayDevice; dwFlags: DWORD): BOOL; overload;
function EnumDisplayDevices(lpDevice: IntPtr; iDevNum: DWORD;
  out lpDisplayDevice: TDisplayDevice; dwFlags: DWORD): BOOL; overload;
function EnumDisplayDevicesA(lpDevice: string; iDevNum: DWORD;
  out lpDisplayDevice: TDisplayDeviceA; dwFlags: DWORD): BOOL;
function EnumDisplayDevicesW(lpDevice: string; iDevNum: DWORD;
  out lpDisplayDevice: TDisplayDeviceW; dwFlags: DWORD): BOOL;

function SystemParametersInfo(uiAction, uiParam: UINT;
  pvParam: IntPtr; fWinIni: UINT): BOOL; overload;
function SystemParametersInfo(uiAction, uiParam: UINT;
  var pvParam: TRect; fWinIni: UINT): BOOL; overload;
function SystemParametersInfo(uiAction, uiParam: UINT;
  var pvParam: TLogFont; fWinIni: UINT): BOOL; overload;
function SystemParametersInfo(uiAction, uiParam: UINT;
  var pvParam: TAnimationInfo; fWinIni: UINT): BOOL; overload;
function SystemParametersInfo(uiAction, uiParam: UINT;
  var pvParam: Integer; fWinIni: UINT): BOOL; overload;
function SystemParametersInfo(uiAction, uiParam: UINT;
  var pvParam: Bool; fWinIni: UINT): BOOL; overload;
function SystemParametersInfoA(uiAction, uiParam: UINT;
  pvParam: IntPtr; fWinIni: UINT): BOOL;
function SystemParametersInfoW(uiAction, uiParam: UINT;
  pvParam: IntPtr; fWinIni: UINT): BOOL;

type
  { Accessibility support }
  tagFILTERKEYS = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    iWaitMSec: DWORD;       { Acceptance Delay}
    iDelayMSec: DWORD;      { Delay Until Repeat}
    iRepeatMSec: DWORD;     { Repeat Rate}
    iBounceMSec: DWORD;     { Debounce Time}
  end;
  TFilterKeys = tagFILTERKEYS;
  FILTERKEYS = tagFILTERKEYS;


const
  { TFilterKeys dwFlags field }
  FKF_FILTERKEYSON = 1;
  FKF_AVAILABLE = 2;
  FKF_HOTKEYACTIVE = 4;
  FKF_CONFIRMHOTKEY = 8;
  FKF_HOTKEYSOUND = $10;
  FKF_INDICATOR = $20;
  FKF_CLICKON = $40;

type
  tagSTICKYKEYS = packed record
    cbSize: UINT;
    dwFlags: DWORD;
  end;
  TStickyKeys = tagSTICKYKEYS;
  STICKYKEYS = tagSTICKYKEYS;

const
  { TStickyKeys dwFlags field }
  SKF_STICKYKEYSON = 1;
  SKF_AVAILABLE = 2;
  SKF_HOTKEYACTIVE = 4;
  SKF_CONFIRMHOTKEY = 8;
  SKF_HOTKEYSOUND = $10;
  SKF_INDICATOR = $20;
  SKF_AUDIBLEFEEDBACK = $40;
  SKF_TRISTATE = $80;
  SKF_TWOKEYSOFF = $100;
  SKF_LALTLATCHED = $10000000;
  SKF_LCTLLATCHED = $04000000;
  SKF_LSHIFTLATCHED = $01000000;
  SKF_RALTLATCHED = $20000000;
  SKF_RCTLLATCHED = $08000000;
  SKF_RSHIFTLATCHED = $02000000;
  SKF_LWINLATCHED = $40000000;
  SKF_RWINLATCHED = $80000000;
  SKF_LALTLOCKED = $00100000;
  SKF_LCTLLOCKED = $00040000;
  SKF_LSHIFTLOCKED = $00010000;
  SKF_RALTLOCKED = $00200000;
  SKF_RCTLLOCKED = $00080000;
  SKF_RSHIFTLOCKED = $00020000;
  SKF_LWINLOCKED = $00400000;
  SKF_RWINLOCKED = $00800000;

type
  tagMOUSEKEYS = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    iMaxSpeed: DWORD;
    iTimeToMaxSpeed: DWORD;
    iCtrlSpeed: DWORD;
    dwReserved1: DWORD;
    dwReserved2: DWORD;
  end;
  TMouseKeys = tagMOUSEKEYS;
  MOUSEKEYS = tagMOUSEKEYS;

const
  { TMouseKeys dwFlags field }
  MKF_MOUSEKEYSON = 1;
  MKF_AVAILABLE = 2;
  MKF_HOTKEYACTIVE = 4;
  MKF_CONFIRMHOTKEY = 8;
  MKF_HOTKEYSOUND = $10;
  MKF_INDICATOR = $20;
  MKF_MODIFIERS = $40;
  MKF_REPLACENUMBERS = $80;
  MKF_LEFTBUTTONSEL = $10000000;
  MKF_RIGHTBUTTONSEL = $20000000;
  MKF_LEFTBUTTONDOWN = $01000000;
  MKF_RIGHTBUTTONDOWN = $02000000;
  MKF_MOUSEMODE = $80000000;

type
  tagACCESSTIMEOUT = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    iTimeOutMSec: DWORD;
  end;
  TAccessTimeout = tagACCESSTIMEOUT;
  ACCESSTIMEOUT = tagACCESSTIMEOUT;

const
  { TAccessTimeout dwFlags field }
  ATF_TIMEOUTON = 1;
  ATF_ONOFFFEEDBACK = 2;

  { values for TSoundsEntry iFSGrafEffect field }
  SSGF_NONE = 0;
  SSGF_DISPLAY = 3;

  { values for TSoundsEntry iFSTextEffect field }
  SSTF_NONE = 0;
  SSTF_CHARS = 1;
  SSTF_BORDER = 2;
  SSTF_DISPLAY = 3;

  { values for TSoundsEntry iWindowsEffect field }
  SSWF_NONE = 0;
  SSWF_TITLE = 1;
  SSWF_WINDOW = 2;
  SSWF_DISPLAY = 3;
  SSWF_CUSTOM = 4;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagSOUNDSENTRY = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    iFSTextEffect: DWORD;
    iFSTextEffectMSec: DWORD;
    iFSTextEffectColorBits: DWORD;
    iFSGrafEffect: DWORD;
    iFSGrafEffectMSec: DWORD;
    iFSGrafEffectColor: DWORD;
    iWindowsEffect: DWORD;
    iWindowsEffectMSec: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszWindowsEffectDLL: string;
    iWindowsEffectOrdinal: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagSOUNDSENTRYA = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    iFSTextEffect: DWORD;
    iFSTextEffectMSec: DWORD;
    iFSTextEffectColorBits: DWORD;
    iFSGrafEffect: DWORD;
    iFSGrafEffectMSec: DWORD;
    iFSGrafEffectColor: DWORD;
    iWindowsEffect: DWORD;
    iWindowsEffectMSec: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszWindowsEffectDLL: string;
    iWindowsEffectOrdinal: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagSOUNDSENTRYW = packed record
    cbSize: UINT;
    dwFlags: DWORD;
    iFSTextEffect: DWORD;
    iFSTextEffectMSec: DWORD;
    iFSTextEffectColorBits: DWORD;
    iFSGrafEffect: DWORD;
    iFSGrafEffectMSec: DWORD;
    iFSGrafEffectColor: DWORD;
    iWindowsEffect: DWORD;
    iWindowsEffectMSec: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszWindowsEffectDLL: string;
    iWindowsEffectOrdinal: DWORD;
  end;
  TSoundsEntry = tagSOUNDSENTRY;
  TSoundsEntryA = tagSOUNDSENTRYA;
  TSoundsEntryW = tagSOUNDSENTRYW;
  SOUNDSENTRY = tagSOUNDSENTRY;
  SOUNDSENTRYA = tagSOUNDSENTRYA;
  SOUNDSENTRYW = tagSOUNDSENTRYW;

const
  { SOUNDSENTRY dwFlags field }
  SSF_SOUNDSENTRYON = 1;
  SSF_AVAILABLE = 2;
  SSF_INDICATOR = 4;


type
  tagTOGGLEKEYS = packed record
    cbSize: UINT;
    dwFlags: DWORD;
  end;
  TToggleKeys = tagTOGGLEKEYS;
  TOGGLEKEYS = tagTOGGLEKEYS;

const
  { TToggleKeys dwFlags field }
  TKF_TOGGLEKEYSON = 1;
  TKF_AVAILABLE = 2;
  TKF_HOTKEYACTIVE = 4;
  TKF_CONFIRMHOTKEY = 8;
  TKF_HOTKEYSOUND = $10;
  TKF_INDICATOR = $20;

procedure SetDebugErrorLevel(dwLevel: DWORD);

const
  { SetLastErrorEx() types. }
  SLE_ERROR = 1;
  SLE_MINORERROR = 2;
  SLE_WARNING = 3;

procedure SetLastErrorEx(dwErrCode, dwType: DWORD);


{ WinEvents - Active Accessibility hooks }
procedure NotifyWinEvent(event: DWORD; hwnd: HWND; idObject, idChild: Longint);

type
    TFNWinEventProc = procedure (hWinEventHook: THandle; event: DWORD;
    hwnd: HWND; idObject, idChild: Longint; idEventThread, dwmsEventTime: DWORD);

const
  CHILDID_SELF = 0;
  INDEXID_OBJECT = 0;
  INDEXID_CONTAINER = 0;

  { Reserved IDs for system objects}
  OBJID_WINDOW = $00000000;
  OBJID_SYSMENU = $FFFFFFFF;
  OBJID_TITLEBAR = $FFFFFFFE;
  OBJID_MENU = $FFFFFFFD;
  OBJID_CLIENT = $FFFFFFFC;
  OBJID_VSCROLL = $FFFFFFFB;
  OBJID_HSCROLL = $FFFFFFFA;
  OBJID_SIZEGRIP = $FFFFFFF9;
  OBJID_CARET = $FFFFFFF8;
  OBJID_CURSOR = $FFFFFFF7;
  OBJID_ALERT = $FFFFFFF6;
  OBJID_SOUND = $FFFFFFF5;

  { EVENT DEFINITION }
  EVENT_MIN = $00000001;
  EVENT_MAX = $7FFFFFFF;

  EVENT_SYSTEM_SOUND = $0001;
  EVENT_SYSTEM_ALERT = $0002;
  EVENT_SYSTEM_FOREGROUND = $0003;
  EVENT_SYSTEM_MENUSTART = $0004;
  EVENT_SYSTEM_MENUEND = $0005;
  EVENT_SYSTEM_MENUPOPUPSTART  = $0006;
  EVENT_SYSTEM_MENUPOPUPEND    = $0007;
  EVENT_SYSTEM_CAPTURESTART    = $0008;
  EVENT_SYSTEM_CAPTUREEND      = $0009;
  EVENT_SYSTEM_MOVESIZESTART   = $000A;
  EVENT_SYSTEM_MOVESIZEEND     = $000B;
  EVENT_SYSTEM_CONTEXTHELPSTART= $000C;
  EVENT_SYSTEM_CONTEXTHELPEND  = $000D;
  EVENT_SYSTEM_DRAGDROPSTART   = $000E;
  EVENT_SYSTEM_DRAGDROPEND     = $000F;
  EVENT_SYSTEM_DIALOGSTART     = $0010;
  EVENT_SYSTEM_DIALOGEND       = $0011;
  EVENT_SYSTEM_SCROLLINGSTART  = $0012;
  EVENT_SYSTEM_SCROLLINGEND    = $0013;
  EVENT_SYSTEM_SWITCHSTART     = $0014;
  EVENT_SYSTEM_SWITCHEND       = $0015;
  EVENT_SYSTEM_MINIMIZESTART   = $0016;
  EVENT_SYSTEM_MINIMIZEEND     = $0017;
  EVENT_OBJECT_CREATE              = $8000;  { hwnd + ID + idChild is created item }
  EVENT_OBJECT_DESTROY             = $8001;  { hwnd + ID + idChild is destroyed item }
  EVENT_OBJECT_SHOW                = $8002;  { hwnd + ID + idChild is shown item }
  EVENT_OBJECT_HIDE                = $8003;  { hwnd + ID + idChild is hidden item }
  EVENT_OBJECT_REORDER             = $8004;  { hwnd + ID + idChild is parent of zordering children }
  EVENT_OBJECT_FOCUS               = $8005;  { hwnd + ID + idChild is focused item }
  EVENT_OBJECT_SELECTION           = $8006;  { hwnd + ID + idChild is selected item (if only one), or idChild is OBJID_WINDOW if complex }
  EVENT_OBJECT_SELECTIONADD        = $8007;  { hwnd + ID + idChild is item added }
  EVENT_OBJECT_SELECTIONREMOVE     = $8008;  { hwnd + ID + idChild is item removed }
  EVENT_OBJECT_SELECTIONWITHIN     = $8009;  { hwnd + ID + idChild is parent of changed selected items }
  EVENT_OBJECT_STATECHANGE         = $800A;  { hwnd + ID + idChild is item w/ state change }
  EVENT_OBJECT_LOCATIONCHANGE      = $800B;  { hwnd + ID + idChild is moved/sized item }
  EVENT_OBJECT_NAMECHANGE          = $800C;  { hwnd + ID + idChild is item w/ name change }
  EVENT_OBJECT_DESCRIPTIONCHANGE   = $800D;  { hwnd + ID + idChild is item w/ desc change }
  EVENT_OBJECT_VALUECHANGE         = $800E;  { hwnd + ID + idChild is item w/ value change }
  EVENT_OBJECT_PARENTCHANGE        = $800F;  { hwnd + ID + idChild is item w/ new parent }
  EVENT_OBJECT_HELPCHANGE          = $8010;  { hwnd + ID + idChild is item w/ help change }
  EVENT_OBJECT_DEFACTIONCHANGE     = $8011;  { hwnd + ID + idChild is item w/ def action change }
  EVENT_OBJECT_ACCELERATORCHANGE   = $8012;  { hwnd + ID + idChild is item w/ keybd accel change }
  SOUND_SYSTEM_STARTUP           = 1;
  SOUND_SYSTEM_SHUTDOWN          = 2;
  SOUND_SYSTEM_BEEP              = 3;
  SOUND_SYSTEM_ERROR             = 4;
  SOUND_SYSTEM_QUESTION          = 5;
  SOUND_SYSTEM_WARNING           = 6;
  SOUND_SYSTEM_INFORMATION       = 7;
  SOUND_SYSTEM_MAXIMIZE          = 8;
  SOUND_SYSTEM_MINIMIZE          = 9;
  SOUND_SYSTEM_RESTOREUP         = 10;
  SOUND_SYSTEM_RESTOREDOWN       = 11;
  SOUND_SYSTEM_APPSTART          = 12;
  SOUND_SYSTEM_FAULT             = 13;
  SOUND_SYSTEM_APPEND            = 14;
  SOUND_SYSTEM_MENUCOMMAND       = 15;
  SOUND_SYSTEM_MENUPOPUP         = 16;
  CSOUND_SYSTEM                  = 16;
  ALERT_SYSTEM_INFORMATIONAL     = 1;       { MB_INFORMATION }
  ALERT_SYSTEM_WARNING           = 2;       { MB_WARNING }
  ALERT_SYSTEM_ERROR             = 3;       { MB_ERROR }
  ALERT_SYSTEM_QUERY             = 4;       { MB_QUESTION }
  ALERT_SYSTEM_CRITICAL          = 5;       { HardSysErrBox }
  CALERT_SYSTEM                  = 6;

function SetWinEventHook (eventMin, eventMax: DWORD; hmodWinEventProc: HMODULE;
  pfnWinEventProc: TFNWinEventProc; idProcess, idThread, dwFlags: DWORD): THandle;

function UnhookWinEvent(hWinEventHook: THandle): BOOL;

const
  { dwFlags for SetWinEventHook }
  WINEVENT_OUTOFCONTEXT  = $0000;  { Events are ASYNC }
  WINEVENT_SKIPOWNTHREAD = $0001;  { Don't call back for events on installer's thread }
  WINEVENT_SKIPOWNPROCESS = $0002;  { Don't call back for events on installer's process }
  WINEVENT_INCONTEXT = $0004;  { Events are SYNC, this causes your dll to be injected into every process }

type
  tagGUITHREADINFO = packed record
    cbSize: DWORD;
    flags: DWORD;
    hwndActive: HWND;
    hwndFocus: HWND;
    hwndCapture: HWND;
    hwndMenuOwner: HWND;
    hwndMoveSize: HWND;
    hwndCaret: HWND;
    rcCaret: TRect;
  end;
  TGUIThreadInfo = tagGUITHREADINFO;

const
  GUI_CARETBLINKING  = $00000001;
  GUI_INMOVESIZE     = $00000002;
  GUI_INMENUMODE     = $00000004;
  GUI_SYSTEMMENUMODE = $00000008;
  GUI_POPUPMENUMODE  = $00000010;

function GetGUIThreadInfo(idThread: DWORD; out pgui: TGUIThreadinfo): BOOL;

function GetWindowModuleFileName(hwnd: HWND; pszFileName: StringBuilder; cchFileNameMax: UINT): UINT;
function GetWindowModuleFileNameA(hwnd: HWND; pszFileName: StringBuilder; cchFileNameMax: UINT): UINT;
function GetWindowModuleFileNameW(hwnd: HWND; pszFileName: StringBuilder; cchFileNameMax: UINT): UINT;

const
  STATE_SYSTEM_UNAVAILABLE     = $00000001;  { Disabled }
  STATE_SYSTEM_SELECTED        = $00000002;
  STATE_SYSTEM_FOCUSED         = $00000004;
  STATE_SYSTEM_PRESSED         = $00000008;
  STATE_SYSTEM_CHECKED         = $00000010;
  STATE_SYSTEM_MIXED           = $00000020;  { 3-state checkbox or toolbar button }
  STATE_SYSTEM_READONLY        = $00000040;
  STATE_SYSTEM_HOTTRACKED      = $00000080;
  STATE_SYSTEM_DEFAULT         = $00000100;
  STATE_SYSTEM_EXPANDED        = $00000200;
  STATE_SYSTEM_COLLAPSED       = $00000400;
  STATE_SYSTEM_BUSY            = $00000800;
  STATE_SYSTEM_FLOATING        = $00001000;  { Children "owned" not "contained" by parent }
  STATE_SYSTEM_MARQUEED        = $00002000;
  STATE_SYSTEM_ANIMATED        = $00004000;
  STATE_SYSTEM_INVISIBLE       = $00008000;
  STATE_SYSTEM_OFFSCREEN       = $00010000;
  STATE_SYSTEM_SIZEABLE        = $00020000;
  STATE_SYSTEM_MOVEABLE        = $00040000;
  STATE_SYSTEM_SELFVOICING     = $00080000;
  STATE_SYSTEM_FOCUSABLE       = $00100000;
  STATE_SYSTEM_SELECTABLE      = $00200000;
  STATE_SYSTEM_LINKED          = $00400000;
  STATE_SYSTEM_TRAVERSED       = $00800000;
  STATE_SYSTEM_MULTISELECTABLE = $01000000;  { Supports multiple selection }
  STATE_SYSTEM_EXTSELECTABLE   = $02000000;  { Supports extended selection }
  STATE_SYSTEM_ALERT_LOW       = $04000000;  { This information is of low priority }
  STATE_SYSTEM_ALERT_MEDIUM    = $08000000;  { This information is of medium priority }
  STATE_SYSTEM_ALERT_HIGH      = $10000000;  { This information is of high priority }
  STATE_SYSTEM_VALID           = $1FFFFFFF;

  CCHILDREN_TITLEBAR           =   5;
  CCHILDREN_SCROLLBAR          =   5;

type
  { Information about the global cursor. }
  tagCURSORINFO = packed record
    cbSize: DWORD;
    flags: DWORD;
    hCursor: HCURSOR;
    ptScreenPos: TPoint;
  end;
  TCursorInfo = tagCURSORINFO;

const
  CURSOR_SHOWING = $00000001;

function GetCursorInfo(var pci: TCursorInfo): BOOL;

type
  { Window information snapshot }
  tagWINDOWINFO = packed record
    cbSize: DWORD;
    rcWindow: TRect;
    rcClient: TRect;
    dwStyle: DWORD;
    dwExStyle: DWORD;
    dwOtherStuff: DWORD;
    cxWindowBorders: UINT;
    cyWindowBorders: UINT;
    atomWindowType: TAtom;
    wCreatorVersion: WORD;
  end;
  TWindowInfo = tagWINDOWINFO;

const
  WS_ACTIVECAPTION = $0001;

function GetWindowInfo(hwnd: HWND; var pwi: TWindowInfo): BOOL;

type
  { Titlebar information. }
  tagTITLEBARINFO = packed record
    cbSize: DWORD;
    rcTitleBar: TRect;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=CCHILDREN_TITLEBAR)]
    rgstate: array [0..CCHILDREN_TITLEBAR] of DWORD;
  end;
  TTitleBarInfo = tagTITLEBARINFO;

function GetTitleBarInfo(hwnd: HWND; var pti: TTitleBarInfo): BOOL;

type
  { Menubar information }
  tagMENUBARINFO = packed record
    cbSize: DWORD;
    rcBar: TRect;        { rect of bar, popup, item }
    hMenu: HMENU;        { real menu handle of bar, popup }
    hwndMenu: HWND;      { hwnd of item submenu if one }
{    fBarFocused:1: BOOL;} { bar, popup has the focus }
{    fFocused:1: BOOL; }  { item has the focus }
    FocusedBits: BYTE;
  end;
  TMenuBarInfo = tagMENUBARINFO;

function GetMenuBarInfo(hend: HWND; idObject, idItem: Longint;
  var pmbi: TMenuBarInfo): BOOL;

type
  { Scrollbar information }
  tagSCROLLBARINFO = packed record
    cbSize: DWORD;
    rcScrollBar: TRect;
    dxyLineButton: Integer;
    xyThumbTop: Integer;
    xyThumbBottom: Integer;
    bogus: Integer;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=CCHILDREN_SCROLLBAR)]
    rgstate: array[0..CCHILDREN_SCROLLBAR] of DWORD;
  end;
  TScrollBarInfo = tagSCROLLBARINFO;

Function GetScrollBarInfo(hwnd: HWND; idObject: Longint;
  var psbi: TScrollBarInfo): BOOL;

type
  { Combobox information }
  tagCOMBOBOXINFO = packed record
    cbSize: DWORD;
    rcItem: TRect;
    rcButton: TRect;
    stateButton: DWORD;
    hwndCombo: HWND;
    hwndItem: HWND;
    hwndList: HWND;
  end;
  TComboBoxInfo = tagCOMBOBOXINFO;

Function GetComboBoxInfo(hwndCombo: HWND; var pcbi: TComboBoxInfo): BOOL;

const
  { The "real" ancestor window }
  GA_MIC       =   1;
  GA_PARENT    =   1;
  GA_ROOT      =   2;
  GA_ROOTOWNER =   3;
  GA_MAC       =   4;

function GetAncestor(hwnd: HWND; gaFlags: UINT): HWND;

function RealChildWindowFromPoint(hwndParent: HWND; ptParentClientCoords: TPoint): HWND;

function RealGetWindowClass(hwnd: HWND; pszType: StringBuilder; cchType: UINT): UINT;
function RealGetWindowClassA(hwnd: HWND; pszType: StringBuilder; cchType: UINT): UINT;
function RealGetWindowClassW(hwnd: HWND; pszType: StringBuilder; cchType: UINT): UINT;

type
  { Alt-Tab Switch window information. }
  tagALTTABINFO = packed record
    cbSize: DWORD;
    cItems: Integer;
    cColumns: Integer;
    cRows: Integer;
    iColFocus: Integer;
    iRowFocus: Integer;
    cxItem: Integer;
    cyItem: Integer;
    ptStart: TPoint;
  end;
  TAltTabInfo = tagALTTABINFO;

function GetAltTabInfo(hwnd: HWND; iItem: Integer; var pati: TAltTabInfo;
  pszItemText: StringBuilder; cchItemText: UINT): BOOL;
function GetAltTabInfoA(hwnd: HWND; iItem: Integer; var pati: TAltTabInfo;
  pszItemText: StringBuilder; cchItemText: UINT): BOOL;
function GetAltTabInfoW(hwnd: HWND; iItem: Integer; var pati: TAltTabInfo;
  pszItemText: StringBuilder; cchItemText: UINT): BOOL;

{ Listbox information. Returns the number of items per row. }
function GetListBoxInfo(hwnd: HWND): DWORD;
function LockWorkStation: BOOL;
function UserHandleGrantAccess(hUserHandle, hJob: THandle): BOOL;

{ Translated from WINNLS.H }

const

{ String Length Maximums. }

  MAX_LEADBYTES = 12; { 5 ranges, 2 bytes ea., 0 term. }
  MAX_DEFAULTCHAR = 2; { single or double byte }

{ MBCS and Unicode Translation Flags. }

  MB_PRECOMPOSED = 1; { use precomposed chars }
  MB_COMPOSITE = 2; { use composite chars }
  MB_USEGLYPHCHARS = 4; { use glyph chars, not ctrl chars }

  WC_DEFAULTCHECK = $100; { check for default char }
  WC_COMPOSITECHECK = $200; { convert composite to precomposed }
  WC_DISCARDNS = $10; { discard non-spacing chars }
  WC_SEPCHARS = $20; { generate separate chars }
  WC_DEFAULTCHAR = $40; { replace w default char }

{ Character Type Flags. }

  CT_CTYPE1 = 1; { ctype 1 information }
  CT_CTYPE2 = 2; { ctype 2 information }
  CT_CTYPE3 = 4; { ctype 3 information }

{ CType 1 Flag Bits. }

  C1_UPPER = 1; { upper case }
  C1_LOWER = 2; { lower case }
  C1_DIGIT = 4; { decimal digits }
  C1_SPACE = 8; { spacing characters }
  C1_PUNCT = $10; { punctuation characters }
  C1_CNTRL = $20; { control characters }
  C1_BLANK = $40; { blank characters }
  C1_XDIGIT = $80; { other digits }
  C1_ALPHA = $100; { any letter }

{ CType 2 Flag Bits. }

  C2_LEFTTORIGHT = 1; { left to right }
  C2_RIGHTTOLEFT = 2; { right to left }
  C2_EUROPENUMBER = 3; { European number, digit }
  C2_EUROPESEPARATOR = 4; { European numeric separator }
  C2_EUROPETERMINATOR = 5; { European numeric terminator }
  C2_ARABICNUMBER = 6; { Arabic number }
  C2_COMMONSEPARATOR = 7; { common numeric separator }
  C2_BLOCKSEPARATOR = 8; { block separator }
  C2_SEGMENTSEPARATOR = 9; { segment separator }
  C2_WHITESPACE = 10; { white space }
  C2_OTHERNEUTRAL = 11; { other neutrals }
  C2_NOTAPPLICABLE = 0; { no implicit directionality }

{ CType 3 Flag Bits. }

  C3_NONSPACING = 1; { nonspacing character }
  C3_DIACRITIC = 2; { diacritic mark }
  C3_VOWELMARK = 4; { vowel mark }
  C3_SYMBOL = 8; { symbols }
  C3_KATAKANA = $0010; { katakana character }
  C3_HIRAGANA = $0020; { hiragana character }
  C3_HALFWIDTH = $0040; { half width character }
  C3_FULLWIDTH = $0080; { full width character }
  C3_IDEOGRAPH = $0100; { ideographic character }
  C3_KASHIDA = $0200; { Arabic kashida character }
  C3_LEXICAL = $0400; { lexical character }
  C3_ALPHA = $8000; { any linguistic char (C1_ALPHA) }
  C3_NOTAPPLICABLE = 0; { ctype 3 is not applicable }

{ String Flags. }

  NORM_IGNORECASE = 1; { ignore case }
  NORM_IGNORENONSPACE = 2; { ignore nonspacing chars }
  NORM_IGNORESYMBOLS = 4; { ignore symbols }
  NORM_IGNOREKANATYPE = $10000;
  NORM_IGNOREWIDTH = $20000;

{ Locale Independent Mapping Flags. }

  MAP_FOLDCZONE = $10; { fold compatibility zone chars }
  MAP_PRECOMPOSED = $20; { convert to precomposed chars }
  MAP_COMPOSITE = $40; { convert to composite chars }
  MAP_FOLDDIGITS = $80; { all digits to ASCII 0-9 }

{ Locale Dependent Mapping Flags. }

  LCMAP_LOWERCASE = $00000100;              { lower case letters }
  LCMAP_UPPERCASE = $00000200;              { upper case letters }
  LCMAP_SORTKEY = $00000400;                { WC sort key (normalize) }
  LCMAP_BYTEREV = $00000800;                { byte reversal }

  LCMAP_HIRAGANA = $00100000;               { map katakana to hiragana }
  LCMAP_KATAKANA = $00200000;               { map hiragana to katakana }
  LCMAP_HALFWIDTH = $00400000;              { map double byte to single byte }
  LCMAP_FULLWIDTH = $00800000;              { map single byte to double byte }

  LCMAP_LINGUISTIC_CASING = $01000000;      { use linguistic rules for casing }

  LCMAP_SIMPLIFIED_CHINESE      = $02000000;  { map traditional chinese to simplified chinese }
  LCMAP_TRADITIONAL_CHINESE     = $04000000;  { map simplified chinese to traditional chinese }

{ Locale Enumeration Flags. }

  LCID_INSTALLED          = $00000001;  { installed locale ids }
  LCID_SUPPORTED          = $00000002;  { supported locale ids }

{ Code Page Enumeration Flags. }

  CP_INSTALLED            = $00000001;  { installed code page ids }
  CP_SUPPORTED            = $00000002;  { supported code page ids }


{ Sorting Flags.

     WORD Sort:    culturally correct sort
                   hyphen and apostrophe are special cased
                   example: "coop" and "co-op" will sort together in a list

                         co_op     <-------  underscore (symbol)
                         coat
                         comb
                         coop
                         co-op     <-------  hyphen (punctuation)
                         cork
                         went
                         were
                         we're     <-------  apostrophe (punctuation)


     STRING Sort:  hyphen and apostrophe will sort with all other symbols

                         co-op     <-------  hyphen (punctuation)
                         co_op     <-------  underscore (symbol)
                         coat
                         comb
                         coop
                         cork
                         we're     <-------  apostrophe (punctuation)
                         went
                         were
 }

  SORT_STRINGSORT = $1000; { use string sort method }

{ Compare String Return Values }

  CSTR_LESS_THAN           = 1;             { string 1 less than string 2 }
  CSTR_EQUAL               = 2;             { string 1 equal to string 2 }
  CSTR_GREATER_THAN        = 3;             { string 1 greater than string 2 }

{ Code Page Default Values. }

  CP_ACP                   = 0;             { default to ANSI code page }
  CP_OEMCP                 = 1;             { default to OEM  code page }
  CP_MACCP                 = 2;             { default to MAC  code page }
  CP_THREAD_ACP            = 3;             { current thread's ANSI code page }
  CP_SYMBOL                = 42;            { SYMBOL translations }

  CP_UTF7                  = 65000;         { UTF-7 translation }
  CP_UTF8                  = 65001;         { UTF-8 translation }

{ Country Codes. }

  CTRY_DEFAULT = 0;
  CTRY_AUSTRALIA = 61; { Australia }
  CTRY_AUSTRIA = 43; { Austria }
  CTRY_BELGIUM = $20; { Belgium }
  CTRY_BRAZIL = 55; { Brazil }
  CTRY_CANADA = 2; { Canada }
  CTRY_DENMARK = 45; { Denmark }
  CTRY_FINLAND = 358; { Finland }
  CTRY_FRANCE = 33; { France }
  CTRY_GERMANY = 49; { Germany }
  CTRY_ICELAND = 354; { Iceland }
  CTRY_IRELAND = 353; { Ireland }
  CTRY_ITALY = 39; { Italy }
  CTRY_JAPAN = 81; { Japan }
  CTRY_MEXICO = 52; { Mexico }
  CTRY_NETHERLANDS = 31; { Netherlands }
  CTRY_NEW_ZEALAND = $40; { New Zealand }
  CTRY_NORWAY = 47; { Norway }
  CTRY_PORTUGAL = 351; { Portugal }
  CTRY_PRCHINA = 86; { PR China }
  CTRY_SOUTH_KOREA = 82; { South Korea }
  CTRY_SPAIN = 34; { Spain }
  CTRY_SWEDEN = 46; { Sweden }
  CTRY_SWITZERLAND = 41; { Switzerland }
  CTRY_TAIWAN = 886; { Taiwan }
  CTRY_UNITED_KINGDOM = 44; { United Kingdom }
  CTRY_UNITED_STATES = 1; { United States }

{ Locale Types.
  These types are used for the GetLocaleInfoW NLS API routine. }

{ LOCALE_NOUSEROVERRIDE is also used in GetTimeFormatW and GetDateFormatW. }

  LOCALE_NOUSEROVERRIDE           = DWORD($80000000);   { do not use user overrides }
  LOCALE_USE_CP_ACP               = $40000000;   { use the system ACP }

  LOCALE_ILANGUAGE                = $00000001;   { language id }
  LOCALE_SLANGUAGE                = $00000002;   { localized name of language }
  LOCALE_SENGLANGUAGE             = $00001001;   { English name of language }
  LOCALE_SABBREVLANGNAME          = $00000003;   { abbreviated language name }
  LOCALE_SNATIVELANGNAME          = $00000004;   { native name of language }

  LOCALE_ICOUNTRY                 = $00000005;   { country code }
  LOCALE_SCOUNTRY                 = $00000006;   { localized name of country }
  LOCALE_SENGCOUNTRY              = $00001002;   { English name of country }
  LOCALE_SABBREVCTRYNAME          = $00000007;   { abbreviated country name }
  LOCALE_SNATIVECTRYNAME          = $00000008;   { native name of country }

  LOCALE_IDEFAULTLANGUAGE         = $00000009;   { default language id }
  LOCALE_IDEFAULTCOUNTRY          = $0000000A;   { default country code }
  LOCALE_IDEFAULTCODEPAGE         = $0000000B;   { default oem code page }
  LOCALE_IDEFAULTANSICODEPAGE     = $00001004;   { default ansi code page }
  LOCALE_IDEFAULTMACCODEPAGE      = $00001011;   { default mac code page }

  LOCALE_SLIST                    = $0000000C;   { list item separator }
  LOCALE_IMEASURE                 = $0000000D;   { 0 = metric, 1 = US }

  LOCALE_SDECIMAL                 = $0000000E;   { decimal separator }
  LOCALE_STHOUSAND                = $0000000F;   { thousand separator }
  LOCALE_SGROUPING                = $00000010;   { digit grouping }
  LOCALE_IDIGITS                  = $00000011;   { number of fractional digits }
  LOCALE_ILZERO                   = $00000012;   { leading zeros for decimal }
  LOCALE_INEGNUMBER               = $00001010;   { negative number mode }
  LOCALE_SNATIVEDIGITS            = $00000013;   { native ascii 0-9 }

  LOCALE_SCURRENCY                = $00000014;   { local monetary symbol }
  LOCALE_SINTLSYMBOL              = $00000015;   { intl monetary symbol }
  LOCALE_SMONDECIMALSEP           = $00000016;   { monetary decimal separator }
  LOCALE_SMONTHOUSANDSEP          = $00000017;   { monetary thousand separator }
  LOCALE_SMONGROUPING             = $00000018;   { monetary grouping }
  LOCALE_ICURRDIGITS              = $00000019;   { # local monetary digits }
  LOCALE_IINTLCURRDIGITS          = $0000001A;   { # intl monetary digits }
  LOCALE_ICURRENCY                = $0000001B;   { positive currency mode }
  LOCALE_INEGCURR                 = $0000001C;   { negative currency mode }

  LOCALE_SDATE                    = $0000001D;   { date separator }
  LOCALE_STIME                    = $0000001E;   { time separator }
  LOCALE_SSHORTDATE               = $0000001F;   { short date format string }
  LOCALE_SLONGDATE                = $00000020;   { long date format string }
  LOCALE_STIMEFORMAT              = $00001003;   { time format string }
  LOCALE_IDATE                    = $00000021;   { short date format ordering }
  LOCALE_ILDATE                   = $00000022;   { long date format ordering }
  LOCALE_ITIME                    = $00000023;   { time format specifier }
  LOCALE_ITIMEMARKPOSN            = $00001005;   { time marker position }
  LOCALE_ICENTURY                 = $00000024;   { century format specifier (short date) }
  LOCALE_ITLZERO                  = $00000025;   { leading zeros in time field }
  LOCALE_IDAYLZERO                = $00000026;   { leading zeros in day field (short date) }
  LOCALE_IMONLZERO                = $00000027;   { leading zeros in month field (short date) }
  LOCALE_S1159                    = $00000028;   { AM designator }
  LOCALE_S2359                    = $00000029;   { PM designator }

  LOCALE_ICALENDARTYPE            = $00001009;   { type of calendar specifier }
  LOCALE_IOPTIONALCALENDAR        = $0000100B;   { additional calendar types specifier }
  LOCALE_IFIRSTDAYOFWEEK          = $0000100C;   { first day of week specifier }
  LOCALE_IFIRSTWEEKOFYEAR         = $0000100D;   { first week of year specifier }

  LOCALE_SDAYNAME1                = $0000002A;   { long name for Monday }
  LOCALE_SDAYNAME2                = $0000002B;   { long name for Tuesday }
  LOCALE_SDAYNAME3                = $0000002C;   { long name for Wednesday }
  LOCALE_SDAYNAME4                = $0000002D;   { long name for Thursday }
  LOCALE_SDAYNAME5                = $0000002E;   { long name for Friday }
  LOCALE_SDAYNAME6                = $0000002F;   { long name for Saturday }
  LOCALE_SDAYNAME7                = $00000030;   { long name for Sunday }
  LOCALE_SABBREVDAYNAME1          = $00000031;   { abbreviated name for Monday }
  LOCALE_SABBREVDAYNAME2          = $00000032;   { abbreviated name for Tuesday }
  LOCALE_SABBREVDAYNAME3          = $00000033;   { abbreviated name for Wednesday }
  LOCALE_SABBREVDAYNAME4          = $00000034;   { abbreviated name for Thursday }
  LOCALE_SABBREVDAYNAME5          = $00000035;   { abbreviated name for Friday }
  LOCALE_SABBREVDAYNAME6          = $00000036;   { abbreviated name for Saturday }
  LOCALE_SABBREVDAYNAME7          = $00000037;   { abbreviated name for Sunday }
  LOCALE_SMONTHNAME1              = $00000038;   { long name for January }
  LOCALE_SMONTHNAME2              = $00000039;   { long name for February }
  LOCALE_SMONTHNAME3              = $0000003A;   { long name for March }
  LOCALE_SMONTHNAME4              = $0000003B;   { long name for April }
  LOCALE_SMONTHNAME5              = $0000003C;   { long name for May }
  LOCALE_SMONTHNAME6              = $0000003D;   { long name for June }
  LOCALE_SMONTHNAME7              = $0000003E;   { long name for July }
  LOCALE_SMONTHNAME8              = $0000003F;   { long name for August }
  LOCALE_SMONTHNAME9              = $00000040;   { long name for September }
  LOCALE_SMONTHNAME10             = $00000041;   { long name for October }
  LOCALE_SMONTHNAME11             = $00000042;   { long name for November }
  LOCALE_SMONTHNAME12             = $00000043;   { long name for December }
  LOCALE_SMONTHNAME13             = $0000100E;   { long name for 13th month (if exists) }
  LOCALE_SABBREVMONTHNAME1        = $00000044;   { abbreviated name for January }
  LOCALE_SABBREVMONTHNAME2        = $00000045;   { abbreviated name for February }
  LOCALE_SABBREVMONTHNAME3        = $00000046;   { abbreviated name for March }
  LOCALE_SABBREVMONTHNAME4        = $00000047;   { abbreviated name for April }
  LOCALE_SABBREVMONTHNAME5        = $00000048;   { abbreviated name for May }
  LOCALE_SABBREVMONTHNAME6        = $00000049;   { abbreviated name for June }
  LOCALE_SABBREVMONTHNAME7        = $0000004A;   { abbreviated name for July }
  LOCALE_SABBREVMONTHNAME8        = $0000004B;   { abbreviated name for August }
  LOCALE_SABBREVMONTHNAME9        = $0000004C;   { abbreviated name for September }
  LOCALE_SABBREVMONTHNAME10       = $0000004D;   { abbreviated name for October }
  LOCALE_SABBREVMONTHNAME11       = $0000004E;   { abbreviated name for November }
  LOCALE_SABBREVMONTHNAME12       = $0000004F;   { abbreviated name for December }
  LOCALE_SABBREVMONTHNAME13       = $0000100F;   { abbreviated name for 13th month (if exists) }

  LOCALE_SPOSITIVESIGN            = $00000050;   { positive sign }
  LOCALE_SNEGATIVESIGN            = $00000051;   { negative sign }
  LOCALE_IPOSSIGNPOSN             = $00000052;   { positive sign position }
  LOCALE_INEGSIGNPOSN             = $00000053;   { negative sign position }
  LOCALE_IPOSSYMPRECEDES          = $00000054;   { mon sym precedes pos amt }
  LOCALE_IPOSSEPBYSPACE           = $00000055;   { mon sym sep by space from pos amt }
  LOCALE_INEGSYMPRECEDES          = $00000056;   { mon sym precedes neg amt }
  LOCALE_INEGSEPBYSPACE           = $00000057;   { mon sym sep by space from neg amt }

  LOCALE_FONTSIGNATURE            = $00000058;   { font signature }
  LOCALE_SISO639LANGNAME          = $00000059;   { ISO abbreviated language name }
  LOCALE_SISO3166CTRYNAME         = $0000005A;   { ISO abbreviated country name }

{ Time Flags for GetTimeFormatW. }

  TIME_NOMINUTESORSECONDS = 1; { do not use minutes or seconds }
  TIME_NOSECONDS = 2; { do not use seconds }
  TIME_NOTIMEMARKER = 4; { do not use time marker }
  TIME_FORCE24HOURFORMAT = 8; { always use 24 hour format }

{ Date Flags for GetDateFormatW. }

  DATE_SHORTDATE = 1; { use short date picture }
  DATE_LONGDATE = 2; { use long date picture }
  DATE_USE_ALT_CALENDAR = 4;   { use alternate calendar (if any) }

{ Calendar Types.
  These types are used for the GetALTCalendarInfoW NLS API routine. }

  CAL_ICALINTVALUE = 1;   { calendar type }
  CAL_SCALNAME = 2;   { native name of calendar }
  CAL_IYEAROFFSETRANGE = 3;   { starting years of eras }
  CAL_SERASTRING = 4;   { era name for IYearOffsetRanges }
  CAL_SSHORTDATE = 5;   { short date format string }
  CAL_SLONGDATE = 6;   { long date format string }
  CAL_SDAYNAME1 = 7;   { native name for Monday }
  CAL_SDAYNAME2 = 8;   { native name for Tuesday }
  CAL_SDAYNAME3 = 9;   { native name for Wednesday }
  CAL_SDAYNAME4 = 10;   { native name for Thursday }
  CAL_SDAYNAME5 = 11;   { native name for Friday }
  CAL_SDAYNAME6 = 12;   { native name for Saturday }
  CAL_SDAYNAME7 = 13;   { native name for Sunday }
  CAL_SABBREVDAYNAME1 = 14;   { abbreviated name for Monday }
  CAL_SABBREVDAYNAME2 = 15;   { abbreviated name for Tuesday }
  CAL_SABBREVDAYNAME3 = $10;   { abbreviated name for Wednesday }
  CAL_SABBREVDAYNAME4 = 17;   { abbreviated name for Thursday }
  CAL_SABBREVDAYNAME5 = 18;   { abbreviated name for Friday }
  CAL_SABBREVDAYNAME6 = 19;   { abbreviated name for Saturday }
  CAL_SABBREVDAYNAME7 = 20;   { abbreviated name for Sunday }
  CAL_SMONTHNAME1 = 21;   { native name for January }
  CAL_SMONTHNAME2 = 22;   { native name for February }
  CAL_SMONTHNAME3 = 23;   { native name for March }
  CAL_SMONTHNAME4 = 24;   { native name for April }
  CAL_SMONTHNAME5 = 25;   { native name for May }
  CAL_SMONTHNAME6 = 26;   { native name for June }
  CAL_SMONTHNAME7 = 27;   { native name for July }
  CAL_SMONTHNAME8 = 28;   { native name for August }
  CAL_SMONTHNAME9 = 29;   { native name for September }
  CAL_SMONTHNAME10 = 30;   { native name for October }
  CAL_SMONTHNAME11 = 31;   { native name for November }
  CAL_SMONTHNAME12 = $20;   { native name for December }
  CAL_SMONTHNAME13 = 33;   { native name for 13th month (if any) }
  CAL_SABBREVMONTHNAME1 = 34;   { abbreviated name for January }
  CAL_SABBREVMONTHNAME2 = 35;   { abbreviated name for February }
  CAL_SABBREVMONTHNAME3 = 36;   { abbreviated name for March }
  CAL_SABBREVMONTHNAME4 = 37;   { abbreviated name for April }
  CAL_SABBREVMONTHNAME5 = 38;   { abbreviated name for May }
  CAL_SABBREVMONTHNAME6 = 39;   { abbreviated name for June }
  CAL_SABBREVMONTHNAME7 = 40;   { abbreviated name for July }
  CAL_SABBREVMONTHNAME8 = 41;   { abbreviated name for August }
  CAL_SABBREVMONTHNAME9 = 42;   { abbreviated name for September }
  CAL_SABBREVMONTHNAME10 = 43;   { abbreviated name for October }
  CAL_SABBREVMONTHNAME11 = 44;   { abbreviated name for November }
  CAL_SABBREVMONTHNAME12 = 45;   { abbreviated name for December }
  CAL_SABBREVMONTHNAME13 = 46;   { abbreviated name for 13th month (if any) }

{ Calendar Enumeration Value. }

  ENUM_ALL_CALENDARS = DWORD($FFFFFFFF);   { enumerate all calendars }

{ Calendar ID Values. }

  CAL_GREGORIAN = 1;           { Gregorian (localized) calendar }
  CAL_GREGORIAN_US = 2;        { Gregorian (U.S.) calendar }
  CAL_JAPAN = 3;               { Japanese Emperor Era calendar }
  CAL_TAIWAN = 4;              { Republic of China Era calendar }
  CAL_KOREA = 5;               { Korean Tangun Era calendar }
  CAL_HIJRI = 6;               { Hijri (Arabic Lunar) calendar }
  CAL_THAI = 7;                { Thai calendar }
  CAL_HEBREW = 8;              { Hebrew calendar }


type
  LCTYPE = DWORD;   { Locale type constant. }
  CALTYPE = DWORD;  { Calendar type constant. }
  CALID = DWORD;    { Calendar ID. }

  [StructLayout(LayoutKind.Sequential)]
  _cpinfo = record
    MaxCharSize: UINT;                       { max length (bytes) of a char }
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=MAX_DEFAULTCHAR)]
    DefaultChar: array[0..MAX_DEFAULTCHAR - 1] of Byte; { default character }
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=MAX_LEADBYTES)]
    LeadByte: array[0..MAX_LEADBYTES - 1] of Byte;      { lead byte ranges }
  end;
  TCPInfo = _cpinfo;
  CPINFO = _cpinfo;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _numberfmt = packed record
    NumDigits: UINT;        { number of decimal digits }
    LeadingZero: UINT;      { if leading zero in decimal fields }
    Grouping: UINT;         { group size left of decimal }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDecimalSep: string;   { ptr to decimal separator string }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpThousandSep: string;  { ptr to thousand separator string }
    NegativeOrder: UINT;    { negative number ordering }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _numberfmtA = packed record
    NumDigits: UINT;        { number of decimal digits }
    LeadingZero: UINT;      { if leading zero in decimal fields }
    Grouping: UINT;         { group size left of decimal }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDecimalSep: string;   { ptr to decimal separator string }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpThousandSep: string;  { ptr to thousand separator string }
    NegativeOrder: UINT;    { negative number ordering }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _numberfmtW = packed record
    NumDigits: UINT;        { number of decimal digits }
    LeadingZero: UINT;      { if leading zero in decimal fields }
    Grouping: UINT;         { group size left of decimal }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDecimalSep: string;   { ptr to decimal separator string }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpThousandSep: string;  { ptr to thousand separator string }
    NegativeOrder: UINT;    { negative number ordering }
  end;
  TNumberFmt = _numberfmt;
  TNumberFmtA = _numberfmtA;
  TNumberFmtW = _numberfmtW;
  NUMBERFMT = _numberfmt;
  NUMBERFMTA = _numberfmtA;
  NUMBERFMTW = _numberfmtW;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _currencyfmt = packed record
    NumDigits: UINT;           { number of decimal digits }
    LeadingZero: UINT;         { if leading zero in decimal fields }
    Grouping: UINT;            { group size left of decimal }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDecimalSep: string;      { ptr to decimal separator string }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpThousandSep: string;     { ptr to thousand separator string }
    NegativeOrder: UINT;       { negative currency ordering }
    PositiveOrder: UINT;       { positive currency ordering }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpCurrencySymbol: string;  { ptr to currency symbol string }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _currencyfmtA = packed record
    NumDigits: UINT;           { number of decimal digits }
    LeadingZero: UINT;         { if leading zero in decimal fields }
    Grouping: UINT;            { group size left of decimal }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDecimalSep: string;      { ptr to decimal separator string }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpThousandSep: string;     { ptr to thousand separator string }
    NegativeOrder: UINT;       { negative currency ordering }
    PositiveOrder: UINT;       { positive currency ordering }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpCurrencySymbol: string;  { ptr to currency symbol string }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _currencyfmtW = packed record
    NumDigits: UINT;           { number of decimal digits }
    LeadingZero: UINT;         { if leading zero in decimal fields }
    Grouping: UINT;            { group size left of decimal }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDecimalSep: string;      { ptr to decimal separator string }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpThousandSep: string;     { ptr to thousand separator string }
    NegativeOrder: UINT;       { negative currency ordering }
    PositiveOrder: UINT;       { positive currency ordering }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpCurrencySymbol: string;  { ptr to currency symbol string }
  end;
  TCurrencyFmt = _currencyfmt;
  TCurrencyFmtA = _currencyfmtA;
  TCurrencyFmtW = _currencyfmtW;
  CURRENCYFMT = _currencyfmt;
  CURRENCYFMTA = _currencyfmtA;
  CURRENCYFMTW = _currencyfmtW;

{ Enumeration function constants. }

  TFNLocaleEnumProc = function (p1: IntPtr): Integer; 
  TFNCodepageEnumProc = function (p1: IntPtr): Integer;
  TFNDateFmtEnumProc = function (p1: IntPtr): Integer;
  TFNTimeFmtEnumProc = function (p1: IntPtr): Integer;
  TFNCalInfoEnumProc = function (p1: IntPtr): Integer;


{ Code Page Dependent APIs. }

function IsValidCodePage(CodePage: UINT): BOOL;
function GetACP: UINT;
function GetOEMCP: UINT;
function GetCPInfo(CodePage: UINT; out lpCPInfo: TCPInfo): BOOL;
function IsDBCSLeadByte(TestChar: Byte): BOOL;
function IsDBCSLeadByteEx(CodePage: UINT; TestChar: Byte): BOOL;
function MultiByteToWideChar(CodePage: UINT; dwFlags: DWORD;
  lpMultiByteStr: string; cchMultiByte: Integer;
  lpWideCharStr: StringBuilder; cchWideChar: Integer): Integer;
function WideCharToMultiByte(CodePage: UINT; dwFlags: DWORD;
  lpWideCharStr: string; cchWideChar: Integer; lpMultiByteStr: StringBuilder;
  cchMultiByte: Integer; lpDefaultChar: string;
  var lpUsedDefaultChar: BOOL): Integer; overload;
function WideCharToMultiByte(CodePage: UINT; dwFlags: DWORD;
  lpWideCharStr: string; cchWideChar: Integer; lpMultiByteStr: StringBuilder;
  cchMultiByte: Integer; lpDefaultChar: IntPtr;
  lpUsedDefaultChar: IntPtr): Integer; overload;

{ Locale Dependent APIs. }

function CompareString(Locale: LCID; dwCmpFlags: DWORD; lpString1: string;
  cchCount1: Integer; lpString2: string; cchCount2: Integer): Integer;
function CompareStringA(Locale: LCID; dwCmpFlags: DWORD; lpString1: string;
  cchCount1: Integer; lpString2: string; cchCount2: Integer): Integer;
function CompareStringW(Locale: LCID; dwCmpFlags: DWORD; lpString1: string;
  cchCount1: Integer; lpString2: string; cchCount2: Integer): Integer;
function LCMapString(Locale: LCID; dwMapFlags: DWORD; lpSrcStr: string;
  cchSrc: Integer; lpDestStr: StringBuilder; cchDest: Integer): Integer;
function LCMapStringA(Locale: LCID; dwMapFlags: DWORD; lpSrcStr: string;
  cchSrc: Integer; lpDestStr: StringBuilder; cchDest: Integer): Integer;
function LCMapStringW(Locale: LCID; dwMapFlags: DWORD; lpSrcStr: string;
  cchSrc: Integer; lpDestStr: StringBuilder; cchDest: Integer): Integer;
function GetLocaleInfo(Locale: LCID; LCType: LCTYPE; lpLCData: StringBuilder; cchData: Integer): Integer;
function GetLocaleInfoA(Locale: LCID; LCType: LCTYPE; lpLCData: StringBuilder; cchData: Integer): Integer;
function GetLocaleInfoW(Locale: LCID; LCType: LCTYPE; lpLCData: StringBuilder; cchData: Integer): Integer;
function SetLocaleInfo(Locale: LCID; LCType: LCTYPE; lpLCData: string): BOOL;
function SetLocaleInfoA(Locale: LCID; LCType: LCTYPE; lpLCData: string): BOOL;
function SetLocaleInfoW(Locale: LCID; LCType: LCTYPE; lpLCData: string): BOOL;

function GetTimeFormat(Locale: LCID; dwFlags: DWORD; const lpTime: TSystemTime;
  lpFormat: string; lpTimeStr: StringBuilder; cchTime: Integer): Integer; overload;
function GetTimeFormat(Locale: LCID; dwFlags: DWORD; lpTime: IntPtr;
  lpFormat: IntPtr; lpTimeStr: StringBuilder; cchTime: Integer): Integer; overload;
function GetTimeFormat(Locale: LCID; dwFlags: DWORD; lpTime: IntPtr;
  lpFormat: string; lpTimeStr: StringBuilder; cchTime: Integer): Integer; overload;
function GetTimeFormat(Locale: LCID; dwFlags: DWORD; const lpTime: TSystemTime;
  lpFormat: IntPtr; lpTimeStr: StringBuilder; cchTime: Integer): Integer; overload;
function GetTimeFormatA(Locale: LCID; dwFlags: DWORD; const lpTime: TSystemTime;
  lpFormat: string; lpTimeStr: StringBuilder; cchTime: Integer): Integer;
function GetTimeFormatW(Locale: LCID; dwFlags: DWORD; const lpTime: TSystemTime;
  lpFormat: string; lpTimeStr: StringBuilder; cchTime: Integer): Integer;

function GetDateFormat(Locale: LCID; dwFlags: DWORD; const lpDate: TSystemTime;
  lpFormat: string; lpDateStr: StringBuilder; cchDate: Integer): Integer; overload;
function GetDateFormat(Locale: LCID; dwFlags: DWORD; lpDate: IntPtr;
  lpFormat: IntPtr; lpDateStr: StringBuilder; cchDate: Integer): Integer; overload;
function GetDateFormat(Locale: LCID; dwFlags: DWORD; lpDate: IntPtr;
  lpFormat: string; lpDateStr: StringBuilder; cchDate: Integer): Integer; overload;
function GetDateFormat(Locale: LCID; dwFlags: DWORD; const lpDate: TSystemTime;
  lpFormat: IntPtr; lpDateStr: StringBuilder; cchDate: Integer): Integer; overload;
function GetDateFormatA(Locale: LCID; dwFlags: DWORD; const lpDate: TSystemTime;
  lpFormat: string; lpDateStr: StringBuilder; cchDate: Integer): Integer;
function GetDateFormatW(Locale: LCID; dwFlags: DWORD; const lpDate: TSystemTime;
  lpFormat: string; lpDateStr: StringBuilder; cchDate: Integer): Integer;

function GetNumberFormat(Locale: LCID; dwFlags: DWORD; lpValue: string;
  const lpFormat: TNumberFmt; lpNumberStr: StringBuilder; cchNumber: Integer): Integer; overload;
function GetNumberFormat(Locale: LCID; dwFlags: DWORD; lpValue: string;
  lpFormat: IntPtr; lpNumberStr: StringBuilder; cchNumber: Integer): Integer; overload;
function GetNumberFormatA(Locale: LCID; dwFlags: DWORD; lpValue: string;
  const lpFormat: TNumberFmtA; lpNumberStr: StringBuilder; cchNumber: Integer): Integer;
function GetNumberFormatW(Locale: LCID; dwFlags: DWORD; lpValue: string;
  const lpFormat: TNumberFmtW; lpNumberStr: StringBuilder; cchNumber: Integer): Integer;

function GetCurrencyFormat(Locale: LCID; dwFlags: DWORD; lpValue: string;
  const lpFormat: TCurrencyFmt; lpCurrencyStr: StringBuilder; cchCurrency: Integer): Integer; overload;
function GetCurrencyFormat(Locale: LCID; dwFlags: DWORD; lpValue: string;
  lpFormat: IntPtr; lpCurrencyStr: StringBuilder; cchCurrency: Integer): Integer; overload;
function GetCurrencyFormatA(Locale: LCID; dwFlags: DWORD; lpValue: string;
  const lpFormat: TCurrencyFmtA; lpCurrencyStr: StringBuilder; cchCurrency: Integer): Integer;
function GetCurrencyFormatW(Locale: LCID; dwFlags: DWORD; lpValue: string;
  const lpFormat: TCurrencyFmtW; lpCurrencyStr: StringBuilder; cchCurrency: Integer): Integer;

function EnumCalendarInfo(lpCalInfoEnumProc: TFNCalInfoEnumProc; Locale: LCID;
  Calendar: CALID; CalType: CALTYPE): BOOL;
function EnumCalendarInfoA(lpCalInfoEnumProc: TFNCalInfoEnumProc; Locale: LCID;
  Calendar: CALID; CalType: CALTYPE): BOOL;
function EnumCalendarInfoW(lpCalInfoEnumProc: TFNCalInfoEnumProc; Locale: LCID;
  Calendar: CALID; CalType: CALTYPE): BOOL;
function EnumTimeFormats(lpTimeFmtEnumProc: TFNTimeFmtEnumProc;
  Locale: LCID; dwFlags: DWORD): BOOL;
function EnumTimeFormatsA(lpTimeFmtEnumProc: TFNTimeFmtEnumProc;
  Locale: LCID; dwFlags: DWORD): BOOL;
function EnumTimeFormatsW(lpTimeFmtEnumProc: TFNTimeFmtEnumProc;
  Locale: LCID; dwFlags: DWORD): BOOL;
function EnumDateFormats(lpDateFmtEnumProc: TFNDateFmtEnumProc;
  Locale: LCID; dwFlags: DWORD): BOOL;
function EnumDateFormatsA(lpDateFmtEnumProc: TFNDateFmtEnumProc;
  Locale: LCID; dwFlags: DWORD): BOOL;
function EnumDateFormatsW(lpDateFmtEnumProc: TFNDateFmtEnumProc;
  Locale: LCID; dwFlags: DWORD): BOOL;
function IsValidLocale(Locale: LCID; dwFlags: DWORD): BOOL;
function ConvertDefaultLocale(Locale: LCID): LCID;
function GetThreadLocale: LCID;
function SetThreadLocale(Locale: LCID): BOOL;
function GetSystemDefaultLangID: LANGID;
function GetUserDefaultLangID: LANGID;
function GetSystemDefaultLCID: LCID;
function GetUserDefaultLCID: LCID;

{ Locale Independent APIs. }

function GetStringTypeEx(Locale: LCID; dwInfoType: DWORD;
  lpSrcStr: string; cchSrc: Integer; [out] lpCharType: TWordDynArray): BOOL;
function GetStringTypeExA(Locale: LCID; dwInfoType: DWORD;
  lpSrcStr: string; cchSrc: Integer; [out] lpCharType: TWordDynArray): BOOL;
function GetStringTypeExW(Locale: LCID; dwInfoType: DWORD;
  lpSrcStr: string; cchSrc: Integer; [out] lpCharType: TWordDynArray): BOOL;

{  NOTE: The parameters for GetStringTypeA and GetStringTypeW are
         NOT the same.  The W version was shipped in NT 3.1.  The
         A version was then shipped in 16-bit OLE with the wrong
         parameters (ported from Win95).  To be compatible, we
         must break the relationship between the A and W versions
         of GetStringType.  There will be NO function call for the
         generic GetStringType.

         GetStringTypeEx (above) should be used instead. }

function GetStringTypeA(Locale: LCID; dwInfoType: DWORD; lpSrcStr: string;
  cchSrc: Integer; [out] lpCharType: TWordDynArray): BOOL;
function GetStringTypeW(dwInfoType: DWORD; lpSrcStr: string;
  cchSrc: Integer; [out] lpCharType: TWordDynArray): BOOL;

function FoldString(dwMapFlags: DWORD; lpSrcStr: string; cchSrc: Integer;
  lpDestStr: StringBuilder; cchDest: Integer): Integer;
function FoldStringA(dwMapFlags: DWORD; lpSrcStr: string; cchSrc: Integer;
  lpDestStr: StringBuilder; cchDest: Integer): Integer;
function FoldStringW(dwMapFlags: DWORD; lpSrcStr: string; cchSrc: Integer;
  lpDestStr: StringBuilder; cchDest: Integer): Integer;
function EnumSystemLocales(lpLocaleEnumProc: TFNLocaleEnumProc; dwFlags: DWORD): BOOL;
function EnumSystemLocalesA(lpLocaleEnumProc: TFNLocaleEnumProc; dwFlags: DWORD): BOOL;
function EnumSystemLocalesW(lpLocaleEnumProc: TFNLocaleEnumProc; dwFlags: DWORD): BOOL;
function EnumSystemCodePages(lpCodePageEnumProc: TFNCodepageEnumProc; dwFlags: DWORD): BOOL;
function EnumSystemCodePagesA(lpCodePageEnumProc: TFNCodepageEnumProc; dwFlags: DWORD): BOOL;
function EnumSystemCodePagesW(lpCodePageEnumProc: TFNCodepageEnumProc; dwFlags: DWORD): BOOL;


{ Translated from WINCON.H }

{ This module contains the public data structures, data types,
    and procedures exported by the NT console subsystem. }

type
  _COORD = packed record
    X: SHORT;
    Y: SHORT;
  end;
  TCoord = _COORD;
  COORD = _COORD;

  _SMALL_RECT = packed record
    Left: SHORT;
    Top: SHORT;
    Right: SHORT;
    Bottom: SHORT;
  end;
  TSmallRect = _SMALL_RECT;
  SMALL_RECT = _SMALL_RECT;

  _KEY_EVENT_RECORD = packed record
    bKeyDown: BOOL;
    wRepeatCount: Word;
    wVirtualKeyCode: Word;
    wVirtualScanCode: Word;
    case Integer of
      0: (
        UnicodeChar: WideChar;
        dwControlKeyState: DWORD;
        );
      1: (
        AsciiChar: AnsiChar);
  end;
  TKeyEventRecord = _KEY_EVENT_RECORD;
  KEY_EVENT_RECORD = _KEY_EVENT_RECORD;

const
{ ControlKeyState flags }

  RIGHT_ALT_PRESSED = 1;     { the right alt key is pressed. }
  LEFT_ALT_PRESSED = 2;     { the left alt key is pressed. }
  RIGHT_CTRL_PRESSED = 4;     { the right ctrl key is pressed. }
  LEFT_CTRL_PRESSED = 8;     { the left ctrl key is pressed. }
  SHIFT_PRESSED = $10;     { the shift key is pressed. }
  NUMLOCK_ON = $20;     { the numlock light is on. }
  SCROLLLOCK_ON = $40;     { the scrolllock light is on. }
  CAPSLOCK_ON = $80;     { the capslock light is on. }
  ENHANCED_KEY = $100;     { the key is enhanced. }

type
  _MOUSE_EVENT_RECORD = packed record
    dwMousePosition: TCoord;
    dwButtonState: DWORD;
    dwControlKeyState: DWORD;
    dwEventFlags: DWORD;
  end;
  TMouseEventRecord = _MOUSE_EVENT_RECORD;
  MOUSE_EVENT_RECORD = _MOUSE_EVENT_RECORD;

const
{ ButtonState flags }

  FROM_LEFT_1ST_BUTTON_PRESSED = 1;
  RIGHTMOST_BUTTON_PRESSED = 2;
  FROM_LEFT_2ND_BUTTON_PRESSED = 4;
  FROM_LEFT_3RD_BUTTON_PRESSED = 8;
  FROM_LEFT_4TH_BUTTON_PRESSED = $10;

{ EventFlags }

  MOUSE_MOVED = 1;
  DOUBLE_CLICK = 2;

type
  _WINDOW_BUFFER_SIZE_RECORD = packed record
    dwSize: TCoord;
  end;
  TWindowBufferSizeRecord = _WINDOW_BUFFER_SIZE_RECORD;
  WINDOW_BUFFER_SIZE_RECORD = _WINDOW_BUFFER_SIZE_RECORD;

  _MENU_EVENT_RECORD = packed record
    dwCommandId: UINT;
  end;
  TMenuEventRecord = _MENU_EVENT_RECORD;
  MENU_EVENT_RECORD = _MENU_EVENT_RECORD;

  _FOCUS_EVENT_RECORD = packed record
    bSetFocus: BOOL;
  end;
  TFocusEventRecord = _FOCUS_EVENT_RECORD;
  FOCUS_EVENT_RECORD = _FOCUS_EVENT_RECORD;

  [StructLayout(LayoutKind.Sequential)]
  _INPUT_RECORD = record
    EventType: Word;
    Reserved: Word;
    Event: Record case Integer of
      0: (KeyEvent: TKeyEventRecord);
      1: (MouseEvent: TMouseEventRecord);
      2: (WindowBufferSizeEvent: TWindowBufferSizeRecord);
      3: (MenuEvent: TMenuEventRecord);
      4: (FocusEvent: TFocusEventRecord);
    end;
  end;
  TInputRecord = _INPUT_RECORD;
  INPUT_RECORD = _INPUT_RECORD;


const
{  EventType flags: }

  KEY_EVENT = 1;       { Event contains key event record}
  _MOUSE_EVENT = 2;  { Renamed }   { Event contains mouse event record }
  WINDOW_BUFFER_SIZE_EVENT = 4;  { Event contains window change event record }
  MENU_EVENT = 8;     { Event contains menu event record }
  FOCUS_EVENT = $10;  { event contains focus change }

type
  _CHAR_INFO = record
    case Integer of
      0: (
        UnicodeChar: WCHAR;
        Attributes: Word);
      1: (
        AsciiChar: CHAR);
  end;
  TCharInfo = _CHAR_INFO;
  CHAR_INFO = _CHAR_INFO;

const
{ Attributes flags:}

  FOREGROUND_BLUE = 1;    { text color contains blue.}
  FOREGROUND_GREEN = 2;     { text color contains green. }
  FOREGROUND_RED = 4;     { text color contains red. }
  FOREGROUND_INTENSITY = 8;     { text color is intensified. }
  BACKGROUND_BLUE = $10;     { background color contains blue. }
  BACKGROUND_GREEN = $20;     { background color contains green. }
  BACKGROUND_RED = $40;     { background color contains red. }
  BACKGROUND_INTENSITY = $80;     { background color is intensified. }

type
  _CONSOLE_SCREEN_BUFFER_INFO = packed record
    dwSize: TCoord;
    dwCursorPosition: TCoord;
    wAttributes: Word;
    srWindow: TSmallRect;
    dwMaximumWindowSize: TCoord;
  end;
  TConsoleScreenBufferInfo = _CONSOLE_SCREEN_BUFFER_INFO;
  CONSOLE_SCREEN_BUFFER_INFO = _CONSOLE_SCREEN_BUFFER_INFO;

  _CONSOLE_CURSOR_INFO = packed record
    dwSize: DWORD;
    bVisible: BOOL;
  end;
  TConsoleCursorInfo = _CONSOLE_CURSOR_INFO;
  CONSOLE_CURSOR_INFO = _CONSOLE_CURSOR_INFO;

  TFNHandlerRoutine = function (CtrlType: DWORD): BOOL;

const
  CTRL_C_EVENT = 0;
  CTRL_BREAK_EVENT = 1;
  CTRL_CLOSE_EVENT = 2;
  { 3 is reserved! }
  { 4 is reserved! }

  CTRL_LOGOFF_EVENT = 5;
  CTRL_SHUTDOWN_EVENT = 6;
  ENABLE_PROCESSED_INPUT = 1;     {  Input Mode flags: }
  ENABLE_LINE_INPUT = 2;
  ENABLE_ECHO_INPUT = 4;
  ENABLE_WINDOW_INPUT = 8;
  ENABLE_MOUSE_INPUT = $10;
  ENABLE_PROCESSED_OUTPUT = 1;     { Output Mode flags: }
  ENABLE_WRAP_AT_EOL_OUTPUT = 2;

{ direct API definitions. }

function PeekConsoleInput(hConsoleInput: THandle; out lpBuffer: TInputRecord;
  nLength: DWORD; out lpNumberOfEventsRead: DWORD): BOOL;
function PeekConsoleInputA(hConsoleInput: THandle; out lpBuffer: TInputRecord;
  nLength: DWORD; out lpNumberOfEventsRead: DWORD): BOOL;
function PeekConsoleInputW(hConsoleInput: THandle; out lpBuffer: TInputRecord;
  nLength: DWORD; out lpNumberOfEventsRead: DWORD): BOOL;

function ReadConsoleInput(hConsoleInput: THandle; out lpBuffer: TInputRecord;
  nLength: DWORD; out lpNumberOfEventsRead: DWORD): BOOL;
function ReadConsoleInputA(hConsoleInput: THandle; out lpBuffer: TInputRecord;
  nLength: DWORD; out lpNumberOfEventsRead: DWORD): BOOL;
function ReadConsoleInputW(hConsoleInput: THandle; out lpBuffer: TInputRecord;
  nLength: DWORD; out lpNumberOfEventsRead: DWORD): BOOL;

function WriteConsoleInput(hConsoleInput: THandle; const lpBuffer: TInputRecord;
  nLength: DWORD; out lpNumberOfEventsWritten: DWORD): BOOL;
function WriteConsoleInputA(hConsoleInput: THandle; const lpBuffer: TInputRecord;
  nLength: DWORD; out lpNumberOfEventsWritten: DWORD): BOOL;
function WriteConsoleInputW(hConsoleInput: THandle; const lpBuffer: TInputRecord;
  nLength: DWORD; out lpNumberOfEventsWritten: DWORD): BOOL;

function ReadConsoleOutput(hConsoleOutput: THandle; lpBuffer: IntPtr;
  dwBufferSize, dwBufferCoord: TCoord; var lpReadRegion: TSmallRect): BOOL;
function ReadConsoleOutputA(hConsoleOutput: THandle; lpBuffer: IntPtr;
  dwBufferSize, dwBufferCoord: TCoord; var lpReadRegion: TSmallRect): BOOL;
function ReadConsoleOutputW(hConsoleOutput: THandle; lpBuffer: IntPtr;
  dwBufferSize, dwBufferCoord: TCoord; var lpReadRegion: TSmallRect): BOOL;

function WriteConsoleOutput(hConsoleOutput: THandle; lpBuffer: IntPtr;
  dwBufferSize, dwBufferCoord: TCoord; var lpWriteRegion: TSmallRect): BOOL;
function WriteConsoleOutputA(hConsoleOutput: THandle; lpBuffer: IntPtr;
  dwBufferSize, dwBufferCoord: TCoord; var lpWriteRegion: TSmallRect): BOOL;
function WriteConsoleOutputW(hConsoleOutput: THandle; lpBuffer: IntPtr;
  dwBufferSize, dwBufferCoord: TCoord; var lpWriteRegion: TSmallRect): BOOL;

function ReadConsoleOutputCharacter(hConsoleOutput: THandle; lpCharacter: StringBuilder;
  nLength: DWORD; dwReadCoord: TCoord; out lpNumberOfCharsRead: DWORD): BOOL;
function ReadConsoleOutputCharacterA(hConsoleOutput: THandle; lpCharacter: StringBuilder;
  nLength: DWORD; dwReadCoord: TCoord; out lpNumberOfCharsRead: DWORD): BOOL;
function ReadConsoleOutputCharacterW(hConsoleOutput: THandle; lpCharacter: StringBuilder;
  nLength: DWORD; dwReadCoord: TCoord; out lpNumberOfCharsRead: DWORD): BOOL;

function ReadConsoleOutputAttribute(hConsoleOutput: THandle; [out] lpAttribute: TWordDynArray;
  nLength: DWORD; dwReadCoord: TCoord; out lpNumberOfAttrsRead: DWORD): BOOL;

function WriteConsoleOutputCharacter(hConsoleOutput: THandle; lpCharacter: string;
  nLength: DWORD; dwWriteCoord: TCoord; out lpNumberOfCharsWritten: DWORD): BOOL;
function WriteConsoleOutputCharacterA(hConsoleOutput: THandle; lpCharacter: string;
  nLength: DWORD; dwWriteCoord: TCoord; out lpNumberOfCharsWritten: DWORD): BOOL;
function WriteConsoleOutputCharacterW(hConsoleOutput: THandle; lpCharacter: string;
  nLength: DWORD; dwWriteCoord: TCoord; out lpNumberOfCharsWritten: DWORD): BOOL;

function WriteConsoleOutputAttribute(hConsoleOutput: THandle; [in] lpAttribute: TWordDynArray;
  nLength: DWORD; dwWriteCoord: TCoord; out lpNumberOfAttrsWritten: DWORD): BOOL;

function FillConsoleOutputCharacter(hConsoleOutput: THandle; cCharacter: Char;
  nLength: DWORD; dwWriteCoord: TCoord; out lpNumberOfCharsWritten: DWORD): BOOL;
function FillConsoleOutputCharacterA(hConsoleOutput: THandle; cCharacter: AnsiChar;
  nLength: DWORD; dwWriteCoord: TCoord; out lpNumberOfCharsWritten: DWORD): BOOL;
function FillConsoleOutputCharacterW(hConsoleOutput: THandle; cCharacter: WideChar;
  nLength: DWORD; dwWriteCoord: TCoord; out lpNumberOfCharsWritten: DWORD): BOOL;

function FillConsoleOutputAttribute(hConsoleOutput: THandle; wAttribute: Word;
  nLength: DWORD; dwWriteCoord: TCoord; out lpNumberOfAttrsWritten: DWORD): BOOL;
function GetConsoleMode(hConsoleHandle: THandle; out lpMode: DWORD): BOOL;
function GetNumberOfConsoleInputEvents(hConsoleInput: THandle;
  out lpNumberOfEvents: DWORD): BOOL;
function GetConsoleScreenBufferInfo(hConsoleOutput: THandle;
  out lpConsoleScreenBufferInfo: TConsoleScreenBufferInfo): BOOL;
function GetLargestConsoleWindowSize(hConsoleOutput: THandle): TCoord;
function GetConsoleCursorInfo(hConsoleOutput: THandle;
  out lpConsoleCursorInfo: TConsoleCursorInfo): BOOL;
function GetNumberOfConsoleMouseButtons([in] var lpNumberOfMouseButtons: DWORD): BOOL;
function SetConsoleMode(hConsoleHandle: THandle; dwMode: DWORD): BOOL;
function SetConsoleActiveScreenBuffer(hConsoleOutput: THandle): BOOL;
function FlushConsoleInputBuffer(hConsoleInput: THandle): BOOL;
function SetConsoleScreenBufferSize(hConsoleOutput: THandle; dwSize: TCoord): BOOL;
function SetConsoleCursorPosition(hConsoleOutput: THandle; dwCursorPosition: TCoord): BOOL;
function SetConsoleCursorInfo(hConsoleOutput: THandle;
  const lpConsoleCursorInfo: TConsoleCursorInfo): BOOL;

function ScrollConsoleScreenBuffer(hConsoleOutput: THandle;
  const lpScrollRectangle: TSmallRect; const lpClipRectangle: TSmallRect;
  dwDestinationOrigin: TCoord; const lpFill: TCharInfo): BOOL; overload;
function ScrollConsoleScreenBuffer(hConsoleOutput: THandle;
  const lpScrollRectangle: TSmallRect; lpClipRectangle: IntPtr;
  dwDestinationOrigin: TCoord; const lpFill: TCharInfo): BOOL; overload;
function ScrollConsoleScreenBufferA(hConsoleOutput: THandle;
  const lpScrollRectangle, lpClipRectangle: TSmallRect;
  dwDestinationOrigin: TCoord; const lpFill: TCharInfo): BOOL;
function ScrollConsoleScreenBufferW(hConsoleOutput: THandle;
  const lpScrollRectangle, lpClipRectangle: TSmallRect;
  dwDestinationOrigin: TCoord; const lpFill: TCharInfo): BOOL;

function SetConsoleWindowInfo(hConsoleOutput: THandle; bAbsolute: BOOL;
  const lpConsoleWindow: TSmallRect): BOOL;
function SetConsoleTextAttribute(hConsoleOutput: THandle; wAttributes: Word): BOOL;
function SetConsoleCtrlHandler(HandlerRoutine: TFNHandlerRoutine; Add: BOOL): BOOL;
function GenerateConsoleCtrlEvent(dwCtrlEvent: DWORD; dwProcessGroupId: DWORD): BOOL;
function AllocConsole: BOOL;
function FreeConsole: BOOL;

function GetConsoleTitle(lpConsoleTitle: string; nSize: DWORD): DWORD;
function GetConsoleTitleA(lpConsoleTitle: string; nSize: DWORD): DWORD;
function GetConsoleTitleW(lpConsoleTitle: string; nSize: DWORD): DWORD;

function SetConsoleTitle(lpConsoleTitle: string): BOOL;
function SetConsoleTitleA(lpConsoleTitle: string): BOOL;
function SetConsoleTitleW(lpConsoleTitle: string): BOOL;

function ReadConsole(hConsoleInput: THandle; [out] lpBuffer: TBytes;
  nNumberOfCharsToRead: DWORD; out lpNumberOfCharsRead: DWORD; lpReserved: IntPtr): BOOL;
function ReadConsoleA(hConsoleInput: THandle; [out] lpBuffer: TBytes;
  nNumberOfCharsToRead: DWORD; out lpNumberOfCharsRead: DWORD; lpReserved: IntPtr): BOOL;
function ReadConsoleW(hConsoleInput: THandle; [out] lpBuffer: TBytes;
  nNumberOfCharsToRead: DWORD; out lpNumberOfCharsRead: DWORD; lpReserved: IntPtr): BOOL;

function WriteConsole(hConsoleOutput: THandle; [in] lpBuffer: TBytes;
  nNumberOfCharsToWrite: DWORD; out lpNumberOfCharsWritten: DWORD; lpReserved: IntPtr): BOOL;
function WriteConsoleA(hConsoleOutput: THandle; [in] lpBuffer: TBytes;
  nNumberOfCharsToWrite: DWORD; out lpNumberOfCharsWritten: DWORD; lpReserved: IntPtr): BOOL;
function WriteConsoleW(hConsoleOutput: THandle; [in] lpBuffer: TBytes;
  nNumberOfCharsToWrite: DWORD; out lpNumberOfCharsWritten: DWORD; lpReserved: IntPtr): BOOL;

const
  CONSOLE_TEXTMODE_BUFFER = 1;

function CreateConsoleScreenBuffer(dwDesiredAccess, dwShareMode: DWORD;
  const lpSecurityAttributes: TSecurityAttributes; dwFlags: DWORD;
  lpScreenBufferData: IntPtr): THandle; overload;
function CreateConsoleScreenBuffer(dwDesiredAccess, dwShareMode: DWORD;
  lpSecurityAttributes: IntPtr; dwFlags: DWORD;
  lpScreenBufferData: IntPtr): THandle; overload;

function GetConsoleCP: UINT;
function SetConsoleCP(wCodePageID: UINT): BOOL;
function GetConsoleOutputCP: UINT;
function SetConsoleOutputCP(wCodePageID: UINT): BOOL;


{ Translated from WINVER.H }

{ Version management functions, types, and definitions
  Include file for VER.DLL.  This library is designed to allow version
  stamping of Windows executable files and of special .VER files for
  DOS executable files. }

const
{ Symbols }

  VS_FILE_INFO = RT_VERSION;
  VS_VERSION_INFO = 1;
  VS_USER_DEFINED = 100;

{ VS_VERSION.dwFileFlags }

  VS_FFI_SIGNATURE = DWORD($FEEF04BD);
  VS_FFI_STRUCVERSION = $10000;
  VS_FFI_FILEFLAGSMASK = 63;

{ VS_VERSION.dwFileFlags }

  VS_FF_DEBUG = 1;
  VS_FF_PRERELEASE = 2;
  VS_FF_PATCHED = 4;
  VS_FF_PRIVATEBUILD = 8;
  VS_FF_INFOINFERRED = $10;
  VS_FF_SPECIALBUILD = $20;

{ VS_VERSION.dwFileOS }

  VOS_UNKNOWN = 0;
  VOS_DOS = $10000;
  VOS_OS216 = $20000;
  VOS_OS232 = $30000;
  VOS_NT = $40000;

  VOS__BASE = 0;
  VOS__WINDOWS16 = 1;
  VOS__PM16 = 2;
  VOS__PM32 = 3;
  VOS__WINDOWS32 = 4;

  VOS_DOS_WINDOWS16 = $10001;
  VOS_DOS_WINDOWS32 = $10004;
  VOS_OS216_PM16 = $20002;
  VOS_OS232_PM32 = $30003;
  VOS_NT_WINDOWS32 = $40004;

{ VS_VERSION.dwFileType }

  VFT_UNKNOWN = 0;
  VFT_APP = 1;
  VFT_DLL = 2;
  VFT_DRV = 3;
  VFT_FONT = 4;
  VFT_VXD = 5;
  VFT_STATIC_LIB = 7;

{ VS_VERSION.dwFileSubtype for VFT_WINDOWS_DRV }

  VFT2_UNKNOWN = 0;
  VFT2_DRV_PRINTER = 1;
  VFT2_DRV_KEYBOARD = 2;
  VFT2_DRV_LANGUAGE = 3;
  VFT2_DRV_DISPLAY = 4;
  VFT2_DRV_MOUSE = 5;
  VFT2_DRV_NETWORK = 6;
  VFT2_DRV_SYSTEM = 7;
  VFT2_DRV_INSTALLABLE = 8;
  VFT2_DRV_SOUND = 9;
  VFT2_DRV_COMM = 10;

{ VS_VERSION.dwFileSubtype for VFT_WINDOWS_FONT }

  VFT2_FONT_RASTER = 1;
  VFT2_FONT_VECTOR = 2;
  VFT2_FONT_TRUETYPE = 3;

{ VerFindFile() flags }

  VFFF_ISSHAREDFILE = 1;

  VFF_CURNEDEST = 1;
  VFF_FILEINUSE = 2;
  VFF_BUFFTOOSMALL = 4;

{ VerInstallFile() flags }

  VIFF_FORCEINSTALL = 1;
  VIFF_DONTDELETEOLD = 2;

  VIF_TEMPFILE = 1;
  VIF_MISMATCH = 2;
  VIF_SRCOLD = 4;

  VIF_DIFFLANG = 8;
  VIF_DIFFCODEPG = $10;
  VIF_DIFFTYPE = $20;

  VIF_WRITEPROT = $40;
  VIF_FILEINUSE = $80;
  VIF_OUTOFSPACE = $100;
  VIF_ACCESSVIOLATION = $200;
  VIF_SHARINGVIOLATION = $400;
  VIF_CANNOTCREATE = $800;
  VIF_CANNOTDELETE = $1000;
  VIF_CANNOTRENAME = $2000;
  VIF_CANNOTDELETECUR = $4000;
  VIF_OUTOFMEMORY = $8000;

  VIF_CANNOTREADSRC = $10000;
  VIF_CANNOTREADDST = $20000;

  VIF_BUFFTOOSMALL = $40000;

type
  tagVS_FIXEDFILEINFO = packed record
    dwSignature: DWORD;        { e.g. $feef04bd }
    dwStrucVersion: DWORD;     { e.g. $00000042 = "0.42" }
    dwFileVersionMS: DWORD;    { e.g. $00030075 = "3.75" }
    dwFileVersionLS: DWORD;    { e.g. $00000031 = "0.31" }
    dwProductVersionMS: DWORD; { e.g. $00030010 = "3.10" }
    dwProductVersionLS: DWORD; { e.g. $00000031 = "0.31" }
    dwFileFlagsMask: DWORD;    { = $3F for version "0.42" }
    dwFileFlags: DWORD;        { e.g. VFF_DEBUG | VFF_PRERELEASE }
    dwFileOS: DWORD;           { e.g. VOS_DOS_WINDOWS16 }
    dwFileType: DWORD;         { e.g. VFT_DRIVER }
    dwFileSubtype: DWORD;      { e.g. VFT2_DRV_KEYBOARD }
    dwFileDateMS: DWORD;       { e.g. 0 }
    dwFileDateLS: DWORD;       { e.g. 0 }
  end;
  TVSFixedFileInfo = tagVS_FIXEDFILEINFO;
  VS_FIXEDFILEINFO = tagVS_FIXEDFILEINFO;

function VerFindFile(uFlags: DWORD; szFileName, szWinDir, szAppDir: string;
  szCurDir: StringBuilder; var lpuCurDirLen: UINT; szDestDir: StringBuilder;
  var lpuDestDirLen: UINT): DWORD;
function VerFindFileA(uFlags: DWORD; szFileName, szWinDir, szAppDir: string;
  szCurDir: StringBuilder; var lpuCurDirLen: UINT; szDestDir: StringBuilder;
  var lpuDestDirLen: UINT): DWORD;
function VerFindFileW(uFlags: DWORD; szFileName, szWinDir, szAppDir: string;
  szCurDir: StringBuilder; var lpuCurDirLen: UINT; szDestDir: StringBuilder;
  var lpuDestDirLen: UINT): DWORD;

function VerInstallFile(uFlags: DWORD;
  szSrcFileName, szDestFileName, szSrcDir, szDestDir, szCurDir: string;
  szTmpFile: StringBuilder; var lpuTmpFileLen: UINT): DWORD;
function VerInstallFileA(uFlags: DWORD;
  szSrcFileName, szDestFileName, szSrcDir, szDestDir, szCurDir: string;
  szTmpFile: StringBuilder; var lpuTmpFileLen: UINT): DWORD;
function VerInstallFileW(uFlags: DWORD;
  szSrcFileName, szDestFileName, szSrcDir, szDestDir, szCurDir: string;
  szTmpFile: StringBuilder; var lpuTmpFileLen: UINT): DWORD;

function GetFileVersionInfoSize(lptstrFilename: string; out lpdwHandle: DWORD): DWORD;
function GetFileVersionInfoSizeA(lptstrFilename: string; out lpdwHandle: DWORD): DWORD;
function GetFileVersionInfoSizeW(lptstrFilename: string; out lpdwHandle: DWORD): DWORD;

function GetFileVersionInfo(lptstrFilename: string; dwHandle, dwLen: DWORD; [out] lpData: TBytes): BOOL;
function GetFileVersionInfoA(lptstrFilename: string; dwHandle, dwLen: DWORD; [out] lpData: TBytes): BOOL;
function GetFileVersionInfoW(lptstrFilename: string; dwHandle, dwLen: DWORD; [out] lpData: TBytes): BOOL;

function VerLanguageName(wLang: DWORD; szLang: StringBuilder; nSize: DWORD): DWORD;
function VerLanguageNameA(wLang: DWORD; szLang: StringBuilder; nSize: DWORD): DWORD;
function VerLanguageNameW(wLang: DWORD; szLang: StringBuilder; nSize: DWORD): DWORD;

function VerQueryValue([in] pBlock: TBytes; lpSubBlock: string;
  out lplpBuffer: IntPtr; out puLen: UINT): BOOL;
function VerQueryValueA([in] pBlock: TBytes; lpSubBlock: string;
  out lplpBuffer: IntPtr; out puLen: UINT): BOOL;
function VerQueryValueW([in] pBlock: TBytes; lpSubBlock: string;
  out lplpBuffer: IntPtr; out puLen: UINT): BOOL;


{ Translated from WINREG.H }

{ This module contains the function prototypes and constant, type and
   structure definitions for the Windows 32-Bit Registry API. }

type
  REGSAM = ACCESS_MASK;  { Requested Key access mask type. }

  HKEY = type LongWord;

const
{ Reserved Key Handles. }

  HKEY_CLASSES_ROOT     = DWORD($80000000);
  HKEY_CURRENT_USER     = DWORD($80000001);
  HKEY_LOCAL_MACHINE    = DWORD($80000002);
  HKEY_USERS            = DWORD($80000003);
  HKEY_PERFORMANCE_DATA = DWORD($80000004);
  HKEY_CURRENT_CONFIG   = DWORD($80000005);
  HKEY_DYN_DATA         = DWORD($80000006);


  PROVIDER_KEEPS_VALUE_LENGTH = 1;

type
  val_context = packed record
    valuelen: Integer;                  { the total length of this value }
    value_context: IntPtr; { Pointer }  { provider's context }
    val_buff_ptr: IntPtr;  { Pointer }  { where in the ouput buffer the value is }
  end;
  TValContext = val_context;


type
{ Provider supplied value/context.}
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  pvalue = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    pv_valuename: string;           { The value name pointer }
    pv_valuelen: BOOL;
    pv_value_context: IntPtr; { Pointer }
    pv_type: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  pvalueA = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    pv_valuename: string;           { The value name pointer }
    pv_valuelen: BOOL;
    pv_value_context: IntPtr; { Pointer }
    pv_type: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  pvalueW = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    pv_valuename: string;           { The value name pointer }
    pv_valuelen: BOOL;
    pv_value_context: IntPtr; { Pointer }
    pv_type: DWORD;
  end;
  TPValue = pvalue;
  TPValueA = pvalueA;
  TPValueW = pvalueW;

  TFNQueryHandler = function (keycontext: IntPtr; [in] var val_list: TValContext;
    num_vals: DWORD; outputbuffer: IntPtr; var total_outlen: DWORD;
    input_blen: DWORD): DWORD;

  provider_info = packed record
    pi_R0_1val: IntPtr;     { PFNQueryHandler }
    pi_R0_allvals: IntPtr;  { PFNQueryHandler }
    pi_R3_1val: IntPtr;     { PFNQueryHandler }
    pi_R3_allvals: IntPtr;  { PFNQueryHandler }
    pi_flags: DWORD;        { capability flags (none defined yet). }
    pi_key_context: IntPtr; { Pointer }
  end;
  TProviderInfo = provider_info;
  REG_PROVIDER = provider_info;
  TRegProvider = TProviderInfo;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  value_ent = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    ve_valuename: string;
    ve_valuelen: DWORD;
    ve_valueptr: DWORD;
    ve_type: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  value_entA = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    ve_valuename: string;
    ve_valuelen: DWORD;
    ve_valueptr: DWORD;
    ve_type: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  value_entW = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    ve_valuename: string;
    ve_valuelen: DWORD;
    ve_valueptr: DWORD;
    ve_type: DWORD;
  end;
  TValueEnt = value_ent;
  TValueEntA = value_entA;
  TValueEntW = value_entW;
  VALENT = value_ent;
  VALENTA = value_entA;
  VALENTW = value_entW;
  TValEnt = TValueEnt;


{ Default values for parameters that do not exist in the Win 3.1
  compatible APIs. }

function RegCloseKey(hKey: HKEY): Longint;
function RegConnectRegistry(lpMachineName: string; hKey: HKEY; out phkResult: HKEY): Longint;
function RegConnectRegistryA(lpMachineName: string; hKey: HKEY; out phkResult: HKEY): Longint;
function RegConnectRegistryW(lpMachineName: string; hKey: HKEY; out phkResult: HKEY): Longint;
function RegCreateKey(hKey: HKEY; lpSubKey: string; out phkResult: HKEY): Longint;
function RegCreateKeyA(hKey: HKEY; lpSubKey: string; out phkResult: HKEY): Longint;
function RegCreateKeyW(hKey: HKEY; lpSubKey: string; out phkResult: HKEY): Longint;

function RegCreateKeyEx(hKey: HKEY; lpSubKey: string;
  Reserved: DWORD; lpClass: string; dwOptions: DWORD; samDesired: REGSAM;
  const lpSecurityAttributes: TSecurityAttributes; out phkResult: HKEY;
  out lpdwDisposition: DWORD): Longint; overload;
function RegCreateKeyEx(hKey: HKEY; lpSubKey: string;
  Reserved: DWORD; lpClass: string; dwOptions: DWORD; samDesired: REGSAM;
  lpSecurityAttributes: IntPtr; out phkResult: HKEY;
  out lpdwDisposition: DWORD): Longint; overload;
function RegCreateKeyEx(hKey: HKEY; lpSubKey: string;
  Reserved: DWORD; lpClass: IntPtr; dwOptions: DWORD; samDesired: REGSAM;
  const lpSecurityAttributes: TSecurityAttributes; out phkResult: HKEY;
  out lpdwDisposition: DWORD): Longint; overload;
function RegCreateKeyEx(hKey: HKEY; lpSubKey: string;
  Reserved: DWORD; lpClass: IntPtr; dwOptions: DWORD; samDesired: REGSAM;
  lpSecurityAttributes: IntPtr; out phkResult: HKEY;
  out lpdwDisposition: DWORD): Longint; overload;
function RegCreateKeyExA(hKey: HKEY; lpSubKey: string;
  Reserved: DWORD; lpClass: string; dwOptions: DWORD; samDesired: REGSAM;
  const lpSecurityAttributes: TSecurityAttributes; out phkResult: HKEY;
  out lpdwDisposition: DWORD): Longint;
function RegCreateKeyExW(hKey: HKEY; lpSubKey: string;
  Reserved: DWORD; lpClass: string; dwOptions: DWORD; samDesired: REGSAM;
  const lpSecurityAttributes: TSecurityAttributes; out phkResult: HKEY;
  out lpdwDisposition: DWORD): Longint;

function RegDeleteKey(hKey: HKEY; lpSubKey: string): Longint;
function RegDeleteKeyA(hKey: HKEY; lpSubKey: string): Longint;
function RegDeleteKeyW(hKey: HKEY; lpSubKey: string): Longint;
function RegDeleteValue(hKey: HKEY; lpValueName: string): Longint;
function RegDeleteValueA(hKey: HKEY; lpValueName: string): Longint;
function RegDeleteValueW(hKey: HKEY; lpValueName: string): Longint;
function RegEnumKey(hKey: HKEY; dwIndex: DWORD; lpName: StringBuilder; cbName: DWORD): Longint;
function RegEnumKeyA(hKey: HKEY; dwIndex: DWORD; lpName: StringBuilder; cbName: DWORD): Longint;
function RegEnumKeyW(hKey: HKEY; dwIndex: DWORD;lpName: StringBuilder; cbName: DWORD): Longint;

function RegEnumKeyEx(hKey: HKEY; dwIndex: DWORD; lpName: StringBuilder;
  var lpcbName: DWORD; lpReserved: IntPtr; lpClass: StringBuilder;
  var lpcbClass: DWORD; out lpftLastWriteTime: TFileTime): Longint; overload;
function RegEnumKeyEx(hKey: HKEY; dwIndex: DWORD; lpName: StringBuilder;
  var lpcbName: DWORD; lpReserved: IntPtr; lpClass: StringBuilder;
  lpcbClass: IntPtr; lpftLastWriteTime: IntPtr): Longint; overload;
function RegEnumKeyEx(hKey: HKEY; dwIndex: DWORD; lpName: StringBuilder;
  var lpcbName: DWORD; lpReserved: IntPtr; lpClass: StringBuilder;
  lpcbClass: IntPtr; out lpftLastWriteTime: TFileTime): Longint; overload;
function RegEnumKeyEx(hKey: HKEY; dwIndex: DWORD; lpName: StringBuilder;
  var lpcbName: DWORD; lpReserved: IntPtr; lpClass: StringBuilder;
  var lpcbClass: DWORD; lpftLastWriteTime: IntPtr): Longint; overload;
function RegEnumKeyExA(hKey: HKEY; dwIndex: DWORD; lpName: StringBuilder;
  var lpcbName: DWORD; lpReserved: IntPtr; lpClass: StringBuilder;
  var lpcbClass: DWORD; out lpftLastWriteTime: TFileTime): Longint;
function RegEnumKeyExW(hKey: HKEY; dwIndex: DWORD; lpName: StringBuilder;
  var lpcbName: DWORD; lpReserved: IntPtr; lpClass: StringBuilder;
  var lpcbClass: DWORD; out lpftLastWriteTime: TFileTime): Longint;

function RegEnumValue(hKey: HKEY; dwIndex: DWORD; lpValueName: StringBuilder;
  var lpcbValueName: DWORD; lpReserved: IntPtr; out lpType: DWORD;
  [out] lpData: array of Byte; var lpcbData: DWORD): Longint; overload;
function RegEnumValue(hKey: HKEY; dwIndex: DWORD; lpValueName: StringBuilder;
  var lpcbValueName: DWORD; lpReserved: IntPtr; lpType: IntPtr;
  lpData, lpcbData: IntPtr): Longint; overload;
function RegEnumValue(hKey: HKEY; dwIndex: DWORD; lpValueName: StringBuilder;
  var lpcbValueName: DWORD; lpReserved: IntPtr; lpType: IntPtr;
  [out] lpData: array of Byte; var lpcbData: DWORD): Longint; overload;
function RegEnumValue(hKey: HKEY; dwIndex: DWORD; lpValueName: StringBuilder;
  var lpcbValueName: DWORD; lpReserved: IntPtr; out lpType: DWORD;
  lpData, lpcbData: IntPtr): Longint; overload;
function RegEnumValueA(hKey: HKEY; dwIndex: DWORD; lpValueName: StringBuilder;
  var lpcbValueName: DWORD; lpReserved: IntPtr; out lpType: DWORD;
  [out] lpData: TBytes; var lpcbData: DWORD): Longint;
function RegEnumValueW(hKey: HKEY; dwIndex: DWORD; lpValueName: StringBuilder;
  var lpcbValueName: DWORD; lpReserved: IntPtr; out lpType: DWORD;
  [out] lpData: TBytes; var lpcbData: DWORD): Longint;

function RegFlushKey(hKey: HKEY): Longint;
function RegGetKeySecurity(hKey: HKEY; SecurityInformation: SECURITY_INFORMATION;
  out pSecurityDescriptor: TSecurityDescriptor; var lpcbSecurityDescriptor: DWORD): Longint;
function RegLoadKey(hKey: HKEY; lpSubKey, lpFile: string): Longint;
function RegLoadKeyA(hKey: HKEY; lpSubKey, lpFile: string): Longint;
function RegLoadKeyW(hKey: HKEY; lpSubKey, lpFile: string): Longint;
function RegNotifyChangeKeyValue(hKey: HKEY; bWatchSubtree: BOOL;
  dwNotifyFilter: DWORD; hEvent: THandle; fAsynchronus: BOOL): Longint;
function RegOpenKey(hKey: HKEY; lpSubKey: string; out phkResult: HKEY): Longint;
function RegOpenKeyA(hKey: HKEY; lpSubKey: string; out phkResult: HKEY): Longint;
function RegOpenKeyW(hKey: HKEY; lpSubKey: string; out phkResult: HKEY): Longint;

function RegOpenKeyEx(hKey: HKEY; lpSubKey: string;
  ulOptions: DWORD; samDesired: REGSAM; out phkResult: HKEY): Longint; overload;
function RegOpenKeyEx(hKey: HKEY; lpSubKey: IntPtr;
  ulOptions: DWORD; samDesired: REGSAM; out phkResult: HKEY): Longint; overload;
function RegOpenKeyExA(hKey: HKEY; lpSubKey: string;
  ulOptions: DWORD; samDesired: REGSAM; out phkResult: HKEY): Longint;
function RegOpenKeyExW(hKey: HKEY; lpSubKey: string;
  ulOptions: DWORD; samDesired: REGSAM; out phkResult: HKEY): Longint;

function RegQueryInfoKey(hKey: HKEY; lpClass: StringBuilder;
  var lpcbClass: DWORD; lpReserved: IntPtr;
  out lpcSubKeys, lpcbMaxSubKeyLen: DWORD; lpcbMaxClassLen: IntPtr; out lpcValues,
  lpcbMaxValueNameLen, lpcbMaxValueLen, lpcbSecurityDescriptor: DWORD;
  out lpftLastWriteTime: TFileTime): Longint; overload;
function RegQueryInfoKey(hKey: HKEY; lpClass, lpcbClass, lpReserved: IntPtr;
  var lpcSubKeys, lpcbMaxSubKeyLen: DWORD; lpcbMaxClassLen: IntPtr; out lpcValues,
  lpcbMaxValueNameLen, lpcbMaxValueLen: DWORD; lpcbSecurityDescriptor: IntPtr;
  out lpftLastWriteTime: TFileTime): Longint; overload;
function RegQueryInfoKeyA(hKey: HKEY; lpClass: StringBuilder;
  var lpcbClass: DWORD; lpReserved: IntPtr;
  out lpcSubKeys, lpcbMaxSubKeyLen, lpcbMaxClassLen, lpcValues,
  lpcbMaxValueNameLen, lpcbMaxValueLen, lpcbSecurityDescriptor: DWORD;
  out lpftLastWriteTime: TFileTime): Longint;
function RegQueryInfoKeyW(hKey: HKEY; lpClass: StringBuilder;
  var lpcbClass: DWORD; lpReserved: IntPtr;
  out lpcSubKeys, lpcbMaxSubKeyLen, lpcbMaxClassLen, lpcValues,
  lpcbMaxValueNameLen, lpcbMaxValueLen, lpcbSecurityDescriptor: DWORD;
  out lpftLastWriteTime: TFileTime): Longint;

function RegQueryValue(hKey: HKEY; lpSubKey: string; lpValue: StringBuilder;
  var lpcbValue: Longint): Longint;
function RegQueryValueA(hKey: HKEY; lpSubKey: string; lpValue: StringBuilder;
  var lpcbValue: Longint): Longint;
function RegQueryValueW(hKey: HKEY; lpSubKey: string; lpValue: StringBuilder;
  var lpcbValue: Longint): Longint;

function RegQueryMultipleValues(hKey: HKEY; [out] ValList: array of TValueEnt;
  NumVals: DWORD; lpValueBuf: IntPtr; var ldwTotsize: DWORD): Longint; 
function RegQueryMultipleValuesA(hKey: HKEY; [out] ValList: array of TValueEntA;
  NumVals: DWORD; lpValueBuf: IntPtr; var ldwTotsize: DWORD): Longint;
function RegQueryMultipleValuesW(hKey: HKEY; [out] ValList: array of TValueEntW;
  NumVals: DWORD; lpValueBuf: IntPtr; var ldwTotsize: DWORD): Longint;

function RegQueryValueEx(hKey: HKEY; lpValueName: string;
  lpReserved: IntPtr; out lpType: DWORD; [in, out] lpData: array of Byte;
  var lpcbData: DWORD): Longint; overload;
function RegQueryValueEx(hKey: HKEY; lpValueName: string;
  lpReserved: IntPtr; out lpType: DWORD; lpData: IntPtr;
  var lpcbData: DWORD): Longint; overload;
function RegQueryValueEx(hKey: HKEY; lpValueName: string;
  lpReserved: IntPtr; lpType: IntPtr; lpData: IntPtr;
  var lpcbData: DWORD): Longint; overload;
function RegQueryValueEx(hKey: HKEY; lpValueName: string;
  lpReserved: IntPtr; lpType: IntPtr; [in, out] lpData: StringBuilder;
  var lpcbData: Longint): Longint; overload;
function RegQueryValueExA(hKey: HKEY; lpValueName: string;
  lpReserved: IntPtr; out lpType: DWORD; [in, out] lpData: TBytes;
  var lpcbData: DWORD): Longint;
function RegQueryValueExW(hKey: HKEY; lpValueName: string;
  lpReserved: IntPtr; out lpType: DWORD; [in, out] lpData: TBytes;
  var lpcbData: DWORD): Longint;

function RegReplaceKey(hKey: HKEY; lpSubKey: string;
   lpNewFile: string; lpOldFile: string): Longint;
function RegReplaceKeyA(hKey: HKEY; lpSubKey: string;
   lpNewFile: string; lpOldFile: string): Longint;
function RegReplaceKeyW(hKey: HKEY; lpSubKey: string;
   lpNewFile: string; lpOldFile: string): Longint;
function RegRestoreKey(hKey: HKEY; lpFile: string; dwFlags: DWORD): Longint;
function RegRestoreKeyA(hKey: HKEY; lpFile: string; dwFlags: DWORD): Longint;
function RegRestoreKeyW(hKey: HKEY; lpFile: string; dwFlags: DWORD): Longint;
function RegSaveKey(hKey: HKEY; lpFile: string;
  const lpSecurityAttributes: TSecurityAttributes): Longint; overload;
function RegSaveKey(hKey: HKEY; lpFile: string;
  lpSecurityAttributes: IntPtr): Longint; overload;
function RegSaveKeyA(hKey: HKEY; lpFile: string;
  const lpSecurityAttributes: TSecurityAttributes): Longint;
function RegSaveKeyW(hKey: HKEY; lpFile: string;
  const lpSecurityAttributes: TSecurityAttributes): Longint;
function RegSetKeySecurity(hKey: HKEY; SecurityInformation: SECURITY_INFORMATION;
  pSecurityDescriptor: IntPtr): Longint;

function RegSetValue(hKey: HKEY; lpSubKey: string;
  dwType: DWORD; lpData: string; cbData: DWORD): Longint;
function RegSetValueA(hKey: HKEY; lpSubKey: string;
  dwType: DWORD; lpData: string; cbData: DWORD): Longint;
function RegSetValueW(hKey: HKEY; lpSubKey: string;
  dwType: DWORD; lpData: string; cbData: DWORD): Longint;
function RegSetValueEx(hKey: HKEY; lpValueName: string;
  Reserved: DWORD; dwType: DWORD; [in] lpData: TBytes; cbData: DWORD): Longint;
function RegSetValueExA(hKey: HKEY; lpValueName: string;
  Reserved: DWORD; dwType: DWORD; [in] lpData: TBytes; cbData: DWORD): Longint;
function RegSetValueExW(hKey: HKEY; lpValueName: string;
  Reserved: DWORD; dwType: DWORD; [in] lpData: TBytes; cbData: DWORD): Longint;
function RegUnLoadKey(hKey: HKEY; lpSubKey: string): Longint;
function RegUnLoadKeyA(hKey: HKEY; lpSubKey: string): Longint;
function RegUnLoadKeyW(hKey: HKEY; lpSubKey: string): Longint;

{ Remoteable System Shutdown APIs }

function InitiateSystemShutdown(lpMachineName, lpMessage: string;
  dwTimeout: DWORD; bForceAppsClosed, bRebootAfterShutdown: BOOL): BOOL;
function InitiateSystemShutdownA(lpMachineName, lpMessage: string;
  dwTimeout: DWORD; bForceAppsClosed, bRebootAfterShutdown: BOOL): BOOL;
function InitiateSystemShutdownW(lpMachineName, lpMessage: string;
  dwTimeout: DWORD; bForceAppsClosed, bRebootAfterShutdown: BOOL): BOOL;
function AbortSystemShutdown(lpMachineName: string): BOOL;
function AbortSystemShutdownA(lpMachineName: string): BOOL;
function AbortSystemShutdownW(lpMachineName: string): BOOL;


{ Translated from WINNETWK.H }

const
{ Network types }

  WNNC_NET_MSNET              = $00010000;
  WNNC_NET_LANMAN             = $00020000;
  WNNC_NET_NETWARE            = $00030000;
  WNNC_NET_VINES              = $00040000;
  WNNC_NET_10NET              = $00050000;
  WNNC_NET_LOCUS              = $00060000;
  WNNC_NET_SUN_PC_NFS         = $00070000;
  WNNC_NET_LANSTEP            = $00080000;
  WNNC_NET_9TILES             = $00090000;
  WNNC_NET_LANTASTIC          = $000A0000;
  WNNC_NET_AS400              = $000B0000;
  WNNC_NET_FTP_NFS            = $000C0000;
  WNNC_NET_PATHWORKS          = $000D0000;
  WNNC_NET_LIFENET            = $000E0000;
  WNNC_NET_POWERLAN           = $000F0000;
  WNNC_NET_BWNFS              = $00100000;
  WNNC_NET_COGENT             = $00110000;
  WNNC_NET_FARALLON           = $00120000;
  WNNC_NET_APPLETALK          = $00130000;
  WNNC_NET_INTERGRAPH         = $00140000;
  WNNC_NET_SYMFONET           = $00150000;
  WNNC_NET_CLEARCASE          = $00160000;

{ Network Resources. }

  RESOURCE_CONNECTED = 1;
  RESOURCE_GLOBALNET = 2;
  RESOURCE_REMEMBERED = 3;
  RESOURCE_RECENT = 4;
  RESOURCE_CONTEXT = 5;

  RESOURCETYPE_ANY = 0;
  RESOURCETYPE_DISK = 1;
  RESOURCETYPE_PRINT = 2;
  RESOURCETYPE_RESERVED = 8;
  RESOURCETYPE_UNKNOWN = DWORD($FFFFFFFF);

  RESOURCEUSAGE_CONNECTABLE = 1;
  RESOURCEUSAGE_CONTAINER = 2;
  RESOURCEUSAGE_NOLOCALDEVICE = 4;
  RESOURCEUSAGE_SIBLING = 8;

  RESOURCEUSAGE_ATTACHED = $00000010;
  RESOURCEUSAGE_ALL = (RESOURCEUSAGE_CONNECTABLE or RESOURCEUSAGE_CONTAINER or RESOURCEUSAGE_ATTACHED);
  RESOURCEUSAGE_RESERVED = DWORD($80000000);

  RESOURCEDISPLAYTYPE_GENERIC            = $00000000;
  RESOURCEDISPLAYTYPE_DOMAIN             = $00000001;
  RESOURCEDISPLAYTYPE_SERVER             = $00000002;
  RESOURCEDISPLAYTYPE_SHARE              = $00000003;
  RESOURCEDISPLAYTYPE_FILE               = $00000004;
  RESOURCEDISPLAYTYPE_GROUP              = $00000005;
  RESOURCEDISPLAYTYPE_NETWORK            = $00000006;
  RESOURCEDISPLAYTYPE_ROOT               = $00000007;
  RESOURCEDISPLAYTYPE_SHAREADMIN         = $00000008;
  RESOURCEDISPLAYTYPE_DIRECTORY          = $00000009;
  RESOURCEDISPLAYTYPE_TREE               = $0000000A;
  RESOURCEDISPLAYTYPE_NDSCONTAINER       = $0000000B;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  _NETRESOURCE = packed record
    dwScope: DWORD;
    dwType: DWORD;
    dwDisplayType: DWORD;
    dwUsage: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpLocalName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpRemoteName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpComment: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpProvider: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  _NETRESOURCEA = packed record
    dwScope: DWORD;
    dwType: DWORD;
    dwDisplayType: DWORD;
    dwUsage: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpLocalName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpRemoteName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpComment: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpProvider: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  _NETRESOURCEW = packed record
    dwScope: DWORD;
    dwType: DWORD;
    dwDisplayType: DWORD;
    dwUsage: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpLocalName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpRemoteName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpComment: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpProvider: string;
  end;
  TNetResource = _NETRESOURCE;
  TNetResourceA = _NETRESOURCEA;
  TNetResourceW = _NETRESOURCEW;
  NETRESOURCE = _NETRESOURCE;
  NETRESOURCEA = _NETRESOURCEA;
  NETRESOURCEW = _NETRESOURCEW;

const
{ Network Connections. }

  NETPROPERTY_PERSISTENT = 1;

  CONNECT_UPDATE_PROFILE          = $00000001;
  CONNECT_UPDATE_RECENT           = $00000002;
  CONNECT_TEMPORARY               = $00000004;
  CONNECT_INTERACTIVE             = $00000008;
  CONNECT_PROMPT                  = $00000010;
  CONNECT_NEED_DRIVE              = $00000020;
  CONNECT_REFCOUNT                = $00000040;
  CONNECT_REDIRECT                = $00000080;
  CONNECT_LOCALDRIVE              = $00000100;
  CONNECT_CURRENT_MEDIA           = $00000200;
  CONNECT_DEFERRED                = $00000400;
  CONNECT_RESERVED                = DWORD($FF000000);

function WNetAddConnection(lpRemoteName, lpPassword, lpLocalName: string): DWORD; overload;
function WNetAddConnection(lpRemoteName: string; lpPassword: IntPtr; lpLocalName: string): DWORD; overload;
function WNetAddConnection(lpRemoteName: string; lpPassword, lpLocalName: IntPtr): DWORD; overload;
function WNetAddConnection(lpRemoteName, lpPassword: string; lpLocalName: IntPtr): DWORD; overload;
function WNetAddConnectionA(lpRemoteName, lpPassword, lpLocalName: string): DWORD;
function WNetAddConnectionW(lpRemoteName, lpPassword, lpLocalName: string): DWORD;

function WNetAddConnection2(const lpNetResource: TNetResource;
  lpPassword, lpUserName: string; dwFlags: DWORD): DWORD; overload;
function WNetAddConnection2(const lpNetResource: TNetResource;
  lpPassword: IntPtr; lpUserName: string; dwFlags: DWORD): DWORD; overload;
function WNetAddConnection2(const lpNetResource: TNetResource;
  lpPassword, lpUserName: IntPtr; dwFlags: DWORD): DWORD; overload;
function WNetAddConnection2(const lpNetResource: TNetResource;
  lpPassword: string; lpUserName: IntPtr; dwFlags: DWORD): DWORD; overload;
function WNetAddConnection2A(const lpNetResource: TNetResourceA;
  lpPassword, lpUserName: string; dwFlags: DWORD): DWORD;
function WNetAddConnection2W(const lpNetResource: TNetResourceW;
  lpPassword, lpUserName: string; dwFlags: DWORD): DWORD;

function WNetAddConnection3(hwndOwner: HWND; const lpNetResource: TNetResource;
  lpPassword, lpUserName: string; dwFlags: DWORD): DWORD; overload;
function WNetAddConnection3(hwndOwner: HWND; const lpNetResource: TNetResource;
  lpPassword: IntPtr; lpUserName: string; dwFlags: DWORD): DWORD; overload;
function WNetAddConnection3(hwndOwner: HWND; const lpNetResource: TNetResource;
  lpPassword, lpUserName: IntPtr; dwFlags: DWORD): DWORD; overload;
function WNetAddConnection3(hwndOwner: HWND; const lpNetResource: TNetResource;
  lpPassword: string; lpUserName: IntPtr; dwFlags: DWORD): DWORD; overload;
function WNetAddConnection3A(hwndOwner: HWND; const lpNetResource: TNetResourceA;
  lpPassword, lpUserName: string; dwFlags: DWORD): DWORD;
function WNetAddConnection3W(hwndOwner: HWND; const lpNetResource: TNetResourceW;
  lpPassword, lpUserName: string; dwFlags: DWORD): DWORD;

function WNetCancelConnection(lpName: string; fForce: BOOL): DWORD;
function WNetCancelConnectionA(lpName: string; fForce: BOOL): DWORD;
function WNetCancelConnectionW(lpName: string; fForce: BOOL): DWORD;
function WNetCancelConnection2(lpName: string; dwFlags: DWORD; fForce: BOOL): DWORD;
function WNetCancelConnection2A(lpName: string; dwFlags: DWORD; fForce: BOOL): DWORD;
function WNetCancelConnection2W(lpName: string; dwFlags: DWORD; fForce: BOOL): DWORD;
function WNetGetConnection(lpLocalName: string;
  lpRemoteName: StringBuilder; var lpnLength: DWORD): DWORD;
function WNetGetConnectionA(lpLocalName: string;
  lpRemoteName: StringBuilder; var lpnLength: DWORD): DWORD;
function WNetGetConnectionW(lpLocalName: string;
  lpRemoteName: StringBuilder; var lpnLength: DWORD): DWORD;

function WNetUseConnection(hwndOwner: HWND;
  const lpNetResource: TNetResource; lpUserID: string;
  lpPassword: string; dwFlags: DWORD; lpAccessName: StringBuilder;
  var lpBufferSize: DWORD; out lpResult: DWORD): DWORD; overload;
function WNetUseConnection(hwndOwner: HWND;
  const lpNetResource: TNetResource; lpUserID: IntPtr;
  lpPassword: string; dwFlags: DWORD; lpAccessName: StringBuilder;
  var lpBufferSize: DWORD; out lpResult: DWORD): DWORD; overload;
function WNetUseConnection(hwndOwner: HWND;
  const lpNetResource: TNetResource; lpUserID: IntPtr;
  lpPassword: IntPtr; dwFlags: DWORD; lpAccessName: StringBuilder;
  var lpBufferSize: DWORD; out lpResult: DWORD): DWORD; overload;
function WNetUseConnection(hwndOwner: HWND;
  const lpNetResource: TNetResource; lpUserID: string;
  lpPassword: IntPtr; dwFlags: DWORD; lpAccessName: StringBuilder;
  var lpBufferSize: DWORD; out lpResult: DWORD): DWORD; overload;
function WNetUseConnectionA(hwndOwner: HWND;
  const lpNetResource: TNetResourceA; lpUserID: string;
  lpPassword: string; dwFlags: DWORD; lpAccessName: StringBuilder;
  var lpBufferSize: DWORD; out lpResult: DWORD): DWORD;
function WNetUseConnectionW(hwndOwner: HWND;
  const lpNetResource: TNetResourceW; lpUserID: string;
  lpPassword: string; dwFlags: DWORD; lpAccessName: StringBuilder;
  var lpBufferSize: DWORD; out lpResult: DWORD): DWORD;

function WNetSetConnection(lpName: string; dwProperties: DWORD; var pvValues: DWORD): DWORD;
function WNetSetConnectionA(lpName: string; dwProperties: DWORD; var pvValues: DWORD): DWORD;
function WNetSetConnectionW(lpName: string; dwProperties: DWORD; var pvValues: DWORD): DWORD;

{ Network Connection Dialogs. }

function WNetConnectionDialog(hwnd: HWND; dwType: DWORD): DWORD;
function WNetDisconnectDialog(hwnd: HWND; dwType: DWORD): DWORD;

type
  _CONNECTDLGSTRUCTA = packed record
    cbStructure: DWORD;          { size of this structure in bytes }
    hwndOwner: HWND;             { owner window for the dialog }
    lpConnRes: IntPtr;           { PNetResource - Requested Resource info    }
    dwFlags: DWORD;              { flags (see below) }
    dwDevNum: DWORD;             { number of devices connected to }
  end;
  TConnectDlgStruct = _CONNECTDLGSTRUCTA;
  CONNECTDLGSTRUCT = _CONNECTDLGSTRUCTA;

const
  CONNDLG_RO_PATH = 1;    { Resource path should be read-only     }
  CONNDLG_CONN_POINT = 2; { Netware -style movable connection point enabled  }
  CONNDLG_USE_MRU = 4;    { Use MRU combobox   }
  CONNDLG_HIDE_BOX = 8;   { Hide persistent connect checkbox   }

  { NOTE:  Set at most ONE of the below flags.  If neither flag is set,
           then the persistence is set to whatever the user chose during
           a previous connection }

  CONNDLG_PERSIST = $10;       { Force persistent connection  }
  CONNDLG_NOT_PERSIST = $20;   { Force connection NOT persistent  }

function WNetConnectionDialog1(var lpConnDlgStruct: TConnectDlgStruct): DWORD;
function WNetConnectionDialog1A(var lpConnDlgStruct: TConnectDlgStruct): DWORD;
function WNetConnectionDialog1W(var lpConnDlgStruct: TConnectDlgStruct): DWORD;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  _DISCDLGSTRUCT = packed record
    cbStructure: DWORD;       { size of this structure in bytes }
    hwndOwner: HWND;          { owner window for the dialog }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpLocalName: string;       { local device name }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpRemoteName: string;      { network resource name }
    dwFlags: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  _DISCDLGSTRUCTA = packed record
    cbStructure: DWORD;       { size of this structure in bytes }
    hwndOwner: HWND;          { owner window for the dialog }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpLocalName: string;       { local device name }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpRemoteName: string;      { network resource name }
    dwFlags: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  _DISCDLGSTRUCTW = packed record
    cbStructure: DWORD;       { size of this structure in bytes }
    hwndOwner: HWND;          { owner window for the dialog }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpLocalName: string;       { local device name }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpRemoteName: string;      { network resource name }
    dwFlags: DWORD;
  end;
  TDiscDlgStruct = _DISCDLGSTRUCT;
  TDiscDlgStructA = _DISCDLGSTRUCTA;
  TDiscDlgStructW = _DISCDLGSTRUCTW;
  DISCDLGSTRUCT = _DISCDLGSTRUCT;
  DISCDLGSTRUCTA = _DISCDLGSTRUCTA;
  DISCDLGSTRUCTW = _DISCDLGSTRUCTW;

const
  DISC_UPDATE_PROFILE = 1;
  DISC_NO_FORCE = $40;

function WNetDisconnectDialog1(const lpConnDlgStruct: TDiscDlgStruct): DWORD;
function WNetDisconnectDialog1A(const lpConnDlgStruct: TDiscDlgStructA): DWORD;
function WNetDisconnectDialog1W(const lpConnDlgStruct: TDiscDlgStructW): DWORD;

{ Network Browsing. }

function WNetOpenEnum(dwScope, dwType, dwUsage: DWORD;
  const lpNetResource: TNetResource; out lphEnum: THandle): DWORD; overload;
function WNetOpenEnum(dwScope, dwType, dwUsage: DWORD;
  lpNetResource: IntPtr; out lphEnum: THandle): DWORD; overload;
function WNetOpenEnumA(dwScope, dwType, dwUsage: DWORD;
  const lpNetResource: TNetResourceA; out lphEnum: THandle): DWORD;
function WNetOpenEnumW(dwScope, dwType, dwUsage: DWORD;
  const lpNetResource: TNetResourceW; out lphEnum: THandle): DWORD;

function WNetEnumResource(hEnum: THandle; var lpcCount: DWORD;
  lpBuffer: IntPtr; var lpBufferSize: DWORD): DWORD;
function WNetEnumResourceA(hEnum: THandle; var lpcCount: DWORD;
  lpBuffer: IntPtr; var lpBufferSize: DWORD): DWORD;
function WNetEnumResourceW(hEnum: THandle; var lpcCount: DWORD;
  lpBuffer: IntPtr; var lpBufferSize: DWORD): DWORD;
function WNetCloseEnum(hEnum: THandle): DWORD;
function WNetGetResourceParent(const lpNetResource: TNetResource;
  out lpBuffer: TNetResource; var cbBuffer: DWORD): DWORD;
function WNetGetResourceParentA(const lpNetResource: TNetResourceA;
  out lpBuffer: TNetResourceA; var cbBuffer: DWORD): DWORD;
function WNetGetResourceParentW(const lpNetResource: TNetResourceW;
  out lpBuffer: TNetResourceW; var cbBuffer: DWORD): DWORD;

const
{ Universal Naming. }

  UNIVERSAL_NAME_INFO_LEVEL = 1;
  REMOTE_NAME_INFO_LEVEL = 2;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  _UNIVERSAL_NAME_INFO = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpUniversalName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  _UNIVERSAL_NAME_INFOA = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpUniversalName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  _UNIVERSAL_NAME_INFOW = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpUniversalName: string;
  end;
  TUniversalNameInfo = _UNIVERSAL_NAME_INFO;
  TUniversalNameInfoA = _UNIVERSAL_NAME_INFOA;
  TUniversalNameInfoW = _UNIVERSAL_NAME_INFOW;
  UNIVERSAL_NAME_INFO = _UNIVERSAL_NAME_INFO;
  UNIVERSAL_NAME_INFOA = _UNIVERSAL_NAME_INFOA;
  UNIVERSAL_NAME_INFOW = _UNIVERSAL_NAME_INFOW;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  _REMOTE_NAME_INFO = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpUniversalName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpConnectionName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpRemainingPath: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  _REMOTE_NAME_INFOA = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpUniversalName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpConnectionName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpRemainingPath: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  _REMOTE_NAME_INFOW = packed record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpUniversalName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpConnectionName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpRemainingPath: string;
  end;
  TRemoteNameInfo = _REMOTE_NAME_INFO;
  TRemoteNameInfoA = _REMOTE_NAME_INFOA;
  TRemoteNameInfoW = _REMOTE_NAME_INFOW;
  REMOTE_NAME_INFO = _REMOTE_NAME_INFO;
  REMOTE_NAME_INFOA = _REMOTE_NAME_INFOA;
  REMOTE_NAME_INFOW = _REMOTE_NAME_INFOW;

function WNetGetUniversalName(lpLocalPath: string; dwInfoLevel: DWORD;
  lpBuffer: IntPtr; var lpBufferSize: DWORD): DWORD;
function WNetGetUniversalNameA(lpLocalPath: string; dwInfoLevel: DWORD;
  lpBuffer: IntPtr; var lpBufferSize: DWORD): DWORD;
function WNetGetUniversalNameW(lpLocalPath: string; dwInfoLevel: DWORD;
  lpBuffer: IntPtr; var lpBufferSize: DWORD): DWORD;

{ Authentication and Logon/Logoff }

function WNetGetUser(lpName: string; lpUserName: StringBuilder; var lpnLength: DWORD): DWORD; overload;
function WNetGetUser(lpName: IntPtr; lpUserName: StringBuilder; var lpnLength: DWORD): DWORD; overload;
function WNetGetUserA(lpName: string; lpUserName: StringBuilder; var lpnLength: DWORD): DWORD;
function WNetGetUserW(lpName: string; lpUserName: StringBuilder; var lpnLength: DWORD): DWORD;

const
  WNFMT_MULTILINE = 1;
  WNFMT_ABBREVIATED = 2;
  WNFMT_INENUM = $10;
  WNFMT_CONNECTION = $20;

function WNetGetProviderName(dwNetType: DWORD; lpProviderName: StringBuilder;
  var lpBufferSize: DWORD): DWORD;
function WNetGetProviderNameA(dwNetType: DWORD; lpProviderName: StringBuilder;
  var lpBufferSize: DWORD): DWORD;
function WNetGetProviderNameW(dwNetType: DWORD; lpProviderName: StringBuilder;
  var lpBufferSize: DWORD): DWORD;

type
  [StructLayout(LayoutKind.Sequential)]
  _NETINFOSTRUCT = record
    cbStructure: DWORD;
    dwProviderVersion: DWORD;
    dwStatus: DWORD;
    dwCharacteristics: DWORD;
    dwHandle: DWORD;
    wNetType: Word;
    dwPrinters: DWORD;
    dwDrives: DWORD;
  end;
  TNetInfoStruct = _NETINFOSTRUCT;
  NETINFOSTRUCT = _NETINFOSTRUCT;

const
  NETINFO_DLL16 = 1;      { Provider running as 16 bit Winnet Driver  }
  NETINFO_DISKRED = 4;    { Provider requires disk redirections to connect  }
  NETINFO_PRINTERRED = 8; { Provider requires printer redirections to connect  }

function WNetGetNetworkInformation(lpProvider: string;
  out lpNetInfoStruct: TNetInfoStruct): DWORD;
function WNetGetNetworkInformationA(lpProvider: string;
  out lpNetInfoStruct: TNetInfoStruct): DWORD;
function WNetGetNetworkInformationW(lpProvider: string;
  out lpNetInfoStruct: TNetInfoStruct): DWORD;

type
{ User Profiles }
  TFNGetProfilePath = function (pszUsername: string; pszBuffer: StringBuilder;
    cbBuffer: UINT): UINT;
  TFNReconcileProfile = function (pszCentralFile: string; pszLocalFile: string;
    dwFlags: DWORD): UINT;


const
  RP_LOGON = 1;    { if set, do for logon, else for logoff }
  RP_INIFILE = 2;  { if set, reconcile .INI file, else reg. hive }

type
{ Policies }

  TFNProcessPolicies = function (pszPath: string; pszUsername: string;
    pszComputerName: string; dwFlags: DWORD): BOOL;

const
  PP_DISPLAYERRORS = 1;  { if set, display error messages, else fail silently if error }

{ Error handling }

function WNetGetLastError(out lpError: DWORD; lpErrorBuf: StringBuilder;
  nErrorBufSize: DWORD; lpNameBuf: StringBuilder; nNameBufSize: DWORD): DWORD;
function WNetGetLastErrorA(out lpError: DWORD; lpErrorBuf: StringBuilder;
  nErrorBufSize: DWORD; lpNameBuf: StringBuilder; nNameBufSize: DWORD): DWORD;
function WNetGetLastErrorW(out lpError: DWORD; lpErrorBuf: StringBuilder;
  nErrorBufSize: DWORD; lpNameBuf: StringBuilder; nNameBufSize: DWORD): DWORD;


const
{ STATUS CODES }
{ General }

  WN_SUCCESS = NO_ERROR;
  WN_NO_ERROR = NO_ERROR;
  WN_NOT_SUPPORTED = ERROR_NOT_SUPPORTED;
  WN_CANCEL = ERROR_CANCELLED;
  WN_RETRY = ERROR_RETRY;
  WN_NET_ERROR = ERROR_UNEXP_NET_ERR;
  WN_MORE_DATA = ERROR_MORE_DATA;
  WN_BAD_POINTER = ERROR_INVALID_ADDRESS;
  WN_BAD_VALUE = ERROR_INVALID_PARAMETER;
  WN_BAD_USER = ERROR_BAD_USERNAME;
  WN_BAD_PASSWORD = ERROR_INVALID_PASSWORD;
  WN_ACCESS_DENIED = ERROR_ACCESS_DENIED;
  WN_FUNCTION_BUSY = ERROR_BUSY;
  WN_WINDOWS_ERROR = ERROR_UNEXP_NET_ERR;
  WN_OUT_OF_MEMORY = ERROR_NOT_ENOUGH_MEMORY;
  WN_NO_NETWORK = ERROR_NO_NETWORK;
  WN_EXTENDED_ERROR = ERROR_EXTENDED_ERROR;
  WN_BAD_LEVEL = ERROR_INVALID_LEVEL;
  WN_BAD_HANDLE = ERROR_INVALID_HANDLE;
  WN_NOT_INITIALIZING = ERROR_ALREADY_INITIALIZED;
  WN_NO_MORE_DEVICES = ERROR_NO_MORE_DEVICES;

{ Connection }

  WN_NOT_CONNECTED = ERROR_NOT_CONNECTED;
  WN_OPEN_FILES = ERROR_OPEN_FILES;
  WN_DEVICE_IN_USE = ERROR_DEVICE_IN_USE;
  WN_BAD_NETNAME = ERROR_BAD_NET_NAME;
  WN_BAD_LOCALNAME = ERROR_BAD_DEVICE;
  WN_ALREADY_CONNECTED = ERROR_ALREADY_ASSIGNED;
  WN_DEVICE_ERROR = ERROR_GEN_FAILURE;
  WN_CONNECTION_CLOSED = ERROR_CONNECTION_UNAVAIL;
  WN_NO_NET_OR_BAD_PATH = ERROR_NO_NET_OR_BAD_PATH;
  WN_BAD_PROVIDER = ERROR_BAD_PROVIDER;
  WN_CANNOT_OPEN_PROFILE = ERROR_CANNOT_OPEN_PROFILE;
  WN_BAD_PROFILE = ERROR_BAD_PROFILE;
  WN_BAD_DEV_TYPE = ERROR_BAD_DEV_TYPE;
  WN_DEVICE_ALREADY_REMEMBERED = ERROR_DEVICE_ALREADY_REMEMBERED;

{ Enumeration }

  WN_NO_MORE_ENTRIES = ERROR_NO_MORE_ITEMS;
  WN_NOT_CONTAINER = ERROR_NOT_CONTAINER;

{ Authentication }

  WN_NOT_AUTHENTICATED = ERROR_NOT_AUTHENTICATED;
  WN_NOT_LOGGED_ON = ERROR_NOT_LOGGED_ON;
  WN_NOT_VALIDATED = ERROR_NO_LOGON_SERVERS;

type
{ For Shell }
  _NETCONNECTINFOSTRUCT = packed record
    cbStructure: DWORD;
    dwFlags: DWORD;
    dwSpeed: DWORD;
    dwDelay: DWORD;
    dwOptDataSize: DWORD;
  end;
  TNetConnectInfoStruct = _NETCONNECTINFOSTRUCT;
  NETCONNECTINFOSTRUCT = _NETCONNECTINFOSTRUCT;

const
  WNCON_FORNETCARD = 1;
  WNCON_NOTROUTED = 2;
  WNCON_SLOWLINK = 4;
  WNCON_DYNAMIC = 8;

function MultinetGetConnectionPerformance(const lpNetResource: TNetResource;
  out lpNetConnectInfoStruc: TNetConnectInfoStruct): DWORD;
function MultinetGetConnectionPerformanceA(const lpNetResource: TNetResourceA;
  out lpNetConnectInfoStruc: TNetConnectInfoStruct): DWORD;
function MultinetGetConnectionPerformanceW(const lpNetResource: TNetResourceW;
  out lpNetConnectInfoStruc: TNetConnectInfoStruct): DWORD;

{ Translated from DDE.H }

const
  WM_DDE_FIRST      = $03E0;
  WM_DDE_INITIATE   = WM_DDE_FIRST;
  WM_DDE_TERMINATE  = WM_DDE_FIRST+1;
  WM_DDE_ADVISE     = WM_DDE_FIRST+2;
  WM_DDE_UNADVISE   = WM_DDE_FIRST+3;
  WM_DDE_ACK        = WM_DDE_FIRST+4;
  WM_DDE_DATA       = WM_DDE_FIRST+5;
  WM_DDE_REQUEST    = WM_DDE_FIRST+6;
  WM_DDE_POKE       = WM_DDE_FIRST+7;
  WM_DDE_EXECUTE    = WM_DDE_FIRST+8;
  WM_DDE_LAST       = WM_DDE_FIRST+8;

{ Constants used for a WM_DDE_ACK message sent in responce to a WM_DDE_DATA
  WM_DDE_REQUEST, WM_DDE_POKE, WM_DDE_ADVISE, or WM_DDE_UNADVISE message.
  For example
    if lParam and dde_Ack <> 0 then ...
}

type
  DDEACK = packed record
    Flags: Word;
  end;
  TDDEAck = DDEACK;

const
  dde_AppReturnCode = $00FF;
  dde_Busy          = $4000;
  dde_Ack           = $8000;

{ Record for the  WM_DDE_ADVISE Options parameter (LoWord(lParam)) }

type
  DDEADVISE = packed record
    Flags: Word;
    cfFormat: SmallInt;
  end;
  TDDEAdvise = DDEADVISE;

const
  dde_DeferUpd     = $4000;
  dde_AckReq       = $8000;

{ Record for the hData parameter of a WM_DDE_DATA message (LoWord(lParam)).
  The actual size of this record depends on the size of the Value
  array. }

type
  DDEDATA = packed record
    Flags: Word;
    cfFormat: SmallInt;
    Value: IntPtr;    { array[0..0] of Byte }
    Reserved: IntPtr; { array[0..0] of Byte }
  end;
  TDDEData = DDEDATA;

const
  dde_Response = $1000;
  dde_Release  = $2000;

{ Record for the hData parameter of the WM_DDE_POKE record (LoWord(lParam)).
  The actual size of this record depends on the size of the Value array. }

type
  DDEPOKE = packed record
    Flags: Word;
    cfFormat: SmallInt;
    Value: IntPtr;    { array[0..0] of Byte }
    Reserved: IntPtr; { array[0..0] of Byte }
  end;
  TDDEPoke = DDEPOKE;

{ DDE Security }

function DdeSetQualityOfService(hWndClient: HWnd; const pqosNew: TSecurityQualityOfService;
  out pqosPrev: TSecurityQualityOfService): BOOL; overload;
function DdeSetQualityOfService(hWndClient: HWnd; const pqosNew: TSecurityQualityOfService;
  pqosPrev: IntPtr): BOOL; overload;
function ImpersonateDdeClientWindow(hWndClient: HWnd; hWndServer: HWnd): BOOL;

{ DDE message packing APIs }
function PackDDElParam(msg: UINT; uiLo: UINT; uiHi: UINT): Longint;
function UnpackDDElParam(msg: UINT; lParam: Longint; out puiLo, puiHi: UINT): BOOL;
function FreeDDElParam(msg: UINT; lParam: Longint): BOOL;
function ReuseDDElParam(lParam: Longint; msgIn: UINT; msgOut: UINT; uiLo: UINT; uiHi: UINT): Longint;

{ From zmouse.h }

{ Client Appplication (API) Defines for Wheel rolling }

const
  // Apps need to call RegisterWindowMessage using the constant below to
  // get the message number that is sent to the foreground window
  // when a wheel roll occurs
  MSH_MOUSEWHEEL   = 'MSWHEEL_ROLLMSG';
   // wParam = wheel rotation expressed in multiples of WHEEL_DELTA
   // lParam is the mouse coordinates

{ Client Appplication (API) Defines for
   *  determining if wheel support active
   *  determining # of Scroll Lines }

  // Class name for MSWHEEL.EXE's invisible window
  // use FindWindow to get hwnd to MSWHEEL
  MOUSEZ_CLASSNAME = 'MouseZ';            // wheel window class
  MOUSEZ_TITLE     = 'Magellan MSWHEEL';  // wheel window title

  MSH_WHEELMODULE_CLASS = MOUSEZ_CLASSNAME;
  MSH_WHEELMODULE_TITLE = MOUSEZ_TITLE;

// Apps need to call RegisterWindowMessage using the constants
// below to get the message numbers for:
// 1) the message that can be sent to the MSWHEEL window to
//    query if wheel support is active (MSH_WHEELSUPPORT)>
// 2) the message to query for the number of scroll lines
//    (MSH_SCROLL_LINES)
//
// To send a message to MSWheel window, use FindWindow with the #defines
// for CLASS and TITLE above.  If FindWindow fails to find the MSWHEEL
// window or the return from SendMessage is false, then Wheel support
// is not currently available.

  // MSH_WHEELSUPPORT
  //    wParam - not used
  //    lParam - not used
  //    returns BOOL - TRUE if wheel support is active, FALSE otherwise
  MSH_WHEELSUPPORT = 'MSH_WHEELSUPPORT_MSG';  // name of msg to send
                                              // to query for wheel support
  // MSH_SCROLL_LINES
  //    wParam - not used
  //    lParam - not used
  //    returns int  - number of lines to scroll on a wheel roll
  MSH_SCROLL_LINES = 'MSH_SCROLL_LINES_MSG';

(*********************************************************************
* FUNCTION: HwndMsWheel
* Purpose : Get a reference to MSWheel Window, the registered messages,
*           wheel support active setting, and number of scrollLines
* Params  : puiMsh_MsgMouseWheel - UINT to contain returned registered wheel message
*           puiMsh_Msg3DSupport - UINT to contain wheel support registered message
*           puiMsh_MsgScrollLines - UINT to contain Scroll lines registered message
*           pf3DSupport - BOOL to contain returned flag for wheel support active
*           piScrollLines - Integer to contain returned scroll lines
* Returns : HWND handle to the MsWheel window
* Note    : The return value for pf3DSupport and piScrollLines is dependant
*           on the POINT32 module.  If POINT32 module is not running then
*           the values returned for these parameters will be
*           FALSE and 3, respectively.
*********************************************************************)
function HwndMSWheel(var puiMsh_MsgMouseWheel, puiMsh_Msg3DSupport,
  puiMsh_MsgScrollLines: UINT; var pf3DSupport: BOOL;
  var piScrollLines: Integer): HWND;

const
  advapi32  = 'advapi32.dll';
  kernel32  = 'kernel32.dll';
  mpr       = 'mpr.dll';
  version   = 'version.dll';
  comctl32  = 'comctl32.dll';
  gdi32     = 'gdi32.dll';
  opengl32  = 'opengl32.dll';
  user32    = 'user32.dll';
  wintrust  = 'wintrust.dll';
  msimg32   = 'msimg32.dll';

implementation

{ Externals from advapi32.dll }

[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AbortSystemShutdown')]
function AbortSystemShutdown; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AbortSystemShutdownA')]
function AbortSystemShutdownA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AbortSystemShutdownW')]
function AbortSystemShutdownW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AllocateLocallyUniqueId')]
function AllocateLocallyUniqueId; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'BackupEventLog')]
function BackupEventLog; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BackupEventLogA')]
function BackupEventLogA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'BackupEventLogW')]
function BackupEventLogW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ClearEventLog')]
function ClearEventLog; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ClearEventLogA')]
function ClearEventLogA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ClearEventLogW')]
function ClearEventLogW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CloseEventLog')]
function CloseEventLog; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateProcessAsUser')]
function CreateProcessAsUser(hToken: THandle; lpApplicationName: string;
  lpCommandLine: string; const lpProcessAttributes: TSecurityAttributes;
  const lpThreadAttributes: TSecurityAttributes; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: string; lpCurrentDirectory: string;
  const lpStartupInfo: TStartupInfo; out lpProcessInformation: TProcessInformation): BOOL; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateProcessAsUser')]
function CreateProcessAsUser(hToken: THandle; lpApplicationName: string;
  lpCommandLine: string; lpProcessAttributes: IntPtr;
  lpThreadAttributes: IntPtr; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: string; lpCurrentDirectory: string;
  const lpStartupInfo: TStartupInfo; out lpProcessInformation: TProcessInformation): BOOL; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateProcessAsUser')]
function CreateProcessAsUser(hToken: THandle; lpApplicationName: string;
  lpCommandLine: string; lpProcessAttributes: IntPtr;
  const lpThreadAttributes: TSecurityAttributes; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: string; lpCurrentDirectory: string;
  const lpStartupInfo: TStartupInfo; out lpProcessInformation: TProcessInformation): BOOL; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateProcessAsUser')]
function CreateProcessAsUser(hToken: THandle; lpApplicationName: string;
  lpCommandLine: string; const lpProcessAttributes: TSecurityAttributes;
  lpThreadAttributes: IntPtr; bInheritHandles: BOOL;
  dwCreationFlags: DWORD; lpEnvironment: string; lpCurrentDirectory: string;
  const lpStartupInfo: TStartupInfo; out lpProcessInformation: TProcessInformation): BOOL; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateProcessAsUserA')]
function CreateProcessAsUserA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateProcessAsUserW')]
function CreateProcessAsUserW; external;

[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeregisterEventSource')]
function DeregisterEventSource; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCurrentHwProfile')]
function GetCurrentHwProfile; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCurrentHwProfileA')]
function GetCurrentHwProfileA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetCurrentHwProfileW')]
function GetCurrentHwProfileW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetFileSecurity')]
function GetFileSecurity; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileSecurityA')]
function GetFileSecurityA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetFileSecurityW')]
function GetFileSecurityW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNumberOfEventLogRecords')]
function GetNumberOfEventLogRecords; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetOldestEventLogRecord')]
function GetOldestEventLogRecord; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetUserName')]
function GetUserName; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetUserNameA')]
function GetUserNameA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetUserNameW')]
function GetUserNameW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ImpersonateLoggedOnUser')]
function ImpersonateLoggedOnUser; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InitiateSystemShutdown')]
function InitiateSystemShutdown; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InitiateSystemShutdownA')]
function InitiateSystemShutdownA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InitiateSystemShutdownW')]
function InitiateSystemShutdownW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'IsTextUnicode')]
function IsTextUnicode([in] lpBuffer: TBytes; cb: Integer; var lpi: Integer): BOOL; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'IsTextUnicode')]
function IsTextUnicode([in] lpBuffer: TBytes; cb: Integer; lpi: IntPtr): BOOL; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'LogonUser')]
function LogonUser(lpszUsername, lpszDomain, lpszPassword: string;
  dwLogonType, dwLogonProvider: DWORD; out phToken: THandle): BOOL; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'LogonUser')]
function LogonUser(lpszUsername: string; lpszDomain: IntPtr; lpszPassword: string;
  dwLogonType, dwLogonProvider: DWORD; out phToken: THandle): BOOL; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LogonUserA')]
function LogonUserA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'LogonUserW')]
function LogonUserW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'LookupAccountName')]
function LookupAccountName; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LookupAccountNameA')]
function LookupAccountNameA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'LookupAccountNameW')]
function LookupAccountNameW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'LookupAccountSid')]
function LookupAccountSid; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LookupAccountSidA')]
function LookupAccountSidA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'LookupAccountSidW')]
function LookupAccountSidW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'LookupPrivilegeDisplayName')]
function LookupPrivilegeDisplayName; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LookupPrivilegeDisplayNameA')]
function LookupPrivilegeDisplayNameA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'LookupPrivilegeDisplayNameW')]
function LookupPrivilegeDisplayNameW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'LookupPrivilegeName')]
function LookupPrivilegeName; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LookupPrivilegeNameA')]
function LookupPrivilegeNameA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'LookupPrivilegeNameW')]
function LookupPrivilegeNameW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'LookupPrivilegeValue')]
function LookupPrivilegeValue; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LookupPrivilegeValueA')]
function LookupPrivilegeValueA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'LookupPrivilegeValueW')]
function LookupPrivilegeValueW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'MapGenericMask')]
procedure MapGenericMask; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'NotifyChangeEventLog')]
function NotifyChangeEventLog; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OpenBackupEventLog')]
function OpenBackupEventLog; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenBackupEventLogA')]
function OpenBackupEventLogA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OpenBackupEventLogW')]
function OpenBackupEventLogW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OpenEventLog')]
function OpenEventLog; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenEventLogA')]
function OpenEventLogA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OpenEventLogW')]
function OpenEventLogW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ReadEventLog')]
function ReadEventLog; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadEventLogA')]
function ReadEventLogA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ReadEventLogW')]
function ReadEventLogW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegCloseKey')]
function RegCloseKey; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegConnectRegistry')]
function RegConnectRegistry; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegConnectRegistryA')]
function RegConnectRegistryA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegConnectRegistryW')]
function RegConnectRegistryW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegCreateKey')]
function RegCreateKey; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegCreateKeyA')]
function RegCreateKeyA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegCreateKeyW')]
function RegCreateKeyW; external;

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegCreateKeyEx')]
function RegCreateKeyEx(hKey: HKEY; lpSubKey: string;
  Reserved: DWORD; lpClass: string; dwOptions: DWORD; samDesired: REGSAM;
  const lpSecurityAttributes: TSecurityAttributes; out phkResult: HKEY;
  out lpdwDisposition: DWORD): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegCreateKeyEx')]
function RegCreateKeyEx(hKey: HKEY; lpSubKey: string;
  Reserved: DWORD; lpClass: string; dwOptions: DWORD; samDesired: REGSAM;
  lpSecurityAttributes: IntPtr; out phkResult: HKEY;
  out lpdwDisposition: DWORD): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegCreateKeyEx')]
function RegCreateKeyEx(hKey: HKEY; lpSubKey: string;
  Reserved: DWORD; lpClass: IntPtr; dwOptions: DWORD; samDesired: REGSAM;
  const lpSecurityAttributes: TSecurityAttributes; out phkResult: HKEY;
  out lpdwDisposition: DWORD): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegCreateKeyEx')]
function RegCreateKeyEx(hKey: HKEY; lpSubKey: string;
  Reserved: DWORD; lpClass: IntPtr; dwOptions: DWORD; samDesired: REGSAM;
  lpSecurityAttributes: IntPtr; out phkResult: HKEY;
  out lpdwDisposition: DWORD): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegCreateKeyExA')]
function RegCreateKeyExA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegCreateKeyExW')]
function RegCreateKeyExW; external;

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegDeleteKey')]
function RegDeleteKey; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegDeleteKeyA')]
function RegDeleteKeyA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegDeleteKeyW')]
function RegDeleteKeyW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegDeleteValue')]
function RegDeleteValue; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegDeleteValueA')]
function RegDeleteValueA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegDeleteValueW')]
function RegDeleteValueW; external;

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegEnumKeyEx')]
function RegEnumKeyEx(hKey: HKEY; dwIndex: DWORD; lpName: StringBuilder;
  var lpcbName: DWORD; lpReserved: IntPtr; lpClass: StringBuilder;
  var lpcbClass: DWORD; out lpftLastWriteTime: TFileTime): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegEnumKeyEx')]
function RegEnumKeyEx(hKey: HKEY; dwIndex: DWORD; lpName: StringBuilder;
  var lpcbName: DWORD; lpReserved: IntPtr; lpClass: StringBuilder;
  lpcbClass: IntPtr; lpftLastWriteTime: IntPtr): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegEnumKeyEx')]
function RegEnumKeyEx(hKey: HKEY; dwIndex: DWORD; lpName: StringBuilder;
  var lpcbName: DWORD; lpReserved: IntPtr; lpClass: StringBuilder;
  lpcbClass: IntPtr; out lpftLastWriteTime: TFileTime): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegEnumKeyEx')]
function RegEnumKeyEx(hKey: HKEY; dwIndex: DWORD; lpName: StringBuilder;
  var lpcbName: DWORD; lpReserved: IntPtr; lpClass: StringBuilder;
  var lpcbClass: DWORD; lpftLastWriteTime: IntPtr): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegEnumKeyExA')]
function RegEnumKeyExA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegEnumKeyExW')]
function RegEnumKeyExW; external;

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegEnumKey')]
function RegEnumKey; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegEnumKeyA')]
function RegEnumKeyA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegEnumKeyW')]
function RegEnumKeyW; external;

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegEnumValue')]
function RegEnumValue(hKey: HKEY; dwIndex: DWORD; lpValueName: StringBuilder;
  var lpcbValueName: DWORD; lpReserved: IntPtr; out lpType: DWORD;
  [out] lpData: array of Byte; var lpcbData: DWORD): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegEnumValue')]
function RegEnumValue(hKey: HKEY; dwIndex: DWORD; lpValueName: StringBuilder;
  var lpcbValueName: DWORD; lpReserved: IntPtr; lpType: IntPtr;
  lpData, lpcbData: IntPtr): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegEnumValue')]
function RegEnumValue(hKey: HKEY; dwIndex: DWORD; lpValueName: StringBuilder;
  var lpcbValueName: DWORD; lpReserved: IntPtr; lpType: IntPtr;
  [out] lpData: array of Byte; var lpcbData: DWORD): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegEnumValue')]
function RegEnumValue(hKey: HKEY; dwIndex: DWORD; lpValueName: StringBuilder;
  var lpcbValueName: DWORD; lpReserved: IntPtr; out lpType: DWORD;
  lpData, lpcbData: IntPtr): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegEnumValueA')]
function RegEnumValueA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegEnumValueW')]
function RegEnumValueW; external;

[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegFlushKey')]
function RegFlushKey; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegGetKeySecurity')]
function RegGetKeySecurity; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegLoadKey')]
function RegLoadKey; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegLoadKeyA')]
function RegLoadKeyA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegLoadKeyW')]
function RegLoadKeyW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegNotifyChangeKeyValue')]
function RegNotifyChangeKeyValue; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegOpenKey')]
function RegOpenKey; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegOpenKeyA')]
function RegOpenKeyA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegOpenKeyW')]
function RegOpenKeyW; external;

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegOpenKeyEx')]
function RegOpenKeyEx(hKey: HKEY; lpSubKey: string;
  ulOptions: DWORD; samDesired: REGSAM; out phkResult: HKEY): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegOpenKeyEx')]
function RegOpenKeyEx(hKey: HKEY; lpSubKey: IntPtr;
  ulOptions: DWORD; samDesired: REGSAM; out phkResult: HKEY): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegOpenKeyExA')]
function RegOpenKeyExA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegOpenKeyExW')]
function RegOpenKeyExW; external;

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegQueryInfoKey')]
function RegQueryInfoKey(hKey: HKEY; lpClass: StringBuilder;
  var lpcbClass: DWORD; lpReserved: IntPtr;
  out lpcSubKeys, lpcbMaxSubKeyLen: DWORD; lpcbMaxClassLen: IntPtr; out lpcValues,
  lpcbMaxValueNameLen, lpcbMaxValueLen, lpcbSecurityDescriptor: DWORD;
  out lpftLastWriteTime: TFileTime): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegQueryInfoKey')]
function RegQueryInfoKey(hKey: HKEY; lpClass, lpcbClass, lpReserved: IntPtr;
  var lpcSubKeys, lpcbMaxSubKeyLen: DWORD; lpcbMaxClassLen: IntPtr; out lpcValues,
  lpcbMaxValueNameLen, lpcbMaxValueLen: DWORD; lpcbSecurityDescriptor: IntPtr;
  out lpftLastWriteTime: TFileTime): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegQueryInfoKeyA')]
function RegQueryInfoKeyA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegQueryInfoKeyW')]
function RegQueryInfoKeyW; external;

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegQueryMultipleValues')]
function RegQueryMultipleValues; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegQueryMultipleValuesA')]
function RegQueryMultipleValuesA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegQueryMultipleValuesW')]
function RegQueryMultipleValuesW; external;

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegQueryValue')]
function RegQueryValue; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegQueryValueA')]
function RegQueryValueA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegQueryValueW')]
function RegQueryValueW; external;

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegQueryValueEx')]
function RegQueryValueEx(hKey: HKEY; lpValueName: string;
  lpReserved: IntPtr; out lpType: DWORD; [in, out] lpData: array of Byte;
  var lpcbData: DWORD): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegQueryValueEx')]
function RegQueryValueEx(hKey: HKEY; lpValueName: string;
  lpReserved: IntPtr; out lpType: DWORD; lpData: IntPtr;
  var lpcbData: DWORD): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegQueryValueEx')]
function RegQueryValueEx(hKey: HKEY; lpValueName: string;
  lpReserved: IntPtr; lpType: IntPtr; lpData: IntPtr;
  var lpcbData: DWORD): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegQueryValueEx')]
function RegQueryValueEx(hKey: HKEY; lpValueName: string;
  lpReserved: IntPtr; lpType: IntPtr; [in, out] lpData: StringBuilder;
  var lpcbData: Longint): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegQueryValueExA')]
function RegQueryValueExA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegQueryValueExW')]
function RegQueryValueExW; external;

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegReplaceKey')]
function RegReplaceKey; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegReplaceKeyA')]
function RegReplaceKeyA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegReplaceKeyW')]
function RegReplaceKeyW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegRestoreKey')]
function RegRestoreKey; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegRestoreKeyA')]
function RegRestoreKeyA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegRestoreKeyW')]
function RegRestoreKeyW; external;

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegSaveKey')]
function RegSaveKey(hKey: HKEY; lpFile: string;
  const lpSecurityAttributes: TSecurityAttributes): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegSaveKey')]
function RegSaveKey(hKey: HKEY; lpFile: string;
  lpSecurityAttributes: IntPtr): Longint; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegSaveKeyA')]
function RegSaveKeyA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegSaveKeyW')]
function RegSaveKeyW; external;

[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegSetKeySecurity')]
function RegSetKeySecurity; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegSetValue')]
function RegSetValue; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegSetValueA')]
function RegSetValueA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegSetValueW')]
function RegSetValueW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegSetValueEx')]
function RegSetValueEx; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegSetValueExA')]
function RegSetValueExA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegSetValueExW')]
function RegSetValueExW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegUnLoadKey')]
function RegUnLoadKey; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegUnLoadKeyA')]
function RegUnLoadKeyA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegUnLoadKeyW')]
function RegUnLoadKeyW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegisterEventSource')]
function RegisterEventSource(lpUNCServerName, lpSourceName: string): THandle; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegisterEventSource')]
function RegisterEventSource(lpUNCServerName: IntPtr; lpSourceName: string): THandle; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegisterEventSourceA')]
function RegisterEventSourceA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegisterEventSourceW')]
function RegisterEventSourceW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ReportEvent')]
function ReportEvent; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReportEventA')]
function ReportEventA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ReportEventW')]
function ReportEventW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetFileSecurity')]
function SetFileSecurity; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFileSecurityA')]
function SetFileSecurityA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetFileSecurityW')]
function SetFileSecurityW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetKernelObjectSecurity')]
function SetKernelObjectSecurity; external;

{ Externals from kernel32.dll }

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddAtom')]
function AddAtom; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddAtomA')]
function AddAtomA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AddAtomW')]
function AddAtomW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AllocConsole')]
function AllocConsole; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AreFileApisANSI')]
function AreFileApisANSI; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BackupRead')]
function BackupRead; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BackupSeek')]
function BackupSeek; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BackupWrite')]
function BackupWrite; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'Beep')]
function Beep; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'BeginUpdateResource')]
function BeginUpdateResource; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BeginUpdateResourceA')]
function BeginUpdateResourceA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'BeginUpdateResourceW')]
function BeginUpdateResourceW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'BuildCommDCB')]
function BuildCommDCB; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BuildCommDCBA')]
function BuildCommDCBA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'BuildCommDCBW')]
function BuildCommDCBW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'BuildCommDCBAndTimeouts')]
function BuildCommDCBAndTimeouts; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BuildCommDCBAndTimeoutsA')]
function BuildCommDCBAndTimeoutsA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'BuildCommDCBAndTimeoutsW')]
function BuildCommDCBAndTimeoutsW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CallNamedPipe')]
function CallNamedPipe; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CallNamedPipeA')]
function CallNamedPipeA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CallNamedPipeW')]
function CallNamedPipeW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CancelIo')]
function CancelIo; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CancelWaitableTimer')]
function CancelWaitableTimer; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ClearCommBreak')]
function ClearCommBreak; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ClearCommError')]
function ClearCommError(hFile: THandle; out lpErrors: DWORD; out lpStat: TComStat): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ClearCommError')]
function ClearCommError(hFile: THandle; out lpErrors: DWORD; lpStat: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CloseHandle')]
function CloseHandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CloseRaw')]
procedure CloseRaw; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CommConfigDialog')]
function CommConfigDialog; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CommConfigDialogA')]
function CommConfigDialogA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CommConfigDialogW')]
function CommConfigDialogW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CompareFileTime')]
function CompareFileTime; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CompareString')]
function CompareString; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CompareStringA')]
function CompareStringA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CompareStringW')]
function CompareStringW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ConnectNamedPipe')]
function ConnectNamedPipe(hNamedPipe: THandle; const lpOverlapped: TOverlapped): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ConnectNamedPipe')]
function ConnectNamedPipe(hNamedPipe: THandle; lpOverlapped: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ContinueDebugEvent')]
function ContinueDebugEvent; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ConvertThreadToFiber')]
function ConvertThreadToFiber; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ConvertDefaultLocale')]
function ConvertDefaultLocale; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CopyFile')]
function CopyFile; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CopyFileA')]
function CopyFileA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CopyFileW')]
function CopyFileW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CopyFileEx')]
function CopyFileEx; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CopyFileExA')]
function CopyFileExA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CopyFileExW')]
function CopyFileExW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateConsoleScreenBuffer')]
function CreateConsoleScreenBuffer(dwDesiredAccess, dwShareMode: DWORD;
  const lpSecurityAttributes: TSecurityAttributes; dwFlags: DWORD;
  lpScreenBufferData: IntPtr): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateConsoleScreenBuffer')]
function CreateConsoleScreenBuffer(dwDesiredAccess, dwShareMode: DWORD;
  lpSecurityAttributes: IntPtr; dwFlags: DWORD;
  lpScreenBufferData: IntPtr): THandle; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDirectory')]
function CreateDirectory(lpPathName: string;
  const lpSecurityAttributes: TSecurityAttributes): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDirectory')]
function CreateDirectory(lpPathName: string;
  lpSecurityAttributes: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateDirectoryA')]
function CreateDirectoryA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateDirectoryW')]
function CreateDirectoryW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDirectoryEx')]
function CreateDirectoryEx(lpTemplateDirectory, lpNewDirectory: string;
  const lpSecurityAttributes: TSecurityAttributes): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDirectoryEx')]
function CreateDirectoryEx(lpTemplateDirectory, lpNewDirectory: string;
  lpSecurityAttributes: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateDirectoryExA')]
function CreateDirectoryExA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateDirectoryExW')]
function CreateDirectoryExW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateEvent')]
function CreateEvent(const lpEventAttributes: TSecurityAttributes;
  bManualReset, bInitialState: BOOL; lpName: string): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateEvent')]
function CreateEvent(lpEventAttributes: IntPtr;
  bManualReset, bInitialState: BOOL; lpName: string): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateEventA')]
function CreateEventA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateEventW')]
function CreateEventW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateFiber')]
function CreateFiber; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateFile')]
function CreateFile(lpFileName: string; dwDesiredAccess, dwShareMode: DWORD;
  const lpSecurityAttributes: TSecurityAttributes; dwCreationDisposition,
  dwFlagsAndAttributes: DWORD; hTemplateFile: THandle): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateFile')]
function CreateFile(lpFileName: string; dwDesiredAccess, dwShareMode: DWORD;
  lpSecurityAttributes: IntPtr; dwCreationDisposition, dwFlagsAndAttributes: DWORD;
  hTemplateFile: THandle): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateFileA')]
function CreateFileA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateFileW')]
function CreateFileW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateFileMapping')]
function CreateFileMapping(hFile: THandle; const lpFileMappingAttributes: TSecurityAttributes;
  flProtect, dwMaximumSizeHigh, dwMaximumSizeLow: DWORD; lpName: string): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateFileMapping')]
function CreateFileMapping(hFile: THandle; lpFileMappingAttributes: IntPtr;
  flProtect, dwMaximumSizeHigh, dwMaximumSizeLow: DWORD; lpName: string): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateFileMappingA')]
function CreateFileMappingA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateFileMappingW')]
function CreateFileMappingW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateHardLink')]
function CreateHardLink; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateHardLinkA')]
function CreateHardLinkA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateHardLinkW')]
function CreateHardLinkW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateIoCompletionPort')]
function CreateIoCompletionPort; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateMailslot')]
function CreateMailslot(lpName: string; nMaxMessageSize: DWORD;
  lReadTimeout: DWORD; const lpSecurityAttributes: TSecurityAttributes): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateMailslot')]
function CreateMailslot(lpName: string; nMaxMessageSize: DWORD;
  lReadTimeout: DWORD; lpSecurityAttributes: IntPtr): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateMailslotA')]
function CreateMailslotA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateMailslotW')]
function CreateMailslotW; external;

// NT 4.0 bug workaround - NT 4.0 doesn't test bInitialOwner for zero/nonzero, it tests for 1
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateMutex')]
function _CreateMutex(const lpMutexAttributes: TSecurityAttributes;
  bInitialOwner: Integer; lpName: string): THandle; overload; external;

function CreateMutex(const lpMutexAttributes: TSecurityAttributes; bInitialOwner: BOOL; lpName: string): THandle;
begin
  Result := _CreateMutex(lpMutexAttributes, Integer(Boolean(bInitialOwner)), lpName);
end;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateMutex')]
function _CreateMutex(lpMutexAttributes: IntPtr; bInitialOwner: Integer; lpName: string): THandle; overload; external;

function CreateMutex(lpMutexAttributes: IntPtr; bInitialOwner: BOOL; lpName: string): THandle;
begin
  Result := _CreateMutex(lpMutexAttributes, Integer(Boolean(bInitialOwner)), lpName);
end;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateMutexA')]
function _CreateMutexA(const lpMutexAttributes: TSecurityAttributes;
  bInitialOwner: Integer; lpName: string): THandle; external;

function CreateMutexA(const lpMutexAttributes: TSecurityAttributes; bInitialOwner: BOOL; lpName: string): THandle;
begin
  Result := _CreateMutexA(lpMutexAttributes, Integer(Boolean(bInitialOwner)), lpName);
end;

[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateMutexW')]
function _CreateMutexW(const lpMutexAttributes: TSecurityAttributes;
  bInitialOwner: Integer; lpName: string): THandle; external;

function CreateMutexW(const lpMutexAttributes: TSecurityAttributes; bInitialOwner: BOOL; lpName: string): THandle;
begin
  Result := _CreateMutexW(lpMutexAttributes, Integer(Boolean(bInitialOwner)), lpName);
end;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateNamedPipe')]
function CreateNamedPipe(lpName: string;
  dwOpenMode, dwPipeMode, nMaxInstances, nOutBufferSize, nInBufferSize, nDefaultTimeOut: DWORD;
  const lpSecurityAttributes: TSecurityAttributes): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateNamedPipe')]
function CreateNamedPipe(lpName: string;
  dwOpenMode, dwPipeMode, nMaxInstances, nOutBufferSize, nInBufferSize, nDefaultTimeOut: DWORD;
  lpSecurityAttributes: IntPtr): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateNamedPipeA')]
function CreateNamedPipeA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateNamedPipeW')]
function CreateNamedPipeW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreatePipe')]
function CreatePipe(out hReadPipe, hWritePipe: THandle;
  const lpPipeAttributes: TSecurityAttributes; nSize: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreatePipe')]
function CreatePipe(out hReadPipe, hWritePipe: THandle;
  lpPipeAttributes: IntPtr; nSize: DWORD): BOOL; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateProcess')]
function CreateProcess(lpApplicationName: string; lpCommandLine: StringBuilder;
  const lpProcessAttributes, lpThreadAttributes: TSecurityAttributes;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: string;
  lpCurrentDirectory: string; const lpStartupInfo: TStartupInfo;
  out lpProcessInformation: TProcessInformation): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateProcess')]
function CreateProcess(lpApplicationName: string; lpCommandLine: StringBuilder;
  lpProcessAttributes, lpThreadAttributes: IntPtr;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: string;
  lpCurrentDirectory: string; const lpStartupInfo: TStartupInfo;
  out lpProcessInformation: TProcessInformation): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateProcess')]
function CreateProcess(lpApplicationName: string; lpCommandLine: StringBuilder;
  lpProcessAttributes: IntPtr; const lpThreadAttributes: TSecurityAttributes;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: string;
  lpCurrentDirectory: string; const lpStartupInfo: TStartupInfo;
  out lpProcessInformation: TProcessInformation): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateProcess')]
function CreateProcess(lpApplicationName: string; lpCommandLine: StringBuilder;
  const lpProcessAttributes: TSecurityAttributes; lpThreadAttributes: IntPtr;
  bInheritHandles: BOOL; dwCreationFlags: DWORD; lpEnvironment: string;
  lpCurrentDirectory: string; const lpStartupInfo: TStartupInfo;
  out lpProcessInformation: TProcessInformation): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateProcessA')]
function CreateProcessA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateProcessW')]
function CreateProcessW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateRemoteThread')]
function CreateRemoteThread(hProcess: THandle; const lpThreadAttributes: TSecurityAttributes;
  dwStackSize: DWORD; lpStartAddress: TFNThreadStartRoutine; lpParameter: IntPtr;
  dwCreationFlags: DWORD; out lpThreadId: DWORD): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateRemoteThread')]
function CreateRemoteThread(hProcess: THandle; lpThreadAttributes: IntPtr;
  dwStackSize: DWORD; lpStartAddress: TFNThreadStartRoutine; lpParameter: IntPtr;
  dwCreationFlags: DWORD; out lpThreadId: DWORD): THandle; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateSemaphore')]
function CreateSemaphore(const lpSemaphoreAttributes: TSecurityAttributes;
  lInitialCount, lMaximumCount: Longint; lpName: string): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateSemaphore')]
function CreateSemaphore(lpSemaphoreAttributes: IntPtr;
  lInitialCount, lMaximumCount: Longint; lpName: string): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateSemaphoreA')]
function CreateSemaphoreA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateSemaphoreW')]
function CreateSemaphoreW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateTapePartition')]
function CreateTapePartition; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateThread')]
function CreateThread(lpThreadAttributes: IntPtr;
  dwStackSize: DWORD; lpStartAddress: TFNThreadStartRoutine;
  lpParameter: IntPtr; dwCreationFlags: DWORD; out lpThreadId: DWORD): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateThread')]
function CreateThread(const lpThreadAttributes: TSecurityAttributes;
  dwStackSize: DWORD; lpStartAddress: TFNThreadStartRoutine;
  lpParameter: IntPtr; dwCreationFlags: DWORD; out lpThreadId: DWORD): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateWaitableTimer')]
function CreateWaitableTimer(const lpTimerAttributes: TSecurityAttributes;
  bManualReset: BOOL; lpTimerName: string): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateWaitableTimer')]
function CreateWaitableTimer(lpTimerAttributes: IntPtr;
  bManualReset: BOOL; lpTimerName: string): THandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateWaitableTimerA')]
function CreateWaitableTimerA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateWaitableTimerW')]
function CreateWaitableTimerW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DecryptFile')]
function DecryptFile; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DecryptFileA')]
function DecryptFileA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DecryptFileW')]
function DecryptFileW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DebugActiveProcess')]
function DebugActiveProcess; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DebugBreak')]
procedure DebugBreak; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DefineDosDevice')]
function DefineDosDevice; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DefineDosDeviceA')]
function DefineDosDeviceA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DefineDosDeviceW')]
function DefineDosDeviceW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteAtom')]
function DeleteAtom; external;
{$IFNDEF LINUXCRITSECTION}
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteCriticalSection')]
procedure DeleteCriticalSection; external;
{$ENDIF}
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteFiber')]
function DeleteFiber; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeleteFile')]
function DeleteFile; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteFileA')]
function DeleteFileA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DeleteFileW')]
function DeleteFileW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeviceIoControl')]
function DeviceIoControl(hDevice: THandle; dwIoControlCode: DWORD; lpInBuffer: IntPtr;
  nInBufferSize: DWORD; lpOutBuffer: IntPtr; nOutBufferSize: DWORD;
  out lpBytesReturned: DWORD; const lpOverlapped: TOverlapped): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeviceIoControl')]
function DeviceIoControl(hDevice: THandle; dwIoControlCode: DWORD; lpInBuffer: IntPtr;
  nInBufferSize: DWORD; lpOutBuffer: IntPtr; nOutBufferSize: DWORD;
  out lpBytesReturned: DWORD; lpOverlapped: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DisableThreadLibraryCalls')]
function DisableThreadLibraryCalls; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DisconnectNamedPipe')]
function DisconnectNamedPipe; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DosDateTimeToFileTime')]
function DosDateTimeToFileTime; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DuplicateHandle')]
function DuplicateHandle(hSourceProcessHandle, hSourceHandle, hTargetProcessHandle: THandle;
  out lpTargetHandle: THandle; dwDesiredAccess: DWORD;
  bInheritHandle: BOOL; dwOptions: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DuplicateHandle')]
function DuplicateHandle(hSourceProcessHandle, hSourceHandle, hTargetProcessHandle: THandle;
  lpTargetHandle: IntPtr; dwDesiredAccess: DWORD;
  bInheritHandle: BOOL; dwOptions: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EncryptFile')]
function EncryptFile; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EncryptFileA')]
function EncryptFileA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EncryptFileW')]
function EncryptFileW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EndUpdateResource')]
function EndUpdateResource; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EndUpdateResourceA')]
function EndUpdateResourceA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EndUpdateResourceW')]
function EndUpdateResourceW; external;
{$IFNDEF LINUXCRITSECTION}
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnterCriticalSection')]
procedure EnterCriticalSection; external;
{$ENDIF}
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumCalendarInfo')]
function EnumCalendarInfo; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumCalendarInfoA')]
function EnumCalendarInfoA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumCalendarInfoW')]
function EnumCalendarInfoW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumDateFormats')]
function EnumDateFormats; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumDateFormatsA')]
function EnumDateFormatsA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumDateFormatsW')]
function EnumDateFormatsW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumResourceLanguages')]
function EnumResourceLanguages; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumResourceLanguagesA')]
function EnumResourceLanguagesA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumResourceLanguagesW')]
function EnumResourceLanguagesW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumResourceNames')]
function EnumResourceNames; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumResourceNamesA')]
function EnumResourceNamesA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumResourceNamesW')]
function EnumResourceNamesW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumResourceTypes')]
function EnumResourceTypes; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumResourceTypesA')]
function EnumResourceTypesA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumResourceTypesW')]
function EnumResourceTypesW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumSystemCodePages')]
function EnumSystemCodePages; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumSystemCodePagesA')]
function EnumSystemCodePagesA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumSystemCodePagesW')]
function EnumSystemCodePagesW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumSystemLocales')]
function EnumSystemLocales; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumSystemLocalesA')]
function EnumSystemLocalesA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumSystemLocalesW')]
function EnumSystemLocalesW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumTimeFormats')]
function EnumTimeFormats; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumTimeFormatsA')]
function EnumTimeFormatsA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumTimeFormatsW')]
function EnumTimeFormatsW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EraseTape')]
function EraseTape; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EscapeCommFunction')]
function EscapeCommFunction; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExitProcess')]
procedure ExitProcess; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExitThread')]
procedure ExitThread; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ExpandEnvironmentStrings')]
function ExpandEnvironmentStrings; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExpandEnvironmentStringsA')]
function ExpandEnvironmentStringsA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ExpandEnvironmentStringsW')]
function ExpandEnvironmentStringsW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FatalAppExit')]
procedure FatalAppExit; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FatalAppExitA')]
procedure FatalAppExitA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FatalAppExitW')]
procedure FatalAppExitW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FatalExit')]
procedure FatalExit; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FileTimeToDosDateTime')]
function FileTimeToDosDateTime; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FileTimeToLocalFileTime')]
function FileTimeToLocalFileTime; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FileTimeToSystemTime')]
function FileTimeToSystemTime; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FillConsoleOutputAttribute')]
function FillConsoleOutputAttribute; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FillConsoleOutputCharacter')]
function FillConsoleOutputCharacter; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FillConsoleOutputCharacterA')]
function FillConsoleOutputCharacterA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FillConsoleOutputCharacterW')]
function FillConsoleOutputCharacterW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindAtom')]
function FindAtom; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindAtomA')]
function FindAtomA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindAtomW')]
function FindAtomW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindClose')]
function FindClose; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindCloseChangeNotification')]
function FindCloseChangeNotification; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindFirstChangeNotification')]
function FindFirstChangeNotification; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindFirstChangeNotificationA')]
function FindFirstChangeNotificationA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindFirstChangeNotificationW')]
function FindFirstChangeNotificationW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindFirstFile')]
function FindFirstFile; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindFirstFileA')]
function FindFirstFileA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindFirstFileW')]
function FindFirstFileW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindFirstFileEx')]
function FindFirstFileEx; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindFirstFileExA')]
function FindFirstFileExA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindFirstFileExW')]
function FindFirstFileExW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindNextChangeNotification')]
function FindNextChangeNotification; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindNextFile')]
function FindNextFile; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindNextFileA')]
function FindNextFileA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindNextFileW')]
function FindNextFileW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindResource')]
function FindResource(hModule: HMODULE; lpName, lpType: string): HRSRC; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindResource')]
function FindResource(hModule: HMODULE; lpName: string; lpType: Integer): HRSRC; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindResource')]
function FindResource(hModule: HMODULE; lpName, lpType: Integer): HRSRC; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindResource')]
function FindResource(hModule: HMODULE; lpName: Integer; lpType: string): HRSRC; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindResourceA')]
function FindResourceA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindResourceW')]
function FindResourceW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindResourceEx')]
function FindResourceEx; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindResourceExA')]
function FindResourceExA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindResourceExW')]
function FindResourceExW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlushConsoleInputBuffer')]
function FlushConsoleInputBuffer; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlushFileBuffers')]
function FlushFileBuffers; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlushViewOfFile')]
function FlushViewOfFile; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FoldString')]
function FoldString; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FoldStringA')]
function FoldStringA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FoldStringW')]
function FoldStringW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FormatMessage')]
function FormatMessage; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FormatMessageA')]
function FormatMessageA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FormatMessageW')]
function FormatMessageW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FreeConsole')]
function FreeConsole; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FreeEnvironmentStrings')]
function FreeEnvironmentStrings; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FreeEnvironmentStringsA')]
function FreeEnvironmentStringsA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FreeEnvironmentStringsW')]
function FreeEnvironmentStringsW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FreeLibrary')]
function FreeLibrary; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FreeLibraryAndExitThread')]
procedure FreeLibraryAndExitThread; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FreeResource')]
function FreeResource; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GenerateConsoleCtrlEvent')]
function GenerateConsoleCtrlEvent; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetACP')]
function GetACP; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetAtomName')]
function GetAtomName; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetAtomNameA')]
function GetAtomNameA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetAtomNameW')]
function GetAtomNameW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetBinaryType')]
function GetBinaryType; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetBinaryTypeA')]
function GetBinaryTypeA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetBinaryTypeW')]
function GetBinaryTypeW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCPInfo')]
function GetCPInfo; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCommandLine')]
function GetCommandLine; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCommandLineA')]
function GetCommandLineA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetCommandLineW')]
function GetCommandLineW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCommConfig')]
function GetCommConfig; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCommMask')]
function GetCommMask; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCommModemStatus')]
function GetCommModemStatus; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCommProperties')]
function GetCommProperties; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCommState')]
function GetCommState; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCommTimeouts')]
function GetCommTimeouts; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCompressedFileSize')]
function GetCompressedFileSize; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCompressedFileSizeA')]
function GetCompressedFileSizeA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetCompressedFileSizeW')]
function GetCompressedFileSizeW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetComputerName')]
function GetComputerName; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetComputerNameA')]
function GetComputerNameA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetComputerNameW')]
function GetComputerNameW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetConsoleCP')]
function GetConsoleCP; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetConsoleCursorInfo')]
function GetConsoleCursorInfo; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetConsoleMode')]
function GetConsoleMode; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetConsoleOutputCP')]
function GetConsoleOutputCP; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetConsoleScreenBufferInfo')]
function GetConsoleScreenBufferInfo; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetConsoleTitle')]
function GetConsoleTitle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetConsoleTitleA')]
function GetConsoleTitleA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetConsoleTitleW')]
function GetConsoleTitleW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCurrencyFormat')]
function GetCurrencyFormat(Locale: LCID; dwFlags: DWORD; lpValue: string;
  const lpFormat: TCurrencyFmt; lpCurrencyStr: StringBuilder; cchCurrency: Integer): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCurrencyFormat')]
function GetCurrencyFormat(Locale: LCID; dwFlags: DWORD; lpValue: string;
  lpFormat: IntPtr; lpCurrencyStr: StringBuilder; cchCurrency: Integer): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCurrencyFormatA')]
function GetCurrencyFormatA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetCurrencyFormatW')]
function GetCurrencyFormatW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCurrentDirectory')]
function GetCurrentDirectory; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCurrentDirectoryA')]
function GetCurrentDirectoryA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetCurrentDirectoryW')]
function GetCurrentDirectoryW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCurrentProcess')]
function GetCurrentProcess; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCurrentProcessId')]
function GetCurrentProcessId; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCurrentThread')]
function GetCurrentThread; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCurrentThreadId')]
function GetCurrentThreadId; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetDateFormat')]
function GetDateFormat(Locale: LCID; dwFlags: DWORD; const lpDate: TSystemTime;
  lpFormat: string; lpDateStr: StringBuilder; cchDate: Integer): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetDateFormat')]
function GetDateFormat(Locale: LCID; dwFlags: DWORD; lpDate: IntPtr;
  lpFormat: IntPtr; lpDateStr: StringBuilder; cchDate: Integer): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetDateFormat')]
function GetDateFormat(Locale: LCID; dwFlags: DWORD; lpDate: IntPtr;
  lpFormat: string; lpDateStr: StringBuilder; cchDate: Integer): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetDateFormat')]
function GetDateFormat(Locale: LCID; dwFlags: DWORD; const lpDate: TSystemTime;
  lpFormat: IntPtr; lpDateStr: StringBuilder; cchDate: Integer): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDateFormatA')]
function GetDateFormatA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetDateFormatW')]
function GetDateFormatW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetDefaultCommConfig')]
function GetDefaultCommConfig; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDefaultCommConfigA')]
function GetDefaultCommConfigA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetDefaultCommConfigW')]
function GetDefaultCommConfigW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetDiskFreeSpace')]
function GetDiskFreeSpace(lpRootPathName: string; out lpSectorsPerCluster,
  lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetDiskFreeSpace')]
function GetDiskFreeSpace(lpRootPathName: IntPtr; out lpSectorsPerCluster,
  lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDiskFreeSpaceA')]
function GetDiskFreeSpaceA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetDiskFreeSpaceW')]
function GetDiskFreeSpaceW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetDiskFreeSpaceEx')]
function GetDiskFreeSpaceEx(lpDirectoryName: string;
  out lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes,
  lpTotalNumberOfFreeBytes: TLargeInteger): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetDiskFreeSpaceEx')]
function GetDiskFreeSpaceEx(lpDirectoryName: string;
  out lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes: TLargeInteger;
  lpTotalNumberOfFreeBytes: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetDiskFreeSpaceEx')]
function GetDiskFreeSpaceEx(lpDirectoryName: IntPtr;
  out lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes: TLargeInteger;
  lpTotalNumberOfFreeBytes: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDiskFreeSpaceExA')]
function GetDiskFreeSpaceExA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetDiskFreeSpaceExW')]
function GetDiskFreeSpaceExW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetDriveType')]
function GetDriveType; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDriveTypeA')]
function GetDriveTypeA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetDriveTypeW')]
function GetDriveTypeW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetEnvironmentStrings')]
function GetEnvironmentStrings; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetEnvironmentStringsA')]
function GetEnvironmentStringsA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetEnvironmentStringsW')]
function GetEnvironmentStringsW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetEnvironmentVariable')]
function GetEnvironmentVariable(lpName: string; lpBuffer: StringBuilder; nSize: DWORD): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetEnvironmentVariableA')]
function GetEnvironmentVariableA(lpName: string; lpBuffer: StringBuilder; nSize: DWORD): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetEnvironmentVariableW')]
function GetEnvironmentVariableW(lpName: string; lpBuffer: StringBuilder; nSize: DWORD): DWORD; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetExitCodeProcess')]
function GetExitCodeProcess; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetExitCodeThread')]
function GetExitCodeThread; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetFileAttributes')]
function GetFileAttributes; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileAttributesA')]
function GetFileAttributesA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetFileAttributesW')]
function GetFileAttributesW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetFileAttributesEx')]
function GetFileAttributesEx(lpFileName: string; fInfoLevelId: TGetFileExInfoLevels;
  out lpFileInformation: TWin32FindData): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetFileAttributesEx')]
function GetFileAttributesEx(lpFileName: string; fInfoLevelId: TGetFileExInfoLevels;
  lpFileInformation: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileAttributesExA')]
function GetFileAttributesExA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetFileAttributesExW')]
function GetFileAttributesExW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileInformationByHandle')]
function GetFileInformationByHandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileSize')]
function GetFileSize(hFile: THandle; out lpFileSizeHigh: DWORD): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileSize')]
function GetFileSize(hFile: THandle; lpFileSizeHigh: IntPtr): DWORD; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileTime')]
function GetFileTime(hFile: THandle; out lpCreationTime: TFileTime;
  out lpLastAccessTime: TFileTime; out lpLastWriteTime: TFileTime): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileTime')]
function GetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  lpLastAccessTime: IntPtr; lpLastWriteTime: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileTime')]
function GetFileTime(hFile: THandle; out lpCreationTime: TFileTime;
  lpLastAccessTime: IntPtr; lpLastWriteTime: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileTime')]
function GetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  out lpLastAccessTime: TFileTime; out lpLastWriteTime: TFileTime): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileTime')]
function GetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  out lpLastAccessTime: TFileTime; lpLastWriteTime: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileTime')]
function GetFileTime(hFile: THandle; out lpCreationTime: TFileTime;
  lpLastAccessTime: IntPtr; out lpLastWriteTime: TFileTime): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileTime')]
function GetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  lpLastAccessTime: IntPtr; out lpLastWriteTime: TFileTime): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileTime')]
function GetFileTime(hFile: THandle; out lpCreationTime: TFileTime;
  out lpLastAccessTime: TFileTime; lpLastWriteTime: IntPtr): BOOL; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileType')]
function GetFileType; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetFullPathName')]
function GetFullPathName; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFullPathNameA')]
function GetFullPathNameA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetFullPathNameW')]
function GetFullPathNameW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetHandleInformation')]
function GetHandleInformation; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetLargestConsoleWindowSize')]
function GetLargestConsoleWindowSize; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetLocalTime')]
procedure GetLocalTime; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetLocaleInfo')]
function GetLocaleInfo; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetLocaleInfoA')]
function GetLocaleInfoA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetLocaleInfoW')]
function GetLocaleInfoW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetLogicalDriveStrings')]
function GetLogicalDriveStrings; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetLogicalDriveStringsA')]
function GetLogicalDriveStringsA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetLogicalDriveStringsW')]
function GetLogicalDriveStringsW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetLogicalDrives')]
function GetLogicalDrives; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMailslotInfo')]
function GetMailslotInfo(hMailslot: THandle; [in] var lpMaxMessageSize: DWORD;
  [in] var lpNextSize: DWORD; [in] var lpMessageCount: DWORD;
  [in] var lpReadTimeout: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMailslotInfo')]
function GetMailslotInfo(hMailslot: THandle; lpMaxMessageSize: IntPtr;
  [in] var lpNextSize: DWORD; lpMessageCount: IntPtr;
  lpReadTimeout: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMailslotInfo')]
function GetMailslotInfo(hMailslot: THandle; lpMaxMessageSize: IntPtr;
  [in] var lpNextSize: DWORD; [in] var lpMessageCount: DWORD;
  [in] var lpReadTimeout: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMailslotInfo')]
function GetMailslotInfo(hMailslot: THandle; [in] var lpMaxMessageSize: DWORD;
  [in] var lpNextSize: DWORD; lpMessageCount: IntPtr;
  lpReadTimeout: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMailslotInfo')]
function GetMailslotInfo(hMailslot: THandle; [in] var lpMaxMessageSize: DWORD;
  [in] var lpNextSize: DWORD; lpMessageCount: IntPtr;
  [in] var lpReadTimeout: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMailslotInfo')]
function GetMailslotInfo(hMailslot: THandle; lpMaxMessageSize: IntPtr;
  [in] var lpNextSize: DWORD; [in] var lpMessageCount: DWORD;
  lpReadTimeout: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMailslotInfo')]
function GetMailslotInfo(hMailslot: THandle; [in] var lpMaxMessageSize: DWORD;
  [in] var lpNextSize: DWORD; [in] var lpMessageCount: DWORD;
  lpReadTimeout: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMailslotInfo')]
function GetMailslotInfo(hMailslot: THandle; lpMaxMessageSize: IntPtr;
  [in] var lpNextSize: DWORD; lpMessageCount: IntPtr;
  [in] var lpReadTimeout: DWORD): BOOL; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetModuleFileName')]
function GetModuleFileName; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetModuleFileNameA')]
function GetModuleFileNameA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetModuleFileNameW')]
function GetModuleFileNameW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetModuleHandle')]
function GetModuleHandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetModuleHandleA')]
function GetModuleHandleA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetModuleHandleW')]
function GetModuleHandleW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetNamedPipeHandleState')]
function GetNamedPipeHandleState; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNamedPipeHandleStateA')]
function GetNamedPipeHandleStateA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetNamedPipeHandleStateW')]
function GetNamedPipeHandleStateW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNamedPipeInfo')]
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  out lpOutBufferSize: DWORD; out lpInBufferSize: DWORD;
  out lpMaxInstances: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNamedPipeInfo')]
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  lpOutBufferSize: IntPtr; lpInBufferSize: IntPtr;
  lpMaxInstances: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNamedPipeInfo')]
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  lpOutBufferSize: IntPtr; out lpInBufferSize: DWORD;
  out lpMaxInstances: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNamedPipeInfo')]
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  out lpOutBufferSize: DWORD; lpInBufferSize: IntPtr;
  lpMaxInstances: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNamedPipeInfo')]
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  out lpOutBufferSize: DWORD; lpInBufferSize: IntPtr;
  out lpMaxInstances: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNamedPipeInfo')]
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  lpOutBufferSize: IntPtr; out lpInBufferSize: DWORD;
  lpMaxInstances: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNamedPipeInfo')]
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  out lpOutBufferSize: DWORD; out lpInBufferSize: DWORD;
  lpMaxInstances: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNamedPipeInfo')]
function GetNamedPipeInfo(hNamedPipe: THandle; [in] var lpFlags: DWORD;
  lpOutBufferSize: IntPtr; lpInBufferSize: IntPtr;
  out lpMaxInstances: DWORD): BOOL; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetNumberFormat')]
function GetNumberFormat(Locale: LCID; dwFlags: DWORD; lpValue: string;
  const lpFormat: TNumberFmt; lpNumberStr: StringBuilder; cchNumber: Integer): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetNumberFormat')]
function GetNumberFormat(Locale: LCID; dwFlags: DWORD; lpValue: string;
  lpFormat: IntPtr; lpNumberStr: StringBuilder; cchNumber: Integer): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNumberFormatA')]
function GetNumberFormatA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetNumberFormatW')]
function GetNumberFormatW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNumberOfConsoleInputEvents')]
function GetNumberOfConsoleInputEvents; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNumberOfConsoleMouseButtons')]
function GetNumberOfConsoleMouseButtons; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetOEMCP')]
function GetOEMCP; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetOverlappedResult')]
function GetOverlappedResult; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPriorityClass')]
function GetPriorityClass; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrivateProfileInt')]
function GetPrivateProfileInt; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPrivateProfileIntA')]
function GetPrivateProfileIntA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetPrivateProfileIntW')]
function GetPrivateProfileIntW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrivateProfileSection')]
function GetPrivateProfileSection; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPrivateProfileSectionA')]
function GetPrivateProfileSectionA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetPrivateProfileSectionW')]
function GetPrivateProfileSectionW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrivateProfileSectionNames')]
function GetPrivateProfileSectionNames([out] lpszReturnBuffer: TBytes;
  nSize: DWORD; lpFileName: string): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrivateProfileSectionNames')]
function GetPrivateProfileSectionNames([out] lpszReturnBuffer: TBytes;
  nSize: DWORD; lpFileName: IntPtr): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPrivateProfileSectionNamesA')]
function GetPrivateProfileSectionNamesA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetPrivateProfileSectionNamesW')]
function GetPrivateProfileSectionNamesW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrivateProfileString')]
function GetPrivateProfileString(lpAppName, lpKeyName, lpDefault: string;
  lpReturnedString: StringBuilder; nSize: DWORD; lpFileName: string): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrivateProfileString')]
function GetPrivateProfileString(lpAppName, lpKeyName: string; lpDefault: IntPtr;
  lpReturnedString: StringBuilder; nSize: DWORD; lpFileName: string): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrivateProfileString')]
function GetPrivateProfileString(lpAppName: string; lpKeyName, lpDefault: IntPtr;
  [out] lpReturnedString: TBytes; nSize: DWORD; lpFileName: string): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrivateProfileString')]
function GetPrivateProfileString(lpAppName, lpKeyName, lpDefault: IntPtr;
  [out] lpReturnedString: TBytes; nSize: DWORD; lpFileName: string): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPrivateProfileStringA')]
function GetPrivateProfileStringA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetPrivateProfileStringW')]
function GetPrivateProfileStringW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetProcAddress')]
function GetProcAddress; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetProcessAffinityMask')]
function GetProcessAffinityMask; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetProcessPriorityBoost')]
function GetProcessPriorityBoost; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetProcessShutdownParameters')]
function GetProcessShutdownParameters; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetProcessTimes')]
function GetProcessTimes; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetProcessVersion')]
function GetProcessVersion; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetProcessWorkingSetSize')]
function GetProcessWorkingSetSize; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetProfileInt')]
function GetProfileInt; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetProfileIntA')]
function GetProfileIntA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetProfileIntW')]
function GetProfileIntW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetProfileSection')]
function GetProfileSection; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetProfileSectionA')]
function GetProfileSectionA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetProfileSectionW')]
function GetProfileSectionW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetProfileString')]
function GetProfileString(lpAppName, lpKeyName, lpDefault: string;
  {[out]} lpReturnedString: StringBuilder; nSize: DWORD): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetProfileString')]
function GetProfileString(lpAppName, lpKeyName: string; lpDefault: IntPtr;
  lpReturnedString: StringBuilder; nSize: DWORD): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetProfileString')]
function GetProfileString(lpAppName: string; lpKeyName, lpDefault: IntPtr;
  [out] lpReturnedString: TBytes; nSize: DWORD): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetProfileString')]
function GetProfileString(lpAppName, lpKeyName, lpDefault: IntPtr;
  [out] lpReturnedString: TBytes; nSize: DWORD): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetProfileStringA')]
function GetProfileStringA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetProfileStringW')]
function GetProfileStringW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetQueuedCompletionStatus')]
function GetQueuedCompletionStatus; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetShortPathName')]
function GetShortPathName; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetShortPathNameA')]
function GetShortPathNameA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetShortPathNameW')]
function GetShortPathNameW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetStartupInfo')]
procedure GetStartupInfo; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetStartupInfoA')]
procedure GetStartupInfoA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetStartupInfoW')]
procedure GetStartupInfoW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetStdHandle')]
function GetStdHandle; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetStringTypeEx')]
function GetStringTypeEx; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetStringTypeExA')]
function GetStringTypeExA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetStringTypeExW')]
function GetStringTypeExW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetStringTypeA')]
function GetStringTypeA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetStringTypeW')]
function GetStringTypeW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetSystemDefaultLCID')]
function GetSystemDefaultLCID; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetSystemDefaultLangID')]
function GetSystemDefaultLangID; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetSystemDirectory')]
function GetSystemDirectory; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetSystemDirectoryA')]
function GetSystemDirectoryA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetSystemDirectoryW')]
function GetSystemDirectoryW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetSystemInfo')]
procedure GetSystemInfo; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetSystemPowerStatus')]
function GetSystemPowerStatus; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetSystemTime')]
procedure GetSystemTime; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetSystemTimeAsFileTime')]
procedure GetSystemTimeAsFileTime; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetSystemTimeAdjustment')]
function GetSystemTimeAdjustment; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTapeParameters')]
function GetTapeParameters; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTapePosition')]
function GetTapePosition(hDevice: THandle; dwPositionType: DWORD;
  out lpdwPartition, lpdwOffsetLow, lpdwOffsetHigh: DWORD): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTapePosition')]
function GetTapePosition(hDevice: THandle; dwPositionType: DWORD;
  out lpdwPartition, lpdwOffsetLow: DWORD; lpdwOffsetHigh: IntPtr): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTapeStatus')]
function GetTapeStatus; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTempFileName')]
function GetTempFileName; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTempFileNameA')]
function GetTempFileNameA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetTempFileNameW')]
function GetTempFileNameW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTempPath')]
function GetTempPath; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTempPathA')]
function GetTempPathA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetTempPathW')]
function GetTempPathW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetThreadContext')]
function GetThreadContext; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetThreadLocale')]
function GetThreadLocale; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetThreadPriority')]
function GetThreadPriority; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetThreadPriorityBoost')]
function GetThreadPriorityBoost; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetThreadSelectorEntry')]
function GetThreadSelectorEntry; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetThreadTimes')]
function GetThreadTimes; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTickCount')]
function GetTickCount; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTimeFormat')]
function GetTimeFormat(Locale: LCID; dwFlags: DWORD; const lpTime: TSystemTime;
  lpFormat: string; lpTimeStr: StringBuilder; cchTime: Integer): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTimeFormat')]
function GetTimeFormat(Locale: LCID; dwFlags: DWORD; lpTime: IntPtr;
  lpFormat: IntPtr; lpTimeStr: StringBuilder; cchTime: Integer): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTimeFormat')]
function GetTimeFormat(Locale: LCID; dwFlags: DWORD; lpTime: IntPtr;
  lpFormat: string; lpTimeStr: StringBuilder; cchTime: Integer): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTimeFormat')]
function GetTimeFormat(Locale: LCID; dwFlags: DWORD; const lpTime: TSystemTime;
  lpFormat: IntPtr; lpTimeStr: StringBuilder; cchTime: Integer): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTimeFormatA')]
function GetTimeFormatA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetTimeFormatW')]
function GetTimeFormatW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTimeZoneInformation')]
function GetTimeZoneInformation; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetUserDefaultLCID')]
function GetUserDefaultLCID; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetUserDefaultLangID')]
function GetUserDefaultLangID; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetVersion')]
function GetVersion; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetVersionEx')]
function GetVersionEx; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetVersionExA')]
function GetVersionExA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetVersionExW')]
function GetVersionExW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetVolumeInformation')]
function GetVolumeInformation(lpRootPathName: string; lpVolumeNameBuffer: StringBuilder;
  nVolumeNameSize: DWORD; out lpVolumeSerialNumber: DWORD;
  out lpMaximumComponentLength, lpFileSystemFlags: DWORD;
  lpFileSystemNameBuffer: StringBuilder; nFileSystemNameSize: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetVolumeInformation')]
function GetVolumeInformation(lpRootPathName: string; lpVolumeNameBuffer: StringBuilder;
  nVolumeNameSize: DWORD; lpVolumeSerialNumber: IntPtr;
  out lpMaximumComponentLength, lpFileSystemFlags: DWORD;
  lpFileSystemNameBuffer: StringBuilder; nFileSystemNameSize: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetVolumeInformationA')]
function GetVolumeInformationA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetVolumeInformationW')]
function GetVolumeInformationW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetWindowsDirectory')]
function GetWindowsDirectory; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetWindowsDirectoryA')]
function GetWindowsDirectoryA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetWindowsDirectoryW')]
function GetWindowsDirectoryW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GlobalAddAtom')]
function GlobalAddAtom; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalAddAtomA')]
function GlobalAddAtomA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GlobalAddAtomW')]
function GlobalAddAtomW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalAlloc')]
function GlobalAlloc; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalCompact')]
function GlobalCompact; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalDeleteAtom')]
function GlobalDeleteAtom; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GlobalFindAtom')]
function GlobalFindAtom; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalFindAtomA')]
function GlobalFindAtomA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GlobalFindAtomW')]
function GlobalFindAtomW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalFix')]
procedure GlobalFix; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalFlags')]
function GlobalFlags; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalFree')]
function GlobalFree; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GlobalGetAtomName')]
function GlobalGetAtomName; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalGetAtomNameA')]
function GlobalGetAtomNameA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GlobalGetAtomNameW')]
function GlobalGetAtomNameW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalLock')]
function GlobalLock; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalHandle')]
function GlobalHandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalMemoryStatus')]
procedure GlobalMemoryStatus; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalReAlloc')]
function GlobalReAlloc; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalSize')]
function GlobalSize; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalUnWire')]
function GlobalUnWire; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalUnfix')]
procedure GlobalUnfix; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalUnlock')]
function GlobalUnlock; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GlobalWire')]
function GlobalWire; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InitAtomTable')]
function InitAtomTable; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InitializeCriticalSection')]
procedure InitializeCriticalSection; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InitializeCriticalSectionAndSpinCount')]
function InitializeCriticalSectionAndSpinCount; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'IsDBCSLeadByte')]
function IsDBCSLeadByte; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'IsDBCSLeadByteEx')]
function IsDBCSLeadByteEx; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'IsProcessorFeaturePresent')]
function IsProcessorFeaturePresent; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'IsValidCodePage')]
function IsValidCodePage; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'IsValidLocale')]
function IsValidLocale; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'LCMapString')]
function LCMapString; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LCMapStringA')]
function LCMapStringA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'LCMapStringW')]
function LCMapStringW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LeaveCriticalSection')]
procedure LeaveCriticalSection; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'LoadLibrary')]
function LoadLibrary; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LoadLibraryA')]
function LoadLibraryA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'LoadLibraryW')]
function LoadLibraryW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'LoadLibraryEx')]
function LoadLibraryEx; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LoadLibraryExA')]
function LoadLibraryExA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'LoadLibraryExW')]
function LoadLibraryExW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LoadModule')]
function LoadModule; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LoadResource')]
function LoadResource; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LocalFileTimeToFileTime')]
function LocalFileTimeToFileTime; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LockFile')]
function LockFile; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LockFileEx')]
function LockFileEx; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LockResource')]
function LockResource; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'MapViewOfFile')]
function MapViewOfFile; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'MapViewOfFileEx')]
function MapViewOfFileEx; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'MoveFile')]
function MoveFile; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'MoveFileA')]
function MoveFileA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'MoveFileW')]
function MoveFileW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'MoveFileEx')]
function MoveFileEx; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'MoveFileExA')]
function MoveFileExA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'MoveFileExW')]
function MoveFileExW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'MoveFileWithProgress')]
function MoveFileWithProgress; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'MoveFileWithProgressA')]
function MoveFileWithProgressA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'MoveFileWithProgressW')]
function MoveFileWithProgressW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'MulDiv')]
function MulDiv; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'MultiByteToWideChar')]
function MultiByteToWideChar; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OpenEvent')]
function OpenEvent; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenEventA')]
function OpenEventA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OpenEventW')]
function OpenEventW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenFile')]
function OpenFile; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OpenFileMapping')]
function OpenFileMapping; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenFileMappingA')]
function OpenFileMappingA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OpenFileMappingW')]
function OpenFileMappingW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OpenMutex')]
function OpenMutex; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenMutexA')]
function OpenMutexA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OpenMutexW')]
function OpenMutexW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenProcess')]
function OpenProcess; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OpenRaw')]
function OpenRaw; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenRawA')]
function OpenRawA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OpenRawW')]
function OpenRawW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OpenSemaphore')]
function OpenSemaphore; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenSemaphoreA')]
function OpenSemaphoreA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OpenSemaphoreW')]
function OpenSemaphoreW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OpenWaitableTimer')]
function OpenWaitableTimer; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenWaitableTimerA')]
function OpenWaitableTimerA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OpenWaitableTimerW')]
function OpenWaitableTimerW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OutputDebugString')]
procedure OutputDebugString; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OutputDebugStringA')]
procedure OutputDebugStringA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OutputDebugStringW')]
procedure OutputDebugStringW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'PeekConsoleInput')]
function PeekConsoleInput; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PeekConsoleInputA')]
function PeekConsoleInputA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'PeekConsoleInputW')]
function PeekConsoleInputW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PeekNamedPipe')]
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; out lpBytesRead: DWORD; out lpTotalBytesAvail: DWORD;
  out lpBytesLeftThisMessage: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PeekNamedPipe')]
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; lpBytesRead: IntPtr; lpTotalBytesAvail: IntPtr;
  lpBytesLeftThisMessage: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PeekNamedPipe')]
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; lpBytesRead: IntPtr; out lpTotalBytesAvail: DWORD;
  out lpBytesLeftThisMessage: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PeekNamedPipe')]
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; out lpBytesRead: DWORD; lpTotalBytesAvail: IntPtr;
  lpBytesLeftThisMessage: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PeekNamedPipe')]
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; out lpBytesRead: DWORD; lpTotalBytesAvail: IntPtr;
  out lpBytesLeftThisMessage: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PeekNamedPipe')]
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; lpBytesRead: IntPtr; out lpTotalBytesAvail: DWORD;
  lpBytesLeftThisMessage: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PeekNamedPipe')]
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; out lpBytesRead: DWORD; out lpTotalBytesAvail: DWORD;
  lpBytesLeftThisMessage: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PeekNamedPipe')]
function PeekNamedPipe(hNamedPipe: THandle; [out] lpBuffer: TBytes;
  nBufferSize: DWORD; lpBytesRead: IntPtr; lpTotalBytesAvail: IntPtr;
  out lpBytesLeftThisMessage: DWORD): BOOL; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PostQueuedCompletionStatus')]
function PostQueuedCompletionStatus; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PrepareTape')]
function PrepareTape; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PulseEvent')]
function PulseEvent; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PurgeComm')]
function PurgeComm; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'QueryDosDevice')]
function QueryDosDevice(lpDeviceName: string; [out] lpTargetPath: TBytes; ucchMax: DWORD): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'QueryDosDevice')]
function QueryDosDevice(lpDeviceName: IntPtr; [out] lpTargetPath: TBytes; ucchMax: DWORD): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'QueryDosDeviceA')]
function QueryDosDeviceA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'QueryDosDeviceW')]
function QueryDosDeviceW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'QueryPerformanceCounter')]
function QueryPerformanceCounter; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'QueryPerformanceFrequency')]
function QueryPerformanceFrequency; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'QueryRecoveryAgents')]
function QueryRecoveryAgents; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'QueryRecoveryAgentsA')]
function QueryRecoveryAgentsA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'QueryRecoveryAgentsW')]
function QueryRecoveryAgentsW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'QueueUserAPC')]
function QueueUserAPC; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RaiseException')]
procedure RaiseException; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ReadConsole')]
function ReadConsole; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadConsoleA')]
function ReadConsoleA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ReadConsoleW')]
function ReadConsoleW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ReadConsoleInput')]
function ReadConsoleInput; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadConsoleInputA')]
function ReadConsoleInputA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ReadConsoleInputW')]
function ReadConsoleInputW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ReadConsoleOutput')]
function ReadConsoleOutput; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadConsoleOutputA')]
function ReadConsoleOutputA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ReadConsoleOutputW')]
function ReadConsoleOutputW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadConsoleOutputAttribute')]
function ReadConsoleOutputAttribute; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ReadConsoleOutputCharacter')]
function ReadConsoleOutputCharacter; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadConsoleOutputCharacterA')]
function ReadConsoleOutputCharacterA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ReadConsoleOutputCharacterW')]
function ReadConsoleOutputCharacterW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadDirectoryChangesW')]
function ReadDirectoryChanges(hDirectory: THandle; var lpBuffer: TFileNotifyInformation;
  nBufferLength: DWORD; bWatchSubtree: Bool; dwNotifyFilter: DWORD; out lpBytesReturned: DWORD;
  const lpOverlapped: TOverlapped; lpCompletionRoutine: FARPROC): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadDirectoryChangesW')]
function ReadDirectoryChanges(hDirectory: THandle; var lpBuffer: TFileNotifyInformation;
  nBufferLength: DWORD; bWatchSubtree: Bool; dwNotifyFilter: DWORD; out lpBytesReturned: DWORD;
  lpOverlapped: IntPtr; lpCompletionRoutine: FARPROC): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ReadDirectoryChangesW')]
function ReadDirectoryChangesW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadFile')]
function ReadFile(hFile: THandle; [out] Buffer: TBytes; nNumberOfBytesToRead: DWORD;
  out lpNumberOfBytesRead: DWORD; const lpOverlapped: TOverlapped): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadFile')]
function ReadFile(hFile: THandle; [out] Buffer: TBytes; nNumberOfBytesToRead: DWORD;
  lpNumberOfBytesRead: IntPtr; lpOverlapped: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadFile')]
function ReadFile(hFile: THandle; [out] Buffer: TBytes; nNumberOfBytesToRead: DWORD;
  out lpNumberOfBytesRead: DWORD; lpOverlapped: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadFile')]
function ReadFile(hFile: THandle; [out] Buffer: TBytes; nNumberOfBytesToRead: DWORD;
  lpNumberOfBytesRead: IntPtr; const lpOverlapped: TOverlapped): BOOL; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadFileEx')]
function ReadFileEx; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadProcessMemory')]
function ReadProcessMemory; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadRaw')]
function ReadRaw; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReleaseMutex')]
function ReleaseMutex; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReleaseSemaphore')]
function ReleaseSemaphore(hSemaphore: THandle; lReleaseCount: Longint;
  out lpPreviousCount: LongInt): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReleaseSemaphore')]
function ReleaseSemaphore(hSemaphore: THandle; lReleaseCount: Longint;
  lpPreviousCount: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RemoveDirectory')]
function RemoveDirectory; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RemoveDirectoryA')]
function RemoveDirectoryA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RemoveDirectoryW')]
function RemoveDirectoryW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ResetEvent')]
function ResetEvent; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ResumeThread')]
function ResumeThread; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ScrollConsoleScreenBuffer')]
function ScrollConsoleScreenBuffer(hConsoleOutput: THandle;
  const lpScrollRectangle: TSmallRect; const lpClipRectangle: TSmallRect;
  dwDestinationOrigin: TCoord; const lpFill: TCharInfo): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ScrollConsoleScreenBuffer')]
function ScrollConsoleScreenBuffer(hConsoleOutput: THandle;
  const lpScrollRectangle: TSmallRect; lpClipRectangle: IntPtr;
  dwDestinationOrigin: TCoord; const lpFill: TCharInfo): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ScrollConsoleScreenBufferA')]
function ScrollConsoleScreenBufferA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ScrollConsoleScreenBufferW')]
function ScrollConsoleScreenBufferW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SearchPath')]
function SearchPath; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SearchPathA')]
function SearchPathA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SearchPathW')]
function SearchPathW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetCommBreak')]
function SetCommBreak; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetCommConfig')]
function SetCommConfig; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetCommMask')]
function SetCommMask; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetCommState')]
function SetCommState; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetCommTimeouts')]
function SetCommTimeouts; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetComputerName')]
function SetComputerName; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetComputerNameA')]
function SetComputerNameA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetComputerNameW')]
function SetComputerNameW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetConsoleActiveScreenBuffer')]
function SetConsoleActiveScreenBuffer; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetConsoleCP')]
function SetConsoleCP; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetConsoleCtrlHandler')]
function SetConsoleCtrlHandler; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetConsoleCursorInfo')]
function SetConsoleCursorInfo; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetConsoleCursorPosition')]
function SetConsoleCursorPosition; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetConsoleMode')]
function SetConsoleMode; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetConsoleOutputCP')]
function SetConsoleOutputCP; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetConsoleScreenBufferSize')]
function SetConsoleScreenBufferSize; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetConsoleTextAttribute')]
function SetConsoleTextAttribute; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetConsoleTitle')]
function SetConsoleTitle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetConsoleTitleA')]
function SetConsoleTitleA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetConsoleTitleW')]
function SetConsoleTitleW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetConsoleWindowInfo')]
function SetConsoleWindowInfo; external;
{$IFNDEF LINUXCRITSECTION}
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetCriticalSectionSpinCount')]
function SetCriticalSectionSpinCount; external;
{$ENDIF}
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetCurrentDirectory')]
function SetCurrentDirectory; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetCurrentDirectoryA')]
function SetCurrentDirectoryA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetCurrentDirectoryW')]
function SetCurrentDirectoryW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetDefaultCommConfig')]
function SetDefaultCommConfig; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetDefaultCommConfigA')]
function SetDefaultCommConfigA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetDefaultCommConfigW')]
function SetDefaultCommConfigW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetEndOfFile')]
function SetEndOfFile; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetEnvironmentVariable')]
function SetEnvironmentVariable; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetEnvironmentVariableA')]
function SetEnvironmentVariableA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetEnvironmentVariableW')]
function SetEnvironmentVariableW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetErrorMode')]
function SetErrorMode; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetEvent')]
function SetEvent; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFileApisToANSI')]
procedure SetFileApisToANSI; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFileApisToOEM')]
procedure SetFileApisToOEM; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetFileAttributes')]
function SetFileAttributes; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFileAttributesA')]
function SetFileAttributesA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetFileAttributesW')]
function SetFileAttributesW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFilePointer')]
function SetFilePointer(hFile: THandle; lDistanceToMove: Longint;
  [in] var lpDistanceToMoveHigh: LongInt; dwMoveMethod: DWORD): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFilePointer')]
function SetFilePointer(hFile: THandle; lDistanceToMove: Longint;
  lpDistanceToMoveHigh: IntPtr; dwMoveMethod: DWORD): DWORD; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFileTime')]
function SetFileTime(hFile: THandle; const lpCreationTime: TFileTime;
  const lpLastAccessTime: TFileTime; const lpLastWriteTime: TFileTime): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFileTime')]
function SetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  lpLastAccessTime: IntPtr; lpLastWriteTime: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFileTime')]
function SetFileTime(hFile: THandle; const lpCreationTime: TFileTime;
  lpLastAccessTime: IntPtr; lpLastWriteTime: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFileTime')]
function SetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  const lpLastAccessTime: TFileTime; const lpLastWriteTime: TFileTime): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFileTime')]
function SetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  const lpLastAccessTime: TFileTime; lpLastWriteTime: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFileTime')]
function SetFileTime(hFile: THandle; const lpCreationTime: TFileTime;
  lpLastAccessTime: IntPtr; const lpLastWriteTime: TFileTime): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFileTime')]
function SetFileTime(hFile: THandle; lpCreationTime: IntPtr;
  lpLastAccessTime: IntPtr; const lpLastWriteTime: TFileTime): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFileTime')]
function SetFileTime(hFile: THandle; const lpCreationTime: TFileTime;
  const lpLastAccessTime: TFileTime; lpLastWriteTime: IntPtr): BOOL; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetHandleCount')]
function SetHandleCount; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetHandleInformation')]
function SetHandleInformation; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetLastError')]
procedure SetLastError; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetLocalTime')]
function SetLocalTime; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetLocaleInfo')]
function SetLocaleInfo; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetLocaleInfoA')]
function SetLocaleInfoA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetLocaleInfoW')]
function SetLocaleInfoW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetMailslotInfo')]
function SetMailslotInfo; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetNamedPipeHandleState')]
function SetNamedPipeHandleState(hNamedPipe: THandle; [in] var lpMode: DWORD;
  [in] var lpMaxCollectionCount: DWORD; [in] var lpCollectDataTimeout: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetNamedPipeHandleState')]
function SetNamedPipeHandleState(hNamedPipe: THandle; lpMode: IntPtr;
  lpMaxCollectionCount: IntPtr; lpCollectDataTimeout: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetNamedPipeHandleState')]
function SetNamedPipeHandleState(hNamedPipe: THandle; [in] var lpMode: DWORD;
  lpMaxCollectionCount: IntPtr; lpCollectDataTimeout: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetNamedPipeHandleState')]
function SetNamedPipeHandleState(hNamedPipe: THandle; lpMode: IntPtr;
  [in] var lpMaxCollectionCount: DWORD; [in] var lpCollectDataTimeout: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetNamedPipeHandleState')]
function SetNamedPipeHandleState(hNamedPipe: THandle; lpMode: IntPtr;
  [in] var lpMaxCollectionCount: DWORD; lpCollectDataTimeout: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetNamedPipeHandleState')]
function SetNamedPipeHandleState(hNamedPipe: THandle; [in] var lpMode: DWORD;
  lpMaxCollectionCount: IntPtr; [in] var lpCollectDataTimeout: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetNamedPipeHandleState')]
function SetNamedPipeHandleState(hNamedPipe: THandle; lpMode: IntPtr;
  lpMaxCollectionCount: IntPtr; [in] var lpCollectDataTimeout: DWORD): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetNamedPipeHandleState')]
function SetNamedPipeHandleState(hNamedPipe: THandle; [in] var lpMode: DWORD;
  [in] var lpMaxCollectionCount: DWORD; lpCollectDataTimeout: IntPtr): BOOL; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetPriorityClass')]
function SetPriorityClass; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetProcessAffinityMask')]
function SetProcessAffinityMask; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetProcessPriorityBoost')]
function SetProcessPriorityBoost; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetProcessShutdownParameters')]
function SetProcessShutdownParameters; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetProcessWorkingSetSize')]
function SetProcessWorkingSetSize; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetStdHandle')]
function SetStdHandle; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetSystemPowerState')]
function SetSystemPowerState; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetSystemTime')]
function SetSystemTime; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetSystemTimeAdjustment')]
function SetSystemTimeAdjustment; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetTapeParameters')]
function SetTapeParameters; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetTapePosition')]
function SetTapePosition; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetThreadAffinityMask')]
function SetThreadAffinityMask; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetThreadContext')]
function SetThreadContext; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetThreadIdealProcessor')]
function SetThreadIdealProcessor; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetThreadLocale')]
function SetThreadLocale; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetThreadPriority')]
function SetThreadPriority; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetThreadPriorityBoost')]
function SetThreadPriorityBoost; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetTimeZoneInformation')]
function SetTimeZoneInformation; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetUnhandledExceptionFilter')]
function SetUnhandledExceptionFilter; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetVolumeLabel')]
function SetVolumeLabel(lpRootPathName: string; lpVolumeName: string): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetVolumeLabel')]
function SetVolumeLabel(lpRootPathName: IntPtr; lpVolumeName: string): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetVolumeLabel')]
function SetVolumeLabel(lpRootPathName: IntPtr; lpVolumeName: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetVolumeLabel')]
function SetVolumeLabel(lpRootPathName: string; lpVolumeName: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetVolumeLabelA')]
function SetVolumeLabelA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetVolumeLabelW')]
function SetVolumeLabelW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetWaitableTimer')]
function SetWaitableTimer; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetupComm')]
function SetupComm; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SignalObjectAndWait')]
function SignalObjectAndWait; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SizeofResource')]
function SizeofResource; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'Sleep')]
procedure Sleep; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SleepEx')]
function SleepEx; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SuspendThread')]
function SuspendThread; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SwitchToFiber')]
function SwitchToFiber; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SwitchToThread')]
function SwitchToThread; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SystemTimeToFileTime')]
function SystemTimeToFileTime; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SystemTimeToTzSpecificLocalTime')]
function SystemTimeToTzSpecificLocalTime(const lpTimeZoneInformation: TTimeZoneInformation;
  const lpUniversalTime: TSystemTime; out lpLocalTime: TSystemTime): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SystemTimeToTzSpecificLocalTime')]
function SystemTimeToTzSpecificLocalTime(lpTimeZoneInformation: IntPtr;
  const lpUniversalTime: TSystemTime; out lpLocalTime: TSystemTime): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TerminateProcess')]
function TerminateProcess; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TerminateThread')]
function TerminateThread; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TlsAlloc')]
function TlsAlloc; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TlsFree')]
function TlsFree; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TlsGetValue')]
function TlsGetValue; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TlsSetValue')]
function TlsSetValue; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TransactNamedPipe')]
function TransactNamedPipe(hNamedPipe: THandle; [in] lpInBuffer: TBytes;
  nInBufferSize: DWORD; [out] lpOutBuffer: TBytes; nOutBufferSize: DWORD;
  out lpBytesRead: DWORD; const lpOverlapped: TOverlapped): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TransactNamedPipe')]
function TransactNamedPipe(hNamedPipe: THandle; [in] lpInBuffer: TBytes;
  nInBufferSize: DWORD; [out] lpOutBuffer: TBytes; nOutBufferSize: DWORD;
  out lpBytesRead: DWORD; lpOverlapped: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TransmitCommChar')]
function TransmitCommChar; external;
{$IFNDEF LINUXCRITSECTION}
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TryEnterCriticalSection')]
function TryEnterCriticalSection; external;
{$ENDIF}
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'UnhandledExceptionFilter')]
function UnhandledExceptionFilter; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'UnlockFile')]
function UnlockFile; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'UnlockFileEx')]
function UnlockFileEx; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'UnmapViewOfFile')]
function UnmapViewOfFile; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'UpdateResource')]
function UpdateResource; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'UpdateResourceA')]
function UpdateResourceA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'UpdateResourceW')]
function UpdateResourceW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'VerLanguageName')]
function VerLanguageName; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'VerLanguageNameA')]
function VerLanguageNameA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'VerLanguageNameW')]
function VerLanguageNameW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WaitCommEvent')]
function WaitCommEvent(hFile: THandle; out lpEvtMask: DWORD;
  const lpOverlapped: TOverlapped): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WaitCommEvent')]
function WaitCommEvent(hFile: THandle; out lpEvtMask: DWORD;
  lpOverlapped: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WaitForDebugEvent')]
function WaitForDebugEvent; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WaitForMultipleObjects')]
function WaitForMultipleObjects(nCount: DWORD; [in] lpHandles: array of THandle;
  bWaitAll: BOOL; dwMilliseconds: DWORD): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WaitForMultipleObjectsEx')]
function WaitForMultipleObjectsEx(nCount: DWORD; [in] lpHandles: array of THandle;
  bWaitAll: BOOL; dwMilliseconds: DWORD; bAlertable: BOOL): DWORD; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WaitForSingleObject')]
function WaitForSingleObject; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WaitForSingleObjectEx')]
function WaitForSingleObjectEx; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WaitNamedPipe')]
function WaitNamedPipe; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WaitNamedPipeA')]
function WaitNamedPipeA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WaitNamedPipeW')]
function WaitNamedPipeW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WideCharToMultiByte')]
function WideCharToMultiByte(CodePage: UINT; dwFlags: DWORD;
  lpWideCharStr: string; cchWideChar: Integer; lpMultiByteStr: StringBuilder;
  cchMultiByte: Integer; lpDefaultChar: string;
  var lpUsedDefaultChar: BOOL): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WideCharToMultiByte')]
function WideCharToMultiByte(CodePage: UINT; dwFlags: DWORD;
  lpWideCharStr: string; cchWideChar: Integer; lpMultiByteStr: StringBuilder;
  cchMultiByte: Integer; lpDefaultChar: IntPtr;
  lpUsedDefaultChar: IntPtr): Integer; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WinExec')]
function WinExec; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WriteConsole')]
function WriteConsole; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteConsoleA')]
function WriteConsoleA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WriteConsoleW')]
function WriteConsoleW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WriteConsoleInput')]
function WriteConsoleInput; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteConsoleInputA')]
function WriteConsoleInputA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WriteConsoleInputW')]
function WriteConsoleInputW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WriteConsoleOutput')]
function WriteConsoleOutput; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteConsoleOutputA')]
function WriteConsoleOutputA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WriteConsoleOutputW')]
function WriteConsoleOutputW; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteConsoleOutputAttribute')]
function WriteConsoleOutputAttribute; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WriteConsoleOutputCharacter')]
function WriteConsoleOutputCharacter; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteConsoleOutputCharacterA')]
function WriteConsoleOutputCharacterA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WriteConsoleOutputCharacterW')]
function WriteConsoleOutputCharacterW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteFile')]
function WriteFile(hFile: THandle; [in] Buffer: TBytes; nNumberOfBytesToWrite: DWORD;
  out lpNumberOfBytesWritten: DWORD; const lpOverlapped: TOverlapped): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteFile')]
function WriteFile(hFile: THandle; [in] Buffer: TBytes; nNumberOfBytesToWrite: DWORD;
  lpNumberOfBytesWritten: IntPtr; lpOverlapped: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteFile')]
function WriteFile(hFile: THandle; [in] Buffer: TBytes; nNumberOfBytesToWrite: DWORD;
  out lpNumberOfBytesWritten: DWORD; lpOverlapped: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteFile')]
function WriteFile(hFile: THandle; [in] Buffer: TBytes; nNumberOfBytesToWrite: DWORD;
  lpNumberOfBytesWritten: IntPtr; const lpOverlapped: TOverlapped): BOOL; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteFileEx')]
function WriteFileEx; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WritePrivateProfileSection')]
function WritePrivateProfileSection; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WritePrivateProfileSectionA')]
function WritePrivateProfileSectionA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WritePrivateProfileSectionW')]
function WritePrivateProfileSectionW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WritePrivateProfileString')]
function WritePrivateProfileString(lpAppName, lpKeyName, lpString, lpFileName: string): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WritePrivateProfileString')]
function WritePrivateProfileString(lpAppName, lpKeyName: string; lpString: IntPtr; lpFileName: string): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WritePrivateProfileString')]
function WritePrivateProfileString(lpAppName: string; lpKeyName, lpString: IntPtr; lpFileName: string): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WritePrivateProfileString')]
function WritePrivateProfileString(lpAppName, lpKeyName, lpString: IntPtr; lpFileName: string): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WritePrivateProfileStringA')]
function WritePrivateProfileStringA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WritePrivateProfileStringW')]
function WritePrivateProfileStringW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteProcessMemory')]
function WriteProcessMemory; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WriteProfileSection')]
function WriteProfileSection; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteProfileSectionA')]
function WriteProfileSectionA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WriteProfileSectionW')]
function WriteProfileSectionW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WriteProfileString')]
function WriteProfileString(lpAppName, lpKeyName, lpString: string): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WriteProfileString')]
function WriteProfileString(lpAppName: string; lpKeyName, lpString: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WriteProfileString')]
function WriteProfileString(lpAppName: string; lpKeyName: IntPtr; lpString: string): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WriteProfileString')]
function WriteProfileString(lpAppName, lpKeyName: string; lpString: IntPtr): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteProfileStringA')]
function WriteProfileStringA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WriteProfileStringW')]
function WriteProfileStringW; external;

[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteRaw')]
function WriteRaw; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WriteTapemark')]
function WriteTapemark; external;


{ Externals from mpr.dll }

[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'MultinetGetConnectionPerformance')]
function MultinetGetConnectionPerformance; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'MultinetGetConnectionPerformanceA')]
function MultinetGetConnectionPerformanceA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'MultinetGetConnectionPerformanceW')]
function MultinetGetConnectionPerformanceW; external;

[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetAddConnection2')]
function WNetAddConnection2(const lpNetResource: TNetResource;
  lpPassword, lpUserName: string; dwFlags: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetAddConnection2')]
function WNetAddConnection2(const lpNetResource: TNetResource;
  lpPassword: IntPtr; lpUserName: string; dwFlags: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetAddConnection2')]
function WNetAddConnection2(const lpNetResource: TNetResource;
  lpPassword, lpUserName: IntPtr; dwFlags: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetAddConnection2')]
function WNetAddConnection2(const lpNetResource: TNetResource;
  lpPassword: string; lpUserName: IntPtr; dwFlags: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetAddConnection2A')]
function WNetAddConnection2A; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetAddConnection2W')]
function WNetAddConnection2W; external;

[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetAddConnection3')]
function WNetAddConnection3(hwndOwner: HWND; const lpNetResource: TNetResource;
  lpPassword, lpUserName: string; dwFlags: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetAddConnection3')]
function WNetAddConnection3(hwndOwner: HWND; const lpNetResource: TNetResource;
  lpPassword: IntPtr; lpUserName: string; dwFlags: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetAddConnection3')]
function WNetAddConnection3(hwndOwner: HWND; const lpNetResource: TNetResource;
  lpPassword, lpUserName: IntPtr; dwFlags: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetAddConnection3')]
function WNetAddConnection3(hwndOwner: HWND; const lpNetResource: TNetResource;
  lpPassword: string; lpUserName: IntPtr; dwFlags: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetAddConnection3A')]
function WNetAddConnection3A; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetAddConnection3W')]
function WNetAddConnection3W; external;

[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetAddConnection')]
function WNetAddConnection(lpRemoteName, lpPassword, lpLocalName: string): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetAddConnection')]
function WNetAddConnection(lpRemoteName: string; lpPassword: IntPtr; lpLocalName: string): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetAddConnection')]
function WNetAddConnection(lpRemoteName: string; lpPassword, lpLocalName: IntPtr): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetAddConnection')]
function WNetAddConnection(lpRemoteName, lpPassword: string; lpLocalName: IntPtr): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetAddConnectionA')]
function WNetAddConnectionA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetAddConnectionW')]
function WNetAddConnectionW; external;

[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetCancelConnection2')]
function WNetCancelConnection2; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetCancelConnection2A')]
function WNetCancelConnection2A; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetCancelConnection2W')]
function WNetCancelConnection2W; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetCancelConnection')]
function WNetCancelConnection; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetCancelConnectionA')]
function WNetCancelConnectionA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetCancelConnectionW')]
function WNetCancelConnectionW; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetCloseEnum')]
function WNetCloseEnum; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetConnectionDialog1')]
function WNetConnectionDialog1; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetConnectionDialog1A')]
function WNetConnectionDialog1A; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetConnectionDialog1W')]
function WNetConnectionDialog1W; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetConnectionDialog')]
function WNetConnectionDialog; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetDisconnectDialog1')]
function WNetDisconnectDialog1; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetDisconnectDialog1A')]
function WNetDisconnectDialog1A; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetDisconnectDialog1W')]
function WNetDisconnectDialog1W; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetDisconnectDialog')]
function WNetDisconnectDialog; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetEnumResource')]
function WNetEnumResource; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetEnumResourceA')]
function WNetEnumResourceA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetEnumResourceW')]
function WNetEnumResourceW; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetGetConnection')]
function WNetGetConnection; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetGetConnectionA')]
function WNetGetConnectionA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetGetConnectionW')]
function WNetGetConnectionW; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetGetLastError')]
function WNetGetLastError; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetGetLastErrorA')]
function WNetGetLastErrorA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetGetLastErrorW')]
function WNetGetLastErrorW; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetGetNetworkInformation')]
function WNetGetNetworkInformation; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetGetNetworkInformationA')]
function WNetGetNetworkInformationA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetGetNetworkInformationW')]
function WNetGetNetworkInformationW; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetGetProviderName')]
function WNetGetProviderName; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetGetProviderNameA')]
function WNetGetProviderNameA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetGetProviderNameW')]
function WNetGetProviderNameW; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetGetResourceParent')]
function WNetGetResourceParent; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetGetResourceParentA')]
function WNetGetResourceParentA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetGetResourceParentW')]
function WNetGetResourceParentW; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetGetUniversalName')]
function WNetGetUniversalName; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetGetUniversalNameA')]
function WNetGetUniversalNameA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetGetUniversalNameW')]
function WNetGetUniversalNameW; external;

[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetGetUser')]
function WNetGetUser(lpName: string; lpUserName: StringBuilder; var lpnLength: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetGetUser')]
function WNetGetUser(lpName: IntPtr; lpUserName: StringBuilder; var lpnLength: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetGetUserA')]
function WNetGetUserA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetGetUserW')]
function WNetGetUserW; external;

[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetOpenEnum')]
function WNetOpenEnum(dwScope, dwType, dwUsage: DWORD;
  const lpNetResource: TNetResource; out lphEnum: THandle): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetOpenEnum')]
function WNetOpenEnum(dwScope, dwType, dwUsage: DWORD;
  lpNetResource: IntPtr; out lphEnum: THandle): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetOpenEnumA')]
function WNetOpenEnumA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetOpenEnumW')]
function WNetOpenEnumW; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetSetConnection')]
function WNetSetConnection; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetSetConnectionA')]
function WNetSetConnectionA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetSetConnectionW')]
function WNetSetConnectionW; external;

[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetUseConnection')]
function WNetUseConnection(hwndOwner: HWND;
  const lpNetResource: TNetResource; lpUserID: string;
  lpPassword: string; dwFlags: DWORD; lpAccessName: StringBuilder;
  var lpBufferSize: DWORD; out lpResult: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetUseConnection')]
function WNetUseConnection(hwndOwner: HWND;
  const lpNetResource: TNetResource; lpUserID: IntPtr;
  lpPassword: string; dwFlags: DWORD; lpAccessName: StringBuilder;
  var lpBufferSize: DWORD; out lpResult: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetUseConnection')]
function WNetUseConnection(hwndOwner: HWND;
  const lpNetResource: TNetResource; lpUserID: IntPtr;
  lpPassword: IntPtr; dwFlags: DWORD; lpAccessName: StringBuilder;
  var lpBufferSize: DWORD; out lpResult: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WNetUseConnection')]
function WNetUseConnection(hwndOwner: HWND;
  const lpNetResource: TNetResource; lpUserID: string;
  lpPassword: IntPtr; dwFlags: DWORD; lpAccessName: StringBuilder;
  var lpBufferSize: DWORD; out lpResult: DWORD): DWORD; external;
[DllImport(mpr, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WNetUseConnectionA')]
function WNetUseConnectionA; external;
[DllImport(mpr, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WNetUseConnectionW')]
function WNetUseConnectionW; external;


{ Externals from version.dll }

[DllImport(version, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetFileVersionInfo')]
function GetFileVersionInfo; external;
[DllImport(version, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileVersionInfoA')]
function GetFileVersionInfoA; external;
[DllImport(version, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetFileVersionInfoW')]
function GetFileVersionInfoW; external;
[DllImport(version, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetFileVersionInfoSize')]
function GetFileVersionInfoSize; external;
[DllImport(version, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFileVersionInfoSizeA')]
function GetFileVersionInfoSizeA; external;
[DllImport(version, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetFileVersionInfoSizeW')]
function GetFileVersionInfoSizeW; external;
[DllImport(version, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'VerFindFile')]
function VerFindFile; external;
[DllImport(version, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'VerFindFileA')]
function VerFindFileA; external;
[DllImport(version, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'VerFindFileW')]
function VerFindFileW; external;
[DllImport(version, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'VerInstallFile')]
function VerInstallFile; external;
[DllImport(version, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'VerInstallFileA')]
function VerInstallFileA; external;
[DllImport(version, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'VerInstallFileW')]
function VerInstallFileW; external;
[DllImport(version, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'VerQueryValue')]
function VerQueryValue; external;
[DllImport(version, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'VerQueryValueA')]
function VerQueryValueA; external;
[DllImport(version, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'VerQueryValueW')]
function VerQueryValueW; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrivateProfileStruct')]
function GetPrivateProfileStruct; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPrivateProfileStructA')]
function GetPrivateProfileStructA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetPrivateProfileStructW')]
function GetPrivateProfileStructW; external;

[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WritePrivateProfileStruct')]
function WritePrivateProfileStruct(lpszSection: string; lpszKey: string;
  [in] lpStruct: TBytes; uSizeStruct: UINT; szFile: string): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'WritePrivateProfileStruct')]
function WritePrivateProfileStruct(lpszSection: string; lpszKey: IntPtr;
  [in] lpStruct: TBytes; uSizeStruct: UINT; szFile: string): BOOL; external;
[DllImport(kernel32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WritePrivateProfileStructA')]
function WritePrivateProfileStructA; external;
[DllImport(kernel32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WritePrivateProfileStructW')]
function WritePrivateProfileStructW; external;

{ Externals from gdi32.dll }

[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AbortDoc')]
function AbortDoc; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AbortPath')]
function AbortPath; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddFontMemResourceEx')]
function AddFontMemResourceEx; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddFontResource')]
function AddFontResource; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddFontResourceA')]
function AddFontResourceA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AddFontResourceW')]
function AddFontResourceW; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddFontResourceEx')]
function AddFontResourceEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddFontResourceExA')]
function AddFontResourceExA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AddFontResourceExW')]
function AddFontResourceExW; external;
[DllImport(msimg32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AlphaBlend')]
function AlphaBlend; external;
[DllImport(msimg32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AlphaDIBBlend')]
function AlphaDIBBlend; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AngleArc')]
function AngleArc; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AnimatePalette')]
function AnimatePalette; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'Arc')]
function Arc; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ArcTo')]
function ArcTo; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BeginPath')]
function BeginPath; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BitBlt')]
function BitBlt; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CancelDC')]
function CancelDC; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CheckColorsInGamut')]
function CheckColorsInGamut; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ChoosePixelFormat')]
function ChoosePixelFormat; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'Chord')]
function Chord; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CloseEnhMetaFile')]
function CloseEnhMetaFile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CloseFigure')]
function CloseFigure; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CloseMetaFile')]
function CloseMetaFile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ColorCorrectPalette')]
function ColorCorrectPalette; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ColorMatchToTarget')]
function ColorMatchToTarget; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CombineRgn')]
function CombineRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CombineTransform')]
function CombineTransform; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CopyEnhMetaFile')]
function CopyEnhMetaFile(Handle: HENHMETAFILE; p2: string): HENHMETAFILE; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CopyEnhMetaFile')]
function CopyEnhMetaFile(Handle: HENHMETAFILE; p2: IntPtr): HENHMETAFILE; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CopyEnhMetaFileA')]
function CopyEnhMetaFileA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CopyEnhMetaFileW')]
function CopyEnhMetaFileW; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CopyMetaFile')]
function CopyMetaFile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CopyMetaFileA')]
function CopyMetaFileA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CopyMetaFileW')]
function CopyMetaFileW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateBitmap')]
function CreateBitmap; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateBitmapIndirect')]
function CreateBitmapIndirect; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateBrushIndirect')]
function CreateBrushIndirect; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateColorSpace')]
function CreateColorSpace; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateColorSpaceA')]
function CreateColorSpaceA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateColorSpaceW')]
function CreateColorSpaceW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateCompatibleBitmap')]
function CreateCompatibleBitmap; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateCompatibleDC')]
function CreateCompatibleDC; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDC')]
function CreateDC(lpszDriver, lpszDevice: string; lpszOutput: IntPtr;
  const lpdvmInit: TDeviceMode): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDC')]
function CreateDC(lpszDriver: string; lpszDevice, lpszOutput: IntPtr;
  const lpdvmInit: TDeviceMode): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDC')]
function CreateDC(lpszDriver: IntPtr; lpszDevice: string; lpszOutput: IntPtr;
  const lpdvmInit: TDeviceMode): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDC')]
function CreateDC(lpszDriver, lpszDevice, lpszOutput: IntPtr;
  const lpdvmInit: TDeviceMode): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDC')]
function CreateDC(lpszDriver, lpszDevice: string; lpszOutput: IntPtr;
  lpdvmInit: IntPtr): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDC')]
function CreateDC(lpszDriver: string; lpszDevice, lpszOutput: IntPtr;
  lpdvmInit: IntPtr): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDC')]
function CreateDC(lpszDriver: IntPtr; lpszDevice: string; lpszOutput: IntPtr;
  lpdvmInit: IntPtr): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDC')]
function CreateDC(lpszDriver, lpszDevice, lpszOutput: IntPtr;
  lpdvmInit: IntPtr): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateDCA')]
function CreateDCA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateDCW')]
function CreateDCW; external;

[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateDIBPatternBrush')]
function CreateDIBPatternBrush; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateDIBPatternBrushPt')]
function CreateDIBPatternBrushPt; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateDIBSection')]
function CreateDIBSection; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateDIBitmap')]
function CreateDIBitmap; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateDiscardableBitmap')]
function CreateDiscardableBitmap; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateEllipticRgn')]
function CreateEllipticRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateEllipticRgnIndirect')]
function CreateEllipticRgnIndirect; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateEnhMetaFile')]
function CreateEnhMetaFile(DC: HDC; FileName: string; const Rect: TRect; Desc: string): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateEnhMetaFile')]
function CreateEnhMetaFile(DC: HDC; FileName: IntPtr; const Rect: TRect; Desc: string): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateEnhMetaFile')]
function CreateEnhMetaFile(DC: HDC; FileName: IntPtr; const Rect: TRect; Desc: IntPtr): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateEnhMetaFile')]
function CreateEnhMetaFile(DC: HDC; FileName: IntPtr; const Rect: TRect; Desc: StringBuilder): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateEnhMetaFileA')]
function CreateEnhMetaFileA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateEnhMetaFileW')]
function CreateEnhMetaFileW; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateFont')]
function CreateFont; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateFontA')]
function CreateFontA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateFontW')]
function CreateFontW; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateFontIndirect')]
function CreateFontIndirect; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateFontIndirectA')]
function CreateFontIndirectA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateFontIndirectW')]
function CreateFontIndirectW; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateFontIndirectEx')]
function CreateFontIndirectEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateFontIndirectExA')]
function CreateFontIndirectExA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateFontIndirectExW')]
function CreateFontIndirectExW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateHalftonePalette')]
function CreateHalftonePalette; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateHatchBrush')]
function CreateHatchBrush; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateIC')]
function CreateIC(lpszDriver: string; lpszDevice: string;
  lpszOutput: IntPtr; const lpdvmInit: TDeviceMode): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateIC')]
function CreateIC(lpszDriver: IntPtr; lpszDevice: string;
  lpszOutput: IntPtr; const lpdvmInit: TDeviceMode): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateIC')]
function CreateIC(lpszDriver: IntPtr; lpszDevice: IntPtr;
  lpszOutput: IntPtr; lpdvmInit: IntPtr): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateIC')]
function CreateIC(lpszDriver: string; lpszDevice: IntPtr;
  lpszOutput: IntPtr; lpdvmInit: IntPtr): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateIC')]
function CreateIC(lpszDriver: string; lpszDevice: IntPtr;
  lpszOutput: IntPtr; const lpdvmInit: TDeviceMode): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateIC')]
function CreateIC(lpszDriver: IntPtr; lpszDevice: string;
  lpszOutput: IntPtr; lpdvmInit: IntPtr): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateIC')]
function CreateIC(lpszDriver: string; lpszDevice: string;
  lpszOutput: IntPtr; lpdvmInit: IntPtr): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateIC')]
function CreateIC(lpszDriver: IntPtr; lpszDevice: IntPtr;
  lpszOutput: IntPtr; const lpdvmInit: TDeviceMode): HDC; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateICA')]
function CreateICA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateICW')]
function CreateICW; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateMetaFile')]
function CreateMetaFile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateMetaFileA')]
function CreateMetaFileA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateMetaFileW')]
function CreateMetaFileW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreatePalette')]
function CreatePalette(const LogPalette: TLogPalette): HPalette; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreatePalette')]
function CreatePalette(const LogPalette: TMaxLogPalette): HPalette; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreatePatternBrush')]
function CreatePatternBrush; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreatePen')]
function CreatePen; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreatePenIndirect')]
function CreatePenIndirect; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreatePolyPolygonRgn')]
function CreatePolyPolygonRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreatePolygonRgn')]
function CreatePolygonRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateRectRgn')]
function CreateRectRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateRectRgnIndirect')]
function CreateRectRgnIndirect; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateRoundRectRgn')]
function CreateRoundRectRgn; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateScalableFontResource')]
function CreateScalableFontResource; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateScalableFontResourceA')]
function CreateScalableFontResourceA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateScalableFontResourceW')]
function CreateScalableFontResourceW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateSolidBrush')]
function CreateSolidBrush; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DPtoLP')]
function DPtoLP; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteColorSpace')]
function DeleteColorSpace; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteDC')]
function DeleteDC; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteEnhMetaFile')]
function DeleteEnhMetaFile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteMetaFile')]
function DeleteMetaFile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteObject')]
function DeleteObject; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DescribePixelFormat')]
function DescribePixelFormat; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeviceCapabilities')]
function DeviceCapabilities(pDriverName, pDeviceName, pPort: string;
  iIndex: Integer; pOutput: IntPtr; const DevMode: TDeviceMode): Integer; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeviceCapabilities')]
function DeviceCapabilities(pDriverName, pDeviceName, pPort: string;
  iIndex: Integer; pOutput: IntPtr; DevMode: IntPtr): Integer; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeviceCapabilitiesA')]
function DeviceCapabilitiesA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DeviceCapabilitiesW')]
function DeviceCapabilitiesW; external;

{[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeviceCapabilitiesEx')]
function DeviceCapabilitiesEx; external;}
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawEscape')]
function DrawEscape(DC: HDC; nEscape, cbInput: Integer; [in] lpszInData: array of Byte): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawEscape')]
function DrawEscape(DC: HDC; nEscape, cbInput: Integer; lpszInData: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'Ellipse')]
function Ellipse; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EndDoc')]
function EndDoc; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EndPage')]
function EndPage; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EndPath')]
function EndPath; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumEnhMetaFile')]
function EnumEnhMetaFile; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumFontFamilies')]
function EnumFontFamilies(DC: HDC; p2: string; p3: TFNFontEnumProc; p4: LPARAM): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumFontFamilies')]
function EnumFontFamilies(DC: HDC; p2: IntPtr; p3: TFNFontEnumProc; p4: LPARAM): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumFontFamiliesA')]
function EnumFontFamiliesA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumFontFamiliesW')]
function EnumFontFamiliesW; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumFontFamiliesEx')]
function EnumFontFamiliesEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumFontFamiliesExA')]
function EnumFontFamiliesExA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumFontFamiliesExW')]
function EnumFontFamiliesExW; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumFonts')]
function EnumFonts(DC: HDC; lpszFace: string; fntenmprc: TFNFontEnumProc;
  LParam: Longint): Integer; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumFonts')]
function EnumFonts(DC: HDC; lpszFace: IntPtr; fntenmprc: TFNFontEnumProc;
  LParam: Longint): Integer; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumFontsA')]
function EnumFontsA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumFontsW')]
function EnumFontsW; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumICMProfiles')]
function EnumICMProfiles; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumICMProfilesA')]
function EnumICMProfilesA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumICMProfilesW')]
function EnumICMProfilesW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumMetaFile')]
function EnumMetaFile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumObjects')]
function EnumObjects; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EqualRgn')]
function EqualRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'Escape')]
function Escape; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExcludeClipRect')]
function ExcludeClipRect; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExtCreatePen')]
function ExtCreatePen(PenStyle, Width: DWORD; const Brush: TLogBrush;
  StyleCount: DWORD; [in] Style: array of DWORD): HPEN; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExtCreatePen')]
function ExtCreatePen(PenStyle, Width: DWORD; const Brush: TLogBrush;
  StyleCount: DWORD; Style: IntPtr): HPEN; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExtCreateRegion')]
function ExtCreateRegion(const XForm: TXForm; Count: DWORD; RgnData: IntPtr): HRGN; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExtCreateRegion')]
function ExtCreateRegion(XForm: IntPtr; Count: DWORD; RgnData: IntPtr): HRGN; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExtEscape')]
function ExtEscape; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExtFloodFill')]
function ExtFloodFill; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExtSelectClipRgn')]
function ExtSelectClipRgn; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ExtTextOut')]
function ExtTextOut(DC: HDC; X, Y: Integer; Options: Longint;
  const Rect: TRect; Str: string; Count: Longint; [in] Dx: TIntegerDynArray): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ExtTextOut')]
function ExtTextOut(DC: HDC; X, Y: Integer; Options: Longint;
  Rect: IntPtr; Str: string; Count: Longint; [in] Dx: TIntegerDynArray): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ExtTextOut')]
function ExtTextOut(DC: HDC; X, Y: Integer; Options: Longint;
  const Rect: TRect; Str: IntPtr; Count: Longint; Dx: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExtTextOutA')]
function ExtTextOutA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ExtTextOutW')]
function ExtTextOutW; external;

[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FillPath')]
function FillPath; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FillRgn')]
function FillRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlattenPath')]
function FlattenPath; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FloodFill')]
function FloodFill; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FrameRgn')]
function FrameRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GdiComment')]
function GdiComment; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GdiFlush')]
function GdiFlush; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GdiGetBatchLimit')]
function GdiGetBatchLimit; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GdiSetBatchLimit')]
function GdiSetBatchLimit; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetArcDirection')]
function GetArcDirection; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetAspectRatioFilterEx')]
function GetAspectRatioFilterEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetBitmapBits')]
function GetBitmapBits(Bitmap: HBITMAP; Count: Longint; [out] Bits: array of Byte): Longint; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetBitmapBits')]
function GetBitmapBits(Bitmap: HBITMAP; Count: Longint; Bits: IntPtr): Longint; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetBitmapDimensionEx')]
function GetBitmapDimensionEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetBkColor')]
function GetBkColor; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetBkMode')]
function GetBkMode; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetBoundsRect')]
function GetBoundsRect; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetBrushOrgEx')]
function GetBrushOrgEx; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCharABCWidths')]
function GetCharABCWidths; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCharABCWidthsA')]
function GetCharABCWidthsA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetCharABCWidthsW')]
function GetCharABCWidthsW; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCharABCWidthsI')]
function GetCharABCWidthsI(DC: HDC; p2, p3: UINT;
  [in] p4: array of Word; [out] Widths: array of TABC): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCharABCWidthsI')]
function GetCharABCWidthsI(DC: HDC; p2, p3: UINT;
  p4: IntPtr; [out] Widths: array of TABC): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCharABCWidthsFloat')]
function GetCharABCWidthsFloat; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCharABCWidthsFloatA')]
function GetCharABCWidthsFloatA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetCharABCWidthsFloatW')]
function GetCharABCWidthsFloatW; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCharWidth32')]
function GetCharWidth32; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCharWidth32A')]
function GetCharWidth32A; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetCharWidth32W')]
function GetCharWidth32W; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCharWidth')]
function GetCharWidth; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCharWidthA')]
function GetCharWidthA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetCharWidthW')]
function GetCharWidthW; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCharWidthFloat')]
function GetCharWidthFloat; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCharWidthFloatA')]
function GetCharWidthFloatA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetCharWidthFloatW')]
function GetCharWidthFloatW; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCharWidthI')]
function GetCharWidthI(DC: HDC; p2, p3: UINT;
  [in] p4: array of Word; [out] Widths: TIntegerDynArray): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCharWidthI')]
function GetCharWidthI(DC: HDC; p2, p3: UINT;
  p4: IntPtr; [out] Widths: TIntegerDynArray): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetCharacterPlacement')]
function GetCharacterPlacement; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCharacterPlacementA')]
function GetCharacterPlacementA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetCharacterPlacementW')]
function GetCharacterPlacementW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClipBox')]
function GetClipBox; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClipRgn')]
function GetClipRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetColorAdjustment')]
function GetColorAdjustment; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetColorSpace')]
function GetColorSpace; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCurrentObject')]
function GetCurrentObject; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCurrentPositionEx')]
function GetCurrentPositionEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDCBrushColor')]
function GetDCBrushColor; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDCPenColor')]
function GetDCPenColor; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDCOrgEx')]
function GetDCOrgEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDIBColorTable')]
function GetDIBColorTable; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDIBits')]
function GetDIBits(DC: HDC; Bitmap: HBitmap; StartScan, NumScans: UINT;
  [out] Bits: array of Byte; BitInfo: IntPtr; Usage: UINT): Integer; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDIBits')]
function GetDIBits(DC: HDC; Bitmap: HBitmap; StartScan, NumScans: UINT;
  Bits: IntPtr; var BitInfo: TBitmapInfo; Usage: UINT): Integer; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDeviceCaps')]
function GetDeviceCaps; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDeviceGammaRamp')]
function GetDeviceGammaRamp; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetEnhMetaFile')]
function GetEnhMetaFile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetEnhMetaFileA')]
function GetEnhMetaFileA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetEnhMetaFileW')]
function GetEnhMetaFileW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetEnhMetaFileBits')]
function GetEnhMetaFileBits(Handle: HENHMETAFILE; Size: Cardinal;
  [out] p3: array of Byte): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetEnhMetaFileBits')]
function GetEnhMetaFileBits(Handle: HENHMETAFILE; Size: Cardinal;
  p3: IntPtr): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetEnhMetaFileDescription')]
function GetEnhMetaFileDescription(Handle: HENHMETAFILE; Size: Cardinal; [out] p3: TBytes): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetEnhMetaFileDescription')]
function GetEnhMetaFileDescription(Handle: HENHMETAFILE; Size: Cardinal; p3: StringBuilder): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetEnhMetaFileDescriptionA')]
function GetEnhMetaFileDescriptionA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetEnhMetaFileDescriptionW')]
function GetEnhMetaFileDescriptionW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetEnhMetaFileHeader')]
function GetEnhMetaFileHeader(Handle: HENHMETAFILE; Size: Cardinal;
  out p3: TEnhMetaHeader): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetEnhMetaFileHeader')]
function GetEnhMetaFileHeader(Handle: HENHMETAFILE; Size: Cardinal;
  p3: IntPtr): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetEnhMetaFilePaletteEntries')]
function GetEnhMetaFilePaletteEntries(Handle: HENHMETAFILE;
  Size: Cardinal; [out] p3: array of TPaletteEntry): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetEnhMetaFilePaletteEntries')]
function GetEnhMetaFilePaletteEntries(Handle: HENHMETAFILE;
  Size: Cardinal; [out] p3: array of ColorRef): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetEnhMetaFilePaletteEntries')]
function GetEnhMetaFilePaletteEntries(Handle: HENHMETAFILE;
  Size: Cardinal; p3: IntPtr): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetEnhMetaFilePixelFormat')]
function GetEnhMetaFilePixelFormat; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFontData')]
function GetFontData(DC: HDC; p2, p3: DWORD; [out] p4: array of Byte; p5: DWORD): DWORD; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFontData')]
function GetFontData(DC: HDC; p2, p3: DWORD; p4: IntPtr; p5: DWORD): DWORD; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFontLanguageInfo')]
function GetFontLanguageInfo; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFontUnicodeRanges')]
function GetFontUnicodeRanges(DC: HDC; out lpgs: TGlyphSet): DWORD; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFontUnicodeRanges')]
function GetFontUnicodeRanges(DC: HDC; lpgs: IntPtr): DWORD; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetGlyphIndices')]
function GetGlyphIndices; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetGlyphIndicesA')]
function GetGlyphIndicesA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetGlyphIndicesW')]
function GetGlyphIndicesW; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetGlyphOutline')]
function GetGlyphOutline(DC: HDC; uChar, uFormat: UINT;
  out lpgm: TGlyphMetrics; cbBuffer: DWORD; [out] lpvBuffer: array of Byte;
  const lpmat2: TMat2): DWORD; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetGlyphOutline')]
function GetGlyphOutline(DC: HDC; uChar, uFormat: UINT;
  out lpgm: TGlyphMetrics; cbBuffer: DWORD; lpvBuffer: IntPtr;
  const lpmat2: TMat2): DWORD; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetGlyphOutlineA')]
function GetGlyphOutlineA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetGlyphOutlineW')]
function GetGlyphOutlineW; external;

[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetGraphicsMode')]
function GetGraphicsMode; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetICMProfile')]
function GetICMProfile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetICMProfileA')]
function GetICMProfileA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetICMProfileW')]
function GetICMProfileW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetKerningPairs')]
function GetKerningPairs(DC: HDC; Count: DWORD; [out] KerningPairs: array of TKerningPair): DWORD; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetKerningPairs')]
function GetKerningPairs(DC: HDC; Count: DWORD; KerningPairs: IntPtr): DWORD; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetLogColorSpace')]
function GetLogColorSpace; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetLogColorSpaceA')]
function GetLogColorSpaceA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetLogColorSpaceW')]
function GetLogColorSpaceW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMapMode')]
function GetMapMode; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetMetaFile')]
function GetMetaFile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMetaFileA')]
function GetMetaFileA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetMetaFileW')]
function GetMetaFileW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMetaFileBitsEx')]
function GetMetaFileBitsEx(p1: HMETAFILE; Size: Cardinal;
  [out] p3: array of Byte): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMetaFileBitsEx')]
function GetMetaFileBitsEx(p1: HMETAFILE; Size: Cardinal;
  p3: IntPtr): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMetaRgn')]
function GetMetaRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetMiterLimit')]
function GetMiterLimit; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNearestColor')]
function GetNearestColor; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetNearestPaletteIndex')]
function GetNearestPaletteIndex; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetObject')]
function GetObject(Handle: HGDIOBJ; cbBuffer: Integer; out lpvObject: TLogFont): Integer; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetObject')]
function GetObject(Handle: HGDIOBJ; cbBuffer: Integer; out lpvObject: TBitmap): Integer; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetObject')]
function GetObject(Handle: HGDIOBJ; cbBuffer: Integer; out lpvObject: TDIBSection): Integer; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetObject')]
function GetObject(Handle: HGDIOBJ; cbBuffer: Integer; out lpvObject: Integer): Integer; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetObject')]
function GetObject(Handle: HGDIOBJ; cbBuffer: Integer; lpvObject: IntPtr): Integer; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetObjectA')]
function GetObjectA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetObjectW')]
function GetObjectW; external;

[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetObjectType')]
function GetObjectType; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetOutlineTextMetrics')]
function GetOutlineTextMetrics(DC: HDC; Size: Cardinal;
  [out] OTMetricStructs: array of TOutlineTextMetric): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetOutlineTextMetrics')]
function GetOutlineTextMetrics(DC: HDC; Size: Cardinal;
  OTMetricStructs: IntPtr): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetOutlineTextMetricsA')]
function GetOutlineTextMetricsA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetOutlineTextMetricsW')]
function GetOutlineTextMetricsW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPaletteEntries')]
function GetPaletteEntries(Palette: HPALETTE; StartIndex, NumEntries: UINT;
  [out] PaletteEntries: array of ColorRef): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPaletteEntries')]
function GetPaletteEntries(Palette: HPALETTE; StartIndex, NumEntries: UINT;
  [out] PaletteEntries: array of TPaletteEntry): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPath')]
function GetPath; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPixel')]
function GetPixel; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPixelFormat')]
function GetPixelFormat; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPolyFillMode')]
function GetPolyFillMode; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetROP2')]
function GetROP2; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetRasterizerCaps')]
function GetRasterizerCaps; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetRegionData')]
function GetRegionData(RGN: HRGN; p2: DWORD; out p3: TRgnData): DWORD; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetRegionData')]
function GetRegionData(RGN: HRGN; p2: DWORD; p3: IntPtr): DWORD; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetRgnBox')]
function GetRgnBox; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetStockObject')]
function GetStockObject; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetStretchBltMode')]
function GetStretchBltMode; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetSystemPaletteEntries')]
function GetSystemPaletteEntries(DC: HDC; StartIndex, NumEntries: UINT;
  [out] PaletteEntries: array of ColorRef): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetSystemPaletteEntries')]
function GetSystemPaletteEntries(DC: HDC; StartIndex, NumEntries: UINT;
  PaletteEntries: IntPtr): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetSystemPaletteUse')]
function GetSystemPaletteUse; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTextAlign')]
function GetTextAlign; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTextCharacterExtra')]
function GetTextCharacterExtra; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTextCharset')]
function GetTextCharset; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTextCharsetInfo')]
function GetTextCharsetInfo(hdc: HDC; out lpSig: TFontSignature;
  dwFlags: DWORD): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTextCharsetInfo')]
function GetTextCharsetInfo(hdc: HDC; lpSig: IntPtr;
  dwFlags: DWORD): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTextColor')]
function GetTextColor; external;

[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTextExtentExPoint')]
function GetTextExtentExPoint(DC: HDC; p2: string; p3, p4: Integer; out p5: Integer;
  out p6: Integer; out p7: TSize): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTextExtentExPoint')]
function GetTextExtentExPoint(DC: HDC; p2: string; p3, p4: Integer; p5: IntPtr;
  p6: IntPtr; out p7: TSize): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTextExtentExPoint')]
function GetTextExtentExPoint(DC: HDC; p2: string; p3, p4: Integer; out p5: Integer;
  p6: IntPtr; out p7: TSize): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTextExtentExPoint')]
function GetTextExtentExPoint(DC: HDC; p2: string; p3, p4: Integer; p5: IntPtr;
  out p6: Integer; out p7: TSize): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTextExtentExPointA')]
function GetTextExtentExPointA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetTextExtentExPointW')]
function GetTextExtentExPointW; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTextExtentExPointI')]
function GetTextExtentExPointI(DC: HDC; [in] p2: TWordDynArray; p3, p4: Integer;
  p5, p6: IntPtr; out p7: TSize): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTextExtentExPointI')]
function GetTextExtentExPointI(DC: HDC; [in] p2: TWordDynArray; p3, p4: Integer;
  out p5: Integer; [out] p6: TIntegerDynArray; out p7: TSize): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTextExtentPoint32')]
function GetTextExtentPoint32; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTextExtentPoint32A')]
function GetTextExtentPoint32A; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetTextExtentPoint32W')]
function GetTextExtentPoint32W; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTextExtentPoint')]
function GetTextExtentPoint; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTextExtentPointA')]
function GetTextExtentPointA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetTextExtentPointW')]
function GetTextExtentPointW; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTextExtentPointI')]
function GetTextExtentPointI; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTextFace')]
function GetTextFace; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTextFaceA')]
function GetTextFaceA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetTextFaceW')]
function GetTextFaceW; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetTextMetrics')]
function GetTextMetrics; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetTextMetricsA')]
function GetTextMetricsA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetTextMetricsW')]
function GetTextMetricsW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetViewportExtEx')]
function GetViewportExtEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetViewportOrgEx')]
function GetViewportOrgEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetWinMetaFileBits')]
function GetWinMetaFileBits(Handle: HENHMETAFILE; Size: Cardinal;
  [out] p3: array of Byte; p4: Integer; p5: HDC): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetWinMetaFileBits')]
function GetWinMetaFileBits(Handle: HENHMETAFILE; Size: Cardinal;
  p3: IntPtr; p4: Integer; p5: HDC): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetWindowExtEx')]
function GetWindowExtEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetWindowOrgEx')]
function GetWindowOrgEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetWorldTransform')]
function GetWorldTransform; external;
[DllImport(msimg32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GradientFill')]
function GradientFill(DC: HDC; [in] Vertex: array of TTriVertex; NumVertex: ULONG;
  const Mesh: TGradientTriangle; NumMesh, Mode: ULONG): BOOL; external;
[DllImport(msimg32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GradientFill')]
function GradientFill(DC: HDC; [in] Vertex: array of TTriVertex; NumVertex: ULONG;
  const Mesh: TGradientRect; NumMesh, Mode: ULONG): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'IntersectClipRect')]
function IntersectClipRect; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InvertRgn')]
function InvertRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LPtoDP')]
function LPtoDP; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LineDDA')]
function LineDDA; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LineTo')]
function LineTo; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'MaskBlt')]
function MaskBlt; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ModifyWorldTransform')]
function ModifyWorldTransform; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'MoveToEx')]
function MoveToEx(DC: HDC; X, Y: Integer; out lpPoint: TPoint): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'MoveToEx')]
function MoveToEx(DC: HDC; X, Y: Integer; lpPoint: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OffsetClipRgn')]
function OffsetClipRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OffsetRgn')]
function OffsetRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OffsetViewportOrgEx')]
function OffsetViewportOrgEx(DC: HDC; X, Y: Integer; out Point: TPoint): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OffsetViewportOrgEx')]
function OffsetViewportOrgEx(DC: HDC; X, Y: Integer; Point: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OffsetWindowOrgEx')]
function OffsetWindowOrgEx(DC: HDC; X, Y: Integer; out Point: TPoint): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OffsetWindowOrgEx')]
function OffsetWindowOrgEx(DC: HDC; X, Y: Integer; Point: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PaintRgn')]
function PaintRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PatBlt')]
function PatBlt; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PathToRegion')]
function PathToRegion; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'Pie')]
function Pie; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PlayEnhMetaFile')]
function PlayEnhMetaFile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PlayEnhMetaFileRecord')]
function PlayEnhMetaFileRecord; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PlayMetaFile')]
function PlayMetaFile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PlayMetaFileRecord')]
function PlayMetaFileRecord; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PlgBlt')]
function PlgBlt; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PolyBezier')]
function PolyBezier; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PolyBezierTo')]
function PolyBezierTo; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PolyDraw')]
function PolyDraw; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PolyPolygon')]
function PolyPolygon; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PolyPolyline')]
function PolyPolyline; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'PolyTextOut')]
function PolyTextOut; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PolyTextOutA')]
function PolyTextOutA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'PolyTextOutW')]
function PolyTextOutW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'Polygon')]
function Polygon; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'Polyline')]
function Polyline; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PolylineTo')]
function PolylineTo; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PtInRegion')]
function PtInRegion; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PtVisible')]
function PtVisible; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RealizePalette')]
function RealizePalette; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RectInRegion')]
function RectInRegion; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RectVisible')]
function RectVisible; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'Rectangle')]
function Rectangle; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RemoveFontMemResourceEx')]
function RemoveFontMemResourceEx; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RemoveFontResource')]
function RemoveFontResource; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RemoveFontResourceA')]
function RemoveFontResourceA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RemoveFontResourceW')]
function RemoveFontResourceW; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RemoveFontResourceEx')]
function RemoveFontResourceEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RemoveFontResourceExA')]
function RemoveFontResourceExA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RemoveFontResourceExW')]
function RemoveFontResourceExW; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ResetDC')]
function ResetDC; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ResetDCA')]
function ResetDCA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ResetDCW')]
function ResetDCW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ResizePalette')]
function ResizePalette; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RestoreDC')]
function RestoreDC; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RoundRect')]
function RoundRect; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SaveDC')]
function SaveDC; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ScaleViewportExtEx')]
function ScaleViewportExtEx(DC: HDC; XM, XD, YM, YD: Integer; out Size: TSize): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ScaleViewportExtEx')]
function ScaleViewportExtEx(DC: HDC; XM, XD, YM, YD: Integer; Size: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ScaleWindowExtEx')]
function ScaleWindowExtEx(DC: HDC; XM, XD, YM, YD: Integer; out Size: TSize): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ScaleWindowExtEx')]
function ScaleWindowExtEx(DC: HDC; XM, XD, YM, YD: Integer; Size: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SelectClipPath')]
function SelectClipPath; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SelectClipRgn')]
function SelectClipRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SelectObject')]
function SelectObject; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SelectPalette')]
function SelectPalette; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetAbortProc')]
function SetAbortProc; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetArcDirection')]
function SetArcDirection; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetBitmapBits')]
function SetBitmapBits; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetBitmapDimensionEx')]
function SetBitmapDimensionEx(hBitmap: HBITMAP; Width, Height: Integer; out Size: TSize): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetBitmapDimensionEx')]
function SetBitmapDimensionEx(hBitmap: HBITMAP; Width, Height: Integer; Size: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetBkColor')]
function SetBkColor; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetBkMode')]
function SetBkMode; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetBoundsRect')]
function SetBoundsRect(DC: HDC; const p2: TRect; p3: UINT): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetBoundsRect')]
function SetBoundsRect(DC: HDC; p2: IntPtr; p3: UINT): UINT; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetBrushOrgEx')]
function SetBrushOrgEx(DC: HDC; X, Y: Integer; out PrevPt: TPoint): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetBrushOrgEx')]
function SetBrushOrgEx(DC: HDC; X, Y: Integer; PrevPt: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetColorAdjustment')]
function SetColorAdjustment; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetColorSpace')]
function SetColorSpace; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetDCBrushColor')]
function SetDCBrushColor; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetDCPenColor')]
function SetDCPenColor; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetDIBColorTable')]
function SetDIBColorTable; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetDIBits')]
function SetDIBits; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetDIBitsToDevice')]
function SetDIBitsToDevice; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetDeviceGammaRamp')]
function SetDeviceGammaRamp; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetEnhMetaFileBits')]
function SetEnhMetaFileBits([in] p1: UINT; p2: TBytes): HENHMETAFILE; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetEnhMetaFileBits')]
function SetEnhMetaFileBits(p1: UINT; p2: IntPtr): HENHMETAFILE; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetGraphicsMode')]
function SetGraphicsMode; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetICMMode')]
function SetICMMode; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetICMProfile')]
function SetICMProfile; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetICMProfileA')]
function SetICMProfileA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetICMProfileW')]
function SetICMProfileW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetMapMode')]
function SetMapMode; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetMapperFlags')]
function SetMapperFlags; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetMetaFileBitsEx')]
function SetMetaFileBitsEx; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetMetaRgn')]
function SetMetaRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetMiterLimit')]
function SetMiterLimit(DC: HDC; NewLimit: Single; out OldLimit: Single): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetMiterLimit')]
function SetMiterLimit(DC: HDC; NewLimit: Single; OldLimit: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetPaletteEntries')]
function SetPaletteEntries; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetPixel')]
function SetPixel; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetPixelFormat')]
function SetPixelFormat; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetPixelV')]
function SetPixelV; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetPolyFillMode')]
function SetPolyFillMode; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetROP2')]
function SetROP2; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetRectRgn')]
function SetRectRgn; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetStretchBltMode')]
function SetStretchBltMode; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetSystemPaletteUse')]
function SetSystemPaletteUse; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetTextAlign')]
function SetTextAlign; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetTextColor')]
function SetTextColor; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetTextCharacterExtra')]
function SetTextCharacterExtra; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetTextJustification')]
function SetTextJustification; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetViewportExtEx')]
function SetViewportExtEx(DC: HDC; XExt, YExt: Integer; out Size: TSize): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetViewportExtEx')]
function SetViewportExtEx(DC: HDC; XExt, YExt: Integer; Size: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetViewportOrgEx')]
function SetViewportOrgEx(DC: HDC; X, Y: Integer; out Point: TPoint): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetViewportOrgEx')]
function SetViewportOrgEx(DC: HDC; X, Y: Integer; Point: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetWinMetaFileBits')]
function SetWinMetaFileBits(p1: UINT; [in] p2: TBytes; p3: HDC;
  const p4: TMetaFilePict): HENHMETAFILE; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetWinMetaFileBits')]
function SetWinMetaFileBits(p1: UINT; [in] p2: TBytes; p3: HDC;
  p4: IntPtr): HENHMETAFILE; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetWindowExtEx')]
function SetWindowExtEx(DC: HDC; XExt, YExt: Integer; out Size: TSize): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetWindowExtEx')]
function SetWindowExtEx(DC: HDC; XExt, YExt: Integer; Size: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetWindowOrgEx')]
function SetWindowOrgEx(DC: HDC; X, Y: Integer; out Point: TPoint): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetWindowOrgEx')]
function SetWindowOrgEx(DC: HDC; X, Y: Integer; Point: IntPtr): BOOL; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetWorldTransform')]
function SetWorldTransform; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'StartDoc')]
function StartDoc; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'StartDocA')]
function StartDocA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'StartDocW')]
function StartDocW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'StartPage')]
function StartPage; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'StretchBlt')]
function StretchBlt; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'StretchDIBits')]
function StretchDIBits; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'StrokeAndFillPath')]
function StrokeAndFillPath; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'StrokePath')]
function StrokePath; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SwapBuffers')]
function SwapBuffers; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'TextOut')]
function TextOut; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TextOutA')]
function TextOutA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'TextOutW')]
function TextOutW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TranslateCharsetInfo')]
function TranslateCharsetInfo; external;
[DllImport(msimg32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TransparentBlt')]
function TransparentBlt; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'TransparentDIBits')]
function TransparentDIBits; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'UnrealizeObject')]
function UnrealizeObject; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'UpdateColors')]
function UpdateColors; external;
[DllImport(gdi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'UpdateICMRegKey')]
function UpdateICMRegKey; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'UpdateICMRegKeyA')]
function UpdateICMRegKeyA; external;
[DllImport(gdi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'UpdateICMRegKeyW')]
function UpdateICMRegKeyW; external;
[DllImport(gdi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WidenPath')]
function WidenPath; external;

{ Externals from opengl32.dll }

[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglCopyContext')]
function wglCopyContext; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglCreateContext')]
function wglCreateContext; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglCreateLayerContext')]
function wglCreateLayerContext; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglDeleteContext')]
function wglDeleteContext; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglDescribeLayerPlane')]
function wglDescribeLayerPlane; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglGetCurrentContext')]
function wglGetCurrentContext; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglGetCurrentDC')]
function wglGetCurrentDC; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglGetLayerPaletteEntries')]
function wglGetLayerPaletteEntries; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglMakeCurrent')]
function wglMakeCurrent; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglRealizeLayerPalette')]
function wglRealizeLayerPalette; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglSetLayerPaletteEntries')]
function wglSetLayerPaletteEntries; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglShareLists')]
function wglShareLists; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglSwapLayerBuffers')]
function wglSwapLayerBuffers; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglSwapMultipleBuffers')]
function wglSwapMultipleBuffers; external;
[DllImport(opengl32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'wglUseFontBitmaps')]
function wglUseFontBitmaps; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglUseFontBitmapsA')]
function wglUseFontBitmapsA; external;
[DllImport(opengl32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'wglUseFontBitmapsW')]
function wglUseFontBitmapsW; external;
[DllImport(opengl32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'wglUseFontOutlines')]
function wglUseFontOutlines(p1: HDC; p2, p3, p4: DWORD; p5, p6: Single;
  p7: Integer; var p8: TGlyphMetricsFloat): BOOL; external;
[DllImport(opengl32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'wglUseFontOutlines')]
function wglUseFontOutlines(p1: HDC; p2, p3, p4: DWORD; p5, p6: Single;
  p7: Integer; p8: IntPtr): BOOL; external;
[DllImport(opengl32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'wglUseFontOutlinesA')]
function wglUseFontOutlinesA; external;
[DllImport(opengl32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'wglUseFontOutlinesW')]
function wglUseFontOutlinesW; external;


{ Externals from user32.dll }

[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ActivateKeyboardLayout')]
function ActivateKeyboardLayout; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AdjustWindowRect')]
function AdjustWindowRect; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AdjustWindowRectEx')]
function AdjustWindowRectEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharToOemA')]
function AnsiToOem; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharToOemBuffA')]
function AnsiToOemBuff; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharUpperA')]
function AnsiUpper; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharUpperBuffA')]
function AnsiUpperBuff; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharLowerA')]
function AnsiLower; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharLowerBuffA')]
function AnsiLowerBuff; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharNextA')]
function AnsiNext; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharPrevA')]
function AnsiPrev; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AnyPopup')]
function AnyPopup; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AppendMenu')]
function AppendMenu; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AppendMenuA')]
function AppendMenuA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AppendMenuW')]
function AppendMenuW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ArrangeIconicWindows')]
function ArrangeIconicWindows; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AttachThreadInput')]
function AttachThreadInput; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BeginDeferWindowPos')]
function BeginDeferWindowPos; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BeginPaint')]
function BeginPaint; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BringWindowToTop')]
function BringWindowToTop; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'BroadcastSystemMessage')]
function BroadcastSystemMessage(Flags: DWORD; [in] var Recipients: DWORD; uiMessage: UINT;
  wParam: WPARAM; lParam: LPARAM): Longint; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'BroadcastSystemMessage')]
function BroadcastSystemMessage(Flags: DWORD; Recipients: IntPtr; uiMessage: UINT;
  wParam: WPARAM; lParam: LPARAM): Longint; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'BroadcastSystemMessageA')]
function BroadcastSystemMessageA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'BroadcastSystemMessageW')]
function BroadcastSystemMessageW; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CallMsgFilter')]
function CallMsgFilter; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CallMsgFilterA')]
function CallMsgFilterA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CallMsgFilterW')]
function CallMsgFilterW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CallNextHookEx')]
function CallNextHookEx(hhk: HHOOK; nCode: Integer; wParam: WPARAM;
  lParam: LPARAM): LRESULT; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CallNextHookEx')]
function CallNextHookEx(hhk: HHOOK; nCode: Integer; wParam: WPARAM;
  lParam: INtPtr): LRESULT; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CallWindowProc')]
function CallWindowProc(lpPrevWndFunc: TFNWndProc; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CallWindowProcA')]
function CallWindowProcA(lpPrevWndFunc: TFNWndProc; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CallWindowProcW')]
function CallWindowProcW(lpPrevWndFunc: TFNWndProc; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CallWindowProc')]
function CallWindowProc(lpPrevWndFunc: IntPtr; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CallWindowProcA')]
function CallWindowProcA(lpPrevWndFunc: IntPtr; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CallWindowProcW')]
function CallWindowProcW(lpPrevWndFunc: IntPtr; hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; external;

[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CascadeWindows')]
function CascadeWindows(hwndParent: HWND; wHow: UINT; const lpRect: TRect;
  cKids: UINT; [in] lpKids: array of HWND): Word; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CascadeWindows')]
function CascadeWindows(hwndParent: HWND; wHow: UINT; lpRect: IntPtr;
  cKids: UINT; lpKids: IntPtr): Word; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CascadeWindows')]
function CascadeWindows(hwndParent: HWND; wHow: UINT; lpRect: IntPtr;
  cKids: UINT; [in] lpKids: array of HWND): Word; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CascadeWindows')]
function CascadeWindows(hwndParent: HWND; wHow: UINT; const lpRect: TRect;
  cKids: UINT; lpKids: IntPtr): Word; external;

[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ChangeClipboardChain')]
function ChangeClipboardChain; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ChangeDisplaySettings')]
function ChangeDisplaySettings(const lpDevMode: TDeviceMode; dwFlags: DWORD): Longint; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ChangeDisplaySettings')]
function ChangeDisplaySettings(lpDevMode: IntPtr; dwFlags: DWORD): Longint; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ChangeDisplaySettingsA')]
function ChangeDisplaySettingsA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ChangeDisplaySettingsW')]
function ChangeDisplaySettingsW; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ChangeDisplaySettingsEx')]
function ChangeDisplaySettingsEx(lpszDeviceName: string; const lpDevMode: TDeviceMode;
        wnd: HWND; dwFlags: DWORD; lParam: IntPtr): Longint; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ChangeDisplaySettingsEx')]
function ChangeDisplaySettingsEx(lpszDeviceName: IntPtr; const lpDevMode: TDeviceMode;
        wnd: HWND; dwFlags: DWORD; lParam: IntPtr): Longint; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ChangeDisplaySettingsEx')]
function ChangeDisplaySettingsEx(lpszDeviceName, lpDevMode: IntPtr;
        wnd: HWND; dwFlags: DWORD; lParam: IntPtr): Longint; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ChangeDisplaySettingsEx')]
function ChangeDisplaySettingsEx(lpszDeviceName: string; lpDevMode: IntPtr;
        wnd: HWND; dwFlags: DWORD; lParam: IntPtr): Longint; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ChangeDisplaySettingsExA')]
function ChangeDisplaySettingsExA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ChangeDisplaySettingsExW')]
function ChangeDisplaySettingsExW; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ChangeMenu')]
function ChangeMenu; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ChangeMenuA')]
function ChangeMenuA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ChangeMenuW')]
function ChangeMenuW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CharLower')]
function CharLower; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharLowerA')]
function CharLowerA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CharLowerW')]
function CharLowerW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CharLowerBuff')]
function CharLowerBuff; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharLowerBuffA')]
function CharLowerBuffA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CharLowerBuffW')]
function CharLowerBuffW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CharNext')]
function CharNext; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharNextA')]
function CharNextA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CharNextW')]
function CharNextW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharNextExA')]
function CharNextEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharNextExA')]
function CharNextExA; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CharPrev')]
function CharPrev; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharPrevA')]
function CharPrevA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CharPrevW')]
function CharPrevW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharPrevExA')]
function CharPrevEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharPrevExA')]
function CharPrevExA; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CharToOem')]
function CharToOem; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharToOemA')]
function CharToOemA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CharToOemW')]
function CharToOemW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CharToOemBuff')]
function CharToOemBuff; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharToOemBuffA')]
function CharToOemBuffA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CharToOemBuffW')]
function CharToOemBuffW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CharUpper')]
function CharUpper; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharUpperA')]
function CharUpperA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CharUpperW')]
function CharUpperW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CharUpperBuff')]
function CharUpperBuff; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharUpperBuffA')]
function CharUpperBuffA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CharUpperBuffW')]
function CharUpperBuffW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CheckDlgButton')]
function CheckDlgButton; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CheckMenuItem')]
function CheckMenuItem; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CheckMenuRadioItem')]
function CheckMenuRadioItem; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CheckRadioButton')]
function CheckRadioButton; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ChildWindowFromPoint')]
function ChildWindowFromPoint; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ChildWindowFromPointEx')]
function ChildWindowFromPointEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ClientToScreen')]
function ClientToScreen; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ClipCursor')]
function ClipCursor(const lpRect: TRect): BOOL; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ClipCursor')]
function ClipCursor(lpRect: IntPtr): BOOL; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CloseClipboard')]
function CloseClipboard; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CloseDesktop')]
function CloseDesktop; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CloseWindow')]
function CloseWindow; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CloseWindowStation')]
function CloseWindowStation; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CopyAcceleratorTable')]
function CopyAcceleratorTable; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CopyAcceleratorTableA')]
function CopyAcceleratorTableA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CopyAcceleratorTableW')]
function CopyAcceleratorTableW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CopyIcon')]
function CopyIcon; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CopyImage')]
function CopyImage; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CopyRect')]
function CopyRect; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CountClipboardFormats')]
function CountClipboardFormats; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateAcceleratorTable')]
function CreateAcceleratorTable; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateAcceleratorTableA')]
function CreateAcceleratorTableA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateAcceleratorTableW')]
function CreateAcceleratorTableW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateCaret')]
function CreateCaret; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateCursor')]
function CreateCursor; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDesktop')]
function CreateDesktop(lpszDesktop: string; lpszDevice,
  pDevmode: IntPtr; dwFlags: DWORD; dwDesiredAccess: DWORD;
  const lpsa: TSecurityAttributes): HDESK; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDesktop')]
function CreateDesktop(lpszDesktop: string; lpszDevice,
  pDevmode: IntPtr; dwFlags: DWORD; dwDesiredAccess: DWORD;
  lpsa: IntPtr): HDESK; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateDesktopA')]
function CreateDesktopA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateDesktopW')]
function CreateDesktopW; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDialogIndirectParam')]
function CreateDialogIndirectParam; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateDialogIndirectParamA')]
function CreateDialogIndirectParamA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateDialogIndirectParamW')]
function CreateDialogIndirectParamW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateDialogParam')]
function CreateDialogParam; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateDialogParamA')]
function CreateDialogParamA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateDialogParamW')]
function CreateDialogParamW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateIcon')]
function CreateIcon; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateIconFromResource')]
function CreateIconFromResource; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateIconFromResourceEx')]
function CreateIconFromResourceEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateIconIndirect')]
function CreateIconIndirect; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateMDIWindow')]
function CreateMDIWindow; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateMDIWindowA')]
function CreateMDIWindowA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateMDIWindowW')]
function CreateMDIWindowW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateMenu')]
function CreateMenu; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreatePopupMenu')]
function CreatePopupMenu; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateWindowEx')]
function CreateWindowEx(dwExStyle: DWORD; lpClassName: string;
  lpWindowName: string; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; const lpParam: TCreateStruct): HWND; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateWindowEx')]
function CreateWindowEx(dwExStyle: DWORD; lpClassName: string;
  lpWindowName: string; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; const lpParam: TClientCreateStruct): HWND; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateWindowEx')]
function CreateWindowEx(dwExStyle: DWORD; lpClassName: string;
  lpWindowName: string; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; lpParam: IntPtr): HWND; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateWindowEx')]
function CreateWindowEx(dwExStyle: DWORD; lpClassName: string;
  lpWindowName: IntPtr; dwStyle: DWORD; X, Y, nWidth, nHeight: Integer;
  hWndParent: HWND; hMenu: HMENU; hInstance: HINST; lpParam: IntPtr): HWND; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateWindowExA')]
function CreateWindowExA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateWindowExW')]
function CreateWindowExW; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateWindowStation')]
function CreateWindowStation(lpwinsta: string; dwReserved, dwDesiredAccess: DWORD;
  const lpsa: TSecurityAttributes): HWINSTA; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateWindowStation')]
function CreateWindowStation(lpwinsta: string; dwReserved, dwDesiredAccess: DWORD;
  lpsa: IntPtr): HWINSTA; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateWindowStationA')]
function CreateWindowStationA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateWindowStationW')]
function CreateWindowStationW; external;

[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DdeSetQualityOfService')]
function DdeSetQualityOfService(hWndClient: HWnd; const pqosNew: TSecurityQualityOfService;
  out pqosPrev: TSecurityQualityOfService): BOOL; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DdeSetQualityOfService')]
function DdeSetQualityOfService(hWndClient: HWnd; const pqosNew: TSecurityQualityOfService;
  pqosPrev: IntPtr): BOOL; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DefDlgProc')]
function DefDlgProc; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DefDlgProcA')]
function DefDlgProcA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DefDlgProcW')]
function DefDlgProcW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DefFrameProc')]
function DefFrameProc; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DefFrameProcA')]
function DefFrameProcA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DefFrameProcW')]
function DefFrameProcW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DefMDIChildProc')]
function DefMDIChildProc; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DefMDIChildProcA')]
function DefMDIChildProcA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DefMDIChildProcW')]
function DefMDIChildProcW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DefWindowProc')]
function DefWindowProc; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DefWindowProcA')]
function DefWindowProcA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DefWindowProcW')]
function DefWindowProcW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeferWindowPos')]
function DeferWindowPos; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteMenu')]
function DeleteMenu; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DestroyAcceleratorTable')]
function DestroyAcceleratorTable; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DestroyCaret')]
function DestroyCaret; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DestroyCursor')]
function DestroyCursor; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DestroyIcon')]
function DestroyIcon; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DestroyMenu')]
function DestroyMenu; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DestroyWindow')]
function DestroyWindow; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DialogBoxIndirectParam')]
function DialogBoxIndirectParam; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DialogBoxIndirectParamA')]
function DialogBoxIndirectParamA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DialogBoxIndirectParamW')]
function DialogBoxIndirectParamW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DialogBoxParam')]
function DialogBoxParam; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DialogBoxParamA')]
function DialogBoxParamA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DialogBoxParamW')]
function DialogBoxParamW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DispatchMessage')]
function DispatchMessage; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DispatchMessageA')]
function DispatchMessageA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DispatchMessageW')]
function DispatchMessageW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DlgDirList')]
function DlgDirList; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DlgDirListA')]
function DlgDirListA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DlgDirListW')]
function DlgDirListW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DlgDirListComboBox')]
function DlgDirListComboBox; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DlgDirListComboBoxA')]
function DlgDirListComboBoxA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DlgDirListComboBoxW')]
function DlgDirListComboBoxW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DlgDirSelectComboBoxEx')]
function DlgDirSelectComboBoxEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DlgDirSelectComboBoxExA')]
function DlgDirSelectComboBoxExA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DlgDirSelectComboBoxExW')]
function DlgDirSelectComboBoxExW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DlgDirSelectEx')]
function DlgDirSelectEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DlgDirSelectExA')]
function DlgDirSelectExA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DlgDirSelectExW')]
function DlgDirSelectExW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DragDetect')]
function DragDetect; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DragObject')]
function DragObject; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawAnimatedRects')]
function DrawAnimatedRects; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawCaption')]
function DrawCaption; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawEdge')]
function DrawEdge; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawFocusRect')]
function DrawFocusRect; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawFrameControl')]
function DrawFrameControl; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawIcon')]
function DrawIcon; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawIconEx')]
function DrawIconEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawMenuBar')]
function DrawMenuBar; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DrawState')]
function DrawState; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawStateA')]
function DrawStateA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DrawStateW')]
function DrawStateW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DrawText')]
function DrawText; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawTextA')]
function DrawTextA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DrawTextW')]
function DrawTextW; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DrawTextEx')]
function DrawTextEx(DC: HDC; lpchText: string; cchText: Integer; var p4: TRect;
  dwDTFormat: UINT; const DTParams: TDrawTextParams): Integer; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DrawTextEx')]
function DrawTextEx(DC: HDC; lpchText: string; cchText: Integer; var p4: TRect;
  dwDTFormat: UINT; DTParams: IntPtr): Integer; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DrawTextEx')]
function DrawTextEx(DC: HDC; lpchText: StringBuilder; cchText: Integer; var p4: TRect;
  dwDTFormat: UINT; const DTParams: IntPtr): Integer; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrawTextExA')]
function DrawTextExA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DrawTextExW')]
function DrawTextExW; external;

[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EmptyClipboard')]
function EmptyClipboard; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnableMenuItem')]
function EnableMenuItem; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnableScrollBar')]
function EnableScrollBar; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnableWindow')]
function EnableWindow; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EndDeferWindowPos')]
function EndDeferWindowPos; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EndDialog')]
function EndDialog; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EndMenu')]
function EndMenu; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EndPaint')]
function EndPaint; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumChildWindows')]
function EnumChildWindows; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumClipboardFormats')]
function EnumClipboardFormats; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumDesktops')]
function EnumDesktops; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumDesktopsA')]
function EnumDesktopsA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumDesktopsW')]
function EnumDesktopsW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumDesktopWindows')]
function EnumDesktopWindows; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumDisplaySettings')]
function EnumDisplaySettings(lpszDeviceName: string; iModeNum: DWORD;
  out lpDevMode: TDeviceMode): BOOL; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumDisplaySettings')]
function EnumDisplaySettings(lpszDeviceName: IntPtr; iModeNum: DWORD;
  out lpDevMode: TDeviceMode): BOOL; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumDisplaySettingsA')]
function EnumDisplaySettingsA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumDisplaySettingsW')]
function EnumDisplaySettingsW; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumDisplayDevices')]
function EnumDisplayDevices(lpDevice: string; iDevNum: DWORD;
  out lpDisplayDevice: TDisplayDevice; dwFlags: DWORD): BOOL; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumDisplayDevices')]
function EnumDisplayDevices(lpDevice: IntPtr; iDevNum: DWORD;
  out lpDisplayDevice: TDisplayDevice; dwFlags: DWORD): BOOL; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumDisplayDevicesA')]
function EnumDisplayDevicesA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumDisplayDevicesW')]
function EnumDisplayDevicesW; external;

[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumProps')]
function EnumProps; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumPropsA')]
function EnumPropsA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumPropsW')]
function EnumPropsW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPropsEx')]
function EnumPropsEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumPropsExA')]
function EnumPropsExA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumPropsExW')]
function EnumPropsExW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumThreadWindows')]
function EnumThreadWindows; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumWindowStations')]
function EnumWindowStations; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumWindowStationsA')]
function EnumWindowStationsA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumWindowStationsW')]
function EnumWindowStationsW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumWindows')]
function EnumWindows; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EqualRect')]
function EqualRect; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExcludeUpdateRgn')]
function ExcludeUpdateRgn; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExitWindowsEx')]
function ExitWindowsEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FillRect')]
function FillRect; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindWindow')]
function FindWindow; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindWindowA')]
function FindWindowA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindWindowW')]
function FindWindowW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindWindowEx')]
function FindWindowEx(Parent, Child: HWND; ClassName, WindowName: string): HWND; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindWindowEx')]
function FindWindowEx(Parent, Child: HWND; ClassName: string; WindowName: IntPtr): HWND; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindWindowExA')]
function FindWindowExA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindWindowExW')]
function FindWindowExW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlashWindow')]
function FlashWindow; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlashWindowEx')]
function FlashWindowEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FrameRect')]
function FrameRect; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FreeDDElParam')]
function FreeDDElParam; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetActiveWindow')]
function GetActiveWindow; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetAltTabInfo')]
function GetAltTabInfo; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetAltTabInfoA')]
function GetAltTabInfoA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetAltTabInfoW')]
function GetAltTabInfoW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetAncestor')]
function GetAncestor; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetAsyncKeyState')]
function GetAsyncKeyState; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCapture')]
function GetCapture; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCaretBlinkTime')]
function GetCaretBlinkTime; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCaretPos')]
function GetCaretPos; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetClassInfo')]
function GetClassInfo; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClassInfoA')]
function GetClassInfoA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetClassInfoW')]
function GetClassInfoW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetClassInfoEx')]
function GetClassInfoEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClassInfoExA')]
function GetClassInfoExA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetClassInfoExW')]
function GetClassInfoExW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetClassLong')]
function GetClassLong; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClassLongA')]
function GetClassLongA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetClassLongW')]
function GetClassLongW; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetClassName')]
function GetClassName; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClassNameA')]
function GetClassNameA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetClassNameW')]
function GetClassNameW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClassWord')]
function GetClassWord; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClientRect')]
function GetClientRect; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClipCursor')]
function GetClipCursor; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClipboardData')]
function GetClipboardData; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetClipboardFormatName')]
function GetClipboardFormatName; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClipboardFormatNameA')]
function GetClipboardFormatNameA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetClipboardFormatNameW')]
function GetClipboardFormatNameW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClipboardSequenceNumber')]
function GetClipboardSequenceNumber; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClipboardOwner')]
function GetClipboardOwner; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetClipboardViewer')]
function GetClipboardViewer; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetComboBoxInfo')]
function GetComboBoxInfo; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCursor')]
function GetCursor; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCursorInfo')]
function GetCursorInfo; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetCursorPos')]
function GetCursorPos; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDC')]
function GetDC; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDCEx')]
function GetDCEx; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDesktopWindow')]
function GetDesktopWindow; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDialogBaseUnits')]
function GetDialogBaseUnits; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDlgCtrlID')]
function GetDlgCtrlID; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDlgItem')]
function GetDlgItem; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDlgItemInt')]
function GetDlgItemInt; external;
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetDlgItemText')]
function GetDlgItemText; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDlgItemTextA')]
function GetDlgItemTextA; external;
[DllImport(user32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetDlgItemTextW')]
function GetDlgItemTextW; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDoubleClickTime')]
function GetDoubleClickTime; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFocus')]
function GetFocus; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetForegroundWindow')]
function GetForegroundWindow; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetGuiResources')]
function GetGuiResources; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetGUIThreadInfo')]
function 